// third_party/blink/public/mojom/preloading/anchor_element_interaction_host.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AnchorElementInteractionHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.AnchorElementInteractionHost', scope);
  }
}

/** @interface */
export class AnchorElementInteractionHostInterface {
  
  /**
   * @param { !url_mojom_Url } target
   */

  onPointerDown(target) {}
  
  /**
   * @param { !url_mojom_Url } target
   * @param { !AnchorElementPointerData } mouseData
   */

  onPointerHoverEager(target, mouseData) {}
  
  /**
   * @param { !url_mojom_Url } target
   * @param { !AnchorElementPointerData } mouseData
   */

  onPointerHoverModerate(target, mouseData) {}
  
  /**
   * @param { !url_mojom_Url } target
   */

  onViewportHeuristicTriggered(target) {}
}

/**
 * @implements { AnchorElementInteractionHostInterface }
 */
export class AnchorElementInteractionHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AnchorElementInteractionHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AnchorElementInteractionHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AnchorElementInteractionHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !url_mojom_Url } target
   */

  onPointerDown(
      target) {
    this.proxy.sendMessage(
        0,
        AnchorElementInteractionHost_OnPointerDown_ParamsSpec.$,
        null,
        [
          target
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } target
   * @param { !AnchorElementPointerData } mouseData
   */

  onPointerHoverEager(
      target,
      mouseData) {
    this.proxy.sendMessage(
        1,
        AnchorElementInteractionHost_OnPointerHoverEager_ParamsSpec.$,
        null,
        [
          target,
          mouseData
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } target
   * @param { !AnchorElementPointerData } mouseData
   */

  onPointerHoverModerate(
      target,
      mouseData) {
    this.proxy.sendMessage(
        2,
        AnchorElementInteractionHost_OnPointerHoverModerate_ParamsSpec.$,
        null,
        [
          target,
          mouseData
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } target
   */

  onViewportHeuristicTriggered(
      target) {
    this.proxy.sendMessage(
        3,
        AnchorElementInteractionHost_OnViewportHeuristicTriggered_ParamsSpec.$,
        null,
        [
          target
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AnchorElementInteractionHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AnchorElementInteractionHostReceiver {
  /**
   * @param {!AnchorElementInteractionHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AnchorElementInteractionHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AnchorElementInteractionHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AnchorElementInteractionHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AnchorElementInteractionHost_OnPointerDown_ParamsSpec.$,
        null,
        impl.onPointerDown.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        AnchorElementInteractionHost_OnPointerHoverEager_ParamsSpec.$,
        null,
        impl.onPointerHoverEager.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        AnchorElementInteractionHost_OnPointerHoverModerate_ParamsSpec.$,
        null,
        impl.onPointerHoverModerate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        AnchorElementInteractionHost_OnViewportHeuristicTriggered_ParamsSpec.$,
        null,
        impl.onViewportHeuristicTriggered.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AnchorElementInteractionHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AnchorElementInteractionHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AnchorElementInteractionHostRemote}
   */
  static getRemote() {
    let remote = new AnchorElementInteractionHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AnchorElementInteractionHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AnchorElementInteractionHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AnchorElementInteractionHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AnchorElementInteractionHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPointerDown =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AnchorElementInteractionHost_OnPointerDown_ParamsSpec.$,
        null,
        this.onPointerDown.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPointerHoverEager =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        AnchorElementInteractionHost_OnPointerHoverEager_ParamsSpec.$,
        null,
        this.onPointerHoverEager.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPointerHoverModerate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        AnchorElementInteractionHost_OnPointerHoverModerate_ParamsSpec.$,
        null,
        this.onPointerHoverModerate.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onViewportHeuristicTriggered =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        AnchorElementInteractionHost_OnViewportHeuristicTriggered_ParamsSpec.$,
        null,
        this.onViewportHeuristicTriggered.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AnchorElementPointerDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AnchorElementInteractionHost_OnPointerDown_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AnchorElementInteractionHost_OnPointerHoverEager_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AnchorElementInteractionHost_OnPointerHoverModerate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AnchorElementInteractionHost_OnViewportHeuristicTriggered_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    AnchorElementPointerDataSpec.$,
    'AnchorElementPointerData',
    [
      mojo.internal.StructField(
        'isMousePointer', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mouseVelocity', 8,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mouseAcceleration', 16,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class AnchorElementPointerData {
  constructor() {
    /** @type { !boolean } */
    this.isMousePointer;
    /** @type { !number } */
    this.mouseVelocity;
    /** @type { !number } */
    this.mouseAcceleration;
  }
}



mojo.internal.Struct(
    AnchorElementInteractionHost_OnPointerDown_ParamsSpec.$,
    'AnchorElementInteractionHost_OnPointerDown_Params',
    [
      mojo.internal.StructField(
        'target', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AnchorElementInteractionHost_OnPointerDown_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.target;
  }
}



mojo.internal.Struct(
    AnchorElementInteractionHost_OnPointerHoverEager_ParamsSpec.$,
    'AnchorElementInteractionHost_OnPointerHoverEager_Params',
    [
      mojo.internal.StructField(
        'target', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mouseData', 8,
        0,
        AnchorElementPointerDataSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AnchorElementInteractionHost_OnPointerHoverEager_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.target;
    /** @type { !AnchorElementPointerData } */
    this.mouseData;
  }
}



mojo.internal.Struct(
    AnchorElementInteractionHost_OnPointerHoverModerate_ParamsSpec.$,
    'AnchorElementInteractionHost_OnPointerHoverModerate_Params',
    [
      mojo.internal.StructField(
        'target', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mouseData', 8,
        0,
        AnchorElementPointerDataSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AnchorElementInteractionHost_OnPointerHoverModerate_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.target;
    /** @type { !AnchorElementPointerData } */
    this.mouseData;
  }
}



mojo.internal.Struct(
    AnchorElementInteractionHost_OnViewportHeuristicTriggered_ParamsSpec.$,
    'AnchorElementInteractionHost_OnViewportHeuristicTriggered_Params',
    [
      mojo.internal.StructField(
        'target', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AnchorElementInteractionHost_OnViewportHeuristicTriggered_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.target;
  }
}

