// third_party/blink/public/mojom/picture_in_picture/picture_in_picture.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/picture_in_picture/picture_in_picture.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/picture_in_picture/picture_in_picture.mojom-params-data.h"
#include "third_party/blink/public/mojom/picture_in_picture/picture_in_picture.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/picture_in_picture/picture_in_picture.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/picture_in_picture/picture_in_picture.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
// The declaration includes the definition on other builds.

PictureInPictureSessionObserver::IPCStableHashFunction PictureInPictureSessionObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PictureInPictureSessionObserver>(message.name())) {
    case messages::PictureInPictureSessionObserver::kOnWindowSizeChanged: {
      return &PictureInPictureSessionObserver::OnWindowSizeChanged_Sym::IPCStableHash;
    }
    case messages::PictureInPictureSessionObserver::kOnStopped: {
      return &PictureInPictureSessionObserver::OnStopped_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PictureInPictureSessionObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PictureInPictureSessionObserver>(message.name())) {
      case messages::PictureInPictureSessionObserver::kOnWindowSizeChanged:
            return "Receive blink::mojom::PictureInPictureSessionObserver::OnWindowSizeChanged";
      case messages::PictureInPictureSessionObserver::kOnStopped:
            return "Receive blink::mojom::PictureInPictureSessionObserver::OnStopped";
    }
  } else {
    switch (static_cast<messages::PictureInPictureSessionObserver>(message.name())) {
      case messages::PictureInPictureSessionObserver::kOnWindowSizeChanged:
            return "Receive reply blink::mojom::PictureInPictureSessionObserver::OnWindowSizeChanged";
      case messages::PictureInPictureSessionObserver::kOnStopped:
            return "Receive reply blink::mojom::PictureInPictureSessionObserver::OnStopped";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PictureInPictureSessionObserver::OnWindowSizeChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x19b8799c;  // IPCStableHash for blink::mojom::PictureInPictureSessionObserver::OnWindowSizeChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PictureInPictureSessionObserver::OnStopped_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe840fcb1;  // IPCStableHash for blink::mojom::PictureInPictureSessionObserver::OnStopped
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PictureInPictureSessionObserverProxy::PictureInPictureSessionObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PictureInPictureSessionObserverProxy::OnWindowSizeChanged(
    const ::gfx::Size& in_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PictureInPictureSessionObserver::OnWindowSizeChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size"), in_size,
                        "<value of type const ::gfx::Size&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PictureInPictureSessionObserver::kOnWindowSizeChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PictureInPictureSessionObserver_OnWindowSizeChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->size)::BaseType> size_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_size,
    size_fragment);

  params->size.Set(
      size_fragment.is_null() ? nullptr : size_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->size.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null size in PictureInPictureSessionObserver.OnWindowSizeChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PictureInPictureSessionObserver::Name_);
  message.set_method_name("OnWindowSizeChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PictureInPictureSessionObserverProxy::OnStopped(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::PictureInPictureSessionObserver::OnStopped");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PictureInPictureSessionObserver::kOnStopped), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PictureInPictureSessionObserver_OnStopped_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PictureInPictureSessionObserver::Name_);
  message.set_method_name("OnStopped");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PictureInPictureSessionObserverStubDispatch::Accept(
    PictureInPictureSessionObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PictureInPictureSessionObserver>(message->header()->name)) {
    case messages::PictureInPictureSessionObserver::kOnWindowSizeChanged: {
      DCHECK(message->is_serialized());
      internal::PictureInPictureSessionObserver_OnWindowSizeChanged_Params_Data* params =
          reinterpret_cast<internal::PictureInPictureSessionObserver_OnWindowSizeChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PictureInPictureSessionObserver.0
      bool success = true;
      ::gfx::Size p_size{};
      PictureInPictureSessionObserver_OnWindowSizeChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSize(&p_size))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PictureInPictureSessionObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnWindowSizeChanged(        
        std::move(p_size));
      return true;
    }
    case messages::PictureInPictureSessionObserver::kOnStopped: {
      DCHECK(message->is_serialized());
      internal::PictureInPictureSessionObserver_OnStopped_Params_Data* params =
          reinterpret_cast<internal::PictureInPictureSessionObserver_OnStopped_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PictureInPictureSessionObserver.1
      bool success = true;
      PictureInPictureSessionObserver_OnStopped_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PictureInPictureSessionObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStopped(        );
      return true;
    }
  }
  return false;
}

// static
bool PictureInPictureSessionObserverStubDispatch::AcceptWithResponder(
    PictureInPictureSessionObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PictureInPictureSessionObserver>(message->header()->name)) {
    case messages::PictureInPictureSessionObserver::kOnWindowSizeChanged: {
      break;
    }
    case messages::PictureInPictureSessionObserver::kOnStopped: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPictureInPictureSessionObserverValidationInfo[] = {
    { &internal::PictureInPictureSessionObserver_OnWindowSizeChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PictureInPictureSessionObserver_OnStopped_Params_Data::Validate,
     nullptr /* no response */},
};

bool PictureInPictureSessionObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::PictureInPictureSessionObserver::Name_,
    kPictureInPictureSessionObserverValidationInfo);
}

// The declaration includes the definition on other builds.

PictureInPictureSession::IPCStableHashFunction PictureInPictureSession::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PictureInPictureSession>(message.name())) {
    case messages::PictureInPictureSession::kUpdate: {
      return &PictureInPictureSession::Update_Sym::IPCStableHash;
    }
    case messages::PictureInPictureSession::kStop: {
      return &PictureInPictureSession::Stop_Sym::IPCStableHash;
    }
    case messages::PictureInPictureSession::kUpdateMediaPosition: {
      return &PictureInPictureSession::UpdateMediaPosition_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PictureInPictureSession::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PictureInPictureSession>(message.name())) {
      case messages::PictureInPictureSession::kUpdate:
            return "Receive blink::mojom::PictureInPictureSession::Update";
      case messages::PictureInPictureSession::kStop:
            return "Receive blink::mojom::PictureInPictureSession::Stop";
      case messages::PictureInPictureSession::kUpdateMediaPosition:
            return "Receive blink::mojom::PictureInPictureSession::UpdateMediaPosition";
    }
  } else {
    switch (static_cast<messages::PictureInPictureSession>(message.name())) {
      case messages::PictureInPictureSession::kUpdate:
            return "Receive reply blink::mojom::PictureInPictureSession::Update";
      case messages::PictureInPictureSession::kStop:
            return "Receive reply blink::mojom::PictureInPictureSession::Stop";
      case messages::PictureInPictureSession::kUpdateMediaPosition:
            return "Receive reply blink::mojom::PictureInPictureSession::UpdateMediaPosition";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PictureInPictureSession::Update_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3ec8e979;  // IPCStableHash for blink::mojom::PictureInPictureSession::Update
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PictureInPictureSession::Stop_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf7ee6721;  // IPCStableHash for blink::mojom::PictureInPictureSession::Stop
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PictureInPictureSession::UpdateMediaPosition_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x505a3d67;  // IPCStableHash for blink::mojom::PictureInPictureSession::UpdateMediaPosition
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PictureInPictureSession_Stop_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PictureInPictureSession_Stop_ForwardToCallback(
      PictureInPictureSession::StopCallback callback
      ) : callback_(std::move(callback)) {
  }

  PictureInPictureSession_Stop_ForwardToCallback(const PictureInPictureSession_Stop_ForwardToCallback&) = delete;
  PictureInPictureSession_Stop_ForwardToCallback& operator=(const PictureInPictureSession_Stop_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PictureInPictureSession::StopCallback callback_;
};

PictureInPictureSessionProxy::PictureInPictureSessionProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PictureInPictureSessionProxy::Update(
    uint32_t in_player_id, ::mojo::PendingAssociatedRemote<::media::mojom::blink::MediaPlayer> in_player_remote, const ::viz::SurfaceId& in_surface_id, const ::gfx::Size& in_natural_size, bool in_show_play_pause_button) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PictureInPictureSession::Update", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("player_id"), in_player_id,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("player_remote"), in_player_remote,
                        "<value of type ::mojo::PendingAssociatedRemote<::media::mojom::blink::MediaPlayer>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("surface_id"), in_surface_id,
                        "<value of type const ::viz::SurfaceId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("natural_size"), in_natural_size,
                        "<value of type const ::gfx::Size&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("show_play_pause_button"), in_show_play_pause_button,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PictureInPictureSession::kUpdate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PictureInPictureSession_Update_Params_Data> params(
          message);
  params.Allocate();

  params->player_id = in_player_id;

  
  mojo::internal::Serialize<::media::mojom::MediaPlayerAssociatedPtrInfoDataView>(
    in_player_remote,
    &params->player_remote,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->player_remote)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid player_remote in PictureInPictureSession.Update request");
  mojo::internal::MessageFragment<
      typename decltype(params->surface_id)::BaseType> surface_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::SurfaceIdDataView>(
    in_surface_id,
    surface_id_fragment);

  params->surface_id.Set(
      surface_id_fragment.is_null() ? nullptr : surface_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->surface_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null surface_id in PictureInPictureSession.Update request");
  mojo::internal::MessageFragment<
      typename decltype(params->natural_size)::BaseType> natural_size_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_natural_size,
    natural_size_fragment);

  params->natural_size.Set(
      natural_size_fragment.is_null() ? nullptr : natural_size_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->natural_size.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null natural_size in PictureInPictureSession.Update request");

  params->show_play_pause_button = in_show_play_pause_button;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PictureInPictureSession::Name_);
  message.set_method_name("Update");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PictureInPictureSessionProxy::Stop(
    StopCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::PictureInPictureSession::Stop");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PictureInPictureSession::kStop), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PictureInPictureSession_Stop_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PictureInPictureSession::Name_);
  message.set_method_name("Stop");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PictureInPictureSession_Stop_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PictureInPictureSessionProxy::UpdateMediaPosition(
    ::media_session::mojom::blink::MediaPositionPtr in_media_position) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PictureInPictureSession::UpdateMediaPosition", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("media_position"), in_media_position,
                        "<value of type ::media_session::mojom::blink::MediaPositionPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PictureInPictureSession::kUpdateMediaPosition), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PictureInPictureSession_UpdateMediaPosition_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->media_position)::BaseType> media_position_fragment(
          params.message());
  
  mojo::internal::Serialize<::media_session::mojom::MediaPositionDataView>(
    in_media_position,
    media_position_fragment);

  params->media_position.Set(
      media_position_fragment.is_null() ? nullptr : media_position_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->media_position.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null media_position in PictureInPictureSession.UpdateMediaPosition request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PictureInPictureSession::Name_);
  message.set_method_name("UpdateMediaPosition");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class PictureInPictureSession_Stop_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PictureInPictureSession::StopCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PictureInPictureSession_Stop_ProxyToResponder> proxy(
        new PictureInPictureSession_Stop_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PictureInPictureSession_Stop_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PictureInPictureSession_Stop_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PictureInPictureSession_Stop_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PictureInPictureSession::StopCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool PictureInPictureSession_Stop_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PictureInPictureSession_Stop_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PictureInPictureSession_Stop_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PictureInPictureSession.1
  bool success = true;
  PictureInPictureSession_Stop_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PictureInPictureSession::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void PictureInPictureSession_Stop_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply blink::mojom::PictureInPictureSession::Stop");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PictureInPictureSession::kStop), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PictureInPictureSession_Stop_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PictureInPictureSession::Name_);
  message.set_method_name("Stop");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PictureInPictureSessionStubDispatch::Accept(
    PictureInPictureSession* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PictureInPictureSession>(message->header()->name)) {
    case messages::PictureInPictureSession::kUpdate: {
      DCHECK(message->is_serialized());
      internal::PictureInPictureSession_Update_Params_Data* params =
          reinterpret_cast<internal::PictureInPictureSession_Update_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PictureInPictureSession.0
      bool success = true;
      uint32_t p_player_id{};
      ::mojo::PendingAssociatedRemote<::media::mojom::blink::MediaPlayer> p_player_remote{};
      ::viz::SurfaceId p_surface_id{};
      ::gfx::Size p_natural_size{};
      bool p_show_play_pause_button{};
      PictureInPictureSession_Update_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_player_id = input_data_view.player_id();
      if (success) {
        p_player_remote =
            input_data_view.TakePlayerRemote<decltype(p_player_remote)>();
      }
      if (success && !input_data_view.ReadSurfaceId(&p_surface_id))
        success = false;
      if (success && !input_data_view.ReadNaturalSize(&p_natural_size))
        success = false;
      if (success)
        p_show_play_pause_button = input_data_view.show_play_pause_button();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PictureInPictureSession::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Update(        
        std::move(p_player_id), 
        std::move(p_player_remote), 
        std::move(p_surface_id), 
        std::move(p_natural_size), 
        std::move(p_show_play_pause_button));
      return true;
    }
    case messages::PictureInPictureSession::kStop: {
      break;
    }
    case messages::PictureInPictureSession::kUpdateMediaPosition: {
      DCHECK(message->is_serialized());
      internal::PictureInPictureSession_UpdateMediaPosition_Params_Data* params =
          reinterpret_cast<internal::PictureInPictureSession_UpdateMediaPosition_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PictureInPictureSession.2
      bool success = true;
      ::media_session::mojom::blink::MediaPositionPtr p_media_position{};
      PictureInPictureSession_UpdateMediaPosition_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMediaPosition(&p_media_position))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PictureInPictureSession::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateMediaPosition(        
        std::move(p_media_position));
      return true;
    }
  }
  return false;
}

// static
bool PictureInPictureSessionStubDispatch::AcceptWithResponder(
    PictureInPictureSession* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PictureInPictureSession>(message->header()->name)) {
    case messages::PictureInPictureSession::kUpdate: {
      break;
    }
    case messages::PictureInPictureSession::kStop: {
      internal::PictureInPictureSession_Stop_Params_Data* params =
          reinterpret_cast<
              internal::PictureInPictureSession_Stop_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PictureInPictureSession.1
      bool success = true;
      PictureInPictureSession_Stop_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PictureInPictureSession::Name_, 1, false);
        return false;
      }
      auto callback =
          PictureInPictureSession_Stop_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Stop(std::move(callback));
      return true;
    }
    case messages::PictureInPictureSession::kUpdateMediaPosition: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPictureInPictureSessionValidationInfo[] = {
    { &internal::PictureInPictureSession_Update_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PictureInPictureSession_Stop_Params_Data::Validate,
     &internal::PictureInPictureSession_Stop_ResponseParams_Data::Validate},
    { &internal::PictureInPictureSession_UpdateMediaPosition_Params_Data::Validate,
     nullptr /* no response */},
};

bool PictureInPictureSessionRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::PictureInPictureSession::Name_,
    kPictureInPictureSessionValidationInfo);
}

bool PictureInPictureSessionResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::PictureInPictureSession::Name_,
    kPictureInPictureSessionValidationInfo);
}
// The declaration includes the definition on other builds.

PictureInPictureService::IPCStableHashFunction PictureInPictureService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PictureInPictureService>(message.name())) {
    case messages::PictureInPictureService::kStartSession: {
      return &PictureInPictureService::StartSession_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PictureInPictureService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PictureInPictureService>(message.name())) {
      case messages::PictureInPictureService::kStartSession:
            return "Receive blink::mojom::PictureInPictureService::StartSession";
    }
  } else {
    switch (static_cast<messages::PictureInPictureService>(message.name())) {
      case messages::PictureInPictureService::kStartSession:
            return "Receive reply blink::mojom::PictureInPictureService::StartSession";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PictureInPictureService::StartSession_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd9932e09;  // IPCStableHash for blink::mojom::PictureInPictureService::StartSession
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PictureInPictureService_StartSession_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PictureInPictureService_StartSession_ForwardToCallback(
      PictureInPictureService::StartSessionCallback callback
      ) : callback_(std::move(callback)) {
  }

  PictureInPictureService_StartSession_ForwardToCallback(const PictureInPictureService_StartSession_ForwardToCallback&) = delete;
  PictureInPictureService_StartSession_ForwardToCallback& operator=(const PictureInPictureService_StartSession_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PictureInPictureService::StartSessionCallback callback_;
};

PictureInPictureServiceProxy::PictureInPictureServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PictureInPictureServiceProxy::StartSession(
    uint32_t in_player_id, ::mojo::PendingAssociatedRemote<::media::mojom::blink::MediaPlayer> in_player_remote, const ::viz::SurfaceId& in_surface_id, const ::gfx::Size& in_natural_size, bool in_show_play_pause_button, ::mojo::PendingRemote<PictureInPictureSessionObserver> in_observer, const ::gfx::Rect& in_source_bounds, StartSessionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PictureInPictureService::StartSession", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("player_id"), in_player_id,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("player_remote"), in_player_remote,
                        "<value of type ::mojo::PendingAssociatedRemote<::media::mojom::blink::MediaPlayer>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("surface_id"), in_surface_id,
                        "<value of type const ::viz::SurfaceId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("natural_size"), in_natural_size,
                        "<value of type const ::gfx::Size&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("show_play_pause_button"), in_show_play_pause_button,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<PictureInPictureSessionObserver>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_bounds"), in_source_bounds,
                        "<value of type const ::gfx::Rect&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PictureInPictureService::kStartSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PictureInPictureService_StartSession_Params_Data> params(
          message);
  params.Allocate();

  params->player_id = in_player_id;

  
  mojo::internal::Serialize<::media::mojom::MediaPlayerAssociatedPtrInfoDataView>(
    in_player_remote,
    &params->player_remote,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->player_remote)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid player_remote in PictureInPictureService.StartSession request");
  mojo::internal::MessageFragment<
      typename decltype(params->surface_id)::BaseType> surface_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::SurfaceIdDataView>(
    in_surface_id,
    surface_id_fragment);

  params->surface_id.Set(
      surface_id_fragment.is_null() ? nullptr : surface_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->surface_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null surface_id in PictureInPictureService.StartSession request");
  mojo::internal::MessageFragment<
      typename decltype(params->natural_size)::BaseType> natural_size_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_natural_size,
    natural_size_fragment);

  params->natural_size.Set(
      natural_size_fragment.is_null() ? nullptr : natural_size_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->natural_size.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null natural_size in PictureInPictureService.StartSession request");

  params->show_play_pause_button = in_show_play_pause_button;

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::PictureInPictureSessionObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in PictureInPictureService.StartSession request");
  mojo::internal::MessageFragment<
      typename decltype(params->source_bounds)::BaseType> source_bounds_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_source_bounds,
    source_bounds_fragment);

  params->source_bounds.Set(
      source_bounds_fragment.is_null() ? nullptr : source_bounds_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source_bounds.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source_bounds in PictureInPictureService.StartSession request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PictureInPictureService::Name_);
  message.set_method_name("StartSession");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PictureInPictureService_StartSession_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class PictureInPictureService_StartSession_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PictureInPictureService::StartSessionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PictureInPictureService_StartSession_ProxyToResponder> proxy(
        new PictureInPictureService_StartSession_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PictureInPictureService_StartSession_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PictureInPictureService_StartSession_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PictureInPictureService_StartSession_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PictureInPictureService::StartSessionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::PendingRemote<PictureInPictureSession> in_session, const ::gfx::Size& in_size);
};

bool PictureInPictureService_StartSession_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PictureInPictureService_StartSession_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PictureInPictureService_StartSession_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PictureInPictureService.0
  bool success = true;
  ::mojo::PendingRemote<PictureInPictureSession> p_session{};
  ::gfx::Size p_size{};
  PictureInPictureService_StartSession_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_session =
        input_data_view.TakeSession<decltype(p_session)>();
  }
  if (success && !input_data_view.ReadSize(&p_size))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PictureInPictureService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_session), 
std::move(p_size));
  }
  return true;
}

void PictureInPictureService_StartSession_ProxyToResponder::Run(
    ::mojo::PendingRemote<PictureInPictureSession> in_session, const ::gfx::Size& in_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::PictureInPictureService::StartSession", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session"), in_session,
                        "<value of type ::mojo::PendingRemote<PictureInPictureSession>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size"), in_size,
                        "<value of type const ::gfx::Size&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PictureInPictureService::kStartSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PictureInPictureService_StartSession_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::PictureInPictureSessionInterfaceBase>>(
    in_session,
    &params->session,
    &params.message());
  mojo::internal::MessageFragment<
      typename decltype(params->size)::BaseType> size_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_size,
    size_fragment);

  params->size.Set(
      size_fragment.is_null() ? nullptr : size_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->size.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null size in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PictureInPictureService::Name_);
  message.set_method_name("StartSession");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PictureInPictureServiceStubDispatch::Accept(
    PictureInPictureService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PictureInPictureService>(message->header()->name)) {
    case messages::PictureInPictureService::kStartSession: {
      break;
    }
  }
  return false;
}

// static
bool PictureInPictureServiceStubDispatch::AcceptWithResponder(
    PictureInPictureService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PictureInPictureService>(message->header()->name)) {
    case messages::PictureInPictureService::kStartSession: {
      internal::PictureInPictureService_StartSession_Params_Data* params =
          reinterpret_cast<
              internal::PictureInPictureService_StartSession_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PictureInPictureService.0
      bool success = true;
      uint32_t p_player_id{};
      ::mojo::PendingAssociatedRemote<::media::mojom::blink::MediaPlayer> p_player_remote{};
      ::viz::SurfaceId p_surface_id{};
      ::gfx::Size p_natural_size{};
      bool p_show_play_pause_button{};
      ::mojo::PendingRemote<PictureInPictureSessionObserver> p_observer{};
      ::gfx::Rect p_source_bounds{};
      PictureInPictureService_StartSession_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_player_id = input_data_view.player_id();
      if (success) {
        p_player_remote =
            input_data_view.TakePlayerRemote<decltype(p_player_remote)>();
      }
      if (success && !input_data_view.ReadSurfaceId(&p_surface_id))
        success = false;
      if (success && !input_data_view.ReadNaturalSize(&p_natural_size))
        success = false;
      if (success)
        p_show_play_pause_button = input_data_view.show_play_pause_button();
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (success && !input_data_view.ReadSourceBounds(&p_source_bounds))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PictureInPictureService::Name_, 0, false);
        return false;
      }
      auto callback =
          PictureInPictureService_StartSession_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartSession(        
        std::move(p_player_id), 
        std::move(p_player_remote), 
        std::move(p_surface_id), 
        std::move(p_natural_size), 
        std::move(p_show_play_pause_button), 
        std::move(p_observer), 
        std::move(p_source_bounds), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPictureInPictureServiceValidationInfo[] = {
    { &internal::PictureInPictureService_StartSession_Params_Data::Validate,
     &internal::PictureInPictureService_StartSession_ResponseParams_Data::Validate},
};

bool PictureInPictureServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::PictureInPictureService::Name_,
    kPictureInPictureServiceValidationInfo);
}

bool PictureInPictureServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::PictureInPictureService::Name_,
    kPictureInPictureServiceValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void PictureInPictureSessionObserverInterceptorForTesting::OnWindowSizeChanged(const ::gfx::Size& size) {
  GetForwardingInterface()->OnWindowSizeChanged(
    std::move(size)
    );
}
void PictureInPictureSessionObserverInterceptorForTesting::OnStopped() {
  GetForwardingInterface()->OnStopped();
}
PictureInPictureSessionObserverAsyncWaiter::PictureInPictureSessionObserverAsyncWaiter(
    PictureInPictureSessionObserver* proxy) : proxy_(proxy) {}

PictureInPictureSessionObserverAsyncWaiter::~PictureInPictureSessionObserverAsyncWaiter() = default;





void PictureInPictureSessionInterceptorForTesting::Update(uint32_t player_id, ::mojo::PendingAssociatedRemote<::media::mojom::blink::MediaPlayer> player_remote, const ::viz::SurfaceId& surface_id, const ::gfx::Size& natural_size, bool show_play_pause_button) {
  GetForwardingInterface()->Update(
    std::move(player_id)
    , 
    std::move(player_remote)
    , 
    std::move(surface_id)
    , 
    std::move(natural_size)
    , 
    std::move(show_play_pause_button)
    );
}
void PictureInPictureSessionInterceptorForTesting::Stop(StopCallback callback) {
  GetForwardingInterface()->Stop(std::move(callback));
}
void PictureInPictureSessionInterceptorForTesting::UpdateMediaPosition(::media_session::mojom::blink::MediaPositionPtr media_position) {
  GetForwardingInterface()->UpdateMediaPosition(
    std::move(media_position)
    );
}
PictureInPictureSessionAsyncWaiter::PictureInPictureSessionAsyncWaiter(
    PictureInPictureSession* proxy) : proxy_(proxy) {}

PictureInPictureSessionAsyncWaiter::~PictureInPictureSessionAsyncWaiter() = default;


void PictureInPictureSessionAsyncWaiter::Stop(
    ) {
  base::RunLoop loop;
  proxy_->Stop(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}






void PictureInPictureServiceInterceptorForTesting::StartSession(uint32_t player_id, ::mojo::PendingAssociatedRemote<::media::mojom::blink::MediaPlayer> player_remote, const ::viz::SurfaceId& surface_id, const ::gfx::Size& natural_size, bool show_play_pause_button, ::mojo::PendingRemote<PictureInPictureSessionObserver> observer, const ::gfx::Rect& source_bounds, StartSessionCallback callback) {
  GetForwardingInterface()->StartSession(
    std::move(player_id)
    , 
    std::move(player_remote)
    , 
    std::move(surface_id)
    , 
    std::move(natural_size)
    , 
    std::move(show_play_pause_button)
    , 
    std::move(observer)
    , 
    std::move(source_bounds)
    , std::move(callback));
}
PictureInPictureServiceAsyncWaiter::PictureInPictureServiceAsyncWaiter(
    PictureInPictureService* proxy) : proxy_(proxy) {}

PictureInPictureServiceAsyncWaiter::~PictureInPictureServiceAsyncWaiter() = default;


void PictureInPictureServiceAsyncWaiter::StartSession(
    uint32_t player_id, ::mojo::PendingAssociatedRemote<::media::mojom::blink::MediaPlayer> player_remote, const ::viz::SurfaceId& surface_id, const ::gfx::Size& natural_size, bool show_play_pause_button, ::mojo::PendingRemote<PictureInPictureSessionObserver> observer, const ::gfx::Rect& source_bounds, ::mojo::PendingRemote<PictureInPictureSession>* out_session, ::gfx::Size* out_size) {
  base::RunLoop loop;
  proxy_->StartSession(
      std::move(player_id),
      std::move(player_remote),
      std::move(surface_id),
      std::move(natural_size),
      std::move(show_play_pause_button),
      std::move(observer),
      std::move(source_bounds),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo::PendingRemote<PictureInPictureSession>* out_session
,
             ::gfx::Size* out_size
,
             ::mojo::PendingRemote<PictureInPictureSession> session,
             const ::gfx::Size& size) {*out_session = std::move(session);*out_size = std::move(size);
            loop->Quit();
          },
          &loop,
          out_session,
          out_size));
  loop.Run();
}








}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif