// third_party/blink/public/mojom/performance_manager/v8_detailed_memory_reporter.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERFORMANCE_MANAGER_V8_DETAILED_MEMORY_REPORTER_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERFORMANCE_MANAGER_V8_DETAILED_MEMORY_REPORTER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/performance_manager/v8_detailed_memory_reporter.mojom-shared-internal.h"
#include "mojo/public/mojom/base/byte_count.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "third_party/blink/public/mojom/performance_manager/v8_detailed_memory_reporter.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::blink::mojom::V8DetailedMemoryReporter_Mode>
    : public mojo::internal::EnumHashImpl<::blink::mojom::V8DetailedMemoryReporter_Mode> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::V8DetailedMemoryReporter_Mode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::V8DetailedMemoryReporter_Mode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::V8DetailedMemoryReporter_Mode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PerContextV8MemoryUsageDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PerContextV8MemoryUsageDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PerContextV8MemoryUsage_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::token(input)) in_token = Traits::token(input);
    mojo::internal::MessageFragment<decltype(fragment->token)>
        token_fragment(fragment.message());
    token_fragment.Claim(&fragment->token);
    
    mojo::internal::Serialize<::blink::mojom::ExecutionContextTokenDataView>(
      in_token,
      token_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->token.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null token in PerContextV8MemoryUsage struct");

    decltype(Traits::memory_used(input)) in_memory_used = Traits::memory_used(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->memory_used)::BaseType> memory_used_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::ByteCountDataView>(
      in_memory_used,
      memory_used_fragment);

    fragment->memory_used.Set(
        memory_used_fragment.is_null() ? nullptr : memory_used_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->memory_used.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null memory_used in PerContextV8MemoryUsage struct");

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::PerContextV8MemoryUsage_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PerContextV8MemoryUsageDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PerContextCanvasMemoryUsageDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PerContextCanvasMemoryUsageDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PerContextCanvasMemoryUsage_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::token(input)) in_token = Traits::token(input);
    mojo::internal::MessageFragment<decltype(fragment->token)>
        token_fragment(fragment.message());
    token_fragment.Claim(&fragment->token);
    
    mojo::internal::Serialize<::blink::mojom::ExecutionContextTokenDataView>(
      in_token,
      token_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->token.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null token in PerContextCanvasMemoryUsage struct");

    decltype(Traits::memory_used(input)) in_memory_used = Traits::memory_used(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->memory_used)::BaseType> memory_used_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::ByteCountDataView>(
      in_memory_used,
      memory_used_fragment);

    fragment->memory_used.Set(
        memory_used_fragment.is_null() ? nullptr : memory_used_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->memory_used.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null memory_used in PerContextCanvasMemoryUsage struct");
  }

  static bool Deserialize(::blink::mojom::internal::PerContextCanvasMemoryUsage_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PerContextCanvasMemoryUsageDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PerIsolateV8MemoryUsageDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PerIsolateV8MemoryUsageDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PerIsolateV8MemoryUsage_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->num_detached_contexts = Traits::num_detached_contexts(input);

    decltype(Traits::detached_memory_used(input)) in_detached_memory_used = Traits::detached_memory_used(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->detached_memory_used)::BaseType> detached_memory_used_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::ByteCountDataView>(
      in_detached_memory_used,
      detached_memory_used_fragment);

    fragment->detached_memory_used.Set(
        detached_memory_used_fragment.is_null() ? nullptr : detached_memory_used_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->detached_memory_used.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null detached_memory_used in PerIsolateV8MemoryUsage struct");

    decltype(Traits::shared_memory_used(input)) in_shared_memory_used = Traits::shared_memory_used(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->shared_memory_used)::BaseType> shared_memory_used_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::ByteCountDataView>(
      in_shared_memory_used,
      shared_memory_used_fragment);

    fragment->shared_memory_used.Set(
        shared_memory_used_fragment.is_null() ? nullptr : shared_memory_used_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->shared_memory_used.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null shared_memory_used in PerIsolateV8MemoryUsage struct");

    decltype(Traits::blink_memory_used(input)) in_blink_memory_used = Traits::blink_memory_used(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->blink_memory_used)::BaseType> blink_memory_used_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::ByteCountDataView>(
      in_blink_memory_used,
      blink_memory_used_fragment);

    fragment->blink_memory_used.Set(
        blink_memory_used_fragment.is_null() ? nullptr : blink_memory_used_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->blink_memory_used.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null blink_memory_used in PerIsolateV8MemoryUsage struct");

    decltype(Traits::contexts(input)) in_contexts = Traits::contexts(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->contexts)::BaseType>
        contexts_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& contexts_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::PerContextV8MemoryUsageDataView>>(
      in_contexts,
      contexts_fragment,
      &contexts_validate_params);

    fragment->contexts.Set(
        contexts_fragment.is_null() ? nullptr : contexts_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->contexts.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null contexts in PerIsolateV8MemoryUsage struct");

    decltype(Traits::canvas_contexts(input)) in_canvas_contexts = Traits::canvas_contexts(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->canvas_contexts)::BaseType>
        canvas_contexts_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& canvas_contexts_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::PerContextCanvasMemoryUsageDataView>>(
      in_canvas_contexts,
      canvas_contexts_fragment,
      &canvas_contexts_validate_params);

    fragment->canvas_contexts.Set(
        canvas_contexts_fragment.is_null() ? nullptr : canvas_contexts_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->canvas_contexts.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null canvas_contexts in PerIsolateV8MemoryUsage struct");
  }

  static bool Deserialize(::blink::mojom::internal::PerIsolateV8MemoryUsage_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PerIsolateV8MemoryUsageDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PerProcessV8MemoryUsageDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PerProcessV8MemoryUsageDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PerProcessV8MemoryUsage_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::isolates(input)) in_isolates = Traits::isolates(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->isolates)::BaseType>
        isolates_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& isolates_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::PerIsolateV8MemoryUsageDataView>>(
      in_isolates,
      isolates_fragment,
      &isolates_validate_params);

    fragment->isolates.Set(
        isolates_fragment.is_null() ? nullptr : isolates_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->isolates.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null isolates in PerProcessV8MemoryUsage struct");
  }

  static bool Deserialize(::blink::mojom::internal::PerProcessV8MemoryUsage_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PerProcessV8MemoryUsageDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void PerContextV8MemoryUsageDataView::GetTokenDataView(
    ::blink::mojom::ExecutionContextTokenDataView* output) {
  auto pointer = &data_->token;
  *output = ::blink::mojom::ExecutionContextTokenDataView(pointer, message_);
}
inline void PerContextV8MemoryUsageDataView::GetMemoryUsedDataView(
    ::mojo_base::mojom::ByteCountDataView* output) {
  auto pointer = data_->memory_used.Get();
  *output = ::mojo_base::mojom::ByteCountDataView(pointer, message_);
}
inline void PerContextV8MemoryUsageDataView::GetUrlDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->url.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void PerContextCanvasMemoryUsageDataView::GetTokenDataView(
    ::blink::mojom::ExecutionContextTokenDataView* output) {
  auto pointer = &data_->token;
  *output = ::blink::mojom::ExecutionContextTokenDataView(pointer, message_);
}
inline void PerContextCanvasMemoryUsageDataView::GetMemoryUsedDataView(
    ::mojo_base::mojom::ByteCountDataView* output) {
  auto pointer = data_->memory_used.Get();
  *output = ::mojo_base::mojom::ByteCountDataView(pointer, message_);
}


inline void PerIsolateV8MemoryUsageDataView::GetDetachedMemoryUsedDataView(
    ::mojo_base::mojom::ByteCountDataView* output) {
  auto pointer = data_->detached_memory_used.Get();
  *output = ::mojo_base::mojom::ByteCountDataView(pointer, message_);
}
inline void PerIsolateV8MemoryUsageDataView::GetSharedMemoryUsedDataView(
    ::mojo_base::mojom::ByteCountDataView* output) {
  auto pointer = data_->shared_memory_used.Get();
  *output = ::mojo_base::mojom::ByteCountDataView(pointer, message_);
}
inline void PerIsolateV8MemoryUsageDataView::GetBlinkMemoryUsedDataView(
    ::mojo_base::mojom::ByteCountDataView* output) {
  auto pointer = data_->blink_memory_used.Get();
  *output = ::mojo_base::mojom::ByteCountDataView(pointer, message_);
}
inline void PerIsolateV8MemoryUsageDataView::GetContextsDataView(
    mojo::ArrayDataView<PerContextV8MemoryUsageDataView>* output) {
  auto pointer = data_->contexts.Get();
  *output = mojo::ArrayDataView<PerContextV8MemoryUsageDataView>(pointer, message_);
}
inline void PerIsolateV8MemoryUsageDataView::GetCanvasContextsDataView(
    mojo::ArrayDataView<PerContextCanvasMemoryUsageDataView>* output) {
  auto pointer = data_->canvas_contexts.Get();
  *output = mojo::ArrayDataView<PerContextCanvasMemoryUsageDataView>(pointer, message_);
}


inline void PerProcessV8MemoryUsageDataView::GetIsolatesDataView(
    mojo::ArrayDataView<PerIsolateV8MemoryUsageDataView>* output) {
  auto pointer = data_->isolates.Get();
  *output = mojo::ArrayDataView<PerIsolateV8MemoryUsageDataView>(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::V8DetailedMemoryReporter_Mode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::V8DetailedMemoryReporter_Mode value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERFORMANCE_MANAGER_V8_DETAILED_MEMORY_REPORTER_MOJOM_SHARED_H_