// third_party/blink/public/mojom/payments/payment_request.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('payments.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
payments.mojom.PaymentErrorReasonSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
payments.mojom.PaymentErrorReason = {
  
  UNKNOWN: 0,
  USER_CANCEL: 1,
  NOT_SUPPORTED: 2,
  NOT_SUPPORTED_FOR_INVALID_ORIGIN_OR_SSL: 3,
  ALREADY_SHOWING: 4,
  INVALID_DATA_FROM_RENDERER: 5,
  NOT_ALLOWED_ERROR: 6,
  USER_OPT_OUT: 7,
  USER_ACTIVATION_REQUIRED: 8,
  MIN_VALUE: 0,
  MAX_VALUE: 8,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
payments.mojom.CanMakePaymentQueryResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
payments.mojom.CanMakePaymentQueryResult = {
  
  CAN_MAKE_PAYMENT: 0,
  CANNOT_MAKE_PAYMENT: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
payments.mojom.HasEnrolledInstrumentQueryResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
payments.mojom.HasEnrolledInstrumentQueryResult = {
  
  HAS_ENROLLED_INSTRUMENT: 0,
  HAS_NO_ENROLLED_INSTRUMENT: 1,
  QUERY_QUOTA_EXCEEDED: 2,
  WARNING_HAS_ENROLLED_INSTRUMENT: 3,
  WARNING_HAS_NO_ENROLLED_INSTRUMENT: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
payments.mojom.AndroidPayEnvironmentSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
payments.mojom.AndroidPayEnvironment = {
  
  PRODUCTION: 0,
  TEST: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
payments.mojom.BasicCardNetworkSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
payments.mojom.BasicCardNetwork = {
  
  AMEX: 0,
  DINERS: 1,
  DISCOVER: 2,
  JCB: 3,
  MASTERCARD: 4,
  MIR: 5,
  UNIONPAY: 6,
  VISA: 7,
  MIN_VALUE: 0,
  MAX_VALUE: 7,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
payments.mojom.PaymentShippingTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
payments.mojom.PaymentShippingType = {
  
  SHIPPING: 0,
  DELIVERY: 1,
  PICKUP: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
payments.mojom.PaymentCompleteSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
payments.mojom.PaymentComplete = {
  
  FAIL: 0,
  SUCCESS: 1,
  UNKNOWN: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
payments.mojom.PaymentRequestClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        payments.mojom.PaymentRequestClient.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { payments.mojom.PaymentRequestClientInterface }
 */
payments.mojom.PaymentRequestClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!payments.mojom.PaymentRequestClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          payments.mojom.PaymentRequestClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!payments.mojom.PaymentRequestClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } methodName
   * @param { !string } stringifiedDetails
   */

  onPaymentMethodChange(
      methodName,
      stringifiedDetails) {
    this.proxy.sendMessage(
        0,
        payments.mojom.PaymentRequestClient_OnPaymentMethodChange_ParamsSpec.$,
        null,
        [
          methodName,
          stringifiedDetails
        ],
        false);
  }

  
  /**
   * @param { !payments.mojom.PaymentAddress } address
   */

  onShippingAddressChange(
      address) {
    this.proxy.sendMessage(
        1,
        payments.mojom.PaymentRequestClient_OnShippingAddressChange_ParamsSpec.$,
        null,
        [
          address
        ],
        false);
  }

  
  /**
   * @param { !string } shippingOptionId
   */

  onShippingOptionChange(
      shippingOptionId) {
    this.proxy.sendMessage(
        2,
        payments.mojom.PaymentRequestClient_OnShippingOptionChange_ParamsSpec.$,
        null,
        [
          shippingOptionId
        ],
        false);
  }

  
  /**
   * @param { !payments.mojom.PayerDetail } detail
   */

  onPayerDetailChange(
      detail) {
    this.proxy.sendMessage(
        3,
        payments.mojom.PaymentRequestClient_OnPayerDetailChange_ParamsSpec.$,
        null,
        [
          detail
        ],
        false);
  }

  
  /**
   * @param { !payments.mojom.PaymentResponse } response
   */

  onPaymentResponse(
      response) {
    this.proxy.sendMessage(
        4,
        payments.mojom.PaymentRequestClient_OnPaymentResponse_ParamsSpec.$,
        null,
        [
          response
        ],
        false);
  }

  
  /**
   * @param { !payments.mojom.PaymentErrorReason } error
   * @param { !string } errorMessage
   */

  onError(
      error,
      errorMessage) {
    this.proxy.sendMessage(
        5,
        payments.mojom.PaymentRequestClient_OnError_ParamsSpec.$,
        null,
        [
          error,
          errorMessage
        ],
        false);
  }

  
  /**
   */

  onComplete() {
    this.proxy.sendMessage(
        6,
        payments.mojom.PaymentRequestClient_OnComplete_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } abortedSuccessfully
   */

  onAbort(
      abortedSuccessfully) {
    this.proxy.sendMessage(
        7,
        payments.mojom.PaymentRequestClient_OnAbort_ParamsSpec.$,
        null,
        [
          abortedSuccessfully
        ],
        false);
  }

  
  /**
   * @param { !payments.mojom.CanMakePaymentQueryResult } result
   */

  onCanMakePayment(
      result) {
    this.proxy.sendMessage(
        8,
        payments.mojom.PaymentRequestClient_OnCanMakePayment_ParamsSpec.$,
        null,
        [
          result
        ],
        false);
  }

  
  /**
   * @param { !payments.mojom.HasEnrolledInstrumentQueryResult } result
   */

  onHasEnrolledInstrument(
      result) {
    this.proxy.sendMessage(
        9,
        payments.mojom.PaymentRequestClient_OnHasEnrolledInstrument_ParamsSpec.$,
        null,
        [
          result
        ],
        false);
  }

  
  /**
   */

  warnNoFavicon() {
    this.proxy.sendMessage(
        10,
        payments.mojom.PaymentRequestClient_WarnNoFavicon_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @param { !url.mojom.Url } urlBeforeRedirects
   * @param { !boolean } didFollowRedirect
   * @return {!Promise<{
        allow: !boolean,
   *  }>}
   */

  allowConnectToSource(
      url,
      urlBeforeRedirects,
      didFollowRedirect) {
    return this.proxy.sendMessage(
        11,
        payments.mojom.PaymentRequestClient_AllowConnectToSource_ParamsSpec.$,
        payments.mojom.PaymentRequestClient_AllowConnectToSource_ResponseParamsSpec.$,
        [
          url,
          urlBeforeRedirects,
          didFollowRedirect
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PaymentRequestClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
payments.mojom.PaymentRequestClientReceiver = class {
  /**
   * @param {!payments.mojom.PaymentRequestClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!payments.mojom.PaymentRequestClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        payments.mojom.PaymentRequestClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!payments.mojom.PaymentRequestClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        payments.mojom.PaymentRequestClient_OnPaymentMethodChange_ParamsSpec.$,
        null,
        impl.onPaymentMethodChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        payments.mojom.PaymentRequestClient_OnShippingAddressChange_ParamsSpec.$,
        null,
        impl.onShippingAddressChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        payments.mojom.PaymentRequestClient_OnShippingOptionChange_ParamsSpec.$,
        null,
        impl.onShippingOptionChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        payments.mojom.PaymentRequestClient_OnPayerDetailChange_ParamsSpec.$,
        null,
        impl.onPayerDetailChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        payments.mojom.PaymentRequestClient_OnPaymentResponse_ParamsSpec.$,
        null,
        impl.onPaymentResponse.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        payments.mojom.PaymentRequestClient_OnError_ParamsSpec.$,
        null,
        impl.onError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        payments.mojom.PaymentRequestClient_OnComplete_ParamsSpec.$,
        null,
        impl.onComplete.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        payments.mojom.PaymentRequestClient_OnAbort_ParamsSpec.$,
        null,
        impl.onAbort.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        payments.mojom.PaymentRequestClient_OnCanMakePayment_ParamsSpec.$,
        null,
        impl.onCanMakePayment.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        payments.mojom.PaymentRequestClient_OnHasEnrolledInstrument_ParamsSpec.$,
        null,
        impl.onHasEnrolledInstrument.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        payments.mojom.PaymentRequestClient_WarnNoFavicon_ParamsSpec.$,
        null,
        impl.warnNoFavicon.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        payments.mojom.PaymentRequestClient_AllowConnectToSource_ParamsSpec.$,
        payments.mojom.PaymentRequestClient_AllowConnectToSource_ResponseParamsSpec.$,
        impl.allowConnectToSource.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
payments.mojom.PaymentRequestClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "payments.mojom.PaymentRequestClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!payments.mojom.PaymentRequestClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new payments.mojom.PaymentRequestClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the PaymentRequestClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
payments.mojom.PaymentRequestClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      payments.mojom.PaymentRequestClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!payments.mojom.PaymentRequestClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPaymentMethodChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        payments.mojom.PaymentRequestClient_OnPaymentMethodChange_ParamsSpec.$,
        null,
        this.onPaymentMethodChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onShippingAddressChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        payments.mojom.PaymentRequestClient_OnShippingAddressChange_ParamsSpec.$,
        null,
        this.onShippingAddressChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onShippingOptionChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        payments.mojom.PaymentRequestClient_OnShippingOptionChange_ParamsSpec.$,
        null,
        this.onShippingOptionChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPayerDetailChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        payments.mojom.PaymentRequestClient_OnPayerDetailChange_ParamsSpec.$,
        null,
        this.onPayerDetailChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPaymentResponse =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        payments.mojom.PaymentRequestClient_OnPaymentResponse_ParamsSpec.$,
        null,
        this.onPaymentResponse.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        payments.mojom.PaymentRequestClient_OnError_ParamsSpec.$,
        null,
        this.onError.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onComplete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        payments.mojom.PaymentRequestClient_OnComplete_ParamsSpec.$,
        null,
        this.onComplete.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onAbort =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        payments.mojom.PaymentRequestClient_OnAbort_ParamsSpec.$,
        null,
        this.onAbort.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCanMakePayment =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        payments.mojom.PaymentRequestClient_OnCanMakePayment_ParamsSpec.$,
        null,
        this.onCanMakePayment.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onHasEnrolledInstrument =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        payments.mojom.PaymentRequestClient_OnHasEnrolledInstrument_ParamsSpec.$,
        null,
        this.onHasEnrolledInstrument.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.warnNoFavicon =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        payments.mojom.PaymentRequestClient_WarnNoFavicon_ParamsSpec.$,
        null,
        this.warnNoFavicon.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.allowConnectToSource =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        payments.mojom.PaymentRequestClient_AllowConnectToSource_ParamsSpec.$,
        payments.mojom.PaymentRequestClient_AllowConnectToSource_ResponseParamsSpec.$,
        this.allowConnectToSource.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
payments.mojom.PaymentRequestPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        payments.mojom.PaymentRequest.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { payments.mojom.PaymentRequestInterface }
 */
payments.mojom.PaymentRequestRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!payments.mojom.PaymentRequestPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          payments.mojom.PaymentRequestPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!payments.mojom.PaymentRequestPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !payments.mojom.PaymentRequestClientRemote } client
   * @param { !Array<!payments.mojom.PaymentMethodData> } methodData
   * @param { !payments.mojom.PaymentDetails } details
   * @param { !payments.mojom.PaymentOptions } options
   */

  init(
      client,
      methodData,
      details,
      options) {
    this.proxy.sendMessage(
        0,
        payments.mojom.PaymentRequest_Init_ParamsSpec.$,
        null,
        [
          client,
          methodData,
          details,
          options
        ],
        false);
  }

  
  /**
   * @param { !boolean } waitForUpdatedDetails
   * @param { !boolean } hadUserActivation
   */

  show(
      waitForUpdatedDetails,
      hadUserActivation) {
    this.proxy.sendMessage(
        1,
        payments.mojom.PaymentRequest_Show_ParamsSpec.$,
        null,
        [
          waitForUpdatedDetails,
          hadUserActivation
        ],
        false);
  }

  
  /**
   * @param { !payments.mojom.PaymentDetails } details
   */

  updateWith(
      details) {
    this.proxy.sendMessage(
        2,
        payments.mojom.PaymentRequest_UpdateWith_ParamsSpec.$,
        null,
        [
          details
        ],
        false);
  }

  
  /**
   */

  onPaymentDetailsNotUpdated() {
    this.proxy.sendMessage(
        3,
        payments.mojom.PaymentRequest_OnPaymentDetailsNotUpdated_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  abort() {
    this.proxy.sendMessage(
        4,
        payments.mojom.PaymentRequest_Abort_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !payments.mojom.PaymentComplete } result
   */

  complete(
      result) {
    this.proxy.sendMessage(
        5,
        payments.mojom.PaymentRequest_Complete_ParamsSpec.$,
        null,
        [
          result
        ],
        false);
  }

  
  /**
   * @param { !payments.mojom.PaymentValidationErrors } errors
   */

  retry(
      errors) {
    this.proxy.sendMessage(
        6,
        payments.mojom.PaymentRequest_Retry_ParamsSpec.$,
        null,
        [
          errors
        ],
        false);
  }

  
  /**
   */

  canMakePayment() {
    this.proxy.sendMessage(
        7,
        payments.mojom.PaymentRequest_CanMakePayment_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  hasEnrolledInstrument() {
    this.proxy.sendMessage(
        8,
        payments.mojom.PaymentRequest_HasEnrolledInstrument_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PaymentRequest
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
payments.mojom.PaymentRequestReceiver = class {
  /**
   * @param {!payments.mojom.PaymentRequestInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!payments.mojom.PaymentRequestRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        payments.mojom.PaymentRequestRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!payments.mojom.PaymentRequestRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        payments.mojom.PaymentRequest_Init_ParamsSpec.$,
        null,
        impl.init.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        payments.mojom.PaymentRequest_Show_ParamsSpec.$,
        null,
        impl.show.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        payments.mojom.PaymentRequest_UpdateWith_ParamsSpec.$,
        null,
        impl.updateWith.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        payments.mojom.PaymentRequest_OnPaymentDetailsNotUpdated_ParamsSpec.$,
        null,
        impl.onPaymentDetailsNotUpdated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        payments.mojom.PaymentRequest_Abort_ParamsSpec.$,
        null,
        impl.abort.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        payments.mojom.PaymentRequest_Complete_ParamsSpec.$,
        null,
        impl.complete.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        payments.mojom.PaymentRequest_Retry_ParamsSpec.$,
        null,
        impl.retry.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        payments.mojom.PaymentRequest_CanMakePayment_ParamsSpec.$,
        null,
        impl.canMakePayment.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        payments.mojom.PaymentRequest_HasEnrolledInstrument_ParamsSpec.$,
        null,
        impl.hasEnrolledInstrument.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
payments.mojom.PaymentRequest = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "payments.mojom.PaymentRequest";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!payments.mojom.PaymentRequestRemote}
   * @export
   */
  static getRemote() {
    let remote = new payments.mojom.PaymentRequestRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the PaymentRequest
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
payments.mojom.PaymentRequestCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      payments.mojom.PaymentRequestRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!payments.mojom.PaymentRequestRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.init =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        payments.mojom.PaymentRequest_Init_ParamsSpec.$,
        null,
        this.init.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.show =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        payments.mojom.PaymentRequest_Show_ParamsSpec.$,
        null,
        this.show.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateWith =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        payments.mojom.PaymentRequest_UpdateWith_ParamsSpec.$,
        null,
        this.updateWith.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPaymentDetailsNotUpdated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        payments.mojom.PaymentRequest_OnPaymentDetailsNotUpdated_ParamsSpec.$,
        null,
        this.onPaymentDetailsNotUpdated.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.abort =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        payments.mojom.PaymentRequest_Abort_ParamsSpec.$,
        null,
        this.abort.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.complete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        payments.mojom.PaymentRequest_Complete_ParamsSpec.$,
        null,
        this.complete.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.retry =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        payments.mojom.PaymentRequest_Retry_ParamsSpec.$,
        null,
        this.retry.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.canMakePayment =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        payments.mojom.PaymentRequest_CanMakePayment_ParamsSpec.$,
        null,
        this.canMakePayment.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.hasEnrolledInstrument =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        payments.mojom.PaymentRequest_HasEnrolledInstrument_ParamsSpec.$,
        null,
        this.hasEnrolledInstrument.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentResponseSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PayerDetailSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentItemSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentShippingOptionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.SecurePaymentConfirmationRequestSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.NetworkOrIssuerInformationSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentEntityLogoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentMethodDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentDetailsModifierSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentRequestClient_OnPaymentMethodChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentRequestClient_OnShippingAddressChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentRequestClient_OnShippingOptionChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentRequestClient_OnPayerDetailChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentRequestClient_OnPaymentResponse_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentRequestClient_OnError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentRequestClient_OnComplete_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentRequestClient_OnAbort_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentRequestClient_OnCanMakePayment_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentRequestClient_OnHasEnrolledInstrument_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentRequestClient_WarnNoFavicon_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentRequestClient_AllowConnectToSource_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentRequestClient_AllowConnectToSource_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentRequest_Init_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentRequest_Show_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentRequest_UpdateWith_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentRequest_OnPaymentDetailsNotUpdated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentRequest_Abort_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentRequest_Complete_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentRequest_Retry_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentRequest_CanMakePayment_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentRequest_HasEnrolledInstrument_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    payments.mojom.PaymentResponseSpec.$,
    'PaymentResponse',
    [
      mojo.internal.StructField(
        'methodName', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'stringifiedDetails', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'shippingAddress', 16,
        0,
        payments.mojom.PaymentAddressSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'shippingOption', 24,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'payer', 32,
        0,
        payments.mojom.PayerDetailSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'getAssertionAuthenticatorResponse', 40,
        0,
        blink.mojom.GetAssertionAuthenticatorResponseSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);





/** @record */
payments.mojom.PaymentResponse = class {
  constructor() {
    /** @export { !string } */
    this.methodName;
    /** @export { !string } */
    this.stringifiedDetails;
    /** @export { (payments.mojom.PaymentAddress|undefined) } */
    this.shippingAddress;
    /** @export { (string|undefined) } */
    this.shippingOption;
    /** @export { !payments.mojom.PayerDetail } */
    this.payer;
    /** @export { (blink.mojom.GetAssertionAuthenticatorResponse|undefined) } */
    this.getAssertionAuthenticatorResponse;
  }
};



mojo.internal.Struct(
    payments.mojom.PayerDetailSpec.$,
    'PayerDetail',
    [
      mojo.internal.StructField(
        'email', 0,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'name', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'phone', 16,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
payments.mojom.PayerDetail = class {
  constructor() {
    /** @export { (string|undefined) } */
    this.email;
    /** @export { (string|undefined) } */
    this.name;
    /** @export { (string|undefined) } */
    this.phone;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentItemSpec.$,
    'PaymentItem',
    [
      mojo.internal.StructField(
        'label', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'amount', 8,
        0,
        payments.mojom.PaymentCurrencyAmountSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pending', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
payments.mojom.PaymentItem = class {
  constructor() {
    /** @export { !string } */
    this.label;
    /** @export { !payments.mojom.PaymentCurrencyAmount } */
    this.amount;
    /** @export { !boolean } */
    this.pending;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentShippingOptionSpec.$,
    'PaymentShippingOption',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'label', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'amount', 16,
        0,
        payments.mojom.PaymentCurrencyAmountSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'selected', 24,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
payments.mojom.PaymentShippingOption = class {
  constructor() {
    /** @export { !string } */
    this.id;
    /** @export { !string } */
    this.label;
    /** @export { !payments.mojom.PaymentCurrencyAmount } */
    this.amount;
    /** @export { !boolean } */
    this.selected;
  }
};



mojo.internal.Struct(
    payments.mojom.SecurePaymentConfirmationRequestSpec.$,
    'SecurePaymentConfirmationRequest',
    [
      mojo.internal.StructField(
        'credentialIds', 0,
        0,
        mojo.internal.Array(mojo.internal.Array(mojo.internal.Uint8, false), false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'challenge', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'instrument', 16,
        0,
        blink.mojom.PaymentCredentialInstrumentSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'timeout', 24,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'payeeOrigin', 32,
        0,
        url.mojom.OriginSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'payeeName', 40,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'rpId', 48,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'extensions', 56,
        0,
        blink.mojom.AuthenticationExtensionsClientInputsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'browserBoundPubKeyCredParams', 64,
        0,
        mojo.internal.Array(blink.mojom.PublicKeyCredentialParametersSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'showOptOut', 72,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'paymentEntitiesLogos', 80,
        0,
        mojo.internal.Array(payments.mojom.PaymentEntityLogoSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 96],]);





/** @record */
payments.mojom.SecurePaymentConfirmationRequest = class {
  constructor() {
    /** @export { !Array<!Array<!number>> } */
    this.credentialIds;
    /** @export { !Array<!number> } */
    this.challenge;
    /** @export { !blink.mojom.PaymentCredentialInstrument } */
    this.instrument;
    /** @export { (mojoBase.mojom.TimeDelta|undefined) } */
    this.timeout;
    /** @export { (url.mojom.Origin|undefined) } */
    this.payeeOrigin;
    /** @export { (string|undefined) } */
    this.payeeName;
    /** @export { !string } */
    this.rpId;
    /** @export { (blink.mojom.AuthenticationExtensionsClientInputs|undefined) } */
    this.extensions;
    /** @export { !Array<!blink.mojom.PublicKeyCredentialParameters> } */
    this.browserBoundPubKeyCredParams;
    /** @export { !boolean } */
    this.showOptOut;
    /** @export { !Array<!payments.mojom.PaymentEntityLogo> } */
    this.paymentEntitiesLogos;
  }
};



mojo.internal.Struct(
    payments.mojom.NetworkOrIssuerInformationSpec.$,
    'NetworkOrIssuerInformation',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'icon', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
payments.mojom.NetworkOrIssuerInformation = class {
  constructor() {
    /** @export { !string } */
    this.name;
    /** @export { !url.mojom.Url } */
    this.icon;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentEntityLogoSpec.$,
    'PaymentEntityLogo',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'label', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
payments.mojom.PaymentEntityLogo = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !string } */
    this.label;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentMethodDataSpec.$,
    'PaymentMethodData',
    [
      mojo.internal.StructField(
        'supportedMethod', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'stringifiedData', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'environment', 16,
        0,
        payments.mojom.AndroidPayEnvironmentSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'minGooglePlayServicesVersion', 20,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'apiVersion', 24,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'supportedNetworks', 32,
        0,
        mojo.internal.Array(payments.mojom.BasicCardNetworkSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'securePaymentConfirmation', 40,
        0,
        payments.mojom.SecurePaymentConfirmationRequestSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);





/** @record */
payments.mojom.PaymentMethodData = class {
  constructor() {
    /** @export { !string } */
    this.supportedMethod;
    /** @export { !string } */
    this.stringifiedData;
    /** @export { !payments.mojom.AndroidPayEnvironment } */
    this.environment;
    /** @export { !number } */
    this.minGooglePlayServicesVersion;
    /** @export { !number } */
    this.apiVersion;
    /** @export { !Array<!payments.mojom.BasicCardNetwork> } */
    this.supportedNetworks;
    /** @export { (payments.mojom.SecurePaymentConfirmationRequest|undefined) } */
    this.securePaymentConfirmation;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentDetailsModifierSpec.$,
    'PaymentDetailsModifier',
    [
      mojo.internal.StructField(
        'total', 0,
        0,
        payments.mojom.PaymentItemSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'additionalDisplayItems', 8,
        0,
        mojo.internal.Array(payments.mojom.PaymentItemSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'methodData', 16,
        0,
        payments.mojom.PaymentMethodDataSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
payments.mojom.PaymentDetailsModifier = class {
  constructor() {
    /** @export { (payments.mojom.PaymentItem|undefined) } */
    this.total;
    /** @export { !Array<!payments.mojom.PaymentItem> } */
    this.additionalDisplayItems;
    /** @export { !payments.mojom.PaymentMethodData } */
    this.methodData;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentDetailsSpec.$,
    'PaymentDetails',
    [
      mojo.internal.StructField(
        'total', 0,
        0,
        payments.mojom.PaymentItemSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'displayItems', 8,
        0,
        mojo.internal.Array(payments.mojom.PaymentItemSpec.$, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'shippingOptions', 16,
        0,
        mojo.internal.Array(payments.mojom.PaymentShippingOptionSpec.$, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'modifiers', 24,
        0,
        mojo.internal.Array(payments.mojom.PaymentDetailsModifierSpec.$, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'error', 32,
        0,
        mojo.internal.String,
        "",
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'shippingAddressErrors', 40,
        0,
        payments.mojom.AddressErrorsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'id', 48,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'stringifiedPaymentMethodErrors', 56,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 72],]);





/** @record */
payments.mojom.PaymentDetails = class {
  constructor() {
    /** @export { (payments.mojom.PaymentItem|undefined) } */
    this.total;
    /** @export { (Array<!payments.mojom.PaymentItem>|undefined) } */
    this.displayItems;
    /** @export { (Array<!payments.mojom.PaymentShippingOption>|undefined) } */
    this.shippingOptions;
    /** @export { (Array<!payments.mojom.PaymentDetailsModifier>|undefined) } */
    this.modifiers;
    /** @export { !string } */
    this.error;
    /** @export { (payments.mojom.AddressErrors|undefined) } */
    this.shippingAddressErrors;
    /** @export { (string|undefined) } */
    this.id;
    /** @export { (string|undefined) } */
    this.stringifiedPaymentMethodErrors;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentOptionsSpec.$,
    'PaymentOptions',
    [
      mojo.internal.StructField(
        'requestPayerName', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requestPayerEmail', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requestPayerPhone', 0,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requestShipping', 0,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'shippingType', 4,
        0,
        payments.mojom.PaymentShippingTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
payments.mojom.PaymentOptions = class {
  constructor() {
    /** @export { !boolean } */
    this.requestPayerName;
    /** @export { !boolean } */
    this.requestPayerEmail;
    /** @export { !boolean } */
    this.requestPayerPhone;
    /** @export { !boolean } */
    this.requestShipping;
    /** @export { !payments.mojom.PaymentShippingType } */
    this.shippingType;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentRequestClient_OnPaymentMethodChange_ParamsSpec.$,
    'PaymentRequestClient_OnPaymentMethodChange_Params',
    [
      mojo.internal.StructField(
        'methodName', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'stringifiedDetails', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
payments.mojom.PaymentRequestClient_OnPaymentMethodChange_Params = class {
  constructor() {
    /** @export { !string } */
    this.methodName;
    /** @export { !string } */
    this.stringifiedDetails;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentRequestClient_OnShippingAddressChange_ParamsSpec.$,
    'PaymentRequestClient_OnShippingAddressChange_Params',
    [
      mojo.internal.StructField(
        'address', 0,
        0,
        payments.mojom.PaymentAddressSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
payments.mojom.PaymentRequestClient_OnShippingAddressChange_Params = class {
  constructor() {
    /** @export { !payments.mojom.PaymentAddress } */
    this.address;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentRequestClient_OnShippingOptionChange_ParamsSpec.$,
    'PaymentRequestClient_OnShippingOptionChange_Params',
    [
      mojo.internal.StructField(
        'shippingOptionId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
payments.mojom.PaymentRequestClient_OnShippingOptionChange_Params = class {
  constructor() {
    /** @export { !string } */
    this.shippingOptionId;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentRequestClient_OnPayerDetailChange_ParamsSpec.$,
    'PaymentRequestClient_OnPayerDetailChange_Params',
    [
      mojo.internal.StructField(
        'detail', 0,
        0,
        payments.mojom.PayerDetailSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
payments.mojom.PaymentRequestClient_OnPayerDetailChange_Params = class {
  constructor() {
    /** @export { !payments.mojom.PayerDetail } */
    this.detail;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentRequestClient_OnPaymentResponse_ParamsSpec.$,
    'PaymentRequestClient_OnPaymentResponse_Params',
    [
      mojo.internal.StructField(
        'response', 0,
        0,
        payments.mojom.PaymentResponseSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
payments.mojom.PaymentRequestClient_OnPaymentResponse_Params = class {
  constructor() {
    /** @export { !payments.mojom.PaymentResponse } */
    this.response;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentRequestClient_OnError_ParamsSpec.$,
    'PaymentRequestClient_OnError_Params',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        payments.mojom.PaymentErrorReasonSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'errorMessage', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
payments.mojom.PaymentRequestClient_OnError_Params = class {
  constructor() {
    /** @export { !payments.mojom.PaymentErrorReason } */
    this.error;
    /** @export { !string } */
    this.errorMessage;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentRequestClient_OnComplete_ParamsSpec.$,
    'PaymentRequestClient_OnComplete_Params',
    [
    ],
    [[0, 8],]);





/** @record */
payments.mojom.PaymentRequestClient_OnComplete_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentRequestClient_OnAbort_ParamsSpec.$,
    'PaymentRequestClient_OnAbort_Params',
    [
      mojo.internal.StructField(
        'abortedSuccessfully', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
payments.mojom.PaymentRequestClient_OnAbort_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.abortedSuccessfully;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentRequestClient_OnCanMakePayment_ParamsSpec.$,
    'PaymentRequestClient_OnCanMakePayment_Params',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        payments.mojom.CanMakePaymentQueryResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
payments.mojom.PaymentRequestClient_OnCanMakePayment_Params = class {
  constructor() {
    /** @export { !payments.mojom.CanMakePaymentQueryResult } */
    this.result;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentRequestClient_OnHasEnrolledInstrument_ParamsSpec.$,
    'PaymentRequestClient_OnHasEnrolledInstrument_Params',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        payments.mojom.HasEnrolledInstrumentQueryResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
payments.mojom.PaymentRequestClient_OnHasEnrolledInstrument_Params = class {
  constructor() {
    /** @export { !payments.mojom.HasEnrolledInstrumentQueryResult } */
    this.result;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentRequestClient_WarnNoFavicon_ParamsSpec.$,
    'PaymentRequestClient_WarnNoFavicon_Params',
    [
    ],
    [[0, 8],]);





/** @record */
payments.mojom.PaymentRequestClient_WarnNoFavicon_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentRequestClient_AllowConnectToSource_ParamsSpec.$,
    'PaymentRequestClient_AllowConnectToSource_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'urlBeforeRedirects', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'didFollowRedirect', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
payments.mojom.PaymentRequestClient_AllowConnectToSource_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !url.mojom.Url } */
    this.urlBeforeRedirects;
    /** @export { !boolean } */
    this.didFollowRedirect;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentRequestClient_AllowConnectToSource_ResponseParamsSpec.$,
    'PaymentRequestClient_AllowConnectToSource_ResponseParams',
    [
      mojo.internal.StructField(
        'allow', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
payments.mojom.PaymentRequestClient_AllowConnectToSource_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.allow;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentRequest_Init_ParamsSpec.$,
    'PaymentRequest_Init_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(payments.mojom.PaymentRequestClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'methodData', 8,
        0,
        mojo.internal.Array(payments.mojom.PaymentMethodDataSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'details', 16,
        0,
        payments.mojom.PaymentDetailsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'options', 24,
        0,
        payments.mojom.PaymentOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
payments.mojom.PaymentRequest_Init_Params = class {
  constructor() {
    /** @export { !payments.mojom.PaymentRequestClientRemote } */
    this.client;
    /** @export { !Array<!payments.mojom.PaymentMethodData> } */
    this.methodData;
    /** @export { !payments.mojom.PaymentDetails } */
    this.details;
    /** @export { !payments.mojom.PaymentOptions } */
    this.options;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentRequest_Show_ParamsSpec.$,
    'PaymentRequest_Show_Params',
    [
      mojo.internal.StructField(
        'waitForUpdatedDetails', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hadUserActivation', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
payments.mojom.PaymentRequest_Show_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.waitForUpdatedDetails;
    /** @export { !boolean } */
    this.hadUserActivation;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentRequest_UpdateWith_ParamsSpec.$,
    'PaymentRequest_UpdateWith_Params',
    [
      mojo.internal.StructField(
        'details', 0,
        0,
        payments.mojom.PaymentDetailsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
payments.mojom.PaymentRequest_UpdateWith_Params = class {
  constructor() {
    /** @export { !payments.mojom.PaymentDetails } */
    this.details;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentRequest_OnPaymentDetailsNotUpdated_ParamsSpec.$,
    'PaymentRequest_OnPaymentDetailsNotUpdated_Params',
    [
    ],
    [[0, 8],]);





/** @record */
payments.mojom.PaymentRequest_OnPaymentDetailsNotUpdated_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentRequest_Abort_ParamsSpec.$,
    'PaymentRequest_Abort_Params',
    [
    ],
    [[0, 8],]);





/** @record */
payments.mojom.PaymentRequest_Abort_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentRequest_Complete_ParamsSpec.$,
    'PaymentRequest_Complete_Params',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        payments.mojom.PaymentCompleteSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
payments.mojom.PaymentRequest_Complete_Params = class {
  constructor() {
    /** @export { !payments.mojom.PaymentComplete } */
    this.result;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentRequest_Retry_ParamsSpec.$,
    'PaymentRequest_Retry_Params',
    [
      mojo.internal.StructField(
        'errors', 0,
        0,
        payments.mojom.PaymentValidationErrorsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
payments.mojom.PaymentRequest_Retry_Params = class {
  constructor() {
    /** @export { !payments.mojom.PaymentValidationErrors } */
    this.errors;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentRequest_CanMakePayment_ParamsSpec.$,
    'PaymentRequest_CanMakePayment_Params',
    [
    ],
    [[0, 8],]);





/** @record */
payments.mojom.PaymentRequest_CanMakePayment_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentRequest_HasEnrolledInstrument_ParamsSpec.$,
    'PaymentRequest_HasEnrolledInstrument_Params',
    [
    ],
    [[0, 8],]);





/** @record */
payments.mojom.PaymentRequest_HasEnrolledInstrument_Params = class {
  constructor() {
  }
};

