// third_party/blink/public/mojom/page/prerender_page_param.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/page/prerender_page_param.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');



  function PrerenderParam(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PrerenderParam.prototype.initDefaults_ = function() {
    this.pageMetricSuffix = null;
    this.shouldWarmUpCompositor = false;
    this.shouldPreparePaintTree = false;
    this.shouldPauseJavascriptExecution = false;
  };
  PrerenderParam.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PrerenderParam.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PrerenderParam.pageMetricSuffix
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  PrerenderParam.encodedSize = codec.kStructHeaderSize + 16;

  PrerenderParam.decode = function(decoder) {
    var packed;
    var val = new PrerenderParam();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.pageMetricSuffix =
        decoder.decodeStruct(codec.String);
    packed = decoder.readUint8();
    val.shouldWarmUpCompositor = (packed >> 0) & 1 ? true : false;
    val.shouldPreparePaintTree = (packed >> 1) & 1 ? true : false;
    val.shouldPauseJavascriptExecution = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PrerenderParam.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PrerenderParam.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.pageMetricSuffix);
    packed = 0;
    packed |= (val.shouldWarmUpCompositor & 1) << 0
    packed |= (val.shouldPreparePaintTree & 1) << 1
    packed |= (val.shouldPauseJavascriptExecution & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  exports.PrerenderParam = PrerenderParam;
})();