// third_party/blink/public/mojom/page/draggable_region.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_DRAGGABLE_REGION_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_DRAGGABLE_REGION_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/page/draggable_region.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/page/draggable_region.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/page/draggable_region.mojom-blink-forward.h"  // IWYU pragma: export
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/renderer/core/core_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {








class CORE_EXPORT DraggableRegion {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DraggableRegion, T>::value>;
  using DataView = DraggableRegionDataView;
  using Data_ = internal::DraggableRegion_Data;

  template <typename... Args>
  static DraggableRegionPtr New(Args&&... args) {
    return DraggableRegionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DraggableRegionPtr From(const U& u) {
    return mojo::TypeConverter<DraggableRegionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DraggableRegion>::Convert(*this);
  }


  DraggableRegion();

  DraggableRegion(
      const ::gfx::Rect& bounds,
      bool draggable);


  ~DraggableRegion();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DraggableRegionPtr>
  DraggableRegionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DraggableRegion::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DraggableRegion::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DraggableRegion::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DraggableRegion::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DraggableRegion::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DraggableRegion::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DraggableRegion_UnserializedMessageContext<
            UserType, DraggableRegion::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DraggableRegion::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DraggableRegion::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DraggableRegion_UnserializedMessageContext<
            UserType, DraggableRegion::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DraggableRegion::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::Rect bounds;
  
  bool draggable;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DraggableRegion::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DraggableRegion::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DraggableRegion::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DraggableRegion::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
DraggableRegionPtr DraggableRegion::Clone() const {
  return New(
      mojo::Clone(bounds),
      mojo::Clone(draggable)
  );
}

template <typename T, DraggableRegion::EnableIfSame<T>*>
bool DraggableRegion::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->bounds, other_struct.bounds))
    return false;
  if (!mojo::Equals(this->draggable, other_struct.draggable))
    return false;
  return true;
}

template <typename T, DraggableRegion::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.bounds < rhs.bounds)
    return true;
  if (rhs.bounds < lhs.bounds)
    return false;
  if (lhs.draggable < rhs.draggable)
    return true;
  if (rhs.draggable < lhs.draggable)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct CORE_EXPORT StructTraits<::blink::mojom::blink::DraggableRegion::DataView,
                                         ::blink::mojom::blink::DraggableRegionPtr> {
  static bool IsNull(const ::blink::mojom::blink::DraggableRegionPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::DraggableRegionPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::DraggableRegion::bounds)& bounds(
      const ::blink::mojom::blink::DraggableRegionPtr& input) {
    return input->bounds;
  }

  static decltype(::blink::mojom::blink::DraggableRegion::draggable) draggable(
      const ::blink::mojom::blink::DraggableRegionPtr& input) {
    return input->draggable;
  }

  static bool Read(::blink::mojom::blink::DraggableRegion::DataView input, ::blink::mojom::blink::DraggableRegionPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_DRAGGABLE_REGION_MOJOM_BLINK_H_