// third_party/blink/public/mojom/origin_trials/origin_trial_state_host.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/origin_trials/origin_trial_state_host.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_state_host.mojom-params-data.h"
#include "third_party/blink/public/mojom/origin_trials/origin_trial_state_host.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_state_host.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/origin_trials/origin_trial_state_host.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
OriginTrialFeatureState::OriginTrialFeatureState()
    : is_enabled(),
      tokens() {}

OriginTrialFeatureState::OriginTrialFeatureState(
    bool is_enabled_in,
    ::blink::Vector<::blink::String> tokens_in)
    : is_enabled(std::move(is_enabled_in)),
      tokens(std::move(tokens_in)) {}

OriginTrialFeatureState::~OriginTrialFeatureState() = default;

void OriginTrialFeatureState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_enabled"), this->is_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tokens"), this->tokens,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::blink::String>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool OriginTrialFeatureState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

OriginTrialStateHost::IPCStableHashFunction OriginTrialStateHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::OriginTrialStateHost>(message.name())) {
    case messages::OriginTrialStateHost::kApplyFeatureDiffForOriginTrial: {
      return &OriginTrialStateHost::ApplyFeatureDiffForOriginTrial_Sym::IPCStableHash;
    }
    case messages::OriginTrialStateHost::kEnablePersistentTrial: {
      return &OriginTrialStateHost::EnablePersistentTrial_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* OriginTrialStateHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::OriginTrialStateHost>(message.name())) {
      case messages::OriginTrialStateHost::kApplyFeatureDiffForOriginTrial:
            return "Receive blink::mojom::OriginTrialStateHost::ApplyFeatureDiffForOriginTrial";
      case messages::OriginTrialStateHost::kEnablePersistentTrial:
            return "Receive blink::mojom::OriginTrialStateHost::EnablePersistentTrial";
    }
  } else {
    switch (static_cast<messages::OriginTrialStateHost>(message.name())) {
      case messages::OriginTrialStateHost::kApplyFeatureDiffForOriginTrial:
            return "Receive reply blink::mojom::OriginTrialStateHost::ApplyFeatureDiffForOriginTrial";
      case messages::OriginTrialStateHost::kEnablePersistentTrial:
            return "Receive reply blink::mojom::OriginTrialStateHost::EnablePersistentTrial";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t OriginTrialStateHost::ApplyFeatureDiffForOriginTrial_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x44f2d4b9;  // IPCStableHash for blink::mojom::OriginTrialStateHost::ApplyFeatureDiffForOriginTrial
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t OriginTrialStateHost::EnablePersistentTrial_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x36e07d76;  // IPCStableHash for blink::mojom::OriginTrialStateHost::EnablePersistentTrial
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

OriginTrialStateHostProxy::OriginTrialStateHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void OriginTrialStateHostProxy::ApplyFeatureDiffForOriginTrial(
    ::blink::HashMap<::blink::mojom::blink::RuntimeFeature, OriginTrialFeatureStatePtr> in_origin_trial_features) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::OriginTrialStateHost::ApplyFeatureDiffForOriginTrial", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin_trial_features"), in_origin_trial_features,
                        "<value of type ::blink::HashMap<::blink::mojom::blink::RuntimeFeature, OriginTrialFeatureStatePtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OriginTrialStateHost::kApplyFeatureDiffForOriginTrial), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::OriginTrialStateHost_ApplyFeatureDiffForOriginTrial_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origin_trial_features)::BaseType>
      origin_trial_features_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& origin_trial_features_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::RuntimeFeature_Data::Validate>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<::blink::mojom::RuntimeFeature, ::blink::mojom::OriginTrialFeatureStateDataView>>(
    in_origin_trial_features,
    origin_trial_features_fragment,
    &origin_trial_features_validate_params);

  params->origin_trial_features.Set(
      origin_trial_features_fragment.is_null() ? nullptr : origin_trial_features_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->origin_trial_features.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null origin_trial_features in OriginTrialStateHost.ApplyFeatureDiffForOriginTrial request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OriginTrialStateHost::Name_);
  message.set_method_name("ApplyFeatureDiffForOriginTrial");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void OriginTrialStateHostProxy::EnablePersistentTrial(
    const ::blink::String& in_token, const ::blink::Vector<::scoped_refptr<const ::blink::SecurityOrigin>>& in_script_origins) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::OriginTrialStateHost::EnablePersistentTrial", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("script_origins"), in_script_origins,
                        "<value of type const ::blink::Vector<::scoped_refptr<const ::blink::SecurityOrigin>>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OriginTrialStateHost::kEnablePersistentTrial), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::OriginTrialStateHost_EnablePersistentTrial_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->token)::BaseType> token_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_token,
    token_fragment);

  params->token.Set(
      token_fragment.is_null() ? nullptr : token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null token in OriginTrialStateHost.EnablePersistentTrial request");
  mojo::internal::MessageFragment<
      typename decltype(params->script_origins)::BaseType>
      script_origins_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& script_origins_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::OriginDataView>>(
    in_script_origins,
    script_origins_fragment,
    &script_origins_validate_params);

  params->script_origins.Set(
      script_origins_fragment.is_null() ? nullptr : script_origins_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->script_origins.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null script_origins in OriginTrialStateHost.EnablePersistentTrial request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OriginTrialStateHost::Name_);
  message.set_method_name("EnablePersistentTrial");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool OriginTrialStateHostStubDispatch::Accept(
    OriginTrialStateHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::OriginTrialStateHost>(message->header()->name)) {
    case messages::OriginTrialStateHost::kApplyFeatureDiffForOriginTrial: {
      DCHECK(message->is_serialized());
      internal::OriginTrialStateHost_ApplyFeatureDiffForOriginTrial_Params_Data* params =
          reinterpret_cast<internal::OriginTrialStateHost_ApplyFeatureDiffForOriginTrial_Params_Data*>(
              message->mutable_payload());
      

      // Validation for OriginTrialStateHost.0
      bool success = true;
      ::blink::HashMap<::blink::mojom::blink::RuntimeFeature, OriginTrialFeatureStatePtr> p_origin_trial_features{};
      OriginTrialStateHost_ApplyFeatureDiffForOriginTrial_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOriginTrialFeatures(&p_origin_trial_features))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OriginTrialStateHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ApplyFeatureDiffForOriginTrial(        
        std::move(p_origin_trial_features));
      return true;
    }
    case messages::OriginTrialStateHost::kEnablePersistentTrial: {
      DCHECK(message->is_serialized());
      internal::OriginTrialStateHost_EnablePersistentTrial_Params_Data* params =
          reinterpret_cast<internal::OriginTrialStateHost_EnablePersistentTrial_Params_Data*>(
              message->mutable_payload());
      

      // Validation for OriginTrialStateHost.1
      bool success = true;
      ::blink::String p_token{};
      ::blink::Vector<::scoped_refptr<const ::blink::SecurityOrigin>> p_script_origins{};
      OriginTrialStateHost_EnablePersistentTrial_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadToken(&p_token))
        success = false;
      if (success && !input_data_view.ReadScriptOrigins(&p_script_origins))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OriginTrialStateHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnablePersistentTrial(        
        std::move(p_token), 
        std::move(p_script_origins));
      return true;
    }
  }
  return false;
}

// static
bool OriginTrialStateHostStubDispatch::AcceptWithResponder(
    OriginTrialStateHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::OriginTrialStateHost>(message->header()->name)) {
    case messages::OriginTrialStateHost::kApplyFeatureDiffForOriginTrial: {
      break;
    }
    case messages::OriginTrialStateHost::kEnablePersistentTrial: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kOriginTrialStateHostValidationInfo[] = {
    { &internal::OriginTrialStateHost_ApplyFeatureDiffForOriginTrial_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::OriginTrialStateHost_EnablePersistentTrial_Params_Data::Validate,
     nullptr /* no response */},
};

bool OriginTrialStateHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::OriginTrialStateHost::Name_,
    kOriginTrialStateHostValidationInfo);
}



}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::OriginTrialFeatureState::DataView, ::blink::mojom::blink::OriginTrialFeatureStatePtr>::Read(
    ::blink::mojom::blink::OriginTrialFeatureState::DataView input,
    ::blink::mojom::blink::OriginTrialFeatureStatePtr* output) {
  bool success = true;
  ::blink::mojom::blink::OriginTrialFeatureStatePtr result(::blink::mojom::blink::OriginTrialFeatureState::New());
  
      if (success)
        result->is_enabled = input.is_enabled();
      if (success && !input.ReadTokens(&result->tokens))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void OriginTrialStateHostInterceptorForTesting::ApplyFeatureDiffForOriginTrial(::blink::HashMap<::blink::mojom::blink::RuntimeFeature, OriginTrialFeatureStatePtr> origin_trial_features) {
  GetForwardingInterface()->ApplyFeatureDiffForOriginTrial(
    std::move(origin_trial_features)
    );
}
void OriginTrialStateHostInterceptorForTesting::EnablePersistentTrial(const ::blink::String& token, const ::blink::Vector<::scoped_refptr<const ::blink::SecurityOrigin>>& script_origins) {
  GetForwardingInterface()->EnablePersistentTrial(
    std::move(token)
    , 
    std::move(script_origins)
    );
}
OriginTrialStateHostAsyncWaiter::OriginTrialStateHostAsyncWaiter(
    OriginTrialStateHost* proxy) : proxy_(proxy) {}

OriginTrialStateHostAsyncWaiter::~OriginTrialStateHostAsyncWaiter() = default;







}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif