// third_party/blink/public/mojom/on_device_translation/translator.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/on_device_translation/translator.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var model_streaming_responder$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/ai/model_streaming_responder.mojom', '../ai/model_streaming_responder.mojom.js');
  }



  function Translator_Translate_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Translator_Translate_Params.prototype.initDefaults_ = function() {
    this.input = null;
    this.pendingResponder = new model_streaming_responder$.ModelStreamingResponderPtr();
  };
  Translator_Translate_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Translator_Translate_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Translator_Translate_Params.input
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate Translator_Translate_Params.pendingResponder
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 8, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Translator_Translate_Params.encodedSize = codec.kStructHeaderSize + 16;

  Translator_Translate_Params.decode = function(decoder) {
    var packed;
    var val = new Translator_Translate_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.input =
        decoder.decodeStruct(codec.String);
    val.pendingResponder =
        decoder.decodeStruct(new codec.Interface(model_streaming_responder$.ModelStreamingResponderPtr));
    return val;
  };

  Translator_Translate_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Translator_Translate_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.input);
    encoder.encodeStruct(new codec.Interface(model_streaming_responder$.ModelStreamingResponderPtr), val.pendingResponder);
  };
  function Translator_TranslateStreaming_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Translator_TranslateStreaming_Params.prototype.initDefaults_ = function() {
    this.input = null;
    this.pendingResponder = new model_streaming_responder$.ModelStreamingResponderPtr();
  };
  Translator_TranslateStreaming_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Translator_TranslateStreaming_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Translator_TranslateStreaming_Params.input
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate Translator_TranslateStreaming_Params.pendingResponder
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 8, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Translator_TranslateStreaming_Params.encodedSize = codec.kStructHeaderSize + 16;

  Translator_TranslateStreaming_Params.decode = function(decoder) {
    var packed;
    var val = new Translator_TranslateStreaming_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.input =
        decoder.decodeStruct(codec.String);
    val.pendingResponder =
        decoder.decodeStruct(new codec.Interface(model_streaming_responder$.ModelStreamingResponderPtr));
    return val;
  };

  Translator_TranslateStreaming_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Translator_TranslateStreaming_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.input);
    encoder.encodeStruct(new codec.Interface(model_streaming_responder$.ModelStreamingResponderPtr), val.pendingResponder);
  };
  var kTranslator_Translate_Name = 0;
  var kTranslator_TranslateStreaming_Name = 1;

  function TranslatorPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(Translator,
                                                   handleOrPtrInfo);
  }

  function TranslatorAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        Translator, associatedInterfacePtrInfo);
  }

  TranslatorAssociatedPtr.prototype =
      Object.create(TranslatorPtr.prototype);
  TranslatorAssociatedPtr.prototype.constructor =
      TranslatorAssociatedPtr;

  function TranslatorProxy(receiver) {
    this.receiver_ = receiver;
  }
  TranslatorPtr.prototype.translate = function() {
    return TranslatorProxy.prototype.translate
        .apply(this.ptr.getProxy(), arguments);
  };

  TranslatorProxy.prototype.translate = function(input, pendingResponder) {
    var params_ = new Translator_Translate_Params();
    params_.input = input;
    params_.pendingResponder = pendingResponder;
    var builder = new codec.MessageV0Builder(
        kTranslator_Translate_Name,
        codec.align(Translator_Translate_Params.encodedSize));
    builder.encodeStruct(Translator_Translate_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  TranslatorPtr.prototype.translateStreaming = function() {
    return TranslatorProxy.prototype.translateStreaming
        .apply(this.ptr.getProxy(), arguments);
  };

  TranslatorProxy.prototype.translateStreaming = function(input, pendingResponder) {
    var params_ = new Translator_TranslateStreaming_Params();
    params_.input = input;
    params_.pendingResponder = pendingResponder;
    var builder = new codec.MessageV0Builder(
        kTranslator_TranslateStreaming_Name,
        codec.align(Translator_TranslateStreaming_Params.encodedSize));
    builder.encodeStruct(Translator_TranslateStreaming_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function TranslatorStub(delegate) {
    this.delegate_ = delegate;
  }
  TranslatorStub.prototype.translate = function(input, pendingResponder) {
    return this.delegate_ && this.delegate_.translate && this.delegate_.translate(input, pendingResponder);
  }
  TranslatorStub.prototype.translateStreaming = function(input, pendingResponder) {
    return this.delegate_ && this.delegate_.translateStreaming && this.delegate_.translateStreaming(input, pendingResponder);
  }

  TranslatorStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kTranslator_Translate_Name:
      var params = reader.decodeStruct(Translator_Translate_Params);
      this.translate(params.input, params.pendingResponder);
      return true;
    case kTranslator_TranslateStreaming_Name:
      var params = reader.decodeStruct(Translator_TranslateStreaming_Params);
      this.translateStreaming(params.input, params.pendingResponder);
      return true;
    default:
      return false;
    }
  };

  TranslatorStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateTranslatorRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kTranslator_Translate_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = Translator_Translate_Params;
      break;
      case kTranslator_TranslateStreaming_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = Translator_TranslateStreaming_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateTranslatorResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var Translator = {
    name: 'blink.mojom.Translator',
    kVersion: 0,
    ptrClass: TranslatorPtr,
    proxyClass: TranslatorProxy,
    stubClass: TranslatorStub,
    validateRequest: validateTranslatorRequest,
    validateResponse: null,
  };
  TranslatorStub.prototype.validator = validateTranslatorRequest;
  TranslatorProxy.prototype.validator = null;
  exports.Translator = Translator;
  exports.TranslatorPtr = TranslatorPtr;
  exports.TranslatorAssociatedPtr = TranslatorAssociatedPtr;
})();