// third_party/blink/public/mojom/on_device_translation/translator.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/on_device_translation/translator.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/on_device_translation/translator.mojom-params-data.h"
#include "third_party/blink/public/mojom/on_device_translation/translator.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/on_device_translation/translator.mojom-import-headers.h"
#include "third_party/blink/public/mojom/on_device_translation/translator.mojom-test-utils.h"


namespace blink::mojom {
// The declaration includes the definition on other builds.

Translator::IPCStableHashFunction Translator::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Translator>(message.name())) {
    case messages::Translator::kTranslate: {
      return &Translator::Translate_Sym::IPCStableHash;
    }
    case messages::Translator::kTranslateStreaming: {
      return &Translator::TranslateStreaming_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Translator::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Translator>(message.name())) {
      case messages::Translator::kTranslate:
            return "Receive blink::mojom::Translator::Translate";
      case messages::Translator::kTranslateStreaming:
            return "Receive blink::mojom::Translator::TranslateStreaming";
    }
  } else {
    switch (static_cast<messages::Translator>(message.name())) {
      case messages::Translator::kTranslate:
            return "Receive reply blink::mojom::Translator::Translate";
      case messages::Translator::kTranslateStreaming:
            return "Receive reply blink::mojom::Translator::TranslateStreaming";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Translator::Translate_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x73ad5035;  // IPCStableHash for blink::mojom::Translator::Translate
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Translator::TranslateStreaming_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x99f86d59;  // IPCStableHash for blink::mojom::Translator::TranslateStreaming
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

TranslatorProxy::TranslatorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TranslatorProxy::Translate(
    const std::string& in_input, ::mojo::PendingRemote<::blink::mojom::ModelStreamingResponder> in_pending_responder) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::Translator::Translate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("input"), in_input,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pending_responder"), in_pending_responder,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::ModelStreamingResponder>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Translator::kTranslate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Translator_Translate_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->input)::BaseType> input_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_input,
    input_fragment);

  params->input.Set(
      input_fragment.is_null() ? nullptr : input_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->input.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null input in Translator.Translate request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::ModelStreamingResponderInterfaceBase>>(
    in_pending_responder,
    &params->pending_responder,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->pending_responder)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid pending_responder in Translator.Translate request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Translator::Name_);
  message.set_method_name("Translate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void TranslatorProxy::TranslateStreaming(
    const std::string& in_input, ::mojo::PendingRemote<::blink::mojom::ModelStreamingResponder> in_pending_responder) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::Translator::TranslateStreaming", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("input"), in_input,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pending_responder"), in_pending_responder,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::ModelStreamingResponder>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Translator::kTranslateStreaming), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Translator_TranslateStreaming_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->input)::BaseType> input_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_input,
    input_fragment);

  params->input.Set(
      input_fragment.is_null() ? nullptr : input_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->input.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null input in Translator.TranslateStreaming request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::ModelStreamingResponderInterfaceBase>>(
    in_pending_responder,
    &params->pending_responder,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->pending_responder)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid pending_responder in Translator.TranslateStreaming request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Translator::Name_);
  message.set_method_name("TranslateStreaming");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool TranslatorStubDispatch::Accept(
    Translator* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Translator>(message->header()->name)) {
    case messages::Translator::kTranslate: {
      DCHECK(message->is_serialized());
      internal::Translator_Translate_Params_Data* params =
          reinterpret_cast<internal::Translator_Translate_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Translator.0
      bool success = true;
      std::string p_input{};
      ::mojo::PendingRemote<::blink::mojom::ModelStreamingResponder> p_pending_responder{};
      Translator_Translate_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInput(&p_input))
        success = false;
      if (success) {
        p_pending_responder =
            input_data_view.TakePendingResponder<decltype(p_pending_responder)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Translator::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Translate(        
        std::move(p_input), 
        std::move(p_pending_responder));
      return true;
    }
    case messages::Translator::kTranslateStreaming: {
      DCHECK(message->is_serialized());
      internal::Translator_TranslateStreaming_Params_Data* params =
          reinterpret_cast<internal::Translator_TranslateStreaming_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Translator.1
      bool success = true;
      std::string p_input{};
      ::mojo::PendingRemote<::blink::mojom::ModelStreamingResponder> p_pending_responder{};
      Translator_TranslateStreaming_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInput(&p_input))
        success = false;
      if (success) {
        p_pending_responder =
            input_data_view.TakePendingResponder<decltype(p_pending_responder)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Translator::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TranslateStreaming(        
        std::move(p_input), 
        std::move(p_pending_responder));
      return true;
    }
  }
  return false;
}

// static
bool TranslatorStubDispatch::AcceptWithResponder(
    Translator* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Translator>(message->header()->name)) {
    case messages::Translator::kTranslate: {
      break;
    }
    case messages::Translator::kTranslateStreaming: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kTranslatorValidationInfo[] = {
    { &internal::Translator_Translate_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Translator_TranslateStreaming_Params_Data::Validate,
     nullptr /* no response */},
};

bool TranslatorRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::Translator::Name_,
    kTranslatorValidationInfo);
}



}  // blink::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void TranslatorInterceptorForTesting::Translate(const std::string& input, ::mojo::PendingRemote<::blink::mojom::ModelStreamingResponder> pending_responder) {
  GetForwardingInterface()->Translate(
    std::move(input)
    , 
    std::move(pending_responder)
    );
}
void TranslatorInterceptorForTesting::TranslateStreaming(const std::string& input, ::mojo::PendingRemote<::blink::mojom::ModelStreamingResponder> pending_responder) {
  GetForwardingInterface()->TranslateStreaming(
    std::move(input)
    , 
    std::move(pending_responder)
    );
}
TranslatorAsyncWaiter::TranslatorAsyncWaiter(
    Translator* proxy) : proxy_(proxy) {}

TranslatorAsyncWaiter::~TranslatorAsyncWaiter() = default;







}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif