// third_party/blink/public/mojom/notifications/notification_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/notifications/notification_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/notifications/notification_service.mojom-params-data.h"
#include "third_party/blink/public/mojom/notifications/notification_service.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/notifications/notification_service.mojom-import-headers.h"
#include "third_party/blink/public/mojom/notifications/notification_service.mojom-test-utils.h"


namespace blink::mojom {
// The declaration includes the definition on other builds.

NonPersistentNotificationListener::IPCStableHashFunction NonPersistentNotificationListener::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::NonPersistentNotificationListener>(message.name())) {
    case messages::NonPersistentNotificationListener::kOnShow: {
      return &NonPersistentNotificationListener::OnShow_Sym::IPCStableHash;
    }
    case messages::NonPersistentNotificationListener::kOnClick: {
      return &NonPersistentNotificationListener::OnClick_Sym::IPCStableHash;
    }
    case messages::NonPersistentNotificationListener::kOnClose: {
      return &NonPersistentNotificationListener::OnClose_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* NonPersistentNotificationListener::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::NonPersistentNotificationListener>(message.name())) {
      case messages::NonPersistentNotificationListener::kOnShow:
            return "Receive blink::mojom::NonPersistentNotificationListener::OnShow";
      case messages::NonPersistentNotificationListener::kOnClick:
            return "Receive blink::mojom::NonPersistentNotificationListener::OnClick";
      case messages::NonPersistentNotificationListener::kOnClose:
            return "Receive blink::mojom::NonPersistentNotificationListener::OnClose";
    }
  } else {
    switch (static_cast<messages::NonPersistentNotificationListener>(message.name())) {
      case messages::NonPersistentNotificationListener::kOnShow:
            return "Receive reply blink::mojom::NonPersistentNotificationListener::OnShow";
      case messages::NonPersistentNotificationListener::kOnClick:
            return "Receive reply blink::mojom::NonPersistentNotificationListener::OnClick";
      case messages::NonPersistentNotificationListener::kOnClose:
            return "Receive reply blink::mojom::NonPersistentNotificationListener::OnClose";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t NonPersistentNotificationListener::OnShow_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x71b2bafc;  // IPCStableHash for blink::mojom::NonPersistentNotificationListener::OnShow
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NonPersistentNotificationListener::OnClick_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0e00156a;  // IPCStableHash for blink::mojom::NonPersistentNotificationListener::OnClick
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NonPersistentNotificationListener::OnClose_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6cb431f4;  // IPCStableHash for blink::mojom::NonPersistentNotificationListener::OnClose
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class NonPersistentNotificationListener_OnClick_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NonPersistentNotificationListener_OnClick_ForwardToCallback(
      NonPersistentNotificationListener::OnClickCallback callback
      ) : callback_(std::move(callback)) {
  }

  NonPersistentNotificationListener_OnClick_ForwardToCallback(const NonPersistentNotificationListener_OnClick_ForwardToCallback&) = delete;
  NonPersistentNotificationListener_OnClick_ForwardToCallback& operator=(const NonPersistentNotificationListener_OnClick_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NonPersistentNotificationListener::OnClickCallback callback_;
};

class NonPersistentNotificationListener_OnClose_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NonPersistentNotificationListener_OnClose_ForwardToCallback(
      NonPersistentNotificationListener::OnCloseCallback callback
      ) : callback_(std::move(callback)) {
  }

  NonPersistentNotificationListener_OnClose_ForwardToCallback(const NonPersistentNotificationListener_OnClose_ForwardToCallback&) = delete;
  NonPersistentNotificationListener_OnClose_ForwardToCallback& operator=(const NonPersistentNotificationListener_OnClose_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NonPersistentNotificationListener::OnCloseCallback callback_;
};

NonPersistentNotificationListenerProxy::NonPersistentNotificationListenerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NonPersistentNotificationListenerProxy::OnShow(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::NonPersistentNotificationListener::OnShow");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NonPersistentNotificationListener::kOnShow), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::NonPersistentNotificationListener_OnShow_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NonPersistentNotificationListener::Name_);
  message.set_method_name("OnShow");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NonPersistentNotificationListenerProxy::OnClick(
    OnClickCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::NonPersistentNotificationListener::OnClick");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NonPersistentNotificationListener::kOnClick), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::NonPersistentNotificationListener_OnClick_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NonPersistentNotificationListener::Name_);
  message.set_method_name("OnClick");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NonPersistentNotificationListener_OnClick_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NonPersistentNotificationListenerProxy::OnClose(
    OnCloseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::NonPersistentNotificationListener::OnClose");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NonPersistentNotificationListener::kOnClose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::NonPersistentNotificationListener_OnClose_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NonPersistentNotificationListener::Name_);
  message.set_method_name("OnClose");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NonPersistentNotificationListener_OnClose_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class NonPersistentNotificationListener_OnClick_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NonPersistentNotificationListener::OnClickCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NonPersistentNotificationListener_OnClick_ProxyToResponder> proxy(
        new NonPersistentNotificationListener_OnClick_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NonPersistentNotificationListener_OnClick_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NonPersistentNotificationListener_OnClick_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NonPersistentNotificationListener_OnClick_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "NonPersistentNotificationListener::OnClickCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NonPersistentNotificationListener_OnClick_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NonPersistentNotificationListener_OnClick_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NonPersistentNotificationListener_OnClick_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NonPersistentNotificationListener.1
  bool success = true;
  NonPersistentNotificationListener_OnClick_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NonPersistentNotificationListener::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NonPersistentNotificationListener_OnClick_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply blink::mojom::NonPersistentNotificationListener::OnClick");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NonPersistentNotificationListener::kOnClick), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::NonPersistentNotificationListener_OnClick_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NonPersistentNotificationListener::Name_);
  message.set_method_name("OnClick");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NonPersistentNotificationListener_OnClose_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NonPersistentNotificationListener::OnCloseCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NonPersistentNotificationListener_OnClose_ProxyToResponder> proxy(
        new NonPersistentNotificationListener_OnClose_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NonPersistentNotificationListener_OnClose_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NonPersistentNotificationListener_OnClose_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NonPersistentNotificationListener_OnClose_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "NonPersistentNotificationListener::OnCloseCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NonPersistentNotificationListener_OnClose_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NonPersistentNotificationListener_OnClose_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NonPersistentNotificationListener_OnClose_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NonPersistentNotificationListener.2
  bool success = true;
  NonPersistentNotificationListener_OnClose_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NonPersistentNotificationListener::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NonPersistentNotificationListener_OnClose_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply blink::mojom::NonPersistentNotificationListener::OnClose");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NonPersistentNotificationListener::kOnClose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::NonPersistentNotificationListener_OnClose_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NonPersistentNotificationListener::Name_);
  message.set_method_name("OnClose");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool NonPersistentNotificationListenerStubDispatch::Accept(
    NonPersistentNotificationListener* impl,
    mojo::Message* message) {
  switch (static_cast<messages::NonPersistentNotificationListener>(message->header()->name)) {
    case messages::NonPersistentNotificationListener::kOnShow: {
      DCHECK(message->is_serialized());
      internal::NonPersistentNotificationListener_OnShow_Params_Data* params =
          reinterpret_cast<internal::NonPersistentNotificationListener_OnShow_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NonPersistentNotificationListener.0
      bool success = true;
      NonPersistentNotificationListener_OnShow_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NonPersistentNotificationListener::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnShow(        );
      return true;
    }
    case messages::NonPersistentNotificationListener::kOnClick: {
      break;
    }
    case messages::NonPersistentNotificationListener::kOnClose: {
      break;
    }
  }
  return false;
}

// static
bool NonPersistentNotificationListenerStubDispatch::AcceptWithResponder(
    NonPersistentNotificationListener* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::NonPersistentNotificationListener>(message->header()->name)) {
    case messages::NonPersistentNotificationListener::kOnShow: {
      break;
    }
    case messages::NonPersistentNotificationListener::kOnClick: {
      internal::NonPersistentNotificationListener_OnClick_Params_Data* params =
          reinterpret_cast<
              internal::NonPersistentNotificationListener_OnClick_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NonPersistentNotificationListener.1
      bool success = true;
      NonPersistentNotificationListener_OnClick_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NonPersistentNotificationListener::Name_, 1, false);
        return false;
      }
      auto callback =
          NonPersistentNotificationListener_OnClick_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnClick(std::move(callback));
      return true;
    }
    case messages::NonPersistentNotificationListener::kOnClose: {
      internal::NonPersistentNotificationListener_OnClose_Params_Data* params =
          reinterpret_cast<
              internal::NonPersistentNotificationListener_OnClose_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NonPersistentNotificationListener.2
      bool success = true;
      NonPersistentNotificationListener_OnClose_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NonPersistentNotificationListener::Name_, 2, false);
        return false;
      }
      auto callback =
          NonPersistentNotificationListener_OnClose_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnClose(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kNonPersistentNotificationListenerValidationInfo[] = {
    { &internal::NonPersistentNotificationListener_OnShow_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NonPersistentNotificationListener_OnClick_Params_Data::Validate,
     &internal::NonPersistentNotificationListener_OnClick_ResponseParams_Data::Validate},
    { &internal::NonPersistentNotificationListener_OnClose_Params_Data::Validate,
     &internal::NonPersistentNotificationListener_OnClose_ResponseParams_Data::Validate},
};

bool NonPersistentNotificationListenerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::NonPersistentNotificationListener::Name_,
    kNonPersistentNotificationListenerValidationInfo);
}

bool NonPersistentNotificationListenerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::NonPersistentNotificationListener::Name_,
    kNonPersistentNotificationListenerValidationInfo);
}
// The declaration includes the definition on other builds.

NotificationService::IPCStableHashFunction NotificationService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::NotificationService>(message.name())) {
    case messages::NotificationService::kGetPermissionStatus: {
      return &NotificationService::GetPermissionStatus_Sym::IPCStableHash;
    }
    case messages::NotificationService::kDisplayNonPersistentNotification: {
      return &NotificationService::DisplayNonPersistentNotification_Sym::IPCStableHash;
    }
    case messages::NotificationService::kCloseNonPersistentNotification: {
      return &NotificationService::CloseNonPersistentNotification_Sym::IPCStableHash;
    }
    case messages::NotificationService::kDisplayPersistentNotification: {
      return &NotificationService::DisplayPersistentNotification_Sym::IPCStableHash;
    }
    case messages::NotificationService::kClosePersistentNotification: {
      return &NotificationService::ClosePersistentNotification_Sym::IPCStableHash;
    }
    case messages::NotificationService::kGetNotifications: {
      return &NotificationService::GetNotifications_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* NotificationService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::NotificationService>(message.name())) {
      case messages::NotificationService::kGetPermissionStatus:
            return "Receive blink::mojom::NotificationService::GetPermissionStatus";
      case messages::NotificationService::kDisplayNonPersistentNotification:
            return "Receive blink::mojom::NotificationService::DisplayNonPersistentNotification";
      case messages::NotificationService::kCloseNonPersistentNotification:
            return "Receive blink::mojom::NotificationService::CloseNonPersistentNotification";
      case messages::NotificationService::kDisplayPersistentNotification:
            return "Receive blink::mojom::NotificationService::DisplayPersistentNotification";
      case messages::NotificationService::kClosePersistentNotification:
            return "Receive blink::mojom::NotificationService::ClosePersistentNotification";
      case messages::NotificationService::kGetNotifications:
            return "Receive blink::mojom::NotificationService::GetNotifications";
    }
  } else {
    switch (static_cast<messages::NotificationService>(message.name())) {
      case messages::NotificationService::kGetPermissionStatus:
            return "Receive reply blink::mojom::NotificationService::GetPermissionStatus";
      case messages::NotificationService::kDisplayNonPersistentNotification:
            return "Receive reply blink::mojom::NotificationService::DisplayNonPersistentNotification";
      case messages::NotificationService::kCloseNonPersistentNotification:
            return "Receive reply blink::mojom::NotificationService::CloseNonPersistentNotification";
      case messages::NotificationService::kDisplayPersistentNotification:
            return "Receive reply blink::mojom::NotificationService::DisplayPersistentNotification";
      case messages::NotificationService::kClosePersistentNotification:
            return "Receive reply blink::mojom::NotificationService::ClosePersistentNotification";
      case messages::NotificationService::kGetNotifications:
            return "Receive reply blink::mojom::NotificationService::GetNotifications";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t NotificationService::GetPermissionStatus_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xec5cc462;  // IPCStableHash for blink::mojom::NotificationService::GetPermissionStatus
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NotificationService::DisplayNonPersistentNotification_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf3690888;  // IPCStableHash for blink::mojom::NotificationService::DisplayNonPersistentNotification
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NotificationService::CloseNonPersistentNotification_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6c1e68e5;  // IPCStableHash for blink::mojom::NotificationService::CloseNonPersistentNotification
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NotificationService::DisplayPersistentNotification_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xae273260;  // IPCStableHash for blink::mojom::NotificationService::DisplayPersistentNotification
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NotificationService::ClosePersistentNotification_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x885877ae;  // IPCStableHash for blink::mojom::NotificationService::ClosePersistentNotification
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NotificationService::GetNotifications_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6580588f;  // IPCStableHash for blink::mojom::NotificationService::GetNotifications
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool NotificationService::GetPermissionStatus(::blink::mojom::PermissionStatus* out_status) {
  NOTREACHED();
}
class NotificationService_GetPermissionStatus_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NotificationService_GetPermissionStatus_HandleSyncResponse(
      bool* result, ::blink::mojom::PermissionStatus* out_status)
      : result_(result), out_status_(out_status) {
    DCHECK(!*result_);
  }

  NotificationService_GetPermissionStatus_HandleSyncResponse(const NotificationService_GetPermissionStatus_HandleSyncResponse&) = delete;
  NotificationService_GetPermissionStatus_HandleSyncResponse& operator=(const NotificationService_GetPermissionStatus_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::blink::mojom::PermissionStatus* out_status_;};

class NotificationService_GetPermissionStatus_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NotificationService_GetPermissionStatus_ForwardToCallback(
      NotificationService::GetPermissionStatusCallback callback
      ) : callback_(std::move(callback)) {
  }

  NotificationService_GetPermissionStatus_ForwardToCallback(const NotificationService_GetPermissionStatus_ForwardToCallback&) = delete;
  NotificationService_GetPermissionStatus_ForwardToCallback& operator=(const NotificationService_GetPermissionStatus_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NotificationService::GetPermissionStatusCallback callback_;
};

class NotificationService_DisplayPersistentNotification_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NotificationService_DisplayPersistentNotification_ForwardToCallback(
      NotificationService::DisplayPersistentNotificationCallback callback
      ) : callback_(std::move(callback)) {
  }

  NotificationService_DisplayPersistentNotification_ForwardToCallback(const NotificationService_DisplayPersistentNotification_ForwardToCallback&) = delete;
  NotificationService_DisplayPersistentNotification_ForwardToCallback& operator=(const NotificationService_DisplayPersistentNotification_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NotificationService::DisplayPersistentNotificationCallback callback_;
};

class NotificationService_GetNotifications_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NotificationService_GetNotifications_ForwardToCallback(
      NotificationService::GetNotificationsCallback callback
      ) : callback_(std::move(callback)) {
  }

  NotificationService_GetNotifications_ForwardToCallback(const NotificationService_GetNotifications_ForwardToCallback&) = delete;
  NotificationService_GetNotifications_ForwardToCallback& operator=(const NotificationService_GetNotifications_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NotificationService::GetNotificationsCallback callback_;
};

NotificationServiceProxy::NotificationServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool NotificationServiceProxy::GetPermissionStatus(
    ::blink::mojom::PermissionStatus* out_param_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call blink::mojom::NotificationService::GetPermissionStatus (sync)");
#else
  TRACE_EVENT0("mojom", "NotificationService::GetPermissionStatus");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NotificationService::kGetPermissionStatus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::NotificationService_GetPermissionStatus_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NotificationService::Name_);
  message.set_method_name("GetPermissionStatus");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NotificationService_GetPermissionStatus_HandleSyncResponse(
          &result, out_param_status));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "NotificationService::GetPermissionStatus", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), out_param_status,
                        "<value of type ::blink::mojom::PermissionStatus>");
   });
#endif
  return result;
}

void NotificationServiceProxy::GetPermissionStatus(
    GetPermissionStatusCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::NotificationService::GetPermissionStatus");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NotificationService::kGetPermissionStatus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::NotificationService_GetPermissionStatus_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NotificationService::Name_);
  message.set_method_name("GetPermissionStatus");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NotificationService_GetPermissionStatus_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NotificationServiceProxy::DisplayNonPersistentNotification(
    const std::string& in_token, const ::blink::PlatformNotificationData& in_notification_data, const ::blink::NotificationResources& in_notification_resources, ::mojo::PendingRemote<NonPersistentNotificationListener> in_event_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::NotificationService::DisplayNonPersistentNotification", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("notification_data"), in_notification_data,
                        "<value of type const ::blink::PlatformNotificationData&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("notification_resources"), in_notification_resources,
                        "<value of type const ::blink::NotificationResources&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_listener"), in_event_listener,
                        "<value of type ::mojo::PendingRemote<NonPersistentNotificationListener>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NotificationService::kDisplayNonPersistentNotification), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::NotificationService_DisplayNonPersistentNotification_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->token)::BaseType> token_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_token,
    token_fragment);

  params->token.Set(
      token_fragment.is_null() ? nullptr : token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null token in NotificationService.DisplayNonPersistentNotification request");
  mojo::internal::MessageFragment<
      typename decltype(params->notification_data)::BaseType> notification_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::NotificationDataDataView>(
    in_notification_data,
    notification_data_fragment);

  params->notification_data.Set(
      notification_data_fragment.is_null() ? nullptr : notification_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->notification_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null notification_data in NotificationService.DisplayNonPersistentNotification request");
  mojo::internal::MessageFragment<
      typename decltype(params->notification_resources)::BaseType> notification_resources_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::NotificationResourcesDataView>(
    in_notification_resources,
    notification_resources_fragment);

  params->notification_resources.Set(
      notification_resources_fragment.is_null() ? nullptr : notification_resources_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->notification_resources.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null notification_resources in NotificationService.DisplayNonPersistentNotification request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::NonPersistentNotificationListenerInterfaceBase>>(
    in_event_listener,
    &params->event_listener,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->event_listener)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid event_listener in NotificationService.DisplayNonPersistentNotification request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NotificationService::Name_);
  message.set_method_name("DisplayNonPersistentNotification");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NotificationServiceProxy::CloseNonPersistentNotification(
    const std::string& in_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::NotificationService::CloseNonPersistentNotification", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NotificationService::kCloseNonPersistentNotification), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::NotificationService_CloseNonPersistentNotification_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->token)::BaseType> token_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_token,
    token_fragment);

  params->token.Set(
      token_fragment.is_null() ? nullptr : token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null token in NotificationService.CloseNonPersistentNotification request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NotificationService::Name_);
  message.set_method_name("CloseNonPersistentNotification");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NotificationServiceProxy::DisplayPersistentNotification(
    int64_t in_service_worker_registration_id, const ::blink::PlatformNotificationData& in_notification_data, const ::blink::NotificationResources& in_notification_resources, DisplayPersistentNotificationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::NotificationService::DisplayPersistentNotification", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_registration_id"), in_service_worker_registration_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("notification_data"), in_notification_data,
                        "<value of type const ::blink::PlatformNotificationData&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("notification_resources"), in_notification_resources,
                        "<value of type const ::blink::NotificationResources&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NotificationService::kDisplayPersistentNotification), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::NotificationService_DisplayPersistentNotification_Params_Data> params(
          message);
  params.Allocate();

  params->service_worker_registration_id = in_service_worker_registration_id;
  mojo::internal::MessageFragment<
      typename decltype(params->notification_data)::BaseType> notification_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::NotificationDataDataView>(
    in_notification_data,
    notification_data_fragment);

  params->notification_data.Set(
      notification_data_fragment.is_null() ? nullptr : notification_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->notification_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null notification_data in NotificationService.DisplayPersistentNotification request");
  mojo::internal::MessageFragment<
      typename decltype(params->notification_resources)::BaseType> notification_resources_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::NotificationResourcesDataView>(
    in_notification_resources,
    notification_resources_fragment);

  params->notification_resources.Set(
      notification_resources_fragment.is_null() ? nullptr : notification_resources_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->notification_resources.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null notification_resources in NotificationService.DisplayPersistentNotification request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NotificationService::Name_);
  message.set_method_name("DisplayPersistentNotification");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NotificationService_DisplayPersistentNotification_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NotificationServiceProxy::ClosePersistentNotification(
    const std::string& in_notification_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::NotificationService::ClosePersistentNotification", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("notification_id"), in_notification_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NotificationService::kClosePersistentNotification), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::NotificationService_ClosePersistentNotification_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->notification_id)::BaseType> notification_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_notification_id,
    notification_id_fragment);

  params->notification_id.Set(
      notification_id_fragment.is_null() ? nullptr : notification_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->notification_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null notification_id in NotificationService.ClosePersistentNotification request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NotificationService::Name_);
  message.set_method_name("ClosePersistentNotification");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NotificationServiceProxy::GetNotifications(
    int64_t in_service_worker_registration_id, const std::string& in_filter_tag, bool in_include_triggered, GetNotificationsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::NotificationService::GetNotifications", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_registration_id"), in_service_worker_registration_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("filter_tag"), in_filter_tag,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("include_triggered"), in_include_triggered,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NotificationService::kGetNotifications), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::NotificationService_GetNotifications_Params_Data> params(
          message);
  params.Allocate();

  params->service_worker_registration_id = in_service_worker_registration_id;
  mojo::internal::MessageFragment<
      typename decltype(params->filter_tag)::BaseType> filter_tag_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_filter_tag,
    filter_tag_fragment);

  params->filter_tag.Set(
      filter_tag_fragment.is_null() ? nullptr : filter_tag_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->filter_tag.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null filter_tag in NotificationService.GetNotifications request");

  params->include_triggered = in_include_triggered;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NotificationService::Name_);
  message.set_method_name("GetNotifications");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NotificationService_GetNotifications_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class NotificationService_GetPermissionStatus_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NotificationService::GetPermissionStatusCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NotificationService_GetPermissionStatus_ProxyToResponder> proxy(
        new NotificationService_GetPermissionStatus_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NotificationService_GetPermissionStatus_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NotificationService_GetPermissionStatus_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NotificationService_GetPermissionStatus_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "NotificationService::GetPermissionStatusCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::PermissionStatus in_status);
};

bool NotificationService_GetPermissionStatus_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NotificationService_GetPermissionStatus_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NotificationService_GetPermissionStatus_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NotificationService.0
  bool success = true;
  ::blink::mojom::PermissionStatus p_status{};
  NotificationService_GetPermissionStatus_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NotificationService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void NotificationService_GetPermissionStatus_ProxyToResponder::Run(
    ::blink::mojom::PermissionStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::NotificationService::GetPermissionStatus", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::PermissionStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NotificationService::kGetPermissionStatus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::NotificationService_GetPermissionStatus_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::PermissionStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NotificationService::Name_);
  message.set_method_name("GetPermissionStatus");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NotificationService_GetPermissionStatus_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NotificationService_GetPermissionStatus_ResponseParams_Data* params =
      reinterpret_cast<internal::NotificationService_GetPermissionStatus_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for NotificationService.0
  bool success = true;
  ::blink::mojom::PermissionStatus p_status{};
  NotificationService_GetPermissionStatus_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NotificationService::Name_, 0, true);
    return false;
  }
  *out_status_ = std::move(p_status);
  *result_ = true;
  return true;
}
class NotificationService_DisplayPersistentNotification_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NotificationService::DisplayPersistentNotificationCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NotificationService_DisplayPersistentNotification_ProxyToResponder> proxy(
        new NotificationService_DisplayPersistentNotification_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NotificationService_DisplayPersistentNotification_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NotificationService_DisplayPersistentNotification_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NotificationService_DisplayPersistentNotification_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "NotificationService::DisplayPersistentNotificationCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      PersistentNotificationError in_error);
};

bool NotificationService_DisplayPersistentNotification_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NotificationService_DisplayPersistentNotification_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NotificationService_DisplayPersistentNotification_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NotificationService.3
  bool success = true;
  PersistentNotificationError p_error{};
  NotificationService_DisplayPersistentNotification_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NotificationService::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error));
  }
  return true;
}

void NotificationService_DisplayPersistentNotification_ProxyToResponder::Run(
    PersistentNotificationError in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::NotificationService::DisplayPersistentNotification", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type PersistentNotificationError>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NotificationService::kDisplayPersistentNotification), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::NotificationService_DisplayPersistentNotification_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::PersistentNotificationError>(
    in_error,
    &params->error);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NotificationService::Name_);
  message.set_method_name("DisplayPersistentNotification");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NotificationService_GetNotifications_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NotificationService::GetNotificationsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NotificationService_GetNotifications_ProxyToResponder> proxy(
        new NotificationService_GetNotifications_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NotificationService_GetNotifications_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NotificationService_GetNotifications_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NotificationService_GetNotifications_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "NotificationService::GetNotificationsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<std::string>& in_notification_ids, const std::vector<::blink::PlatformNotificationData>& in_notification_datas);
};

bool NotificationService_GetNotifications_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NotificationService_GetNotifications_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NotificationService_GetNotifications_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NotificationService.5
  bool success = true;
  std::vector<std::string> p_notification_ids{};
  std::vector<::blink::PlatformNotificationData> p_notification_datas{};
  NotificationService_GetNotifications_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadNotificationIds(&p_notification_ids))
    success = false;
  if (success && !input_data_view.ReadNotificationDatas(&p_notification_datas))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NotificationService::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_notification_ids), 
std::move(p_notification_datas));
  }
  return true;
}

void NotificationService_GetNotifications_ProxyToResponder::Run(
    const std::vector<std::string>& in_notification_ids, const std::vector<::blink::PlatformNotificationData>& in_notification_datas) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::NotificationService::GetNotifications", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("notification_ids"), in_notification_ids,
                        "<value of type const std::vector<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("notification_datas"), in_notification_datas,
                        "<value of type const std::vector<::blink::PlatformNotificationData>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NotificationService::kGetNotifications), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::NotificationService_GetNotifications_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->notification_ids)::BaseType>
      notification_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& notification_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_notification_ids,
    notification_ids_fragment,
    &notification_ids_validate_params);

  params->notification_ids.Set(
      notification_ids_fragment.is_null() ? nullptr : notification_ids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->notification_ids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null notification_ids in ");
  mojo::internal::MessageFragment<
      typename decltype(params->notification_datas)::BaseType>
      notification_datas_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& notification_datas_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::NotificationDataDataView>>(
    in_notification_datas,
    notification_datas_fragment,
    &notification_datas_validate_params);

  params->notification_datas.Set(
      notification_datas_fragment.is_null() ? nullptr : notification_datas_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->notification_datas.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null notification_datas in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NotificationService::Name_);
  message.set_method_name("GetNotifications");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool NotificationServiceStubDispatch::Accept(
    NotificationService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::NotificationService>(message->header()->name)) {
    case messages::NotificationService::kGetPermissionStatus: {
      break;
    }
    case messages::NotificationService::kDisplayNonPersistentNotification: {
      DCHECK(message->is_serialized());
      internal::NotificationService_DisplayNonPersistentNotification_Params_Data* params =
          reinterpret_cast<internal::NotificationService_DisplayNonPersistentNotification_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NotificationService.1
      bool success = true;
      std::string p_token{};
      ::blink::PlatformNotificationData p_notification_data{};
      ::blink::NotificationResources p_notification_resources{};
      ::mojo::PendingRemote<NonPersistentNotificationListener> p_event_listener{};
      NotificationService_DisplayNonPersistentNotification_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadToken(&p_token))
        success = false;
      if (success && !input_data_view.ReadNotificationData(&p_notification_data))
        success = false;
      if (success && !input_data_view.ReadNotificationResources(&p_notification_resources))
        success = false;
      if (success) {
        p_event_listener =
            input_data_view.TakeEventListener<decltype(p_event_listener)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NotificationService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DisplayNonPersistentNotification(        
        std::move(p_token), 
        std::move(p_notification_data), 
        std::move(p_notification_resources), 
        std::move(p_event_listener));
      return true;
    }
    case messages::NotificationService::kCloseNonPersistentNotification: {
      DCHECK(message->is_serialized());
      internal::NotificationService_CloseNonPersistentNotification_Params_Data* params =
          reinterpret_cast<internal::NotificationService_CloseNonPersistentNotification_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NotificationService.2
      bool success = true;
      std::string p_token{};
      NotificationService_CloseNonPersistentNotification_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadToken(&p_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NotificationService::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloseNonPersistentNotification(        
        std::move(p_token));
      return true;
    }
    case messages::NotificationService::kDisplayPersistentNotification: {
      break;
    }
    case messages::NotificationService::kClosePersistentNotification: {
      DCHECK(message->is_serialized());
      internal::NotificationService_ClosePersistentNotification_Params_Data* params =
          reinterpret_cast<internal::NotificationService_ClosePersistentNotification_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NotificationService.4
      bool success = true;
      std::string p_notification_id{};
      NotificationService_ClosePersistentNotification_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNotificationId(&p_notification_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NotificationService::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClosePersistentNotification(        
        std::move(p_notification_id));
      return true;
    }
    case messages::NotificationService::kGetNotifications: {
      break;
    }
  }
  return false;
}

// static
bool NotificationServiceStubDispatch::AcceptWithResponder(
    NotificationService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::NotificationService>(message->header()->name)) {
    case messages::NotificationService::kGetPermissionStatus: {
      internal::NotificationService_GetPermissionStatus_Params_Data* params =
          reinterpret_cast<
              internal::NotificationService_GetPermissionStatus_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NotificationService.0
      bool success = true;
      NotificationService_GetPermissionStatus_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NotificationService::Name_, 0, false);
        return false;
      }
      auto callback =
          NotificationService_GetPermissionStatus_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPermissionStatus(std::move(callback));
      return true;
    }
    case messages::NotificationService::kDisplayNonPersistentNotification: {
      break;
    }
    case messages::NotificationService::kCloseNonPersistentNotification: {
      break;
    }
    case messages::NotificationService::kDisplayPersistentNotification: {
      internal::NotificationService_DisplayPersistentNotification_Params_Data* params =
          reinterpret_cast<
              internal::NotificationService_DisplayPersistentNotification_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NotificationService.3
      bool success = true;
      int64_t p_service_worker_registration_id{};
      ::blink::PlatformNotificationData p_notification_data{};
      ::blink::NotificationResources p_notification_resources{};
      NotificationService_DisplayPersistentNotification_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_service_worker_registration_id = input_data_view.service_worker_registration_id();
      if (success && !input_data_view.ReadNotificationData(&p_notification_data))
        success = false;
      if (success && !input_data_view.ReadNotificationResources(&p_notification_resources))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NotificationService::Name_, 3, false);
        return false;
      }
      auto callback =
          NotificationService_DisplayPersistentNotification_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DisplayPersistentNotification(        
        std::move(p_service_worker_registration_id), 
        std::move(p_notification_data), 
        std::move(p_notification_resources), std::move(callback));
      return true;
    }
    case messages::NotificationService::kClosePersistentNotification: {
      break;
    }
    case messages::NotificationService::kGetNotifications: {
      internal::NotificationService_GetNotifications_Params_Data* params =
          reinterpret_cast<
              internal::NotificationService_GetNotifications_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NotificationService.5
      bool success = true;
      int64_t p_service_worker_registration_id{};
      std::string p_filter_tag{};
      bool p_include_triggered{};
      NotificationService_GetNotifications_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_service_worker_registration_id = input_data_view.service_worker_registration_id();
      if (success && !input_data_view.ReadFilterTag(&p_filter_tag))
        success = false;
      if (success)
        p_include_triggered = input_data_view.include_triggered();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NotificationService::Name_, 5, false);
        return false;
      }
      auto callback =
          NotificationService_GetNotifications_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetNotifications(        
        std::move(p_service_worker_registration_id), 
        std::move(p_filter_tag), 
        std::move(p_include_triggered), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kNotificationServiceValidationInfo[] = {
    { &internal::NotificationService_GetPermissionStatus_Params_Data::Validate,
     &internal::NotificationService_GetPermissionStatus_ResponseParams_Data::Validate},
    { &internal::NotificationService_DisplayNonPersistentNotification_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NotificationService_CloseNonPersistentNotification_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NotificationService_DisplayPersistentNotification_Params_Data::Validate,
     &internal::NotificationService_DisplayPersistentNotification_ResponseParams_Data::Validate},
    { &internal::NotificationService_ClosePersistentNotification_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NotificationService_GetNotifications_Params_Data::Validate,
     &internal::NotificationService_GetNotifications_ResponseParams_Data::Validate},
};

bool NotificationServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::NotificationService::Name_,
    kNotificationServiceValidationInfo);
}

bool NotificationServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::NotificationService::Name_,
    kNotificationServiceValidationInfo);
}


}  // blink::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void NonPersistentNotificationListenerInterceptorForTesting::OnShow() {
  GetForwardingInterface()->OnShow();
}
void NonPersistentNotificationListenerInterceptorForTesting::OnClick(OnClickCallback callback) {
  GetForwardingInterface()->OnClick(std::move(callback));
}
void NonPersistentNotificationListenerInterceptorForTesting::OnClose(OnCloseCallback callback) {
  GetForwardingInterface()->OnClose(std::move(callback));
}
NonPersistentNotificationListenerAsyncWaiter::NonPersistentNotificationListenerAsyncWaiter(
    NonPersistentNotificationListener* proxy) : proxy_(proxy) {}

NonPersistentNotificationListenerAsyncWaiter::~NonPersistentNotificationListenerAsyncWaiter() = default;


void NonPersistentNotificationListenerAsyncWaiter::OnClick(
    ) {
  base::RunLoop loop;
  proxy_->OnClick(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void NonPersistentNotificationListenerAsyncWaiter::OnClose(
    ) {
  base::RunLoop loop;
  proxy_->OnClose(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}






void NotificationServiceInterceptorForTesting::GetPermissionStatus(GetPermissionStatusCallback callback) {
  GetForwardingInterface()->GetPermissionStatus(std::move(callback));
}
void NotificationServiceInterceptorForTesting::DisplayNonPersistentNotification(const std::string& token, const ::blink::PlatformNotificationData& notification_data, const ::blink::NotificationResources& notification_resources, ::mojo::PendingRemote<NonPersistentNotificationListener> event_listener) {
  GetForwardingInterface()->DisplayNonPersistentNotification(
    std::move(token)
    , 
    std::move(notification_data)
    , 
    std::move(notification_resources)
    , 
    std::move(event_listener)
    );
}
void NotificationServiceInterceptorForTesting::CloseNonPersistentNotification(const std::string& token) {
  GetForwardingInterface()->CloseNonPersistentNotification(
    std::move(token)
    );
}
void NotificationServiceInterceptorForTesting::DisplayPersistentNotification(int64_t service_worker_registration_id, const ::blink::PlatformNotificationData& notification_data, const ::blink::NotificationResources& notification_resources, DisplayPersistentNotificationCallback callback) {
  GetForwardingInterface()->DisplayPersistentNotification(
    std::move(service_worker_registration_id)
    , 
    std::move(notification_data)
    , 
    std::move(notification_resources)
    , std::move(callback));
}
void NotificationServiceInterceptorForTesting::ClosePersistentNotification(const std::string& notification_id) {
  GetForwardingInterface()->ClosePersistentNotification(
    std::move(notification_id)
    );
}
void NotificationServiceInterceptorForTesting::GetNotifications(int64_t service_worker_registration_id, const std::string& filter_tag, bool include_triggered, GetNotificationsCallback callback) {
  GetForwardingInterface()->GetNotifications(
    std::move(service_worker_registration_id)
    , 
    std::move(filter_tag)
    , 
    std::move(include_triggered)
    , std::move(callback));
}
NotificationServiceAsyncWaiter::NotificationServiceAsyncWaiter(
    NotificationService* proxy) : proxy_(proxy) {}

NotificationServiceAsyncWaiter::~NotificationServiceAsyncWaiter() = default;


void NotificationServiceAsyncWaiter::GetPermissionStatus(
    ::blink::mojom::PermissionStatus* out_status) {
  base::RunLoop loop;
  proxy_->GetPermissionStatus(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::PermissionStatus* out_status
,
             ::blink::mojom::PermissionStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::blink::mojom::PermissionStatus NotificationServiceAsyncWaiter::GetPermissionStatus(
    ) {
  ::blink::mojom::PermissionStatus async_wait_result;
  GetPermissionStatus(&async_wait_result);
  return async_wait_result;
}

void NotificationServiceAsyncWaiter::DisplayPersistentNotification(
    int64_t service_worker_registration_id, const ::blink::PlatformNotificationData& notification_data, const ::blink::NotificationResources& notification_resources, PersistentNotificationError* out_error) {
  base::RunLoop loop;
  proxy_->DisplayPersistentNotification(
      std::move(service_worker_registration_id),
      std::move(notification_data),
      std::move(notification_resources),
      base::BindOnce(
          [](base::RunLoop* loop,
             PersistentNotificationError* out_error
,
             PersistentNotificationError error) {*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_error));
  loop.Run();
}

PersistentNotificationError NotificationServiceAsyncWaiter::DisplayPersistentNotification(
    int64_t service_worker_registration_id, const ::blink::PlatformNotificationData& notification_data, const ::blink::NotificationResources& notification_resources) {
  PersistentNotificationError async_wait_result;
  DisplayPersistentNotification(std::move(service_worker_registration_id),std::move(notification_data),std::move(notification_resources),&async_wait_result);
  return async_wait_result;
}

void NotificationServiceAsyncWaiter::GetNotifications(
    int64_t service_worker_registration_id, const std::string& filter_tag, bool include_triggered, std::vector<std::string>* out_notification_ids, std::vector<::blink::PlatformNotificationData>* out_notification_datas) {
  base::RunLoop loop;
  proxy_->GetNotifications(
      std::move(service_worker_registration_id),
      std::move(filter_tag),
      std::move(include_triggered),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<std::string>* out_notification_ids
,
             std::vector<::blink::PlatformNotificationData>* out_notification_datas
,
             const std::vector<std::string>& notification_ids,
             const std::vector<::blink::PlatformNotificationData>& notification_datas) {*out_notification_ids = std::move(notification_ids);*out_notification_datas = std::move(notification_datas);
            loop->Quit();
          },
          &loop,
          out_notification_ids,
          out_notification_datas));
  loop.Run();
}








}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif