// third_party/blink/public/mojom/navigation/prefetched_signed_exchange_info.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_NAVIGATION_PREFETCHED_SIGNED_EXCHANGE_INFO_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_NAVIGATION_PREFETCHED_SIGNED_EXCHANGE_INFO_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/navigation/prefetched_signed_exchange_info.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/navigation/prefetched_signed_exchange_info.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/navigation/prefetched_signed_exchange_info.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/byte_string.mojom-blink.h"
#include "services/network/public/mojom/url_loader_factory.mojom-blink-forward.h"
#include "services/network/public/mojom/url_loader.mojom-blink-forward.h"
#include "services/network/public/mojom/url_response_head.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "third_party/blink/public/common/navigation/prefetched_signed_exchange_info_mojom_traits.h"
#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {









class PLATFORM_EXPORT SHA256HashValue {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SHA256HashValue, T>::value>;
  using DataView = SHA256HashValueDataView;
  using Data_ = internal::SHA256HashValue_Data;

  template <typename... Args>
  static SHA256HashValuePtr New(Args&&... args) {
    return SHA256HashValuePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SHA256HashValuePtr From(const U& u) {
    return mojo::TypeConverter<SHA256HashValuePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SHA256HashValue>::Convert(*this);
  }


  SHA256HashValue();

  explicit SHA256HashValue(
      const std::string& data);


  ~SHA256HashValue();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SHA256HashValuePtr>
  SHA256HashValuePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SHA256HashValue::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SHA256HashValue::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SHA256HashValue::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SHA256HashValue::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SHA256HashValue::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SHA256HashValue::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SHA256HashValue_UnserializedMessageContext<
            UserType, SHA256HashValue::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SHA256HashValue::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SHA256HashValue::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SHA256HashValue_UnserializedMessageContext<
            UserType, SHA256HashValue::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SHA256HashValue::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SHA256HashValue::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SHA256HashValue::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SHA256HashValue::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SHA256HashValue::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT PrefetchedSignedExchangeInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PrefetchedSignedExchangeInfo, T>::value>;
  using DataView = PrefetchedSignedExchangeInfoDataView;
  using Data_ = internal::PrefetchedSignedExchangeInfo_Data;

  template <typename... Args>
  static PrefetchedSignedExchangeInfoPtr New(Args&&... args) {
    return PrefetchedSignedExchangeInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PrefetchedSignedExchangeInfoPtr From(const U& u) {
    return mojo::TypeConverter<PrefetchedSignedExchangeInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PrefetchedSignedExchangeInfo>::Convert(*this);
  }


  PrefetchedSignedExchangeInfo();

  PrefetchedSignedExchangeInfo(
      const ::blink::KURL& outer_url,
      const ::net::SHA256HashValue& header_integrity,
      const ::blink::KURL& inner_url,
      ::network::mojom::blink::URLResponseHeadPtr inner_response,
      ::mojo::PendingRemote<::network::mojom::blink::URLLoaderFactory> loader_factory_handle);

PrefetchedSignedExchangeInfo(const PrefetchedSignedExchangeInfo&) = delete;
PrefetchedSignedExchangeInfo& operator=(const PrefetchedSignedExchangeInfo&) = delete;

  ~PrefetchedSignedExchangeInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PrefetchedSignedExchangeInfoPtr>
  PrefetchedSignedExchangeInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PrefetchedSignedExchangeInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PrefetchedSignedExchangeInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PrefetchedSignedExchangeInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PrefetchedSignedExchangeInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PrefetchedSignedExchangeInfo_UnserializedMessageContext<
            UserType, PrefetchedSignedExchangeInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PrefetchedSignedExchangeInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PrefetchedSignedExchangeInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PrefetchedSignedExchangeInfo_UnserializedMessageContext<
            UserType, PrefetchedSignedExchangeInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PrefetchedSignedExchangeInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::KURL outer_url;
  
  ::net::SHA256HashValue header_integrity;
  
  ::blink::KURL inner_url;
  
  ::network::mojom::blink::URLResponseHeadPtr inner_response;
  
  ::mojo::PendingRemote<::network::mojom::blink::URLLoaderFactory> loader_factory_handle;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PrefetchedSignedExchangeInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PrefetchedSignedExchangeInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PrefetchedSignedExchangeInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PrefetchedSignedExchangeInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SHA256HashValuePtr SHA256HashValue::Clone() const {
  return New(
      mojo::Clone(data)
  );
}

template <typename T, SHA256HashValue::EnableIfSame<T>*>
bool SHA256HashValue::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  return true;
}

template <typename T, SHA256HashValue::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  return false;
}
template <typename StructPtrType>
PrefetchedSignedExchangeInfoPtr PrefetchedSignedExchangeInfo::Clone() const {
  return New(
      mojo::Clone(outer_url),
      mojo::Clone(header_integrity),
      mojo::Clone(inner_url),
      mojo::Clone(inner_response),
      mojo::Clone(loader_factory_handle)
  );
}

template <typename T, PrefetchedSignedExchangeInfo::EnableIfSame<T>*>
bool PrefetchedSignedExchangeInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->outer_url, other_struct.outer_url))
    return false;
  if (!mojo::Equals(this->header_integrity, other_struct.header_integrity))
    return false;
  if (!mojo::Equals(this->inner_url, other_struct.inner_url))
    return false;
  if (!mojo::Equals(this->inner_response, other_struct.inner_response))
    return false;
  if (!mojo::Equals(this->loader_factory_handle, other_struct.loader_factory_handle))
    return false;
  return true;
}

template <typename T, PrefetchedSignedExchangeInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.outer_url < rhs.outer_url)
    return true;
  if (rhs.outer_url < lhs.outer_url)
    return false;
  if (lhs.header_integrity < rhs.header_integrity)
    return true;
  if (rhs.header_integrity < lhs.header_integrity)
    return false;
  if (lhs.inner_url < rhs.inner_url)
    return true;
  if (rhs.inner_url < lhs.inner_url)
    return false;
  if (lhs.inner_response < rhs.inner_response)
    return true;
  if (rhs.inner_response < lhs.inner_response)
    return false;
  if (lhs.loader_factory_handle < rhs.loader_factory_handle)
    return true;
  if (rhs.loader_factory_handle < lhs.loader_factory_handle)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::SHA256HashValue::DataView,
                                         ::blink::mojom::blink::SHA256HashValuePtr> {
  static bool IsNull(const ::blink::mojom::blink::SHA256HashValuePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::SHA256HashValuePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::SHA256HashValue::data)& data(
      const ::blink::mojom::blink::SHA256HashValuePtr& input) {
    return input->data;
  }

  static bool Read(::blink::mojom::blink::SHA256HashValue::DataView input, ::blink::mojom::blink::SHA256HashValuePtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::PrefetchedSignedExchangeInfo::DataView,
                                         ::blink::mojom::blink::PrefetchedSignedExchangeInfoPtr> {
  static bool IsNull(const ::blink::mojom::blink::PrefetchedSignedExchangeInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::PrefetchedSignedExchangeInfoPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::PrefetchedSignedExchangeInfo::outer_url)& outer_url(
      const ::blink::mojom::blink::PrefetchedSignedExchangeInfoPtr& input) {
    return input->outer_url;
  }

  static const decltype(::blink::mojom::blink::PrefetchedSignedExchangeInfo::header_integrity)& header_integrity(
      const ::blink::mojom::blink::PrefetchedSignedExchangeInfoPtr& input) {
    return input->header_integrity;
  }

  static const decltype(::blink::mojom::blink::PrefetchedSignedExchangeInfo::inner_url)& inner_url(
      const ::blink::mojom::blink::PrefetchedSignedExchangeInfoPtr& input) {
    return input->inner_url;
  }

  static const decltype(::blink::mojom::blink::PrefetchedSignedExchangeInfo::inner_response)& inner_response(
      const ::blink::mojom::blink::PrefetchedSignedExchangeInfoPtr& input) {
    return input->inner_response;
  }

  static  decltype(::blink::mojom::blink::PrefetchedSignedExchangeInfo::loader_factory_handle)& loader_factory_handle(
       ::blink::mojom::blink::PrefetchedSignedExchangeInfoPtr& input) {
    return input->loader_factory_handle;
  }

  static bool Read(::blink::mojom::blink::PrefetchedSignedExchangeInfo::DataView input, ::blink::mojom::blink::PrefetchedSignedExchangeInfoPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_NAVIGATION_PREFETCHED_SIGNED_EXCHANGE_INFO_MOJOM_BLINK_H_