// third_party/blink/public/mojom/navigation/navigation_api_history_entry_arrays.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_NAVIGATION_NAVIGATION_API_HISTORY_ENTRY_ARRAYS_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_NAVIGATION_NAVIGATION_API_HISTORY_ENTRY_ARRAYS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/navigation/navigation_api_history_entry_arrays.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/navigation/navigation_api_history_entry_arrays.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/navigation/navigation_api_history_entry_arrays.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom.h"
#include <string>
#include <vector>




#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {









class BLINK_COMMON_EXPORT NavigationApiHistoryEntry {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NavigationApiHistoryEntry, T>::value>;
  using DataView = NavigationApiHistoryEntryDataView;
  using Data_ = internal::NavigationApiHistoryEntry_Data;

  template <typename... Args>
  static NavigationApiHistoryEntryPtr New(Args&&... args) {
    return NavigationApiHistoryEntryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NavigationApiHistoryEntryPtr From(const U& u) {
    return mojo::TypeConverter<NavigationApiHistoryEntryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NavigationApiHistoryEntry>::Convert(*this);
  }


  NavigationApiHistoryEntry();

  NavigationApiHistoryEntry(
      const ::std::u16string& key,
      const ::std::u16string& id,
      const ::std::u16string& url,
      int64_t item_sequence_number,
      int64_t document_sequence_number,
      const std::optional<::std::u16string>& state);


  ~NavigationApiHistoryEntry();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NavigationApiHistoryEntryPtr>
  NavigationApiHistoryEntryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NavigationApiHistoryEntry::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NavigationApiHistoryEntry::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NavigationApiHistoryEntry::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NavigationApiHistoryEntry::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NavigationApiHistoryEntry::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NavigationApiHistoryEntry::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NavigationApiHistoryEntry_UnserializedMessageContext<
            UserType, NavigationApiHistoryEntry::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NavigationApiHistoryEntry::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NavigationApiHistoryEntry::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NavigationApiHistoryEntry_UnserializedMessageContext<
            UserType, NavigationApiHistoryEntry::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NavigationApiHistoryEntry::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::std::u16string key;
  
  ::std::u16string id;
  
  ::std::u16string url;
  
  int64_t item_sequence_number;
  
  int64_t document_sequence_number;
  
  std::optional<::std::u16string> state;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NavigationApiHistoryEntry::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NavigationApiHistoryEntry::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NavigationApiHistoryEntry::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NavigationApiHistoryEntry::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT NavigationApiHistoryEntryArrays {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NavigationApiHistoryEntryArrays, T>::value>;
  using DataView = NavigationApiHistoryEntryArraysDataView;
  using Data_ = internal::NavigationApiHistoryEntryArrays_Data;

  template <typename... Args>
  static NavigationApiHistoryEntryArraysPtr New(Args&&... args) {
    return NavigationApiHistoryEntryArraysPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NavigationApiHistoryEntryArraysPtr From(const U& u) {
    return mojo::TypeConverter<NavigationApiHistoryEntryArraysPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NavigationApiHistoryEntryArrays>::Convert(*this);
  }


  NavigationApiHistoryEntryArrays();

  NavigationApiHistoryEntryArrays(
      std::vector<NavigationApiHistoryEntryPtr> back_entries,
      std::vector<NavigationApiHistoryEntryPtr> forward_entries,
      NavigationApiHistoryEntryPtr previous_entry);

NavigationApiHistoryEntryArrays(const NavigationApiHistoryEntryArrays&) = delete;
NavigationApiHistoryEntryArrays& operator=(const NavigationApiHistoryEntryArrays&) = delete;

  ~NavigationApiHistoryEntryArrays();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NavigationApiHistoryEntryArraysPtr>
  NavigationApiHistoryEntryArraysPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NavigationApiHistoryEntryArrays::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NavigationApiHistoryEntryArrays::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NavigationApiHistoryEntryArrays::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NavigationApiHistoryEntryArrays::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NavigationApiHistoryEntryArrays::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NavigationApiHistoryEntryArrays::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NavigationApiHistoryEntryArrays_UnserializedMessageContext<
            UserType, NavigationApiHistoryEntryArrays::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NavigationApiHistoryEntryArrays::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NavigationApiHistoryEntryArrays::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NavigationApiHistoryEntryArrays_UnserializedMessageContext<
            UserType, NavigationApiHistoryEntryArrays::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NavigationApiHistoryEntryArrays::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<NavigationApiHistoryEntryPtr> back_entries;
  
  std::vector<NavigationApiHistoryEntryPtr> forward_entries;
  
  NavigationApiHistoryEntryPtr previous_entry;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NavigationApiHistoryEntryArrays::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NavigationApiHistoryEntryArrays::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NavigationApiHistoryEntryArrays::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NavigationApiHistoryEntryArrays::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
NavigationApiHistoryEntryPtr NavigationApiHistoryEntry::Clone() const {
  return New(
      mojo::Clone(key),
      mojo::Clone(id),
      mojo::Clone(url),
      mojo::Clone(item_sequence_number),
      mojo::Clone(document_sequence_number),
      mojo::Clone(state)
  );
}

template <typename T, NavigationApiHistoryEntry::EnableIfSame<T>*>
bool NavigationApiHistoryEntry::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->key, other_struct.key))
    return false;
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->item_sequence_number, other_struct.item_sequence_number))
    return false;
  if (!mojo::Equals(this->document_sequence_number, other_struct.document_sequence_number))
    return false;
  if (!mojo::Equals(this->state, other_struct.state))
    return false;
  return true;
}

template <typename T, NavigationApiHistoryEntry::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.key < rhs.key)
    return true;
  if (rhs.key < lhs.key)
    return false;
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.item_sequence_number < rhs.item_sequence_number)
    return true;
  if (rhs.item_sequence_number < lhs.item_sequence_number)
    return false;
  if (lhs.document_sequence_number < rhs.document_sequence_number)
    return true;
  if (rhs.document_sequence_number < lhs.document_sequence_number)
    return false;
  if (lhs.state < rhs.state)
    return true;
  if (rhs.state < lhs.state)
    return false;
  return false;
}
template <typename StructPtrType>
NavigationApiHistoryEntryArraysPtr NavigationApiHistoryEntryArrays::Clone() const {
  return New(
      mojo::Clone(back_entries),
      mojo::Clone(forward_entries),
      mojo::Clone(previous_entry)
  );
}

template <typename T, NavigationApiHistoryEntryArrays::EnableIfSame<T>*>
bool NavigationApiHistoryEntryArrays::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->back_entries, other_struct.back_entries))
    return false;
  if (!mojo::Equals(this->forward_entries, other_struct.forward_entries))
    return false;
  if (!mojo::Equals(this->previous_entry, other_struct.previous_entry))
    return false;
  return true;
}

template <typename T, NavigationApiHistoryEntryArrays::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.back_entries < rhs.back_entries)
    return true;
  if (rhs.back_entries < lhs.back_entries)
    return false;
  if (lhs.forward_entries < rhs.forward_entries)
    return true;
  if (rhs.forward_entries < lhs.forward_entries)
    return false;
  if (lhs.previous_entry < rhs.previous_entry)
    return true;
  if (rhs.previous_entry < lhs.previous_entry)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::NavigationApiHistoryEntry::DataView,
                                         ::blink::mojom::NavigationApiHistoryEntryPtr> {
  static bool IsNull(const ::blink::mojom::NavigationApiHistoryEntryPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::NavigationApiHistoryEntryPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::NavigationApiHistoryEntry::key)& key(
      const ::blink::mojom::NavigationApiHistoryEntryPtr& input) {
    return input->key;
  }

  static const decltype(::blink::mojom::NavigationApiHistoryEntry::id)& id(
      const ::blink::mojom::NavigationApiHistoryEntryPtr& input) {
    return input->id;
  }

  static const decltype(::blink::mojom::NavigationApiHistoryEntry::url)& url(
      const ::blink::mojom::NavigationApiHistoryEntryPtr& input) {
    return input->url;
  }

  static decltype(::blink::mojom::NavigationApiHistoryEntry::item_sequence_number) item_sequence_number(
      const ::blink::mojom::NavigationApiHistoryEntryPtr& input) {
    return input->item_sequence_number;
  }

  static decltype(::blink::mojom::NavigationApiHistoryEntry::document_sequence_number) document_sequence_number(
      const ::blink::mojom::NavigationApiHistoryEntryPtr& input) {
    return input->document_sequence_number;
  }

  static const decltype(::blink::mojom::NavigationApiHistoryEntry::state)& state(
      const ::blink::mojom::NavigationApiHistoryEntryPtr& input) {
    return input->state;
  }

  static bool Read(::blink::mojom::NavigationApiHistoryEntry::DataView input, ::blink::mojom::NavigationApiHistoryEntryPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::NavigationApiHistoryEntryArrays::DataView,
                                         ::blink::mojom::NavigationApiHistoryEntryArraysPtr> {
  static bool IsNull(const ::blink::mojom::NavigationApiHistoryEntryArraysPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::NavigationApiHistoryEntryArraysPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::NavigationApiHistoryEntryArrays::back_entries)& back_entries(
      const ::blink::mojom::NavigationApiHistoryEntryArraysPtr& input) {
    return input->back_entries;
  }

  static const decltype(::blink::mojom::NavigationApiHistoryEntryArrays::forward_entries)& forward_entries(
      const ::blink::mojom::NavigationApiHistoryEntryArraysPtr& input) {
    return input->forward_entries;
  }

  static const decltype(::blink::mojom::NavigationApiHistoryEntryArrays::previous_entry)& previous_entry(
      const ::blink::mojom::NavigationApiHistoryEntryArraysPtr& input) {
    return input->previous_entry;
  }

  static bool Read(::blink::mojom::NavigationApiHistoryEntryArrays::DataView input, ::blink::mojom::NavigationApiHistoryEntryArraysPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_NAVIGATION_NAVIGATION_API_HISTORY_ENTRY_ARRAYS_MOJOM_H_