// third_party/blink/public/mojom/messaging/static_bitmap_image.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/messaging/static_bitmap_image.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/messaging/static_bitmap_image.mojom-params-data.h"
#include "third_party/blink/public/mojom/messaging/static_bitmap_image.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/messaging/static_bitmap_image.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/messaging/static_bitmap_image.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"
#include "third_party/blink/public/common/messaging/accelerated_static_bitmap_image_mojom_traits.h"


namespace blink::mojom::blink {
AcceleratedStaticBitmapImage::AcceleratedStaticBitmapImage()
    : shared_image(),
      sync_token(),
      alpha_type(),
      release_callback() {}

AcceleratedStaticBitmapImage::AcceleratedStaticBitmapImage(
    ::gpu::ExportedSharedImage shared_image_in,
    const ::gpu::SyncToken& sync_token_in,
    ::SkAlphaType alpha_type_in,
    ::mojo::PendingRemote<ImageReleaseCallback> release_callback_in)
    : shared_image(std::move(shared_image_in)),
      sync_token(std::move(sync_token_in)),
      alpha_type(std::move(alpha_type_in)),
      release_callback(std::move(release_callback_in)) {}

AcceleratedStaticBitmapImage::~AcceleratedStaticBitmapImage() = default;

void AcceleratedStaticBitmapImage::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shared_image"), this->shared_image,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gpu::ExportedSharedImage>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sync_token"), this->sync_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gpu::SyncToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "alpha_type"), this->alpha_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::SkAlphaType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "release_callback"), this->release_callback,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<ImageReleaseCallback>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AcceleratedStaticBitmapImage::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SerializedStaticBitmapImagePtr
SerializedStaticBitmapImage::NewBitmap(
    const ::SkBitmap& value) {
  return SerializedStaticBitmapImagePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kBitmap)>,
      std::move(value));
}

SerializedStaticBitmapImagePtr
SerializedStaticBitmapImage::NewAcceleratedImage(
    ::blink::AcceleratedImageInfo value) {
  return SerializedStaticBitmapImagePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kAcceleratedImage)>,
      std::move(value));
}

SerializedStaticBitmapImage::SerializedStaticBitmapImage(
    std::in_place_index_t<static_cast<size_t>(Tag::kBitmap)>,
    const ::SkBitmap& value)
    : tag_(Tag::kBitmap),
      data_(std::in_place_index<static_cast<size_t>(Tag::kBitmap)>,
            std::move(value)) {}

SerializedStaticBitmapImage::SerializedStaticBitmapImage(
    std::in_place_index_t<static_cast<size_t>(Tag::kAcceleratedImage)>,
    ::blink::AcceleratedImageInfo value)
    : tag_(Tag::kAcceleratedImage),
      data_(std::in_place_index<static_cast<size_t>(Tag::kAcceleratedImage)>,
            std::move(value)) {}
SerializedStaticBitmapImage::~SerializedStaticBitmapImage() {
  DestroyActive();
}

void SerializedStaticBitmapImage::set_bitmap(const ::SkBitmap& bitmap) {
  if (tag_ == Tag::kBitmap) {
    data_.bitmap = std::move(bitmap);
  } else {
    DestroyActive();
    tag_ = Tag::kBitmap;
    new (&data_.bitmap) ::SkBitmap(
        std::move(bitmap));
  }
}

void SerializedStaticBitmapImage::set_accelerated_image(::blink::AcceleratedImageInfo accelerated_image) {
  if (tag_ == Tag::kAcceleratedImage) {
    data_.accelerated_image = std::move(accelerated_image);
  } else {
    DestroyActive();
    tag_ = Tag::kAcceleratedImage;
    new (&data_.accelerated_image) ::blink::AcceleratedImageInfo(
        std::move(accelerated_image));
  }
}


SerializedStaticBitmapImage::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kBitmap)>,
    const ::SkBitmap& value)
    : bitmap(std::move(value)) {}

SerializedStaticBitmapImage::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kAcceleratedImage)>,
    ::blink::AcceleratedImageInfo value)
    : accelerated_image(std::move(value)) {}

void SerializedStaticBitmapImage::DestroyActive() {
  switch (tag_) {

    case Tag::kBitmap:
      std::destroy_at(&data_.bitmap);
      break;
    case Tag::kAcceleratedImage:
      std::destroy_at(&data_.accelerated_image);
      break;
  }
}

bool SerializedStaticBitmapImage::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

ImageReleaseCallback::IPCStableHashFunction ImageReleaseCallback::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ImageReleaseCallback>(message.name())) {
    case messages::ImageReleaseCallback::kRelease: {
      return &ImageReleaseCallback::Release_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ImageReleaseCallback::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ImageReleaseCallback>(message.name())) {
      case messages::ImageReleaseCallback::kRelease:
            return "Receive blink::mojom::ImageReleaseCallback::Release";
    }
  } else {
    switch (static_cast<messages::ImageReleaseCallback>(message.name())) {
      case messages::ImageReleaseCallback::kRelease:
            return "Receive reply blink::mojom::ImageReleaseCallback::Release";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ImageReleaseCallback::Release_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x02d6a8b0;  // IPCStableHash for blink::mojom::ImageReleaseCallback::Release
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ImageReleaseCallbackProxy::ImageReleaseCallbackProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ImageReleaseCallbackProxy::Release(
    const ::gpu::SyncToken& in_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ImageReleaseCallback::Release", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type const ::gpu::SyncToken&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ImageReleaseCallback::kRelease), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ImageReleaseCallback_Release_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->token)::BaseType> token_fragment(
          params.message());
  
  mojo::internal::Serialize<::gpu::mojom::SyncTokenDataView>(
    in_token,
    token_fragment);

  params->token.Set(
      token_fragment.is_null() ? nullptr : token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null token in ImageReleaseCallback.Release request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ImageReleaseCallback::Name_);
  message.set_method_name("Release");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ImageReleaseCallbackStubDispatch::Accept(
    ImageReleaseCallback* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ImageReleaseCallback>(message->header()->name)) {
    case messages::ImageReleaseCallback::kRelease: {
      DCHECK(message->is_serialized());
      internal::ImageReleaseCallback_Release_Params_Data* params =
          reinterpret_cast<internal::ImageReleaseCallback_Release_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ImageReleaseCallback.0
      bool success = true;
      ::gpu::SyncToken p_token{};
      ImageReleaseCallback_Release_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadToken(&p_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ImageReleaseCallback::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Release(        
        std::move(p_token));
      return true;
    }
  }
  return false;
}

// static
bool ImageReleaseCallbackStubDispatch::AcceptWithResponder(
    ImageReleaseCallback* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ImageReleaseCallback>(message->header()->name)) {
    case messages::ImageReleaseCallback::kRelease: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kImageReleaseCallbackValidationInfo[] = {
    { &internal::ImageReleaseCallback_Release_Params_Data::Validate,
     nullptr /* no response */},
};

bool ImageReleaseCallbackRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::ImageReleaseCallback::Name_,
    kImageReleaseCallbackValidationInfo);
}



}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::AcceleratedStaticBitmapImage::DataView, ::blink::mojom::blink::AcceleratedStaticBitmapImagePtr>::Read(
    ::blink::mojom::blink::AcceleratedStaticBitmapImage::DataView input,
    ::blink::mojom::blink::AcceleratedStaticBitmapImagePtr* output) {
  bool success = true;
  ::blink::mojom::blink::AcceleratedStaticBitmapImagePtr result(::blink::mojom::blink::AcceleratedStaticBitmapImage::New());
  
      if (success && !input.ReadSharedImage(&result->shared_image))
        success = false;
      if (success && !input.ReadSyncToken(&result->sync_token))
        success = false;
      if (success && !input.ReadAlphaType(&result->alpha_type))
        success = false;
      if (success) {
        result->release_callback =
            input.TakeReleaseCallback<decltype(result->release_callback)>();
      }
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::blink::mojom::blink::SerializedStaticBitmapImage::DataView, ::blink::mojom::blink::SerializedStaticBitmapImagePtr>::Read(
    ::blink::mojom::blink::SerializedStaticBitmapImage::DataView input,
    ::blink::mojom::blink::SerializedStaticBitmapImagePtr* output) {
  using UnionType = ::blink::mojom::blink::SerializedStaticBitmapImage;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kBitmap: {
      ::SkBitmap result_bitmap{};
      if (!input.ReadBitmap(&result_bitmap))
        return false;

      *output = UnionType::NewBitmap(
          std::move(result_bitmap));
      break;
    }
    case Tag::kAcceleratedImage: {
      ::blink::AcceleratedImageInfo result_accelerated_image{};
      if (!input.ReadAcceleratedImage(&result_accelerated_image))
        return false;

      *output = UnionType::NewAcceleratedImage(
          std::move(result_accelerated_image));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void ImageReleaseCallbackInterceptorForTesting::Release(const ::gpu::SyncToken& token) {
  GetForwardingInterface()->Release(
    std::move(token)
    );
}
ImageReleaseCallbackAsyncWaiter::ImageReleaseCallbackAsyncWaiter(
    ImageReleaseCallback* proxy) : proxy_(proxy) {}

ImageReleaseCallbackAsyncWaiter::~ImageReleaseCallbackAsyncWaiter() = default;







}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif