// third_party/blink/public/mojom/mediastream/media_devices.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_DEVICES_MOJOM_SEND_VALIDATION_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_DEVICES_MOJOM_SEND_VALIDATION_H_

#include "third_party/blink/public/mojom/mediastream/media_devices.mojom-shared-internal.h"
#include "media/capture/mojom/video_capture_types.mojom-shared.h"
#include "media/mojo/mojom/audio_parameters.mojom-shared.h"
#include "media/mojo/mojom/media_types.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "third_party/blink/public/mojom/media/capture_handle_config.mojom-shared.h"

#include "third_party/blink/public/mojom/mediastream/media_devices.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::MediaDeviceType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::FacingMode, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::AudioOutputStatus, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::MediaDeviceInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::MediaDeviceInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::MediaDeviceInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::device_id(input)) in_device_id = Traits::device_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->device_id)::BaseType> device_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_device_id,
        device_id_fragment);

      fragment->device_id.Set(
          device_id_fragment.is_null() ? nullptr : device_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->device_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null device_id in MediaDeviceInfo struct");

      decltype(Traits::label(input)) in_label = Traits::label(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->label)::BaseType> label_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_label,
        label_fragment);

      fragment->label.Set(
          label_fragment.is_null() ? nullptr : label_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->label.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null label in MediaDeviceInfo struct");

      decltype(Traits::group_id(input)) in_group_id = Traits::group_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->group_id)::BaseType> group_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_group_id,
        group_id_fragment);

      fragment->group_id.Set(
          group_id_fragment.is_null() ? nullptr : group_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->group_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null group_id in MediaDeviceInfo struct");

      decltype(Traits::control_support(input)) in_control_support = Traits::control_support(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->control_support)::BaseType> control_support_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::VideoCaptureControlSupportDataView, send_validation>(
        in_control_support,
        control_support_fragment);

      fragment->control_support.Set(
          control_support_fragment.is_null() ? nullptr : control_support_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->control_support.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null control_support in MediaDeviceInfo struct");

      
      mojo::internal::Serialize<::blink::mojom::FacingMode>(
        Traits::facing_mode(input),
        &fragment->facing_mode);
      fragment->availability_$flag = Traits::availability(input).has_value();
      if (Traits::availability(input).has_value()) {
        
        mojo::internal::Serialize<::media::mojom::CameraAvailability>(
          Traits::availability(input).value(),
          &fragment->availability_$value);
      } else {
        fragment->availability_$value =
            static_cast<int32_t>(::media::mojom::CameraAvailability::kMinValue);
      }
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::VideoInputDeviceCapabilitiesDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::VideoInputDeviceCapabilitiesDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::VideoInputDeviceCapabilities_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::device_id(input)) in_device_id = Traits::device_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->device_id)::BaseType> device_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_device_id,
        device_id_fragment);

      fragment->device_id.Set(
          device_id_fragment.is_null() ? nullptr : device_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->device_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null device_id in VideoInputDeviceCapabilities struct");

      decltype(Traits::group_id(input)) in_group_id = Traits::group_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->group_id)::BaseType> group_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_group_id,
        group_id_fragment);

      fragment->group_id.Set(
          group_id_fragment.is_null() ? nullptr : group_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->group_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null group_id in VideoInputDeviceCapabilities struct");

      decltype(Traits::control_support(input)) in_control_support = Traits::control_support(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->control_support)::BaseType> control_support_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::VideoCaptureControlSupportDataView, send_validation>(
        in_control_support,
        control_support_fragment);

      fragment->control_support.Set(
          control_support_fragment.is_null() ? nullptr : control_support_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->control_support.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null control_support in VideoInputDeviceCapabilities struct");

      decltype(Traits::formats(input)) in_formats = Traits::formats(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->formats)::BaseType>
          formats_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& formats_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::VideoCaptureFormatDataView>, send_validation>(
        in_formats,
        formats_fragment,
        &formats_validate_params);

      fragment->formats.Set(
          formats_fragment.is_null() ? nullptr : formats_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->formats.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null formats in VideoInputDeviceCapabilities struct");

      
      mojo::internal::Serialize<::blink::mojom::FacingMode>(
        Traits::facing_mode(input),
        &fragment->facing_mode);
      fragment->availability_$flag = Traits::availability(input).has_value();
      if (Traits::availability(input).has_value()) {
        
        mojo::internal::Serialize<::media::mojom::CameraAvailability>(
          Traits::availability(input).value(),
          &fragment->availability_$value);
      } else {
        fragment->availability_$value =
            static_cast<int32_t>(::media::mojom::CameraAvailability::kMinValue);
      }
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::SelectAudioOutputResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SelectAudioOutputResultDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::SelectAudioOutputResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::blink::mojom::AudioOutputStatus>(
        Traits::status(input),
        &fragment->status);

      decltype(Traits::device_info(input)) in_device_info = Traits::device_info(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->device_info)::BaseType> device_info_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::MediaDeviceInfoDataView, send_validation>(
        in_device_info,
        device_info_fragment);

      fragment->device_info.Set(
          device_info_fragment.is_null() ? nullptr : device_info_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->device_info.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null device_info in SelectAudioOutputResult struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::AudioInputDeviceCapabilitiesDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AudioInputDeviceCapabilitiesDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AudioInputDeviceCapabilities_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::device_id(input)) in_device_id = Traits::device_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->device_id)::BaseType> device_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_device_id,
        device_id_fragment);

      fragment->device_id.Set(
          device_id_fragment.is_null() ? nullptr : device_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->device_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null device_id in AudioInputDeviceCapabilities struct");

      decltype(Traits::group_id(input)) in_group_id = Traits::group_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->group_id)::BaseType> group_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_group_id,
        group_id_fragment);

      fragment->group_id.Set(
          group_id_fragment.is_null() ? nullptr : group_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->group_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null group_id in AudioInputDeviceCapabilities struct");

      decltype(Traits::parameters(input)) in_parameters = Traits::parameters(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->parameters)::BaseType> parameters_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::AudioParametersDataView, send_validation>(
        in_parameters,
        parameters_fragment);

      fragment->parameters.Set(
          parameters_fragment.is_null() ? nullptr : parameters_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->parameters.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null parameters in AudioInputDeviceCapabilities struct");

      fragment->is_valid = Traits::is_valid(input);

      fragment->channels = Traits::channels(input);

      fragment->sample_rate = Traits::sample_rate(input);

      decltype(Traits::latency(input)) in_latency = Traits::latency(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->latency)::BaseType> latency_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_latency,
        latency_fragment);

      fragment->latency.Set(
          latency_fragment.is_null() ? nullptr : latency_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->latency.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null latency in AudioInputDeviceCapabilities struct");
  }
};

}  // namespace mojo::internal

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_DEVICES_MOJOM_SEND_VALIDATION_H_