// third_party/blink/public/mojom/mediastream/media_devices.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('media.mojom.CameraAvailability');
goog.require('media.mojom.OutputDeviceStatus');
goog.require('media.mojom.SubCaptureTargetType');
goog.require('media.mojom.AudioParameters');
goog.require('blink.mojom.CaptureHandleConfig');
goog.require('mojoBase.mojom.TimeDelta');
goog.require('media.mojom.VideoCaptureControlSupport');
goog.require('media.mojom.VideoCaptureFormat');




goog.provide('blink.mojom.MediaDeviceType');
goog.provide('blink.mojom.MediaDeviceTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.MediaDeviceTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.MediaDeviceType = {
  
  kMediaAudioInput: 0,
  kMediaVideoInput: 1,
  kMediaAudioOutput: 2,
  kNumMediaDeviceTypes: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

goog.provide('blink.mojom.FacingMode');
goog.provide('blink.mojom.FacingModeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.FacingModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.FacingMode = {
  
  kNone: 0,
  kUser: 1,
  kEnvironment: 2,
  kLeft: 3,
  kRight: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};

goog.provide('blink.mojom.AudioOutputStatus');
goog.provide('blink.mojom.AudioOutputStatusSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.AudioOutputStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.AudioOutputStatus = {
  
  kSuccess: 0,
  kNoPermission: 1,
  kNoDevices: 2,
  kUnknown: 3,
  kDeviceNotFound: 4,
  kErrorOtherRequestInProgress: 5,
  kNotSupported: 6,
  kNoUserActivation: 7,
  MIN_VALUE: 0,
  MAX_VALUE: 7,
};



goog.provide('blink.mojom.MediaDevicesDispatcherHost');
goog.provide('blink.mojom.MediaDevicesDispatcherHostReceiver');
goog.provide('blink.mojom.MediaDevicesDispatcherHostCallbackRouter');
goog.provide('blink.mojom.MediaDevicesDispatcherHostInterface');
goog.provide('blink.mojom.MediaDevicesDispatcherHostRemote');
goog.provide('blink.mojom.MediaDevicesDispatcherHostPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.MediaDevicesDispatcherHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.MediaDevicesDispatcherHost.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.MediaDevicesDispatcherHostInterface = class {
  
  /**
   * @param { !boolean } requestAudioInput
   * @param { !boolean } requestVideoInput
   * @param { !boolean } requestAudioOutput
   * @param { !boolean } requestVideoInputCapabilities
   * @param { !boolean } requestAudioInputCapabilities
   * @return {!Promise<{
        enumeration: !Array<!Array<!blink.mojom.MediaDeviceInfo>>,
        videoInputDeviceCapabilities: !Array<!blink.mojom.VideoInputDeviceCapabilities>,
        audioInputDeviceCapabilities: !Array<!blink.mojom.AudioInputDeviceCapabilities>,
   *  }>}
   */

  enumerateDevices(requestAudioInput, requestVideoInput, requestAudioOutput, requestVideoInputCapabilities, requestAudioInputCapabilities) {}
  
  /**
   * @return {!Promise<{
        videoInputDeviceCapabilities: !Array<!blink.mojom.VideoInputDeviceCapabilities>,
   *  }>}
   */

  getVideoInputCapabilities() {}
  
  /**
   * @param { !string } deviceId
   * @return {!Promise<{
        formats: !Array<!media.mojom.VideoCaptureFormat>,
   *  }>}
   */

  getAllVideoInputDeviceFormats(deviceId) {}
  
  /**
   * @param { !string } deviceId
   * @return {!Promise<{
        formats: !Array<!media.mojom.VideoCaptureFormat>,
   *  }>}
   */

  getAvailableVideoInputDeviceFormats(deviceId) {}
  
  /**
   * @return {!Promise<{
        audioInputDeviceCapabilities: !Array<!blink.mojom.AudioInputDeviceCapabilities>,
   *  }>}
   */

  getAudioInputCapabilities() {}
  
  /**
   * @param { !boolean } subscribeAudioInput
   * @param { !boolean } subscribeVideoInput
   * @param { !boolean } subscribeAudioOutput
   * @param { !blink.mojom.MediaDevicesListenerRemote } listener
   */

  addMediaDevicesListener(subscribeAudioInput, subscribeVideoInput, subscribeAudioOutput, listener) {}
  
  /**
   * @param { !blink.mojom.CaptureHandleConfig } config
   */

  setCaptureHandleConfig(config) {}
  
  /**
   * @param { !string } label
   */

  closeFocusWindowOfOpportunity(label) {}
  
  /**
   * @param { !media.mojom.SubCaptureTargetType } type
   * @return {!Promise<{
        id: !string,
   *  }>}
   */

  produceSubCaptureTargetId(type) {}
  
  /**
   * @param { !string } sinkId
   * @return {!Promise<{
        status: !media.mojom.OutputDeviceStatus,
   *  }>}
   */

  setPreferredSinkId(sinkId) {}
  
  /**
   * @param { !string } deviceId
   * @return {!Promise<{
        result: !blink.mojom.SelectAudioOutputResult,
   *  }>}
   */

  selectAudioOutput(deviceId) {}
};

/**
 * @export
 * @implements { blink.mojom.MediaDevicesDispatcherHostInterface }
 */
blink.mojom.MediaDevicesDispatcherHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.MediaDevicesDispatcherHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.MediaDevicesDispatcherHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.MediaDevicesDispatcherHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !boolean } requestAudioInput
   * @param { !boolean } requestVideoInput
   * @param { !boolean } requestAudioOutput
   * @param { !boolean } requestVideoInputCapabilities
   * @param { !boolean } requestAudioInputCapabilities
   * @return {!Promise<{
        enumeration: !Array<!Array<!blink.mojom.MediaDeviceInfo>>,
        videoInputDeviceCapabilities: !Array<!blink.mojom.VideoInputDeviceCapabilities>,
        audioInputDeviceCapabilities: !Array<!blink.mojom.AudioInputDeviceCapabilities>,
   *  }>}
   */

  enumerateDevices(
      requestAudioInput,
      requestVideoInput,
      requestAudioOutput,
      requestVideoInputCapabilities,
      requestAudioInputCapabilities) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.MediaDevicesDispatcherHost_EnumerateDevices_ParamsSpec.$,
        blink.mojom.MediaDevicesDispatcherHost_EnumerateDevices_ResponseParamsSpec.$,
        [
          requestAudioInput,
          requestVideoInput,
          requestAudioOutput,
          requestVideoInputCapabilities,
          requestAudioInputCapabilities
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        videoInputDeviceCapabilities: !Array<!blink.mojom.VideoInputDeviceCapabilities>,
   *  }>}
   */

  getVideoInputCapabilities() {
    return this.proxy.sendMessage(
        1,
        blink.mojom.MediaDevicesDispatcherHost_GetVideoInputCapabilities_ParamsSpec.$,
        blink.mojom.MediaDevicesDispatcherHost_GetVideoInputCapabilities_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } deviceId
   * @return {!Promise<{
        formats: !Array<!media.mojom.VideoCaptureFormat>,
   *  }>}
   */

  getAllVideoInputDeviceFormats(
      deviceId) {
    return this.proxy.sendMessage(
        2,
        blink.mojom.MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ParamsSpec.$,
        blink.mojom.MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ResponseParamsSpec.$,
        [
          deviceId
        ],
        false);
  }

  
  /**
   * @param { !string } deviceId
   * @return {!Promise<{
        formats: !Array<!media.mojom.VideoCaptureFormat>,
   *  }>}
   */

  getAvailableVideoInputDeviceFormats(
      deviceId) {
    return this.proxy.sendMessage(
        3,
        blink.mojom.MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ParamsSpec.$,
        blink.mojom.MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ResponseParamsSpec.$,
        [
          deviceId
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        audioInputDeviceCapabilities: !Array<!blink.mojom.AudioInputDeviceCapabilities>,
   *  }>}
   */

  getAudioInputCapabilities() {
    return this.proxy.sendMessage(
        4,
        blink.mojom.MediaDevicesDispatcherHost_GetAudioInputCapabilities_ParamsSpec.$,
        blink.mojom.MediaDevicesDispatcherHost_GetAudioInputCapabilities_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } subscribeAudioInput
   * @param { !boolean } subscribeVideoInput
   * @param { !boolean } subscribeAudioOutput
   * @param { !blink.mojom.MediaDevicesListenerRemote } listener
   */

  addMediaDevicesListener(
      subscribeAudioInput,
      subscribeVideoInput,
      subscribeAudioOutput,
      listener) {
    this.proxy.sendMessage(
        5,
        blink.mojom.MediaDevicesDispatcherHost_AddMediaDevicesListener_ParamsSpec.$,
        null,
        [
          subscribeAudioInput,
          subscribeVideoInput,
          subscribeAudioOutput,
          listener
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.CaptureHandleConfig } config
   */

  setCaptureHandleConfig(
      config) {
    this.proxy.sendMessage(
        6,
        blink.mojom.MediaDevicesDispatcherHost_SetCaptureHandleConfig_ParamsSpec.$,
        null,
        [
          config
        ],
        false);
  }

  
  /**
   * @param { !string } label
   */

  closeFocusWindowOfOpportunity(
      label) {
    this.proxy.sendMessage(
        7,
        blink.mojom.MediaDevicesDispatcherHost_CloseFocusWindowOfOpportunity_ParamsSpec.$,
        null,
        [
          label
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.SubCaptureTargetType } type
   * @return {!Promise<{
        id: !string,
   *  }>}
   */

  produceSubCaptureTargetId(
      type) {
    return this.proxy.sendMessage(
        8,
        blink.mojom.MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ParamsSpec.$,
        blink.mojom.MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ResponseParamsSpec.$,
        [
          type
        ],
        false);
  }

  
  /**
   * @param { !string } sinkId
   * @return {!Promise<{
        status: !media.mojom.OutputDeviceStatus,
   *  }>}
   */

  setPreferredSinkId(
      sinkId) {
    return this.proxy.sendMessage(
        9,
        blink.mojom.MediaDevicesDispatcherHost_SetPreferredSinkId_ParamsSpec.$,
        blink.mojom.MediaDevicesDispatcherHost_SetPreferredSinkId_ResponseParamsSpec.$,
        [
          sinkId
        ],
        false);
  }

  
  /**
   * @param { !string } deviceId
   * @return {!Promise<{
        result: !blink.mojom.SelectAudioOutputResult,
   *  }>}
   */

  selectAudioOutput(
      deviceId) {
    return this.proxy.sendMessage(
        10,
        blink.mojom.MediaDevicesDispatcherHost_SelectAudioOutput_ParamsSpec.$,
        blink.mojom.MediaDevicesDispatcherHost_SelectAudioOutput_ResponseParamsSpec.$,
        [
          deviceId
        ],
        false);
  }
};

/**
 * An object which receives request messages for the MediaDevicesDispatcherHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.MediaDevicesDispatcherHostReceiver = class {
  /**
   * @param {!blink.mojom.MediaDevicesDispatcherHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.MediaDevicesDispatcherHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.MediaDevicesDispatcherHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.MediaDevicesDispatcherHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.MediaDevicesDispatcherHost_EnumerateDevices_ParamsSpec.$,
        blink.mojom.MediaDevicesDispatcherHost_EnumerateDevices_ResponseParamsSpec.$,
        impl.enumerateDevices.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.MediaDevicesDispatcherHost_GetVideoInputCapabilities_ParamsSpec.$,
        blink.mojom.MediaDevicesDispatcherHost_GetVideoInputCapabilities_ResponseParamsSpec.$,
        impl.getVideoInputCapabilities.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ParamsSpec.$,
        blink.mojom.MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ResponseParamsSpec.$,
        impl.getAllVideoInputDeviceFormats.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ParamsSpec.$,
        blink.mojom.MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ResponseParamsSpec.$,
        impl.getAvailableVideoInputDeviceFormats.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.MediaDevicesDispatcherHost_GetAudioInputCapabilities_ParamsSpec.$,
        blink.mojom.MediaDevicesDispatcherHost_GetAudioInputCapabilities_ResponseParamsSpec.$,
        impl.getAudioInputCapabilities.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.MediaDevicesDispatcherHost_AddMediaDevicesListener_ParamsSpec.$,
        null,
        impl.addMediaDevicesListener.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        blink.mojom.MediaDevicesDispatcherHost_SetCaptureHandleConfig_ParamsSpec.$,
        null,
        impl.setCaptureHandleConfig.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        blink.mojom.MediaDevicesDispatcherHost_CloseFocusWindowOfOpportunity_ParamsSpec.$,
        null,
        impl.closeFocusWindowOfOpportunity.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        blink.mojom.MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ParamsSpec.$,
        blink.mojom.MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ResponseParamsSpec.$,
        impl.produceSubCaptureTargetId.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        blink.mojom.MediaDevicesDispatcherHost_SetPreferredSinkId_ParamsSpec.$,
        blink.mojom.MediaDevicesDispatcherHost_SetPreferredSinkId_ResponseParamsSpec.$,
        impl.setPreferredSinkId.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        blink.mojom.MediaDevicesDispatcherHost_SelectAudioOutput_ParamsSpec.$,
        blink.mojom.MediaDevicesDispatcherHost_SelectAudioOutput_ResponseParamsSpec.$,
        impl.selectAudioOutput.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.MediaDevicesDispatcherHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.MediaDevicesDispatcherHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.MediaDevicesDispatcherHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.MediaDevicesDispatcherHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the MediaDevicesDispatcherHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.MediaDevicesDispatcherHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.MediaDevicesDispatcherHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.MediaDevicesDispatcherHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enumerateDevices =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.MediaDevicesDispatcherHost_EnumerateDevices_ParamsSpec.$,
        blink.mojom.MediaDevicesDispatcherHost_EnumerateDevices_ResponseParamsSpec.$,
        this.enumerateDevices.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getVideoInputCapabilities =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.MediaDevicesDispatcherHost_GetVideoInputCapabilities_ParamsSpec.$,
        blink.mojom.MediaDevicesDispatcherHost_GetVideoInputCapabilities_ResponseParamsSpec.$,
        this.getVideoInputCapabilities.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getAllVideoInputDeviceFormats =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ParamsSpec.$,
        blink.mojom.MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ResponseParamsSpec.$,
        this.getAllVideoInputDeviceFormats.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getAvailableVideoInputDeviceFormats =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ParamsSpec.$,
        blink.mojom.MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ResponseParamsSpec.$,
        this.getAvailableVideoInputDeviceFormats.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getAudioInputCapabilities =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.MediaDevicesDispatcherHost_GetAudioInputCapabilities_ParamsSpec.$,
        blink.mojom.MediaDevicesDispatcherHost_GetAudioInputCapabilities_ResponseParamsSpec.$,
        this.getAudioInputCapabilities.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addMediaDevicesListener =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.MediaDevicesDispatcherHost_AddMediaDevicesListener_ParamsSpec.$,
        null,
        this.addMediaDevicesListener.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setCaptureHandleConfig =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        blink.mojom.MediaDevicesDispatcherHost_SetCaptureHandleConfig_ParamsSpec.$,
        null,
        this.setCaptureHandleConfig.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.closeFocusWindowOfOpportunity =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        blink.mojom.MediaDevicesDispatcherHost_CloseFocusWindowOfOpportunity_ParamsSpec.$,
        null,
        this.closeFocusWindowOfOpportunity.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.produceSubCaptureTargetId =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        blink.mojom.MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ParamsSpec.$,
        blink.mojom.MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ResponseParamsSpec.$,
        this.produceSubCaptureTargetId.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPreferredSinkId =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        blink.mojom.MediaDevicesDispatcherHost_SetPreferredSinkId_ParamsSpec.$,
        blink.mojom.MediaDevicesDispatcherHost_SetPreferredSinkId_ResponseParamsSpec.$,
        this.setPreferredSinkId.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.selectAudioOutput =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        blink.mojom.MediaDevicesDispatcherHost_SelectAudioOutput_ParamsSpec.$,
        blink.mojom.MediaDevicesDispatcherHost_SelectAudioOutput_ResponseParamsSpec.$,
        this.selectAudioOutput.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.MediaDevicesListener');
goog.provide('blink.mojom.MediaDevicesListenerReceiver');
goog.provide('blink.mojom.MediaDevicesListenerCallbackRouter');
goog.provide('blink.mojom.MediaDevicesListenerInterface');
goog.provide('blink.mojom.MediaDevicesListenerRemote');
goog.provide('blink.mojom.MediaDevicesListenerPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.MediaDevicesListenerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.MediaDevicesListener.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.MediaDevicesListenerInterface = class {
  
  /**
   * @param { !blink.mojom.MediaDeviceType } type
   * @param { !Array<!blink.mojom.MediaDeviceInfo> } deviceInfos
   */

  onDevicesChanged(type, deviceInfos) {}
};

/**
 * @export
 * @implements { blink.mojom.MediaDevicesListenerInterface }
 */
blink.mojom.MediaDevicesListenerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.MediaDevicesListenerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.MediaDevicesListenerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.MediaDevicesListenerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.MediaDeviceType } type
   * @param { !Array<!blink.mojom.MediaDeviceInfo> } deviceInfos
   */

  onDevicesChanged(
      type,
      deviceInfos) {
    this.proxy.sendMessage(
        0,
        blink.mojom.MediaDevicesListener_OnDevicesChanged_ParamsSpec.$,
        null,
        [
          type,
          deviceInfos
        ],
        false);
  }
};

/**
 * An object which receives request messages for the MediaDevicesListener
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.MediaDevicesListenerReceiver = class {
  /**
   * @param {!blink.mojom.MediaDevicesListenerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.MediaDevicesListenerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.MediaDevicesListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.MediaDevicesListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.MediaDevicesListener_OnDevicesChanged_ParamsSpec.$,
        null,
        impl.onDevicesChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.MediaDevicesListener = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.MediaDevicesListener";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.MediaDevicesListenerRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.MediaDevicesListenerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the MediaDevicesListener
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.MediaDevicesListenerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.MediaDevicesListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.MediaDevicesListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onDevicesChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.MediaDevicesListener_OnDevicesChanged_ParamsSpec.$,
        null,
        this.onDevicesChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.MediaDeviceInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaDeviceInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.VideoInputDeviceCapabilitiesSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.VideoInputDeviceCapabilitiesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.SelectAudioOutputResultSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SelectAudioOutputResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AudioInputDeviceCapabilitiesSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AudioInputDeviceCapabilitiesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.MediaDevicesDispatcherHost_EnumerateDevices_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaDevicesDispatcherHost_EnumerateDevices_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.MediaDevicesDispatcherHost_EnumerateDevices_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaDevicesDispatcherHost_EnumerateDevices_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.MediaDevicesDispatcherHost_GetVideoInputCapabilities_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaDevicesDispatcherHost_GetVideoInputCapabilities_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.MediaDevicesDispatcherHost_GetVideoInputCapabilities_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaDevicesDispatcherHost_GetVideoInputCapabilities_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.MediaDevicesDispatcherHost_GetAudioInputCapabilities_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaDevicesDispatcherHost_GetAudioInputCapabilities_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.MediaDevicesDispatcherHost_GetAudioInputCapabilities_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaDevicesDispatcherHost_GetAudioInputCapabilities_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.MediaDevicesDispatcherHost_AddMediaDevicesListener_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaDevicesDispatcherHost_AddMediaDevicesListener_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.MediaDevicesDispatcherHost_SetCaptureHandleConfig_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaDevicesDispatcherHost_SetCaptureHandleConfig_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.MediaDevicesDispatcherHost_CloseFocusWindowOfOpportunity_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaDevicesDispatcherHost_CloseFocusWindowOfOpportunity_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.MediaDevicesDispatcherHost_SetPreferredSinkId_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaDevicesDispatcherHost_SetPreferredSinkId_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.MediaDevicesDispatcherHost_SetPreferredSinkId_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaDevicesDispatcherHost_SetPreferredSinkId_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.MediaDevicesDispatcherHost_SelectAudioOutput_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaDevicesDispatcherHost_SelectAudioOutput_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.MediaDevicesDispatcherHost_SelectAudioOutput_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaDevicesDispatcherHost_SelectAudioOutput_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.MediaDevicesListener_OnDevicesChanged_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaDevicesListener_OnDevicesChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.MediaDeviceInfoSpec.$,
    'MediaDeviceInfo',
    [
      mojo.internal.StructField(
        'deviceId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'label', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'groupId', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'controlSupport', 24,
        0,
        media.mojom.VideoCaptureControlSupportSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'facingMode', 32,
        0,
        blink.mojom.FacingModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'availability_$flag', 36,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "availability_$value",
          originalFieldName: "availability",
        }
      ),
      mojo.internal.StructField(
        'availability_$value', 40,
        0,
        media.mojom.CameraAvailabilitySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "availability",
        }
      ),
    ],
    [[0, 56],]);



goog.provide('blink.mojom.MediaDeviceInfo');

/** @record */
blink.mojom.MediaDeviceInfo = class {
  constructor() {
    /** @export { !string } */
    this.deviceId;
    /** @export { !string } */
    this.label;
    /** @export { !string } */
    this.groupId;
    /** @export { !media.mojom.VideoCaptureControlSupport } */
    this.controlSupport;
    /** @export { !blink.mojom.FacingMode } */
    this.facingMode;
    /** @export { (media.mojom.CameraAvailability|undefined) } */
    this.availability;
  }
};



mojo.internal.Struct(
    blink.mojom.VideoInputDeviceCapabilitiesSpec.$,
    'VideoInputDeviceCapabilities',
    [
      mojo.internal.StructField(
        'deviceId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'groupId', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'controlSupport', 16,
        0,
        media.mojom.VideoCaptureControlSupportSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'formats', 24,
        0,
        mojo.internal.Array(media.mojom.VideoCaptureFormatSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'facingMode', 32,
        0,
        blink.mojom.FacingModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'availability_$flag', 36,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "availability_$value",
          originalFieldName: "availability",
        }
      ),
      mojo.internal.StructField(
        'availability_$value', 40,
        0,
        media.mojom.CameraAvailabilitySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "availability",
        }
      ),
    ],
    [[0, 56],]);



goog.provide('blink.mojom.VideoInputDeviceCapabilities');

/** @record */
blink.mojom.VideoInputDeviceCapabilities = class {
  constructor() {
    /** @export { !string } */
    this.deviceId;
    /** @export { !string } */
    this.groupId;
    /** @export { !media.mojom.VideoCaptureControlSupport } */
    this.controlSupport;
    /** @export { !Array<!media.mojom.VideoCaptureFormat> } */
    this.formats;
    /** @export { !blink.mojom.FacingMode } */
    this.facingMode;
    /** @export { (media.mojom.CameraAvailability|undefined) } */
    this.availability;
  }
};



mojo.internal.Struct(
    blink.mojom.SelectAudioOutputResultSpec.$,
    'SelectAudioOutputResult',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.AudioOutputStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'deviceInfo', 8,
        0,
        blink.mojom.MediaDeviceInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.SelectAudioOutputResult');

/** @record */
blink.mojom.SelectAudioOutputResult = class {
  constructor() {
    /** @export { !blink.mojom.AudioOutputStatus } */
    this.status;
    /** @export { !blink.mojom.MediaDeviceInfo } */
    this.deviceInfo;
  }
};



mojo.internal.Struct(
    blink.mojom.AudioInputDeviceCapabilitiesSpec.$,
    'AudioInputDeviceCapabilities',
    [
      mojo.internal.StructField(
        'deviceId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'groupId', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'parameters', 16,
        0,
        media.mojom.AudioParametersSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isValid', 24,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'channels', 28,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sampleRate', 32,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'latency', 40,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);



goog.provide('blink.mojom.AudioInputDeviceCapabilities');

/** @record */
blink.mojom.AudioInputDeviceCapabilities = class {
  constructor() {
    /** @export { !string } */
    this.deviceId;
    /** @export { !string } */
    this.groupId;
    /** @export { !media.mojom.AudioParameters } */
    this.parameters;
    /** @export { !boolean } */
    this.isValid;
    /** @export { !number } */
    this.channels;
    /** @export { !number } */
    this.sampleRate;
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.latency;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaDevicesDispatcherHost_EnumerateDevices_ParamsSpec.$,
    'MediaDevicesDispatcherHost_EnumerateDevices_Params',
    [
      mojo.internal.StructField(
        'requestAudioInput', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requestVideoInput', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requestAudioOutput', 0,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requestVideoInputCapabilities', 0,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requestAudioInputCapabilities', 0,
        4,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.MediaDevicesDispatcherHost_EnumerateDevices_Params');

/** @record */
blink.mojom.MediaDevicesDispatcherHost_EnumerateDevices_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.requestAudioInput;
    /** @export { !boolean } */
    this.requestVideoInput;
    /** @export { !boolean } */
    this.requestAudioOutput;
    /** @export { !boolean } */
    this.requestVideoInputCapabilities;
    /** @export { !boolean } */
    this.requestAudioInputCapabilities;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaDevicesDispatcherHost_EnumerateDevices_ResponseParamsSpec.$,
    'MediaDevicesDispatcherHost_EnumerateDevices_ResponseParams',
    [
      mojo.internal.StructField(
        'enumeration', 0,
        0,
        mojo.internal.Array(mojo.internal.Array(blink.mojom.MediaDeviceInfoSpec.$, false), false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'videoInputDeviceCapabilities', 8,
        0,
        mojo.internal.Array(blink.mojom.VideoInputDeviceCapabilitiesSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'audioInputDeviceCapabilities', 16,
        0,
        mojo.internal.Array(blink.mojom.AudioInputDeviceCapabilitiesSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.MediaDevicesDispatcherHost_EnumerateDevices_ResponseParams');

/** @record */
blink.mojom.MediaDevicesDispatcherHost_EnumerateDevices_ResponseParams = class {
  constructor() {
    /** @export { !Array<!Array<!blink.mojom.MediaDeviceInfo>> } */
    this.enumeration;
    /** @export { !Array<!blink.mojom.VideoInputDeviceCapabilities> } */
    this.videoInputDeviceCapabilities;
    /** @export { !Array<!blink.mojom.AudioInputDeviceCapabilities> } */
    this.audioInputDeviceCapabilities;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaDevicesDispatcherHost_GetVideoInputCapabilities_ParamsSpec.$,
    'MediaDevicesDispatcherHost_GetVideoInputCapabilities_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.MediaDevicesDispatcherHost_GetVideoInputCapabilities_Params');

/** @record */
blink.mojom.MediaDevicesDispatcherHost_GetVideoInputCapabilities_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.MediaDevicesDispatcherHost_GetVideoInputCapabilities_ResponseParamsSpec.$,
    'MediaDevicesDispatcherHost_GetVideoInputCapabilities_ResponseParams',
    [
      mojo.internal.StructField(
        'videoInputDeviceCapabilities', 0,
        0,
        mojo.internal.Array(blink.mojom.VideoInputDeviceCapabilitiesSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.MediaDevicesDispatcherHost_GetVideoInputCapabilities_ResponseParams');

/** @record */
blink.mojom.MediaDevicesDispatcherHost_GetVideoInputCapabilities_ResponseParams = class {
  constructor() {
    /** @export { !Array<!blink.mojom.VideoInputDeviceCapabilities> } */
    this.videoInputDeviceCapabilities;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ParamsSpec.$,
    'MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_Params',
    [
      mojo.internal.StructField(
        'deviceId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_Params');

/** @record */
blink.mojom.MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_Params = class {
  constructor() {
    /** @export { !string } */
    this.deviceId;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ResponseParamsSpec.$,
    'MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ResponseParams',
    [
      mojo.internal.StructField(
        'formats', 0,
        0,
        mojo.internal.Array(media.mojom.VideoCaptureFormatSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ResponseParams');

/** @record */
blink.mojom.MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ResponseParams = class {
  constructor() {
    /** @export { !Array<!media.mojom.VideoCaptureFormat> } */
    this.formats;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ParamsSpec.$,
    'MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_Params',
    [
      mojo.internal.StructField(
        'deviceId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_Params');

/** @record */
blink.mojom.MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_Params = class {
  constructor() {
    /** @export { !string } */
    this.deviceId;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ResponseParamsSpec.$,
    'MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ResponseParams',
    [
      mojo.internal.StructField(
        'formats', 0,
        0,
        mojo.internal.Array(media.mojom.VideoCaptureFormatSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ResponseParams');

/** @record */
blink.mojom.MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ResponseParams = class {
  constructor() {
    /** @export { !Array<!media.mojom.VideoCaptureFormat> } */
    this.formats;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaDevicesDispatcherHost_GetAudioInputCapabilities_ParamsSpec.$,
    'MediaDevicesDispatcherHost_GetAudioInputCapabilities_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.MediaDevicesDispatcherHost_GetAudioInputCapabilities_Params');

/** @record */
blink.mojom.MediaDevicesDispatcherHost_GetAudioInputCapabilities_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.MediaDevicesDispatcherHost_GetAudioInputCapabilities_ResponseParamsSpec.$,
    'MediaDevicesDispatcherHost_GetAudioInputCapabilities_ResponseParams',
    [
      mojo.internal.StructField(
        'audioInputDeviceCapabilities', 0,
        0,
        mojo.internal.Array(blink.mojom.AudioInputDeviceCapabilitiesSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.MediaDevicesDispatcherHost_GetAudioInputCapabilities_ResponseParams');

/** @record */
blink.mojom.MediaDevicesDispatcherHost_GetAudioInputCapabilities_ResponseParams = class {
  constructor() {
    /** @export { !Array<!blink.mojom.AudioInputDeviceCapabilities> } */
    this.audioInputDeviceCapabilities;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaDevicesDispatcherHost_AddMediaDevicesListener_ParamsSpec.$,
    'MediaDevicesDispatcherHost_AddMediaDevicesListener_Params',
    [
      mojo.internal.StructField(
        'subscribeAudioInput', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'subscribeVideoInput', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'subscribeAudioOutput', 0,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'listener', 4,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.MediaDevicesListenerRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.MediaDevicesDispatcherHost_AddMediaDevicesListener_Params');

/** @record */
blink.mojom.MediaDevicesDispatcherHost_AddMediaDevicesListener_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.subscribeAudioInput;
    /** @export { !boolean } */
    this.subscribeVideoInput;
    /** @export { !boolean } */
    this.subscribeAudioOutput;
    /** @export { !blink.mojom.MediaDevicesListenerRemote } */
    this.listener;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaDevicesDispatcherHost_SetCaptureHandleConfig_ParamsSpec.$,
    'MediaDevicesDispatcherHost_SetCaptureHandleConfig_Params',
    [
      mojo.internal.StructField(
        'config', 0,
        0,
        blink.mojom.CaptureHandleConfigSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.MediaDevicesDispatcherHost_SetCaptureHandleConfig_Params');

/** @record */
blink.mojom.MediaDevicesDispatcherHost_SetCaptureHandleConfig_Params = class {
  constructor() {
    /** @export { !blink.mojom.CaptureHandleConfig } */
    this.config;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaDevicesDispatcherHost_CloseFocusWindowOfOpportunity_ParamsSpec.$,
    'MediaDevicesDispatcherHost_CloseFocusWindowOfOpportunity_Params',
    [
      mojo.internal.StructField(
        'label', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.MediaDevicesDispatcherHost_CloseFocusWindowOfOpportunity_Params');

/** @record */
blink.mojom.MediaDevicesDispatcherHost_CloseFocusWindowOfOpportunity_Params = class {
  constructor() {
    /** @export { !string } */
    this.label;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ParamsSpec.$,
    'MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        media.mojom.SubCaptureTargetTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_Params');

/** @record */
blink.mojom.MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_Params = class {
  constructor() {
    /** @export { !media.mojom.SubCaptureTargetType } */
    this.type;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ResponseParamsSpec.$,
    'MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ResponseParams',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ResponseParams');

/** @record */
blink.mojom.MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ResponseParams = class {
  constructor() {
    /** @export { !string } */
    this.id;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaDevicesDispatcherHost_SetPreferredSinkId_ParamsSpec.$,
    'MediaDevicesDispatcherHost_SetPreferredSinkId_Params',
    [
      mojo.internal.StructField(
        'sinkId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.MediaDevicesDispatcherHost_SetPreferredSinkId_Params');

/** @record */
blink.mojom.MediaDevicesDispatcherHost_SetPreferredSinkId_Params = class {
  constructor() {
    /** @export { !string } */
    this.sinkId;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaDevicesDispatcherHost_SetPreferredSinkId_ResponseParamsSpec.$,
    'MediaDevicesDispatcherHost_SetPreferredSinkId_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        media.mojom.OutputDeviceStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.MediaDevicesDispatcherHost_SetPreferredSinkId_ResponseParams');

/** @record */
blink.mojom.MediaDevicesDispatcherHost_SetPreferredSinkId_ResponseParams = class {
  constructor() {
    /** @export { !media.mojom.OutputDeviceStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaDevicesDispatcherHost_SelectAudioOutput_ParamsSpec.$,
    'MediaDevicesDispatcherHost_SelectAudioOutput_Params',
    [
      mojo.internal.StructField(
        'deviceId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.MediaDevicesDispatcherHost_SelectAudioOutput_Params');

/** @record */
blink.mojom.MediaDevicesDispatcherHost_SelectAudioOutput_Params = class {
  constructor() {
    /** @export { !string } */
    this.deviceId;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaDevicesDispatcherHost_SelectAudioOutput_ResponseParamsSpec.$,
    'MediaDevicesDispatcherHost_SelectAudioOutput_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.SelectAudioOutputResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.MediaDevicesDispatcherHost_SelectAudioOutput_ResponseParams');

/** @record */
blink.mojom.MediaDevicesDispatcherHost_SelectAudioOutput_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.SelectAudioOutputResult } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaDevicesListener_OnDevicesChanged_ParamsSpec.$,
    'MediaDevicesListener_OnDevicesChanged_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        blink.mojom.MediaDeviceTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'deviceInfos', 8,
        0,
        mojo.internal.Array(blink.mojom.MediaDeviceInfoSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.MediaDevicesListener_OnDevicesChanged_Params');

/** @record */
blink.mojom.MediaDevicesListener_OnDevicesChanged_Params = class {
  constructor() {
    /** @export { !blink.mojom.MediaDeviceType } */
    this.type;
    /** @export { !Array<!blink.mojom.MediaDeviceInfo> } */
    this.deviceInfos;
  }
};

