// third_party/blink/public/mojom/manifest/manifest_manager.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.ManifestManagerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.ManifestManager.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.ManifestManagerInterface }
 */
blink.mojom.ManifestManagerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.ManifestManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.ManifestManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.ManifestManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        result: !blink.mojom.ManifestRequestResult,
        url: !url.mojom.Url,
        manifest: !blink.mojom.Manifest,
   *  }>}
   */

  requestManifest() {
    return this.proxy.sendMessage(
        0,
        blink.mojom.ManifestManager_RequestManifest_ParamsSpec.$,
        blink.mojom.ManifestManager_RequestManifest_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        url: !url.mojom.Url,
        parsedManifest: !blink.mojom.Manifest,
        debugInfo: !blink.mojom.ManifestDebugInfo,
   *  }>}
   */

  requestManifestDebugInfo() {
    return this.proxy.sendMessage(
        1,
        blink.mojom.ManifestManager_RequestManifestDebugInfo_ParamsSpec.$,
        blink.mojom.ManifestManager_RequestManifestDebugInfo_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } documentUrl
   * @param { !url.mojom.Url } manifestUrl
   * @param { !string } manifestContent
   * @return {!Promise<{
        parsedManifest: ?blink.mojom.Manifest,
   *  }>}
   */

  parseManifestFromString(
      documentUrl,
      manifestUrl,
      manifestContent) {
    return this.proxy.sendMessage(
        2,
        blink.mojom.ManifestManager_ParseManifestFromString_ParamsSpec.$,
        blink.mojom.ManifestManager_ParseManifestFromString_ResponseParamsSpec.$,
        [
          documentUrl,
          manifestUrl,
          manifestContent
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ManifestManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.ManifestManagerReceiver = class {
  /**
   * @param {!blink.mojom.ManifestManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.ManifestManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.ManifestManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ManifestManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ManifestManager_RequestManifest_ParamsSpec.$,
        blink.mojom.ManifestManager_RequestManifest_ResponseParamsSpec.$,
        impl.requestManifest.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.ManifestManager_RequestManifestDebugInfo_ParamsSpec.$,
        blink.mojom.ManifestManager_RequestManifestDebugInfo_ResponseParamsSpec.$,
        impl.requestManifestDebugInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.ManifestManager_ParseManifestFromString_ParamsSpec.$,
        blink.mojom.ManifestManager_ParseManifestFromString_ResponseParamsSpec.$,
        impl.parseManifestFromString.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.ManifestManager = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ManifestManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.ManifestManagerRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.ManifestManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ManifestManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.ManifestManagerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.ManifestManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ManifestManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestManifest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ManifestManager_RequestManifest_ParamsSpec.$,
        blink.mojom.ManifestManager_RequestManifest_ResponseParamsSpec.$,
        this.requestManifest.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestManifestDebugInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.ManifestManager_RequestManifestDebugInfo_ParamsSpec.$,
        blink.mojom.ManifestManager_RequestManifestDebugInfo_ResponseParamsSpec.$,
        this.requestManifestDebugInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.parseManifestFromString =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.ManifestManager_ParseManifestFromString_ParamsSpec.$,
        blink.mojom.ManifestManager_ParseManifestFromString_ResponseParamsSpec.$,
        this.parseManifestFromString.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ManifestManager_RequestManifest_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ManifestManager_RequestManifest_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ManifestManager_RequestManifestDebugInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ManifestManager_RequestManifestDebugInfo_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ManifestManager_ParseManifestFromString_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ManifestManager_ParseManifestFromString_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.ManifestManager_RequestManifest_ParamsSpec.$,
    'ManifestManager_RequestManifest_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.ManifestManager_RequestManifest_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.ManifestManager_RequestManifest_ResponseParamsSpec.$,
    'ManifestManager_RequestManifest_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.ManifestRequestResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'manifest', 16,
        0,
        blink.mojom.ManifestSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.ManifestManager_RequestManifest_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.ManifestRequestResult } */
    this.result;
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !blink.mojom.Manifest } */
    this.manifest;
  }
};



mojo.internal.Struct(
    blink.mojom.ManifestManager_RequestManifestDebugInfo_ParamsSpec.$,
    'ManifestManager_RequestManifestDebugInfo_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.ManifestManager_RequestManifestDebugInfo_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.ManifestManager_RequestManifestDebugInfo_ResponseParamsSpec.$,
    'ManifestManager_RequestManifestDebugInfo_ResponseParams',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'parsedManifest', 8,
        0,
        blink.mojom.ManifestSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'debugInfo', 16,
        0,
        blink.mojom.ManifestDebugInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.ManifestManager_RequestManifestDebugInfo_ResponseParams = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !blink.mojom.Manifest } */
    this.parsedManifest;
    /** @export { !blink.mojom.ManifestDebugInfo } */
    this.debugInfo;
  }
};



mojo.internal.Struct(
    blink.mojom.ManifestManager_ParseManifestFromString_ParamsSpec.$,
    'ManifestManager_ParseManifestFromString_Params',
    [
      mojo.internal.StructField(
        'documentUrl', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'manifestUrl', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'manifestContent', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.ManifestManager_ParseManifestFromString_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.documentUrl;
    /** @export { !url.mojom.Url } */
    this.manifestUrl;
    /** @export { !string } */
    this.manifestContent;
  }
};



mojo.internal.Struct(
    blink.mojom.ManifestManager_ParseManifestFromString_ResponseParamsSpec.$,
    'ManifestManager_ParseManifestFromString_ResponseParams',
    [
      mojo.internal.StructField(
        'parsedManifest', 0,
        0,
        blink.mojom.ManifestSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.ManifestManager_ParseManifestFromString_ResponseParams = class {
  constructor() {
    /** @export { (blink.mojom.Manifest|undefined) } */
    this.parsedManifest;
  }
};

