// third_party/blink/public/mojom/manifest/manifest.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/manifest/manifest.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/manifest/manifest.mojom-params-data.h"
#include "third_party/blink/public/mojom/manifest/manifest.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/manifest/manifest.mojom-import-headers.h"
#include "third_party/blink/public/mojom/manifest/manifest.mojom-test-utils.h"
#include "third_party/blink/public/common/manifest/manifest_mojom_traits.h"


namespace blink::mojom {
Manifest::Manifest()
    : manifest_url(),
      dir(),
      name(),
      short_name(),
      description(),
      id(),
      has_custom_id(),
      start_url(),
      has_valid_specified_start_url(),
      display(),
      display_override(),
      borderless_url_patterns(),
      orientation(),
      icons(),
      screenshots(),
      shortcuts(),
      share_target(),
      file_handlers(),
      protocol_handlers(),
      scope_extensions(),
      lock_screen(),
      note_taking(),
      related_applications(),
      prefer_related_applications(),
      has_theme_color(),
      theme_color(),
      has_background_color(),
      background_color(),
      gcm_sender_id(),
      scope(),
      permissions_policy(),
      launch_handler(),
      translations(),
      has_dark_theme_color(),
      dark_theme_color(),
      has_dark_background_color(),
      dark_background_color(),
      tab_strip(),
      version(),
      name_localized(),
      short_name_localized(),
      description_localized(),
      icons_localized() {}

Manifest::Manifest(
    const ::GURL& manifest_url_in,
    Manifest::TextDirection dir_in,
    const std::optional<::std::u16string>& name_in,
    const std::optional<::std::u16string>& short_name_in,
    const std::optional<::std::u16string>& description_in,
    const ::GURL& id_in,
    bool has_custom_id_in,
    const ::GURL& start_url_in,
    bool has_valid_specified_start_url_in,
    ::blink::mojom::DisplayMode display_in,
    std::vector<::blink::mojom::DisplayMode> display_override_in,
    std::vector<::blink::SafeUrlPattern> borderless_url_patterns_in,
    ::device::mojom::ScreenOrientationLockType orientation_in,
    std::vector<::blink::Manifest::ImageResource> icons_in,
    std::vector<ManifestScreenshotPtr> screenshots_in,
    std::vector<::blink::Manifest::ShortcutItem> shortcuts_in,
    const std::optional<::blink::Manifest::ShareTarget>& share_target_in,
    std::vector<ManifestFileHandlerPtr> file_handlers_in,
    std::vector<ManifestProtocolHandlerPtr> protocol_handlers_in,
    std::vector<ManifestScopeExtensionPtr> scope_extensions_in,
    ManifestLockScreenPtr lock_screen_in,
    ManifestNoteTakingPtr note_taking_in,
    std::vector<::blink::Manifest::RelatedApplication> related_applications_in,
    bool prefer_related_applications_in,
    bool has_theme_color_in,
    uint32_t theme_color_in,
    bool has_background_color_in,
    uint32_t background_color_in,
    const std::optional<::std::u16string>& gcm_sender_id_in,
    const ::GURL& scope_in,
    std::vector<::network::ParsedPermissionsPolicyDeclaration> permissions_policy_in,
    const std::optional<::blink::Manifest::LaunchHandler>& launch_handler_in,
    const base::flat_map<::std::u16string, ::blink::Manifest::TranslationItem>& translations_in,
    bool has_dark_theme_color_in,
    uint32_t dark_theme_color_in,
    bool has_dark_background_color_in,
    uint32_t dark_background_color_in,
    const std::optional<::blink::Manifest::TabStrip>& tab_strip_in,
    const std::optional<::std::u16string>& version_in,
    base::flat_map<::std::u16string, ManifestLocalizedTextObjectPtr> name_localized_in,
    base::flat_map<::std::u16string, ManifestLocalizedTextObjectPtr> short_name_localized_in,
    base::flat_map<::std::u16string, ManifestLocalizedTextObjectPtr> description_localized_in,
    const base::flat_map<::std::u16string, std::vector<::blink::Manifest::ImageResource>>& icons_localized_in)
    : manifest_url(std::move(manifest_url_in)),
      dir(std::move(dir_in)),
      name(std::move(name_in)),
      short_name(std::move(short_name_in)),
      description(std::move(description_in)),
      id(std::move(id_in)),
      has_custom_id(std::move(has_custom_id_in)),
      start_url(std::move(start_url_in)),
      has_valid_specified_start_url(std::move(has_valid_specified_start_url_in)),
      display(std::move(display_in)),
      display_override(std::move(display_override_in)),
      borderless_url_patterns(std::move(borderless_url_patterns_in)),
      orientation(std::move(orientation_in)),
      icons(std::move(icons_in)),
      screenshots(std::move(screenshots_in)),
      shortcuts(std::move(shortcuts_in)),
      share_target(std::move(share_target_in)),
      file_handlers(std::move(file_handlers_in)),
      protocol_handlers(std::move(protocol_handlers_in)),
      scope_extensions(std::move(scope_extensions_in)),
      lock_screen(std::move(lock_screen_in)),
      note_taking(std::move(note_taking_in)),
      related_applications(std::move(related_applications_in)),
      prefer_related_applications(std::move(prefer_related_applications_in)),
      has_theme_color(std::move(has_theme_color_in)),
      theme_color(std::move(theme_color_in)),
      has_background_color(std::move(has_background_color_in)),
      background_color(std::move(background_color_in)),
      gcm_sender_id(std::move(gcm_sender_id_in)),
      scope(std::move(scope_in)),
      permissions_policy(std::move(permissions_policy_in)),
      launch_handler(std::move(launch_handler_in)),
      translations(std::move(translations_in)),
      has_dark_theme_color(std::move(has_dark_theme_color_in)),
      dark_theme_color(std::move(dark_theme_color_in)),
      has_dark_background_color(std::move(has_dark_background_color_in)),
      dark_background_color(std::move(dark_background_color_in)),
      tab_strip(std::move(tab_strip_in)),
      version(std::move(version_in)),
      name_localized(std::move(name_localized_in)),
      short_name_localized(std::move(short_name_localized_in)),
      description_localized(std::move(description_localized_in)),
      icons_localized(std::move(icons_localized_in)) {}

Manifest::~Manifest() = default;

void Manifest::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "manifest_url"), this->manifest_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dir"), this->dir,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type Manifest::TextDirection>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "short_name"), this->short_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "description"), this->description,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_custom_id"), this->has_custom_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "start_url"), this->start_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_valid_specified_start_url"), this->has_valid_specified_start_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display"), this->display,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::DisplayMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_override"), this->display_override,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::blink::mojom::DisplayMode>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "borderless_url_patterns"), this->borderless_url_patterns,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::blink::SafeUrlPattern>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "orientation"), this->orientation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::device::mojom::ScreenOrientationLockType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icons"), this->icons,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::blink::Manifest::ImageResource>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "screenshots"), this->screenshots,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<ManifestScreenshotPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shortcuts"), this->shortcuts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::blink::Manifest::ShortcutItem>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "share_target"), this->share_target,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::Manifest::ShareTarget>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file_handlers"), this->file_handlers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<ManifestFileHandlerPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "protocol_handlers"), this->protocol_handlers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<ManifestProtocolHandlerPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scope_extensions"), this->scope_extensions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<ManifestScopeExtensionPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "lock_screen"), this->lock_screen,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ManifestLockScreenPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "note_taking"), this->note_taking,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ManifestNoteTakingPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "related_applications"), this->related_applications,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::blink::Manifest::RelatedApplication>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prefer_related_applications"), this->prefer_related_applications,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_theme_color"), this->has_theme_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "theme_color"), this->theme_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_background_color"), this->has_background_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "background_color"), this->background_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gcm_sender_id"), this->gcm_sender_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scope"), this->scope,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "permissions_policy"), this->permissions_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::network::ParsedPermissionsPolicyDeclaration>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "launch_handler"), this->launch_handler,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::Manifest::LaunchHandler>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "translations"), this->translations,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<::std::u16string, ::blink::Manifest::TranslationItem>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_dark_theme_color"), this->has_dark_theme_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dark_theme_color"), this->dark_theme_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_dark_background_color"), this->has_dark_background_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dark_background_color"), this->dark_background_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tab_strip"), this->tab_strip,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::Manifest::TabStrip>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "version"), this->version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name_localized"), this->name_localized,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type base::flat_map<::std::u16string, ManifestLocalizedTextObjectPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "short_name_localized"), this->short_name_localized,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type base::flat_map<::std::u16string, ManifestLocalizedTextObjectPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "description_localized"), this->description_localized,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type base::flat_map<::std::u16string, ManifestLocalizedTextObjectPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icons_localized"), this->icons_localized,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<::std::u16string, std::vector<::blink::Manifest::ImageResource>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Manifest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ManifestLocalizedTextObject::ManifestLocalizedTextObject()
    : value(),
      dir(),
      lang() {}

ManifestLocalizedTextObject::ManifestLocalizedTextObject(
    const ::std::u16string& value_in,
    std::optional<Manifest::TextDirection> dir_in,
    const std::optional<::std::u16string>& lang_in)
    : value(std::move(value_in)),
      dir(std::move(dir_in)),
      lang(std::move(lang_in)) {}

ManifestLocalizedTextObject::~ManifestLocalizedTextObject() = default;

void ManifestLocalizedTextObject::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dir"), this->dir,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<Manifest::TextDirection>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "lang"), this->lang,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ManifestLocalizedTextObject::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ManifestShortcutItem::ManifestShortcutItem()
    : name(),
      short_name(),
      description(),
      url(),
      icons(),
      name_localized(),
      short_name_localized(),
      description_localized(),
      icons_localized() {}

ManifestShortcutItem::ManifestShortcutItem(
    const ::std::u16string& name_in,
    const std::optional<::std::u16string>& short_name_in,
    const std::optional<::std::u16string>& description_in,
    const ::GURL& url_in,
    std::vector<::blink::Manifest::ImageResource> icons_in,
    base::flat_map<::std::u16string, ManifestLocalizedTextObjectPtr> name_localized_in,
    base::flat_map<::std::u16string, ManifestLocalizedTextObjectPtr> short_name_localized_in,
    base::flat_map<::std::u16string, ManifestLocalizedTextObjectPtr> description_localized_in,
    const base::flat_map<::std::u16string, std::vector<::blink::Manifest::ImageResource>>& icons_localized_in)
    : name(std::move(name_in)),
      short_name(std::move(short_name_in)),
      description(std::move(description_in)),
      url(std::move(url_in)),
      icons(std::move(icons_in)),
      name_localized(std::move(name_localized_in)),
      short_name_localized(std::move(short_name_localized_in)),
      description_localized(std::move(description_localized_in)),
      icons_localized(std::move(icons_localized_in)) {}

ManifestShortcutItem::~ManifestShortcutItem() = default;

void ManifestShortcutItem::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "short_name"), this->short_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "description"), this->description,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icons"), this->icons,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::blink::Manifest::ImageResource>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name_localized"), this->name_localized,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type base::flat_map<::std::u16string, ManifestLocalizedTextObjectPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "short_name_localized"), this->short_name_localized,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type base::flat_map<::std::u16string, ManifestLocalizedTextObjectPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "description_localized"), this->description_localized,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type base::flat_map<::std::u16string, ManifestLocalizedTextObjectPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icons_localized"), this->icons_localized,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<::std::u16string, std::vector<::blink::Manifest::ImageResource>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ManifestShortcutItem::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ManifestImageResource::ManifestImageResource()
    : src(),
      type(),
      sizes(),
      purpose() {}

ManifestImageResource::ManifestImageResource(
    const ::GURL& src_in,
    const std::optional<::std::u16string>& type_in,
    std::vector<::gfx::Size> sizes_in,
    std::vector<ManifestImageResource::Purpose> purpose_in)
    : src(std::move(src_in)),
      type(std::move(type_in)),
      sizes(std::move(sizes_in)),
      purpose(std::move(purpose_in)) {}

ManifestImageResource::~ManifestImageResource() = default;

void ManifestImageResource::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "src"), this->src,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sizes"), this->sizes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::gfx::Size>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "purpose"), this->purpose,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<ManifestImageResource::Purpose>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ManifestImageResource::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ManifestScreenshot::ManifestScreenshot()
    : image(),
      form_factor(),
      label() {}

ManifestScreenshot::ManifestScreenshot(
    const ::blink::Manifest::ImageResource& image_in,
    ManifestScreenshot::FormFactor form_factor_in,
    const std::optional<::std::u16string>& label_in)
    : image(std::move(image_in)),
      form_factor(std::move(form_factor_in)),
      label(std::move(label_in)) {}

ManifestScreenshot::~ManifestScreenshot() = default;

void ManifestScreenshot::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image"), this->image,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Manifest::ImageResource&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "form_factor"), this->form_factor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ManifestScreenshot::FormFactor>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ManifestScreenshot::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ManifestFileFilter::ManifestFileFilter()
    : name(),
      accept() {}

ManifestFileFilter::ManifestFileFilter(
    const std::optional<::std::u16string>& name_in,
    std::vector<::std::u16string> accept_in)
    : name(std::move(name_in)),
      accept(std::move(accept_in)) {}

ManifestFileFilter::~ManifestFileFilter() = default;

void ManifestFileFilter::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "accept"), this->accept,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ManifestFileFilter::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ManifestProtocolHandler::ManifestProtocolHandler()
    : protocol(),
      url() {}

ManifestProtocolHandler::ManifestProtocolHandler(
    const ::std::u16string& protocol_in,
    const ::GURL& url_in)
    : protocol(std::move(protocol_in)),
      url(std::move(url_in)) {}

ManifestProtocolHandler::~ManifestProtocolHandler() = default;

void ManifestProtocolHandler::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "protocol"), this->protocol,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ManifestProtocolHandler::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ManifestScopeExtension::ManifestScopeExtension()
    : origin(),
      has_origin_wildcard() {}

ManifestScopeExtension::ManifestScopeExtension(
    const ::url::Origin& origin_in,
    bool has_origin_wildcard_in)
    : origin(std::move(origin_in)),
      has_origin_wildcard(std::move(has_origin_wildcard_in)) {}

ManifestScopeExtension::~ManifestScopeExtension() = default;

void ManifestScopeExtension::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin"), this->origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_origin_wildcard"), this->has_origin_wildcard,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ManifestScopeExtension::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ManifestLockScreen::ManifestLockScreen()
    : start_url() {}

ManifestLockScreen::ManifestLockScreen(
    const ::GURL& start_url_in)
    : start_url(std::move(start_url_in)) {}

ManifestLockScreen::~ManifestLockScreen() = default;

void ManifestLockScreen::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "start_url"), this->start_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ManifestLockScreen::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ManifestNoteTaking::ManifestNoteTaking()
    : new_note_url() {}

ManifestNoteTaking::ManifestNoteTaking(
    const ::GURL& new_note_url_in)
    : new_note_url(std::move(new_note_url_in)) {}

ManifestNoteTaking::~ManifestNoteTaking() = default;

void ManifestNoteTaking::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "new_note_url"), this->new_note_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ManifestNoteTaking::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ManifestRelatedApplication::ManifestRelatedApplication()
    : platform(),
      url(),
      id() {}

ManifestRelatedApplication::ManifestRelatedApplication(
    const std::optional<::std::u16string>& platform_in,
    const std::optional<::GURL>& url_in,
    const std::optional<::std::u16string>& id_in)
    : platform(std::move(platform_in)),
      url(std::move(url_in)),
      id(std::move(id_in)) {}

ManifestRelatedApplication::~ManifestRelatedApplication() = default;

void ManifestRelatedApplication::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "platform"), this->platform,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ManifestRelatedApplication::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ManifestShareTargetParams::ManifestShareTargetParams()
    : title(),
      text(),
      url(),
      files() {}

ManifestShareTargetParams::ManifestShareTargetParams(
    const std::optional<::std::u16string>& title_in,
    const std::optional<::std::u16string>& text_in,
    const std::optional<::std::u16string>& url_in,
    std::optional<std::vector<ManifestFileFilterPtr>> files_in)
    : title(std::move(title_in)),
      text(std::move(text_in)),
      url(std::move(url_in)),
      files(std::move(files_in)) {}

ManifestShareTargetParams::~ManifestShareTargetParams() = default;

void ManifestShareTargetParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text"), this->text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "files"), this->files,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<std::vector<ManifestFileFilterPtr>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ManifestShareTargetParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ManifestShareTarget::ManifestShareTarget()
    : action(),
      method(),
      enctype(),
      params() {}

ManifestShareTarget::ManifestShareTarget(
    const ::GURL& action_in,
    ManifestShareTarget::Method method_in,
    ManifestShareTarget::Enctype enctype_in,
    ManifestShareTargetParamsPtr params_in)
    : action(std::move(action_in)),
      method(std::move(method_in)),
      enctype(std::move(enctype_in)),
      params(std::move(params_in)) {}

ManifestShareTarget::~ManifestShareTarget() = default;

void ManifestShareTarget::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "action"), this->action,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "method"), this->method,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ManifestShareTarget::Method>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enctype"), this->enctype,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ManifestShareTarget::Enctype>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "params"), this->params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ManifestShareTargetParamsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ManifestShareTarget::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ManifestFileHandler::ManifestFileHandler()
    : action(),
      name(),
      icons(),
      accept(),
      launch_type() {}

ManifestFileHandler::ManifestFileHandler(
    const ::GURL& action_in,
    const ::std::u16string& name_in,
    std::vector<::blink::Manifest::ImageResource> icons_in,
    const base::flat_map<::std::u16string, std::vector<::std::u16string>>& accept_in,
    ManifestFileHandler::LaunchType launch_type_in)
    : action(std::move(action_in)),
      name(std::move(name_in)),
      icons(std::move(icons_in)),
      accept(std::move(accept_in)),
      launch_type(std::move(launch_type_in)) {}

ManifestFileHandler::~ManifestFileHandler() = default;

void ManifestFileHandler::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "action"), this->action,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icons"), this->icons,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::blink::Manifest::ImageResource>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "accept"), this->accept,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<::std::u16string, std::vector<::std::u16string>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "launch_type"), this->launch_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ManifestFileHandler::LaunchType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ManifestFileHandler::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ManifestTranslationItem::ManifestTranslationItem()
    : name(),
      short_name(),
      description() {}

ManifestTranslationItem::ManifestTranslationItem(
    const std::optional<::std::u16string>& name_in,
    const std::optional<::std::u16string>& short_name_in,
    const std::optional<::std::u16string>& description_in)
    : name(std::move(name_in)),
      short_name(std::move(short_name_in)),
      description(std::move(description_in)) {}

ManifestTranslationItem::~ManifestTranslationItem() = default;

void ManifestTranslationItem::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "short_name"), this->short_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "description"), this->description,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ManifestTranslationItem::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ManifestTabStrip::ManifestTabStrip()
    : home_tab(),
      new_tab_button() {}

ManifestTabStrip::ManifestTabStrip(
    HomeTabUnionPtr home_tab_in,
    NewTabButtonParamsPtr new_tab_button_in)
    : home_tab(std::move(home_tab_in)),
      new_tab_button(std::move(new_tab_button_in)) {}

ManifestTabStrip::~ManifestTabStrip() = default;

void ManifestTabStrip::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "home_tab"), this->home_tab,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type HomeTabUnionPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "new_tab_button"), this->new_tab_button,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type NewTabButtonParamsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ManifestTabStrip::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HomeTabParams::HomeTabParams()
    : icons(),
      scope_patterns() {}

HomeTabParams::HomeTabParams(
    std::vector<::blink::Manifest::ImageResource> icons_in,
    std::vector<::blink::SafeUrlPattern> scope_patterns_in)
    : icons(std::move(icons_in)),
      scope_patterns(std::move(scope_patterns_in)) {}

HomeTabParams::~HomeTabParams() = default;

void HomeTabParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icons"), this->icons,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::blink::Manifest::ImageResource>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scope_patterns"), this->scope_patterns,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::blink::SafeUrlPattern>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HomeTabParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NewTabButtonParams::NewTabButtonParams()
    : url() {}

NewTabButtonParams::NewTabButtonParams(
    const std::optional<::GURL>& url_in)
    : url(std::move(url_in)) {}

NewTabButtonParams::~NewTabButtonParams() = default;

void NewTabButtonParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool NewTabButtonParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ManifestDebugInfo::ManifestDebugInfo()
    : errors(),
      raw_manifest() {}

ManifestDebugInfo::ManifestDebugInfo(
    std::vector<ManifestErrorPtr> errors_in,
    const std::string& raw_manifest_in)
    : errors(std::move(errors_in)),
      raw_manifest(std::move(raw_manifest_in)) {}

ManifestDebugInfo::~ManifestDebugInfo() = default;

void ManifestDebugInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "errors"), this->errors,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<ManifestErrorPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "raw_manifest"), this->raw_manifest,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ManifestDebugInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ManifestError::ManifestError()
    : message(),
      critical(),
      line(),
      column() {}

ManifestError::ManifestError(
    const std::string& message_in,
    bool critical_in,
    uint32_t line_in,
    uint32_t column_in)
    : message(std::move(message_in)),
      critical(std::move(critical_in)),
      line(std::move(line_in)),
      column(std::move(column_in)) {}

ManifestError::~ManifestError() = default;
size_t ManifestError::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->message);
  seed = mojo::internal::Hash(seed, this->critical);
  seed = mojo::internal::Hash(seed, this->line);
  seed = mojo::internal::Hash(seed, this->column);
  return seed;
}

void ManifestError::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "message"), this->message,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "critical"), this->critical,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "line"), this->line,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "column"), this->column,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ManifestError::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HomeTabUnionPtr
HomeTabUnion::NewVisibility(
    TabStripMemberVisibility value) {
  return HomeTabUnionPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kVisibility)>,
      std::move(value));
}

HomeTabUnionPtr
HomeTabUnion::NewParams(
    HomeTabParamsPtr value) {
  return HomeTabUnionPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kParams)>,
      std::move(value));
}

HomeTabUnion::HomeTabUnion(
    std::in_place_index_t<static_cast<size_t>(Tag::kVisibility)>,
    TabStripMemberVisibility value)
    : tag_(Tag::kVisibility),
      data_(std::in_place_index<static_cast<size_t>(Tag::kVisibility)>,
            std::move(value)) {}

HomeTabUnion::HomeTabUnion(
    std::in_place_index_t<static_cast<size_t>(Tag::kParams)>,
    HomeTabParamsPtr value)
    : tag_(Tag::kParams),
      data_(std::in_place_index<static_cast<size_t>(Tag::kParams)>,
            std::move(value)) {}
HomeTabUnion::~HomeTabUnion() {
  DestroyActive();
}

void HomeTabUnion::set_visibility(TabStripMemberVisibility visibility) {
  if (tag_ != Tag::kVisibility) {
    DestroyActive();
    tag_ = Tag::kVisibility;
  }
  data_.visibility = visibility;
}

void HomeTabUnion::set_params(HomeTabParamsPtr params) {
  if (tag_ == Tag::kParams) {
    data_.params = std::move(params);
  } else {
    DestroyActive();
    tag_ = Tag::kParams;
    new (&data_.params) HomeTabParamsPtr(
        std::move(params));
  }
}


HomeTabUnion::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kVisibility)>,
    TabStripMemberVisibility value)
    : visibility(std::move(value)) {}

HomeTabUnion::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kParams)>,
    HomeTabParamsPtr value)
    : params(std::move(value)) {}

void HomeTabUnion::DestroyActive() {
  switch (tag_) {

    case Tag::kVisibility:
      std::destroy_at(&data_.visibility);
      break;
    case Tag::kParams:
      std::destroy_at(&data_.params);
      break;
  }
}

bool HomeTabUnion::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}


}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::Manifest::DataView, ::blink::mojom::ManifestPtr>::Read(
    ::blink::mojom::Manifest::DataView input,
    ::blink::mojom::ManifestPtr* output) {
  bool success = true;
  ::blink::mojom::ManifestPtr result(::blink::mojom::Manifest::New());
  
      if (success && !input.ReadManifestUrl(&result->manifest_url))
        success = false;
      if (success && !input.ReadDir(&result->dir))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadShortName(&result->short_name))
        success = false;
      if (success && !input.ReadDescription(&result->description))
        success = false;
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success)
        result->has_custom_id = input.has_custom_id();
      if (success && !input.ReadStartUrl(&result->start_url))
        success = false;
      if (success)
        result->has_valid_specified_start_url = input.has_valid_specified_start_url();
      if (success && !input.ReadDisplay(&result->display))
        success = false;
      if (success && !input.ReadDisplayOverride(&result->display_override))
        success = false;
      if (success && !input.ReadBorderlessUrlPatterns(&result->borderless_url_patterns))
        success = false;
      if (success && !input.ReadOrientation(&result->orientation))
        success = false;
      if (success && !input.ReadIcons(&result->icons))
        success = false;
      if (success && !input.ReadScreenshots(&result->screenshots))
        success = false;
      if (success && !input.ReadShortcuts(&result->shortcuts))
        success = false;
      if (success && !input.ReadShareTarget(&result->share_target))
        success = false;
      if (success && !input.ReadFileHandlers(&result->file_handlers))
        success = false;
      if (success && !input.ReadProtocolHandlers(&result->protocol_handlers))
        success = false;
      if (success && !input.ReadScopeExtensions(&result->scope_extensions))
        success = false;
      if (success && !input.ReadLockScreen(&result->lock_screen))
        success = false;
      if (success && !input.ReadNoteTaking(&result->note_taking))
        success = false;
      if (success && !input.ReadRelatedApplications(&result->related_applications))
        success = false;
      if (success)
        result->prefer_related_applications = input.prefer_related_applications();
      if (success)
        result->has_theme_color = input.has_theme_color();
      if (success)
        result->theme_color = input.theme_color();
      if (success)
        result->has_background_color = input.has_background_color();
      if (success)
        result->background_color = input.background_color();
      if (success && !input.ReadGcmSenderId(&result->gcm_sender_id))
        success = false;
      if (success && !input.ReadScope(&result->scope))
        success = false;
      if (success && !input.ReadPermissionsPolicy(&result->permissions_policy))
        success = false;
      if (success && !input.ReadLaunchHandler(&result->launch_handler))
        success = false;
      if (success && !input.ReadTranslations(&result->translations))
        success = false;
      if (success)
        result->has_dark_theme_color = input.has_dark_theme_color();
      if (success)
        result->dark_theme_color = input.dark_theme_color();
      if (success)
        result->has_dark_background_color = input.has_dark_background_color();
      if (success)
        result->dark_background_color = input.dark_background_color();
      if (success && !input.ReadTabStrip(&result->tab_strip))
        success = false;
      if (success && !input.ReadVersion(&result->version))
        success = false;
      if (success && !input.ReadNameLocalized(&result->name_localized))
        success = false;
      if (success && !input.ReadShortNameLocalized(&result->short_name_localized))
        success = false;
      if (success && !input.ReadDescriptionLocalized(&result->description_localized))
        success = false;
      if (success && !input.ReadIconsLocalized(&result->icons_localized))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ManifestLocalizedTextObject::DataView, ::blink::mojom::ManifestLocalizedTextObjectPtr>::Read(
    ::blink::mojom::ManifestLocalizedTextObject::DataView input,
    ::blink::mojom::ManifestLocalizedTextObjectPtr* output) {
  bool success = true;
  ::blink::mojom::ManifestLocalizedTextObjectPtr result(::blink::mojom::ManifestLocalizedTextObject::New());
  
      if (success && !input.ReadValue(&result->value))
        success = false;
      if (success && !input.ReadDir(&result->dir)) {
        success = false;
      }
      if (success && !input.ReadLang(&result->lang))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ManifestShortcutItem::DataView, ::blink::mojom::ManifestShortcutItemPtr>::Read(
    ::blink::mojom::ManifestShortcutItem::DataView input,
    ::blink::mojom::ManifestShortcutItemPtr* output) {
  bool success = true;
  ::blink::mojom::ManifestShortcutItemPtr result(::blink::mojom::ManifestShortcutItem::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadShortName(&result->short_name))
        success = false;
      if (success && !input.ReadDescription(&result->description))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadIcons(&result->icons))
        success = false;
      if (success && !input.ReadNameLocalized(&result->name_localized))
        success = false;
      if (success && !input.ReadShortNameLocalized(&result->short_name_localized))
        success = false;
      if (success && !input.ReadDescriptionLocalized(&result->description_localized))
        success = false;
      if (success && !input.ReadIconsLocalized(&result->icons_localized))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ManifestImageResource::DataView, ::blink::mojom::ManifestImageResourcePtr>::Read(
    ::blink::mojom::ManifestImageResource::DataView input,
    ::blink::mojom::ManifestImageResourcePtr* output) {
  bool success = true;
  ::blink::mojom::ManifestImageResourcePtr result(::blink::mojom::ManifestImageResource::New());
  
      if (success && !input.ReadSrc(&result->src))
        success = false;
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadSizes(&result->sizes))
        success = false;
      if (success && !input.ReadPurpose(&result->purpose))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ManifestScreenshot::DataView, ::blink::mojom::ManifestScreenshotPtr>::Read(
    ::blink::mojom::ManifestScreenshot::DataView input,
    ::blink::mojom::ManifestScreenshotPtr* output) {
  bool success = true;
  ::blink::mojom::ManifestScreenshotPtr result(::blink::mojom::ManifestScreenshot::New());
  
      if (success && !input.ReadImage(&result->image))
        success = false;
      if (success && !input.ReadFormFactor(&result->form_factor))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ManifestFileFilter::DataView, ::blink::mojom::ManifestFileFilterPtr>::Read(
    ::blink::mojom::ManifestFileFilter::DataView input,
    ::blink::mojom::ManifestFileFilterPtr* output) {
  bool success = true;
  ::blink::mojom::ManifestFileFilterPtr result(::blink::mojom::ManifestFileFilter::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadAccept(&result->accept))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ManifestProtocolHandler::DataView, ::blink::mojom::ManifestProtocolHandlerPtr>::Read(
    ::blink::mojom::ManifestProtocolHandler::DataView input,
    ::blink::mojom::ManifestProtocolHandlerPtr* output) {
  bool success = true;
  ::blink::mojom::ManifestProtocolHandlerPtr result(::blink::mojom::ManifestProtocolHandler::New());
  
      if (success && !input.ReadProtocol(&result->protocol))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ManifestScopeExtension::DataView, ::blink::mojom::ManifestScopeExtensionPtr>::Read(
    ::blink::mojom::ManifestScopeExtension::DataView input,
    ::blink::mojom::ManifestScopeExtensionPtr* output) {
  bool success = true;
  ::blink::mojom::ManifestScopeExtensionPtr result(::blink::mojom::ManifestScopeExtension::New());
  
      if (success && !input.ReadOrigin(&result->origin))
        success = false;
      if (success)
        result->has_origin_wildcard = input.has_origin_wildcard();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ManifestLockScreen::DataView, ::blink::mojom::ManifestLockScreenPtr>::Read(
    ::blink::mojom::ManifestLockScreen::DataView input,
    ::blink::mojom::ManifestLockScreenPtr* output) {
  bool success = true;
  ::blink::mojom::ManifestLockScreenPtr result(::blink::mojom::ManifestLockScreen::New());
  
      if (success && !input.ReadStartUrl(&result->start_url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ManifestNoteTaking::DataView, ::blink::mojom::ManifestNoteTakingPtr>::Read(
    ::blink::mojom::ManifestNoteTaking::DataView input,
    ::blink::mojom::ManifestNoteTakingPtr* output) {
  bool success = true;
  ::blink::mojom::ManifestNoteTakingPtr result(::blink::mojom::ManifestNoteTaking::New());
  
      if (success && !input.ReadNewNoteUrl(&result->new_note_url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ManifestRelatedApplication::DataView, ::blink::mojom::ManifestRelatedApplicationPtr>::Read(
    ::blink::mojom::ManifestRelatedApplication::DataView input,
    ::blink::mojom::ManifestRelatedApplicationPtr* output) {
  bool success = true;
  ::blink::mojom::ManifestRelatedApplicationPtr result(::blink::mojom::ManifestRelatedApplication::New());
  
      if (success && !input.ReadPlatform(&result->platform))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadId(&result->id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ManifestShareTargetParams::DataView, ::blink::mojom::ManifestShareTargetParamsPtr>::Read(
    ::blink::mojom::ManifestShareTargetParams::DataView input,
    ::blink::mojom::ManifestShareTargetParamsPtr* output) {
  bool success = true;
  ::blink::mojom::ManifestShareTargetParamsPtr result(::blink::mojom::ManifestShareTargetParams::New());
  
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadText(&result->text))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadFiles(&result->files))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ManifestShareTarget::DataView, ::blink::mojom::ManifestShareTargetPtr>::Read(
    ::blink::mojom::ManifestShareTarget::DataView input,
    ::blink::mojom::ManifestShareTargetPtr* output) {
  bool success = true;
  ::blink::mojom::ManifestShareTargetPtr result(::blink::mojom::ManifestShareTarget::New());
  
      if (success && !input.ReadAction(&result->action))
        success = false;
      if (success && !input.ReadMethod(&result->method))
        success = false;
      if (success && !input.ReadEnctype(&result->enctype))
        success = false;
      if (success && !input.ReadParams(&result->params))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ManifestFileHandler::DataView, ::blink::mojom::ManifestFileHandlerPtr>::Read(
    ::blink::mojom::ManifestFileHandler::DataView input,
    ::blink::mojom::ManifestFileHandlerPtr* output) {
  bool success = true;
  ::blink::mojom::ManifestFileHandlerPtr result(::blink::mojom::ManifestFileHandler::New());
  
      if (success && !input.ReadAction(&result->action))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadIcons(&result->icons))
        success = false;
      if (success && !input.ReadAccept(&result->accept))
        success = false;
      if (success && !input.ReadLaunchType(&result->launch_type))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ManifestTranslationItem::DataView, ::blink::mojom::ManifestTranslationItemPtr>::Read(
    ::blink::mojom::ManifestTranslationItem::DataView input,
    ::blink::mojom::ManifestTranslationItemPtr* output) {
  bool success = true;
  ::blink::mojom::ManifestTranslationItemPtr result(::blink::mojom::ManifestTranslationItem::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadShortName(&result->short_name))
        success = false;
      if (success && !input.ReadDescription(&result->description))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ManifestTabStrip::DataView, ::blink::mojom::ManifestTabStripPtr>::Read(
    ::blink::mojom::ManifestTabStrip::DataView input,
    ::blink::mojom::ManifestTabStripPtr* output) {
  bool success = true;
  ::blink::mojom::ManifestTabStripPtr result(::blink::mojom::ManifestTabStrip::New());
  
      if (success && !input.ReadHomeTab(&result->home_tab))
        success = false;
      if (success && !input.ReadNewTabButton(&result->new_tab_button))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::HomeTabParams::DataView, ::blink::mojom::HomeTabParamsPtr>::Read(
    ::blink::mojom::HomeTabParams::DataView input,
    ::blink::mojom::HomeTabParamsPtr* output) {
  bool success = true;
  ::blink::mojom::HomeTabParamsPtr result(::blink::mojom::HomeTabParams::New());
  
      if (success && !input.ReadIcons(&result->icons))
        success = false;
      if (success && !input.ReadScopePatterns(&result->scope_patterns))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::NewTabButtonParams::DataView, ::blink::mojom::NewTabButtonParamsPtr>::Read(
    ::blink::mojom::NewTabButtonParams::DataView input,
    ::blink::mojom::NewTabButtonParamsPtr* output) {
  bool success = true;
  ::blink::mojom::NewTabButtonParamsPtr result(::blink::mojom::NewTabButtonParams::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ManifestDebugInfo::DataView, ::blink::mojom::ManifestDebugInfoPtr>::Read(
    ::blink::mojom::ManifestDebugInfo::DataView input,
    ::blink::mojom::ManifestDebugInfoPtr* output) {
  bool success = true;
  ::blink::mojom::ManifestDebugInfoPtr result(::blink::mojom::ManifestDebugInfo::New());
  
      if (success && !input.ReadErrors(&result->errors))
        success = false;
      if (success && !input.ReadRawManifest(&result->raw_manifest))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ManifestError::DataView, ::blink::mojom::ManifestErrorPtr>::Read(
    ::blink::mojom::ManifestError::DataView input,
    ::blink::mojom::ManifestErrorPtr* output) {
  bool success = true;
  ::blink::mojom::ManifestErrorPtr result(::blink::mojom::ManifestError::New());
  
      if (success && !input.ReadMessage(&result->message))
        success = false;
      if (success)
        result->critical = input.critical();
      if (success)
        result->line = input.line();
      if (success)
        result->column = input.column();
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::blink::mojom::HomeTabUnion::DataView, ::blink::mojom::HomeTabUnionPtr>::Read(
    ::blink::mojom::HomeTabUnion::DataView input,
    ::blink::mojom::HomeTabUnionPtr* output) {
  using UnionType = ::blink::mojom::HomeTabUnion;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kVisibility: {
      ::blink::mojom::TabStripMemberVisibility result_visibility;
      if (!input.ReadVisibility(&result_visibility))
        return false;

      *output = UnionType::NewVisibility(result_visibility);
      break;
    }
    case Tag::kParams: {
      ::blink::mojom::HomeTabParamsPtr result_params{};
      if (!input.ReadParams(&result_params))
        return false;

      *output = UnionType::NewParams(
          std::move(result_params));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {




}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif