// third_party/blink/public/mojom/locks/lock_manager.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/locks/lock_manager.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/locks/lock_manager.mojom-params-data.h"
#include "third_party/blink/public/mojom/locks/lock_manager.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/locks/lock_manager.mojom-import-headers.h"
#include "third_party/blink/public/mojom/locks/lock_manager.mojom-test-utils.h"


namespace blink::mojom {
LockInfo::LockInfo()
    : name(),
      mode(),
      client_id() {}

LockInfo::LockInfo(
    const std::string& name_in,
    LockMode mode_in,
    const std::string& client_id_in)
    : name(std::move(name_in)),
      mode(std::move(mode_in)),
      client_id(std::move(client_id_in)) {}

LockInfo::~LockInfo() = default;
size_t LockInfo::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->name);
  seed = mojo::internal::Hash(seed, this->mode);
  seed = mojo::internal::Hash(seed, this->client_id);
  return seed;
}

void LockInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mode"), this->mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type LockMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client_id"), this->client_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LockInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

LockHandle::IPCStableHashFunction LockHandle::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* LockHandle::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
# endif // !BUILDFLAG(IS_FUCHSIA)

LockHandleProxy::LockHandleProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

// static
bool LockHandleStubDispatch::Accept(
    LockHandle* impl,
    mojo::Message* message) {
  return false;
}

// static
bool LockHandleStubDispatch::AcceptWithResponder(
    LockHandle* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  return false;
}
namespace {
}  // namespace

bool LockHandleRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::blink::mojom::LockHandle::Name_,
    {});
}

// The declaration includes the definition on other builds.

LockRequest::IPCStableHashFunction LockRequest::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::LockRequest>(message.name())) {
    case messages::LockRequest::kGranted: {
      return &LockRequest::Granted_Sym::IPCStableHash;
    }
    case messages::LockRequest::kFailed: {
      return &LockRequest::Failed_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* LockRequest::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::LockRequest>(message.name())) {
      case messages::LockRequest::kGranted:
            return "Receive blink::mojom::LockRequest::Granted";
      case messages::LockRequest::kFailed:
            return "Receive blink::mojom::LockRequest::Failed";
    }
  } else {
    switch (static_cast<messages::LockRequest>(message.name())) {
      case messages::LockRequest::kGranted:
            return "Receive reply blink::mojom::LockRequest::Granted";
      case messages::LockRequest::kFailed:
            return "Receive reply blink::mojom::LockRequest::Failed";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t LockRequest::Granted_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1ae47e99;  // IPCStableHash for blink::mojom::LockRequest::Granted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LockRequest::Failed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x89f77ba5;  // IPCStableHash for blink::mojom::LockRequest::Failed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

LockRequestProxy::LockRequestProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LockRequestProxy::Granted(
    ::mojo::PendingAssociatedRemote<LockHandle> in_lock_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LockRequest::Granted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("lock_handle"), in_lock_handle,
                        "<value of type ::mojo::PendingAssociatedRemote<LockHandle>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LockRequest::kGranted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LockRequest_Granted_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::LockHandleAssociatedPtrInfoDataView>(
    in_lock_handle,
    &params->lock_handle,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->lock_handle)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid lock_handle in LockRequest.Granted request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LockRequest::Name_);
  message.set_method_name("Granted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LockRequestProxy::Failed(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::LockRequest::Failed");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LockRequest::kFailed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LockRequest_Failed_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LockRequest::Name_);
  message.set_method_name("Failed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool LockRequestStubDispatch::Accept(
    LockRequest* impl,
    mojo::Message* message) {
  switch (static_cast<messages::LockRequest>(message->header()->name)) {
    case messages::LockRequest::kGranted: {
      DCHECK(message->is_serialized());
      internal::LockRequest_Granted_Params_Data* params =
          reinterpret_cast<internal::LockRequest_Granted_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LockRequest.0
      bool success = true;
      ::mojo::PendingAssociatedRemote<LockHandle> p_lock_handle{};
      LockRequest_Granted_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_lock_handle =
            input_data_view.TakeLockHandle<decltype(p_lock_handle)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LockRequest::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Granted(        
        std::move(p_lock_handle));
      return true;
    }
    case messages::LockRequest::kFailed: {
      DCHECK(message->is_serialized());
      internal::LockRequest_Failed_Params_Data* params =
          reinterpret_cast<internal::LockRequest_Failed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LockRequest.1
      bool success = true;
      LockRequest_Failed_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LockRequest::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Failed(        );
      return true;
    }
  }
  return false;
}

// static
bool LockRequestStubDispatch::AcceptWithResponder(
    LockRequest* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::LockRequest>(message->header()->name)) {
    case messages::LockRequest::kGranted: {
      break;
    }
    case messages::LockRequest::kFailed: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kLockRequestValidationInfo[] = {
    { &internal::LockRequest_Granted_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LockRequest_Failed_Params_Data::Validate,
     nullptr /* no response */},
};

bool LockRequestRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::LockRequest::Name_,
    kLockRequestValidationInfo);
}

// The declaration includes the definition on other builds.

LockManager::IPCStableHashFunction LockManager::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::LockManager>(message.name())) {
    case messages::LockManager::kRequestLock: {
      return &LockManager::RequestLock_Sym::IPCStableHash;
    }
    case messages::LockManager::kQueryState: {
      return &LockManager::QueryState_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* LockManager::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::LockManager>(message.name())) {
      case messages::LockManager::kRequestLock:
            return "Receive blink::mojom::LockManager::RequestLock";
      case messages::LockManager::kQueryState:
            return "Receive blink::mojom::LockManager::QueryState";
    }
  } else {
    switch (static_cast<messages::LockManager>(message.name())) {
      case messages::LockManager::kRequestLock:
            return "Receive reply blink::mojom::LockManager::RequestLock";
      case messages::LockManager::kQueryState:
            return "Receive reply blink::mojom::LockManager::QueryState";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t LockManager::RequestLock_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe3d2e5b4;  // IPCStableHash for blink::mojom::LockManager::RequestLock
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LockManager::QueryState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x54e60002;  // IPCStableHash for blink::mojom::LockManager::QueryState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class LockManager_QueryState_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LockManager_QueryState_ForwardToCallback(
      LockManager::QueryStateCallback callback
      ) : callback_(std::move(callback)) {
  }

  LockManager_QueryState_ForwardToCallback(const LockManager_QueryState_ForwardToCallback&) = delete;
  LockManager_QueryState_ForwardToCallback& operator=(const LockManager_QueryState_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LockManager::QueryStateCallback callback_;
};

LockManagerProxy::LockManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LockManagerProxy::RequestLock(
    const std::string& in_name, LockMode in_mode, LockManager::WaitMode in_wait, ::mojo::PendingAssociatedRemote<LockRequest> in_request) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LockManager::RequestLock", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mode"), in_mode,
                        "<value of type LockMode>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("wait"), in_wait,
                        "<value of type LockManager::WaitMode>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request"), in_request,
                        "<value of type ::mojo::PendingAssociatedRemote<LockRequest>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LockManager::kRequestLock), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LockManager_RequestLock_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null name in LockManager.RequestLock request");

  
  mojo::internal::Serialize<::blink::mojom::LockMode>(
    in_mode,
    &params->mode);

  
  mojo::internal::Serialize<::blink::mojom::LockManager_WaitMode>(
    in_wait,
    &params->wait);

  
  mojo::internal::Serialize<::blink::mojom::LockRequestAssociatedPtrInfoDataView>(
    in_request,
    &params->request,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->request)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid request in LockManager.RequestLock request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LockManager::Name_);
  message.set_method_name("RequestLock");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LockManagerProxy::QueryState(
    QueryStateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::LockManager::QueryState");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LockManager::kQueryState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LockManager_QueryState_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LockManager::Name_);
  message.set_method_name("QueryState");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LockManager_QueryState_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class LockManager_QueryState_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LockManager::QueryStateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LockManager_QueryState_ProxyToResponder> proxy(
        new LockManager_QueryState_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LockManager_QueryState_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LockManager_QueryState_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LockManager_QueryState_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LockManager::QueryStateCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<LockInfoPtr> in_requested, std::vector<LockInfoPtr> in_held);
};

bool LockManager_QueryState_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LockManager_QueryState_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LockManager_QueryState_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LockManager.1
  bool success = true;
  std::vector<LockInfoPtr> p_requested{};
  std::vector<LockInfoPtr> p_held{};
  LockManager_QueryState_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadRequested(&p_requested))
    success = false;
  if (success && !input_data_view.ReadHeld(&p_held))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LockManager::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_requested), 
std::move(p_held));
  }
  return true;
}

void LockManager_QueryState_ProxyToResponder::Run(
    std::vector<LockInfoPtr> in_requested, std::vector<LockInfoPtr> in_held) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::LockManager::QueryState", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("requested"), in_requested,
                        "<value of type std::vector<LockInfoPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("held"), in_held,
                        "<value of type std::vector<LockInfoPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LockManager::kQueryState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LockManager_QueryState_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->requested)::BaseType>
      requested_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& requested_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::LockInfoDataView>>(
    in_requested,
    requested_fragment,
    &requested_validate_params);

  params->requested.Set(
      requested_fragment.is_null() ? nullptr : requested_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->requested.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null requested in ");
  mojo::internal::MessageFragment<
      typename decltype(params->held)::BaseType>
      held_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& held_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::LockInfoDataView>>(
    in_held,
    held_fragment,
    &held_validate_params);

  params->held.Set(
      held_fragment.is_null() ? nullptr : held_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->held.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null held in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LockManager::Name_);
  message.set_method_name("QueryState");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool LockManagerStubDispatch::Accept(
    LockManager* impl,
    mojo::Message* message) {
  switch (static_cast<messages::LockManager>(message->header()->name)) {
    case messages::LockManager::kRequestLock: {
      DCHECK(message->is_serialized());
      internal::LockManager_RequestLock_Params_Data* params =
          reinterpret_cast<internal::LockManager_RequestLock_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LockManager.0
      bool success = true;
      std::string p_name{};
      LockMode p_mode{};
      LockManager::WaitMode p_wait{};
      ::mojo::PendingAssociatedRemote<LockRequest> p_request{};
      LockManager_RequestLock_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success && !input_data_view.ReadMode(&p_mode))
        success = false;
      if (success && !input_data_view.ReadWait(&p_wait))
        success = false;
      if (success) {
        p_request =
            input_data_view.TakeRequest<decltype(p_request)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LockManager::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestLock(        
        std::move(p_name), 
        std::move(p_mode), 
        std::move(p_wait), 
        std::move(p_request));
      return true;
    }
    case messages::LockManager::kQueryState: {
      break;
    }
  }
  return false;
}

// static
bool LockManagerStubDispatch::AcceptWithResponder(
    LockManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::LockManager>(message->header()->name)) {
    case messages::LockManager::kRequestLock: {
      break;
    }
    case messages::LockManager::kQueryState: {
      internal::LockManager_QueryState_Params_Data* params =
          reinterpret_cast<
              internal::LockManager_QueryState_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LockManager.1
      bool success = true;
      LockManager_QueryState_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LockManager::Name_, 1, false);
        return false;
      }
      auto callback =
          LockManager_QueryState_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueryState(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kLockManagerValidationInfo[] = {
    { &internal::LockManager_RequestLock_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LockManager_QueryState_Params_Data::Validate,
     &internal::LockManager_QueryState_ResponseParams_Data::Validate},
};

bool LockManagerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::LockManager::Name_,
    kLockManagerValidationInfo);
}

bool LockManagerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::LockManager::Name_,
    kLockManagerValidationInfo);
}


}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::LockInfo::DataView, ::blink::mojom::LockInfoPtr>::Read(
    ::blink::mojom::LockInfo::DataView input,
    ::blink::mojom::LockInfoPtr* output) {
  bool success = true;
  ::blink::mojom::LockInfoPtr result(::blink::mojom::LockInfo::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadMode(&result->mode))
        success = false;
      if (success && !input.ReadClientId(&result->client_id))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


LockHandleAsyncWaiter::LockHandleAsyncWaiter(
    LockHandle* proxy) : proxy_(proxy) {}

LockHandleAsyncWaiter::~LockHandleAsyncWaiter() = default;





void LockRequestInterceptorForTesting::Granted(::mojo::PendingAssociatedRemote<LockHandle> lock_handle) {
  GetForwardingInterface()->Granted(
    std::move(lock_handle)
    );
}
void LockRequestInterceptorForTesting::Failed() {
  GetForwardingInterface()->Failed();
}
LockRequestAsyncWaiter::LockRequestAsyncWaiter(
    LockRequest* proxy) : proxy_(proxy) {}

LockRequestAsyncWaiter::~LockRequestAsyncWaiter() = default;





void LockManagerInterceptorForTesting::RequestLock(const std::string& name, LockMode mode, LockManager::WaitMode wait, ::mojo::PendingAssociatedRemote<LockRequest> request) {
  GetForwardingInterface()->RequestLock(
    std::move(name)
    , 
    std::move(mode)
    , 
    std::move(wait)
    , 
    std::move(request)
    );
}
void LockManagerInterceptorForTesting::QueryState(QueryStateCallback callback) {
  GetForwardingInterface()->QueryState(std::move(callback));
}
LockManagerAsyncWaiter::LockManagerAsyncWaiter(
    LockManager* proxy) : proxy_(proxy) {}

LockManagerAsyncWaiter::~LockManagerAsyncWaiter() = default;


void LockManagerAsyncWaiter::QueryState(
    std::vector<LockInfoPtr>* out_requested, std::vector<LockInfoPtr>* out_held) {
  base::RunLoop loop;
  proxy_->QueryState(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<LockInfoPtr>* out_requested
,
             std::vector<LockInfoPtr>* out_held
,
             std::vector<LockInfoPtr> requested,
             std::vector<LockInfoPtr> held) {*out_requested = std::move(requested);*out_held = std::move(held);
            loop->Quit();
          },
          &loop,
          out_requested,
          out_held));
  loop.Run();
}








}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif