// third_party/blink/public/mojom/locks/lock_manager.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOCKS_LOCK_MANAGER_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOCKS_LOCK_MANAGER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/locks/lock_manager.mojom-shared-internal.h"


namespace blink::mojom {
class LockInfoDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::LockInfoDataView> {
  using Data = ::blink::mojom::internal::LockInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class LockMode : int32_t {
  
  SHARED = 0,
  
  EXCLUSIVE = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, LockMode value);
inline bool IsKnownEnumValue(LockMode value) {
  return internal::LockMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class LockManager_WaitMode : int32_t {
  
  WAIT = 0,
  
  NO_WAIT = 1,
  
  PREEMPT = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, LockManager_WaitMode value);
inline bool IsKnownEnumValue(LockManager_WaitMode value) {
  return internal::LockManager_WaitMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class LockHandleInterfaceBase {};

using LockHandlePtrDataView =
    mojo::InterfacePtrDataView<LockHandleInterfaceBase>;
using LockHandleRequestDataView =
    mojo::InterfaceRequestDataView<LockHandleInterfaceBase>;
using LockHandleAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<LockHandleInterfaceBase>;
using LockHandleAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<LockHandleInterfaceBase>;
class LockRequestInterfaceBase {};

using LockRequestPtrDataView =
    mojo::InterfacePtrDataView<LockRequestInterfaceBase>;
using LockRequestRequestDataView =
    mojo::InterfaceRequestDataView<LockRequestInterfaceBase>;
using LockRequestAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<LockRequestInterfaceBase>;
using LockRequestAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<LockRequestInterfaceBase>;
class LockManagerInterfaceBase {};

using LockManagerPtrDataView =
    mojo::InterfacePtrDataView<LockManagerInterfaceBase>;
using LockManagerRequestDataView =
    mojo::InterfaceRequestDataView<LockManagerInterfaceBase>;
using LockManagerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<LockManagerInterfaceBase>;
using LockManagerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<LockManagerInterfaceBase>;


class LockInfoDataView {
 public:
  LockInfoDataView() = default;

  LockInfoDataView(
      internal::LockInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMode(UserType* output) const {
    auto data_value = data_->mode;
    return mojo::internal::Deserialize<::blink::mojom::LockMode>(
        data_value, output);
  }
  LockMode mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::LockMode>(data_->mode));
  }
  inline void GetClientIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClientId(UserType* output) {
    
    auto* pointer = data_->client_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::LockInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOCKS_LOCK_MANAGER_MOJOM_DATA_VIEW_H_