// third_party/blink/public/mojom/lock_screen/lock_screen.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/lock_screen/lock_screen.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');


  var LockScreenServiceStatus = {};
  LockScreenServiceStatus.kSuccess = 0;
  LockScreenServiceStatus.kNotAllowedFromContext = 1;
  LockScreenServiceStatus.kWriteError = 2;
  LockScreenServiceStatus.MIN_VALUE = 0;
  LockScreenServiceStatus.MAX_VALUE = 2;

  LockScreenServiceStatus.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  LockScreenServiceStatus.toKnownEnumValue = function(value) {
    return value;
  };

  LockScreenServiceStatus.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function LockScreenService_GetKeys_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LockScreenService_GetKeys_Params.prototype.initDefaults_ = function() {
  };
  LockScreenService_GetKeys_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LockScreenService_GetKeys_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LockScreenService_GetKeys_Params.encodedSize = codec.kStructHeaderSize + 0;

  LockScreenService_GetKeys_Params.decode = function(decoder) {
    var packed;
    var val = new LockScreenService_GetKeys_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  LockScreenService_GetKeys_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LockScreenService_GetKeys_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function LockScreenService_GetKeys_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LockScreenService_GetKeys_ResponseParams.prototype.initDefaults_ = function() {
    this.keys = null;
  };
  LockScreenService_GetKeys_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LockScreenService_GetKeys_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LockScreenService_GetKeys_ResponseParams.keys
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LockScreenService_GetKeys_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  LockScreenService_GetKeys_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new LockScreenService_GetKeys_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.keys =
        decoder.decodeArrayPointer(codec.String);
    return val;
  };

  LockScreenService_GetKeys_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LockScreenService_GetKeys_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.String, val.keys);
  };
  function LockScreenService_SetData_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LockScreenService_SetData_Params.prototype.initDefaults_ = function() {
    this.key = null;
    this.data = null;
  };
  LockScreenService_SetData_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LockScreenService_SetData_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LockScreenService_SetData_Params.key
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate LockScreenService_SetData_Params.data
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LockScreenService_SetData_Params.encodedSize = codec.kStructHeaderSize + 16;

  LockScreenService_SetData_Params.decode = function(decoder) {
    var packed;
    var val = new LockScreenService_SetData_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.key =
        decoder.decodeStruct(codec.String);
    val.data =
        decoder.decodeStruct(codec.String);
    return val;
  };

  LockScreenService_SetData_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LockScreenService_SetData_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.key);
    encoder.encodeStruct(codec.String, val.data);
  };
  function LockScreenService_SetData_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LockScreenService_SetData_ResponseParams.prototype.initDefaults_ = function() {
    this.status = 0;
  };
  LockScreenService_SetData_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LockScreenService_SetData_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LockScreenService_SetData_ResponseParams.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, LockScreenServiceStatus);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LockScreenService_SetData_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  LockScreenService_SetData_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new LockScreenService_SetData_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(LockScreenServiceStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  LockScreenService_SetData_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LockScreenService_SetData_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kLockScreenService_GetKeys_Name = 0;
  var kLockScreenService_SetData_Name = 1;

  function LockScreenServicePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(LockScreenService,
                                                   handleOrPtrInfo);
  }

  function LockScreenServiceAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        LockScreenService, associatedInterfacePtrInfo);
  }

  LockScreenServiceAssociatedPtr.prototype =
      Object.create(LockScreenServicePtr.prototype);
  LockScreenServiceAssociatedPtr.prototype.constructor =
      LockScreenServiceAssociatedPtr;

  function LockScreenServiceProxy(receiver) {
    this.receiver_ = receiver;
  }
  LockScreenServicePtr.prototype.getKeys = function() {
    return LockScreenServiceProxy.prototype.getKeys
        .apply(this.ptr.getProxy(), arguments);
  };

  LockScreenServiceProxy.prototype.getKeys = function() {
    var params_ = new LockScreenService_GetKeys_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kLockScreenService_GetKeys_Name,
          codec.align(LockScreenService_GetKeys_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(LockScreenService_GetKeys_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(LockScreenService_GetKeys_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  LockScreenServicePtr.prototype.setData = function() {
    return LockScreenServiceProxy.prototype.setData
        .apply(this.ptr.getProxy(), arguments);
  };

  LockScreenServiceProxy.prototype.setData = function(key, data) {
    var params_ = new LockScreenService_SetData_Params();
    params_.key = key;
    params_.data = data;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kLockScreenService_SetData_Name,
          codec.align(LockScreenService_SetData_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(LockScreenService_SetData_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(LockScreenService_SetData_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function LockScreenServiceStub(delegate) {
    this.delegate_ = delegate;
  }
  LockScreenServiceStub.prototype.getKeys = function() {
    return this.delegate_ && this.delegate_.getKeys && this.delegate_.getKeys();
  }
  LockScreenServiceStub.prototype.setData = function(key, data) {
    return this.delegate_ && this.delegate_.setData && this.delegate_.setData(key, data);
  }

  LockScreenServiceStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  LockScreenServiceStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kLockScreenService_GetKeys_Name:
      var params = reader.decodeStruct(LockScreenService_GetKeys_Params);
      this.getKeys().then(function(response) {
        var responseParams =
            new LockScreenService_GetKeys_ResponseParams();
        responseParams.keys = response.keys;
        var builder = new codec.MessageV1Builder(
            kLockScreenService_GetKeys_Name,
            codec.align(LockScreenService_GetKeys_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(LockScreenService_GetKeys_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kLockScreenService_SetData_Name:
      var params = reader.decodeStruct(LockScreenService_SetData_Params);
      this.setData(params.key, params.data).then(function(response) {
        var responseParams =
            new LockScreenService_SetData_ResponseParams();
        responseParams.status = response.status;
        var builder = new codec.MessageV1Builder(
            kLockScreenService_SetData_Name,
            codec.align(LockScreenService_SetData_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(LockScreenService_SetData_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateLockScreenServiceRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kLockScreenService_GetKeys_Name:
        if (message.expectsResponse())
          paramsClass = LockScreenService_GetKeys_Params;
      break;
      case kLockScreenService_SetData_Name:
        if (message.expectsResponse())
          paramsClass = LockScreenService_SetData_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateLockScreenServiceResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kLockScreenService_GetKeys_Name:
        if (message.isResponse())
          paramsClass = LockScreenService_GetKeys_ResponseParams;
        break;
      case kLockScreenService_SetData_Name:
        if (message.isResponse())
          paramsClass = LockScreenService_SetData_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var LockScreenService = {
    name: 'blink.mojom.LockScreenService',
    kVersion: 0,
    ptrClass: LockScreenServicePtr,
    proxyClass: LockScreenServiceProxy,
    stubClass: LockScreenServiceStub,
    validateRequest: validateLockScreenServiceRequest,
    validateResponse: validateLockScreenServiceResponse,
  };
  LockScreenServiceStub.prototype.validator = validateLockScreenServiceRequest;
  LockScreenServiceProxy.prototype.validator = validateLockScreenServiceResponse;
  exports.LockScreenServiceStatus = LockScreenServiceStatus;
  exports.LockScreenService = LockScreenService;
  exports.LockScreenServicePtr = LockScreenServicePtr;
  exports.LockScreenServiceAssociatedPtr = LockScreenServiceAssociatedPtr;
})();