// third_party/blink/public/mojom/loader/resource_load_info_notifier.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  RequestDestination as network_mojom_RequestDestination,
  RequestDestinationSpec as network_mojom_RequestDestinationSpec
} from '../../../../../services/network/public/mojom/fetch_api.mojom.m.js';

import {
  URLRequestRedirectInfo as network_mojom_URLRequestRedirectInfo,
  URLRequestRedirectInfoSpec as network_mojom_URLRequestRedirectInfoSpec
} from '../../../../../services/network/public/mojom/url_loader.mojom.m.js';

import {
  URLLoaderCompletionStatus as network_mojom_URLLoaderCompletionStatus,
  URLLoaderCompletionStatusSpec as network_mojom_URLLoaderCompletionStatusSpec
} from '../../../../../services/network/public/mojom/url_loader_completion_status.mojom.m.js';

import {
  URLResponseHead as network_mojom_URLResponseHead,
  URLResponseHeadSpec as network_mojom_URLResponseHeadSpec
} from '../../../../../services/network/public/mojom/url_response_head.mojom.m.js';

import {
  SchemeHostPort as url_mojom_SchemeHostPort,
  SchemeHostPortSpec as url_mojom_SchemeHostPortSpec
} from '../../../../../url/mojom/scheme_host_port.mojom.m.js';

import {
  ResourceLoadInfo as blink_mojom_ResourceLoadInfo,
  ResourceLoadInfoSpec as blink_mojom_ResourceLoadInfoSpec
} from './resource_load_info.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ResourceLoadInfoNotifierPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.ResourceLoadInfoNotifier', scope);
  }
}

/** @interface */
export class ResourceLoadInfoNotifierInterface {
  
  /**
   * @param { !network_mojom_URLRequestRedirectInfo } redirectInfo
   * @param { !network_mojom_URLResponseHead } redirectResponse
   */

  notifyResourceRedirectReceived(redirectInfo, redirectResponse) {}
  
  /**
   * @param { !bigint } requestId
   * @param { !url_mojom_SchemeHostPort } finalResponseUrl
   * @param { !network_mojom_URLResponseHead } head
   * @param { !network_mojom_RequestDestination } requestDestination
   * @param { !boolean } isAdResource
   */

  notifyResourceResponseReceived(requestId, finalResponseUrl, head, requestDestination, isAdResource) {}
  
  /**
   * @param { !bigint } requestId
   * @param { !number } transferSizeDiff
   */

  notifyResourceTransferSizeUpdated(requestId, transferSizeDiff) {}
  
  /**
   * @param { !blink_mojom_ResourceLoadInfo } resourceLoadInfo
   * @param { !network_mojom_URLLoaderCompletionStatus } status
   */

  notifyResourceLoadCompleted(resourceLoadInfo, status) {}
  
  /**
   * @param { !bigint } requestId
   */

  notifyResourceLoadCanceled(requestId) {}
  
  /**
   * @param { !ResourceLoadInfoNotifierPendingReceiver } pendingResourceLoadInfoNotifier
   */

  clone(pendingResourceLoadInfoNotifier) {}
}

/**
 * @implements { ResourceLoadInfoNotifierInterface }
 */
export class ResourceLoadInfoNotifierRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ResourceLoadInfoNotifierPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ResourceLoadInfoNotifierPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ResourceLoadInfoNotifierPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network_mojom_URLRequestRedirectInfo } redirectInfo
   * @param { !network_mojom_URLResponseHead } redirectResponse
   */

  notifyResourceRedirectReceived(
      redirectInfo,
      redirectResponse) {
    this.proxy.sendMessage(
        0,
        ResourceLoadInfoNotifier_NotifyResourceRedirectReceived_ParamsSpec.$,
        null,
        [
          redirectInfo,
          redirectResponse
        ],
        false);
  }

  
  /**
   * @param { !bigint } requestId
   * @param { !url_mojom_SchemeHostPort } finalResponseUrl
   * @param { !network_mojom_URLResponseHead } head
   * @param { !network_mojom_RequestDestination } requestDestination
   * @param { !boolean } isAdResource
   */

  notifyResourceResponseReceived(
      requestId,
      finalResponseUrl,
      head,
      requestDestination,
      isAdResource) {
    this.proxy.sendMessage(
        1,
        ResourceLoadInfoNotifier_NotifyResourceResponseReceived_ParamsSpec.$,
        null,
        [
          requestId,
          finalResponseUrl,
          head,
          requestDestination,
          isAdResource
        ],
        false);
  }

  
  /**
   * @param { !bigint } requestId
   * @param { !number } transferSizeDiff
   */

  notifyResourceTransferSizeUpdated(
      requestId,
      transferSizeDiff) {
    this.proxy.sendMessage(
        2,
        ResourceLoadInfoNotifier_NotifyResourceTransferSizeUpdated_ParamsSpec.$,
        null,
        [
          requestId,
          transferSizeDiff
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_ResourceLoadInfo } resourceLoadInfo
   * @param { !network_mojom_URLLoaderCompletionStatus } status
   */

  notifyResourceLoadCompleted(
      resourceLoadInfo,
      status) {
    this.proxy.sendMessage(
        3,
        ResourceLoadInfoNotifier_NotifyResourceLoadCompleted_ParamsSpec.$,
        null,
        [
          resourceLoadInfo,
          status
        ],
        false);
  }

  
  /**
   * @param { !bigint } requestId
   */

  notifyResourceLoadCanceled(
      requestId) {
    this.proxy.sendMessage(
        4,
        ResourceLoadInfoNotifier_NotifyResourceLoadCanceled_ParamsSpec.$,
        null,
        [
          requestId
        ],
        false);
  }

  
  /**
   * @param { !ResourceLoadInfoNotifierPendingReceiver } pendingResourceLoadInfoNotifier
   */

  clone(
      pendingResourceLoadInfoNotifier) {
    this.proxy.sendMessage(
        5,
        ResourceLoadInfoNotifier_Clone_ParamsSpec.$,
        null,
        [
          pendingResourceLoadInfoNotifier
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ResourceLoadInfoNotifier
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ResourceLoadInfoNotifierReceiver {
  /**
   * @param {!ResourceLoadInfoNotifierInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ResourceLoadInfoNotifierRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ResourceLoadInfoNotifierRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ResourceLoadInfoNotifierRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ResourceLoadInfoNotifier_NotifyResourceRedirectReceived_ParamsSpec.$,
        null,
        impl.notifyResourceRedirectReceived.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ResourceLoadInfoNotifier_NotifyResourceResponseReceived_ParamsSpec.$,
        null,
        impl.notifyResourceResponseReceived.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ResourceLoadInfoNotifier_NotifyResourceTransferSizeUpdated_ParamsSpec.$,
        null,
        impl.notifyResourceTransferSizeUpdated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        ResourceLoadInfoNotifier_NotifyResourceLoadCompleted_ParamsSpec.$,
        null,
        impl.notifyResourceLoadCompleted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        ResourceLoadInfoNotifier_NotifyResourceLoadCanceled_ParamsSpec.$,
        null,
        impl.notifyResourceLoadCanceled.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        ResourceLoadInfoNotifier_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ResourceLoadInfoNotifier {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ResourceLoadInfoNotifier";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ResourceLoadInfoNotifierRemote}
   */
  static getRemote() {
    let remote = new ResourceLoadInfoNotifierRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ResourceLoadInfoNotifier
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ResourceLoadInfoNotifierCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ResourceLoadInfoNotifierRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ResourceLoadInfoNotifierRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyResourceRedirectReceived =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ResourceLoadInfoNotifier_NotifyResourceRedirectReceived_ParamsSpec.$,
        null,
        this.notifyResourceRedirectReceived.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyResourceResponseReceived =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ResourceLoadInfoNotifier_NotifyResourceResponseReceived_ParamsSpec.$,
        null,
        this.notifyResourceResponseReceived.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyResourceTransferSizeUpdated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ResourceLoadInfoNotifier_NotifyResourceTransferSizeUpdated_ParamsSpec.$,
        null,
        this.notifyResourceTransferSizeUpdated.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyResourceLoadCompleted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        ResourceLoadInfoNotifier_NotifyResourceLoadCompleted_ParamsSpec.$,
        null,
        this.notifyResourceLoadCompleted.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyResourceLoadCanceled =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        ResourceLoadInfoNotifier_NotifyResourceLoadCanceled_ParamsSpec.$,
        null,
        this.notifyResourceLoadCanceled.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        ResourceLoadInfoNotifier_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ResourceLoadInfoNotifier_NotifyResourceRedirectReceived_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ResourceLoadInfoNotifier_NotifyResourceResponseReceived_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ResourceLoadInfoNotifier_NotifyResourceTransferSizeUpdated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ResourceLoadInfoNotifier_NotifyResourceLoadCompleted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ResourceLoadInfoNotifier_NotifyResourceLoadCanceled_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ResourceLoadInfoNotifier_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ResourceLoadInfoNotifier_NotifyResourceRedirectReceived_ParamsSpec.$,
    'ResourceLoadInfoNotifier_NotifyResourceRedirectReceived_Params',
    [
      mojo.internal.StructField(
        'redirectInfo', 0,
        0,
        network_mojom_URLRequestRedirectInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'redirectResponse', 8,
        0,
        network_mojom_URLResponseHeadSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ResourceLoadInfoNotifier_NotifyResourceRedirectReceived_Params {
  constructor() {
    /** @type { !network_mojom_URLRequestRedirectInfo } */
    this.redirectInfo;
    /** @type { !network_mojom_URLResponseHead } */
    this.redirectResponse;
  }
}



mojo.internal.Struct(
    ResourceLoadInfoNotifier_NotifyResourceResponseReceived_ParamsSpec.$,
    'ResourceLoadInfoNotifier_NotifyResourceResponseReceived_Params',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'finalResponseUrl', 8,
        0,
        url_mojom_SchemeHostPortSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'head', 16,
        0,
        network_mojom_URLResponseHeadSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requestDestination', 24,
        0,
        network_mojom_RequestDestinationSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isAdResource', 28,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class ResourceLoadInfoNotifier_NotifyResourceResponseReceived_Params {
  constructor() {
    /** @type { !bigint } */
    this.requestId;
    /** @type { !url_mojom_SchemeHostPort } */
    this.finalResponseUrl;
    /** @type { !network_mojom_URLResponseHead } */
    this.head;
    /** @type { !network_mojom_RequestDestination } */
    this.requestDestination;
    /** @type { !boolean } */
    this.isAdResource;
  }
}



mojo.internal.Struct(
    ResourceLoadInfoNotifier_NotifyResourceTransferSizeUpdated_ParamsSpec.$,
    'ResourceLoadInfoNotifier_NotifyResourceTransferSizeUpdated_Params',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'transferSizeDiff', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ResourceLoadInfoNotifier_NotifyResourceTransferSizeUpdated_Params {
  constructor() {
    /** @type { !bigint } */
    this.requestId;
    /** @type { !number } */
    this.transferSizeDiff;
  }
}



mojo.internal.Struct(
    ResourceLoadInfoNotifier_NotifyResourceLoadCompleted_ParamsSpec.$,
    'ResourceLoadInfoNotifier_NotifyResourceLoadCompleted_Params',
    [
      mojo.internal.StructField(
        'resourceLoadInfo', 0,
        0,
        blink_mojom_ResourceLoadInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'status', 8,
        0,
        network_mojom_URLLoaderCompletionStatusSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ResourceLoadInfoNotifier_NotifyResourceLoadCompleted_Params {
  constructor() {
    /** @type { !blink_mojom_ResourceLoadInfo } */
    this.resourceLoadInfo;
    /** @type { !network_mojom_URLLoaderCompletionStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    ResourceLoadInfoNotifier_NotifyResourceLoadCanceled_ParamsSpec.$,
    'ResourceLoadInfoNotifier_NotifyResourceLoadCanceled_Params',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ResourceLoadInfoNotifier_NotifyResourceLoadCanceled_Params {
  constructor() {
    /** @type { !bigint } */
    this.requestId;
  }
}



mojo.internal.Struct(
    ResourceLoadInfoNotifier_Clone_ParamsSpec.$,
    'ResourceLoadInfoNotifier_Clone_Params',
    [
      mojo.internal.StructField(
        'pendingResourceLoadInfoNotifier', 0,
        0,
        mojo.internal.InterfaceRequest(ResourceLoadInfoNotifierPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ResourceLoadInfoNotifier_Clone_Params {
  constructor() {
    /** @type { !ResourceLoadInfoNotifierPendingReceiver } */
    this.pendingResourceLoadInfoNotifier;
  }
}

