// third_party/blink/public/mojom/loader/resource_load_info_notifier.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/loader/resource_load_info_notifier.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/loader/resource_load_info_notifier.mojom-params-data.h"
#include "third_party/blink/public/mojom/loader/resource_load_info_notifier.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/loader/resource_load_info_notifier.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/loader/resource_load_info_notifier.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
// The declaration includes the definition on other builds.

ResourceLoadInfoNotifier::IPCStableHashFunction ResourceLoadInfoNotifier::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ResourceLoadInfoNotifier>(message.name())) {
    case messages::ResourceLoadInfoNotifier::kNotifyResourceRedirectReceived: {
      return &ResourceLoadInfoNotifier::NotifyResourceRedirectReceived_Sym::IPCStableHash;
    }
    case messages::ResourceLoadInfoNotifier::kNotifyResourceResponseReceived: {
      return &ResourceLoadInfoNotifier::NotifyResourceResponseReceived_Sym::IPCStableHash;
    }
    case messages::ResourceLoadInfoNotifier::kNotifyResourceTransferSizeUpdated: {
      return &ResourceLoadInfoNotifier::NotifyResourceTransferSizeUpdated_Sym::IPCStableHash;
    }
    case messages::ResourceLoadInfoNotifier::kNotifyResourceLoadCompleted: {
      return &ResourceLoadInfoNotifier::NotifyResourceLoadCompleted_Sym::IPCStableHash;
    }
    case messages::ResourceLoadInfoNotifier::kNotifyResourceLoadCanceled: {
      return &ResourceLoadInfoNotifier::NotifyResourceLoadCanceled_Sym::IPCStableHash;
    }
    case messages::ResourceLoadInfoNotifier::kClone: {
      return &ResourceLoadInfoNotifier::Clone_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ResourceLoadInfoNotifier::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ResourceLoadInfoNotifier>(message.name())) {
      case messages::ResourceLoadInfoNotifier::kNotifyResourceRedirectReceived:
            return "Receive blink::mojom::ResourceLoadInfoNotifier::NotifyResourceRedirectReceived";
      case messages::ResourceLoadInfoNotifier::kNotifyResourceResponseReceived:
            return "Receive blink::mojom::ResourceLoadInfoNotifier::NotifyResourceResponseReceived";
      case messages::ResourceLoadInfoNotifier::kNotifyResourceTransferSizeUpdated:
            return "Receive blink::mojom::ResourceLoadInfoNotifier::NotifyResourceTransferSizeUpdated";
      case messages::ResourceLoadInfoNotifier::kNotifyResourceLoadCompleted:
            return "Receive blink::mojom::ResourceLoadInfoNotifier::NotifyResourceLoadCompleted";
      case messages::ResourceLoadInfoNotifier::kNotifyResourceLoadCanceled:
            return "Receive blink::mojom::ResourceLoadInfoNotifier::NotifyResourceLoadCanceled";
      case messages::ResourceLoadInfoNotifier::kClone:
            return "Receive blink::mojom::ResourceLoadInfoNotifier::Clone";
    }
  } else {
    switch (static_cast<messages::ResourceLoadInfoNotifier>(message.name())) {
      case messages::ResourceLoadInfoNotifier::kNotifyResourceRedirectReceived:
            return "Receive reply blink::mojom::ResourceLoadInfoNotifier::NotifyResourceRedirectReceived";
      case messages::ResourceLoadInfoNotifier::kNotifyResourceResponseReceived:
            return "Receive reply blink::mojom::ResourceLoadInfoNotifier::NotifyResourceResponseReceived";
      case messages::ResourceLoadInfoNotifier::kNotifyResourceTransferSizeUpdated:
            return "Receive reply blink::mojom::ResourceLoadInfoNotifier::NotifyResourceTransferSizeUpdated";
      case messages::ResourceLoadInfoNotifier::kNotifyResourceLoadCompleted:
            return "Receive reply blink::mojom::ResourceLoadInfoNotifier::NotifyResourceLoadCompleted";
      case messages::ResourceLoadInfoNotifier::kNotifyResourceLoadCanceled:
            return "Receive reply blink::mojom::ResourceLoadInfoNotifier::NotifyResourceLoadCanceled";
      case messages::ResourceLoadInfoNotifier::kClone:
            return "Receive reply blink::mojom::ResourceLoadInfoNotifier::Clone";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ResourceLoadInfoNotifier::NotifyResourceRedirectReceived_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x91553289;  // IPCStableHash for blink::mojom::ResourceLoadInfoNotifier::NotifyResourceRedirectReceived
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ResourceLoadInfoNotifier::NotifyResourceResponseReceived_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa8a97e58;  // IPCStableHash for blink::mojom::ResourceLoadInfoNotifier::NotifyResourceResponseReceived
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ResourceLoadInfoNotifier::NotifyResourceTransferSizeUpdated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd2c8a176;  // IPCStableHash for blink::mojom::ResourceLoadInfoNotifier::NotifyResourceTransferSizeUpdated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ResourceLoadInfoNotifier::NotifyResourceLoadCompleted_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x23f7c640;  // IPCStableHash for blink::mojom::ResourceLoadInfoNotifier::NotifyResourceLoadCompleted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ResourceLoadInfoNotifier::NotifyResourceLoadCanceled_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf5d4754c;  // IPCStableHash for blink::mojom::ResourceLoadInfoNotifier::NotifyResourceLoadCanceled
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ResourceLoadInfoNotifier::Clone_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x605771d0;  // IPCStableHash for blink::mojom::ResourceLoadInfoNotifier::Clone
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ResourceLoadInfoNotifierProxy::ResourceLoadInfoNotifierProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ResourceLoadInfoNotifierProxy::NotifyResourceRedirectReceived(
    ::network::mojom::blink::URLRequestRedirectInfoPtr in_redirect_info, ::network::mojom::blink::URLResponseHeadPtr in_redirect_response) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ResourceLoadInfoNotifier::NotifyResourceRedirectReceived", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("redirect_info"), in_redirect_info,
                        "<value of type ::network::mojom::blink::URLRequestRedirectInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("redirect_response"), in_redirect_response,
                        "<value of type ::network::mojom::blink::URLResponseHeadPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ResourceLoadInfoNotifier::kNotifyResourceRedirectReceived), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ResourceLoadInfoNotifier_NotifyResourceRedirectReceived_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->redirect_info)::BaseType> redirect_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::URLRequestRedirectInfoDataView>(
    in_redirect_info,
    redirect_info_fragment);

  params->redirect_info.Set(
      redirect_info_fragment.is_null() ? nullptr : redirect_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->redirect_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null redirect_info in ResourceLoadInfoNotifier.NotifyResourceRedirectReceived request");
  mojo::internal::MessageFragment<
      typename decltype(params->redirect_response)::BaseType> redirect_response_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::URLResponseHeadDataView>(
    in_redirect_response,
    redirect_response_fragment);

  params->redirect_response.Set(
      redirect_response_fragment.is_null() ? nullptr : redirect_response_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->redirect_response.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null redirect_response in ResourceLoadInfoNotifier.NotifyResourceRedirectReceived request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ResourceLoadInfoNotifier::Name_);
  message.set_method_name("NotifyResourceRedirectReceived");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ResourceLoadInfoNotifierProxy::NotifyResourceResponseReceived(
    int64_t in_request_id, const ::url::SchemeHostPort& in_final_response_url, ::network::mojom::blink::URLResponseHeadPtr in_head, ::network::mojom::blink::RequestDestination in_request_destination, bool in_is_ad_resource) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ResourceLoadInfoNotifier::NotifyResourceResponseReceived", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("final_response_url"), in_final_response_url,
                        "<value of type const ::url::SchemeHostPort&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("head"), in_head,
                        "<value of type ::network::mojom::blink::URLResponseHeadPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_destination"), in_request_destination,
                        "<value of type ::network::mojom::blink::RequestDestination>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_ad_resource"), in_is_ad_resource,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ResourceLoadInfoNotifier::kNotifyResourceResponseReceived), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ResourceLoadInfoNotifier_NotifyResourceResponseReceived_Params_Data> params(
          message);
  params.Allocate();

  params->request_id = in_request_id;
  mojo::internal::MessageFragment<
      typename decltype(params->final_response_url)::BaseType> final_response_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::SchemeHostPortDataView>(
    in_final_response_url,
    final_response_url_fragment);

  params->final_response_url.Set(
      final_response_url_fragment.is_null() ? nullptr : final_response_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->final_response_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null final_response_url in ResourceLoadInfoNotifier.NotifyResourceResponseReceived request");
  mojo::internal::MessageFragment<
      typename decltype(params->head)::BaseType> head_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::URLResponseHeadDataView>(
    in_head,
    head_fragment);

  params->head.Set(
      head_fragment.is_null() ? nullptr : head_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->head.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null head in ResourceLoadInfoNotifier.NotifyResourceResponseReceived request");

  
  mojo::internal::Serialize<::network::mojom::RequestDestination>(
    in_request_destination,
    &params->request_destination);

  params->is_ad_resource = in_is_ad_resource;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ResourceLoadInfoNotifier::Name_);
  message.set_method_name("NotifyResourceResponseReceived");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ResourceLoadInfoNotifierProxy::NotifyResourceTransferSizeUpdated(
    int64_t in_request_id, int32_t in_transfer_size_diff) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ResourceLoadInfoNotifier::NotifyResourceTransferSizeUpdated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("transfer_size_diff"), in_transfer_size_diff,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ResourceLoadInfoNotifier::kNotifyResourceTransferSizeUpdated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ResourceLoadInfoNotifier_NotifyResourceTransferSizeUpdated_Params_Data> params(
          message);
  params.Allocate();

  params->request_id = in_request_id;

  params->transfer_size_diff = in_transfer_size_diff;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ResourceLoadInfoNotifier::Name_);
  message.set_method_name("NotifyResourceTransferSizeUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ResourceLoadInfoNotifierProxy::NotifyResourceLoadCompleted(
    ::blink::mojom::blink::ResourceLoadInfoPtr in_resource_load_info, const ::network::URLLoaderCompletionStatus& in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ResourceLoadInfoNotifier::NotifyResourceLoadCompleted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resource_load_info"), in_resource_load_info,
                        "<value of type ::blink::mojom::blink::ResourceLoadInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type const ::network::URLLoaderCompletionStatus&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ResourceLoadInfoNotifier::kNotifyResourceLoadCompleted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ResourceLoadInfoNotifier_NotifyResourceLoadCompleted_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->resource_load_info)::BaseType> resource_load_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ResourceLoadInfoDataView>(
    in_resource_load_info,
    resource_load_info_fragment);

  params->resource_load_info.Set(
      resource_load_info_fragment.is_null() ? nullptr : resource_load_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->resource_load_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null resource_load_info in ResourceLoadInfoNotifier.NotifyResourceLoadCompleted request");
  mojo::internal::MessageFragment<
      typename decltype(params->status)::BaseType> status_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::URLLoaderCompletionStatusDataView>(
    in_status,
    status_fragment);

  params->status.Set(
      status_fragment.is_null() ? nullptr : status_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->status.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null status in ResourceLoadInfoNotifier.NotifyResourceLoadCompleted request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ResourceLoadInfoNotifier::Name_);
  message.set_method_name("NotifyResourceLoadCompleted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ResourceLoadInfoNotifierProxy::NotifyResourceLoadCanceled(
    int64_t in_request_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ResourceLoadInfoNotifier::NotifyResourceLoadCanceled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ResourceLoadInfoNotifier::kNotifyResourceLoadCanceled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ResourceLoadInfoNotifier_NotifyResourceLoadCanceled_Params_Data> params(
          message);
  params.Allocate();

  params->request_id = in_request_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ResourceLoadInfoNotifier::Name_);
  message.set_method_name("NotifyResourceLoadCanceled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ResourceLoadInfoNotifierProxy::Clone(
    ::mojo::PendingReceiver<ResourceLoadInfoNotifier> in_pending_resource_load_info_notifier) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ResourceLoadInfoNotifier::Clone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pending_resource_load_info_notifier"), in_pending_resource_load_info_notifier,
                        "<value of type ::mojo::PendingReceiver<ResourceLoadInfoNotifier>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ResourceLoadInfoNotifier::kClone), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ResourceLoadInfoNotifier_Clone_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::ResourceLoadInfoNotifierInterfaceBase>>(
    in_pending_resource_load_info_notifier,
    &params->pending_resource_load_info_notifier,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->pending_resource_load_info_notifier)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid pending_resource_load_info_notifier in ResourceLoadInfoNotifier.Clone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ResourceLoadInfoNotifier::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ResourceLoadInfoNotifierStubDispatch::Accept(
    ResourceLoadInfoNotifier* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ResourceLoadInfoNotifier>(message->header()->name)) {
    case messages::ResourceLoadInfoNotifier::kNotifyResourceRedirectReceived: {
      DCHECK(message->is_serialized());
      internal::ResourceLoadInfoNotifier_NotifyResourceRedirectReceived_Params_Data* params =
          reinterpret_cast<internal::ResourceLoadInfoNotifier_NotifyResourceRedirectReceived_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ResourceLoadInfoNotifier.0
      bool success = true;
      ::network::mojom::blink::URLRequestRedirectInfoPtr p_redirect_info{};
      ::network::mojom::blink::URLResponseHeadPtr p_redirect_response{};
      ResourceLoadInfoNotifier_NotifyResourceRedirectReceived_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRedirectInfo(&p_redirect_info))
        success = false;
      if (success && !input_data_view.ReadRedirectResponse(&p_redirect_response))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ResourceLoadInfoNotifier::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyResourceRedirectReceived(        
        std::move(p_redirect_info), 
        std::move(p_redirect_response));
      return true;
    }
    case messages::ResourceLoadInfoNotifier::kNotifyResourceResponseReceived: {
      DCHECK(message->is_serialized());
      internal::ResourceLoadInfoNotifier_NotifyResourceResponseReceived_Params_Data* params =
          reinterpret_cast<internal::ResourceLoadInfoNotifier_NotifyResourceResponseReceived_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ResourceLoadInfoNotifier.1
      bool success = true;
      int64_t p_request_id{};
      ::url::SchemeHostPort p_final_response_url{};
      ::network::mojom::blink::URLResponseHeadPtr p_head{};
      ::network::mojom::blink::RequestDestination p_request_destination{};
      bool p_is_ad_resource{};
      ResourceLoadInfoNotifier_NotifyResourceResponseReceived_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_request_id = input_data_view.request_id();
      if (success && !input_data_view.ReadFinalResponseUrl(&p_final_response_url))
        success = false;
      if (success && !input_data_view.ReadHead(&p_head))
        success = false;
      if (success && !input_data_view.ReadRequestDestination(&p_request_destination))
        success = false;
      if (success)
        p_is_ad_resource = input_data_view.is_ad_resource();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ResourceLoadInfoNotifier::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyResourceResponseReceived(        
        std::move(p_request_id), 
        std::move(p_final_response_url), 
        std::move(p_head), 
        std::move(p_request_destination), 
        std::move(p_is_ad_resource));
      return true;
    }
    case messages::ResourceLoadInfoNotifier::kNotifyResourceTransferSizeUpdated: {
      DCHECK(message->is_serialized());
      internal::ResourceLoadInfoNotifier_NotifyResourceTransferSizeUpdated_Params_Data* params =
          reinterpret_cast<internal::ResourceLoadInfoNotifier_NotifyResourceTransferSizeUpdated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ResourceLoadInfoNotifier.2
      bool success = true;
      int64_t p_request_id{};
      int32_t p_transfer_size_diff{};
      ResourceLoadInfoNotifier_NotifyResourceTransferSizeUpdated_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_request_id = input_data_view.request_id();
      if (success)
        p_transfer_size_diff = input_data_view.transfer_size_diff();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ResourceLoadInfoNotifier::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyResourceTransferSizeUpdated(        
        std::move(p_request_id), 
        std::move(p_transfer_size_diff));
      return true;
    }
    case messages::ResourceLoadInfoNotifier::kNotifyResourceLoadCompleted: {
      DCHECK(message->is_serialized());
      internal::ResourceLoadInfoNotifier_NotifyResourceLoadCompleted_Params_Data* params =
          reinterpret_cast<internal::ResourceLoadInfoNotifier_NotifyResourceLoadCompleted_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ResourceLoadInfoNotifier.3
      bool success = true;
      ::blink::mojom::blink::ResourceLoadInfoPtr p_resource_load_info{};
      ::network::URLLoaderCompletionStatus p_status{};
      ResourceLoadInfoNotifier_NotifyResourceLoadCompleted_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResourceLoadInfo(&p_resource_load_info))
        success = false;
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ResourceLoadInfoNotifier::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyResourceLoadCompleted(        
        std::move(p_resource_load_info), 
        std::move(p_status));
      return true;
    }
    case messages::ResourceLoadInfoNotifier::kNotifyResourceLoadCanceled: {
      DCHECK(message->is_serialized());
      internal::ResourceLoadInfoNotifier_NotifyResourceLoadCanceled_Params_Data* params =
          reinterpret_cast<internal::ResourceLoadInfoNotifier_NotifyResourceLoadCanceled_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ResourceLoadInfoNotifier.4
      bool success = true;
      int64_t p_request_id{};
      ResourceLoadInfoNotifier_NotifyResourceLoadCanceled_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_request_id = input_data_view.request_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ResourceLoadInfoNotifier::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyResourceLoadCanceled(        
        std::move(p_request_id));
      return true;
    }
    case messages::ResourceLoadInfoNotifier::kClone: {
      DCHECK(message->is_serialized());
      internal::ResourceLoadInfoNotifier_Clone_Params_Data* params =
          reinterpret_cast<internal::ResourceLoadInfoNotifier_Clone_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ResourceLoadInfoNotifier.5
      bool success = true;
      ::mojo::PendingReceiver<ResourceLoadInfoNotifier> p_pending_resource_load_info_notifier{};
      ResourceLoadInfoNotifier_Clone_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_pending_resource_load_info_notifier =
            input_data_view.TakePendingResourceLoadInfoNotifier<decltype(p_pending_resource_load_info_notifier)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ResourceLoadInfoNotifier::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(        
        std::move(p_pending_resource_load_info_notifier));
      return true;
    }
  }
  return false;
}

// static
bool ResourceLoadInfoNotifierStubDispatch::AcceptWithResponder(
    ResourceLoadInfoNotifier* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ResourceLoadInfoNotifier>(message->header()->name)) {
    case messages::ResourceLoadInfoNotifier::kNotifyResourceRedirectReceived: {
      break;
    }
    case messages::ResourceLoadInfoNotifier::kNotifyResourceResponseReceived: {
      break;
    }
    case messages::ResourceLoadInfoNotifier::kNotifyResourceTransferSizeUpdated: {
      break;
    }
    case messages::ResourceLoadInfoNotifier::kNotifyResourceLoadCompleted: {
      break;
    }
    case messages::ResourceLoadInfoNotifier::kNotifyResourceLoadCanceled: {
      break;
    }
    case messages::ResourceLoadInfoNotifier::kClone: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kResourceLoadInfoNotifierValidationInfo[] = {
    { &internal::ResourceLoadInfoNotifier_NotifyResourceRedirectReceived_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ResourceLoadInfoNotifier_NotifyResourceResponseReceived_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ResourceLoadInfoNotifier_NotifyResourceTransferSizeUpdated_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ResourceLoadInfoNotifier_NotifyResourceLoadCompleted_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ResourceLoadInfoNotifier_NotifyResourceLoadCanceled_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ResourceLoadInfoNotifier_Clone_Params_Data::Validate,
     nullptr /* no response */},
};

bool ResourceLoadInfoNotifierRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::ResourceLoadInfoNotifier::Name_,
    kResourceLoadInfoNotifierValidationInfo);
}



}  // blink::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void ResourceLoadInfoNotifierInterceptorForTesting::NotifyResourceRedirectReceived(::network::mojom::blink::URLRequestRedirectInfoPtr redirect_info, ::network::mojom::blink::URLResponseHeadPtr redirect_response) {
  GetForwardingInterface()->NotifyResourceRedirectReceived(
    std::move(redirect_info)
    , 
    std::move(redirect_response)
    );
}
void ResourceLoadInfoNotifierInterceptorForTesting::NotifyResourceResponseReceived(int64_t request_id, const ::url::SchemeHostPort& final_response_url, ::network::mojom::blink::URLResponseHeadPtr head, ::network::mojom::blink::RequestDestination request_destination, bool is_ad_resource) {
  GetForwardingInterface()->NotifyResourceResponseReceived(
    std::move(request_id)
    , 
    std::move(final_response_url)
    , 
    std::move(head)
    , 
    std::move(request_destination)
    , 
    std::move(is_ad_resource)
    );
}
void ResourceLoadInfoNotifierInterceptorForTesting::NotifyResourceTransferSizeUpdated(int64_t request_id, int32_t transfer_size_diff) {
  GetForwardingInterface()->NotifyResourceTransferSizeUpdated(
    std::move(request_id)
    , 
    std::move(transfer_size_diff)
    );
}
void ResourceLoadInfoNotifierInterceptorForTesting::NotifyResourceLoadCompleted(::blink::mojom::blink::ResourceLoadInfoPtr resource_load_info, const ::network::URLLoaderCompletionStatus& status) {
  GetForwardingInterface()->NotifyResourceLoadCompleted(
    std::move(resource_load_info)
    , 
    std::move(status)
    );
}
void ResourceLoadInfoNotifierInterceptorForTesting::NotifyResourceLoadCanceled(int64_t request_id) {
  GetForwardingInterface()->NotifyResourceLoadCanceled(
    std::move(request_id)
    );
}
void ResourceLoadInfoNotifierInterceptorForTesting::Clone(::mojo::PendingReceiver<ResourceLoadInfoNotifier> pending_resource_load_info_notifier) {
  GetForwardingInterface()->Clone(
    std::move(pending_resource_load_info_notifier)
    );
}
ResourceLoadInfoNotifierAsyncWaiter::ResourceLoadInfoNotifierAsyncWaiter(
    ResourceLoadInfoNotifier* proxy) : proxy_(proxy) {}

ResourceLoadInfoNotifierAsyncWaiter::~ResourceLoadInfoNotifierAsyncWaiter() = default;







}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif