// third_party/blink/public/mojom/loader/navigation_predictor.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('blink.mojom.AnchorElementPointerData');
goog.require('gfx.mojom.Size');
goog.require('mojoBase.mojom.TimeDelta');
goog.require('url.mojom.Url');




goog.provide('blink.mojom.AnchorElementUserInteractionEventForMLModelType');
goog.provide('blink.mojom.AnchorElementUserInteractionEventForMLModelTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.AnchorElementUserInteractionEventForMLModelTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.AnchorElementUserInteractionEventForMLModelType = {
  
  kPointerOver: 0,
  kPointerOut: 1,
  kEnteredViewport: 2,
  kLeftViewport: 3,
  kUnknown: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};



goog.provide('blink.mojom.AnchorElementMetricsHost');
goog.provide('blink.mojom.AnchorElementMetricsHostReceiver');
goog.provide('blink.mojom.AnchorElementMetricsHostCallbackRouter');
goog.provide('blink.mojom.AnchorElementMetricsHostInterface');
goog.provide('blink.mojom.AnchorElementMetricsHostRemote');
goog.provide('blink.mojom.AnchorElementMetricsHostPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.AnchorElementMetricsHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.AnchorElementMetricsHost.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.AnchorElementMetricsHostInterface = class {
  
  /**
   * @param { !blink.mojom.AnchorElementClick } clicked
   */

  reportAnchorElementClick(clicked) {}
  
  /**
   * @param { !Array<!blink.mojom.AnchorElementMetrics> } metrics
   * @param { !Array<!number> } removedElements
   */

  reportNewAnchorElements(metrics, removedElements) {}
  
  /**
   * @param { !Array<!blink.mojom.AnchorElementEnteredViewport> } elements
   */

  reportAnchorElementsEnteredViewport(elements) {}
  
  /**
   * @param { !Array<!blink.mojom.AnchorElementLeftViewport> } elements
   */

  reportAnchorElementsLeftViewport(elements) {}
  
  /**
   * @param { !Array<!blink.mojom.AnchorElementPositionUpdate> } elements
   */

  reportAnchorElementsPositionUpdate(elements) {}
  
  /**
   * @param { !blink.mojom.AnchorElementPointerOver } pointerOverEvent
   */

  reportAnchorElementPointerOver(pointerOverEvent) {}
  
  /**
   * @param { !blink.mojom.AnchorElementPointerOut } hoverEvent
   */

  reportAnchorElementPointerOut(hoverEvent) {}
  
  /**
   * @param { !blink.mojom.AnchorElementPointerDown } pointerDownEvent
   */

  reportAnchorElementPointerDown(pointerDownEvent) {}
  
  /**
   * @param { !blink.mojom.AnchorElementPointerDataOnHoverTimerFired } pointerData
   */

  reportAnchorElementPointerDataOnHoverTimerFired(pointerData) {}
  
  /**
   * @param { !blink.mojom.AnchorElementPointerEventForMLModel } pointerEvent
   */

  processPointerEventUsingMLModel(pointerEvent) {}
  
  /**
   * @return {!Promise<{
        shouldSkipForTesting: !boolean,
   *  }>}
   */

  shouldSkipUpdateDelays() {}
};

/**
 * @export
 * @implements { blink.mojom.AnchorElementMetricsHostInterface }
 */
blink.mojom.AnchorElementMetricsHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.AnchorElementMetricsHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.AnchorElementMetricsHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.AnchorElementMetricsHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.AnchorElementClick } clicked
   */

  reportAnchorElementClick(
      clicked) {
    this.proxy.sendMessage(
        0,
        blink.mojom.AnchorElementMetricsHost_ReportAnchorElementClick_ParamsSpec.$,
        null,
        [
          clicked
        ],
        false);
  }

  
  /**
   * @param { !Array<!blink.mojom.AnchorElementMetrics> } metrics
   * @param { !Array<!number> } removedElements
   */

  reportNewAnchorElements(
      metrics,
      removedElements) {
    this.proxy.sendMessage(
        1,
        blink.mojom.AnchorElementMetricsHost_ReportNewAnchorElements_ParamsSpec.$,
        null,
        [
          metrics,
          removedElements
        ],
        false);
  }

  
  /**
   * @param { !Array<!blink.mojom.AnchorElementEnteredViewport> } elements
   */

  reportAnchorElementsEnteredViewport(
      elements) {
    this.proxy.sendMessage(
        2,
        blink.mojom.AnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_ParamsSpec.$,
        null,
        [
          elements
        ],
        false);
  }

  
  /**
   * @param { !Array<!blink.mojom.AnchorElementLeftViewport> } elements
   */

  reportAnchorElementsLeftViewport(
      elements) {
    this.proxy.sendMessage(
        3,
        blink.mojom.AnchorElementMetricsHost_ReportAnchorElementsLeftViewport_ParamsSpec.$,
        null,
        [
          elements
        ],
        false);
  }

  
  /**
   * @param { !Array<!blink.mojom.AnchorElementPositionUpdate> } elements
   */

  reportAnchorElementsPositionUpdate(
      elements) {
    this.proxy.sendMessage(
        4,
        blink.mojom.AnchorElementMetricsHost_ReportAnchorElementsPositionUpdate_ParamsSpec.$,
        null,
        [
          elements
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.AnchorElementPointerOver } pointerOverEvent
   */

  reportAnchorElementPointerOver(
      pointerOverEvent) {
    this.proxy.sendMessage(
        5,
        blink.mojom.AnchorElementMetricsHost_ReportAnchorElementPointerOver_ParamsSpec.$,
        null,
        [
          pointerOverEvent
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.AnchorElementPointerOut } hoverEvent
   */

  reportAnchorElementPointerOut(
      hoverEvent) {
    this.proxy.sendMessage(
        6,
        blink.mojom.AnchorElementMetricsHost_ReportAnchorElementPointerOut_ParamsSpec.$,
        null,
        [
          hoverEvent
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.AnchorElementPointerDown } pointerDownEvent
   */

  reportAnchorElementPointerDown(
      pointerDownEvent) {
    this.proxy.sendMessage(
        7,
        blink.mojom.AnchorElementMetricsHost_ReportAnchorElementPointerDown_ParamsSpec.$,
        null,
        [
          pointerDownEvent
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.AnchorElementPointerDataOnHoverTimerFired } pointerData
   */

  reportAnchorElementPointerDataOnHoverTimerFired(
      pointerData) {
    this.proxy.sendMessage(
        8,
        blink.mojom.AnchorElementMetricsHost_ReportAnchorElementPointerDataOnHoverTimerFired_ParamsSpec.$,
        null,
        [
          pointerData
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.AnchorElementPointerEventForMLModel } pointerEvent
   */

  processPointerEventUsingMLModel(
      pointerEvent) {
    this.proxy.sendMessage(
        9,
        blink.mojom.AnchorElementMetricsHost_ProcessPointerEventUsingMLModel_ParamsSpec.$,
        null,
        [
          pointerEvent
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        shouldSkipForTesting: !boolean,
   *  }>}
   */

  shouldSkipUpdateDelays() {
    return this.proxy.sendMessage(
        10,
        blink.mojom.AnchorElementMetricsHost_ShouldSkipUpdateDelays_ParamsSpec.$,
        blink.mojom.AnchorElementMetricsHost_ShouldSkipUpdateDelays_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AnchorElementMetricsHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.AnchorElementMetricsHostReceiver = class {
  /**
   * @param {!blink.mojom.AnchorElementMetricsHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.AnchorElementMetricsHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.AnchorElementMetricsHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AnchorElementMetricsHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.AnchorElementMetricsHost_ReportAnchorElementClick_ParamsSpec.$,
        null,
        impl.reportAnchorElementClick.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.AnchorElementMetricsHost_ReportNewAnchorElements_ParamsSpec.$,
        null,
        impl.reportNewAnchorElements.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.AnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_ParamsSpec.$,
        null,
        impl.reportAnchorElementsEnteredViewport.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.AnchorElementMetricsHost_ReportAnchorElementsLeftViewport_ParamsSpec.$,
        null,
        impl.reportAnchorElementsLeftViewport.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.AnchorElementMetricsHost_ReportAnchorElementsPositionUpdate_ParamsSpec.$,
        null,
        impl.reportAnchorElementsPositionUpdate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.AnchorElementMetricsHost_ReportAnchorElementPointerOver_ParamsSpec.$,
        null,
        impl.reportAnchorElementPointerOver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        blink.mojom.AnchorElementMetricsHost_ReportAnchorElementPointerOut_ParamsSpec.$,
        null,
        impl.reportAnchorElementPointerOut.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        blink.mojom.AnchorElementMetricsHost_ReportAnchorElementPointerDown_ParamsSpec.$,
        null,
        impl.reportAnchorElementPointerDown.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        blink.mojom.AnchorElementMetricsHost_ReportAnchorElementPointerDataOnHoverTimerFired_ParamsSpec.$,
        null,
        impl.reportAnchorElementPointerDataOnHoverTimerFired.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        blink.mojom.AnchorElementMetricsHost_ProcessPointerEventUsingMLModel_ParamsSpec.$,
        null,
        impl.processPointerEventUsingMLModel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        blink.mojom.AnchorElementMetricsHost_ShouldSkipUpdateDelays_ParamsSpec.$,
        blink.mojom.AnchorElementMetricsHost_ShouldSkipUpdateDelays_ResponseParamsSpec.$,
        impl.shouldSkipUpdateDelays.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.AnchorElementMetricsHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AnchorElementMetricsHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.AnchorElementMetricsHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.AnchorElementMetricsHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AnchorElementMetricsHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.AnchorElementMetricsHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.AnchorElementMetricsHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AnchorElementMetricsHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reportAnchorElementClick =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.AnchorElementMetricsHost_ReportAnchorElementClick_ParamsSpec.$,
        null,
        this.reportAnchorElementClick.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reportNewAnchorElements =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.AnchorElementMetricsHost_ReportNewAnchorElements_ParamsSpec.$,
        null,
        this.reportNewAnchorElements.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reportAnchorElementsEnteredViewport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.AnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_ParamsSpec.$,
        null,
        this.reportAnchorElementsEnteredViewport.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reportAnchorElementsLeftViewport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.AnchorElementMetricsHost_ReportAnchorElementsLeftViewport_ParamsSpec.$,
        null,
        this.reportAnchorElementsLeftViewport.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reportAnchorElementsPositionUpdate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.AnchorElementMetricsHost_ReportAnchorElementsPositionUpdate_ParamsSpec.$,
        null,
        this.reportAnchorElementsPositionUpdate.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reportAnchorElementPointerOver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.AnchorElementMetricsHost_ReportAnchorElementPointerOver_ParamsSpec.$,
        null,
        this.reportAnchorElementPointerOver.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reportAnchorElementPointerOut =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        blink.mojom.AnchorElementMetricsHost_ReportAnchorElementPointerOut_ParamsSpec.$,
        null,
        this.reportAnchorElementPointerOut.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reportAnchorElementPointerDown =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        blink.mojom.AnchorElementMetricsHost_ReportAnchorElementPointerDown_ParamsSpec.$,
        null,
        this.reportAnchorElementPointerDown.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reportAnchorElementPointerDataOnHoverTimerFired =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        blink.mojom.AnchorElementMetricsHost_ReportAnchorElementPointerDataOnHoverTimerFired_ParamsSpec.$,
        null,
        this.reportAnchorElementPointerDataOnHoverTimerFired.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.processPointerEventUsingMLModel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        blink.mojom.AnchorElementMetricsHost_ProcessPointerEventUsingMLModel_ParamsSpec.$,
        null,
        this.processPointerEventUsingMLModel.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.shouldSkipUpdateDelays =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        blink.mojom.AnchorElementMetricsHost_ShouldSkipUpdateDelays_ParamsSpec.$,
        blink.mojom.AnchorElementMetricsHost_ShouldSkipUpdateDelays_ResponseParamsSpec.$,
        this.shouldSkipUpdateDelays.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.AnchorElementMetricsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AnchorElementMetricsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AnchorElementClickSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AnchorElementClickSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AnchorElementPointerDataOnHoverTimerFiredSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AnchorElementPointerDataOnHoverTimerFiredSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AnchorElementEnteredViewportSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AnchorElementEnteredViewportSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AnchorElementLeftViewportSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AnchorElementLeftViewportSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AnchorElementPointerOverSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AnchorElementPointerOverSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AnchorElementPointerOutSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AnchorElementPointerOutSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AnchorElementPointerEventForMLModelSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AnchorElementPointerEventForMLModelSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AnchorElementPointerDownSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AnchorElementPointerDownSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AnchorElementPositionUpdateSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AnchorElementPositionUpdateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AnchorElementMetricsHost_ReportAnchorElementClick_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AnchorElementMetricsHost_ReportAnchorElementClick_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AnchorElementMetricsHost_ReportNewAnchorElements_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AnchorElementMetricsHost_ReportNewAnchorElements_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AnchorElementMetricsHost_ReportAnchorElementsLeftViewport_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AnchorElementMetricsHost_ReportAnchorElementsLeftViewport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AnchorElementMetricsHost_ReportAnchorElementsPositionUpdate_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AnchorElementMetricsHost_ReportAnchorElementsPositionUpdate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AnchorElementMetricsHost_ReportAnchorElementPointerOver_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AnchorElementMetricsHost_ReportAnchorElementPointerOver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AnchorElementMetricsHost_ReportAnchorElementPointerOut_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AnchorElementMetricsHost_ReportAnchorElementPointerOut_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AnchorElementMetricsHost_ReportAnchorElementPointerDown_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AnchorElementMetricsHost_ReportAnchorElementPointerDown_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AnchorElementMetricsHost_ReportAnchorElementPointerDataOnHoverTimerFired_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AnchorElementMetricsHost_ReportAnchorElementPointerDataOnHoverTimerFired_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AnchorElementMetricsHost_ProcessPointerEventUsingMLModel_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AnchorElementMetricsHost_ProcessPointerEventUsingMLModel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AnchorElementMetricsHost_ShouldSkipUpdateDelays_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AnchorElementMetricsHost_ShouldSkipUpdateDelays_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AnchorElementMetricsHost_ShouldSkipUpdateDelays_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AnchorElementMetricsHost_ShouldSkipUpdateDelays_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.AnchorElementMetricsSpec.$,
    'AnchorElementMetrics',
    [
      mojo.internal.StructField(
        'anchorId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ratioArea', 4,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ratioDistanceTopToVisibleTop', 8,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ratioDistanceRootTop', 12,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isInIframe', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'containsImage', 16,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isSameHost', 16,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isUrlIncrementedByOne', 16,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasTextSibling', 16,
        4,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fontSizePx', 20,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fontWeight', 24,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'targetUrl', 32,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'viewportSize', 40,
        0,
        gfx.mojom.SizeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);



goog.provide('blink.mojom.AnchorElementMetrics');

/** @record */
blink.mojom.AnchorElementMetrics = class {
  constructor() {
    /** @export { !number } */
    this.anchorId;
    /** @export { !number } */
    this.ratioArea;
    /** @export { !number } */
    this.ratioDistanceTopToVisibleTop;
    /** @export { !number } */
    this.ratioDistanceRootTop;
    /** @export { !boolean } */
    this.isInIframe;
    /** @export { !boolean } */
    this.containsImage;
    /** @export { !boolean } */
    this.isSameHost;
    /** @export { !boolean } */
    this.isUrlIncrementedByOne;
    /** @export { !boolean } */
    this.hasTextSibling;
    /** @export { !number } */
    this.fontSizePx;
    /** @export { !number } */
    this.fontWeight;
    /** @export { !url.mojom.Url } */
    this.targetUrl;
    /** @export { !gfx.mojom.Size } */
    this.viewportSize;
  }
};



mojo.internal.Struct(
    blink.mojom.AnchorElementClickSpec.$,
    'AnchorElementClick',
    [
      mojo.internal.StructField(
        'anchorId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'targetUrl', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'navigationStartToClick', 16,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.AnchorElementClick');

/** @record */
blink.mojom.AnchorElementClick = class {
  constructor() {
    /** @export { !number } */
    this.anchorId;
    /** @export { !url.mojom.Url } */
    this.targetUrl;
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.navigationStartToClick;
  }
};



mojo.internal.Struct(
    blink.mojom.AnchorElementPointerDataOnHoverTimerFiredSpec.$,
    'AnchorElementPointerDataOnHoverTimerFired',
    [
      mojo.internal.StructField(
        'anchorId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pointerData', 8,
        0,
        blink.mojom.AnchorElementPointerDataSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AnchorElementPointerDataOnHoverTimerFired');

/** @record */
blink.mojom.AnchorElementPointerDataOnHoverTimerFired = class {
  constructor() {
    /** @export { !number } */
    this.anchorId;
    /** @export { !blink.mojom.AnchorElementPointerData } */
    this.pointerData;
  }
};



mojo.internal.Struct(
    blink.mojom.AnchorElementEnteredViewportSpec.$,
    'AnchorElementEnteredViewport',
    [
      mojo.internal.StructField(
        'anchorId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'navigationStartToEnteredViewport', 8,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AnchorElementEnteredViewport');

/** @record */
blink.mojom.AnchorElementEnteredViewport = class {
  constructor() {
    /** @export { !number } */
    this.anchorId;
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.navigationStartToEnteredViewport;
  }
};



mojo.internal.Struct(
    blink.mojom.AnchorElementLeftViewportSpec.$,
    'AnchorElementLeftViewport',
    [
      mojo.internal.StructField(
        'anchorId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'timeInViewport', 8,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AnchorElementLeftViewport');

/** @record */
blink.mojom.AnchorElementLeftViewport = class {
  constructor() {
    /** @export { !number } */
    this.anchorId;
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.timeInViewport;
  }
};



mojo.internal.Struct(
    blink.mojom.AnchorElementPointerOverSpec.$,
    'AnchorElementPointerOver',
    [
      mojo.internal.StructField(
        'anchorId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'navigationStartToPointerOver', 8,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AnchorElementPointerOver');

/** @record */
blink.mojom.AnchorElementPointerOver = class {
  constructor() {
    /** @export { !number } */
    this.anchorId;
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.navigationStartToPointerOver;
  }
};



mojo.internal.Struct(
    blink.mojom.AnchorElementPointerOutSpec.$,
    'AnchorElementPointerOut',
    [
      mojo.internal.StructField(
        'anchorId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hoverDwellTime', 8,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AnchorElementPointerOut');

/** @record */
blink.mojom.AnchorElementPointerOut = class {
  constructor() {
    /** @export { !number } */
    this.anchorId;
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.hoverDwellTime;
  }
};



mojo.internal.Struct(
    blink.mojom.AnchorElementPointerEventForMLModelSpec.$,
    'AnchorElementPointerEventForMLModel',
    [
      mojo.internal.StructField(
        'anchorId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isMouse', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'userInteractionEventType', 8,
        0,
        blink.mojom.AnchorElementUserInteractionEventForMLModelTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AnchorElementPointerEventForMLModel');

/** @record */
blink.mojom.AnchorElementPointerEventForMLModel = class {
  constructor() {
    /** @export { !number } */
    this.anchorId;
    /** @export { !boolean } */
    this.isMouse;
    /** @export { !blink.mojom.AnchorElementUserInteractionEventForMLModelType } */
    this.userInteractionEventType;
  }
};



mojo.internal.Struct(
    blink.mojom.AnchorElementPointerDownSpec.$,
    'AnchorElementPointerDown',
    [
      mojo.internal.StructField(
        'anchorId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'navigationStartToPointerDown', 8,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AnchorElementPointerDown');

/** @record */
blink.mojom.AnchorElementPointerDown = class {
  constructor() {
    /** @export { !number } */
    this.anchorId;
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.navigationStartToPointerDown;
  }
};



mojo.internal.Struct(
    blink.mojom.AnchorElementPositionUpdateSpec.$,
    'AnchorElementPositionUpdate',
    [
      mojo.internal.StructField(
        'anchorId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'verticalPositionRatio', 4,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'distance_from_pointer_down_ratio_$flag', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "distance_from_pointer_down_ratio_$value",
          originalFieldName: "distanceFromPointerDownRatio",
        }
      ),
      mojo.internal.StructField(
        'distance_from_pointer_down_ratio_$value', 12,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "distanceFromPointerDownRatio",
        }
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AnchorElementPositionUpdate');

/** @record */
blink.mojom.AnchorElementPositionUpdate = class {
  constructor() {
    /** @export { !number } */
    this.anchorId;
    /** @export { !number } */
    this.verticalPositionRatio;
    /** @export { (number|undefined) } */
    this.distanceFromPointerDownRatio;
  }
};



mojo.internal.Struct(
    blink.mojom.AnchorElementMetricsHost_ReportAnchorElementClick_ParamsSpec.$,
    'AnchorElementMetricsHost_ReportAnchorElementClick_Params',
    [
      mojo.internal.StructField(
        'clicked', 0,
        0,
        blink.mojom.AnchorElementClickSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AnchorElementMetricsHost_ReportAnchorElementClick_Params');

/** @record */
blink.mojom.AnchorElementMetricsHost_ReportAnchorElementClick_Params = class {
  constructor() {
    /** @export { !blink.mojom.AnchorElementClick } */
    this.clicked;
  }
};



mojo.internal.Struct(
    blink.mojom.AnchorElementMetricsHost_ReportNewAnchorElements_ParamsSpec.$,
    'AnchorElementMetricsHost_ReportNewAnchorElements_Params',
    [
      mojo.internal.StructField(
        'metrics', 0,
        0,
        mojo.internal.Array(blink.mojom.AnchorElementMetricsSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'removedElements', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint32, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AnchorElementMetricsHost_ReportNewAnchorElements_Params');

/** @record */
blink.mojom.AnchorElementMetricsHost_ReportNewAnchorElements_Params = class {
  constructor() {
    /** @export { !Array<!blink.mojom.AnchorElementMetrics> } */
    this.metrics;
    /** @export { !Array<!number> } */
    this.removedElements;
  }
};



mojo.internal.Struct(
    blink.mojom.AnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_ParamsSpec.$,
    'AnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_Params',
    [
      mojo.internal.StructField(
        'elements', 0,
        0,
        mojo.internal.Array(blink.mojom.AnchorElementEnteredViewportSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_Params');

/** @record */
blink.mojom.AnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_Params = class {
  constructor() {
    /** @export { !Array<!blink.mojom.AnchorElementEnteredViewport> } */
    this.elements;
  }
};



mojo.internal.Struct(
    blink.mojom.AnchorElementMetricsHost_ReportAnchorElementsLeftViewport_ParamsSpec.$,
    'AnchorElementMetricsHost_ReportAnchorElementsLeftViewport_Params',
    [
      mojo.internal.StructField(
        'elements', 0,
        0,
        mojo.internal.Array(blink.mojom.AnchorElementLeftViewportSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AnchorElementMetricsHost_ReportAnchorElementsLeftViewport_Params');

/** @record */
blink.mojom.AnchorElementMetricsHost_ReportAnchorElementsLeftViewport_Params = class {
  constructor() {
    /** @export { !Array<!blink.mojom.AnchorElementLeftViewport> } */
    this.elements;
  }
};



mojo.internal.Struct(
    blink.mojom.AnchorElementMetricsHost_ReportAnchorElementsPositionUpdate_ParamsSpec.$,
    'AnchorElementMetricsHost_ReportAnchorElementsPositionUpdate_Params',
    [
      mojo.internal.StructField(
        'elements', 0,
        0,
        mojo.internal.Array(blink.mojom.AnchorElementPositionUpdateSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AnchorElementMetricsHost_ReportAnchorElementsPositionUpdate_Params');

/** @record */
blink.mojom.AnchorElementMetricsHost_ReportAnchorElementsPositionUpdate_Params = class {
  constructor() {
    /** @export { !Array<!blink.mojom.AnchorElementPositionUpdate> } */
    this.elements;
  }
};



mojo.internal.Struct(
    blink.mojom.AnchorElementMetricsHost_ReportAnchorElementPointerOver_ParamsSpec.$,
    'AnchorElementMetricsHost_ReportAnchorElementPointerOver_Params',
    [
      mojo.internal.StructField(
        'pointerOverEvent', 0,
        0,
        blink.mojom.AnchorElementPointerOverSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AnchorElementMetricsHost_ReportAnchorElementPointerOver_Params');

/** @record */
blink.mojom.AnchorElementMetricsHost_ReportAnchorElementPointerOver_Params = class {
  constructor() {
    /** @export { !blink.mojom.AnchorElementPointerOver } */
    this.pointerOverEvent;
  }
};



mojo.internal.Struct(
    blink.mojom.AnchorElementMetricsHost_ReportAnchorElementPointerOut_ParamsSpec.$,
    'AnchorElementMetricsHost_ReportAnchorElementPointerOut_Params',
    [
      mojo.internal.StructField(
        'hoverEvent', 0,
        0,
        blink.mojom.AnchorElementPointerOutSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AnchorElementMetricsHost_ReportAnchorElementPointerOut_Params');

/** @record */
blink.mojom.AnchorElementMetricsHost_ReportAnchorElementPointerOut_Params = class {
  constructor() {
    /** @export { !blink.mojom.AnchorElementPointerOut } */
    this.hoverEvent;
  }
};



mojo.internal.Struct(
    blink.mojom.AnchorElementMetricsHost_ReportAnchorElementPointerDown_ParamsSpec.$,
    'AnchorElementMetricsHost_ReportAnchorElementPointerDown_Params',
    [
      mojo.internal.StructField(
        'pointerDownEvent', 0,
        0,
        blink.mojom.AnchorElementPointerDownSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AnchorElementMetricsHost_ReportAnchorElementPointerDown_Params');

/** @record */
blink.mojom.AnchorElementMetricsHost_ReportAnchorElementPointerDown_Params = class {
  constructor() {
    /** @export { !blink.mojom.AnchorElementPointerDown } */
    this.pointerDownEvent;
  }
};



mojo.internal.Struct(
    blink.mojom.AnchorElementMetricsHost_ReportAnchorElementPointerDataOnHoverTimerFired_ParamsSpec.$,
    'AnchorElementMetricsHost_ReportAnchorElementPointerDataOnHoverTimerFired_Params',
    [
      mojo.internal.StructField(
        'pointerData', 0,
        0,
        blink.mojom.AnchorElementPointerDataOnHoverTimerFiredSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AnchorElementMetricsHost_ReportAnchorElementPointerDataOnHoverTimerFired_Params');

/** @record */
blink.mojom.AnchorElementMetricsHost_ReportAnchorElementPointerDataOnHoverTimerFired_Params = class {
  constructor() {
    /** @export { !blink.mojom.AnchorElementPointerDataOnHoverTimerFired } */
    this.pointerData;
  }
};



mojo.internal.Struct(
    blink.mojom.AnchorElementMetricsHost_ProcessPointerEventUsingMLModel_ParamsSpec.$,
    'AnchorElementMetricsHost_ProcessPointerEventUsingMLModel_Params',
    [
      mojo.internal.StructField(
        'pointerEvent', 0,
        0,
        blink.mojom.AnchorElementPointerEventForMLModelSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AnchorElementMetricsHost_ProcessPointerEventUsingMLModel_Params');

/** @record */
blink.mojom.AnchorElementMetricsHost_ProcessPointerEventUsingMLModel_Params = class {
  constructor() {
    /** @export { !blink.mojom.AnchorElementPointerEventForMLModel } */
    this.pointerEvent;
  }
};



mojo.internal.Struct(
    blink.mojom.AnchorElementMetricsHost_ShouldSkipUpdateDelays_ParamsSpec.$,
    'AnchorElementMetricsHost_ShouldSkipUpdateDelays_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.AnchorElementMetricsHost_ShouldSkipUpdateDelays_Params');

/** @record */
blink.mojom.AnchorElementMetricsHost_ShouldSkipUpdateDelays_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.AnchorElementMetricsHost_ShouldSkipUpdateDelays_ResponseParamsSpec.$,
    'AnchorElementMetricsHost_ShouldSkipUpdateDelays_ResponseParams',
    [
      mojo.internal.StructField(
        'shouldSkipForTesting', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AnchorElementMetricsHost_ShouldSkipUpdateDelays_ResponseParams');

/** @record */
blink.mojom.AnchorElementMetricsHost_ShouldSkipUpdateDelays_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.shouldSkipForTesting;
  }
};

