// third_party/blink/public/mojom/loader/content_security_notifier.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.ContentSecurityNotifierPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.ContentSecurityNotifier.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.ContentSecurityNotifierInterface }
 */
blink.mojom.ContentSecurityNotifierRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.ContentSecurityNotifierPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.ContentSecurityNotifierPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.ContentSecurityNotifierPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  notifyContentWithCertificateErrorsRan() {
    this.proxy.sendMessage(
        0,
        blink.mojom.ContentSecurityNotifier_NotifyContentWithCertificateErrorsRan_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  notifyContentWithCertificateErrorsDisplayed() {
    this.proxy.sendMessage(
        1,
        blink.mojom.ContentSecurityNotifier_NotifyContentWithCertificateErrorsDisplayed_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } origin
   * @param { !url.mojom.Url } insecureUrl
   */

  notifyInsecureContentRan(
      origin,
      insecureUrl) {
    this.proxy.sendMessage(
        2,
        blink.mojom.ContentSecurityNotifier_NotifyInsecureContentRan_ParamsSpec.$,
        null,
        [
          origin,
          insecureUrl
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ContentSecurityNotifier
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.ContentSecurityNotifierReceiver = class {
  /**
   * @param {!blink.mojom.ContentSecurityNotifierInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.ContentSecurityNotifierRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.ContentSecurityNotifierRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ContentSecurityNotifierRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ContentSecurityNotifier_NotifyContentWithCertificateErrorsRan_ParamsSpec.$,
        null,
        impl.notifyContentWithCertificateErrorsRan.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.ContentSecurityNotifier_NotifyContentWithCertificateErrorsDisplayed_ParamsSpec.$,
        null,
        impl.notifyContentWithCertificateErrorsDisplayed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.ContentSecurityNotifier_NotifyInsecureContentRan_ParamsSpec.$,
        null,
        impl.notifyInsecureContentRan.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.ContentSecurityNotifier = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ContentSecurityNotifier";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.ContentSecurityNotifierRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.ContentSecurityNotifierRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ContentSecurityNotifier
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.ContentSecurityNotifierCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.ContentSecurityNotifierRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ContentSecurityNotifierRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyContentWithCertificateErrorsRan =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ContentSecurityNotifier_NotifyContentWithCertificateErrorsRan_ParamsSpec.$,
        null,
        this.notifyContentWithCertificateErrorsRan.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyContentWithCertificateErrorsDisplayed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.ContentSecurityNotifier_NotifyContentWithCertificateErrorsDisplayed_ParamsSpec.$,
        null,
        this.notifyContentWithCertificateErrorsDisplayed.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyInsecureContentRan =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.ContentSecurityNotifier_NotifyInsecureContentRan_ParamsSpec.$,
        null,
        this.notifyInsecureContentRan.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ContentSecurityNotifier_NotifyContentWithCertificateErrorsRan_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ContentSecurityNotifier_NotifyContentWithCertificateErrorsDisplayed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ContentSecurityNotifier_NotifyInsecureContentRan_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.ContentSecurityNotifier_NotifyContentWithCertificateErrorsRan_ParamsSpec.$,
    'ContentSecurityNotifier_NotifyContentWithCertificateErrorsRan_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.ContentSecurityNotifier_NotifyContentWithCertificateErrorsRan_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.ContentSecurityNotifier_NotifyContentWithCertificateErrorsDisplayed_ParamsSpec.$,
    'ContentSecurityNotifier_NotifyContentWithCertificateErrorsDisplayed_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.ContentSecurityNotifier_NotifyContentWithCertificateErrorsDisplayed_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.ContentSecurityNotifier_NotifyInsecureContentRan_ParamsSpec.$,
    'ContentSecurityNotifier_NotifyInsecureContentRan_Params',
    [
      mojo.internal.StructField(
        'origin', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'insecureUrl', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.ContentSecurityNotifier_NotifyInsecureContentRan_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.origin;
    /** @export { !url.mojom.Url } */
    this.insecureUrl;
  }
};

