// third_party/blink/public/mojom/lcp_critical_path_predictor/lcp_critical_path_predictor.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  ByteString as mojoBase_mojom_ByteString,
  ByteStringSpec as mojoBase_mojom_ByteStringSpec
} from '../../../../../mojo/public/mojom/base/byte_string.mojom.m.js';

import {
  TimeDelta as mojoBase_mojom_TimeDelta,
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec
} from '../../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  RequestDestination as network_mojom_RequestDestination,
  RequestDestinationSpec as network_mojom_RequestDestinationSpec
} from '../../../../../services/network/public/mojom/fetch_api.mojom.m.js';

import {
  Origin as url_mojom_Origin,
  OriginSpec as url_mojom_OriginSpec
} from '../../../../../url/mojom/origin.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class LCPCriticalPathPredictorHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.LCPCriticalPathPredictorHost', scope);
  }
}

/** @interface */
export class LCPCriticalPathPredictorHostInterface {
  
  /**
   * @param { !LcpElement } lcpElement
   */

  onLcpUpdated(lcpElement) {}
  
  /**
   * @param { ?mojoBase_mojom_ByteString } elementLocator
   */

  onLcpTimingPredictedForTesting(elementLocator) {}
  
  /**
   * @param { !Array<!url_mojom_Url> } lcpInfluencerScripts
   */

  setLcpInfluencerScriptUrls(lcpInfluencerScripts) {}
  
  /**
   * @param { !url_mojom_Origin } origin
   */

  addPreconnectOrigin(origin) {}
  
  /**
   * @param { !url_mojom_Url } fontUrl
   * @param { !boolean } hit
   */

  notifyFetchedFont(fontUrl, hit) {}
  
  /**
   * @param { !url_mojom_Url } subresourceUrl
   * @param { !mojoBase_mojom_TimeDelta } subresourceLoadStart
   * @param { !network_mojom_RequestDestination } requestDestination
   */

  notifyFetchedSubresource(subresourceUrl, subresourceLoadStart, requestDestination) {}
  
  /**
   * @param { !Array<!url_mojom_Url> } unusedPreloads
   */

  setUnusedPreloads(unusedPreloads) {}
}

/**
 * @implements { LCPCriticalPathPredictorHostInterface }
 */
export class LCPCriticalPathPredictorHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!LCPCriticalPathPredictorHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          LCPCriticalPathPredictorHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!LCPCriticalPathPredictorHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !LcpElement } lcpElement
   */

  onLcpUpdated(
      lcpElement) {
    this.proxy.sendMessage(
        0,
        LCPCriticalPathPredictorHost_OnLcpUpdated_ParamsSpec.$,
        null,
        [
          lcpElement
        ],
        false);
  }

  
  /**
   * @param { ?mojoBase_mojom_ByteString } elementLocator
   */

  onLcpTimingPredictedForTesting(
      elementLocator) {
    this.proxy.sendMessage(
        1,
        LCPCriticalPathPredictorHost_OnLcpTimingPredictedForTesting_ParamsSpec.$,
        null,
        [
          elementLocator
        ],
        false);
  }

  
  /**
   * @param { !Array<!url_mojom_Url> } lcpInfluencerScripts
   */

  setLcpInfluencerScriptUrls(
      lcpInfluencerScripts) {
    this.proxy.sendMessage(
        2,
        LCPCriticalPathPredictorHost_SetLcpInfluencerScriptUrls_ParamsSpec.$,
        null,
        [
          lcpInfluencerScripts
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Origin } origin
   */

  addPreconnectOrigin(
      origin) {
    this.proxy.sendMessage(
        3,
        LCPCriticalPathPredictorHost_AddPreconnectOrigin_ParamsSpec.$,
        null,
        [
          origin
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } fontUrl
   * @param { !boolean } hit
   */

  notifyFetchedFont(
      fontUrl,
      hit) {
    this.proxy.sendMessage(
        4,
        LCPCriticalPathPredictorHost_NotifyFetchedFont_ParamsSpec.$,
        null,
        [
          fontUrl,
          hit
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } subresourceUrl
   * @param { !mojoBase_mojom_TimeDelta } subresourceLoadStart
   * @param { !network_mojom_RequestDestination } requestDestination
   */

  notifyFetchedSubresource(
      subresourceUrl,
      subresourceLoadStart,
      requestDestination) {
    this.proxy.sendMessage(
        5,
        LCPCriticalPathPredictorHost_NotifyFetchedSubresource_ParamsSpec.$,
        null,
        [
          subresourceUrl,
          subresourceLoadStart,
          requestDestination
        ],
        false);
  }

  
  /**
   * @param { !Array<!url_mojom_Url> } unusedPreloads
   */

  setUnusedPreloads(
      unusedPreloads) {
    this.proxy.sendMessage(
        6,
        LCPCriticalPathPredictorHost_SetUnusedPreloads_ParamsSpec.$,
        null,
        [
          unusedPreloads
        ],
        false);
  }
}

/**
 * An object which receives request messages for the LCPCriticalPathPredictorHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class LCPCriticalPathPredictorHostReceiver {
  /**
   * @param {!LCPCriticalPathPredictorHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!LCPCriticalPathPredictorHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        LCPCriticalPathPredictorHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!LCPCriticalPathPredictorHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        LCPCriticalPathPredictorHost_OnLcpUpdated_ParamsSpec.$,
        null,
        impl.onLcpUpdated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        LCPCriticalPathPredictorHost_OnLcpTimingPredictedForTesting_ParamsSpec.$,
        null,
        impl.onLcpTimingPredictedForTesting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        LCPCriticalPathPredictorHost_SetLcpInfluencerScriptUrls_ParamsSpec.$,
        null,
        impl.setLcpInfluencerScriptUrls.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        LCPCriticalPathPredictorHost_AddPreconnectOrigin_ParamsSpec.$,
        null,
        impl.addPreconnectOrigin.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        LCPCriticalPathPredictorHost_NotifyFetchedFont_ParamsSpec.$,
        null,
        impl.notifyFetchedFont.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        LCPCriticalPathPredictorHost_NotifyFetchedSubresource_ParamsSpec.$,
        null,
        impl.notifyFetchedSubresource.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        LCPCriticalPathPredictorHost_SetUnusedPreloads_ParamsSpec.$,
        null,
        impl.setUnusedPreloads.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class LCPCriticalPathPredictorHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.LCPCriticalPathPredictorHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!LCPCriticalPathPredictorHostRemote}
   */
  static getRemote() {
    let remote = new LCPCriticalPathPredictorHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the LCPCriticalPathPredictorHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class LCPCriticalPathPredictorHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      LCPCriticalPathPredictorHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!LCPCriticalPathPredictorHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onLcpUpdated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        LCPCriticalPathPredictorHost_OnLcpUpdated_ParamsSpec.$,
        null,
        this.onLcpUpdated.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onLcpTimingPredictedForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        LCPCriticalPathPredictorHost_OnLcpTimingPredictedForTesting_ParamsSpec.$,
        null,
        this.onLcpTimingPredictedForTesting.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setLcpInfluencerScriptUrls =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        LCPCriticalPathPredictorHost_SetLcpInfluencerScriptUrls_ParamsSpec.$,
        null,
        this.setLcpInfluencerScriptUrls.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addPreconnectOrigin =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        LCPCriticalPathPredictorHost_AddPreconnectOrigin_ParamsSpec.$,
        null,
        this.addPreconnectOrigin.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyFetchedFont =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        LCPCriticalPathPredictorHost_NotifyFetchedFont_ParamsSpec.$,
        null,
        this.notifyFetchedFont.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyFetchedSubresource =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        LCPCriticalPathPredictorHost_NotifyFetchedSubresource_ParamsSpec.$,
        null,
        this.notifyFetchedSubresource.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setUnusedPreloads =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        LCPCriticalPathPredictorHost_SetUnusedPreloads_ParamsSpec.$,
        null,
        this.setUnusedPreloads.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LcpElementSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LCPCriticalPathPredictorNavigationTimeHintSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LCPCriticalPathPredictorHost_OnLcpUpdated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LCPCriticalPathPredictorHost_OnLcpTimingPredictedForTesting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LCPCriticalPathPredictorHost_SetLcpInfluencerScriptUrls_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LCPCriticalPathPredictorHost_AddPreconnectOrigin_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LCPCriticalPathPredictorHost_NotifyFetchedFont_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LCPCriticalPathPredictorHost_NotifyFetchedSubresource_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LCPCriticalPathPredictorHost_SetUnusedPreloads_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    LcpElementSpec.$,
    'LcpElement',
    [
      mojo.internal.StructField(
        'locator', 0,
        0,
        mojoBase_mojom_ByteStringSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isImage', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'predicted_index_$flag', 8,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "predicted_index_$value",
          originalFieldName: "predictedIndex",
        }
      ),
      mojo.internal.StructField(
        'predicted_index_$value', 12,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "predictedIndex",
        }
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class LcpElement {
  constructor() {
    /** @type { (mojoBase_mojom_ByteString|undefined) } */
    this.locator;
    /** @type { !boolean } */
    this.isImage;
    /** @type { (number|undefined) } */
    this.predictedIndex;
  }
}



mojo.internal.Struct(
    LCPCriticalPathPredictorNavigationTimeHintSpec.$,
    'LCPCriticalPathPredictorNavigationTimeHint',
    [
      mojo.internal.StructField(
        'lcpElementLocators', 0,
        0,
        mojo.internal.Array(mojoBase_mojom_ByteStringSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'lcpElementLocatorsAll', 8,
        0,
        mojo.internal.Array(mojoBase_mojom_ByteStringSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'lcpInfluencerScripts', 16,
        0,
        mojo.internal.Array(url_mojom_UrlSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fetchedFonts', 24,
        0,
        mojo.internal.Array(url_mojom_UrlSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'preconnectOrigins', 32,
        0,
        mojo.internal.Array(url_mojom_OriginSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'unusedPreloads', 40,
        0,
        mojo.internal.Array(url_mojom_UrlSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'forTesting', 48,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 64],]);



/**
 * @record
 */
export class LCPCriticalPathPredictorNavigationTimeHint {
  constructor() {
    /** @type { !Array<!mojoBase_mojom_ByteString> } */
    this.lcpElementLocators;
    /** @type { !Array<!mojoBase_mojom_ByteString> } */
    this.lcpElementLocatorsAll;
    /** @type { !Array<!url_mojom_Url> } */
    this.lcpInfluencerScripts;
    /** @type { !Array<!url_mojom_Url> } */
    this.fetchedFonts;
    /** @type { !Array<!url_mojom_Origin> } */
    this.preconnectOrigins;
    /** @type { !Array<!url_mojom_Url> } */
    this.unusedPreloads;
    /** @type { !boolean } */
    this.forTesting;
  }
}



mojo.internal.Struct(
    LCPCriticalPathPredictorHost_OnLcpUpdated_ParamsSpec.$,
    'LCPCriticalPathPredictorHost_OnLcpUpdated_Params',
    [
      mojo.internal.StructField(
        'lcpElement', 0,
        0,
        LcpElementSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class LCPCriticalPathPredictorHost_OnLcpUpdated_Params {
  constructor() {
    /** @type { !LcpElement } */
    this.lcpElement;
  }
}



mojo.internal.Struct(
    LCPCriticalPathPredictorHost_OnLcpTimingPredictedForTesting_ParamsSpec.$,
    'LCPCriticalPathPredictorHost_OnLcpTimingPredictedForTesting_Params',
    [
      mojo.internal.StructField(
        'elementLocator', 0,
        0,
        mojoBase_mojom_ByteStringSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class LCPCriticalPathPredictorHost_OnLcpTimingPredictedForTesting_Params {
  constructor() {
    /** @type { (mojoBase_mojom_ByteString|undefined) } */
    this.elementLocator;
  }
}



mojo.internal.Struct(
    LCPCriticalPathPredictorHost_SetLcpInfluencerScriptUrls_ParamsSpec.$,
    'LCPCriticalPathPredictorHost_SetLcpInfluencerScriptUrls_Params',
    [
      mojo.internal.StructField(
        'lcpInfluencerScripts', 0,
        0,
        mojo.internal.Array(url_mojom_UrlSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class LCPCriticalPathPredictorHost_SetLcpInfluencerScriptUrls_Params {
  constructor() {
    /** @type { !Array<!url_mojom_Url> } */
    this.lcpInfluencerScripts;
  }
}



mojo.internal.Struct(
    LCPCriticalPathPredictorHost_AddPreconnectOrigin_ParamsSpec.$,
    'LCPCriticalPathPredictorHost_AddPreconnectOrigin_Params',
    [
      mojo.internal.StructField(
        'origin', 0,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class LCPCriticalPathPredictorHost_AddPreconnectOrigin_Params {
  constructor() {
    /** @type { !url_mojom_Origin } */
    this.origin;
  }
}



mojo.internal.Struct(
    LCPCriticalPathPredictorHost_NotifyFetchedFont_ParamsSpec.$,
    'LCPCriticalPathPredictorHost_NotifyFetchedFont_Params',
    [
      mojo.internal.StructField(
        'fontUrl', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hit', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class LCPCriticalPathPredictorHost_NotifyFetchedFont_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.fontUrl;
    /** @type { !boolean } */
    this.hit;
  }
}



mojo.internal.Struct(
    LCPCriticalPathPredictorHost_NotifyFetchedSubresource_ParamsSpec.$,
    'LCPCriticalPathPredictorHost_NotifyFetchedSubresource_Params',
    [
      mojo.internal.StructField(
        'subresourceUrl', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'subresourceLoadStart', 8,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requestDestination', 16,
        0,
        network_mojom_RequestDestinationSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class LCPCriticalPathPredictorHost_NotifyFetchedSubresource_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.subresourceUrl;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.subresourceLoadStart;
    /** @type { !network_mojom_RequestDestination } */
    this.requestDestination;
  }
}



mojo.internal.Struct(
    LCPCriticalPathPredictorHost_SetUnusedPreloads_ParamsSpec.$,
    'LCPCriticalPathPredictorHost_SetUnusedPreloads_Params',
    [
      mojo.internal.StructField(
        'unusedPreloads', 0,
        0,
        mojo.internal.Array(url_mojom_UrlSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class LCPCriticalPathPredictorHost_SetUnusedPreloads_Params {
  constructor() {
    /** @type { !Array<!url_mojom_Url> } */
    this.unusedPreloads;
  }
}

