// third_party/blink/public/mojom/interest_group/ad_auction_service.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/interest_group/ad_auction_service.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/interest_group/ad_auction_service.mojom-params-data.h"
#include "third_party/blink/public/mojom/interest_group/ad_auction_service.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/interest_group/ad_auction_service.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/interest_group/ad_auction_service.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
AuctionAdConfigAuctionIdPtr
AuctionAdConfigAuctionId::NewMainAuction(
    uint32_t value) {
  return AuctionAdConfigAuctionIdPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kMainAuction)>,
      std::move(value));
}

AuctionAdConfigAuctionIdPtr
AuctionAdConfigAuctionId::NewComponentAuction(
    uint32_t value) {
  return AuctionAdConfigAuctionIdPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kComponentAuction)>,
      std::move(value));
}

AuctionAdConfigAuctionId::AuctionAdConfigAuctionId(
    std::in_place_index_t<static_cast<size_t>(Tag::kMainAuction)>,
    uint32_t value)
    : tag_(Tag::kMainAuction),
      data_(std::in_place_index<static_cast<size_t>(Tag::kMainAuction)>,
            std::move(value)) {}

AuctionAdConfigAuctionId::AuctionAdConfigAuctionId(
    std::in_place_index_t<static_cast<size_t>(Tag::kComponentAuction)>,
    uint32_t value)
    : tag_(Tag::kComponentAuction),
      data_(std::in_place_index<static_cast<size_t>(Tag::kComponentAuction)>,
            std::move(value)) {}
AuctionAdConfigAuctionId::~AuctionAdConfigAuctionId() {
  DestroyActive();
}

void AuctionAdConfigAuctionId::set_main_auction(uint32_t main_auction) {
  if (tag_ != Tag::kMainAuction) {
    DestroyActive();
    tag_ = Tag::kMainAuction;
  }
  data_.main_auction = main_auction;
}

void AuctionAdConfigAuctionId::set_component_auction(uint32_t component_auction) {
  if (tag_ != Tag::kComponentAuction) {
    DestroyActive();
    tag_ = Tag::kComponentAuction;
  }
  data_.component_auction = component_auction;
}


AuctionAdConfigAuctionId::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kMainAuction)>,
    uint32_t value)
    : main_auction(std::move(value)) {}

AuctionAdConfigAuctionId::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kComponentAuction)>,
    uint32_t value)
    : component_auction(std::move(value)) {}

void AuctionAdConfigAuctionId::DestroyActive() {
  switch (tag_) {

    case Tag::kMainAuction:
      std::destroy_at(&data_.main_auction);
      break;
    case Tag::kComponentAuction:
      std::destroy_at(&data_.component_auction);
      break;
  }
}
size_t AuctionAdConfigAuctionId::Hash(size_t seed) const {
  seed = mojo::internal::HashCombine(seed, static_cast<uint32_t>(tag_));
  switch (tag_) {

    case Tag::kMainAuction:
      return mojo::internal::WTFHash(seed, data_.main_auction);
    case Tag::kComponentAuction:
      return mojo::internal::WTFHash(seed, data_.component_auction);
    default:
      NOTREACHED();
  }
}

bool AuctionAdConfigAuctionId::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

AbortableAdAuction::IPCStableHashFunction AbortableAdAuction::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AbortableAdAuction>(message.name())) {
    case messages::AbortableAdAuction::kResolvedPromiseParam: {
      return &AbortableAdAuction::ResolvedPromiseParam_Sym::IPCStableHash;
    }
    case messages::AbortableAdAuction::kResolvedPerBuyerSignalsPromise: {
      return &AbortableAdAuction::ResolvedPerBuyerSignalsPromise_Sym::IPCStableHash;
    }
    case messages::AbortableAdAuction::kResolvedBuyerTkvSignalsPromise: {
      return &AbortableAdAuction::ResolvedBuyerTkvSignalsPromise_Sym::IPCStableHash;
    }
    case messages::AbortableAdAuction::kResolvedBuyerTimeoutsPromise: {
      return &AbortableAdAuction::ResolvedBuyerTimeoutsPromise_Sym::IPCStableHash;
    }
    case messages::AbortableAdAuction::kResolvedBuyerCurrenciesPromise: {
      return &AbortableAdAuction::ResolvedBuyerCurrenciesPromise_Sym::IPCStableHash;
    }
    case messages::AbortableAdAuction::kResolvedDirectFromSellerSignalsPromise: {
      return &AbortableAdAuction::ResolvedDirectFromSellerSignalsPromise_Sym::IPCStableHash;
    }
    case messages::AbortableAdAuction::kResolvedDirectFromSellerSignalsHeaderAdSlotPromise: {
      return &AbortableAdAuction::ResolvedDirectFromSellerSignalsHeaderAdSlotPromise_Sym::IPCStableHash;
    }
    case messages::AbortableAdAuction::kResolvedDeprecatedRenderURLReplacementsPromise: {
      return &AbortableAdAuction::ResolvedDeprecatedRenderURLReplacementsPromise_Sym::IPCStableHash;
    }
    case messages::AbortableAdAuction::kResolvedAuctionAdResponsePromise: {
      return &AbortableAdAuction::ResolvedAuctionAdResponsePromise_Sym::IPCStableHash;
    }
    case messages::AbortableAdAuction::kResolvedAdditionalBids: {
      return &AbortableAdAuction::ResolvedAdditionalBids_Sym::IPCStableHash;
    }
    case messages::AbortableAdAuction::kAbort: {
      return &AbortableAdAuction::Abort_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AbortableAdAuction::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AbortableAdAuction>(message.name())) {
      case messages::AbortableAdAuction::kResolvedPromiseParam:
            return "Receive blink::mojom::AbortableAdAuction::ResolvedPromiseParam";
      case messages::AbortableAdAuction::kResolvedPerBuyerSignalsPromise:
            return "Receive blink::mojom::AbortableAdAuction::ResolvedPerBuyerSignalsPromise";
      case messages::AbortableAdAuction::kResolvedBuyerTkvSignalsPromise:
            return "Receive blink::mojom::AbortableAdAuction::ResolvedBuyerTkvSignalsPromise";
      case messages::AbortableAdAuction::kResolvedBuyerTimeoutsPromise:
            return "Receive blink::mojom::AbortableAdAuction::ResolvedBuyerTimeoutsPromise";
      case messages::AbortableAdAuction::kResolvedBuyerCurrenciesPromise:
            return "Receive blink::mojom::AbortableAdAuction::ResolvedBuyerCurrenciesPromise";
      case messages::AbortableAdAuction::kResolvedDirectFromSellerSignalsPromise:
            return "Receive blink::mojom::AbortableAdAuction::ResolvedDirectFromSellerSignalsPromise";
      case messages::AbortableAdAuction::kResolvedDirectFromSellerSignalsHeaderAdSlotPromise:
            return "Receive blink::mojom::AbortableAdAuction::ResolvedDirectFromSellerSignalsHeaderAdSlotPromise";
      case messages::AbortableAdAuction::kResolvedDeprecatedRenderURLReplacementsPromise:
            return "Receive blink::mojom::AbortableAdAuction::ResolvedDeprecatedRenderURLReplacementsPromise";
      case messages::AbortableAdAuction::kResolvedAuctionAdResponsePromise:
            return "Receive blink::mojom::AbortableAdAuction::ResolvedAuctionAdResponsePromise";
      case messages::AbortableAdAuction::kResolvedAdditionalBids:
            return "Receive blink::mojom::AbortableAdAuction::ResolvedAdditionalBids";
      case messages::AbortableAdAuction::kAbort:
            return "Receive blink::mojom::AbortableAdAuction::Abort";
    }
  } else {
    switch (static_cast<messages::AbortableAdAuction>(message.name())) {
      case messages::AbortableAdAuction::kResolvedPromiseParam:
            return "Receive reply blink::mojom::AbortableAdAuction::ResolvedPromiseParam";
      case messages::AbortableAdAuction::kResolvedPerBuyerSignalsPromise:
            return "Receive reply blink::mojom::AbortableAdAuction::ResolvedPerBuyerSignalsPromise";
      case messages::AbortableAdAuction::kResolvedBuyerTkvSignalsPromise:
            return "Receive reply blink::mojom::AbortableAdAuction::ResolvedBuyerTkvSignalsPromise";
      case messages::AbortableAdAuction::kResolvedBuyerTimeoutsPromise:
            return "Receive reply blink::mojom::AbortableAdAuction::ResolvedBuyerTimeoutsPromise";
      case messages::AbortableAdAuction::kResolvedBuyerCurrenciesPromise:
            return "Receive reply blink::mojom::AbortableAdAuction::ResolvedBuyerCurrenciesPromise";
      case messages::AbortableAdAuction::kResolvedDirectFromSellerSignalsPromise:
            return "Receive reply blink::mojom::AbortableAdAuction::ResolvedDirectFromSellerSignalsPromise";
      case messages::AbortableAdAuction::kResolvedDirectFromSellerSignalsHeaderAdSlotPromise:
            return "Receive reply blink::mojom::AbortableAdAuction::ResolvedDirectFromSellerSignalsHeaderAdSlotPromise";
      case messages::AbortableAdAuction::kResolvedDeprecatedRenderURLReplacementsPromise:
            return "Receive reply blink::mojom::AbortableAdAuction::ResolvedDeprecatedRenderURLReplacementsPromise";
      case messages::AbortableAdAuction::kResolvedAuctionAdResponsePromise:
            return "Receive reply blink::mojom::AbortableAdAuction::ResolvedAuctionAdResponsePromise";
      case messages::AbortableAdAuction::kResolvedAdditionalBids:
            return "Receive reply blink::mojom::AbortableAdAuction::ResolvedAdditionalBids";
      case messages::AbortableAdAuction::kAbort:
            return "Receive reply blink::mojom::AbortableAdAuction::Abort";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AbortableAdAuction::ResolvedPromiseParam_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe0ef1208;  // IPCStableHash for blink::mojom::AbortableAdAuction::ResolvedPromiseParam
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AbortableAdAuction::ResolvedPerBuyerSignalsPromise_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd51eab08;  // IPCStableHash for blink::mojom::AbortableAdAuction::ResolvedPerBuyerSignalsPromise
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AbortableAdAuction::ResolvedBuyerTkvSignalsPromise_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x73b7ab9b;  // IPCStableHash for blink::mojom::AbortableAdAuction::ResolvedBuyerTkvSignalsPromise
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AbortableAdAuction::ResolvedBuyerTimeoutsPromise_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9b107670;  // IPCStableHash for blink::mojom::AbortableAdAuction::ResolvedBuyerTimeoutsPromise
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AbortableAdAuction::ResolvedBuyerCurrenciesPromise_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf705f1f4;  // IPCStableHash for blink::mojom::AbortableAdAuction::ResolvedBuyerCurrenciesPromise
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AbortableAdAuction::ResolvedDirectFromSellerSignalsPromise_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xaf0d2143;  // IPCStableHash for blink::mojom::AbortableAdAuction::ResolvedDirectFromSellerSignalsPromise
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AbortableAdAuction::ResolvedDirectFromSellerSignalsHeaderAdSlotPromise_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xce5bd3f5;  // IPCStableHash for blink::mojom::AbortableAdAuction::ResolvedDirectFromSellerSignalsHeaderAdSlotPromise
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AbortableAdAuction::ResolvedDeprecatedRenderURLReplacementsPromise_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe99c4458;  // IPCStableHash for blink::mojom::AbortableAdAuction::ResolvedDeprecatedRenderURLReplacementsPromise
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AbortableAdAuction::ResolvedAuctionAdResponsePromise_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x90232aad;  // IPCStableHash for blink::mojom::AbortableAdAuction::ResolvedAuctionAdResponsePromise
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AbortableAdAuction::ResolvedAdditionalBids_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0ac82765;  // IPCStableHash for blink::mojom::AbortableAdAuction::ResolvedAdditionalBids
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AbortableAdAuction::Abort_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1a12455a;  // IPCStableHash for blink::mojom::AbortableAdAuction::Abort
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AbortableAdAuctionProxy::AbortableAdAuctionProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AbortableAdAuctionProxy::ResolvedPromiseParam(
    AuctionAdConfigAuctionIdPtr in_auction, AuctionAdConfigField in_field, const ::blink::String& in_json_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AbortableAdAuction::ResolvedPromiseParam", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("auction"), in_auction,
                        "<value of type AuctionAdConfigAuctionIdPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("field"), in_field,
                        "<value of type AuctionAdConfigField>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("json_value"), in_json_value,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AbortableAdAuction::kResolvedPromiseParam), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AbortableAdAuction_ResolvedPromiseParam_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->auction)>
      auction_fragment(params.message());
  auction_fragment.Claim(&params->auction);
  
  mojo::internal::Serialize<::blink::mojom::AuctionAdConfigAuctionIdDataView>(
    in_auction,
    auction_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->auction.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null auction in AbortableAdAuction.ResolvedPromiseParam request");

  
  mojo::internal::Serialize<::blink::mojom::AuctionAdConfigField>(
    in_field,
    &params->field);
  mojo::internal::MessageFragment<
      typename decltype(params->json_value)::BaseType> json_value_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_json_value,
    json_value_fragment);

  params->json_value.Set(
      json_value_fragment.is_null() ? nullptr : json_value_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AbortableAdAuction::Name_);
  message.set_method_name("ResolvedPromiseParam");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AbortableAdAuctionProxy::ResolvedPerBuyerSignalsPromise(
    AuctionAdConfigAuctionIdPtr in_auction, const std::optional<::blink::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, ::blink::String>>& in_per_buyer_signals) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AbortableAdAuction::ResolvedPerBuyerSignalsPromise", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("auction"), in_auction,
                        "<value of type AuctionAdConfigAuctionIdPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("per_buyer_signals"), in_per_buyer_signals,
                        "<value of type const std::optional<::blink::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, ::blink::String>>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AbortableAdAuction::kResolvedPerBuyerSignalsPromise), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AbortableAdAuction_ResolvedPerBuyerSignalsPromise_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->auction)>
      auction_fragment(params.message());
  auction_fragment.Claim(&params->auction);
  
  mojo::internal::Serialize<::blink::mojom::AuctionAdConfigAuctionIdDataView>(
    in_auction,
    auction_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->auction.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null auction in AbortableAdAuction.ResolvedPerBuyerSignalsPromise request");
  mojo::internal::MessageFragment<
      typename decltype(params->per_buyer_signals)::BaseType>
      per_buyer_signals_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& per_buyer_signals_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<::url::mojom::OriginDataView, mojo::StringDataView>>(
    in_per_buyer_signals,
    per_buyer_signals_fragment,
    &per_buyer_signals_validate_params);

  params->per_buyer_signals.Set(
      per_buyer_signals_fragment.is_null() ? nullptr : per_buyer_signals_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AbortableAdAuction::Name_);
  message.set_method_name("ResolvedPerBuyerSignalsPromise");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AbortableAdAuctionProxy::ResolvedBuyerTkvSignalsPromise(
    AuctionAdConfigAuctionIdPtr in_auction, const ::scoped_refptr<const ::blink::SecurityOrigin>& in_buyer, const ::blink::String& in_json_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AbortableAdAuction::ResolvedBuyerTkvSignalsPromise", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("auction"), in_auction,
                        "<value of type AuctionAdConfigAuctionIdPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buyer"), in_buyer,
                        "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("json_value"), in_json_value,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AbortableAdAuction::kResolvedBuyerTkvSignalsPromise), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AbortableAdAuction_ResolvedBuyerTkvSignalsPromise_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->auction)>
      auction_fragment(params.message());
  auction_fragment.Claim(&params->auction);
  
  mojo::internal::Serialize<::blink::mojom::AuctionAdConfigAuctionIdDataView>(
    in_auction,
    auction_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->auction.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null auction in AbortableAdAuction.ResolvedBuyerTkvSignalsPromise request");
  mojo::internal::MessageFragment<
      typename decltype(params->buyer)::BaseType> buyer_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_buyer,
    buyer_fragment);

  params->buyer.Set(
      buyer_fragment.is_null() ? nullptr : buyer_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->buyer.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null buyer in AbortableAdAuction.ResolvedBuyerTkvSignalsPromise request");
  mojo::internal::MessageFragment<
      typename decltype(params->json_value)::BaseType> json_value_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_json_value,
    json_value_fragment);

  params->json_value.Set(
      json_value_fragment.is_null() ? nullptr : json_value_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AbortableAdAuction::Name_);
  message.set_method_name("ResolvedBuyerTkvSignalsPromise");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AbortableAdAuctionProxy::ResolvedBuyerTimeoutsPromise(
    AuctionAdConfigAuctionIdPtr in_auction, AuctionAdConfigBuyerTimeoutField in_field, ::blink::mojom::blink::AuctionAdConfigBuyerTimeoutsPtr in_buyer_timeouts) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AbortableAdAuction::ResolvedBuyerTimeoutsPromise", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("auction"), in_auction,
                        "<value of type AuctionAdConfigAuctionIdPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("field"), in_field,
                        "<value of type AuctionAdConfigBuyerTimeoutField>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buyer_timeouts"), in_buyer_timeouts,
                        "<value of type ::blink::mojom::blink::AuctionAdConfigBuyerTimeoutsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AbortableAdAuction::kResolvedBuyerTimeoutsPromise), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AbortableAdAuction_ResolvedBuyerTimeoutsPromise_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->auction)>
      auction_fragment(params.message());
  auction_fragment.Claim(&params->auction);
  
  mojo::internal::Serialize<::blink::mojom::AuctionAdConfigAuctionIdDataView>(
    in_auction,
    auction_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->auction.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null auction in AbortableAdAuction.ResolvedBuyerTimeoutsPromise request");

  
  mojo::internal::Serialize<::blink::mojom::AuctionAdConfigBuyerTimeoutField>(
    in_field,
    &params->field);
  mojo::internal::MessageFragment<
      typename decltype(params->buyer_timeouts)::BaseType> buyer_timeouts_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::AuctionAdConfigBuyerTimeoutsDataView>(
    in_buyer_timeouts,
    buyer_timeouts_fragment);

  params->buyer_timeouts.Set(
      buyer_timeouts_fragment.is_null() ? nullptr : buyer_timeouts_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->buyer_timeouts.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null buyer_timeouts in AbortableAdAuction.ResolvedBuyerTimeoutsPromise request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AbortableAdAuction::Name_);
  message.set_method_name("ResolvedBuyerTimeoutsPromise");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AbortableAdAuctionProxy::ResolvedBuyerCurrenciesPromise(
    AuctionAdConfigAuctionIdPtr in_auction, ::blink::mojom::blink::AuctionAdConfigBuyerCurrenciesPtr in_per_buyer_currencies) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AbortableAdAuction::ResolvedBuyerCurrenciesPromise", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("auction"), in_auction,
                        "<value of type AuctionAdConfigAuctionIdPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("per_buyer_currencies"), in_per_buyer_currencies,
                        "<value of type ::blink::mojom::blink::AuctionAdConfigBuyerCurrenciesPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AbortableAdAuction::kResolvedBuyerCurrenciesPromise), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AbortableAdAuction_ResolvedBuyerCurrenciesPromise_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->auction)>
      auction_fragment(params.message());
  auction_fragment.Claim(&params->auction);
  
  mojo::internal::Serialize<::blink::mojom::AuctionAdConfigAuctionIdDataView>(
    in_auction,
    auction_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->auction.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null auction in AbortableAdAuction.ResolvedBuyerCurrenciesPromise request");
  mojo::internal::MessageFragment<
      typename decltype(params->per_buyer_currencies)::BaseType> per_buyer_currencies_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::AuctionAdConfigBuyerCurrenciesDataView>(
    in_per_buyer_currencies,
    per_buyer_currencies_fragment);

  params->per_buyer_currencies.Set(
      per_buyer_currencies_fragment.is_null() ? nullptr : per_buyer_currencies_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->per_buyer_currencies.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null per_buyer_currencies in AbortableAdAuction.ResolvedBuyerCurrenciesPromise request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AbortableAdAuction::Name_);
  message.set_method_name("ResolvedBuyerCurrenciesPromise");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AbortableAdAuctionProxy::ResolvedDirectFromSellerSignalsPromise(
    AuctionAdConfigAuctionIdPtr in_auction, ::blink::mojom::blink::DirectFromSellerSignalsPtr in_direct_from_seller_signals) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AbortableAdAuction::ResolvedDirectFromSellerSignalsPromise", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("auction"), in_auction,
                        "<value of type AuctionAdConfigAuctionIdPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("direct_from_seller_signals"), in_direct_from_seller_signals,
                        "<value of type ::blink::mojom::blink::DirectFromSellerSignalsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AbortableAdAuction::kResolvedDirectFromSellerSignalsPromise), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AbortableAdAuction_ResolvedDirectFromSellerSignalsPromise_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->auction)>
      auction_fragment(params.message());
  auction_fragment.Claim(&params->auction);
  
  mojo::internal::Serialize<::blink::mojom::AuctionAdConfigAuctionIdDataView>(
    in_auction,
    auction_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->auction.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null auction in AbortableAdAuction.ResolvedDirectFromSellerSignalsPromise request");
  mojo::internal::MessageFragment<
      typename decltype(params->direct_from_seller_signals)::BaseType> direct_from_seller_signals_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::DirectFromSellerSignalsDataView>(
    in_direct_from_seller_signals,
    direct_from_seller_signals_fragment);

  params->direct_from_seller_signals.Set(
      direct_from_seller_signals_fragment.is_null() ? nullptr : direct_from_seller_signals_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AbortableAdAuction::Name_);
  message.set_method_name("ResolvedDirectFromSellerSignalsPromise");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AbortableAdAuctionProxy::ResolvedDirectFromSellerSignalsHeaderAdSlotPromise(
    AuctionAdConfigAuctionIdPtr in_auction, const ::blink::String& in_direct_from_seller_signals_header_ad_slot) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AbortableAdAuction::ResolvedDirectFromSellerSignalsHeaderAdSlotPromise", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("auction"), in_auction,
                        "<value of type AuctionAdConfigAuctionIdPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("direct_from_seller_signals_header_ad_slot"), in_direct_from_seller_signals_header_ad_slot,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AbortableAdAuction::kResolvedDirectFromSellerSignalsHeaderAdSlotPromise), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AbortableAdAuction_ResolvedDirectFromSellerSignalsHeaderAdSlotPromise_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->auction)>
      auction_fragment(params.message());
  auction_fragment.Claim(&params->auction);
  
  mojo::internal::Serialize<::blink::mojom::AuctionAdConfigAuctionIdDataView>(
    in_auction,
    auction_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->auction.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null auction in AbortableAdAuction.ResolvedDirectFromSellerSignalsHeaderAdSlotPromise request");
  mojo::internal::MessageFragment<
      typename decltype(params->direct_from_seller_signals_header_ad_slot)::BaseType> direct_from_seller_signals_header_ad_slot_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_direct_from_seller_signals_header_ad_slot,
    direct_from_seller_signals_header_ad_slot_fragment);

  params->direct_from_seller_signals_header_ad_slot.Set(
      direct_from_seller_signals_header_ad_slot_fragment.is_null() ? nullptr : direct_from_seller_signals_header_ad_slot_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AbortableAdAuction::Name_);
  message.set_method_name("ResolvedDirectFromSellerSignalsHeaderAdSlotPromise");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AbortableAdAuctionProxy::ResolvedDeprecatedRenderURLReplacementsPromise(
    AuctionAdConfigAuctionIdPtr in_auction, ::blink::Vector<::blink::mojom::blink::AdKeywordReplacementPtr> in_deprecated_render_url_replacements) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AbortableAdAuction::ResolvedDeprecatedRenderURLReplacementsPromise", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("auction"), in_auction,
                        "<value of type AuctionAdConfigAuctionIdPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("deprecated_render_url_replacements"), in_deprecated_render_url_replacements,
                        "<value of type ::blink::Vector<::blink::mojom::blink::AdKeywordReplacementPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AbortableAdAuction::kResolvedDeprecatedRenderURLReplacementsPromise), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AbortableAdAuction_ResolvedDeprecatedRenderURLReplacementsPromise_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->auction)>
      auction_fragment(params.message());
  auction_fragment.Claim(&params->auction);
  
  mojo::internal::Serialize<::blink::mojom::AuctionAdConfigAuctionIdDataView>(
    in_auction,
    auction_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->auction.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null auction in AbortableAdAuction.ResolvedDeprecatedRenderURLReplacementsPromise request");
  mojo::internal::MessageFragment<
      typename decltype(params->deprecated_render_url_replacements)::BaseType>
      deprecated_render_url_replacements_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& deprecated_render_url_replacements_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::AdKeywordReplacementDataView>>(
    in_deprecated_render_url_replacements,
    deprecated_render_url_replacements_fragment,
    &deprecated_render_url_replacements_validate_params);

  params->deprecated_render_url_replacements.Set(
      deprecated_render_url_replacements_fragment.is_null() ? nullptr : deprecated_render_url_replacements_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->deprecated_render_url_replacements.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null deprecated_render_url_replacements in AbortableAdAuction.ResolvedDeprecatedRenderURLReplacementsPromise request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AbortableAdAuction::Name_);
  message.set_method_name("ResolvedDeprecatedRenderURLReplacementsPromise");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AbortableAdAuctionProxy::ResolvedAuctionAdResponsePromise(
    AuctionAdConfigAuctionIdPtr in_auction, ::mojo_base::BigBuffer in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AbortableAdAuction::ResolvedAuctionAdResponsePromise", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("auction"), in_auction,
                        "<value of type AuctionAdConfigAuctionIdPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::mojo_base::BigBuffer>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AbortableAdAuction::kResolvedAuctionAdResponsePromise), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AbortableAdAuction_ResolvedAuctionAdResponsePromise_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->auction)>
      auction_fragment(params.message());
  auction_fragment.Claim(&params->auction);
  
  mojo::internal::Serialize<::blink::mojom::AuctionAdConfigAuctionIdDataView>(
    in_auction,
    auction_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->auction.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null auction in AbortableAdAuction.ResolvedAuctionAdResponsePromise request");
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in AbortableAdAuction.ResolvedAuctionAdResponsePromise request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AbortableAdAuction::Name_);
  message.set_method_name("ResolvedAuctionAdResponsePromise");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AbortableAdAuctionProxy::ResolvedAdditionalBids(
    AuctionAdConfigAuctionIdPtr in_auction) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AbortableAdAuction::ResolvedAdditionalBids", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("auction"), in_auction,
                        "<value of type AuctionAdConfigAuctionIdPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AbortableAdAuction::kResolvedAdditionalBids), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AbortableAdAuction_ResolvedAdditionalBids_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->auction)>
      auction_fragment(params.message());
  auction_fragment.Claim(&params->auction);
  
  mojo::internal::Serialize<::blink::mojom::AuctionAdConfigAuctionIdDataView>(
    in_auction,
    auction_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->auction.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null auction in AbortableAdAuction.ResolvedAdditionalBids request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AbortableAdAuction::Name_);
  message.set_method_name("ResolvedAdditionalBids");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AbortableAdAuctionProxy::Abort(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::AbortableAdAuction::Abort");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AbortableAdAuction::kAbort), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AbortableAdAuction_Abort_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AbortableAdAuction::Name_);
  message.set_method_name("Abort");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AbortableAdAuctionStubDispatch::Accept(
    AbortableAdAuction* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AbortableAdAuction>(message->header()->name)) {
    case messages::AbortableAdAuction::kResolvedPromiseParam: {
      DCHECK(message->is_serialized());
      internal::AbortableAdAuction_ResolvedPromiseParam_Params_Data* params =
          reinterpret_cast<internal::AbortableAdAuction_ResolvedPromiseParam_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AbortableAdAuction.0
      bool success = true;
      AuctionAdConfigAuctionIdPtr p_auction{};
      AuctionAdConfigField p_field{};
      ::blink::String p_json_value{};
      AbortableAdAuction_ResolvedPromiseParam_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAuction(&p_auction))
        success = false;
      if (success && !input_data_view.ReadField(&p_field))
        success = false;
      if (success && !input_data_view.ReadJsonValue(&p_json_value))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AbortableAdAuction::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResolvedPromiseParam(        
        std::move(p_auction), 
        std::move(p_field), 
        std::move(p_json_value));
      return true;
    }
    case messages::AbortableAdAuction::kResolvedPerBuyerSignalsPromise: {
      DCHECK(message->is_serialized());
      internal::AbortableAdAuction_ResolvedPerBuyerSignalsPromise_Params_Data* params =
          reinterpret_cast<internal::AbortableAdAuction_ResolvedPerBuyerSignalsPromise_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AbortableAdAuction.1
      bool success = true;
      AuctionAdConfigAuctionIdPtr p_auction{};
      std::optional<::blink::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, ::blink::String>> p_per_buyer_signals{};
      AbortableAdAuction_ResolvedPerBuyerSignalsPromise_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAuction(&p_auction))
        success = false;
      if (success && !input_data_view.ReadPerBuyerSignals(&p_per_buyer_signals))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AbortableAdAuction::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResolvedPerBuyerSignalsPromise(        
        std::move(p_auction), 
        std::move(p_per_buyer_signals));
      return true;
    }
    case messages::AbortableAdAuction::kResolvedBuyerTkvSignalsPromise: {
      DCHECK(message->is_serialized());
      internal::AbortableAdAuction_ResolvedBuyerTkvSignalsPromise_Params_Data* params =
          reinterpret_cast<internal::AbortableAdAuction_ResolvedBuyerTkvSignalsPromise_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AbortableAdAuction.2
      bool success = true;
      AuctionAdConfigAuctionIdPtr p_auction{};
      ::scoped_refptr<const ::blink::SecurityOrigin> p_buyer{};
      ::blink::String p_json_value{};
      AbortableAdAuction_ResolvedBuyerTkvSignalsPromise_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAuction(&p_auction))
        success = false;
      if (success && !input_data_view.ReadBuyer(&p_buyer))
        success = false;
      if (success && !input_data_view.ReadJsonValue(&p_json_value))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AbortableAdAuction::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResolvedBuyerTkvSignalsPromise(        
        std::move(p_auction), 
        std::move(p_buyer), 
        std::move(p_json_value));
      return true;
    }
    case messages::AbortableAdAuction::kResolvedBuyerTimeoutsPromise: {
      DCHECK(message->is_serialized());
      internal::AbortableAdAuction_ResolvedBuyerTimeoutsPromise_Params_Data* params =
          reinterpret_cast<internal::AbortableAdAuction_ResolvedBuyerTimeoutsPromise_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AbortableAdAuction.3
      bool success = true;
      AuctionAdConfigAuctionIdPtr p_auction{};
      AuctionAdConfigBuyerTimeoutField p_field{};
      ::blink::mojom::blink::AuctionAdConfigBuyerTimeoutsPtr p_buyer_timeouts{};
      AbortableAdAuction_ResolvedBuyerTimeoutsPromise_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAuction(&p_auction))
        success = false;
      if (success && !input_data_view.ReadField(&p_field))
        success = false;
      if (success && !input_data_view.ReadBuyerTimeouts(&p_buyer_timeouts))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AbortableAdAuction::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResolvedBuyerTimeoutsPromise(        
        std::move(p_auction), 
        std::move(p_field), 
        std::move(p_buyer_timeouts));
      return true;
    }
    case messages::AbortableAdAuction::kResolvedBuyerCurrenciesPromise: {
      DCHECK(message->is_serialized());
      internal::AbortableAdAuction_ResolvedBuyerCurrenciesPromise_Params_Data* params =
          reinterpret_cast<internal::AbortableAdAuction_ResolvedBuyerCurrenciesPromise_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AbortableAdAuction.4
      bool success = true;
      AuctionAdConfigAuctionIdPtr p_auction{};
      ::blink::mojom::blink::AuctionAdConfigBuyerCurrenciesPtr p_per_buyer_currencies{};
      AbortableAdAuction_ResolvedBuyerCurrenciesPromise_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAuction(&p_auction))
        success = false;
      if (success && !input_data_view.ReadPerBuyerCurrencies(&p_per_buyer_currencies))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AbortableAdAuction::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResolvedBuyerCurrenciesPromise(        
        std::move(p_auction), 
        std::move(p_per_buyer_currencies));
      return true;
    }
    case messages::AbortableAdAuction::kResolvedDirectFromSellerSignalsPromise: {
      DCHECK(message->is_serialized());
      internal::AbortableAdAuction_ResolvedDirectFromSellerSignalsPromise_Params_Data* params =
          reinterpret_cast<internal::AbortableAdAuction_ResolvedDirectFromSellerSignalsPromise_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AbortableAdAuction.5
      bool success = true;
      AuctionAdConfigAuctionIdPtr p_auction{};
      ::blink::mojom::blink::DirectFromSellerSignalsPtr p_direct_from_seller_signals{};
      AbortableAdAuction_ResolvedDirectFromSellerSignalsPromise_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAuction(&p_auction))
        success = false;
      if (success && !input_data_view.ReadDirectFromSellerSignals(&p_direct_from_seller_signals))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AbortableAdAuction::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResolvedDirectFromSellerSignalsPromise(        
        std::move(p_auction), 
        std::move(p_direct_from_seller_signals));
      return true;
    }
    case messages::AbortableAdAuction::kResolvedDirectFromSellerSignalsHeaderAdSlotPromise: {
      DCHECK(message->is_serialized());
      internal::AbortableAdAuction_ResolvedDirectFromSellerSignalsHeaderAdSlotPromise_Params_Data* params =
          reinterpret_cast<internal::AbortableAdAuction_ResolvedDirectFromSellerSignalsHeaderAdSlotPromise_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AbortableAdAuction.6
      bool success = true;
      AuctionAdConfigAuctionIdPtr p_auction{};
      ::blink::String p_direct_from_seller_signals_header_ad_slot{};
      AbortableAdAuction_ResolvedDirectFromSellerSignalsHeaderAdSlotPromise_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAuction(&p_auction))
        success = false;
      if (success && !input_data_view.ReadDirectFromSellerSignalsHeaderAdSlot(&p_direct_from_seller_signals_header_ad_slot))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AbortableAdAuction::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResolvedDirectFromSellerSignalsHeaderAdSlotPromise(        
        std::move(p_auction), 
        std::move(p_direct_from_seller_signals_header_ad_slot));
      return true;
    }
    case messages::AbortableAdAuction::kResolvedDeprecatedRenderURLReplacementsPromise: {
      DCHECK(message->is_serialized());
      internal::AbortableAdAuction_ResolvedDeprecatedRenderURLReplacementsPromise_Params_Data* params =
          reinterpret_cast<internal::AbortableAdAuction_ResolvedDeprecatedRenderURLReplacementsPromise_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AbortableAdAuction.7
      bool success = true;
      AuctionAdConfigAuctionIdPtr p_auction{};
      ::blink::Vector<::blink::mojom::blink::AdKeywordReplacementPtr> p_deprecated_render_url_replacements{};
      AbortableAdAuction_ResolvedDeprecatedRenderURLReplacementsPromise_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAuction(&p_auction))
        success = false;
      if (success && !input_data_view.ReadDeprecatedRenderUrlReplacements(&p_deprecated_render_url_replacements))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AbortableAdAuction::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResolvedDeprecatedRenderURLReplacementsPromise(        
        std::move(p_auction), 
        std::move(p_deprecated_render_url_replacements));
      return true;
    }
    case messages::AbortableAdAuction::kResolvedAuctionAdResponsePromise: {
      DCHECK(message->is_serialized());
      internal::AbortableAdAuction_ResolvedAuctionAdResponsePromise_Params_Data* params =
          reinterpret_cast<internal::AbortableAdAuction_ResolvedAuctionAdResponsePromise_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AbortableAdAuction.8
      bool success = true;
      AuctionAdConfigAuctionIdPtr p_auction{};
      ::mojo_base::BigBuffer p_result{};
      AbortableAdAuction_ResolvedAuctionAdResponsePromise_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAuction(&p_auction))
        success = false;
      if (success && !input_data_view.ReadResult(&p_result))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AbortableAdAuction::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResolvedAuctionAdResponsePromise(        
        std::move(p_auction), 
        std::move(p_result));
      return true;
    }
    case messages::AbortableAdAuction::kResolvedAdditionalBids: {
      DCHECK(message->is_serialized());
      internal::AbortableAdAuction_ResolvedAdditionalBids_Params_Data* params =
          reinterpret_cast<internal::AbortableAdAuction_ResolvedAdditionalBids_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AbortableAdAuction.9
      bool success = true;
      AuctionAdConfigAuctionIdPtr p_auction{};
      AbortableAdAuction_ResolvedAdditionalBids_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAuction(&p_auction))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AbortableAdAuction::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResolvedAdditionalBids(        
        std::move(p_auction));
      return true;
    }
    case messages::AbortableAdAuction::kAbort: {
      DCHECK(message->is_serialized());
      internal::AbortableAdAuction_Abort_Params_Data* params =
          reinterpret_cast<internal::AbortableAdAuction_Abort_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AbortableAdAuction.10
      bool success = true;
      AbortableAdAuction_Abort_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AbortableAdAuction::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Abort(        );
      return true;
    }
  }
  return false;
}

// static
bool AbortableAdAuctionStubDispatch::AcceptWithResponder(
    AbortableAdAuction* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AbortableAdAuction>(message->header()->name)) {
    case messages::AbortableAdAuction::kResolvedPromiseParam: {
      break;
    }
    case messages::AbortableAdAuction::kResolvedPerBuyerSignalsPromise: {
      break;
    }
    case messages::AbortableAdAuction::kResolvedBuyerTkvSignalsPromise: {
      break;
    }
    case messages::AbortableAdAuction::kResolvedBuyerTimeoutsPromise: {
      break;
    }
    case messages::AbortableAdAuction::kResolvedBuyerCurrenciesPromise: {
      break;
    }
    case messages::AbortableAdAuction::kResolvedDirectFromSellerSignalsPromise: {
      break;
    }
    case messages::AbortableAdAuction::kResolvedDirectFromSellerSignalsHeaderAdSlotPromise: {
      break;
    }
    case messages::AbortableAdAuction::kResolvedDeprecatedRenderURLReplacementsPromise: {
      break;
    }
    case messages::AbortableAdAuction::kResolvedAuctionAdResponsePromise: {
      break;
    }
    case messages::AbortableAdAuction::kResolvedAdditionalBids: {
      break;
    }
    case messages::AbortableAdAuction::kAbort: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAbortableAdAuctionValidationInfo[] = {
    { &internal::AbortableAdAuction_ResolvedPromiseParam_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AbortableAdAuction_ResolvedPerBuyerSignalsPromise_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AbortableAdAuction_ResolvedBuyerTkvSignalsPromise_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AbortableAdAuction_ResolvedBuyerTimeoutsPromise_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AbortableAdAuction_ResolvedBuyerCurrenciesPromise_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AbortableAdAuction_ResolvedDirectFromSellerSignalsPromise_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AbortableAdAuction_ResolvedDirectFromSellerSignalsHeaderAdSlotPromise_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AbortableAdAuction_ResolvedDeprecatedRenderURLReplacementsPromise_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AbortableAdAuction_ResolvedAuctionAdResponsePromise_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AbortableAdAuction_ResolvedAdditionalBids_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AbortableAdAuction_Abort_Params_Data::Validate,
     nullptr /* no response */},
};

bool AbortableAdAuctionRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::AbortableAdAuction::Name_,
    kAbortableAdAuctionValidationInfo);
}

// The declaration includes the definition on other builds.

AdAuctionService::IPCStableHashFunction AdAuctionService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AdAuctionService>(message.name())) {
    case messages::AdAuctionService::kCreateAdRequest: {
      return &AdAuctionService::CreateAdRequest_Sym::IPCStableHash;
    }
    case messages::AdAuctionService::kFinalizeAd: {
      return &AdAuctionService::FinalizeAd_Sym::IPCStableHash;
    }
    case messages::AdAuctionService::kRunAdAuction: {
      return &AdAuctionService::RunAdAuction_Sym::IPCStableHash;
    }
    case messages::AdAuctionService::kJoinInterestGroup: {
      return &AdAuctionService::JoinInterestGroup_Sym::IPCStableHash;
    }
    case messages::AdAuctionService::kLeaveInterestGroup: {
      return &AdAuctionService::LeaveInterestGroup_Sym::IPCStableHash;
    }
    case messages::AdAuctionService::kLeaveInterestGroupForDocument: {
      return &AdAuctionService::LeaveInterestGroupForDocument_Sym::IPCStableHash;
    }
    case messages::AdAuctionService::kClearOriginJoinedInterestGroups: {
      return &AdAuctionService::ClearOriginJoinedInterestGroups_Sym::IPCStableHash;
    }
    case messages::AdAuctionService::kUpdateAdInterestGroups: {
      return &AdAuctionService::UpdateAdInterestGroups_Sym::IPCStableHash;
    }
    case messages::AdAuctionService::kDeprecatedGetURLFromURN: {
      return &AdAuctionService::DeprecatedGetURLFromURN_Sym::IPCStableHash;
    }
    case messages::AdAuctionService::kDeprecatedReplaceInURN: {
      return &AdAuctionService::DeprecatedReplaceInURN_Sym::IPCStableHash;
    }
    case messages::AdAuctionService::kGetInterestGroupAdAuctionData: {
      return &AdAuctionService::GetInterestGroupAdAuctionData_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AdAuctionService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AdAuctionService>(message.name())) {
      case messages::AdAuctionService::kCreateAdRequest:
            return "Receive blink::mojom::AdAuctionService::CreateAdRequest";
      case messages::AdAuctionService::kFinalizeAd:
            return "Receive blink::mojom::AdAuctionService::FinalizeAd";
      case messages::AdAuctionService::kRunAdAuction:
            return "Receive blink::mojom::AdAuctionService::RunAdAuction";
      case messages::AdAuctionService::kJoinInterestGroup:
            return "Receive blink::mojom::AdAuctionService::JoinInterestGroup";
      case messages::AdAuctionService::kLeaveInterestGroup:
            return "Receive blink::mojom::AdAuctionService::LeaveInterestGroup";
      case messages::AdAuctionService::kLeaveInterestGroupForDocument:
            return "Receive blink::mojom::AdAuctionService::LeaveInterestGroupForDocument";
      case messages::AdAuctionService::kClearOriginJoinedInterestGroups:
            return "Receive blink::mojom::AdAuctionService::ClearOriginJoinedInterestGroups";
      case messages::AdAuctionService::kUpdateAdInterestGroups:
            return "Receive blink::mojom::AdAuctionService::UpdateAdInterestGroups";
      case messages::AdAuctionService::kDeprecatedGetURLFromURN:
            return "Receive blink::mojom::AdAuctionService::DeprecatedGetURLFromURN";
      case messages::AdAuctionService::kDeprecatedReplaceInURN:
            return "Receive blink::mojom::AdAuctionService::DeprecatedReplaceInURN";
      case messages::AdAuctionService::kGetInterestGroupAdAuctionData:
            return "Receive blink::mojom::AdAuctionService::GetInterestGroupAdAuctionData";
    }
  } else {
    switch (static_cast<messages::AdAuctionService>(message.name())) {
      case messages::AdAuctionService::kCreateAdRequest:
            return "Receive reply blink::mojom::AdAuctionService::CreateAdRequest";
      case messages::AdAuctionService::kFinalizeAd:
            return "Receive reply blink::mojom::AdAuctionService::FinalizeAd";
      case messages::AdAuctionService::kRunAdAuction:
            return "Receive reply blink::mojom::AdAuctionService::RunAdAuction";
      case messages::AdAuctionService::kJoinInterestGroup:
            return "Receive reply blink::mojom::AdAuctionService::JoinInterestGroup";
      case messages::AdAuctionService::kLeaveInterestGroup:
            return "Receive reply blink::mojom::AdAuctionService::LeaveInterestGroup";
      case messages::AdAuctionService::kLeaveInterestGroupForDocument:
            return "Receive reply blink::mojom::AdAuctionService::LeaveInterestGroupForDocument";
      case messages::AdAuctionService::kClearOriginJoinedInterestGroups:
            return "Receive reply blink::mojom::AdAuctionService::ClearOriginJoinedInterestGroups";
      case messages::AdAuctionService::kUpdateAdInterestGroups:
            return "Receive reply blink::mojom::AdAuctionService::UpdateAdInterestGroups";
      case messages::AdAuctionService::kDeprecatedGetURLFromURN:
            return "Receive reply blink::mojom::AdAuctionService::DeprecatedGetURLFromURN";
      case messages::AdAuctionService::kDeprecatedReplaceInURN:
            return "Receive reply blink::mojom::AdAuctionService::DeprecatedReplaceInURN";
      case messages::AdAuctionService::kGetInterestGroupAdAuctionData:
            return "Receive reply blink::mojom::AdAuctionService::GetInterestGroupAdAuctionData";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AdAuctionService::CreateAdRequest_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc438c058;  // IPCStableHash for blink::mojom::AdAuctionService::CreateAdRequest
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AdAuctionService::FinalizeAd_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x16cb740d;  // IPCStableHash for blink::mojom::AdAuctionService::FinalizeAd
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AdAuctionService::RunAdAuction_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2056425a;  // IPCStableHash for blink::mojom::AdAuctionService::RunAdAuction
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AdAuctionService::JoinInterestGroup_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd5e6c2bf;  // IPCStableHash for blink::mojom::AdAuctionService::JoinInterestGroup
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AdAuctionService::LeaveInterestGroup_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x592eba82;  // IPCStableHash for blink::mojom::AdAuctionService::LeaveInterestGroup
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AdAuctionService::LeaveInterestGroupForDocument_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd81a214f;  // IPCStableHash for blink::mojom::AdAuctionService::LeaveInterestGroupForDocument
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AdAuctionService::ClearOriginJoinedInterestGroups_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1480b3b2;  // IPCStableHash for blink::mojom::AdAuctionService::ClearOriginJoinedInterestGroups
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AdAuctionService::UpdateAdInterestGroups_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0b926686;  // IPCStableHash for blink::mojom::AdAuctionService::UpdateAdInterestGroups
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AdAuctionService::DeprecatedGetURLFromURN_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x29361e0a;  // IPCStableHash for blink::mojom::AdAuctionService::DeprecatedGetURLFromURN
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AdAuctionService::DeprecatedReplaceInURN_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x04f36a9a;  // IPCStableHash for blink::mojom::AdAuctionService::DeprecatedReplaceInURN
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AdAuctionService::GetInterestGroupAdAuctionData_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc5c93cea;  // IPCStableHash for blink::mojom::AdAuctionService::GetInterestGroupAdAuctionData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class AdAuctionService_CreateAdRequest_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AdAuctionService_CreateAdRequest_ForwardToCallback(
      AdAuctionService::CreateAdRequestCallback callback
      ) : callback_(std::move(callback)) {
  }

  AdAuctionService_CreateAdRequest_ForwardToCallback(const AdAuctionService_CreateAdRequest_ForwardToCallback&) = delete;
  AdAuctionService_CreateAdRequest_ForwardToCallback& operator=(const AdAuctionService_CreateAdRequest_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AdAuctionService::CreateAdRequestCallback callback_;
};

class AdAuctionService_FinalizeAd_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AdAuctionService_FinalizeAd_ForwardToCallback(
      AdAuctionService::FinalizeAdCallback callback
      ) : callback_(std::move(callback)) {
  }

  AdAuctionService_FinalizeAd_ForwardToCallback(const AdAuctionService_FinalizeAd_ForwardToCallback&) = delete;
  AdAuctionService_FinalizeAd_ForwardToCallback& operator=(const AdAuctionService_FinalizeAd_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AdAuctionService::FinalizeAdCallback callback_;
};

class AdAuctionService_RunAdAuction_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AdAuctionService_RunAdAuction_ForwardToCallback(
      AdAuctionService::RunAdAuctionCallback callback
      ) : callback_(std::move(callback)) {
  }

  AdAuctionService_RunAdAuction_ForwardToCallback(const AdAuctionService_RunAdAuction_ForwardToCallback&) = delete;
  AdAuctionService_RunAdAuction_ForwardToCallback& operator=(const AdAuctionService_RunAdAuction_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AdAuctionService::RunAdAuctionCallback callback_;
};

class AdAuctionService_JoinInterestGroup_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AdAuctionService_JoinInterestGroup_ForwardToCallback(
      AdAuctionService::JoinInterestGroupCallback callback
      ) : callback_(std::move(callback)) {
  }

  AdAuctionService_JoinInterestGroup_ForwardToCallback(const AdAuctionService_JoinInterestGroup_ForwardToCallback&) = delete;
  AdAuctionService_JoinInterestGroup_ForwardToCallback& operator=(const AdAuctionService_JoinInterestGroup_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AdAuctionService::JoinInterestGroupCallback callback_;
};

class AdAuctionService_LeaveInterestGroup_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AdAuctionService_LeaveInterestGroup_ForwardToCallback(
      AdAuctionService::LeaveInterestGroupCallback callback
      ) : callback_(std::move(callback)) {
  }

  AdAuctionService_LeaveInterestGroup_ForwardToCallback(const AdAuctionService_LeaveInterestGroup_ForwardToCallback&) = delete;
  AdAuctionService_LeaveInterestGroup_ForwardToCallback& operator=(const AdAuctionService_LeaveInterestGroup_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AdAuctionService::LeaveInterestGroupCallback callback_;
};

class AdAuctionService_ClearOriginJoinedInterestGroups_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AdAuctionService_ClearOriginJoinedInterestGroups_ForwardToCallback(
      AdAuctionService::ClearOriginJoinedInterestGroupsCallback callback
      ) : callback_(std::move(callback)) {
  }

  AdAuctionService_ClearOriginJoinedInterestGroups_ForwardToCallback(const AdAuctionService_ClearOriginJoinedInterestGroups_ForwardToCallback&) = delete;
  AdAuctionService_ClearOriginJoinedInterestGroups_ForwardToCallback& operator=(const AdAuctionService_ClearOriginJoinedInterestGroups_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AdAuctionService::ClearOriginJoinedInterestGroupsCallback callback_;
};

class AdAuctionService_DeprecatedGetURLFromURN_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AdAuctionService_DeprecatedGetURLFromURN_ForwardToCallback(
      AdAuctionService::DeprecatedGetURLFromURNCallback callback
      ) : callback_(std::move(callback)) {
  }

  AdAuctionService_DeprecatedGetURLFromURN_ForwardToCallback(const AdAuctionService_DeprecatedGetURLFromURN_ForwardToCallback&) = delete;
  AdAuctionService_DeprecatedGetURLFromURN_ForwardToCallback& operator=(const AdAuctionService_DeprecatedGetURLFromURN_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AdAuctionService::DeprecatedGetURLFromURNCallback callback_;
};

class AdAuctionService_DeprecatedReplaceInURN_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AdAuctionService_DeprecatedReplaceInURN_ForwardToCallback(
      AdAuctionService::DeprecatedReplaceInURNCallback callback
      ) : callback_(std::move(callback)) {
  }

  AdAuctionService_DeprecatedReplaceInURN_ForwardToCallback(const AdAuctionService_DeprecatedReplaceInURN_ForwardToCallback&) = delete;
  AdAuctionService_DeprecatedReplaceInURN_ForwardToCallback& operator=(const AdAuctionService_DeprecatedReplaceInURN_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AdAuctionService::DeprecatedReplaceInURNCallback callback_;
};

class AdAuctionService_GetInterestGroupAdAuctionData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AdAuctionService_GetInterestGroupAdAuctionData_ForwardToCallback(
      AdAuctionService::GetInterestGroupAdAuctionDataCallback callback
      ) : callback_(std::move(callback)) {
  }

  AdAuctionService_GetInterestGroupAdAuctionData_ForwardToCallback(const AdAuctionService_GetInterestGroupAdAuctionData_ForwardToCallback&) = delete;
  AdAuctionService_GetInterestGroupAdAuctionData_ForwardToCallback& operator=(const AdAuctionService_GetInterestGroupAdAuctionData_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AdAuctionService::GetInterestGroupAdAuctionDataCallback callback_;
};

AdAuctionServiceProxy::AdAuctionServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AdAuctionServiceProxy::CreateAdRequest(
    ::blink::mojom::blink::AdRequestConfigPtr in_config, CreateAdRequestCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AdAuctionService::CreateAdRequest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config"), in_config,
                        "<value of type ::blink::mojom::blink::AdRequestConfigPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AdAuctionService::kCreateAdRequest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AdAuctionService_CreateAdRequest_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->config)::BaseType> config_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::AdRequestConfigDataView>(
    in_config,
    config_fragment);

  params->config.Set(
      config_fragment.is_null() ? nullptr : config_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->config.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null config in AdAuctionService.CreateAdRequest request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AdAuctionService::Name_);
  message.set_method_name("CreateAdRequest");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AdAuctionService_CreateAdRequest_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AdAuctionServiceProxy::FinalizeAd(
    const ::blink::String& in_ads_guid, ::blink::mojom::blink::AuctionAdConfigPtr in_config, FinalizeAdCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AdAuctionService::FinalizeAd", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ads_guid"), in_ads_guid,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config"), in_config,
                        "<value of type ::blink::mojom::blink::AuctionAdConfigPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AdAuctionService::kFinalizeAd), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AdAuctionService_FinalizeAd_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->ads_guid)::BaseType> ads_guid_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_ads_guid,
    ads_guid_fragment);

  params->ads_guid.Set(
      ads_guid_fragment.is_null() ? nullptr : ads_guid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->ads_guid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null ads_guid in AdAuctionService.FinalizeAd request");
  mojo::internal::MessageFragment<
      typename decltype(params->config)::BaseType> config_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::AuctionAdConfigDataView>(
    in_config,
    config_fragment);

  params->config.Set(
      config_fragment.is_null() ? nullptr : config_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->config.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null config in AdAuctionService.FinalizeAd request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AdAuctionService::Name_);
  message.set_method_name("FinalizeAd");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AdAuctionService_FinalizeAd_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AdAuctionServiceProxy::RunAdAuction(
    ::blink::mojom::blink::AuctionAdConfigPtr in_config, ::mojo::PendingReceiver<AbortableAdAuction> in_abort_receiver, RunAdAuctionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AdAuctionService::RunAdAuction", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config"), in_config,
                        "<value of type ::blink::mojom::blink::AuctionAdConfigPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("abort_receiver"), in_abort_receiver,
                        "<value of type ::mojo::PendingReceiver<AbortableAdAuction>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AdAuctionService::kRunAdAuction), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AdAuctionService_RunAdAuction_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->config)::BaseType> config_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::AuctionAdConfigDataView>(
    in_config,
    config_fragment);

  params->config.Set(
      config_fragment.is_null() ? nullptr : config_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->config.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null config in AdAuctionService.RunAdAuction request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::AbortableAdAuctionInterfaceBase>>(
    in_abort_receiver,
    &params->abort_receiver,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AdAuctionService::Name_);
  message.set_method_name("RunAdAuction");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AdAuctionService_RunAdAuction_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AdAuctionServiceProxy::JoinInterestGroup(
    ::blink::mojom::blink::InterestGroupPtr in_group, JoinInterestGroupCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AdAuctionService::JoinInterestGroup", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group"), in_group,
                        "<value of type ::blink::mojom::blink::InterestGroupPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AdAuctionService::kJoinInterestGroup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AdAuctionService_JoinInterestGroup_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->group)::BaseType> group_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::InterestGroupDataView>(
    in_group,
    group_fragment);

  params->group.Set(
      group_fragment.is_null() ? nullptr : group_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->group.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null group in AdAuctionService.JoinInterestGroup request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AdAuctionService::Name_);
  message.set_method_name("JoinInterestGroup");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AdAuctionService_JoinInterestGroup_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AdAuctionServiceProxy::LeaveInterestGroup(
    const ::scoped_refptr<const ::blink::SecurityOrigin>& in_owner, const ::blink::String& in_name, LeaveInterestGroupCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AdAuctionService::LeaveInterestGroup", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("owner"), in_owner,
                        "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AdAuctionService::kLeaveInterestGroup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AdAuctionService_LeaveInterestGroup_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->owner)::BaseType> owner_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_owner,
    owner_fragment);

  params->owner.Set(
      owner_fragment.is_null() ? nullptr : owner_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->owner.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null owner in AdAuctionService.LeaveInterestGroup request");
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null name in AdAuctionService.LeaveInterestGroup request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AdAuctionService::Name_);
  message.set_method_name("LeaveInterestGroup");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AdAuctionService_LeaveInterestGroup_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AdAuctionServiceProxy::LeaveInterestGroupForDocument(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::AdAuctionService::LeaveInterestGroupForDocument");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AdAuctionService::kLeaveInterestGroupForDocument), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AdAuctionService_LeaveInterestGroupForDocument_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AdAuctionService::Name_);
  message.set_method_name("LeaveInterestGroupForDocument");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AdAuctionServiceProxy::ClearOriginJoinedInterestGroups(
    const ::scoped_refptr<const ::blink::SecurityOrigin>& in_owner, const ::blink::Vector<::blink::String>& in_interest_groups_to_keep, ClearOriginJoinedInterestGroupsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AdAuctionService::ClearOriginJoinedInterestGroups", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("owner"), in_owner,
                        "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("interest_groups_to_keep"), in_interest_groups_to_keep,
                        "<value of type const ::blink::Vector<::blink::String>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AdAuctionService::kClearOriginJoinedInterestGroups), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AdAuctionService_ClearOriginJoinedInterestGroups_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->owner)::BaseType> owner_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_owner,
    owner_fragment);

  params->owner.Set(
      owner_fragment.is_null() ? nullptr : owner_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->owner.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null owner in AdAuctionService.ClearOriginJoinedInterestGroups request");
  mojo::internal::MessageFragment<
      typename decltype(params->interest_groups_to_keep)::BaseType>
      interest_groups_to_keep_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& interest_groups_to_keep_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_interest_groups_to_keep,
    interest_groups_to_keep_fragment,
    &interest_groups_to_keep_validate_params);

  params->interest_groups_to_keep.Set(
      interest_groups_to_keep_fragment.is_null() ? nullptr : interest_groups_to_keep_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->interest_groups_to_keep.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null interest_groups_to_keep in AdAuctionService.ClearOriginJoinedInterestGroups request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AdAuctionService::Name_);
  message.set_method_name("ClearOriginJoinedInterestGroups");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AdAuctionService_ClearOriginJoinedInterestGroups_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AdAuctionServiceProxy::UpdateAdInterestGroups(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::AdAuctionService::UpdateAdInterestGroups");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AdAuctionService::kUpdateAdInterestGroups), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AdAuctionService_UpdateAdInterestGroups_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AdAuctionService::Name_);
  message.set_method_name("UpdateAdInterestGroups");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AdAuctionServiceProxy::DeprecatedGetURLFromURN(
    const ::blink::KURL& in_uuid_url, bool in_send_reports, DeprecatedGetURLFromURNCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AdAuctionService::DeprecatedGetURLFromURN", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uuid_url"), in_uuid_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("send_reports"), in_send_reports,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AdAuctionService::kDeprecatedGetURLFromURN), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AdAuctionService_DeprecatedGetURLFromURN_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->uuid_url)::BaseType> uuid_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_uuid_url,
    uuid_url_fragment);

  params->uuid_url.Set(
      uuid_url_fragment.is_null() ? nullptr : uuid_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->uuid_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null uuid_url in AdAuctionService.DeprecatedGetURLFromURN request");

  params->send_reports = in_send_reports;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AdAuctionService::Name_);
  message.set_method_name("DeprecatedGetURLFromURN");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AdAuctionService_DeprecatedGetURLFromURN_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AdAuctionServiceProxy::DeprecatedReplaceInURN(
    const ::blink::KURL& in_uuid_url, ::blink::Vector<::blink::mojom::blink::AdKeywordReplacementPtr> in_replacements, DeprecatedReplaceInURNCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AdAuctionService::DeprecatedReplaceInURN", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uuid_url"), in_uuid_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("replacements"), in_replacements,
                        "<value of type ::blink::Vector<::blink::mojom::blink::AdKeywordReplacementPtr>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AdAuctionService::kDeprecatedReplaceInURN), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AdAuctionService_DeprecatedReplaceInURN_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->uuid_url)::BaseType> uuid_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_uuid_url,
    uuid_url_fragment);

  params->uuid_url.Set(
      uuid_url_fragment.is_null() ? nullptr : uuid_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->uuid_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null uuid_url in AdAuctionService.DeprecatedReplaceInURN request");
  mojo::internal::MessageFragment<
      typename decltype(params->replacements)::BaseType>
      replacements_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& replacements_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::AdKeywordReplacementDataView>>(
    in_replacements,
    replacements_fragment,
    &replacements_validate_params);

  params->replacements.Set(
      replacements_fragment.is_null() ? nullptr : replacements_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->replacements.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null replacements in AdAuctionService.DeprecatedReplaceInURN request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AdAuctionService::Name_);
  message.set_method_name("DeprecatedReplaceInURN");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AdAuctionService_DeprecatedReplaceInURN_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AdAuctionServiceProxy::GetInterestGroupAdAuctionData(
    const ::blink::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, ::scoped_refptr<const ::blink::SecurityOrigin>>& in_sellers, ::blink::mojom::blink::AuctionDataConfigPtr in_config, GetInterestGroupAdAuctionDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AdAuctionService::GetInterestGroupAdAuctionData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sellers"), in_sellers,
                        "<value of type const ::blink::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, ::scoped_refptr<const ::blink::SecurityOrigin>>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config"), in_config,
                        "<value of type ::blink::mojom::blink::AuctionDataConfigPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AdAuctionService::kGetInterestGroupAdAuctionData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AdAuctionService_GetInterestGroupAdAuctionData_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->sellers)::BaseType>
      sellers_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& sellers_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, true, nullptr>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<::url::mojom::OriginDataView, ::url::mojom::OriginDataView>>(
    in_sellers,
    sellers_fragment,
    &sellers_validate_params);

  params->sellers.Set(
      sellers_fragment.is_null() ? nullptr : sellers_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->sellers.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null sellers in AdAuctionService.GetInterestGroupAdAuctionData request");
  mojo::internal::MessageFragment<
      typename decltype(params->config)::BaseType> config_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::AuctionDataConfigDataView>(
    in_config,
    config_fragment);

  params->config.Set(
      config_fragment.is_null() ? nullptr : config_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->config.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null config in AdAuctionService.GetInterestGroupAdAuctionData request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AdAuctionService::Name_);
  message.set_method_name("GetInterestGroupAdAuctionData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AdAuctionService_GetInterestGroupAdAuctionData_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class AdAuctionService_CreateAdRequest_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AdAuctionService::CreateAdRequestCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AdAuctionService_CreateAdRequest_ProxyToResponder> proxy(
        new AdAuctionService_CreateAdRequest_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AdAuctionService_CreateAdRequest_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AdAuctionService_CreateAdRequest_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AdAuctionService_CreateAdRequest_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "AdAuctionService::CreateAdRequestCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::blink::String& in_ads_guid);
};

bool AdAuctionService_CreateAdRequest_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AdAuctionService_CreateAdRequest_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AdAuctionService_CreateAdRequest_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AdAuctionService.0
  bool success = true;
  ::blink::String p_ads_guid{};
  AdAuctionService_CreateAdRequest_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadAdsGuid(&p_ads_guid))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AdAuctionService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_ads_guid));
  }
  return true;
}

void AdAuctionService_CreateAdRequest_ProxyToResponder::Run(
    const ::blink::String& in_ads_guid) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::AdAuctionService::CreateAdRequest", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ads_guid"), in_ads_guid,
                        "<value of type const ::blink::String&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AdAuctionService::kCreateAdRequest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AdAuctionService_CreateAdRequest_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->ads_guid)::BaseType> ads_guid_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_ads_guid,
    ads_guid_fragment);

  params->ads_guid.Set(
      ads_guid_fragment.is_null() ? nullptr : ads_guid_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AdAuctionService::Name_);
  message.set_method_name("CreateAdRequest");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class AdAuctionService_FinalizeAd_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AdAuctionService::FinalizeAdCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AdAuctionService_FinalizeAd_ProxyToResponder> proxy(
        new AdAuctionService_FinalizeAd_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AdAuctionService_FinalizeAd_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AdAuctionService_FinalizeAd_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AdAuctionService_FinalizeAd_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "AdAuctionService::FinalizeAdCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<::blink::KURL>& in_ad_display_url);
};

bool AdAuctionService_FinalizeAd_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AdAuctionService_FinalizeAd_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AdAuctionService_FinalizeAd_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AdAuctionService.1
  bool success = true;
  std::optional<::blink::KURL> p_ad_display_url{};
  AdAuctionService_FinalizeAd_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadAdDisplayUrl(&p_ad_display_url))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AdAuctionService::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_ad_display_url));
  }
  return true;
}

void AdAuctionService_FinalizeAd_ProxyToResponder::Run(
    const std::optional<::blink::KURL>& in_ad_display_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::AdAuctionService::FinalizeAd", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ad_display_url"), in_ad_display_url,
                        "<value of type const std::optional<::blink::KURL>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AdAuctionService::kFinalizeAd), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AdAuctionService_FinalizeAd_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->ad_display_url)::BaseType> ad_display_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_ad_display_url,
    ad_display_url_fragment);

  params->ad_display_url.Set(
      ad_display_url_fragment.is_null() ? nullptr : ad_display_url_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AdAuctionService::Name_);
  message.set_method_name("FinalizeAd");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class AdAuctionService_RunAdAuction_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AdAuctionService::RunAdAuctionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AdAuctionService_RunAdAuction_ProxyToResponder> proxy(
        new AdAuctionService_RunAdAuction_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AdAuctionService_RunAdAuction_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AdAuctionService_RunAdAuction_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AdAuctionService_RunAdAuction_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "AdAuctionService::RunAdAuctionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_aborted_by_script, const std::optional<::blink::FencedFrame::RedactedFencedFrameConfig>& in_config);
};

bool AdAuctionService_RunAdAuction_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AdAuctionService_RunAdAuction_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AdAuctionService_RunAdAuction_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AdAuctionService.2
  bool success = true;
  bool p_aborted_by_script{};
  std::optional<::blink::FencedFrame::RedactedFencedFrameConfig> p_config{};
  AdAuctionService_RunAdAuction_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_aborted_by_script = input_data_view.aborted_by_script();
  if (success && !input_data_view.ReadConfig(&p_config))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AdAuctionService::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_aborted_by_script), 
std::move(p_config));
  }
  return true;
}

void AdAuctionService_RunAdAuction_ProxyToResponder::Run(
    bool in_aborted_by_script, const std::optional<::blink::FencedFrame::RedactedFencedFrameConfig>& in_config) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::AdAuctionService::RunAdAuction", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("aborted_by_script"), in_aborted_by_script,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config"), in_config,
                        "<value of type const std::optional<::blink::FencedFrame::RedactedFencedFrameConfig>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AdAuctionService::kRunAdAuction), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AdAuctionService_RunAdAuction_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->aborted_by_script = in_aborted_by_script;
  mojo::internal::MessageFragment<
      typename decltype(params->config)::BaseType> config_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FencedFrameConfigDataView>(
    in_config,
    config_fragment);

  params->config.Set(
      config_fragment.is_null() ? nullptr : config_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AdAuctionService::Name_);
  message.set_method_name("RunAdAuction");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class AdAuctionService_JoinInterestGroup_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AdAuctionService::JoinInterestGroupCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AdAuctionService_JoinInterestGroup_ProxyToResponder> proxy(
        new AdAuctionService_JoinInterestGroup_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AdAuctionService_JoinInterestGroup_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AdAuctionService_JoinInterestGroup_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AdAuctionService_JoinInterestGroup_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "AdAuctionService::JoinInterestGroupCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_failed_well_known_check);
};

bool AdAuctionService_JoinInterestGroup_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AdAuctionService_JoinInterestGroup_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AdAuctionService_JoinInterestGroup_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AdAuctionService.3
  bool success = true;
  bool p_failed_well_known_check{};
  AdAuctionService_JoinInterestGroup_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_failed_well_known_check = input_data_view.failed_well_known_check();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AdAuctionService::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_failed_well_known_check));
  }
  return true;
}

void AdAuctionService_JoinInterestGroup_ProxyToResponder::Run(
    bool in_failed_well_known_check) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::AdAuctionService::JoinInterestGroup", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("failed_well_known_check"), in_failed_well_known_check,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AdAuctionService::kJoinInterestGroup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AdAuctionService_JoinInterestGroup_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->failed_well_known_check = in_failed_well_known_check;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AdAuctionService::Name_);
  message.set_method_name("JoinInterestGroup");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class AdAuctionService_LeaveInterestGroup_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AdAuctionService::LeaveInterestGroupCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AdAuctionService_LeaveInterestGroup_ProxyToResponder> proxy(
        new AdAuctionService_LeaveInterestGroup_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AdAuctionService_LeaveInterestGroup_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AdAuctionService_LeaveInterestGroup_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AdAuctionService_LeaveInterestGroup_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "AdAuctionService::LeaveInterestGroupCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_failed_well_known_check);
};

bool AdAuctionService_LeaveInterestGroup_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AdAuctionService_LeaveInterestGroup_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AdAuctionService_LeaveInterestGroup_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AdAuctionService.4
  bool success = true;
  bool p_failed_well_known_check{};
  AdAuctionService_LeaveInterestGroup_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_failed_well_known_check = input_data_view.failed_well_known_check();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AdAuctionService::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_failed_well_known_check));
  }
  return true;
}

void AdAuctionService_LeaveInterestGroup_ProxyToResponder::Run(
    bool in_failed_well_known_check) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::AdAuctionService::LeaveInterestGroup", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("failed_well_known_check"), in_failed_well_known_check,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AdAuctionService::kLeaveInterestGroup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AdAuctionService_LeaveInterestGroup_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->failed_well_known_check = in_failed_well_known_check;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AdAuctionService::Name_);
  message.set_method_name("LeaveInterestGroup");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class AdAuctionService_ClearOriginJoinedInterestGroups_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AdAuctionService::ClearOriginJoinedInterestGroupsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AdAuctionService_ClearOriginJoinedInterestGroups_ProxyToResponder> proxy(
        new AdAuctionService_ClearOriginJoinedInterestGroups_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AdAuctionService_ClearOriginJoinedInterestGroups_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AdAuctionService_ClearOriginJoinedInterestGroups_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AdAuctionService_ClearOriginJoinedInterestGroups_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "AdAuctionService::ClearOriginJoinedInterestGroupsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_failed_well_known_check);
};

bool AdAuctionService_ClearOriginJoinedInterestGroups_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AdAuctionService_ClearOriginJoinedInterestGroups_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AdAuctionService_ClearOriginJoinedInterestGroups_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AdAuctionService.6
  bool success = true;
  bool p_failed_well_known_check{};
  AdAuctionService_ClearOriginJoinedInterestGroups_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_failed_well_known_check = input_data_view.failed_well_known_check();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AdAuctionService::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_failed_well_known_check));
  }
  return true;
}

void AdAuctionService_ClearOriginJoinedInterestGroups_ProxyToResponder::Run(
    bool in_failed_well_known_check) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::AdAuctionService::ClearOriginJoinedInterestGroups", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("failed_well_known_check"), in_failed_well_known_check,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AdAuctionService::kClearOriginJoinedInterestGroups), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AdAuctionService_ClearOriginJoinedInterestGroups_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->failed_well_known_check = in_failed_well_known_check;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AdAuctionService::Name_);
  message.set_method_name("ClearOriginJoinedInterestGroups");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class AdAuctionService_DeprecatedGetURLFromURN_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AdAuctionService::DeprecatedGetURLFromURNCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AdAuctionService_DeprecatedGetURLFromURN_ProxyToResponder> proxy(
        new AdAuctionService_DeprecatedGetURLFromURN_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AdAuctionService_DeprecatedGetURLFromURN_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AdAuctionService_DeprecatedGetURLFromURN_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AdAuctionService_DeprecatedGetURLFromURN_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "AdAuctionService::DeprecatedGetURLFromURNCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<::blink::KURL>& in_decoded_url);
};

bool AdAuctionService_DeprecatedGetURLFromURN_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AdAuctionService_DeprecatedGetURLFromURN_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AdAuctionService_DeprecatedGetURLFromURN_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AdAuctionService.8
  bool success = true;
  std::optional<::blink::KURL> p_decoded_url{};
  AdAuctionService_DeprecatedGetURLFromURN_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDecodedUrl(&p_decoded_url))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AdAuctionService::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_decoded_url));
  }
  return true;
}

void AdAuctionService_DeprecatedGetURLFromURN_ProxyToResponder::Run(
    const std::optional<::blink::KURL>& in_decoded_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::AdAuctionService::DeprecatedGetURLFromURN", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("decoded_url"), in_decoded_url,
                        "<value of type const std::optional<::blink::KURL>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AdAuctionService::kDeprecatedGetURLFromURN), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AdAuctionService_DeprecatedGetURLFromURN_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->decoded_url)::BaseType> decoded_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_decoded_url,
    decoded_url_fragment);

  params->decoded_url.Set(
      decoded_url_fragment.is_null() ? nullptr : decoded_url_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AdAuctionService::Name_);
  message.set_method_name("DeprecatedGetURLFromURN");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class AdAuctionService_DeprecatedReplaceInURN_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AdAuctionService::DeprecatedReplaceInURNCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AdAuctionService_DeprecatedReplaceInURN_ProxyToResponder> proxy(
        new AdAuctionService_DeprecatedReplaceInURN_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AdAuctionService_DeprecatedReplaceInURN_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AdAuctionService_DeprecatedReplaceInURN_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AdAuctionService_DeprecatedReplaceInURN_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "AdAuctionService::DeprecatedReplaceInURNCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool AdAuctionService_DeprecatedReplaceInURN_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AdAuctionService_DeprecatedReplaceInURN_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AdAuctionService_DeprecatedReplaceInURN_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AdAuctionService.9
  bool success = true;
  AdAuctionService_DeprecatedReplaceInURN_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AdAuctionService::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void AdAuctionService_DeprecatedReplaceInURN_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply blink::mojom::AdAuctionService::DeprecatedReplaceInURN");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AdAuctionService::kDeprecatedReplaceInURN), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AdAuctionService_DeprecatedReplaceInURN_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AdAuctionService::Name_);
  message.set_method_name("DeprecatedReplaceInURN");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class AdAuctionService_GetInterestGroupAdAuctionData_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AdAuctionService::GetInterestGroupAdAuctionDataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AdAuctionService_GetInterestGroupAdAuctionData_ProxyToResponder> proxy(
        new AdAuctionService_GetInterestGroupAdAuctionData_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AdAuctionService_GetInterestGroupAdAuctionData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AdAuctionService_GetInterestGroupAdAuctionData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AdAuctionService_GetInterestGroupAdAuctionData_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "AdAuctionService::GetInterestGroupAdAuctionDataCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::Vector<::blink::mojom::blink::AdAuctionPerSellerRequestPtr> in_requests, const std::optional<::base::Uuid>& in_request_id);
};

bool AdAuctionService_GetInterestGroupAdAuctionData_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AdAuctionService_GetInterestGroupAdAuctionData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AdAuctionService_GetInterestGroupAdAuctionData_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AdAuctionService.10
  bool success = true;
  ::blink::Vector<::blink::mojom::blink::AdAuctionPerSellerRequestPtr> p_requests{};
  std::optional<::base::Uuid> p_request_id{};
  AdAuctionService_GetInterestGroupAdAuctionData_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadRequests(&p_requests))
    success = false;
  if (success && !input_data_view.ReadRequestId(&p_request_id))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AdAuctionService::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_requests), 
std::move(p_request_id));
  }
  return true;
}

void AdAuctionService_GetInterestGroupAdAuctionData_ProxyToResponder::Run(
    ::blink::Vector<::blink::mojom::blink::AdAuctionPerSellerRequestPtr> in_requests, const std::optional<::base::Uuid>& in_request_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::AdAuctionService::GetInterestGroupAdAuctionData", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("requests"), in_requests,
                        "<value of type ::blink::Vector<::blink::mojom::blink::AdAuctionPerSellerRequestPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type const std::optional<::base::Uuid>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AdAuctionService::kGetInterestGroupAdAuctionData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AdAuctionService_GetInterestGroupAdAuctionData_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->requests)::BaseType>
      requests_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& requests_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::AdAuctionPerSellerRequestDataView>>(
    in_requests,
    requests_fragment,
    &requests_validate_params);

  params->requests.Set(
      requests_fragment.is_null() ? nullptr : requests_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->requests.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null requests in ");
  mojo::internal::MessageFragment<
      typename decltype(params->request_id)::BaseType> request_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UuidDataView>(
    in_request_id,
    request_id_fragment);

  params->request_id.Set(
      request_id_fragment.is_null() ? nullptr : request_id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AdAuctionService::Name_);
  message.set_method_name("GetInterestGroupAdAuctionData");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool AdAuctionServiceStubDispatch::Accept(
    AdAuctionService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AdAuctionService>(message->header()->name)) {
    case messages::AdAuctionService::kCreateAdRequest: {
      break;
    }
    case messages::AdAuctionService::kFinalizeAd: {
      break;
    }
    case messages::AdAuctionService::kRunAdAuction: {
      break;
    }
    case messages::AdAuctionService::kJoinInterestGroup: {
      break;
    }
    case messages::AdAuctionService::kLeaveInterestGroup: {
      break;
    }
    case messages::AdAuctionService::kLeaveInterestGroupForDocument: {
      DCHECK(message->is_serialized());
      internal::AdAuctionService_LeaveInterestGroupForDocument_Params_Data* params =
          reinterpret_cast<internal::AdAuctionService_LeaveInterestGroupForDocument_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AdAuctionService.5
      bool success = true;
      AdAuctionService_LeaveInterestGroupForDocument_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AdAuctionService::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LeaveInterestGroupForDocument(        );
      return true;
    }
    case messages::AdAuctionService::kClearOriginJoinedInterestGroups: {
      break;
    }
    case messages::AdAuctionService::kUpdateAdInterestGroups: {
      DCHECK(message->is_serialized());
      internal::AdAuctionService_UpdateAdInterestGroups_Params_Data* params =
          reinterpret_cast<internal::AdAuctionService_UpdateAdInterestGroups_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AdAuctionService.7
      bool success = true;
      AdAuctionService_UpdateAdInterestGroups_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AdAuctionService::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateAdInterestGroups(        );
      return true;
    }
    case messages::AdAuctionService::kDeprecatedGetURLFromURN: {
      break;
    }
    case messages::AdAuctionService::kDeprecatedReplaceInURN: {
      break;
    }
    case messages::AdAuctionService::kGetInterestGroupAdAuctionData: {
      break;
    }
  }
  return false;
}

// static
bool AdAuctionServiceStubDispatch::AcceptWithResponder(
    AdAuctionService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AdAuctionService>(message->header()->name)) {
    case messages::AdAuctionService::kCreateAdRequest: {
      internal::AdAuctionService_CreateAdRequest_Params_Data* params =
          reinterpret_cast<
              internal::AdAuctionService_CreateAdRequest_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AdAuctionService.0
      bool success = true;
      ::blink::mojom::blink::AdRequestConfigPtr p_config{};
      AdAuctionService_CreateAdRequest_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConfig(&p_config))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AdAuctionService::Name_, 0, false);
        return false;
      }
      auto callback =
          AdAuctionService_CreateAdRequest_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateAdRequest(        
        std::move(p_config), std::move(callback));
      return true;
    }
    case messages::AdAuctionService::kFinalizeAd: {
      internal::AdAuctionService_FinalizeAd_Params_Data* params =
          reinterpret_cast<
              internal::AdAuctionService_FinalizeAd_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AdAuctionService.1
      bool success = true;
      ::blink::String p_ads_guid{};
      ::blink::mojom::blink::AuctionAdConfigPtr p_config{};
      AdAuctionService_FinalizeAd_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAdsGuid(&p_ads_guid))
        success = false;
      if (success && !input_data_view.ReadConfig(&p_config))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AdAuctionService::Name_, 1, false);
        return false;
      }
      auto callback =
          AdAuctionService_FinalizeAd_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FinalizeAd(        
        std::move(p_ads_guid), 
        std::move(p_config), std::move(callback));
      return true;
    }
    case messages::AdAuctionService::kRunAdAuction: {
      internal::AdAuctionService_RunAdAuction_Params_Data* params =
          reinterpret_cast<
              internal::AdAuctionService_RunAdAuction_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AdAuctionService.2
      bool success = true;
      ::blink::mojom::blink::AuctionAdConfigPtr p_config{};
      ::mojo::PendingReceiver<AbortableAdAuction> p_abort_receiver{};
      AdAuctionService_RunAdAuction_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConfig(&p_config))
        success = false;
      if (success) {
        p_abort_receiver =
            input_data_view.TakeAbortReceiver<decltype(p_abort_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AdAuctionService::Name_, 2, false);
        return false;
      }
      auto callback =
          AdAuctionService_RunAdAuction_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RunAdAuction(        
        std::move(p_config), 
        std::move(p_abort_receiver), std::move(callback));
      return true;
    }
    case messages::AdAuctionService::kJoinInterestGroup: {
      internal::AdAuctionService_JoinInterestGroup_Params_Data* params =
          reinterpret_cast<
              internal::AdAuctionService_JoinInterestGroup_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AdAuctionService.3
      bool success = true;
      ::blink::mojom::blink::InterestGroupPtr p_group{};
      AdAuctionService_JoinInterestGroup_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGroup(&p_group))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AdAuctionService::Name_, 3, false);
        return false;
      }
      auto callback =
          AdAuctionService_JoinInterestGroup_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->JoinInterestGroup(        
        std::move(p_group), std::move(callback));
      return true;
    }
    case messages::AdAuctionService::kLeaveInterestGroup: {
      internal::AdAuctionService_LeaveInterestGroup_Params_Data* params =
          reinterpret_cast<
              internal::AdAuctionService_LeaveInterestGroup_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AdAuctionService.4
      bool success = true;
      ::scoped_refptr<const ::blink::SecurityOrigin> p_owner{};
      ::blink::String p_name{};
      AdAuctionService_LeaveInterestGroup_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOwner(&p_owner))
        success = false;
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AdAuctionService::Name_, 4, false);
        return false;
      }
      auto callback =
          AdAuctionService_LeaveInterestGroup_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LeaveInterestGroup(        
        std::move(p_owner), 
        std::move(p_name), std::move(callback));
      return true;
    }
    case messages::AdAuctionService::kLeaveInterestGroupForDocument: {
      break;
    }
    case messages::AdAuctionService::kClearOriginJoinedInterestGroups: {
      internal::AdAuctionService_ClearOriginJoinedInterestGroups_Params_Data* params =
          reinterpret_cast<
              internal::AdAuctionService_ClearOriginJoinedInterestGroups_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AdAuctionService.6
      bool success = true;
      ::scoped_refptr<const ::blink::SecurityOrigin> p_owner{};
      ::blink::Vector<::blink::String> p_interest_groups_to_keep{};
      AdAuctionService_ClearOriginJoinedInterestGroups_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOwner(&p_owner))
        success = false;
      if (success && !input_data_view.ReadInterestGroupsToKeep(&p_interest_groups_to_keep))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AdAuctionService::Name_, 6, false);
        return false;
      }
      auto callback =
          AdAuctionService_ClearOriginJoinedInterestGroups_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearOriginJoinedInterestGroups(        
        std::move(p_owner), 
        std::move(p_interest_groups_to_keep), std::move(callback));
      return true;
    }
    case messages::AdAuctionService::kUpdateAdInterestGroups: {
      break;
    }
    case messages::AdAuctionService::kDeprecatedGetURLFromURN: {
      internal::AdAuctionService_DeprecatedGetURLFromURN_Params_Data* params =
          reinterpret_cast<
              internal::AdAuctionService_DeprecatedGetURLFromURN_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AdAuctionService.8
      bool success = true;
      ::blink::KURL p_uuid_url{};
      bool p_send_reports{};
      AdAuctionService_DeprecatedGetURLFromURN_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUuidUrl(&p_uuid_url))
        success = false;
      if (success)
        p_send_reports = input_data_view.send_reports();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AdAuctionService::Name_, 8, false);
        return false;
      }
      auto callback =
          AdAuctionService_DeprecatedGetURLFromURN_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeprecatedGetURLFromURN(        
        std::move(p_uuid_url), 
        std::move(p_send_reports), std::move(callback));
      return true;
    }
    case messages::AdAuctionService::kDeprecatedReplaceInURN: {
      internal::AdAuctionService_DeprecatedReplaceInURN_Params_Data* params =
          reinterpret_cast<
              internal::AdAuctionService_DeprecatedReplaceInURN_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AdAuctionService.9
      bool success = true;
      ::blink::KURL p_uuid_url{};
      ::blink::Vector<::blink::mojom::blink::AdKeywordReplacementPtr> p_replacements{};
      AdAuctionService_DeprecatedReplaceInURN_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUuidUrl(&p_uuid_url))
        success = false;
      if (success && !input_data_view.ReadReplacements(&p_replacements))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AdAuctionService::Name_, 9, false);
        return false;
      }
      auto callback =
          AdAuctionService_DeprecatedReplaceInURN_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeprecatedReplaceInURN(        
        std::move(p_uuid_url), 
        std::move(p_replacements), std::move(callback));
      return true;
    }
    case messages::AdAuctionService::kGetInterestGroupAdAuctionData: {
      internal::AdAuctionService_GetInterestGroupAdAuctionData_Params_Data* params =
          reinterpret_cast<
              internal::AdAuctionService_GetInterestGroupAdAuctionData_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AdAuctionService.10
      bool success = true;
      ::blink::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, ::scoped_refptr<const ::blink::SecurityOrigin>> p_sellers{};
      ::blink::mojom::blink::AuctionDataConfigPtr p_config{};
      AdAuctionService_GetInterestGroupAdAuctionData_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSellers(&p_sellers))
        success = false;
      if (success && !input_data_view.ReadConfig(&p_config))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AdAuctionService::Name_, 10, false);
        return false;
      }
      auto callback =
          AdAuctionService_GetInterestGroupAdAuctionData_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetInterestGroupAdAuctionData(        
        std::move(p_sellers), 
        std::move(p_config), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAdAuctionServiceValidationInfo[] = {
    { &internal::AdAuctionService_CreateAdRequest_Params_Data::Validate,
     &internal::AdAuctionService_CreateAdRequest_ResponseParams_Data::Validate},
    { &internal::AdAuctionService_FinalizeAd_Params_Data::Validate,
     &internal::AdAuctionService_FinalizeAd_ResponseParams_Data::Validate},
    { &internal::AdAuctionService_RunAdAuction_Params_Data::Validate,
     &internal::AdAuctionService_RunAdAuction_ResponseParams_Data::Validate},
    { &internal::AdAuctionService_JoinInterestGroup_Params_Data::Validate,
     &internal::AdAuctionService_JoinInterestGroup_ResponseParams_Data::Validate},
    { &internal::AdAuctionService_LeaveInterestGroup_Params_Data::Validate,
     &internal::AdAuctionService_LeaveInterestGroup_ResponseParams_Data::Validate},
    { &internal::AdAuctionService_LeaveInterestGroupForDocument_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AdAuctionService_ClearOriginJoinedInterestGroups_Params_Data::Validate,
     &internal::AdAuctionService_ClearOriginJoinedInterestGroups_ResponseParams_Data::Validate},
    { &internal::AdAuctionService_UpdateAdInterestGroups_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AdAuctionService_DeprecatedGetURLFromURN_Params_Data::Validate,
     &internal::AdAuctionService_DeprecatedGetURLFromURN_ResponseParams_Data::Validate},
    { &internal::AdAuctionService_DeprecatedReplaceInURN_Params_Data::Validate,
     &internal::AdAuctionService_DeprecatedReplaceInURN_ResponseParams_Data::Validate},
    { &internal::AdAuctionService_GetInterestGroupAdAuctionData_Params_Data::Validate,
     &internal::AdAuctionService_GetInterestGroupAdAuctionData_ResponseParams_Data::Validate},
};

bool AdAuctionServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::AdAuctionService::Name_,
    kAdAuctionServiceValidationInfo);
}

bool AdAuctionServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::AdAuctionService::Name_,
    kAdAuctionServiceValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {

// static
bool UnionTraits<::blink::mojom::blink::AuctionAdConfigAuctionId::DataView, ::blink::mojom::blink::AuctionAdConfigAuctionIdPtr>::Read(
    ::blink::mojom::blink::AuctionAdConfigAuctionId::DataView input,
    ::blink::mojom::blink::AuctionAdConfigAuctionIdPtr* output) {
  using UnionType = ::blink::mojom::blink::AuctionAdConfigAuctionId;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kMainAuction: {
      *output = UnionType::NewMainAuction(input.main_auction());
      break;
    }
    case Tag::kComponentAuction: {
      *output = UnionType::NewComponentAuction(input.component_auction());
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void AbortableAdAuctionInterceptorForTesting::ResolvedPromiseParam(AuctionAdConfigAuctionIdPtr auction, AuctionAdConfigField field, const ::blink::String& json_value) {
  GetForwardingInterface()->ResolvedPromiseParam(
    std::move(auction)
    , 
    std::move(field)
    , 
    std::move(json_value)
    );
}
void AbortableAdAuctionInterceptorForTesting::ResolvedPerBuyerSignalsPromise(AuctionAdConfigAuctionIdPtr auction, const std::optional<::blink::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, ::blink::String>>& per_buyer_signals) {
  GetForwardingInterface()->ResolvedPerBuyerSignalsPromise(
    std::move(auction)
    , 
    std::move(per_buyer_signals)
    );
}
void AbortableAdAuctionInterceptorForTesting::ResolvedBuyerTkvSignalsPromise(AuctionAdConfigAuctionIdPtr auction, const ::scoped_refptr<const ::blink::SecurityOrigin>& buyer, const ::blink::String& json_value) {
  GetForwardingInterface()->ResolvedBuyerTkvSignalsPromise(
    std::move(auction)
    , 
    std::move(buyer)
    , 
    std::move(json_value)
    );
}
void AbortableAdAuctionInterceptorForTesting::ResolvedBuyerTimeoutsPromise(AuctionAdConfigAuctionIdPtr auction, AuctionAdConfigBuyerTimeoutField field, ::blink::mojom::blink::AuctionAdConfigBuyerTimeoutsPtr buyer_timeouts) {
  GetForwardingInterface()->ResolvedBuyerTimeoutsPromise(
    std::move(auction)
    , 
    std::move(field)
    , 
    std::move(buyer_timeouts)
    );
}
void AbortableAdAuctionInterceptorForTesting::ResolvedBuyerCurrenciesPromise(AuctionAdConfigAuctionIdPtr auction, ::blink::mojom::blink::AuctionAdConfigBuyerCurrenciesPtr per_buyer_currencies) {
  GetForwardingInterface()->ResolvedBuyerCurrenciesPromise(
    std::move(auction)
    , 
    std::move(per_buyer_currencies)
    );
}
void AbortableAdAuctionInterceptorForTesting::ResolvedDirectFromSellerSignalsPromise(AuctionAdConfigAuctionIdPtr auction, ::blink::mojom::blink::DirectFromSellerSignalsPtr direct_from_seller_signals) {
  GetForwardingInterface()->ResolvedDirectFromSellerSignalsPromise(
    std::move(auction)
    , 
    std::move(direct_from_seller_signals)
    );
}
void AbortableAdAuctionInterceptorForTesting::ResolvedDirectFromSellerSignalsHeaderAdSlotPromise(AuctionAdConfigAuctionIdPtr auction, const ::blink::String& direct_from_seller_signals_header_ad_slot) {
  GetForwardingInterface()->ResolvedDirectFromSellerSignalsHeaderAdSlotPromise(
    std::move(auction)
    , 
    std::move(direct_from_seller_signals_header_ad_slot)
    );
}
void AbortableAdAuctionInterceptorForTesting::ResolvedDeprecatedRenderURLReplacementsPromise(AuctionAdConfigAuctionIdPtr auction, ::blink::Vector<::blink::mojom::blink::AdKeywordReplacementPtr> deprecated_render_url_replacements) {
  GetForwardingInterface()->ResolvedDeprecatedRenderURLReplacementsPromise(
    std::move(auction)
    , 
    std::move(deprecated_render_url_replacements)
    );
}
void AbortableAdAuctionInterceptorForTesting::ResolvedAuctionAdResponsePromise(AuctionAdConfigAuctionIdPtr auction, ::mojo_base::BigBuffer result) {
  GetForwardingInterface()->ResolvedAuctionAdResponsePromise(
    std::move(auction)
    , 
    std::move(result)
    );
}
void AbortableAdAuctionInterceptorForTesting::ResolvedAdditionalBids(AuctionAdConfigAuctionIdPtr auction) {
  GetForwardingInterface()->ResolvedAdditionalBids(
    std::move(auction)
    );
}
void AbortableAdAuctionInterceptorForTesting::Abort() {
  GetForwardingInterface()->Abort();
}
AbortableAdAuctionAsyncWaiter::AbortableAdAuctionAsyncWaiter(
    AbortableAdAuction* proxy) : proxy_(proxy) {}

AbortableAdAuctionAsyncWaiter::~AbortableAdAuctionAsyncWaiter() = default;





void AdAuctionServiceInterceptorForTesting::CreateAdRequest(::blink::mojom::blink::AdRequestConfigPtr config, CreateAdRequestCallback callback) {
  GetForwardingInterface()->CreateAdRequest(
    std::move(config)
    , std::move(callback));
}
void AdAuctionServiceInterceptorForTesting::FinalizeAd(const ::blink::String& ads_guid, ::blink::mojom::blink::AuctionAdConfigPtr config, FinalizeAdCallback callback) {
  GetForwardingInterface()->FinalizeAd(
    std::move(ads_guid)
    , 
    std::move(config)
    , std::move(callback));
}
void AdAuctionServiceInterceptorForTesting::RunAdAuction(::blink::mojom::blink::AuctionAdConfigPtr config, ::mojo::PendingReceiver<AbortableAdAuction> abort_receiver, RunAdAuctionCallback callback) {
  GetForwardingInterface()->RunAdAuction(
    std::move(config)
    , 
    std::move(abort_receiver)
    , std::move(callback));
}
void AdAuctionServiceInterceptorForTesting::JoinInterestGroup(::blink::mojom::blink::InterestGroupPtr group, JoinInterestGroupCallback callback) {
  GetForwardingInterface()->JoinInterestGroup(
    std::move(group)
    , std::move(callback));
}
void AdAuctionServiceInterceptorForTesting::LeaveInterestGroup(const ::scoped_refptr<const ::blink::SecurityOrigin>& owner, const ::blink::String& name, LeaveInterestGroupCallback callback) {
  GetForwardingInterface()->LeaveInterestGroup(
    std::move(owner)
    , 
    std::move(name)
    , std::move(callback));
}
void AdAuctionServiceInterceptorForTesting::LeaveInterestGroupForDocument() {
  GetForwardingInterface()->LeaveInterestGroupForDocument();
}
void AdAuctionServiceInterceptorForTesting::ClearOriginJoinedInterestGroups(const ::scoped_refptr<const ::blink::SecurityOrigin>& owner, const ::blink::Vector<::blink::String>& interest_groups_to_keep, ClearOriginJoinedInterestGroupsCallback callback) {
  GetForwardingInterface()->ClearOriginJoinedInterestGroups(
    std::move(owner)
    , 
    std::move(interest_groups_to_keep)
    , std::move(callback));
}
void AdAuctionServiceInterceptorForTesting::UpdateAdInterestGroups() {
  GetForwardingInterface()->UpdateAdInterestGroups();
}
void AdAuctionServiceInterceptorForTesting::DeprecatedGetURLFromURN(const ::blink::KURL& uuid_url, bool send_reports, DeprecatedGetURLFromURNCallback callback) {
  GetForwardingInterface()->DeprecatedGetURLFromURN(
    std::move(uuid_url)
    , 
    std::move(send_reports)
    , std::move(callback));
}
void AdAuctionServiceInterceptorForTesting::DeprecatedReplaceInURN(const ::blink::KURL& uuid_url, ::blink::Vector<::blink::mojom::blink::AdKeywordReplacementPtr> replacements, DeprecatedReplaceInURNCallback callback) {
  GetForwardingInterface()->DeprecatedReplaceInURN(
    std::move(uuid_url)
    , 
    std::move(replacements)
    , std::move(callback));
}
void AdAuctionServiceInterceptorForTesting::GetInterestGroupAdAuctionData(const ::blink::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, ::scoped_refptr<const ::blink::SecurityOrigin>>& sellers, ::blink::mojom::blink::AuctionDataConfigPtr config, GetInterestGroupAdAuctionDataCallback callback) {
  GetForwardingInterface()->GetInterestGroupAdAuctionData(
    std::move(sellers)
    , 
    std::move(config)
    , std::move(callback));
}
AdAuctionServiceAsyncWaiter::AdAuctionServiceAsyncWaiter(
    AdAuctionService* proxy) : proxy_(proxy) {}

AdAuctionServiceAsyncWaiter::~AdAuctionServiceAsyncWaiter() = default;


void AdAuctionServiceAsyncWaiter::CreateAdRequest(
    ::blink::mojom::blink::AdRequestConfigPtr config, ::blink::String* out_ads_guid) {
  base::RunLoop loop;
  proxy_->CreateAdRequest(
      std::move(config),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::String* out_ads_guid
,
             const ::blink::String& ads_guid) {*out_ads_guid = std::move(ads_guid);
            loop->Quit();
          },
          &loop,
          out_ads_guid));
  loop.Run();
}

::blink::String AdAuctionServiceAsyncWaiter::CreateAdRequest(
    ::blink::mojom::blink::AdRequestConfigPtr config) {
  ::blink::String async_wait_result;
  CreateAdRequest(std::move(config),&async_wait_result);
  return async_wait_result;
}

void AdAuctionServiceAsyncWaiter::FinalizeAd(
    const ::blink::String& ads_guid, ::blink::mojom::blink::AuctionAdConfigPtr config, std::optional<::blink::KURL>* out_ad_display_url) {
  base::RunLoop loop;
  proxy_->FinalizeAd(
      std::move(ads_guid),
      std::move(config),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::blink::KURL>* out_ad_display_url
,
             const std::optional<::blink::KURL>& ad_display_url) {*out_ad_display_url = std::move(ad_display_url);
            loop->Quit();
          },
          &loop,
          out_ad_display_url));
  loop.Run();
}

std::optional<::blink::KURL> AdAuctionServiceAsyncWaiter::FinalizeAd(
    const ::blink::String& ads_guid, ::blink::mojom::blink::AuctionAdConfigPtr config) {
  std::optional<::blink::KURL> async_wait_result;
  FinalizeAd(std::move(ads_guid),std::move(config),&async_wait_result);
  return async_wait_result;
}

void AdAuctionServiceAsyncWaiter::RunAdAuction(
    ::blink::mojom::blink::AuctionAdConfigPtr config, ::mojo::PendingReceiver<AbortableAdAuction> abort_receiver, bool* out_aborted_by_script, std::optional<::blink::FencedFrame::RedactedFencedFrameConfig>* out_config) {
  base::RunLoop loop;
  proxy_->RunAdAuction(
      std::move(config),
      std::move(abort_receiver),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_aborted_by_script
,
             std::optional<::blink::FencedFrame::RedactedFencedFrameConfig>* out_config
,
             bool aborted_by_script,
             const std::optional<::blink::FencedFrame::RedactedFencedFrameConfig>& config) {*out_aborted_by_script = std::move(aborted_by_script);*out_config = std::move(config);
            loop->Quit();
          },
          &loop,
          out_aborted_by_script,
          out_config));
  loop.Run();
}



void AdAuctionServiceAsyncWaiter::JoinInterestGroup(
    ::blink::mojom::blink::InterestGroupPtr group, bool* out_failed_well_known_check) {
  base::RunLoop loop;
  proxy_->JoinInterestGroup(
      std::move(group),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_failed_well_known_check
,
             bool failed_well_known_check) {*out_failed_well_known_check = std::move(failed_well_known_check);
            loop->Quit();
          },
          &loop,
          out_failed_well_known_check));
  loop.Run();
}

bool AdAuctionServiceAsyncWaiter::JoinInterestGroup(
    ::blink::mojom::blink::InterestGroupPtr group) {
  bool async_wait_result;
  JoinInterestGroup(std::move(group),&async_wait_result);
  return async_wait_result;
}

void AdAuctionServiceAsyncWaiter::LeaveInterestGroup(
    const ::scoped_refptr<const ::blink::SecurityOrigin>& owner, const ::blink::String& name, bool* out_failed_well_known_check) {
  base::RunLoop loop;
  proxy_->LeaveInterestGroup(
      std::move(owner),
      std::move(name),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_failed_well_known_check
,
             bool failed_well_known_check) {*out_failed_well_known_check = std::move(failed_well_known_check);
            loop->Quit();
          },
          &loop,
          out_failed_well_known_check));
  loop.Run();
}

bool AdAuctionServiceAsyncWaiter::LeaveInterestGroup(
    const ::scoped_refptr<const ::blink::SecurityOrigin>& owner, const ::blink::String& name) {
  bool async_wait_result;
  LeaveInterestGroup(std::move(owner),std::move(name),&async_wait_result);
  return async_wait_result;
}

void AdAuctionServiceAsyncWaiter::ClearOriginJoinedInterestGroups(
    const ::scoped_refptr<const ::blink::SecurityOrigin>& owner, const ::blink::Vector<::blink::String>& interest_groups_to_keep, bool* out_failed_well_known_check) {
  base::RunLoop loop;
  proxy_->ClearOriginJoinedInterestGroups(
      std::move(owner),
      std::move(interest_groups_to_keep),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_failed_well_known_check
,
             bool failed_well_known_check) {*out_failed_well_known_check = std::move(failed_well_known_check);
            loop->Quit();
          },
          &loop,
          out_failed_well_known_check));
  loop.Run();
}

bool AdAuctionServiceAsyncWaiter::ClearOriginJoinedInterestGroups(
    const ::scoped_refptr<const ::blink::SecurityOrigin>& owner, const ::blink::Vector<::blink::String>& interest_groups_to_keep) {
  bool async_wait_result;
  ClearOriginJoinedInterestGroups(std::move(owner),std::move(interest_groups_to_keep),&async_wait_result);
  return async_wait_result;
}

void AdAuctionServiceAsyncWaiter::DeprecatedGetURLFromURN(
    const ::blink::KURL& uuid_url, bool send_reports, std::optional<::blink::KURL>* out_decoded_url) {
  base::RunLoop loop;
  proxy_->DeprecatedGetURLFromURN(
      std::move(uuid_url),
      std::move(send_reports),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::blink::KURL>* out_decoded_url
,
             const std::optional<::blink::KURL>& decoded_url) {*out_decoded_url = std::move(decoded_url);
            loop->Quit();
          },
          &loop,
          out_decoded_url));
  loop.Run();
}

std::optional<::blink::KURL> AdAuctionServiceAsyncWaiter::DeprecatedGetURLFromURN(
    const ::blink::KURL& uuid_url, bool send_reports) {
  std::optional<::blink::KURL> async_wait_result;
  DeprecatedGetURLFromURN(std::move(uuid_url),std::move(send_reports),&async_wait_result);
  return async_wait_result;
}

void AdAuctionServiceAsyncWaiter::DeprecatedReplaceInURN(
    const ::blink::KURL& uuid_url, ::blink::Vector<::blink::mojom::blink::AdKeywordReplacementPtr> replacements) {
  base::RunLoop loop;
  proxy_->DeprecatedReplaceInURN(
      std::move(uuid_url),
      std::move(replacements),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void AdAuctionServiceAsyncWaiter::GetInterestGroupAdAuctionData(
    const ::blink::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, ::scoped_refptr<const ::blink::SecurityOrigin>>& sellers, ::blink::mojom::blink::AuctionDataConfigPtr config, ::blink::Vector<::blink::mojom::blink::AdAuctionPerSellerRequestPtr>* out_requests, std::optional<::base::Uuid>* out_request_id) {
  base::RunLoop loop;
  proxy_->GetInterestGroupAdAuctionData(
      std::move(sellers),
      std::move(config),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::Vector<::blink::mojom::blink::AdAuctionPerSellerRequestPtr>* out_requests
,
             std::optional<::base::Uuid>* out_request_id
,
             ::blink::Vector<::blink::mojom::blink::AdAuctionPerSellerRequestPtr> requests,
             const std::optional<::base::Uuid>& request_id) {*out_requests = std::move(requests);*out_request_id = std::move(request_id);
            loop->Quit();
          },
          &loop,
          out_requests,
          out_request_id));
  loop.Run();
}








}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif