// third_party/blink/public/mojom/input/stylus_writing_gesture.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/input/stylus_writing_gesture.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var string16$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/string16.mojom', '../../../../../mojo/public/mojom/base/string16.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }


  var StylusWritingGestureAction = {};
  StylusWritingGestureAction.DELETE_TEXT = 0;
  StylusWritingGestureAction.ADD_SPACE_OR_TEXT = 1;
  StylusWritingGestureAction.REMOVE_SPACES = 2;
  StylusWritingGestureAction.SPLIT_OR_MERGE = 3;
  StylusWritingGestureAction.SELECT_TEXT = 4;
  StylusWritingGestureAction.MIN_VALUE = 0;
  StylusWritingGestureAction.MAX_VALUE = 4;

  StylusWritingGestureAction.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
      return true;
    }
    return false;
  };

  StylusWritingGestureAction.toKnownEnumValue = function(value) {
    return value;
  };

  StylusWritingGestureAction.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var StylusWritingGestureGranularity = {};
  StylusWritingGestureGranularity.CHARACTER = 0;
  StylusWritingGestureGranularity.WORD = 1;
  StylusWritingGestureGranularity.MIN_VALUE = 0;
  StylusWritingGestureGranularity.MAX_VALUE = 1;

  StylusWritingGestureGranularity.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  StylusWritingGestureGranularity.toKnownEnumValue = function(value) {
    return value;
  };

  StylusWritingGestureGranularity.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function StylusWritingGestureData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  StylusWritingGestureData.prototype.initDefaults_ = function() {
    this.action = 0;
    this.granularity = 0;
    this.startRect = null;
    this.endRect = null;
    this.textAlternative = null;
    this.textToInsert = null;
  };
  StylusWritingGestureData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  StylusWritingGestureData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StylusWritingGestureData.action
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, StylusWritingGestureAction);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StylusWritingGestureData.granularity
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, StylusWritingGestureGranularity);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StylusWritingGestureData.startRect
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StylusWritingGestureData.endRect
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, geometry$.Rect, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StylusWritingGestureData.textAlternative
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StylusWritingGestureData.textToInsert
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, string16$.String16, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  StylusWritingGestureData.encodedSize = codec.kStructHeaderSize + 40;

  StylusWritingGestureData.decode = function(decoder) {
    var packed;
    var val = new StylusWritingGestureData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.action =
        decoder.decodeStruct(new codec.Enum(StylusWritingGestureAction));
    val.granularity =
        decoder.decodeStruct(new codec.Enum(StylusWritingGestureGranularity));
    val.startRect =
        decoder.decodeStructPointer(geometry$.Rect);
    val.endRect =
        decoder.decodeStructPointer(geometry$.Rect);
    val.textAlternative =
        decoder.decodeStructPointer(string16$.String16);
    val.textToInsert =
        decoder.decodeStructPointer(string16$.String16);
    return val;
  };

  StylusWritingGestureData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(StylusWritingGestureData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.action);
    encoder.encodeStruct(codec.Int32, val.granularity);
    encoder.encodeStructPointer(geometry$.Rect, val.startRect);
    encoder.encodeStructPointer(geometry$.Rect, val.endRect);
    encoder.encodeStructPointer(string16$.String16, val.textAlternative);
    encoder.encodeStructPointer(string16$.String16, val.textToInsert);
  };
  exports.StylusWritingGestureAction = StylusWritingGestureAction;
  exports.StylusWritingGestureGranularity = StylusWritingGestureGranularity;
  exports.StylusWritingGestureData = StylusWritingGestureData;
})();