// third_party/blink/public/mojom/input/stylus_writing_gesture.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_STYLUS_WRITING_GESTURE_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_STYLUS_WRITING_GESTURE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/input/stylus_writing_gesture.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/input/stylus_writing_gesture.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/input/stylus_writing_gesture.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom-blink.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {








class PLATFORM_EXPORT StylusWritingGestureData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<StylusWritingGestureData, T>::value>;
  using DataView = StylusWritingGestureDataDataView;
  using Data_ = internal::StylusWritingGestureData_Data;

  template <typename... Args>
  static StylusWritingGestureDataPtr New(Args&&... args) {
    return StylusWritingGestureDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static StylusWritingGestureDataPtr From(const U& u) {
    return mojo::TypeConverter<StylusWritingGestureDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, StylusWritingGestureData>::Convert(*this);
  }


  StylusWritingGestureData();

  StylusWritingGestureData(
      StylusWritingGestureAction action,
      StylusWritingGestureGranularity granularity,
      const ::gfx::Rect& start_rect,
      const std::optional<::gfx::Rect>& end_rect,
      const ::blink::String& text_alternative,
      const ::blink::String& text_to_insert);


  ~StylusWritingGestureData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = StylusWritingGestureDataPtr>
  StylusWritingGestureDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, StylusWritingGestureData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, StylusWritingGestureData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, StylusWritingGestureData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StylusWritingGestureData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StylusWritingGestureData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        StylusWritingGestureData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::StylusWritingGestureData_UnserializedMessageContext<
            UserType, StylusWritingGestureData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<StylusWritingGestureData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return StylusWritingGestureData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::StylusWritingGestureData_UnserializedMessageContext<
            UserType, StylusWritingGestureData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<StylusWritingGestureData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  StylusWritingGestureAction action;
  
  StylusWritingGestureGranularity granularity;
  
  ::gfx::Rect start_rect;
  
  std::optional<::gfx::Rect> end_rect;
  
  ::blink::String text_alternative;
  
  ::blink::String text_to_insert;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, StylusWritingGestureData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, StylusWritingGestureData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, StylusWritingGestureData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, StylusWritingGestureData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
StylusWritingGestureDataPtr StylusWritingGestureData::Clone() const {
  return New(
      mojo::Clone(action),
      mojo::Clone(granularity),
      mojo::Clone(start_rect),
      mojo::Clone(end_rect),
      mojo::Clone(text_alternative),
      mojo::Clone(text_to_insert)
  );
}

template <typename T, StylusWritingGestureData::EnableIfSame<T>*>
bool StylusWritingGestureData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->action, other_struct.action))
    return false;
  if (!mojo::Equals(this->granularity, other_struct.granularity))
    return false;
  if (!mojo::Equals(this->start_rect, other_struct.start_rect))
    return false;
  if (!mojo::Equals(this->end_rect, other_struct.end_rect))
    return false;
  if (!mojo::Equals(this->text_alternative, other_struct.text_alternative))
    return false;
  if (!mojo::Equals(this->text_to_insert, other_struct.text_to_insert))
    return false;
  return true;
}

template <typename T, StylusWritingGestureData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.action < rhs.action)
    return true;
  if (rhs.action < lhs.action)
    return false;
  if (lhs.granularity < rhs.granularity)
    return true;
  if (rhs.granularity < lhs.granularity)
    return false;
  if (lhs.start_rect < rhs.start_rect)
    return true;
  if (rhs.start_rect < lhs.start_rect)
    return false;
  if (lhs.end_rect < rhs.end_rect)
    return true;
  if (rhs.end_rect < lhs.end_rect)
    return false;
  if (lhs.text_alternative < rhs.text_alternative)
    return true;
  if (rhs.text_alternative < lhs.text_alternative)
    return false;
  if (lhs.text_to_insert < rhs.text_to_insert)
    return true;
  if (rhs.text_to_insert < lhs.text_to_insert)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::StylusWritingGestureData::DataView,
                                         ::blink::mojom::blink::StylusWritingGestureDataPtr> {
  static bool IsNull(const ::blink::mojom::blink::StylusWritingGestureDataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::StylusWritingGestureDataPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::StylusWritingGestureData::action) action(
      const ::blink::mojom::blink::StylusWritingGestureDataPtr& input) {
    return input->action;
  }

  static decltype(::blink::mojom::blink::StylusWritingGestureData::granularity) granularity(
      const ::blink::mojom::blink::StylusWritingGestureDataPtr& input) {
    return input->granularity;
  }

  static const decltype(::blink::mojom::blink::StylusWritingGestureData::start_rect)& start_rect(
      const ::blink::mojom::blink::StylusWritingGestureDataPtr& input) {
    return input->start_rect;
  }

  static const decltype(::blink::mojom::blink::StylusWritingGestureData::end_rect)& end_rect(
      const ::blink::mojom::blink::StylusWritingGestureDataPtr& input) {
    return input->end_rect;
  }

  static const decltype(::blink::mojom::blink::StylusWritingGestureData::text_alternative)& text_alternative(
      const ::blink::mojom::blink::StylusWritingGestureDataPtr& input) {
    return input->text_alternative;
  }

  static const decltype(::blink::mojom::blink::StylusWritingGestureData::text_to_insert)& text_to_insert(
      const ::blink::mojom::blink::StylusWritingGestureDataPtr& input) {
    return input->text_to_insert;
  }

  static bool Read(::blink::mojom::blink::StylusWritingGestureData::DataView input, ::blink::mojom::blink::StylusWritingGestureDataPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_STYLUS_WRITING_GESTURE_MOJOM_BLINK_H_