// third_party/blink/public/mojom/input/ime_host.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/input/ime_host.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var skcolor$ =
      mojo.internal.exposeNamespace('skia.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'skia/public/mojom/skcolor.mojom', '../../../../../skia/public/mojom/skcolor.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }



  function EditorBoundsInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EditorBoundsInfo.prototype.initDefaults_ = function() {
    this.editorBounds = null;
    this.handwritingBounds = null;
  };
  EditorBoundsInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EditorBoundsInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EditorBoundsInfo.editorBounds
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.RectF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EditorBoundsInfo.handwritingBounds
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.RectF, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EditorBoundsInfo.encodedSize = codec.kStructHeaderSize + 16;

  EditorBoundsInfo.decode = function(decoder) {
    var packed;
    var val = new EditorBoundsInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.editorBounds =
        decoder.decodeStructPointer(geometry$.RectF);
    val.handwritingBounds =
        decoder.decodeStructPointer(geometry$.RectF);
    return val;
  };

  EditorBoundsInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EditorBoundsInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.RectF, val.editorBounds);
    encoder.encodeStructPointer(geometry$.RectF, val.handwritingBounds);
  };
  function TextAppearanceInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TextAppearanceInfo.prototype.initDefaults_ = function() {
    this.textColor = null;
  };
  TextAppearanceInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TextAppearanceInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextAppearanceInfo.textColor
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, skcolor$.SkColor, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TextAppearanceInfo.encodedSize = codec.kStructHeaderSize + 8;

  TextAppearanceInfo.decode = function(decoder) {
    var packed;
    var val = new TextAppearanceInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.textColor =
        decoder.decodeStructPointer(skcolor$.SkColor);
    return val;
  };

  TextAppearanceInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TextAppearanceInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(skcolor$.SkColor, val.textColor);
  };
  function InputCursorAnchorInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InputCursorAnchorInfo.prototype.initDefaults_ = function() {
    this.characterBounds = null;
    this.editorBoundsInfo = null;
    this.textAppearanceInfo = null;
    this.visibleLineBounds = null;
    this.requested = false;
  };
  InputCursorAnchorInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InputCursorAnchorInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InputCursorAnchorInfo.characterBounds
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(geometry$.Rect), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InputCursorAnchorInfo.editorBoundsInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, EditorBoundsInfo, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InputCursorAnchorInfo.textAppearanceInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, TextAppearanceInfo, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InputCursorAnchorInfo.visibleLineBounds
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 8, new codec.PointerTo(geometry$.Rect), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  InputCursorAnchorInfo.encodedSize = codec.kStructHeaderSize + 40;

  InputCursorAnchorInfo.decode = function(decoder) {
    var packed;
    var val = new InputCursorAnchorInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.characterBounds =
        decoder.decodeArrayPointer(new codec.PointerTo(geometry$.Rect));
    val.editorBoundsInfo =
        decoder.decodeStructPointer(EditorBoundsInfo);
    val.textAppearanceInfo =
        decoder.decodeStructPointer(TextAppearanceInfo);
    val.visibleLineBounds =
        decoder.decodeArrayPointer(new codec.PointerTo(geometry$.Rect));
    packed = decoder.readUint8();
    val.requested = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  InputCursorAnchorInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InputCursorAnchorInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(geometry$.Rect), val.characterBounds);
    encoder.encodeStructPointer(EditorBoundsInfo, val.editorBoundsInfo);
    encoder.encodeStructPointer(TextAppearanceInfo, val.textAppearanceInfo);
    encoder.encodeArrayPointer(new codec.PointerTo(geometry$.Rect), val.visibleLineBounds);
    packed = 0;
    packed |= (val.requested & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ImeRenderWidgetHost_UpdateCursorAnchorInfo_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ImeRenderWidgetHost_UpdateCursorAnchorInfo_Params.prototype.initDefaults_ = function() {
    this.cursorAnchorInfo = null;
  };
  ImeRenderWidgetHost_UpdateCursorAnchorInfo_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ImeRenderWidgetHost_UpdateCursorAnchorInfo_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ImeRenderWidgetHost_UpdateCursorAnchorInfo_Params.cursorAnchorInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, InputCursorAnchorInfo, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ImeRenderWidgetHost_UpdateCursorAnchorInfo_Params.encodedSize = codec.kStructHeaderSize + 8;

  ImeRenderWidgetHost_UpdateCursorAnchorInfo_Params.decode = function(decoder) {
    var packed;
    var val = new ImeRenderWidgetHost_UpdateCursorAnchorInfo_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.cursorAnchorInfo =
        decoder.decodeStructPointer(InputCursorAnchorInfo);
    return val;
  };

  ImeRenderWidgetHost_UpdateCursorAnchorInfo_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ImeRenderWidgetHost_UpdateCursorAnchorInfo_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(InputCursorAnchorInfo, val.cursorAnchorInfo);
  };
  var kImeRenderWidgetHost_UpdateCursorAnchorInfo_Name = 0;

  function ImeRenderWidgetHostPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(ImeRenderWidgetHost,
                                                   handleOrPtrInfo);
  }

  function ImeRenderWidgetHostAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        ImeRenderWidgetHost, associatedInterfacePtrInfo);
  }

  ImeRenderWidgetHostAssociatedPtr.prototype =
      Object.create(ImeRenderWidgetHostPtr.prototype);
  ImeRenderWidgetHostAssociatedPtr.prototype.constructor =
      ImeRenderWidgetHostAssociatedPtr;

  function ImeRenderWidgetHostProxy(receiver) {
    this.receiver_ = receiver;
  }
  ImeRenderWidgetHostPtr.prototype.updateCursorAnchorInfo = function() {
    return ImeRenderWidgetHostProxy.prototype.updateCursorAnchorInfo
        .apply(this.ptr.getProxy(), arguments);
  };

  ImeRenderWidgetHostProxy.prototype.updateCursorAnchorInfo = function(cursorAnchorInfo) {
    var params_ = new ImeRenderWidgetHost_UpdateCursorAnchorInfo_Params();
    params_.cursorAnchorInfo = cursorAnchorInfo;
    var builder = new codec.MessageV0Builder(
        kImeRenderWidgetHost_UpdateCursorAnchorInfo_Name,
        codec.align(ImeRenderWidgetHost_UpdateCursorAnchorInfo_Params.encodedSize));
    builder.encodeStruct(ImeRenderWidgetHost_UpdateCursorAnchorInfo_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function ImeRenderWidgetHostStub(delegate) {
    this.delegate_ = delegate;
  }
  ImeRenderWidgetHostStub.prototype.updateCursorAnchorInfo = function(cursorAnchorInfo) {
    return this.delegate_ && this.delegate_.updateCursorAnchorInfo && this.delegate_.updateCursorAnchorInfo(cursorAnchorInfo);
  }

  ImeRenderWidgetHostStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kImeRenderWidgetHost_UpdateCursorAnchorInfo_Name:
      var params = reader.decodeStruct(ImeRenderWidgetHost_UpdateCursorAnchorInfo_Params);
      this.updateCursorAnchorInfo(params.cursorAnchorInfo);
      return true;
    default:
      return false;
    }
  };

  ImeRenderWidgetHostStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateImeRenderWidgetHostRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kImeRenderWidgetHost_UpdateCursorAnchorInfo_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ImeRenderWidgetHost_UpdateCursorAnchorInfo_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateImeRenderWidgetHostResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var ImeRenderWidgetHost = {
    name: 'blink.mojom.ImeRenderWidgetHost',
    kVersion: 0,
    ptrClass: ImeRenderWidgetHostPtr,
    proxyClass: ImeRenderWidgetHostProxy,
    stubClass: ImeRenderWidgetHostStub,
    validateRequest: validateImeRenderWidgetHostRequest,
    validateResponse: null,
  };
  ImeRenderWidgetHostStub.prototype.validator = validateImeRenderWidgetHostRequest;
  ImeRenderWidgetHostProxy.prototype.validator = null;
  exports.EditorBoundsInfo = EditorBoundsInfo;
  exports.TextAppearanceInfo = TextAppearanceInfo;
  exports.InputCursorAnchorInfo = InputCursorAnchorInfo;
  exports.ImeRenderWidgetHost = ImeRenderWidgetHost;
  exports.ImeRenderWidgetHostPtr = ImeRenderWidgetHostPtr;
  exports.ImeRenderWidgetHostAssociatedPtr = ImeRenderWidgetHostAssociatedPtr;
})();