// third_party/blink/public/mojom/indexeddb/indexeddb.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INDEXEDDB_INDEXEDDB_MOJOM_SEND_VALIDATION_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INDEXEDDB_INDEXEDDB_MOJOM_SEND_VALIDATION_H_

#include "third_party/blink/public/mojom/indexeddb/indexeddb.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/blob.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_transfer_token.mojom-shared.h"

#include "third_party/blink/public/mojom/indexeddb/indexeddb.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::IDBCursorDirection, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::IDBDataLoss, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::IDBKeyType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::IDBTransactionDurability, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::IDBGetAllResultType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::IDBKeyPathType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::IDBOperationType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::IDBPutMode, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::IDBTaskType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::IDBTransactionMode, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::IDBException, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::IDBKeyPathDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::IDBKeyPathDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::IDBKeyPath_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::data(input)) in_data = Traits::data(input);
      mojo::internal::MessageFragment<decltype(fragment->data)>
          data_fragment(fragment.message());
      data_fragment.Claim(&fragment->data);
      
      mojo::internal::Serialize<::blink::mojom::IDBKeyPathDataDataView, send_validation>(
        in_data,
        data_fragment,
        true);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::IDBKeyRangeDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::IDBKeyRangeDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::IDBKeyRange_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::lower(input)) in_lower = Traits::lower(input);
      mojo::internal::MessageFragment<decltype(fragment->lower)>
          lower_fragment(fragment.message());
      lower_fragment.Claim(&fragment->lower);
      
      mojo::internal::Serialize<::blink::mojom::IDBKeyDataView, send_validation>(
        in_lower,
        lower_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->lower.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null lower in IDBKeyRange struct");

      decltype(Traits::upper(input)) in_upper = Traits::upper(input);
      mojo::internal::MessageFragment<decltype(fragment->upper)>
          upper_fragment(fragment.message());
      upper_fragment.Claim(&fragment->upper);
      
      mojo::internal::Serialize<::blink::mojom::IDBKeyDataView, send_validation>(
        in_upper,
        upper_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->upper.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null upper in IDBKeyRange struct");

      fragment->lower_open = Traits::lower_open(input);

      fragment->upper_open = Traits::upper_open(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::IDBIndexMetadataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::IDBIndexMetadataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::IDBIndexMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->id = Traits::id(input);

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in IDBIndexMetadata struct");

      decltype(Traits::key_path(input)) in_key_path = Traits::key_path(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->key_path)::BaseType> key_path_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::IDBKeyPathDataView, send_validation>(
        in_key_path,
        key_path_fragment);

      fragment->key_path.Set(
          key_path_fragment.is_null() ? nullptr : key_path_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->key_path.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null key_path in IDBIndexMetadata struct");

      fragment->unique = Traits::unique(input);

      fragment->multi_entry = Traits::multi_entry(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::IDBObjectStoreMetadataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::IDBObjectStoreMetadataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::IDBObjectStoreMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->id = Traits::id(input);

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in IDBObjectStoreMetadata struct");

      decltype(Traits::key_path(input)) in_key_path = Traits::key_path(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->key_path)::BaseType> key_path_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::IDBKeyPathDataView, send_validation>(
        in_key_path,
        key_path_fragment);

      fragment->key_path.Set(
          key_path_fragment.is_null() ? nullptr : key_path_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->key_path.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null key_path in IDBObjectStoreMetadata struct");

      fragment->auto_increment = Traits::auto_increment(input);

      fragment->max_index_id = Traits::max_index_id(input);

      decltype(Traits::indexes(input)) in_indexes = Traits::indexes(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->indexes)::BaseType>
          indexes_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& indexes_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<int64_t, ::blink::mojom::IDBIndexMetadataDataView>, send_validation>(
        in_indexes,
        indexes_fragment,
        &indexes_validate_params);

      fragment->indexes.Set(
          indexes_fragment.is_null() ? nullptr : indexes_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->indexes.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null indexes in IDBObjectStoreMetadata struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::IDBDatabaseMetadataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::IDBDatabaseMetadataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::IDBDatabaseMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in IDBDatabaseMetadata struct");

      fragment->version = Traits::version(input);

      fragment->max_object_store_id = Traits::max_object_store_id(input);

      decltype(Traits::object_stores(input)) in_object_stores = Traits::object_stores(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->object_stores)::BaseType>
          object_stores_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& object_stores_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<int64_t, ::blink::mojom::IDBObjectStoreMetadataDataView>, send_validation>(
        in_object_stores,
        object_stores_fragment,
        &object_stores_validate_params);

      fragment->object_stores.Set(
          object_stores_fragment.is_null() ? nullptr : object_stores_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->object_stores.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null object_stores in IDBDatabaseMetadata struct");

      fragment->was_cold_open = Traits::was_cold_open(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::IDBNameAndVersionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::IDBNameAndVersionDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::IDBNameAndVersion_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in IDBNameAndVersion struct");

      fragment->version = Traits::version(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::IDBIndexKeysDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::IDBIndexKeysDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::IDBIndexKeys_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->index_id = Traits::index_id(input);

      decltype(Traits::index_keys(input)) in_index_keys = Traits::index_keys(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->index_keys)::BaseType>
          index_keys_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& index_keys_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::IDBKeyDataView>, send_validation>(
        in_index_keys,
        index_keys_fragment,
        &index_keys_validate_params);

      fragment->index_keys.Set(
          index_keys_fragment.is_null() ? nullptr : index_keys_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->index_keys.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null index_keys in IDBIndexKeys struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::IDBFileInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::IDBFileInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::IDBFileInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in IDBFileInfo struct");

      decltype(Traits::last_modified(input)) in_last_modified = Traits::last_modified(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->last_modified)::BaseType> last_modified_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_last_modified,
        last_modified_fragment);

      fragment->last_modified.Set(
          last_modified_fragment.is_null() ? nullptr : last_modified_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->last_modified.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null last_modified in IDBFileInfo struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::IDBBlobInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::IDBBlobInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::IDBBlobInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::blob(input)) in_blob = Traits::blob(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BlobInterfaceBase>>(
        in_blob,
        &fragment->blob,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->blob)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid blob in IDBBlobInfo struct");

      decltype(Traits::mime_type(input)) in_mime_type = Traits::mime_type(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->mime_type)::BaseType> mime_type_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_mime_type,
        mime_type_fragment);

      fragment->mime_type.Set(
          mime_type_fragment.is_null() ? nullptr : mime_type_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->mime_type.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mime_type in IDBBlobInfo struct");

      fragment->size = Traits::size(input);

      decltype(Traits::file(input)) in_file = Traits::file(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->file)::BaseType> file_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::IDBFileInfoDataView, send_validation>(
        in_file,
        file_fragment);

      fragment->file.Set(
          file_fragment.is_null() ? nullptr : file_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::IDBValueDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::IDBValueDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::IDBValue_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::bits(input)) in_bits = Traits::bits(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->bits)::BaseType>
          bits_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& bits_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_bits,
        bits_fragment,
        &bits_validate_params);

      fragment->bits.Set(
          bits_fragment.is_null() ? nullptr : bits_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->bits.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bits in IDBValue struct");

      decltype(Traits::external_objects(input)) in_external_objects = Traits::external_objects(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->external_objects)::BaseType>
          external_objects_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& external_objects_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::IDBExternalObjectDataView>, send_validation>(
        in_external_objects,
        external_objects_fragment,
        &external_objects_validate_params);

      fragment->external_objects.Set(
          external_objects_fragment.is_null() ? nullptr : external_objects_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->external_objects.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null external_objects in IDBValue struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::IDBReturnValueDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::IDBReturnValueDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::IDBReturnValue_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::value(input)) in_value = Traits::value(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->value)::BaseType> value_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::IDBValueDataView, send_validation>(
        in_value,
        value_fragment);

      fragment->value.Set(
          value_fragment.is_null() ? nullptr : value_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->value.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in IDBReturnValue struct");

      decltype(Traits::primary_key(input)) in_primary_key = Traits::primary_key(input);
      mojo::internal::MessageFragment<decltype(fragment->primary_key)>
          primary_key_fragment(fragment.message());
      primary_key_fragment.Claim(&fragment->primary_key);
      
      mojo::internal::Serialize<::blink::mojom::IDBKeyDataView, send_validation>(
        in_primary_key,
        primary_key_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->primary_key.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null primary_key in IDBReturnValue struct");

      decltype(Traits::key_path(input)) in_key_path = Traits::key_path(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->key_path)::BaseType> key_path_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::IDBKeyPathDataView, send_validation>(
        in_key_path,
        key_path_fragment);

      fragment->key_path.Set(
          key_path_fragment.is_null() ? nullptr : key_path_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->key_path.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null key_path in IDBReturnValue struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::IDBRecordDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::IDBRecordDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::IDBRecord_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::primary_key(input)) in_primary_key = Traits::primary_key(input);
      mojo::internal::MessageFragment<decltype(fragment->primary_key)>
          primary_key_fragment(fragment.message());
      primary_key_fragment.Claim(&fragment->primary_key);
      
      mojo::internal::Serialize<::blink::mojom::IDBKeyDataView, send_validation>(
        in_primary_key,
        primary_key_fragment,
        true);

      decltype(Traits::return_value(input)) in_return_value = Traits::return_value(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->return_value)::BaseType> return_value_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::IDBReturnValueDataView, send_validation>(
        in_return_value,
        return_value_fragment);

      fragment->return_value.Set(
          return_value_fragment.is_null() ? nullptr : return_value_fragment.data());

      decltype(Traits::index_key(input)) in_index_key = Traits::index_key(input);
      mojo::internal::MessageFragment<decltype(fragment->index_key)>
          index_key_fragment(fragment.message());
      index_key_fragment.Claim(&fragment->index_key);
      
      mojo::internal::Serialize<::blink::mojom::IDBKeyDataView, send_validation>(
        in_index_key,
        index_key_fragment,
        true);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::IDBErrorDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::IDBErrorDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::IDBError_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::blink::mojom::IDBException>(
        Traits::error_code(input),
        &fragment->error_code);

      decltype(Traits::error_message(input)) in_error_message = Traits::error_message(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->error_message)::BaseType> error_message_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_error_message,
        error_message_fragment);

      fragment->error_message.Set(
          error_message_fragment.is_null() ? nullptr : error_message_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->error_message.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null error_message in IDBError struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::IDBCursorValueDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::IDBCursorValueDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::IDBCursorValue_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::keys(input)) in_keys = Traits::keys(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->keys)::BaseType>
          keys_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& keys_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::IDBKeyDataView>, send_validation>(
        in_keys,
        keys_fragment,
        &keys_validate_params);

      fragment->keys.Set(
          keys_fragment.is_null() ? nullptr : keys_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->keys.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null keys in IDBCursorValue struct");

      decltype(Traits::primary_keys(input)) in_primary_keys = Traits::primary_keys(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->primary_keys)::BaseType>
          primary_keys_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& primary_keys_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::IDBKeyDataView>, send_validation>(
        in_primary_keys,
        primary_keys_fragment,
        &primary_keys_validate_params);

      fragment->primary_keys.Set(
          primary_keys_fragment.is_null() ? nullptr : primary_keys_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->primary_keys.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null primary_keys in IDBCursorValue struct");

      decltype(Traits::values(input)) in_values = Traits::values(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->values)::BaseType>
          values_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& values_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::IDBValueDataView>, send_validation>(
        in_values,
        values_fragment,
        &values_validate_params);

      fragment->values.Set(
          values_fragment.is_null() ? nullptr : values_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->values.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null values in IDBCursorValue struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::IDBDatabaseOpenCursorValueDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::IDBDatabaseOpenCursorValueDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::IDBDatabaseOpenCursorValue_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::cursor(input)) in_cursor = Traits::cursor(input);

      
      mojo::internal::Serialize<::blink::mojom::IDBCursorAssociatedPtrInfoDataView>(
        in_cursor,
        &fragment->cursor,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->cursor)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid cursor in IDBDatabaseOpenCursorValue struct");

      decltype(Traits::key(input)) in_key = Traits::key(input);
      mojo::internal::MessageFragment<decltype(fragment->key)>
          key_fragment(fragment.message());
      key_fragment.Claim(&fragment->key);
      
      mojo::internal::Serialize<::blink::mojom::IDBKeyDataView, send_validation>(
        in_key,
        key_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->key.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null key in IDBDatabaseOpenCursorValue struct");

      decltype(Traits::primary_key(input)) in_primary_key = Traits::primary_key(input);
      mojo::internal::MessageFragment<decltype(fragment->primary_key)>
          primary_key_fragment(fragment.message());
      primary_key_fragment.Claim(&fragment->primary_key);
      
      mojo::internal::Serialize<::blink::mojom::IDBKeyDataView, send_validation>(
        in_primary_key,
        primary_key_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->primary_key.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null primary_key in IDBDatabaseOpenCursorValue struct");

      decltype(Traits::value(input)) in_value = Traits::value(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->value)::BaseType> value_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::IDBValueDataView, send_validation>(
        in_value,
        value_fragment);

      fragment->value.Set(
          value_fragment.is_null() ? nullptr : value_fragment.data());
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::IDBKeyDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::IDBKeyDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::IDBKey_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::IDBKeyDataView::Tag::kKeyArray: {
    decltype(Traits::key_array(input))
    in_key_array = Traits::key_array(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_key_array)::BaseType>
    value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& key_array_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        
mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::IDBKeyDataView>, send_validation>(
  in_key_array,
  value_fragment,
  &key_array_validate_params);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null key_array in IDBKey union");
    fragment->data.f_key_array.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::IDBKeyDataView::Tag::kBinary: {
    decltype(Traits::binary(input))
    in_binary = Traits::binary(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_binary)::BaseType>
    value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& binary_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        
mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
  in_binary,
  value_fragment,
  &binary_validate_params);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null binary in IDBKey union");
    fragment->data.f_binary.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::IDBKeyDataView::Tag::kString: {
    decltype(Traits::string(input))
    in_string = Traits::string(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_string)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
  in_string,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null string in IDBKey union");
    fragment->data.f_string.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::IDBKeyDataView::Tag::kDate: {
    decltype(Traits::date(input))
    in_date = Traits::date(input);
    fragment->data.f_date = in_date;
    break;
  }
  case ::blink::mojom::IDBKeyDataView::Tag::kNumber: {
    decltype(Traits::number(input))
    in_number = Traits::number(input);
    fragment->data.f_number = in_number;
    break;
  }
  case ::blink::mojom::IDBKeyDataView::Tag::kOtherNone: {
    decltype(Traits::other_none(input))
    in_other_none = Traits::other_none(input);
    fragment->data.f_other_none = in_other_none;
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::IDBKeyPathDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::IDBKeyPathDataDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::IDBKeyPathData_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::IDBKeyPathDataDataView::Tag::kString: {
    decltype(Traits::string(input))
    in_string = Traits::string(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_string)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
  in_string,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null string in IDBKeyPathData union");
    fragment->data.f_string.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::IDBKeyPathDataDataView::Tag::kStringArray: {
    decltype(Traits::string_array(input))
    in_string_array = Traits::string_array(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_string_array)::BaseType>
    value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& string_array_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        
mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>, send_validation>(
  in_string_array,
  value_fragment,
  &string_array_validate_params);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null string_array in IDBKeyPathData union");
    fragment->data.f_string_array.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::IDBExternalObjectDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::IDBExternalObjectDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::IDBExternalObject_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::IDBExternalObjectDataView::Tag::kBlobOrFile: {
    decltype(Traits::blob_or_file(input))
    in_blob_or_file = Traits::blob_or_file(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_blob_or_file)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::IDBBlobInfoDataView, send_validation>(
  in_blob_or_file,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null blob_or_file in IDBExternalObject union");
    fragment->data.f_blob_or_file.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::IDBExternalObjectDataView::Tag::kFileSystemAccessToken: {
    decltype(Traits::file_system_access_token(input))
    in_file_system_access_token = Traits::file_system_access_token(input);
        
mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessTransferTokenInterfaceBase>, send_validation>(
  in_file_system_access_token,
  &fragment->data.f_file_system_access_token,
  &fragment.message());
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(!mojo::internal::IsHandleOrInterfaceValid(fragment->data.f_file_system_access_token)),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
  "null file_system_access_token in IDBExternalObject union");
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::IDBCursorResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::IDBCursorResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::IDBCursorResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::IDBCursorResultDataView::Tag::kErrorResult: {
    decltype(Traits::error_result(input))
    in_error_result = Traits::error_result(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_error_result)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::IDBErrorDataView, send_validation>(
  in_error_result,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null error_result in IDBCursorResult union");
    fragment->data.f_error_result.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::IDBCursorResultDataView::Tag::kEmpty: {
    decltype(Traits::empty(input))
    in_empty = Traits::empty(input);
    fragment->data.f_empty = in_empty;
    break;
  }
  case ::blink::mojom::IDBCursorResultDataView::Tag::kValues: {
    decltype(Traits::values(input))
    in_values = Traits::values(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_values)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::IDBCursorValueDataView, send_validation>(
  in_values,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null values in IDBCursorResult union");
    fragment->data.f_values.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::IDBTransactionPutResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::IDBTransactionPutResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::IDBTransactionPutResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::IDBTransactionPutResultDataView::Tag::kErrorResult: {
    decltype(Traits::error_result(input))
    in_error_result = Traits::error_result(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_error_result)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::IDBErrorDataView, send_validation>(
  in_error_result,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null error_result in IDBTransactionPutResult union");
    fragment->data.f_error_result.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::IDBTransactionPutResultDataView::Tag::kKey: {
    decltype(Traits::key(input))
    in_key = Traits::key(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_key)::BaseType>
    value_fragment(fragment.message());
  
mojo::internal::Serialize<::blink::mojom::IDBKeyDataView, send_validation>(
  in_key,
  value_fragment,
  false);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null key in IDBTransactionPutResult union");
    fragment->data.f_key.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::IDBDatabaseGetResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::IDBDatabaseGetResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::IDBDatabaseGetResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::IDBDatabaseGetResultDataView::Tag::kErrorResult: {
    decltype(Traits::error_result(input))
    in_error_result = Traits::error_result(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_error_result)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::IDBErrorDataView, send_validation>(
  in_error_result,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null error_result in IDBDatabaseGetResult union");
    fragment->data.f_error_result.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::IDBDatabaseGetResultDataView::Tag::kEmpty: {
    decltype(Traits::empty(input))
    in_empty = Traits::empty(input);
    fragment->data.f_empty = in_empty;
    break;
  }
  case ::blink::mojom::IDBDatabaseGetResultDataView::Tag::kKey: {
    decltype(Traits::key(input))
    in_key = Traits::key(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_key)::BaseType>
    value_fragment(fragment.message());
  
mojo::internal::Serialize<::blink::mojom::IDBKeyDataView, send_validation>(
  in_key,
  value_fragment,
  false);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null key in IDBDatabaseGetResult union");
    fragment->data.f_key.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::IDBDatabaseGetResultDataView::Tag::kValue: {
    decltype(Traits::value(input))
    in_value = Traits::value(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_value)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::IDBReturnValueDataView, send_validation>(
  in_value,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null value in IDBDatabaseGetResult union");
    fragment->data.f_value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::IDBDatabaseOpenCursorResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::IDBDatabaseOpenCursorResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::IDBDatabaseOpenCursorResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::IDBDatabaseOpenCursorResultDataView::Tag::kErrorResult: {
    decltype(Traits::error_result(input))
    in_error_result = Traits::error_result(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_error_result)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::IDBErrorDataView, send_validation>(
  in_error_result,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null error_result in IDBDatabaseOpenCursorResult union");
    fragment->data.f_error_result.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::IDBDatabaseOpenCursorResultDataView::Tag::kEmpty: {
    decltype(Traits::empty(input))
    in_empty = Traits::empty(input);
    fragment->data.f_empty = in_empty;
    break;
  }
  case ::blink::mojom::IDBDatabaseOpenCursorResultDataView::Tag::kValue: {
    decltype(Traits::value(input))
    in_value = Traits::value(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_value)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::IDBDatabaseOpenCursorValueDataView, send_validation>(
  in_value,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null value in IDBDatabaseOpenCursorResult union");
    fragment->data.f_value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_INDEXEDDB_INDEXEDDB_MOJOM_SEND_VALIDATION_H_