// third_party/blink/public/mojom/image_downloader/image_downloader.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  BitmapN32 as skia_mojom_BitmapN32,
  BitmapN32Spec as skia_mojom_BitmapN32Spec
} from '../../../../../skia/public/mojom/bitmap.mojom.m.js';

import {
  Size as gfx_mojom_Size,
  SizeSpec as gfx_mojom_SizeSpec
} from '../../../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ImageDownloaderPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.ImageDownloader', scope);
  }
}

/** @interface */
export class ImageDownloaderInterface {
  
  /**
   * @param { !url_mojom_Url } url
   * @param { !boolean } isFavicon
   * @param { !gfx_mojom_Size } preferredSize
   * @param { !number } maxBitmapSize
   * @param { !boolean } bypassCache
   * @return {!Promise<{
        httpStatusCode: !number,
        images: !Array<!skia_mojom_BitmapN32>,
        originalImageSizes: !Array<!gfx_mojom_Size>,
   *  }>}
   */

  downloadImage(url, isFavicon, preferredSize, maxBitmapSize, bypassCache) {}
  
  /**
   * @param { !number } axNodeId
   * @param { !gfx_mojom_Size } preferredSize
   * @param { !number } maxBitmapSize
   * @param { !boolean } bypassCache
   * @return {!Promise<{
        httpStatusCode: !number,
        images: !Array<!skia_mojom_BitmapN32>,
        originalImageSizes: !Array<!gfx_mojom_Size>,
   *  }>}
   */

  downloadImageFromAxNode(axNodeId, preferredSize, maxBitmapSize, bypassCache) {}
}

/**
 * @implements { ImageDownloaderInterface }
 */
export class ImageDownloaderRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ImageDownloaderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ImageDownloaderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ImageDownloaderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !url_mojom_Url } url
   * @param { !boolean } isFavicon
   * @param { !gfx_mojom_Size } preferredSize
   * @param { !number } maxBitmapSize
   * @param { !boolean } bypassCache
   * @return {!Promise<{
        httpStatusCode: !number,
        images: !Array<!skia_mojom_BitmapN32>,
        originalImageSizes: !Array<!gfx_mojom_Size>,
   *  }>}
   */

  downloadImage(
      url,
      isFavicon,
      preferredSize,
      maxBitmapSize,
      bypassCache) {
    return this.proxy.sendMessage(
        0,
        ImageDownloader_DownloadImage_ParamsSpec.$,
        ImageDownloader_DownloadImage_ResponseParamsSpec.$,
        [
          url,
          isFavicon,
          preferredSize,
          maxBitmapSize,
          bypassCache
        ],
        false);
  }

  
  /**
   * @param { !number } axNodeId
   * @param { !gfx_mojom_Size } preferredSize
   * @param { !number } maxBitmapSize
   * @param { !boolean } bypassCache
   * @return {!Promise<{
        httpStatusCode: !number,
        images: !Array<!skia_mojom_BitmapN32>,
        originalImageSizes: !Array<!gfx_mojom_Size>,
   *  }>}
   */

  downloadImageFromAxNode(
      axNodeId,
      preferredSize,
      maxBitmapSize,
      bypassCache) {
    return this.proxy.sendMessage(
        1,
        ImageDownloader_DownloadImageFromAxNode_ParamsSpec.$,
        ImageDownloader_DownloadImageFromAxNode_ResponseParamsSpec.$,
        [
          axNodeId,
          preferredSize,
          maxBitmapSize,
          bypassCache
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ImageDownloader
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ImageDownloaderReceiver {
  /**
   * @param {!ImageDownloaderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ImageDownloaderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ImageDownloaderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ImageDownloaderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ImageDownloader_DownloadImage_ParamsSpec.$,
        ImageDownloader_DownloadImage_ResponseParamsSpec.$,
        impl.downloadImage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ImageDownloader_DownloadImageFromAxNode_ParamsSpec.$,
        ImageDownloader_DownloadImageFromAxNode_ResponseParamsSpec.$,
        impl.downloadImageFromAxNode.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ImageDownloader {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ImageDownloader";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ImageDownloaderRemote}
   */
  static getRemote() {
    let remote = new ImageDownloaderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ImageDownloader
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ImageDownloaderCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ImageDownloaderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ImageDownloaderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.downloadImage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ImageDownloader_DownloadImage_ParamsSpec.$,
        ImageDownloader_DownloadImage_ResponseParamsSpec.$,
        this.downloadImage.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.downloadImageFromAxNode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ImageDownloader_DownloadImageFromAxNode_ParamsSpec.$,
        ImageDownloader_DownloadImageFromAxNode_ResponseParamsSpec.$,
        this.downloadImageFromAxNode.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ImageDownloader_DownloadImage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ImageDownloader_DownloadImage_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ImageDownloader_DownloadImageFromAxNode_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ImageDownloader_DownloadImageFromAxNode_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ImageDownloader_DownloadImage_ParamsSpec.$,
    'ImageDownloader_DownloadImage_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isFavicon', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'preferredSize', 16,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxBitmapSize', 12,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'bypassCache', 8,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class ImageDownloader_DownloadImage_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !boolean } */
    this.isFavicon;
    /** @type { !gfx_mojom_Size } */
    this.preferredSize;
    /** @type { !number } */
    this.maxBitmapSize;
    /** @type { !boolean } */
    this.bypassCache;
  }
}



mojo.internal.Struct(
    ImageDownloader_DownloadImage_ResponseParamsSpec.$,
    'ImageDownloader_DownloadImage_ResponseParams',
    [
      mojo.internal.StructField(
        'httpStatusCode', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'images', 8,
        0,
        mojo.internal.Array(skia_mojom_BitmapN32Spec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'originalImageSizes', 16,
        0,
        mojo.internal.Array(gfx_mojom_SizeSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class ImageDownloader_DownloadImage_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.httpStatusCode;
    /** @type { !Array<!skia_mojom_BitmapN32> } */
    this.images;
    /** @type { !Array<!gfx_mojom_Size> } */
    this.originalImageSizes;
  }
}



mojo.internal.Struct(
    ImageDownloader_DownloadImageFromAxNode_ParamsSpec.$,
    'ImageDownloader_DownloadImageFromAxNode_Params',
    [
      mojo.internal.StructField(
        'axNodeId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'preferredSize', 8,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxBitmapSize', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'bypassCache', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class ImageDownloader_DownloadImageFromAxNode_Params {
  constructor() {
    /** @type { !number } */
    this.axNodeId;
    /** @type { !gfx_mojom_Size } */
    this.preferredSize;
    /** @type { !number } */
    this.maxBitmapSize;
    /** @type { !boolean } */
    this.bypassCache;
  }
}



mojo.internal.Struct(
    ImageDownloader_DownloadImageFromAxNode_ResponseParamsSpec.$,
    'ImageDownloader_DownloadImageFromAxNode_ResponseParams',
    [
      mojo.internal.StructField(
        'httpStatusCode', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'images', 8,
        0,
        mojo.internal.Array(skia_mojom_BitmapN32Spec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'originalImageSizes', 16,
        0,
        mojo.internal.Array(gfx_mojom_SizeSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class ImageDownloader_DownloadImageFromAxNode_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.httpStatusCode;
    /** @type { !Array<!skia_mojom_BitmapN32> } */
    this.images;
    /** @type { !Array<!gfx_mojom_Size> } */
    this.originalImageSizes;
  }
}

