// third_party/blink/public/mojom/idle/idle_manager.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/idle/idle_manager.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/idle/idle_manager.mojom-params-data.h"
#include "third_party/blink/public/mojom/idle/idle_manager.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/idle/idle_manager.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/idle/idle_manager.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
IdleState::IdleState()
    : idle_time(),
      screen_locked() {}

IdleState::IdleState(
    std::optional<::base::TimeDelta> idle_time_in,
    bool screen_locked_in)
    : idle_time(std::move(idle_time_in)),
      screen_locked(std::move(screen_locked_in)) {}

IdleState::~IdleState() = default;

void IdleState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "idle_time"), this->idle_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "screen_locked"), this->screen_locked,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool IdleState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

IdleMonitor::IPCStableHashFunction IdleMonitor::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::IdleMonitor>(message.name())) {
    case messages::IdleMonitor::kUpdate: {
      return &IdleMonitor::Update_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* IdleMonitor::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::IdleMonitor>(message.name())) {
      case messages::IdleMonitor::kUpdate:
            return "Receive blink::mojom::IdleMonitor::Update";
    }
  } else {
    switch (static_cast<messages::IdleMonitor>(message.name())) {
      case messages::IdleMonitor::kUpdate:
            return "Receive reply blink::mojom::IdleMonitor::Update";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t IdleMonitor::Update_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x404cdeb4;  // IPCStableHash for blink::mojom::IdleMonitor::Update
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

IdleMonitorProxy::IdleMonitorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void IdleMonitorProxy::Update(
    IdleStatePtr in_state, bool in_is_overridden_by_devtools) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::IdleMonitor::Update", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type IdleStatePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_overridden_by_devtools"), in_is_overridden_by_devtools,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IdleMonitor::kUpdate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IdleMonitor_Update_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->state)::BaseType> state_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::IdleStateDataView>(
    in_state,
    state_fragment);

  params->state.Set(
      state_fragment.is_null() ? nullptr : state_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->state.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null state in IdleMonitor.Update request");

  params->is_overridden_by_devtools = in_is_overridden_by_devtools;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IdleMonitor::Name_);
  message.set_method_name("Update");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool IdleMonitorStubDispatch::Accept(
    IdleMonitor* impl,
    mojo::Message* message) {
  switch (static_cast<messages::IdleMonitor>(message->header()->name)) {
    case messages::IdleMonitor::kUpdate: {
      DCHECK(message->is_serialized());
      internal::IdleMonitor_Update_Params_Data* params =
          reinterpret_cast<internal::IdleMonitor_Update_Params_Data*>(
              message->mutable_payload());
      

      // Validation for IdleMonitor.0
      bool success = true;
      IdleStatePtr p_state{};
      bool p_is_overridden_by_devtools{};
      IdleMonitor_Update_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (success)
        p_is_overridden_by_devtools = input_data_view.is_overridden_by_devtools();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IdleMonitor::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Update(        
        std::move(p_state), 
        std::move(p_is_overridden_by_devtools));
      return true;
    }
  }
  return false;
}

// static
bool IdleMonitorStubDispatch::AcceptWithResponder(
    IdleMonitor* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::IdleMonitor>(message->header()->name)) {
    case messages::IdleMonitor::kUpdate: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kIdleMonitorValidationInfo[] = {
    { &internal::IdleMonitor_Update_Params_Data::Validate,
     nullptr /* no response */},
};

bool IdleMonitorRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::IdleMonitor::Name_,
    kIdleMonitorValidationInfo);
}

// The declaration includes the definition on other builds.
constexpr uint32_t IdleManager::kUserInputThresholdMs;

IdleManager::IPCStableHashFunction IdleManager::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::IdleManager>(message.name())) {
    case messages::IdleManager::kAddMonitor: {
      return &IdleManager::AddMonitor_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* IdleManager::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::IdleManager>(message.name())) {
      case messages::IdleManager::kAddMonitor:
            return "Receive blink::mojom::IdleManager::AddMonitor";
    }
  } else {
    switch (static_cast<messages::IdleManager>(message.name())) {
      case messages::IdleManager::kAddMonitor:
            return "Receive reply blink::mojom::IdleManager::AddMonitor";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t IdleManager::AddMonitor_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf999034b;  // IPCStableHash for blink::mojom::IdleManager::AddMonitor
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class IdleManager_AddMonitor_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IdleManager_AddMonitor_ForwardToCallback(
      IdleManager::AddMonitorCallback callback
      ) : callback_(std::move(callback)) {
  }

  IdleManager_AddMonitor_ForwardToCallback(const IdleManager_AddMonitor_ForwardToCallback&) = delete;
  IdleManager_AddMonitor_ForwardToCallback& operator=(const IdleManager_AddMonitor_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  IdleManager::AddMonitorCallback callback_;
};

IdleManagerProxy::IdleManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void IdleManagerProxy::AddMonitor(
    ::mojo::PendingRemote<IdleMonitor> in_monitor, AddMonitorCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::IdleManager::AddMonitor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("monitor"), in_monitor,
                        "<value of type ::mojo::PendingRemote<IdleMonitor>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IdleManager::kAddMonitor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IdleManager_AddMonitor_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::IdleMonitorInterfaceBase>>(
    in_monitor,
    &params->monitor,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->monitor)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid monitor in IdleManager.AddMonitor request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IdleManager::Name_);
  message.set_method_name("AddMonitor");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IdleManager_AddMonitor_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class IdleManager_AddMonitor_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static IdleManager::AddMonitorCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<IdleManager_AddMonitor_ProxyToResponder> proxy(
        new IdleManager_AddMonitor_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&IdleManager_AddMonitor_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IdleManager_AddMonitor_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  IdleManager_AddMonitor_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "IdleManager::AddMonitorCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      IdleManagerError in_error, IdleStatePtr in_state);
};

bool IdleManager_AddMonitor_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::IdleManager_AddMonitor_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IdleManager_AddMonitor_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for IdleManager.0
  bool success = true;
  IdleManagerError p_error{};
  IdleStatePtr p_state{};
  IdleManager_AddMonitor_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadState(&p_state))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IdleManager::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_state));
  }
  return true;
}

void IdleManager_AddMonitor_ProxyToResponder::Run(
    IdleManagerError in_error, IdleStatePtr in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::IdleManager::AddMonitor", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type IdleManagerError>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type IdleStatePtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IdleManager::kAddMonitor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IdleManager_AddMonitor_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::IdleManagerError>(
    in_error,
    &params->error);
  mojo::internal::MessageFragment<
      typename decltype(params->state)::BaseType> state_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::IdleStateDataView>(
    in_state,
    state_fragment);

  params->state.Set(
      state_fragment.is_null() ? nullptr : state_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IdleManager::Name_);
  message.set_method_name("AddMonitor");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool IdleManagerStubDispatch::Accept(
    IdleManager* impl,
    mojo::Message* message) {
  switch (static_cast<messages::IdleManager>(message->header()->name)) {
    case messages::IdleManager::kAddMonitor: {
      break;
    }
  }
  return false;
}

// static
bool IdleManagerStubDispatch::AcceptWithResponder(
    IdleManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::IdleManager>(message->header()->name)) {
    case messages::IdleManager::kAddMonitor: {
      internal::IdleManager_AddMonitor_Params_Data* params =
          reinterpret_cast<
              internal::IdleManager_AddMonitor_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for IdleManager.0
      bool success = true;
      ::mojo::PendingRemote<IdleMonitor> p_monitor{};
      IdleManager_AddMonitor_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_monitor =
            input_data_view.TakeMonitor<decltype(p_monitor)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IdleManager::Name_, 0, false);
        return false;
      }
      auto callback =
          IdleManager_AddMonitor_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddMonitor(        
        std::move(p_monitor), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kIdleManagerValidationInfo[] = {
    { &internal::IdleManager_AddMonitor_Params_Data::Validate,
     &internal::IdleManager_AddMonitor_ResponseParams_Data::Validate},
};

bool IdleManagerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::IdleManager::Name_,
    kIdleManagerValidationInfo);
}

bool IdleManagerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::IdleManager::Name_,
    kIdleManagerValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::IdleState::DataView, ::blink::mojom::blink::IdleStatePtr>::Read(
    ::blink::mojom::blink::IdleState::DataView input,
    ::blink::mojom::blink::IdleStatePtr* output) {
  bool success = true;
  ::blink::mojom::blink::IdleStatePtr result(::blink::mojom::blink::IdleState::New());
  
      if (success && !input.ReadIdleTime(&result->idle_time))
        success = false;
      if (success)
        result->screen_locked = input.screen_locked();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void IdleMonitorInterceptorForTesting::Update(IdleStatePtr state, bool is_overridden_by_devtools) {
  GetForwardingInterface()->Update(
    std::move(state)
    , 
    std::move(is_overridden_by_devtools)
    );
}
IdleMonitorAsyncWaiter::IdleMonitorAsyncWaiter(
    IdleMonitor* proxy) : proxy_(proxy) {}

IdleMonitorAsyncWaiter::~IdleMonitorAsyncWaiter() = default;





void IdleManagerInterceptorForTesting::AddMonitor(::mojo::PendingRemote<IdleMonitor> monitor, AddMonitorCallback callback) {
  GetForwardingInterface()->AddMonitor(
    std::move(monitor)
    , std::move(callback));
}
IdleManagerAsyncWaiter::IdleManagerAsyncWaiter(
    IdleManager* proxy) : proxy_(proxy) {}

IdleManagerAsyncWaiter::~IdleManagerAsyncWaiter() = default;


void IdleManagerAsyncWaiter::AddMonitor(
    ::mojo::PendingRemote<IdleMonitor> monitor, IdleManagerError* out_error, IdleStatePtr* out_state) {
  base::RunLoop loop;
  proxy_->AddMonitor(
      std::move(monitor),
      base::BindOnce(
          [](base::RunLoop* loop,
             IdleManagerError* out_error
,
             IdleStatePtr* out_state
,
             IdleManagerError error,
             IdleStatePtr state) {*out_error = std::move(error);*out_state = std::move(state);
            loop->Quit();
          },
          &loop,
          out_error,
          out_state));
  loop.Run();
}








}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif