// third_party/blink/public/mojom/hid/hid.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/hid/hid.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var hid$ =
      mojo.internal.exposeNamespace('device.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/device/public/mojom/hid.mojom', '../../../../../services/device/public/mojom/hid.mojom.js');
  }



  function VendorAndProduct(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VendorAndProduct.prototype.initDefaults_ = function() {
    this.vendor = 0;
    this.product = 0;
  };
  VendorAndProduct.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VendorAndProduct.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  VendorAndProduct.encodedSize = codec.kStructHeaderSize + 8;

  VendorAndProduct.decode = function(decoder) {
    var packed;
    var val = new VendorAndProduct();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.vendor =
        decoder.decodeStruct(codec.Uint16);
    val.product =
        decoder.decodeStruct(codec.Uint16);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  VendorAndProduct.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VendorAndProduct.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint16, val.vendor);
    encoder.encodeStruct(codec.Uint16, val.product);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function HidDeviceFilter(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HidDeviceFilter.prototype.initDefaults_ = function() {
    this.deviceIds = null;
    this.usage = null;
  };
  HidDeviceFilter.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HidDeviceFilter.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HidDeviceFilter.deviceIds
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, DeviceIdFilter, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HidDeviceFilter.usage
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 16, UsageFilter, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HidDeviceFilter.encodedSize = codec.kStructHeaderSize + 32;

  HidDeviceFilter.decode = function(decoder) {
    var packed;
    var val = new HidDeviceFilter();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.deviceIds =
        decoder.decodeStruct(DeviceIdFilter);
    val.usage =
        decoder.decodeStruct(UsageFilter);
    return val;
  };

  HidDeviceFilter.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HidDeviceFilter.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(DeviceIdFilter, val.deviceIds);
    encoder.encodeStruct(UsageFilter, val.usage);
  };
  function HidService_RegisterClient_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HidService_RegisterClient_Params.prototype.initDefaults_ = function() {
    this.client = new associatedBindings.AssociatedInterfacePtrInfo();
  };
  HidService_RegisterClient_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HidService_RegisterClient_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HidService_RegisterClient_Params.client
    err = messageValidator.validateAssociatedInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HidService_RegisterClient_Params.encodedSize = codec.kStructHeaderSize + 8;

  HidService_RegisterClient_Params.decode = function(decoder) {
    var packed;
    var val = new HidService_RegisterClient_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.client =
        decoder.decodeStruct(codec.AssociatedInterfacePtrInfo);
    return val;
  };

  HidService_RegisterClient_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HidService_RegisterClient_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.AssociatedInterfacePtrInfo, val.client);
  };
  function HidService_GetDevices_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HidService_GetDevices_Params.prototype.initDefaults_ = function() {
  };
  HidService_GetDevices_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HidService_GetDevices_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HidService_GetDevices_Params.encodedSize = codec.kStructHeaderSize + 0;

  HidService_GetDevices_Params.decode = function(decoder) {
    var packed;
    var val = new HidService_GetDevices_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  HidService_GetDevices_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HidService_GetDevices_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function HidService_GetDevices_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HidService_GetDevices_ResponseParams.prototype.initDefaults_ = function() {
    this.devices = null;
  };
  HidService_GetDevices_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HidService_GetDevices_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HidService_GetDevices_ResponseParams.devices
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(hid$.HidDeviceInfo), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HidService_GetDevices_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  HidService_GetDevices_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new HidService_GetDevices_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.devices =
        decoder.decodeArrayPointer(new codec.PointerTo(hid$.HidDeviceInfo));
    return val;
  };

  HidService_GetDevices_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HidService_GetDevices_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(hid$.HidDeviceInfo), val.devices);
  };
  function HidService_RequestDevice_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HidService_RequestDevice_Params.prototype.initDefaults_ = function() {
    this.filters = null;
    this.exclusionFilters = null;
  };
  HidService_RequestDevice_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HidService_RequestDevice_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HidService_RequestDevice_Params.filters
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(HidDeviceFilter), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HidService_RequestDevice_Params.exclusionFilters
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(HidDeviceFilter), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HidService_RequestDevice_Params.encodedSize = codec.kStructHeaderSize + 16;

  HidService_RequestDevice_Params.decode = function(decoder) {
    var packed;
    var val = new HidService_RequestDevice_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.filters =
        decoder.decodeArrayPointer(new codec.PointerTo(HidDeviceFilter));
    val.exclusionFilters =
        decoder.decodeArrayPointer(new codec.PointerTo(HidDeviceFilter));
    return val;
  };

  HidService_RequestDevice_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HidService_RequestDevice_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(HidDeviceFilter), val.filters);
    encoder.encodeArrayPointer(new codec.PointerTo(HidDeviceFilter), val.exclusionFilters);
  };
  function HidService_RequestDevice_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HidService_RequestDevice_ResponseParams.prototype.initDefaults_ = function() {
    this.devices = null;
  };
  HidService_RequestDevice_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HidService_RequestDevice_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HidService_RequestDevice_ResponseParams.devices
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(hid$.HidDeviceInfo), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HidService_RequestDevice_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  HidService_RequestDevice_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new HidService_RequestDevice_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.devices =
        decoder.decodeArrayPointer(new codec.PointerTo(hid$.HidDeviceInfo));
    return val;
  };

  HidService_RequestDevice_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HidService_RequestDevice_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(hid$.HidDeviceInfo), val.devices);
  };
  function HidService_Connect_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HidService_Connect_Params.prototype.initDefaults_ = function() {
    this.deviceGuid = null;
    this.client = new hid$.HidConnectionClientPtr();
  };
  HidService_Connect_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HidService_Connect_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HidService_Connect_Params.deviceGuid
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate HidService_Connect_Params.client
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 8, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HidService_Connect_Params.encodedSize = codec.kStructHeaderSize + 16;

  HidService_Connect_Params.decode = function(decoder) {
    var packed;
    var val = new HidService_Connect_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.deviceGuid =
        decoder.decodeStruct(codec.String);
    val.client =
        decoder.decodeStruct(new codec.Interface(hid$.HidConnectionClientPtr));
    return val;
  };

  HidService_Connect_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HidService_Connect_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.deviceGuid);
    encoder.encodeStruct(new codec.Interface(hid$.HidConnectionClientPtr), val.client);
  };
  function HidService_Connect_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HidService_Connect_ResponseParams.prototype.initDefaults_ = function() {
    this.connection = new hid$.HidConnectionPtr();
  };
  HidService_Connect_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HidService_Connect_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HidService_Connect_ResponseParams.connection
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HidService_Connect_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  HidService_Connect_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new HidService_Connect_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.connection =
        decoder.decodeStruct(new codec.NullableInterface(hid$.HidConnectionPtr));
    return val;
  };

  HidService_Connect_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HidService_Connect_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.NullableInterface(hid$.HidConnectionPtr), val.connection);
  };
  function HidService_Forget_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HidService_Forget_Params.prototype.initDefaults_ = function() {
    this.deviceInfo = null;
  };
  HidService_Forget_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HidService_Forget_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HidService_Forget_Params.deviceInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, hid$.HidDeviceInfo, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HidService_Forget_Params.encodedSize = codec.kStructHeaderSize + 8;

  HidService_Forget_Params.decode = function(decoder) {
    var packed;
    var val = new HidService_Forget_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.deviceInfo =
        decoder.decodeStructPointer(hid$.HidDeviceInfo);
    return val;
  };

  HidService_Forget_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HidService_Forget_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(hid$.HidDeviceInfo, val.deviceInfo);
  };
  function HidService_Forget_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HidService_Forget_ResponseParams.prototype.initDefaults_ = function() {
  };
  HidService_Forget_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HidService_Forget_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HidService_Forget_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  HidService_Forget_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new HidService_Forget_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  HidService_Forget_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HidService_Forget_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };

  function DeviceIdFilter(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  DeviceIdFilter.Tags = {
    vendor: 0,
    vendorAndProduct: 1,
  };

  DeviceIdFilter.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  DeviceIdFilter.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "vendor",
        "vendorAndProduct",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a DeviceIdFilter member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(DeviceIdFilter.prototype, "vendor", {
    get: function() {
      if (this.$tag != DeviceIdFilter.Tags.vendor) {
        throw new ReferenceError(
            "DeviceIdFilter.vendor is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = DeviceIdFilter.Tags.vendor;
      this.$data = value;
    }
  });
  Object.defineProperty(DeviceIdFilter.prototype, "vendorAndProduct", {
    get: function() {
      if (this.$tag != DeviceIdFilter.Tags.vendorAndProduct) {
        throw new ReferenceError(
            "DeviceIdFilter.vendorAndProduct is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = DeviceIdFilter.Tags.vendorAndProduct;
      this.$data = value;
    }
  });


    DeviceIdFilter.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case DeviceIdFilter.Tags.vendor:
          encoder.encodeStruct(codec.Uint16, val.vendor);
          break;
        case DeviceIdFilter.Tags.vendorAndProduct:
          encoder.encodeStructPointer(VendorAndProduct, val.vendorAndProduct);
          break;
      }
      encoder.align();
    };


    DeviceIdFilter.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new DeviceIdFilter();
      var tag = decoder.readUint32();
      switch (tag) {
        case DeviceIdFilter.Tags.vendor:
          result.vendor = decoder.decodeStruct(codec.Uint16);
          break;
        case DeviceIdFilter.Tags.vendorAndProduct:
          result.vendorAndProduct = decoder.decodeStructPointer(VendorAndProduct);
          break;
      }
      decoder.align();

      return result;
    };


    DeviceIdFilter.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case DeviceIdFilter.Tags.vendor:
          

          break;
        case DeviceIdFilter.Tags.vendorAndProduct:
          

    // validate DeviceIdFilter.vendorAndProduct
    err = messageValidator.validateStructPointer(data_offset, VendorAndProduct, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  DeviceIdFilter.encodedSize = 16;

  function UsageFilter(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  UsageFilter.Tags = {
    page: 0,
    usageAndPage: 1,
  };

  UsageFilter.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  UsageFilter.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "page",
        "usageAndPage",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a UsageFilter member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(UsageFilter.prototype, "page", {
    get: function() {
      if (this.$tag != UsageFilter.Tags.page) {
        throw new ReferenceError(
            "UsageFilter.page is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = UsageFilter.Tags.page;
      this.$data = value;
    }
  });
  Object.defineProperty(UsageFilter.prototype, "usageAndPage", {
    get: function() {
      if (this.$tag != UsageFilter.Tags.usageAndPage) {
        throw new ReferenceError(
            "UsageFilter.usageAndPage is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = UsageFilter.Tags.usageAndPage;
      this.$data = value;
    }
  });


    UsageFilter.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case UsageFilter.Tags.page:
          encoder.encodeStruct(codec.Uint16, val.page);
          break;
        case UsageFilter.Tags.usageAndPage:
          encoder.encodeStructPointer(hid$.HidUsageAndPage, val.usageAndPage);
          break;
      }
      encoder.align();
    };


    UsageFilter.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new UsageFilter();
      var tag = decoder.readUint32();
      switch (tag) {
        case UsageFilter.Tags.page:
          result.page = decoder.decodeStruct(codec.Uint16);
          break;
        case UsageFilter.Tags.usageAndPage:
          result.usageAndPage = decoder.decodeStructPointer(hid$.HidUsageAndPage);
          break;
      }
      decoder.align();

      return result;
    };


    UsageFilter.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case UsageFilter.Tags.page:
          

          break;
        case UsageFilter.Tags.usageAndPage:
          

    // validate UsageFilter.usageAndPage
    err = messageValidator.validateStructPointer(data_offset, hid$.HidUsageAndPage, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  UsageFilter.encodedSize = 16;
  var kHidService_RegisterClient_Name = 0;
  var kHidService_GetDevices_Name = 1;
  var kHidService_RequestDevice_Name = 2;
  var kHidService_Connect_Name = 3;
  var kHidService_Forget_Name = 4;

  function HidServicePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(HidService,
                                                   handleOrPtrInfo);
  }

  function HidServiceAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        HidService, associatedInterfacePtrInfo);
  }

  HidServiceAssociatedPtr.prototype =
      Object.create(HidServicePtr.prototype);
  HidServiceAssociatedPtr.prototype.constructor =
      HidServiceAssociatedPtr;

  function HidServiceProxy(receiver) {
    this.receiver_ = receiver;
  }
  HidServicePtr.prototype.registerClient = function() {
    return HidServiceProxy.prototype.registerClient
        .apply(this.ptr.getProxy(), arguments);
  };

  HidServiceProxy.prototype.registerClient = function(client) {
    var params_ = new HidService_RegisterClient_Params();
    params_.client = client;
    var builder = new codec.MessageV2Builder(
        kHidService_RegisterClient_Name,
        codec.align(HidService_RegisterClient_Params.encodedSize));
    builder.setPayload(HidService_RegisterClient_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  HidServicePtr.prototype.getDevices = function() {
    return HidServiceProxy.prototype.getDevices
        .apply(this.ptr.getProxy(), arguments);
  };

  HidServiceProxy.prototype.getDevices = function() {
    var params_ = new HidService_GetDevices_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kHidService_GetDevices_Name,
          codec.align(HidService_GetDevices_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(HidService_GetDevices_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(HidService_GetDevices_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  HidServicePtr.prototype.requestDevice = function() {
    return HidServiceProxy.prototype.requestDevice
        .apply(this.ptr.getProxy(), arguments);
  };

  HidServiceProxy.prototype.requestDevice = function(filters, exclusionFilters) {
    var params_ = new HidService_RequestDevice_Params();
    params_.filters = filters;
    params_.exclusionFilters = exclusionFilters;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kHidService_RequestDevice_Name,
          codec.align(HidService_RequestDevice_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(HidService_RequestDevice_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(HidService_RequestDevice_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  HidServicePtr.prototype.connect = function() {
    return HidServiceProxy.prototype.connect
        .apply(this.ptr.getProxy(), arguments);
  };

  HidServiceProxy.prototype.connect = function(deviceGuid, client) {
    var params_ = new HidService_Connect_Params();
    params_.deviceGuid = deviceGuid;
    params_.client = client;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kHidService_Connect_Name,
          codec.align(HidService_Connect_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(HidService_Connect_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(HidService_Connect_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  HidServicePtr.prototype.forget = function() {
    return HidServiceProxy.prototype.forget
        .apply(this.ptr.getProxy(), arguments);
  };

  HidServiceProxy.prototype.forget = function(deviceInfo) {
    var params_ = new HidService_Forget_Params();
    params_.deviceInfo = deviceInfo;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kHidService_Forget_Name,
          codec.align(HidService_Forget_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(HidService_Forget_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(HidService_Forget_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function HidServiceStub(delegate) {
    this.delegate_ = delegate;
  }
  HidServiceStub.prototype.registerClient = function(client) {
    return this.delegate_ && this.delegate_.registerClient && this.delegate_.registerClient(client);
  }
  HidServiceStub.prototype.getDevices = function() {
    return this.delegate_ && this.delegate_.getDevices && this.delegate_.getDevices();
  }
  HidServiceStub.prototype.requestDevice = function(filters, exclusionFilters) {
    return this.delegate_ && this.delegate_.requestDevice && this.delegate_.requestDevice(filters, exclusionFilters);
  }
  HidServiceStub.prototype.connect = function(deviceGuid, client) {
    return this.delegate_ && this.delegate_.connect && this.delegate_.connect(deviceGuid, client);
  }
  HidServiceStub.prototype.forget = function(deviceInfo) {
    return this.delegate_ && this.delegate_.forget && this.delegate_.forget(deviceInfo);
  }

  HidServiceStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kHidService_RegisterClient_Name:
      var params = reader.decodeStruct(HidService_RegisterClient_Params);
      this.registerClient(params.client);
      return true;
    default:
      return false;
    }
  };

  HidServiceStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kHidService_GetDevices_Name:
      var params = reader.decodeStruct(HidService_GetDevices_Params);
      this.getDevices().then(function(response) {
        var responseParams =
            new HidService_GetDevices_ResponseParams();
        responseParams.devices = response.devices;
        var builder = new codec.MessageV1Builder(
            kHidService_GetDevices_Name,
            codec.align(HidService_GetDevices_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(HidService_GetDevices_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kHidService_RequestDevice_Name:
      var params = reader.decodeStruct(HidService_RequestDevice_Params);
      this.requestDevice(params.filters, params.exclusionFilters).then(function(response) {
        var responseParams =
            new HidService_RequestDevice_ResponseParams();
        responseParams.devices = response.devices;
        var builder = new codec.MessageV1Builder(
            kHidService_RequestDevice_Name,
            codec.align(HidService_RequestDevice_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(HidService_RequestDevice_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kHidService_Connect_Name:
      var params = reader.decodeStruct(HidService_Connect_Params);
      this.connect(params.deviceGuid, params.client).then(function(response) {
        var responseParams =
            new HidService_Connect_ResponseParams();
        responseParams.connection = response.connection;
        var builder = new codec.MessageV1Builder(
            kHidService_Connect_Name,
            codec.align(HidService_Connect_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(HidService_Connect_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kHidService_Forget_Name:
      var params = reader.decodeStruct(HidService_Forget_Params);
      this.forget(params.deviceInfo).then(function(response) {
        var responseParams =
            new HidService_Forget_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kHidService_Forget_Name,
            codec.align(HidService_Forget_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(HidService_Forget_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateHidServiceRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kHidService_RegisterClient_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = HidService_RegisterClient_Params;
      break;
      case kHidService_GetDevices_Name:
        if (message.expectsResponse())
          paramsClass = HidService_GetDevices_Params;
      break;
      case kHidService_RequestDevice_Name:
        if (message.expectsResponse())
          paramsClass = HidService_RequestDevice_Params;
      break;
      case kHidService_Connect_Name:
        if (message.expectsResponse())
          paramsClass = HidService_Connect_Params;
      break;
      case kHidService_Forget_Name:
        if (message.expectsResponse())
          paramsClass = HidService_Forget_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateHidServiceResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kHidService_GetDevices_Name:
        if (message.isResponse())
          paramsClass = HidService_GetDevices_ResponseParams;
        break;
      case kHidService_RequestDevice_Name:
        if (message.isResponse())
          paramsClass = HidService_RequestDevice_ResponseParams;
        break;
      case kHidService_Connect_Name:
        if (message.isResponse())
          paramsClass = HidService_Connect_ResponseParams;
        break;
      case kHidService_Forget_Name:
        if (message.isResponse())
          paramsClass = HidService_Forget_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var HidService = {
    name: 'blink.mojom.HidService',
    kVersion: 0,
    ptrClass: HidServicePtr,
    proxyClass: HidServiceProxy,
    stubClass: HidServiceStub,
    validateRequest: validateHidServiceRequest,
    validateResponse: validateHidServiceResponse,
  };
  HidServiceStub.prototype.validator = validateHidServiceRequest;
  HidServiceProxy.prototype.validator = validateHidServiceResponse;
  exports.VendorAndProduct = VendorAndProduct;
  exports.HidDeviceFilter = HidDeviceFilter;
  exports.DeviceIdFilter = DeviceIdFilter;
  exports.UsageFilter = UsageFilter;
  exports.HidService = HidService;
  exports.HidServicePtr = HidServicePtr;
  exports.HidServiceAssociatedPtr = HidServiceAssociatedPtr;
})();