// third_party/blink/public/mojom/handwriting/handwriting.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/handwriting/handwriting.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/handwriting/handwriting.mojom-params-data.h"
#include "third_party/blink/public/mojom/handwriting/handwriting.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/handwriting/handwriting.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/handwriting/handwriting.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace handwriting::mojom::blink {
HandwritingPoint::HandwritingPoint()
    : location(),
      t() {}

HandwritingPoint::HandwritingPoint(
    const ::gfx::PointF& location_in,
    std::optional<::base::TimeDelta> t_in)
    : location(std::move(location_in)),
      t(std::move(t_in)) {}

HandwritingPoint::~HandwritingPoint() = default;

void HandwritingPoint::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "location"), this->location,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::PointF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "t"), this->t,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HandwritingPoint::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HandwritingStroke::HandwritingStroke()
    : points() {}

HandwritingStroke::HandwritingStroke(
    ::blink::Vector<HandwritingPointPtr> points_in)
    : points(std::move(points_in)) {}

HandwritingStroke::~HandwritingStroke() = default;

void HandwritingStroke::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "points"), this->points,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<HandwritingPointPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HandwritingStroke::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HandwritingDrawingSegment::HandwritingDrawingSegment()
    : stroke_index(),
      begin_point_index(),
      end_point_index() {}

HandwritingDrawingSegment::HandwritingDrawingSegment(
    uint32_t stroke_index_in,
    uint32_t begin_point_index_in,
    uint32_t end_point_index_in)
    : stroke_index(std::move(stroke_index_in)),
      begin_point_index(std::move(begin_point_index_in)),
      end_point_index(std::move(end_point_index_in)) {}

HandwritingDrawingSegment::~HandwritingDrawingSegment() = default;
size_t HandwritingDrawingSegment::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->stroke_index);
  seed = mojo::internal::WTFHash(seed, this->begin_point_index);
  seed = mojo::internal::WTFHash(seed, this->end_point_index);
  return seed;
}

void HandwritingDrawingSegment::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stroke_index"), this->stroke_index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "begin_point_index"), this->begin_point_index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "end_point_index"), this->end_point_index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HandwritingDrawingSegment::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HandwritingSegment::HandwritingSegment()
    : grapheme(),
      begin_index(),
      end_index(),
      drawing_segments() {}

HandwritingSegment::HandwritingSegment(
    const ::blink::String& grapheme_in,
    uint32_t begin_index_in,
    uint32_t end_index_in,
    ::blink::Vector<HandwritingDrawingSegmentPtr> drawing_segments_in)
    : grapheme(std::move(grapheme_in)),
      begin_index(std::move(begin_index_in)),
      end_index(std::move(end_index_in)),
      drawing_segments(std::move(drawing_segments_in)) {}

HandwritingSegment::~HandwritingSegment() = default;

void HandwritingSegment::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "grapheme"), this->grapheme,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "begin_index"), this->begin_index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "end_index"), this->end_index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "drawing_segments"), this->drawing_segments,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<HandwritingDrawingSegmentPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HandwritingSegment::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HandwritingPrediction::HandwritingPrediction()
    : text(),
      segmentation_result() {}

HandwritingPrediction::HandwritingPrediction(
    const ::blink::String& text_in,
    ::blink::Vector<HandwritingSegmentPtr> segmentation_result_in)
    : text(std::move(text_in)),
      segmentation_result(std::move(segmentation_result_in)) {}

HandwritingPrediction::~HandwritingPrediction() = default;

void HandwritingPrediction::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text"), this->text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "segmentation_result"), this->segmentation_result,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<HandwritingSegmentPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HandwritingPrediction::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HandwritingHints::HandwritingHints()
    : recognition_type(),
      input_type(),
      text_context(),
      alternatives() {}

HandwritingHints::HandwritingHints(
    const ::blink::String& recognition_type_in,
    const ::blink::String& input_type_in,
    const ::blink::String& text_context_in,
    uint32_t alternatives_in)
    : recognition_type(std::move(recognition_type_in)),
      input_type(std::move(input_type_in)),
      text_context(std::move(text_context_in)),
      alternatives(std::move(alternatives_in)) {}

HandwritingHints::~HandwritingHints() = default;

void HandwritingHints::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "recognition_type"), this->recognition_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_type"), this->input_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text_context"), this->text_context,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "alternatives"), this->alternatives,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HandwritingHints::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HandwritingHintsQueryResult::HandwritingHintsQueryResult()
    : recognition_type(),
      input_type(),
      text_context(),
      alternatives() {}

HandwritingHintsQueryResult::HandwritingHintsQueryResult(
    ::blink::Vector<HandwritingRecognitionType> recognition_type_in,
    ::blink::Vector<HandwritingInputType> input_type_in,
    bool text_context_in,
    bool alternatives_in)
    : recognition_type(std::move(recognition_type_in)),
      input_type(std::move(input_type_in)),
      text_context(std::move(text_context_in)),
      alternatives(std::move(alternatives_in)) {}

HandwritingHintsQueryResult::~HandwritingHintsQueryResult() = default;

void HandwritingHintsQueryResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "recognition_type"), this->recognition_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<HandwritingRecognitionType>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_type"), this->input_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<HandwritingInputType>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text_context"), this->text_context,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "alternatives"), this->alternatives,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HandwritingHintsQueryResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
QueryHandwritingRecognizerResult::QueryHandwritingRecognizerResult()
    : text_alternatives(),
      text_segmentation(),
      hints() {}

QueryHandwritingRecognizerResult::QueryHandwritingRecognizerResult(
    bool text_alternatives_in,
    bool text_segmentation_in,
    HandwritingHintsQueryResultPtr hints_in)
    : text_alternatives(std::move(text_alternatives_in)),
      text_segmentation(std::move(text_segmentation_in)),
      hints(std::move(hints_in)) {}

QueryHandwritingRecognizerResult::~QueryHandwritingRecognizerResult() = default;

void QueryHandwritingRecognizerResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text_alternatives"), this->text_alternatives,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text_segmentation"), this->text_segmentation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hints"), this->hints,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type HandwritingHintsQueryResultPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool QueryHandwritingRecognizerResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HandwritingModelConstraint::HandwritingModelConstraint()
    : languages() {}

HandwritingModelConstraint::HandwritingModelConstraint(
    ::blink::Vector<::blink::String> languages_in)
    : languages(std::move(languages_in)) {}

HandwritingModelConstraint::~HandwritingModelConstraint() = default;

void HandwritingModelConstraint::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "languages"), this->languages,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::blink::String>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HandwritingModelConstraint::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

HandwritingRecognizer::IPCStableHashFunction HandwritingRecognizer::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::HandwritingRecognizer>(message.name())) {
    case messages::HandwritingRecognizer::kGetPrediction: {
      return &HandwritingRecognizer::GetPrediction_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* HandwritingRecognizer::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::HandwritingRecognizer>(message.name())) {
      case messages::HandwritingRecognizer::kGetPrediction:
            return "Receive handwriting::mojom::HandwritingRecognizer::GetPrediction";
    }
  } else {
    switch (static_cast<messages::HandwritingRecognizer>(message.name())) {
      case messages::HandwritingRecognizer::kGetPrediction:
            return "Receive reply handwriting::mojom::HandwritingRecognizer::GetPrediction";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t HandwritingRecognizer::GetPrediction_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x75c1937e;  // IPCStableHash for handwriting::mojom::HandwritingRecognizer::GetPrediction
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class HandwritingRecognizer_GetPrediction_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  HandwritingRecognizer_GetPrediction_ForwardToCallback(
      HandwritingRecognizer::GetPredictionCallback callback
      ) : callback_(std::move(callback)) {
  }

  HandwritingRecognizer_GetPrediction_ForwardToCallback(const HandwritingRecognizer_GetPrediction_ForwardToCallback&) = delete;
  HandwritingRecognizer_GetPrediction_ForwardToCallback& operator=(const HandwritingRecognizer_GetPrediction_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  HandwritingRecognizer::GetPredictionCallback callback_;
};

HandwritingRecognizerProxy::HandwritingRecognizerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void HandwritingRecognizerProxy::GetPrediction(
    ::blink::Vector<HandwritingStrokePtr> in_strokes, HandwritingHintsPtr in_hints, GetPredictionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send handwriting::mojom::HandwritingRecognizer::GetPrediction", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("strokes"), in_strokes,
                        "<value of type ::blink::Vector<HandwritingStrokePtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("hints"), in_hints,
                        "<value of type HandwritingHintsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HandwritingRecognizer::kGetPrediction), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::handwriting::mojom::internal::HandwritingRecognizer_GetPrediction_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->strokes)::BaseType>
      strokes_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& strokes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::handwriting::mojom::HandwritingStrokeDataView>>(
    in_strokes,
    strokes_fragment,
    &strokes_validate_params);

  params->strokes.Set(
      strokes_fragment.is_null() ? nullptr : strokes_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->strokes.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null strokes in HandwritingRecognizer.GetPrediction request");
  mojo::internal::MessageFragment<
      typename decltype(params->hints)::BaseType> hints_fragment(
          params.message());
  
  mojo::internal::Serialize<::handwriting::mojom::HandwritingHintsDataView>(
    in_hints,
    hints_fragment);

  params->hints.Set(
      hints_fragment.is_null() ? nullptr : hints_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->hints.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null hints in HandwritingRecognizer.GetPrediction request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HandwritingRecognizer::Name_);
  message.set_method_name("GetPrediction");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new HandwritingRecognizer_GetPrediction_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class HandwritingRecognizer_GetPrediction_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static HandwritingRecognizer::GetPredictionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<HandwritingRecognizer_GetPrediction_ProxyToResponder> proxy(
        new HandwritingRecognizer_GetPrediction_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&HandwritingRecognizer_GetPrediction_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~HandwritingRecognizer_GetPrediction_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  HandwritingRecognizer_GetPrediction_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "HandwritingRecognizer::GetPredictionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::optional<::blink::Vector<HandwritingPredictionPtr>> in_prediction);
};

bool HandwritingRecognizer_GetPrediction_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::HandwritingRecognizer_GetPrediction_ResponseParams_Data* params =
      reinterpret_cast<
          internal::HandwritingRecognizer_GetPrediction_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for HandwritingRecognizer.0
  bool success = true;
  std::optional<::blink::Vector<HandwritingPredictionPtr>> p_prediction{};
  HandwritingRecognizer_GetPrediction_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPrediction(&p_prediction))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        HandwritingRecognizer::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_prediction));
  }
  return true;
}

void HandwritingRecognizer_GetPrediction_ProxyToResponder::Run(
    std::optional<::blink::Vector<HandwritingPredictionPtr>> in_prediction) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply handwriting::mojom::HandwritingRecognizer::GetPrediction", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("prediction"), in_prediction,
                        "<value of type std::optional<::blink::Vector<HandwritingPredictionPtr>>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HandwritingRecognizer::kGetPrediction), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::handwriting::mojom::internal::HandwritingRecognizer_GetPrediction_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->prediction)::BaseType>
      prediction_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& prediction_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::handwriting::mojom::HandwritingPredictionDataView>>(
    in_prediction,
    prediction_fragment,
    &prediction_validate_params);

  params->prediction.Set(
      prediction_fragment.is_null() ? nullptr : prediction_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HandwritingRecognizer::Name_);
  message.set_method_name("GetPrediction");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool HandwritingRecognizerStubDispatch::Accept(
    HandwritingRecognizer* impl,
    mojo::Message* message) {
  switch (static_cast<messages::HandwritingRecognizer>(message->header()->name)) {
    case messages::HandwritingRecognizer::kGetPrediction: {
      break;
    }
  }
  return false;
}

// static
bool HandwritingRecognizerStubDispatch::AcceptWithResponder(
    HandwritingRecognizer* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::HandwritingRecognizer>(message->header()->name)) {
    case messages::HandwritingRecognizer::kGetPrediction: {
      internal::HandwritingRecognizer_GetPrediction_Params_Data* params =
          reinterpret_cast<
              internal::HandwritingRecognizer_GetPrediction_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for HandwritingRecognizer.0
      bool success = true;
      ::blink::Vector<HandwritingStrokePtr> p_strokes{};
      HandwritingHintsPtr p_hints{};
      HandwritingRecognizer_GetPrediction_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStrokes(&p_strokes))
        success = false;
      if (success && !input_data_view.ReadHints(&p_hints))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HandwritingRecognizer::Name_, 0, false);
        return false;
      }
      auto callback =
          HandwritingRecognizer_GetPrediction_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPrediction(        
        std::move(p_strokes), 
        std::move(p_hints), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kHandwritingRecognizerValidationInfo[] = {
    { &internal::HandwritingRecognizer_GetPrediction_Params_Data::Validate,
     &internal::HandwritingRecognizer_GetPrediction_ResponseParams_Data::Validate},
};

bool HandwritingRecognizerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::handwriting::mojom::blink::HandwritingRecognizer::Name_,
    kHandwritingRecognizerValidationInfo);
}

bool HandwritingRecognizerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::handwriting::mojom::blink::HandwritingRecognizer::Name_,
    kHandwritingRecognizerValidationInfo);
}
// The declaration includes the definition on other builds.

HandwritingRecognitionService::IPCStableHashFunction HandwritingRecognitionService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::HandwritingRecognitionService>(message.name())) {
    case messages::HandwritingRecognitionService::kCreateHandwritingRecognizer: {
      return &HandwritingRecognitionService::CreateHandwritingRecognizer_Sym::IPCStableHash;
    }
    case messages::HandwritingRecognitionService::kQueryHandwritingRecognizer: {
      return &HandwritingRecognitionService::QueryHandwritingRecognizer_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* HandwritingRecognitionService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::HandwritingRecognitionService>(message.name())) {
      case messages::HandwritingRecognitionService::kCreateHandwritingRecognizer:
            return "Receive handwriting::mojom::HandwritingRecognitionService::CreateHandwritingRecognizer";
      case messages::HandwritingRecognitionService::kQueryHandwritingRecognizer:
            return "Receive handwriting::mojom::HandwritingRecognitionService::QueryHandwritingRecognizer";
    }
  } else {
    switch (static_cast<messages::HandwritingRecognitionService>(message.name())) {
      case messages::HandwritingRecognitionService::kCreateHandwritingRecognizer:
            return "Receive reply handwriting::mojom::HandwritingRecognitionService::CreateHandwritingRecognizer";
      case messages::HandwritingRecognitionService::kQueryHandwritingRecognizer:
            return "Receive reply handwriting::mojom::HandwritingRecognitionService::QueryHandwritingRecognizer";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t HandwritingRecognitionService::CreateHandwritingRecognizer_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8da5aa08;  // IPCStableHash for handwriting::mojom::HandwritingRecognitionService::CreateHandwritingRecognizer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t HandwritingRecognitionService::QueryHandwritingRecognizer_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe69f1d2e;  // IPCStableHash for handwriting::mojom::HandwritingRecognitionService::QueryHandwritingRecognizer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class HandwritingRecognitionService_CreateHandwritingRecognizer_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  HandwritingRecognitionService_CreateHandwritingRecognizer_ForwardToCallback(
      HandwritingRecognitionService::CreateHandwritingRecognizerCallback callback
      ) : callback_(std::move(callback)) {
  }

  HandwritingRecognitionService_CreateHandwritingRecognizer_ForwardToCallback(const HandwritingRecognitionService_CreateHandwritingRecognizer_ForwardToCallback&) = delete;
  HandwritingRecognitionService_CreateHandwritingRecognizer_ForwardToCallback& operator=(const HandwritingRecognitionService_CreateHandwritingRecognizer_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  HandwritingRecognitionService::CreateHandwritingRecognizerCallback callback_;
};

class HandwritingRecognitionService_QueryHandwritingRecognizer_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  HandwritingRecognitionService_QueryHandwritingRecognizer_ForwardToCallback(
      HandwritingRecognitionService::QueryHandwritingRecognizerCallback callback
      ) : callback_(std::move(callback)) {
  }

  HandwritingRecognitionService_QueryHandwritingRecognizer_ForwardToCallback(const HandwritingRecognitionService_QueryHandwritingRecognizer_ForwardToCallback&) = delete;
  HandwritingRecognitionService_QueryHandwritingRecognizer_ForwardToCallback& operator=(const HandwritingRecognitionService_QueryHandwritingRecognizer_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  HandwritingRecognitionService::QueryHandwritingRecognizerCallback callback_;
};

HandwritingRecognitionServiceProxy::HandwritingRecognitionServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void HandwritingRecognitionServiceProxy::CreateHandwritingRecognizer(
    HandwritingModelConstraintPtr in_constraint, CreateHandwritingRecognizerCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send handwriting::mojom::HandwritingRecognitionService::CreateHandwritingRecognizer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("constraint"), in_constraint,
                        "<value of type HandwritingModelConstraintPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HandwritingRecognitionService::kCreateHandwritingRecognizer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::handwriting::mojom::internal::HandwritingRecognitionService_CreateHandwritingRecognizer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->constraint)::BaseType> constraint_fragment(
          params.message());
  
  mojo::internal::Serialize<::handwriting::mojom::HandwritingModelConstraintDataView>(
    in_constraint,
    constraint_fragment);

  params->constraint.Set(
      constraint_fragment.is_null() ? nullptr : constraint_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->constraint.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null constraint in HandwritingRecognitionService.CreateHandwritingRecognizer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HandwritingRecognitionService::Name_);
  message.set_method_name("CreateHandwritingRecognizer");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new HandwritingRecognitionService_CreateHandwritingRecognizer_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void HandwritingRecognitionServiceProxy::QueryHandwritingRecognizer(
    HandwritingModelConstraintPtr in_constraint, QueryHandwritingRecognizerCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send handwriting::mojom::HandwritingRecognitionService::QueryHandwritingRecognizer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("constraint"), in_constraint,
                        "<value of type HandwritingModelConstraintPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HandwritingRecognitionService::kQueryHandwritingRecognizer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::handwriting::mojom::internal::HandwritingRecognitionService_QueryHandwritingRecognizer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->constraint)::BaseType> constraint_fragment(
          params.message());
  
  mojo::internal::Serialize<::handwriting::mojom::HandwritingModelConstraintDataView>(
    in_constraint,
    constraint_fragment);

  params->constraint.Set(
      constraint_fragment.is_null() ? nullptr : constraint_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HandwritingRecognitionService::Name_);
  message.set_method_name("QueryHandwritingRecognizer");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new HandwritingRecognitionService_QueryHandwritingRecognizer_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class HandwritingRecognitionService_CreateHandwritingRecognizer_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static HandwritingRecognitionService::CreateHandwritingRecognizerCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<HandwritingRecognitionService_CreateHandwritingRecognizer_ProxyToResponder> proxy(
        new HandwritingRecognitionService_CreateHandwritingRecognizer_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&HandwritingRecognitionService_CreateHandwritingRecognizer_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~HandwritingRecognitionService_CreateHandwritingRecognizer_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  HandwritingRecognitionService_CreateHandwritingRecognizer_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "HandwritingRecognitionService::CreateHandwritingRecognizerCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      CreateHandwritingRecognizerResult in_result, ::mojo::PendingRemote<HandwritingRecognizer> in_handwriting_recognizer);
};

bool HandwritingRecognitionService_CreateHandwritingRecognizer_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::HandwritingRecognitionService_CreateHandwritingRecognizer_ResponseParams_Data* params =
      reinterpret_cast<
          internal::HandwritingRecognitionService_CreateHandwritingRecognizer_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for HandwritingRecognitionService.0
  bool success = true;
  CreateHandwritingRecognizerResult p_result{};
  ::mojo::PendingRemote<HandwritingRecognizer> p_handwriting_recognizer{};
  HandwritingRecognitionService_CreateHandwritingRecognizer_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success) {
    p_handwriting_recognizer =
        input_data_view.TakeHandwritingRecognizer<decltype(p_handwriting_recognizer)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        HandwritingRecognitionService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_handwriting_recognizer));
  }
  return true;
}

void HandwritingRecognitionService_CreateHandwritingRecognizer_ProxyToResponder::Run(
    CreateHandwritingRecognizerResult in_result, ::mojo::PendingRemote<HandwritingRecognizer> in_handwriting_recognizer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply handwriting::mojom::HandwritingRecognitionService::CreateHandwritingRecognizer", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type CreateHandwritingRecognizerResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handwriting_recognizer"), in_handwriting_recognizer,
                        "<value of type ::mojo::PendingRemote<HandwritingRecognizer>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HandwritingRecognitionService::kCreateHandwritingRecognizer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::handwriting::mojom::internal::HandwritingRecognitionService_CreateHandwritingRecognizer_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::handwriting::mojom::CreateHandwritingRecognizerResult>(
    in_result,
    &params->result);

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::handwriting::mojom::HandwritingRecognizerInterfaceBase>>(
    in_handwriting_recognizer,
    &params->handwriting_recognizer,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HandwritingRecognitionService::Name_);
  message.set_method_name("CreateHandwritingRecognizer");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class HandwritingRecognitionService_QueryHandwritingRecognizer_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static HandwritingRecognitionService::QueryHandwritingRecognizerCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<HandwritingRecognitionService_QueryHandwritingRecognizer_ProxyToResponder> proxy(
        new HandwritingRecognitionService_QueryHandwritingRecognizer_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&HandwritingRecognitionService_QueryHandwritingRecognizer_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~HandwritingRecognitionService_QueryHandwritingRecognizer_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  HandwritingRecognitionService_QueryHandwritingRecognizer_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "HandwritingRecognitionService::QueryHandwritingRecognizerCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      QueryHandwritingRecognizerResultPtr in_result);
};

bool HandwritingRecognitionService_QueryHandwritingRecognizer_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::HandwritingRecognitionService_QueryHandwritingRecognizer_ResponseParams_Data* params =
      reinterpret_cast<
          internal::HandwritingRecognitionService_QueryHandwritingRecognizer_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for HandwritingRecognitionService.1
  bool success = true;
  QueryHandwritingRecognizerResultPtr p_result{};
  HandwritingRecognitionService_QueryHandwritingRecognizer_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        HandwritingRecognitionService::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void HandwritingRecognitionService_QueryHandwritingRecognizer_ProxyToResponder::Run(
    QueryHandwritingRecognizerResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply handwriting::mojom::HandwritingRecognitionService::QueryHandwritingRecognizer", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type QueryHandwritingRecognizerResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HandwritingRecognitionService::kQueryHandwritingRecognizer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::handwriting::mojom::internal::HandwritingRecognitionService_QueryHandwritingRecognizer_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::handwriting::mojom::QueryHandwritingRecognizerResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HandwritingRecognitionService::Name_);
  message.set_method_name("QueryHandwritingRecognizer");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool HandwritingRecognitionServiceStubDispatch::Accept(
    HandwritingRecognitionService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::HandwritingRecognitionService>(message->header()->name)) {
    case messages::HandwritingRecognitionService::kCreateHandwritingRecognizer: {
      break;
    }
    case messages::HandwritingRecognitionService::kQueryHandwritingRecognizer: {
      break;
    }
  }
  return false;
}

// static
bool HandwritingRecognitionServiceStubDispatch::AcceptWithResponder(
    HandwritingRecognitionService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::HandwritingRecognitionService>(message->header()->name)) {
    case messages::HandwritingRecognitionService::kCreateHandwritingRecognizer: {
      internal::HandwritingRecognitionService_CreateHandwritingRecognizer_Params_Data* params =
          reinterpret_cast<
              internal::HandwritingRecognitionService_CreateHandwritingRecognizer_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for HandwritingRecognitionService.0
      bool success = true;
      HandwritingModelConstraintPtr p_constraint{};
      HandwritingRecognitionService_CreateHandwritingRecognizer_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConstraint(&p_constraint))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HandwritingRecognitionService::Name_, 0, false);
        return false;
      }
      auto callback =
          HandwritingRecognitionService_CreateHandwritingRecognizer_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateHandwritingRecognizer(        
        std::move(p_constraint), std::move(callback));
      return true;
    }
    case messages::HandwritingRecognitionService::kQueryHandwritingRecognizer: {
      internal::HandwritingRecognitionService_QueryHandwritingRecognizer_Params_Data* params =
          reinterpret_cast<
              internal::HandwritingRecognitionService_QueryHandwritingRecognizer_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for HandwritingRecognitionService.1
      bool success = true;
      HandwritingModelConstraintPtr p_constraint{};
      HandwritingRecognitionService_QueryHandwritingRecognizer_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConstraint(&p_constraint))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HandwritingRecognitionService::Name_, 1, false);
        return false;
      }
      auto callback =
          HandwritingRecognitionService_QueryHandwritingRecognizer_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueryHandwritingRecognizer(        
        std::move(p_constraint), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kHandwritingRecognitionServiceValidationInfo[] = {
    { &internal::HandwritingRecognitionService_CreateHandwritingRecognizer_Params_Data::Validate,
     &internal::HandwritingRecognitionService_CreateHandwritingRecognizer_ResponseParams_Data::Validate},
    { &internal::HandwritingRecognitionService_QueryHandwritingRecognizer_Params_Data::Validate,
     &internal::HandwritingRecognitionService_QueryHandwritingRecognizer_ResponseParams_Data::Validate},
};

bool HandwritingRecognitionServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::handwriting::mojom::blink::HandwritingRecognitionService::Name_,
    kHandwritingRecognitionServiceValidationInfo);
}

bool HandwritingRecognitionServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::handwriting::mojom::blink::HandwritingRecognitionService::Name_,
    kHandwritingRecognitionServiceValidationInfo);
}


}  // handwriting::mojom::blink


namespace mojo {


// static
bool StructTraits<::handwriting::mojom::blink::HandwritingPoint::DataView, ::handwriting::mojom::blink::HandwritingPointPtr>::Read(
    ::handwriting::mojom::blink::HandwritingPoint::DataView input,
    ::handwriting::mojom::blink::HandwritingPointPtr* output) {
  bool success = true;
  ::handwriting::mojom::blink::HandwritingPointPtr result(::handwriting::mojom::blink::HandwritingPoint::New());
  
      if (success && !input.ReadLocation(&result->location))
        success = false;
      if (success && !input.ReadT(&result->t))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::handwriting::mojom::blink::HandwritingStroke::DataView, ::handwriting::mojom::blink::HandwritingStrokePtr>::Read(
    ::handwriting::mojom::blink::HandwritingStroke::DataView input,
    ::handwriting::mojom::blink::HandwritingStrokePtr* output) {
  bool success = true;
  ::handwriting::mojom::blink::HandwritingStrokePtr result(::handwriting::mojom::blink::HandwritingStroke::New());
  
      if (success && !input.ReadPoints(&result->points))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::handwriting::mojom::blink::HandwritingDrawingSegment::DataView, ::handwriting::mojom::blink::HandwritingDrawingSegmentPtr>::Read(
    ::handwriting::mojom::blink::HandwritingDrawingSegment::DataView input,
    ::handwriting::mojom::blink::HandwritingDrawingSegmentPtr* output) {
  bool success = true;
  ::handwriting::mojom::blink::HandwritingDrawingSegmentPtr result(::handwriting::mojom::blink::HandwritingDrawingSegment::New());
  
      if (success)
        result->stroke_index = input.stroke_index();
      if (success)
        result->begin_point_index = input.begin_point_index();
      if (success)
        result->end_point_index = input.end_point_index();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::handwriting::mojom::blink::HandwritingSegment::DataView, ::handwriting::mojom::blink::HandwritingSegmentPtr>::Read(
    ::handwriting::mojom::blink::HandwritingSegment::DataView input,
    ::handwriting::mojom::blink::HandwritingSegmentPtr* output) {
  bool success = true;
  ::handwriting::mojom::blink::HandwritingSegmentPtr result(::handwriting::mojom::blink::HandwritingSegment::New());
  
      if (success && !input.ReadGrapheme(&result->grapheme))
        success = false;
      if (success)
        result->begin_index = input.begin_index();
      if (success)
        result->end_index = input.end_index();
      if (success && !input.ReadDrawingSegments(&result->drawing_segments))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::handwriting::mojom::blink::HandwritingPrediction::DataView, ::handwriting::mojom::blink::HandwritingPredictionPtr>::Read(
    ::handwriting::mojom::blink::HandwritingPrediction::DataView input,
    ::handwriting::mojom::blink::HandwritingPredictionPtr* output) {
  bool success = true;
  ::handwriting::mojom::blink::HandwritingPredictionPtr result(::handwriting::mojom::blink::HandwritingPrediction::New());
  
      if (success && !input.ReadText(&result->text))
        success = false;
      if (success && !input.ReadSegmentationResult(&result->segmentation_result))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::handwriting::mojom::blink::HandwritingHints::DataView, ::handwriting::mojom::blink::HandwritingHintsPtr>::Read(
    ::handwriting::mojom::blink::HandwritingHints::DataView input,
    ::handwriting::mojom::blink::HandwritingHintsPtr* output) {
  bool success = true;
  ::handwriting::mojom::blink::HandwritingHintsPtr result(::handwriting::mojom::blink::HandwritingHints::New());
  
      if (success && !input.ReadRecognitionType(&result->recognition_type))
        success = false;
      if (success && !input.ReadInputType(&result->input_type))
        success = false;
      if (success && !input.ReadTextContext(&result->text_context))
        success = false;
      if (success)
        result->alternatives = input.alternatives();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::handwriting::mojom::blink::HandwritingHintsQueryResult::DataView, ::handwriting::mojom::blink::HandwritingHintsQueryResultPtr>::Read(
    ::handwriting::mojom::blink::HandwritingHintsQueryResult::DataView input,
    ::handwriting::mojom::blink::HandwritingHintsQueryResultPtr* output) {
  bool success = true;
  ::handwriting::mojom::blink::HandwritingHintsQueryResultPtr result(::handwriting::mojom::blink::HandwritingHintsQueryResult::New());
  
      if (success && !input.ReadRecognitionType(&result->recognition_type))
        success = false;
      if (success && !input.ReadInputType(&result->input_type))
        success = false;
      if (success)
        result->text_context = input.text_context();
      if (success)
        result->alternatives = input.alternatives();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::handwriting::mojom::blink::QueryHandwritingRecognizerResult::DataView, ::handwriting::mojom::blink::QueryHandwritingRecognizerResultPtr>::Read(
    ::handwriting::mojom::blink::QueryHandwritingRecognizerResult::DataView input,
    ::handwriting::mojom::blink::QueryHandwritingRecognizerResultPtr* output) {
  bool success = true;
  ::handwriting::mojom::blink::QueryHandwritingRecognizerResultPtr result(::handwriting::mojom::blink::QueryHandwritingRecognizerResult::New());
  
      if (success)
        result->text_alternatives = input.text_alternatives();
      if (success)
        result->text_segmentation = input.text_segmentation();
      if (success && !input.ReadHints(&result->hints))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::handwriting::mojom::blink::HandwritingModelConstraint::DataView, ::handwriting::mojom::blink::HandwritingModelConstraintPtr>::Read(
    ::handwriting::mojom::blink::HandwritingModelConstraint::DataView input,
    ::handwriting::mojom::blink::HandwritingModelConstraintPtr* output) {
  bool success = true;
  ::handwriting::mojom::blink::HandwritingModelConstraintPtr result(::handwriting::mojom::blink::HandwritingModelConstraint::New());
  
      if (success && !input.ReadLanguages(&result->languages))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace handwriting::mojom::blink {


void HandwritingRecognizerInterceptorForTesting::GetPrediction(::blink::Vector<HandwritingStrokePtr> strokes, HandwritingHintsPtr hints, GetPredictionCallback callback) {
  GetForwardingInterface()->GetPrediction(
    std::move(strokes)
    , 
    std::move(hints)
    , std::move(callback));
}
HandwritingRecognizerAsyncWaiter::HandwritingRecognizerAsyncWaiter(
    HandwritingRecognizer* proxy) : proxy_(proxy) {}

HandwritingRecognizerAsyncWaiter::~HandwritingRecognizerAsyncWaiter() = default;


void HandwritingRecognizerAsyncWaiter::GetPrediction(
    ::blink::Vector<HandwritingStrokePtr> strokes, HandwritingHintsPtr hints, std::optional<::blink::Vector<HandwritingPredictionPtr>>* out_prediction) {
  base::RunLoop loop;
  proxy_->GetPrediction(
      std::move(strokes),
      std::move(hints),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::blink::Vector<HandwritingPredictionPtr>>* out_prediction
,
             std::optional<::blink::Vector<HandwritingPredictionPtr>> prediction) {*out_prediction = std::move(prediction);
            loop->Quit();
          },
          &loop,
          out_prediction));
  loop.Run();
}

std::optional<::blink::Vector<HandwritingPredictionPtr>> HandwritingRecognizerAsyncWaiter::GetPrediction(
    ::blink::Vector<HandwritingStrokePtr> strokes, HandwritingHintsPtr hints) {
  std::optional<::blink::Vector<HandwritingPredictionPtr>> async_wait_result;
  GetPrediction(std::move(strokes),std::move(hints),&async_wait_result);
  return async_wait_result;
}




void HandwritingRecognitionServiceInterceptorForTesting::CreateHandwritingRecognizer(HandwritingModelConstraintPtr constraint, CreateHandwritingRecognizerCallback callback) {
  GetForwardingInterface()->CreateHandwritingRecognizer(
    std::move(constraint)
    , std::move(callback));
}
void HandwritingRecognitionServiceInterceptorForTesting::QueryHandwritingRecognizer(HandwritingModelConstraintPtr constraint, QueryHandwritingRecognizerCallback callback) {
  GetForwardingInterface()->QueryHandwritingRecognizer(
    std::move(constraint)
    , std::move(callback));
}
HandwritingRecognitionServiceAsyncWaiter::HandwritingRecognitionServiceAsyncWaiter(
    HandwritingRecognitionService* proxy) : proxy_(proxy) {}

HandwritingRecognitionServiceAsyncWaiter::~HandwritingRecognitionServiceAsyncWaiter() = default;


void HandwritingRecognitionServiceAsyncWaiter::CreateHandwritingRecognizer(
    HandwritingModelConstraintPtr constraint, CreateHandwritingRecognizerResult* out_result, ::mojo::PendingRemote<HandwritingRecognizer>* out_handwriting_recognizer) {
  base::RunLoop loop;
  proxy_->CreateHandwritingRecognizer(
      std::move(constraint),
      base::BindOnce(
          [](base::RunLoop* loop,
             CreateHandwritingRecognizerResult* out_result
,
             ::mojo::PendingRemote<HandwritingRecognizer>* out_handwriting_recognizer
,
             CreateHandwritingRecognizerResult result,
             ::mojo::PendingRemote<HandwritingRecognizer> handwriting_recognizer) {*out_result = std::move(result);*out_handwriting_recognizer = std::move(handwriting_recognizer);
            loop->Quit();
          },
          &loop,
          out_result,
          out_handwriting_recognizer));
  loop.Run();
}



void HandwritingRecognitionServiceAsyncWaiter::QueryHandwritingRecognizer(
    HandwritingModelConstraintPtr constraint, QueryHandwritingRecognizerResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->QueryHandwritingRecognizer(
      std::move(constraint),
      base::BindOnce(
          [](base::RunLoop* loop,
             QueryHandwritingRecognizerResultPtr* out_result
,
             QueryHandwritingRecognizerResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

QueryHandwritingRecognizerResultPtr HandwritingRecognitionServiceAsyncWaiter::QueryHandwritingRecognizer(
    HandwritingModelConstraintPtr constraint) {
  QueryHandwritingRecognizerResultPtr async_wait_result;
  QueryHandwritingRecognizer(std::move(constraint),&async_wait_result);
  return async_wait_result;
}






}  // handwriting::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif