// third_party/blink/public/mojom/gpu/gpu.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_GPU_GPU_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_GPU_GPU_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/gpu/gpu.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/gpu/gpu.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/gpu/gpu.mojom-forward.h"  // IWYU pragma: export
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "base/component_export.h"




namespace blink::mojom {

class GpuDataManagerProxy;

template <typename ImplRefTraits>
class GpuDataManagerStub;

class GpuDataManagerRequestValidator;
class GpuDataManagerResponseValidator;


class COMPONENT_EXPORT(BLINK_GPU_MOJOM) GpuDataManager
    : public GpuDataManagerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.GpuDataManager";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    0
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = GpuDataManagerInterfaceBase;
  using Proxy_ = GpuDataManagerProxy;

  template <typename ImplRefTraits>
  using Stub_ = GpuDataManagerStub<ImplRefTraits>;

  using RequestValidator_ = GpuDataManagerRequestValidator;
  using ResponseValidator_ = GpuDataManagerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kAre3DAPIsBlockedForUrlMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Are3DAPIsBlockedForUrl_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~GpuDataManager() = default;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool Are3DAPIsBlockedForUrl(const ::GURL& url, bool* out_blocked);
  using Are3DAPIsBlockedForUrlCallback = base::OnceCallback<void(bool)>;
  using Are3DAPIsBlockedForUrlMojoCallback = base::OnceCallback<void(bool)>;

  virtual void Are3DAPIsBlockedForUrl(const ::GURL& url, Are3DAPIsBlockedForUrlCallback callback) = 0;
};



class COMPONENT_EXPORT(BLINK_GPU_MOJOM) GpuDataManagerProxy
    : public GpuDataManager {
 public:
  using InterfaceType = GpuDataManager;

  explicit GpuDataManagerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool Are3DAPIsBlockedForUrl(const ::GURL& url, bool* out_blocked) final;
  
  void Are3DAPIsBlockedForUrl(const ::GURL& url, Are3DAPIsBlockedForUrlCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class COMPONENT_EXPORT(BLINK_GPU_MOJOM) GpuDataManagerStubDispatch {
 public:
  static bool Accept(GpuDataManager* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      GpuDataManager* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<GpuDataManager>>
class GpuDataManagerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  GpuDataManagerStub() = default;
  ~GpuDataManagerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GpuDataManagerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GpuDataManagerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(BLINK_GPU_MOJOM) GpuDataManagerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(BLINK_GPU_MOJOM) GpuDataManagerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // blink::mojom

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_GPU_GPU_MOJOM_H_