// third_party/blink/public/mojom/frame/viewport_intersection_state.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/frame/viewport_intersection_state.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/frame/viewport_intersection_state.mojom-params-data.h"
#include "third_party/blink/public/mojom/frame/viewport_intersection_state.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/frame/viewport_intersection_state.mojom-import-headers.h"
#include "third_party/blink/public/mojom/frame/viewport_intersection_state.mojom-test-utils.h"


namespace blink::mojom {
ViewportIntersectionState::ViewportIntersectionState()
    : viewport_intersection(),
      main_frame_intersection(),
      compositor_visible_rect(),
      occlusion_state(FrameOcclusionState::kUnknown),
      outermost_main_frame_size(),
      outermost_main_frame_scroll_position(),
      main_frame_transform() {}

ViewportIntersectionState::ViewportIntersectionState(
    const ::gfx::Rect& viewport_intersection_in,
    const ::gfx::Rect& main_frame_intersection_in,
    const ::gfx::Rect& compositor_visible_rect_in,
    FrameOcclusionState occlusion_state_in,
    const ::gfx::Size& outermost_main_frame_size_in,
    const ::gfx::Point& outermost_main_frame_scroll_position_in,
    const ::gfx::Transform& main_frame_transform_in)
    : viewport_intersection(std::move(viewport_intersection_in)),
      main_frame_intersection(std::move(main_frame_intersection_in)),
      compositor_visible_rect(std::move(compositor_visible_rect_in)),
      occlusion_state(std::move(occlusion_state_in)),
      outermost_main_frame_size(std::move(outermost_main_frame_size_in)),
      outermost_main_frame_scroll_position(std::move(outermost_main_frame_scroll_position_in)),
      main_frame_transform(std::move(main_frame_transform_in)) {}

ViewportIntersectionState::~ViewportIntersectionState() = default;

void ViewportIntersectionState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "viewport_intersection"), this->viewport_intersection,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "main_frame_intersection"), this->main_frame_intersection,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "compositor_visible_rect"), this->compositor_visible_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "occlusion_state"), this->occlusion_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type FrameOcclusionState>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "outermost_main_frame_size"), this->outermost_main_frame_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "outermost_main_frame_scroll_position"), this->outermost_main_frame_scroll_position,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Point&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "main_frame_transform"), this->main_frame_transform,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Transform&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ViewportIntersectionState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::ViewportIntersectionState::DataView, ::blink::mojom::ViewportIntersectionStatePtr>::Read(
    ::blink::mojom::ViewportIntersectionState::DataView input,
    ::blink::mojom::ViewportIntersectionStatePtr* output) {
  bool success = true;
  ::blink::mojom::ViewportIntersectionStatePtr result(::blink::mojom::ViewportIntersectionState::New());
  
      if (success && !input.ReadViewportIntersection(&result->viewport_intersection))
        success = false;
      if (success && !input.ReadMainFrameIntersection(&result->main_frame_intersection))
        success = false;
      if (success && !input.ReadCompositorVisibleRect(&result->compositor_visible_rect))
        success = false;
      if (success && !input.ReadOcclusionState(&result->occlusion_state))
        success = false;
      if (success && !input.ReadOutermostMainFrameSize(&result->outermost_main_frame_size))
        success = false;
      if (success && !input.ReadOutermostMainFrameScrollPosition(&result->outermost_main_frame_scroll_position))
        success = false;
      if (success && !input.ReadMainFrameTransform(&result->main_frame_transform))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {




}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif