// third_party/blink/public/mojom/frame/remote_frame.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  RenderFrameMetadata as cc_mojom_RenderFrameMetadata,
  RenderFrameMetadataSpec as cc_mojom_RenderFrameMetadataSpec
} from '../../../../../cc/mojom/render_frame_metadata.mojom.m.js';

import {
  TouchAction as cc_mojom_TouchAction,
  TouchActionSpec as cc_mojom_TouchActionSpec
} from '../../../../../cc/mojom/touch_action.mojom.m.js';

import {
  String16 as mojoBase_mojom_String16,
  String16Spec as mojoBase_mojom_String16Spec
} from '../../../../../mojo/public/mojom/base/string16.mojom.m.js';

import {
  TimeTicks as mojoBase_mojom_TimeTicks,
  TimeTicksSpec as mojoBase_mojom_TimeTicksSpec
} from '../../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  UnguessableToken as mojoBase_mojom_UnguessableToken,
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec
} from '../../../../../mojo/public/mojom/base/unguessable_token.mojom.m.js';

import {
  ParsedPermissionsPolicyDeclaration as network_mojom_ParsedPermissionsPolicyDeclaration,
  ParsedPermissionsPolicyDeclarationSpec as network_mojom_ParsedPermissionsPolicyDeclarationSpec
} from '../../../../../services/network/public/mojom/permissions_policy/permissions_policy.mojom.m.js';

import {
  SourceLocation as network_mojom_SourceLocation,
  SourceLocationSpec as network_mojom_SourceLocationSpec
} from '../../../../../services/network/public/mojom/source_location.mojom.m.js';

import {
  StorageAccessApiStatus as network_mojom_StorageAccessApiStatus,
  StorageAccessApiStatusSpec as network_mojom_StorageAccessApiStatusSpec
} from '../../../../../services/network/public/mojom/storage_access_api.mojom.m.js';

import {
  URLRequestBody as network_mojom_URLRequestBody,
  URLRequestBodySpec as network_mojom_URLRequestBodySpec
} from '../../../../../services/network/public/mojom/url_request.mojom.m.js';

import {
  WebSandboxFlags as network_mojom_WebSandboxFlags,
  WebSandboxFlagsSpec as network_mojom_WebSandboxFlagsSpec
} from '../../../../../services/network/public/mojom/web_sandbox_flags.mojom.m.js';

import {
  FrameSinkId as viz_mojom_FrameSinkId,
  FrameSinkIdSpec as viz_mojom_FrameSinkIdSpec
} from '../../../../../services/viz/public/mojom/compositing/frame_sink_id.mojom.m.js';

import {
  WindowOpenDisposition as ui_mojom_WindowOpenDisposition,
  WindowOpenDispositionSpec as ui_mojom_WindowOpenDispositionSpec
} from '../../../../../ui/base/mojom/window_open_disposition.mojom.m.js';

import {
  ScrollGranularity as ui_mojom_ScrollGranularity,
  ScrollGranularitySpec as ui_mojom_ScrollGranularitySpec
} from '../../../../../ui/events/mojom/scroll_granularity.mojom.m.js';

import {
  Rect as gfx_mojom_Rect,
  RectSpec as gfx_mojom_RectSpec,
  RectF as gfx_mojom_RectF,
  RectFSpec as gfx_mojom_RectFSpec,
  Size as gfx_mojom_Size,
  SizeSpec as gfx_mojom_SizeSpec
} from '../../../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';

import {
  Origin as url_mojom_Origin,
  OriginSpec as url_mojom_OriginSpec
} from '../../../../../url/mojom/origin.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';

import {
  BlobURLTokenRemote as blink_mojom_BlobURLTokenRemote,
  BlobURLTokenPendingReceiver as blink_mojom_BlobURLTokenPendingReceiver
} from '../blob/blob_url_store.mojom.m.js';

import {
  Impression as blink_mojom_Impression,
  ImpressionSpec as blink_mojom_ImpressionSpec
} from '../conversions/conversions.mojom.m.js';

import {
  FocusType as blink_mojom_FocusType,
  FocusTypeSpec as blink_mojom_FocusTypeSpec
} from '../input/focus_type.mojom.m.js';

import {
  ScrollDirection as blink_mojom_ScrollDirection,
  ScrollDirectionSpec as blink_mojom_ScrollDirectionSpec
} from '../input/scroll_direction.mojom.m.js';

import {
  Referrer as blink_mojom_Referrer,
  ReferrerSpec as blink_mojom_ReferrerSpec
} from '../loader/referrer.mojom.m.js';

import {
  TransferableMessage as blink_mojom_TransferableMessage,
  TransferableMessageSpec as blink_mojom_TransferableMessageSpec
} from '../messaging/transferable_message.mojom.m.js';

import {
  NavigationInitiatorActivationAndAdStatus as blink_mojom_NavigationInitiatorActivationAndAdStatus,
  NavigationInitiatorActivationAndAdStatusSpec as blink_mojom_NavigationInitiatorActivationAndAdStatusSpec
} from '../navigation/navigation_initiator_activation_and_ad_status.mojom.m.js';

import {
  NavigationDownloadPolicy as blink_mojom_NavigationDownloadPolicy,
  NavigationDownloadPolicySpec as blink_mojom_NavigationDownloadPolicySpec
} from '../navigation/navigation_policy.mojom.m.js';

import {
  ScrollIntoViewParams as blink_mojom_ScrollIntoViewParams,
  ScrollIntoViewParamsSpec as blink_mojom_ScrollIntoViewParamsSpec
} from '../scroll/scroll_into_view_params.mojom.m.js';

import {
  InsecureRequestPolicy as blink_mojom_InsecureRequestPolicy,
  InsecureRequestPolicySpec as blink_mojom_InsecureRequestPolicySpec
} from '../security_context/insecure_request_policy.mojom.m.js';

import {
  ResourceTimingInfo as blink_mojom_ResourceTimingInfo,
  ResourceTimingInfoSpec as blink_mojom_ResourceTimingInfoSpec
} from '../timing/resource_timing.mojom.m.js';

import {
  LocalFrameToken as blink_mojom_LocalFrameToken,
  LocalFrameTokenSpec as blink_mojom_LocalFrameTokenSpec,
  RemoteFrameToken as blink_mojom_RemoteFrameToken,
  RemoteFrameTokenSpec as blink_mojom_RemoteFrameTokenSpec,
  FrameToken as blink_mojom_FrameToken,
  FrameTokenSpec as blink_mojom_FrameTokenSpec
} from '../tokens/tokens.mojom.m.js';

import {
  FrameOwnerProperties as blink_mojom_FrameOwnerProperties,
  FrameOwnerPropertiesSpec as blink_mojom_FrameOwnerPropertiesSpec
} from './frame_owner_properties.mojom.m.js';

import {
  FramePolicy as blink_mojom_FramePolicy,
  FramePolicySpec as blink_mojom_FramePolicySpec
} from './frame_policy.mojom.m.js';

import {
  FrameReplicationState as blink_mojom_FrameReplicationState,
  FrameReplicationStateSpec as blink_mojom_FrameReplicationStateSpec
} from './frame_replication_state.mojom.m.js';

import {
  FrameVisualProperties as blink_mojom_FrameVisualProperties,
  FrameVisualPropertiesSpec as blink_mojom_FrameVisualPropertiesSpec
} from './frame_visual_properties.mojom.m.js';

import {
  FullscreenOptions as blink_mojom_FullscreenOptions,
  FullscreenOptionsSpec as blink_mojom_FullscreenOptionsSpec
} from './fullscreen.mojom.m.js';

import {
  IntrinsicSizingInfo as blink_mojom_IntrinsicSizingInfo,
  IntrinsicSizingInfoSpec as blink_mojom_IntrinsicSizingInfoSpec
} from './intrinsic_sizing_info.mojom.m.js';

import {
  FrameVisibility as blink_mojom_FrameVisibility,
  FrameVisibilitySpec as blink_mojom_FrameVisibilitySpec
} from './lifecycle.mojom.m.js';

import {
  TextAutosizerPageInfo as blink_mojom_TextAutosizerPageInfo,
  TextAutosizerPageInfoSpec as blink_mojom_TextAutosizerPageInfoSpec
} from './text_autosizer_page_info.mojom.m.js';

import {
  TreeScopeType as blink_mojom_TreeScopeType,
  TreeScopeTypeSpec as blink_mojom_TreeScopeTypeSpec
} from './tree_scope_type.mojom.m.js';

import {
  TriggeringEventInfo as blink_mojom_TriggeringEventInfo,
  TriggeringEventInfoSpec as blink_mojom_TriggeringEventInfoSpec
} from './triggering_event_info.mojom.m.js';

import {
  UserActivationNotificationType as blink_mojom_UserActivationNotificationType,
  UserActivationNotificationTypeSpec as blink_mojom_UserActivationNotificationTypeSpec
} from './user_activation_notification_type.mojom.m.js';

import {
  UserActivationUpdateType as blink_mojom_UserActivationUpdateType,
  UserActivationUpdateTypeSpec as blink_mojom_UserActivationUpdateTypeSpec
} from './user_activation_update_types.mojom.m.js';

import {
  ViewportIntersectionState as blink_mojom_ViewportIntersectionState,
  ViewportIntersectionStateSpec as blink_mojom_ViewportIntersectionStateSpec
} from './viewport_intersection_state.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class NavigationStateKeepAliveHandlePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.NavigationStateKeepAliveHandle', scope);
  }
}

/** @interface */
export class NavigationStateKeepAliveHandleInterface {
}

/**
 * @implements { NavigationStateKeepAliveHandleInterface }
 */
export class NavigationStateKeepAliveHandleRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!NavigationStateKeepAliveHandlePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          NavigationStateKeepAliveHandlePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!NavigationStateKeepAliveHandlePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }
}

/**
 * An object which receives request messages for the NavigationStateKeepAliveHandle
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class NavigationStateKeepAliveHandleReceiver {
  /**
   * @param {!NavigationStateKeepAliveHandleInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!NavigationStateKeepAliveHandleRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        NavigationStateKeepAliveHandleRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!NavigationStateKeepAliveHandleRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class NavigationStateKeepAliveHandle {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.NavigationStateKeepAliveHandle";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!NavigationStateKeepAliveHandleRemote}
   */
  static getRemote() {
    let remote = new NavigationStateKeepAliveHandleRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the NavigationStateKeepAliveHandle
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class NavigationStateKeepAliveHandleCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      NavigationStateKeepAliveHandleRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!NavigationStateKeepAliveHandleRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class RemoteFrameHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.RemoteFrameHost', scope);
  }
}

/** @interface */
export class RemoteFrameHostInterface {
  
  /**
   * @param { !cc_mojom_TouchAction } touchAction
   */

  setInheritedEffectiveTouchAction(touchAction) {}
  
  /**
   * @param { !boolean } isThrottled
   * @param { !boolean } subtreeThrottled
   * @param { !boolean } displayLocked
   */

  updateRenderThrottlingStatus(isThrottled, subtreeThrottled, displayLocked) {}
  
  /**
   * @param { !blink_mojom_FrameVisibility } visibility
   */

  visibilityChanged(visibility) {}
  
  /**
   */

  didFocusFrame() {}
  
  /**
   */

  checkCompleted() {}
  
  /**
   * @param { !gfx_mojom_Rect } clipRect
   * @param { !mojoBase_mojom_UnguessableToken } guid
   */

  capturePaintPreviewOfCrossProcessSubframe(clipRect, guid) {}
  
  /**
   * @param { !boolean } inert
   */

  setIsInert(inert) {}
  
  /**
   * @param { ?blink_mojom_LocalFrameToken } openerFrame
   */

  didChangeOpener(openerFrame) {}
  
  /**
   * @param { !blink_mojom_FocusType } focusType
   * @param { !blink_mojom_LocalFrameToken } sourceFrameToken
   */

  advanceFocus(focusType, sourceFrameToken) {}
  
  /**
   * @param { ?blink_mojom_LocalFrameToken } sourceFrameToken
   * @param { !url_mojom_Origin } sourceOrigin
   * @param { !mojoBase_mojom_String16 } targetOrigin
   * @param { !blink_mojom_TransferableMessage } message
   */

  routeMessageEvent(sourceFrameToken, sourceOrigin, targetOrigin, message) {}
  
  /**
   * @param { !gfx_mojom_Rect } frameContentRect
   * @param { !number } documentCookie
   */

  printCrossProcessSubframe(frameContentRect, documentCookie) {}
  
  /**
   */

  detach() {}
  
  /**
   * @param { !blink_mojom_ViewportIntersectionState } intersectionState
   * @param { ?blink_mojom_FrameVisualProperties } visualProperties
   */

  updateViewportIntersection(intersectionState, visualProperties) {}
  
  /**
   * @param { !blink_mojom_FrameVisualProperties } properties
   */

  synchronizeVisualProperties(properties) {}
  
  /**
   * @param { !OpenURLParams } params
   */

  openURL(params) {}
}

/**
 * @implements { RemoteFrameHostInterface }
 */
export class RemoteFrameHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!RemoteFrameHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          RemoteFrameHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!RemoteFrameHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !cc_mojom_TouchAction } touchAction
   */

  setInheritedEffectiveTouchAction(
      touchAction) {
    this.proxy.sendMessage(
        0,
        RemoteFrameHost_SetInheritedEffectiveTouchAction_ParamsSpec.$,
        null,
        [
          touchAction
        ],
        false);
  }

  
  /**
   * @param { !boolean } isThrottled
   * @param { !boolean } subtreeThrottled
   * @param { !boolean } displayLocked
   */

  updateRenderThrottlingStatus(
      isThrottled,
      subtreeThrottled,
      displayLocked) {
    this.proxy.sendMessage(
        1,
        RemoteFrameHost_UpdateRenderThrottlingStatus_ParamsSpec.$,
        null,
        [
          isThrottled,
          subtreeThrottled,
          displayLocked
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_FrameVisibility } visibility
   */

  visibilityChanged(
      visibility) {
    this.proxy.sendMessage(
        2,
        RemoteFrameHost_VisibilityChanged_ParamsSpec.$,
        null,
        [
          visibility
        ],
        false);
  }

  
  /**
   */

  didFocusFrame() {
    this.proxy.sendMessage(
        3,
        RemoteFrameHost_DidFocusFrame_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  checkCompleted() {
    this.proxy.sendMessage(
        4,
        RemoteFrameHost_CheckCompleted_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !gfx_mojom_Rect } clipRect
   * @param { !mojoBase_mojom_UnguessableToken } guid
   */

  capturePaintPreviewOfCrossProcessSubframe(
      clipRect,
      guid) {
    this.proxy.sendMessage(
        5,
        RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_ParamsSpec.$,
        null,
        [
          clipRect,
          guid
        ],
        false);
  }

  
  /**
   * @param { !boolean } inert
   */

  setIsInert(
      inert) {
    this.proxy.sendMessage(
        6,
        RemoteFrameHost_SetIsInert_ParamsSpec.$,
        null,
        [
          inert
        ],
        false);
  }

  
  /**
   * @param { ?blink_mojom_LocalFrameToken } openerFrame
   */

  didChangeOpener(
      openerFrame) {
    this.proxy.sendMessage(
        7,
        RemoteFrameHost_DidChangeOpener_ParamsSpec.$,
        null,
        [
          openerFrame
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_FocusType } focusType
   * @param { !blink_mojom_LocalFrameToken } sourceFrameToken
   */

  advanceFocus(
      focusType,
      sourceFrameToken) {
    this.proxy.sendMessage(
        8,
        RemoteFrameHost_AdvanceFocus_ParamsSpec.$,
        null,
        [
          focusType,
          sourceFrameToken
        ],
        false);
  }

  
  /**
   * @param { ?blink_mojom_LocalFrameToken } sourceFrameToken
   * @param { !url_mojom_Origin } sourceOrigin
   * @param { !mojoBase_mojom_String16 } targetOrigin
   * @param { !blink_mojom_TransferableMessage } message
   */

  routeMessageEvent(
      sourceFrameToken,
      sourceOrigin,
      targetOrigin,
      message) {
    this.proxy.sendMessage(
        9,
        RemoteFrameHost_RouteMessageEvent_ParamsSpec.$,
        null,
        [
          sourceFrameToken,
          sourceOrigin,
          targetOrigin,
          message
        ],
        false);
  }

  
  /**
   * @param { !gfx_mojom_Rect } frameContentRect
   * @param { !number } documentCookie
   */

  printCrossProcessSubframe(
      frameContentRect,
      documentCookie) {
    this.proxy.sendMessage(
        10,
        RemoteFrameHost_PrintCrossProcessSubframe_ParamsSpec.$,
        null,
        [
          frameContentRect,
          documentCookie
        ],
        false);
  }

  
  /**
   */

  detach() {
    this.proxy.sendMessage(
        11,
        RemoteFrameHost_Detach_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_ViewportIntersectionState } intersectionState
   * @param { ?blink_mojom_FrameVisualProperties } visualProperties
   */

  updateViewportIntersection(
      intersectionState,
      visualProperties) {
    this.proxy.sendMessage(
        12,
        RemoteFrameHost_UpdateViewportIntersection_ParamsSpec.$,
        null,
        [
          intersectionState,
          visualProperties
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_FrameVisualProperties } properties
   */

  synchronizeVisualProperties(
      properties) {
    this.proxy.sendMessage(
        13,
        RemoteFrameHost_SynchronizeVisualProperties_ParamsSpec.$,
        null,
        [
          properties
        ],
        false);
  }

  
  /**
   * @param { !OpenURLParams } params
   */

  openURL(
      params) {
    this.proxy.sendMessage(
        14,
        RemoteFrameHost_OpenURL_ParamsSpec.$,
        null,
        [
          params
        ],
        false);
  }
}

/**
 * An object which receives request messages for the RemoteFrameHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class RemoteFrameHostReceiver {
  /**
   * @param {!RemoteFrameHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!RemoteFrameHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        RemoteFrameHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!RemoteFrameHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        RemoteFrameHost_SetInheritedEffectiveTouchAction_ParamsSpec.$,
        null,
        impl.setInheritedEffectiveTouchAction.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        RemoteFrameHost_UpdateRenderThrottlingStatus_ParamsSpec.$,
        null,
        impl.updateRenderThrottlingStatus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        RemoteFrameHost_VisibilityChanged_ParamsSpec.$,
        null,
        impl.visibilityChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        RemoteFrameHost_DidFocusFrame_ParamsSpec.$,
        null,
        impl.didFocusFrame.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        RemoteFrameHost_CheckCompleted_ParamsSpec.$,
        null,
        impl.checkCompleted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_ParamsSpec.$,
        null,
        impl.capturePaintPreviewOfCrossProcessSubframe.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        RemoteFrameHost_SetIsInert_ParamsSpec.$,
        null,
        impl.setIsInert.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        RemoteFrameHost_DidChangeOpener_ParamsSpec.$,
        null,
        impl.didChangeOpener.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        RemoteFrameHost_AdvanceFocus_ParamsSpec.$,
        null,
        impl.advanceFocus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        RemoteFrameHost_RouteMessageEvent_ParamsSpec.$,
        null,
        impl.routeMessageEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        RemoteFrameHost_PrintCrossProcessSubframe_ParamsSpec.$,
        null,
        impl.printCrossProcessSubframe.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        RemoteFrameHost_Detach_ParamsSpec.$,
        null,
        impl.detach.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        RemoteFrameHost_UpdateViewportIntersection_ParamsSpec.$,
        null,
        impl.updateViewportIntersection.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        RemoteFrameHost_SynchronizeVisualProperties_ParamsSpec.$,
        null,
        impl.synchronizeVisualProperties.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        RemoteFrameHost_OpenURL_ParamsSpec.$,
        null,
        impl.openURL.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class RemoteFrameHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.RemoteFrameHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!RemoteFrameHostRemote}
   */
  static getRemote() {
    let remote = new RemoteFrameHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the RemoteFrameHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class RemoteFrameHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      RemoteFrameHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!RemoteFrameHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setInheritedEffectiveTouchAction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        RemoteFrameHost_SetInheritedEffectiveTouchAction_ParamsSpec.$,
        null,
        this.setInheritedEffectiveTouchAction.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateRenderThrottlingStatus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        RemoteFrameHost_UpdateRenderThrottlingStatus_ParamsSpec.$,
        null,
        this.updateRenderThrottlingStatus.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.visibilityChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        RemoteFrameHost_VisibilityChanged_ParamsSpec.$,
        null,
        this.visibilityChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didFocusFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        RemoteFrameHost_DidFocusFrame_ParamsSpec.$,
        null,
        this.didFocusFrame.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.checkCompleted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        RemoteFrameHost_CheckCompleted_ParamsSpec.$,
        null,
        this.checkCompleted.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.capturePaintPreviewOfCrossProcessSubframe =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_ParamsSpec.$,
        null,
        this.capturePaintPreviewOfCrossProcessSubframe.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setIsInert =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        RemoteFrameHost_SetIsInert_ParamsSpec.$,
        null,
        this.setIsInert.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didChangeOpener =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        RemoteFrameHost_DidChangeOpener_ParamsSpec.$,
        null,
        this.didChangeOpener.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.advanceFocus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        RemoteFrameHost_AdvanceFocus_ParamsSpec.$,
        null,
        this.advanceFocus.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.routeMessageEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        RemoteFrameHost_RouteMessageEvent_ParamsSpec.$,
        null,
        this.routeMessageEvent.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.printCrossProcessSubframe =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        RemoteFrameHost_PrintCrossProcessSubframe_ParamsSpec.$,
        null,
        this.printCrossProcessSubframe.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.detach =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        RemoteFrameHost_Detach_ParamsSpec.$,
        null,
        this.detach.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateViewportIntersection =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        RemoteFrameHost_UpdateViewportIntersection_ParamsSpec.$,
        null,
        this.updateViewportIntersection.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.synchronizeVisualProperties =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        RemoteFrameHost_SynchronizeVisualProperties_ParamsSpec.$,
        null,
        this.synchronizeVisualProperties.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openURL =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        RemoteFrameHost_OpenURL_ParamsSpec.$,
        null,
        this.openURL.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class RemoteFramePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.RemoteFrame', scope);
  }
}

/** @interface */
export class RemoteFrameInterface {
  
  /**
   * @param { !blink_mojom_FullscreenOptions } options
   */

  willEnterFullscreen(options) {}
  
  /**
   * @param { !Array<!number> } set
   */

  enforceInsecureNavigationsSet(set) {}
  
  /**
   * @param { !blink_mojom_FrameOwnerProperties } properties
   */

  setFrameOwnerProperties(properties) {}
  
  /**
   * @param { !blink_mojom_InsecureRequestPolicy } policy
   */

  enforceInsecureRequestPolicy(policy) {}
  
  /**
   * @param { !url_mojom_Origin } origin
   * @param { !boolean } isPotentiallyTrustworthyUniqueOrigin
   */

  setReplicatedOrigin(origin, isPotentiallyTrustworthyUniqueOrigin) {}
  
  /**
   * @param { !boolean } isAdFrame
   */

  setReplicatedIsAdFrame(isAdFrame) {}
  
  /**
   * @param { !string } name
   * @param { !string } uniqueName
   */

  setReplicatedName(name, uniqueName) {}
  
  /**
   */

  dispatchLoadEventForFrameOwner() {}
  
  /**
   * @param { !boolean } needsTracking
   */

  setNeedsOcclusionTracking(needsTracking) {}
  
  /**
   * @param { !boolean } collapsed
   */

  collapse(collapsed) {}
  
  /**
   */

  focus() {}
  
  /**
   * @param { !boolean } hasGesture
   */

  setHadStickyUserActivationBeforeNavigation(hasGesture) {}
  
  /**
   * @param { !blink_mojom_ScrollDirection } direction
   * @param { !ui_mojom_ScrollGranularity } granularity
   */

  bubbleLogicalScroll(direction, granularity) {}
  
  /**
   * @param { !blink_mojom_UserActivationUpdateType } stateUpdateType
   * @param { !blink_mojom_UserActivationNotificationType } notificationType
   */

  updateUserActivationState(stateUpdateType, notificationType) {}
  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } embeddingToken
   */

  setEmbeddingToken(embeddingToken) {}
  
  /**
   * @param { !boolean } isFocused
   */

  setPageFocus(isFocused) {}
  
  /**
   */

  renderFallbackContent() {}
  
  /**
   * @param { !blink_mojom_ResourceTimingInfo } timing
   */

  addResourceTimingFromChild(timing) {}
  
  /**
   * @param { !gfx_mojom_RectF } rect
   * @param { !blink_mojom_ScrollIntoViewParams } params
   */

  scrollRectToVisible(rect, params) {}
  
  /**
   */

  didStartLoading() {}
  
  /**
   */

  didStopLoading() {}
  
  /**
   * @param { !blink_mojom_IntrinsicSizingInfo } sizingInfo
   */

  intrinsicSizingInfoOfChildChanged(sizingInfo) {}
  
  /**
   * @param { !network_mojom_WebSandboxFlags } sandboxFlags
   * @param { !Array<!network_mojom_ParsedPermissionsPolicyDeclaration> } parsedPermissionsPolicy
   */

  didSetFramePolicyHeaders(sandboxFlags, parsedPermissionsPolicy) {}
  
  /**
   * @param { !blink_mojom_FramePolicy } framePolicy
   */

  didUpdateFramePolicy(framePolicy) {}
  
  /**
   * @param { ?blink_mojom_FrameToken } openerFrameToken
   */

  updateOpener(openerFrameToken) {}
  
  /**
   */

  detachAndDispose() {}
  
  /**
   * @param { !gfx_mojom_Size } minSize
   * @param { !gfx_mojom_Size } maxSize
   */

  enableAutoResize(minSize, maxSize) {}
  
  /**
   */

  disableAutoResize() {}
  
  /**
   * @param { !cc_mojom_RenderFrameMetadata } metadata
   */

  didUpdateVisualProperties(metadata) {}
  
  /**
   * @param { !viz_mojom_FrameSinkId } frameSinkId
   * @param { !boolean } allowPaintHolding
   */

  setFrameSinkId(frameSinkId, allowPaintHolding) {}
  
  /**
   */

  childProcessGone() {}
  
  /**
   * @param { !blink_mojom_RemoteFrameToken } token
   * @param { ?blink_mojom_FrameToken } openerFrameToken
   * @param { !blink_mojom_TreeScopeType } treeScopeType
   * @param { !blink_mojom_FrameReplicationState } replicationState
   * @param { !blink_mojom_FrameOwnerProperties } ownerProperties
   * @param { !boolean } isLoading
   * @param { !mojoBase_mojom_UnguessableToken } devtoolsFrameToken
   * @param { !RemoteFrameInterfacesFromBrowser } remoteFrameInterfaces
   */

  createRemoteChild(token, openerFrameToken, treeScopeType, replicationState, ownerProperties, isLoading, devtoolsFrameToken, remoteFrameInterfaces) {}
  
  /**
   * @param { !Array<!CreateRemoteChildParams> } params
   * @param { ?mojoBase_mojom_UnguessableToken } navigationMetricsToken
   */

  createRemoteChildren(params, navigationMetricsToken) {}
  
  /**
   * @param { !string } eventType
   */

  forwardFencedFrameEventToEmbedder(eventType) {}
}

/**
 * @implements { RemoteFrameInterface }
 */
export class RemoteFrameRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!RemoteFramePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          RemoteFramePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!RemoteFramePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink_mojom_FullscreenOptions } options
   */

  willEnterFullscreen(
      options) {
    this.proxy.sendMessage(
        0,
        RemoteFrame_WillEnterFullscreen_ParamsSpec.$,
        null,
        [
          options
        ],
        false);
  }

  
  /**
   * @param { !Array<!number> } set
   */

  enforceInsecureNavigationsSet(
      set) {
    this.proxy.sendMessage(
        1,
        RemoteFrame_EnforceInsecureNavigationsSet_ParamsSpec.$,
        null,
        [
          set
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_FrameOwnerProperties } properties
   */

  setFrameOwnerProperties(
      properties) {
    this.proxy.sendMessage(
        2,
        RemoteFrame_SetFrameOwnerProperties_ParamsSpec.$,
        null,
        [
          properties
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_InsecureRequestPolicy } policy
   */

  enforceInsecureRequestPolicy(
      policy) {
    this.proxy.sendMessage(
        3,
        RemoteFrame_EnforceInsecureRequestPolicy_ParamsSpec.$,
        null,
        [
          policy
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Origin } origin
   * @param { !boolean } isPotentiallyTrustworthyUniqueOrigin
   */

  setReplicatedOrigin(
      origin,
      isPotentiallyTrustworthyUniqueOrigin) {
    this.proxy.sendMessage(
        4,
        RemoteFrame_SetReplicatedOrigin_ParamsSpec.$,
        null,
        [
          origin,
          isPotentiallyTrustworthyUniqueOrigin
        ],
        false);
  }

  
  /**
   * @param { !boolean } isAdFrame
   */

  setReplicatedIsAdFrame(
      isAdFrame) {
    this.proxy.sendMessage(
        5,
        RemoteFrame_SetReplicatedIsAdFrame_ParamsSpec.$,
        null,
        [
          isAdFrame
        ],
        false);
  }

  
  /**
   * @param { !string } name
   * @param { !string } uniqueName
   */

  setReplicatedName(
      name,
      uniqueName) {
    this.proxy.sendMessage(
        6,
        RemoteFrame_SetReplicatedName_ParamsSpec.$,
        null,
        [
          name,
          uniqueName
        ],
        false);
  }

  
  /**
   */

  dispatchLoadEventForFrameOwner() {
    this.proxy.sendMessage(
        7,
        RemoteFrame_DispatchLoadEventForFrameOwner_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } needsTracking
   */

  setNeedsOcclusionTracking(
      needsTracking) {
    this.proxy.sendMessage(
        8,
        RemoteFrame_SetNeedsOcclusionTracking_ParamsSpec.$,
        null,
        [
          needsTracking
        ],
        false);
  }

  
  /**
   * @param { !boolean } collapsed
   */

  collapse(
      collapsed) {
    this.proxy.sendMessage(
        9,
        RemoteFrame_Collapse_ParamsSpec.$,
        null,
        [
          collapsed
        ],
        false);
  }

  
  /**
   */

  focus() {
    this.proxy.sendMessage(
        10,
        RemoteFrame_Focus_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } hasGesture
   */

  setHadStickyUserActivationBeforeNavigation(
      hasGesture) {
    this.proxy.sendMessage(
        11,
        RemoteFrame_SetHadStickyUserActivationBeforeNavigation_ParamsSpec.$,
        null,
        [
          hasGesture
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_ScrollDirection } direction
   * @param { !ui_mojom_ScrollGranularity } granularity
   */

  bubbleLogicalScroll(
      direction,
      granularity) {
    this.proxy.sendMessage(
        12,
        RemoteFrame_BubbleLogicalScroll_ParamsSpec.$,
        null,
        [
          direction,
          granularity
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_UserActivationUpdateType } stateUpdateType
   * @param { !blink_mojom_UserActivationNotificationType } notificationType
   */

  updateUserActivationState(
      stateUpdateType,
      notificationType) {
    this.proxy.sendMessage(
        13,
        RemoteFrame_UpdateUserActivationState_ParamsSpec.$,
        null,
        [
          stateUpdateType,
          notificationType
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } embeddingToken
   */

  setEmbeddingToken(
      embeddingToken) {
    this.proxy.sendMessage(
        14,
        RemoteFrame_SetEmbeddingToken_ParamsSpec.$,
        null,
        [
          embeddingToken
        ],
        false);
  }

  
  /**
   * @param { !boolean } isFocused
   */

  setPageFocus(
      isFocused) {
    this.proxy.sendMessage(
        15,
        RemoteFrame_SetPageFocus_ParamsSpec.$,
        null,
        [
          isFocused
        ],
        false);
  }

  
  /**
   */

  renderFallbackContent() {
    this.proxy.sendMessage(
        16,
        RemoteFrame_RenderFallbackContent_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_ResourceTimingInfo } timing
   */

  addResourceTimingFromChild(
      timing) {
    this.proxy.sendMessage(
        17,
        RemoteFrame_AddResourceTimingFromChild_ParamsSpec.$,
        null,
        [
          timing
        ],
        false);
  }

  
  /**
   * @param { !gfx_mojom_RectF } rect
   * @param { !blink_mojom_ScrollIntoViewParams } params
   */

  scrollRectToVisible(
      rect,
      params) {
    this.proxy.sendMessage(
        18,
        RemoteFrame_ScrollRectToVisible_ParamsSpec.$,
        null,
        [
          rect,
          params
        ],
        false);
  }

  
  /**
   */

  didStartLoading() {
    this.proxy.sendMessage(
        19,
        RemoteFrame_DidStartLoading_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  didStopLoading() {
    this.proxy.sendMessage(
        20,
        RemoteFrame_DidStopLoading_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_IntrinsicSizingInfo } sizingInfo
   */

  intrinsicSizingInfoOfChildChanged(
      sizingInfo) {
    this.proxy.sendMessage(
        21,
        RemoteFrame_IntrinsicSizingInfoOfChildChanged_ParamsSpec.$,
        null,
        [
          sizingInfo
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_WebSandboxFlags } sandboxFlags
   * @param { !Array<!network_mojom_ParsedPermissionsPolicyDeclaration> } parsedPermissionsPolicy
   */

  didSetFramePolicyHeaders(
      sandboxFlags,
      parsedPermissionsPolicy) {
    this.proxy.sendMessage(
        22,
        RemoteFrame_DidSetFramePolicyHeaders_ParamsSpec.$,
        null,
        [
          sandboxFlags,
          parsedPermissionsPolicy
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_FramePolicy } framePolicy
   */

  didUpdateFramePolicy(
      framePolicy) {
    this.proxy.sendMessage(
        23,
        RemoteFrame_DidUpdateFramePolicy_ParamsSpec.$,
        null,
        [
          framePolicy
        ],
        false);
  }

  
  /**
   * @param { ?blink_mojom_FrameToken } openerFrameToken
   */

  updateOpener(
      openerFrameToken) {
    this.proxy.sendMessage(
        24,
        RemoteFrame_UpdateOpener_ParamsSpec.$,
        null,
        [
          openerFrameToken
        ],
        false);
  }

  
  /**
   */

  detachAndDispose() {
    this.proxy.sendMessage(
        25,
        RemoteFrame_DetachAndDispose_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !gfx_mojom_Size } minSize
   * @param { !gfx_mojom_Size } maxSize
   */

  enableAutoResize(
      minSize,
      maxSize) {
    this.proxy.sendMessage(
        26,
        RemoteFrame_EnableAutoResize_ParamsSpec.$,
        null,
        [
          minSize,
          maxSize
        ],
        false);
  }

  
  /**
   */

  disableAutoResize() {
    this.proxy.sendMessage(
        27,
        RemoteFrame_DisableAutoResize_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !cc_mojom_RenderFrameMetadata } metadata
   */

  didUpdateVisualProperties(
      metadata) {
    this.proxy.sendMessage(
        28,
        RemoteFrame_DidUpdateVisualProperties_ParamsSpec.$,
        null,
        [
          metadata
        ],
        false);
  }

  
  /**
   * @param { !viz_mojom_FrameSinkId } frameSinkId
   * @param { !boolean } allowPaintHolding
   */

  setFrameSinkId(
      frameSinkId,
      allowPaintHolding) {
    this.proxy.sendMessage(
        29,
        RemoteFrame_SetFrameSinkId_ParamsSpec.$,
        null,
        [
          frameSinkId,
          allowPaintHolding
        ],
        false);
  }

  
  /**
   */

  childProcessGone() {
    this.proxy.sendMessage(
        30,
        RemoteFrame_ChildProcessGone_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_RemoteFrameToken } token
   * @param { ?blink_mojom_FrameToken } openerFrameToken
   * @param { !blink_mojom_TreeScopeType } treeScopeType
   * @param { !blink_mojom_FrameReplicationState } replicationState
   * @param { !blink_mojom_FrameOwnerProperties } ownerProperties
   * @param { !boolean } isLoading
   * @param { !mojoBase_mojom_UnguessableToken } devtoolsFrameToken
   * @param { !RemoteFrameInterfacesFromBrowser } remoteFrameInterfaces
   */

  createRemoteChild(
      token,
      openerFrameToken,
      treeScopeType,
      replicationState,
      ownerProperties,
      isLoading,
      devtoolsFrameToken,
      remoteFrameInterfaces) {
    this.proxy.sendMessage(
        31,
        RemoteFrame_CreateRemoteChild_ParamsSpec.$,
        null,
        [
          token,
          openerFrameToken,
          treeScopeType,
          replicationState,
          ownerProperties,
          isLoading,
          devtoolsFrameToken,
          remoteFrameInterfaces
        ],
        false);
  }

  
  /**
   * @param { !Array<!CreateRemoteChildParams> } params
   * @param { ?mojoBase_mojom_UnguessableToken } navigationMetricsToken
   */

  createRemoteChildren(
      params,
      navigationMetricsToken) {
    this.proxy.sendMessage(
        32,
        RemoteFrame_CreateRemoteChildren_ParamsSpec.$,
        null,
        [
          params,
          navigationMetricsToken
        ],
        false);
  }

  
  /**
   * @param { !string } eventType
   */

  forwardFencedFrameEventToEmbedder(
      eventType) {
    this.proxy.sendMessage(
        33,
        RemoteFrame_ForwardFencedFrameEventToEmbedder_ParamsSpec.$,
        null,
        [
          eventType
        ],
        false);
  }
}

/**
 * An object which receives request messages for the RemoteFrame
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class RemoteFrameReceiver {
  /**
   * @param {!RemoteFrameInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!RemoteFrameRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        RemoteFrameRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!RemoteFrameRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        RemoteFrame_WillEnterFullscreen_ParamsSpec.$,
        null,
        impl.willEnterFullscreen.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        RemoteFrame_EnforceInsecureNavigationsSet_ParamsSpec.$,
        null,
        impl.enforceInsecureNavigationsSet.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        RemoteFrame_SetFrameOwnerProperties_ParamsSpec.$,
        null,
        impl.setFrameOwnerProperties.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        RemoteFrame_EnforceInsecureRequestPolicy_ParamsSpec.$,
        null,
        impl.enforceInsecureRequestPolicy.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        RemoteFrame_SetReplicatedOrigin_ParamsSpec.$,
        null,
        impl.setReplicatedOrigin.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        RemoteFrame_SetReplicatedIsAdFrame_ParamsSpec.$,
        null,
        impl.setReplicatedIsAdFrame.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        RemoteFrame_SetReplicatedName_ParamsSpec.$,
        null,
        impl.setReplicatedName.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        RemoteFrame_DispatchLoadEventForFrameOwner_ParamsSpec.$,
        null,
        impl.dispatchLoadEventForFrameOwner.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        RemoteFrame_SetNeedsOcclusionTracking_ParamsSpec.$,
        null,
        impl.setNeedsOcclusionTracking.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        RemoteFrame_Collapse_ParamsSpec.$,
        null,
        impl.collapse.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        RemoteFrame_Focus_ParamsSpec.$,
        null,
        impl.focus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        RemoteFrame_SetHadStickyUserActivationBeforeNavigation_ParamsSpec.$,
        null,
        impl.setHadStickyUserActivationBeforeNavigation.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        RemoteFrame_BubbleLogicalScroll_ParamsSpec.$,
        null,
        impl.bubbleLogicalScroll.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        RemoteFrame_UpdateUserActivationState_ParamsSpec.$,
        null,
        impl.updateUserActivationState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        RemoteFrame_SetEmbeddingToken_ParamsSpec.$,
        null,
        impl.setEmbeddingToken.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        RemoteFrame_SetPageFocus_ParamsSpec.$,
        null,
        impl.setPageFocus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        RemoteFrame_RenderFallbackContent_ParamsSpec.$,
        null,
        impl.renderFallbackContent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        RemoteFrame_AddResourceTimingFromChild_ParamsSpec.$,
        null,
        impl.addResourceTimingFromChild.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        RemoteFrame_ScrollRectToVisible_ParamsSpec.$,
        null,
        impl.scrollRectToVisible.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        19,
        RemoteFrame_DidStartLoading_ParamsSpec.$,
        null,
        impl.didStartLoading.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        20,
        RemoteFrame_DidStopLoading_ParamsSpec.$,
        null,
        impl.didStopLoading.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        21,
        RemoteFrame_IntrinsicSizingInfoOfChildChanged_ParamsSpec.$,
        null,
        impl.intrinsicSizingInfoOfChildChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        22,
        RemoteFrame_DidSetFramePolicyHeaders_ParamsSpec.$,
        null,
        impl.didSetFramePolicyHeaders.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        23,
        RemoteFrame_DidUpdateFramePolicy_ParamsSpec.$,
        null,
        impl.didUpdateFramePolicy.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        24,
        RemoteFrame_UpdateOpener_ParamsSpec.$,
        null,
        impl.updateOpener.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        25,
        RemoteFrame_DetachAndDispose_ParamsSpec.$,
        null,
        impl.detachAndDispose.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        26,
        RemoteFrame_EnableAutoResize_ParamsSpec.$,
        null,
        impl.enableAutoResize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        27,
        RemoteFrame_DisableAutoResize_ParamsSpec.$,
        null,
        impl.disableAutoResize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        28,
        RemoteFrame_DidUpdateVisualProperties_ParamsSpec.$,
        null,
        impl.didUpdateVisualProperties.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        29,
        RemoteFrame_SetFrameSinkId_ParamsSpec.$,
        null,
        impl.setFrameSinkId.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        30,
        RemoteFrame_ChildProcessGone_ParamsSpec.$,
        null,
        impl.childProcessGone.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        31,
        RemoteFrame_CreateRemoteChild_ParamsSpec.$,
        null,
        impl.createRemoteChild.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        32,
        RemoteFrame_CreateRemoteChildren_ParamsSpec.$,
        null,
        impl.createRemoteChildren.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        33,
        RemoteFrame_ForwardFencedFrameEventToEmbedder_ParamsSpec.$,
        null,
        impl.forwardFencedFrameEventToEmbedder.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class RemoteFrame {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.RemoteFrame";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!RemoteFrameRemote}
   */
  static getRemote() {
    let remote = new RemoteFrameRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the RemoteFrame
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class RemoteFrameCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      RemoteFrameRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!RemoteFrameRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.willEnterFullscreen =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        RemoteFrame_WillEnterFullscreen_ParamsSpec.$,
        null,
        this.willEnterFullscreen.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enforceInsecureNavigationsSet =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        RemoteFrame_EnforceInsecureNavigationsSet_ParamsSpec.$,
        null,
        this.enforceInsecureNavigationsSet.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setFrameOwnerProperties =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        RemoteFrame_SetFrameOwnerProperties_ParamsSpec.$,
        null,
        this.setFrameOwnerProperties.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enforceInsecureRequestPolicy =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        RemoteFrame_EnforceInsecureRequestPolicy_ParamsSpec.$,
        null,
        this.enforceInsecureRequestPolicy.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setReplicatedOrigin =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        RemoteFrame_SetReplicatedOrigin_ParamsSpec.$,
        null,
        this.setReplicatedOrigin.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setReplicatedIsAdFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        RemoteFrame_SetReplicatedIsAdFrame_ParamsSpec.$,
        null,
        this.setReplicatedIsAdFrame.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setReplicatedName =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        RemoteFrame_SetReplicatedName_ParamsSpec.$,
        null,
        this.setReplicatedName.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchLoadEventForFrameOwner =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        RemoteFrame_DispatchLoadEventForFrameOwner_ParamsSpec.$,
        null,
        this.dispatchLoadEventForFrameOwner.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setNeedsOcclusionTracking =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        RemoteFrame_SetNeedsOcclusionTracking_ParamsSpec.$,
        null,
        this.setNeedsOcclusionTracking.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.collapse =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        RemoteFrame_Collapse_ParamsSpec.$,
        null,
        this.collapse.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.focus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        RemoteFrame_Focus_ParamsSpec.$,
        null,
        this.focus.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setHadStickyUserActivationBeforeNavigation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        RemoteFrame_SetHadStickyUserActivationBeforeNavigation_ParamsSpec.$,
        null,
        this.setHadStickyUserActivationBeforeNavigation.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bubbleLogicalScroll =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        RemoteFrame_BubbleLogicalScroll_ParamsSpec.$,
        null,
        this.bubbleLogicalScroll.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateUserActivationState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        RemoteFrame_UpdateUserActivationState_ParamsSpec.$,
        null,
        this.updateUserActivationState.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setEmbeddingToken =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        RemoteFrame_SetEmbeddingToken_ParamsSpec.$,
        null,
        this.setEmbeddingToken.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPageFocus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        RemoteFrame_SetPageFocus_ParamsSpec.$,
        null,
        this.setPageFocus.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.renderFallbackContent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        RemoteFrame_RenderFallbackContent_ParamsSpec.$,
        null,
        this.renderFallbackContent.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addResourceTimingFromChild =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        RemoteFrame_AddResourceTimingFromChild_ParamsSpec.$,
        null,
        this.addResourceTimingFromChild.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.scrollRectToVisible =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        RemoteFrame_ScrollRectToVisible_ParamsSpec.$,
        null,
        this.scrollRectToVisible.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didStartLoading =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        19,
        RemoteFrame_DidStartLoading_ParamsSpec.$,
        null,
        this.didStartLoading.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didStopLoading =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        20,
        RemoteFrame_DidStopLoading_ParamsSpec.$,
        null,
        this.didStopLoading.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.intrinsicSizingInfoOfChildChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        21,
        RemoteFrame_IntrinsicSizingInfoOfChildChanged_ParamsSpec.$,
        null,
        this.intrinsicSizingInfoOfChildChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didSetFramePolicyHeaders =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        22,
        RemoteFrame_DidSetFramePolicyHeaders_ParamsSpec.$,
        null,
        this.didSetFramePolicyHeaders.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didUpdateFramePolicy =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        23,
        RemoteFrame_DidUpdateFramePolicy_ParamsSpec.$,
        null,
        this.didUpdateFramePolicy.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateOpener =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        24,
        RemoteFrame_UpdateOpener_ParamsSpec.$,
        null,
        this.updateOpener.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.detachAndDispose =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        25,
        RemoteFrame_DetachAndDispose_ParamsSpec.$,
        null,
        this.detachAndDispose.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enableAutoResize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        26,
        RemoteFrame_EnableAutoResize_ParamsSpec.$,
        null,
        this.enableAutoResize.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.disableAutoResize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        27,
        RemoteFrame_DisableAutoResize_ParamsSpec.$,
        null,
        this.disableAutoResize.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didUpdateVisualProperties =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        28,
        RemoteFrame_DidUpdateVisualProperties_ParamsSpec.$,
        null,
        this.didUpdateVisualProperties.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setFrameSinkId =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        29,
        RemoteFrame_SetFrameSinkId_ParamsSpec.$,
        null,
        this.setFrameSinkId.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.childProcessGone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        30,
        RemoteFrame_ChildProcessGone_ParamsSpec.$,
        null,
        this.childProcessGone.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createRemoteChild =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        31,
        RemoteFrame_CreateRemoteChild_ParamsSpec.$,
        null,
        this.createRemoteChild.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createRemoteChildren =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        32,
        RemoteFrame_CreateRemoteChildren_ParamsSpec.$,
        null,
        this.createRemoteChildren.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.forwardFencedFrameEventToEmbedder =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        33,
        RemoteFrame_ForwardFencedFrameEventToEmbedder_ParamsSpec.$,
        null,
        this.forwardFencedFrameEventToEmbedder.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class RemoteMainFramePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.RemoteMainFrame', scope);
  }
}

/** @interface */
export class RemoteMainFrameInterface {
  
  /**
   * @param { !blink_mojom_TextAutosizerPageInfo } pageInfo
   */

  updateTextAutosizerPageInfo(pageInfo) {}
}

/**
 * @implements { RemoteMainFrameInterface }
 */
export class RemoteMainFrameRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!RemoteMainFramePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          RemoteMainFramePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!RemoteMainFramePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink_mojom_TextAutosizerPageInfo } pageInfo
   */

  updateTextAutosizerPageInfo(
      pageInfo) {
    this.proxy.sendMessage(
        0,
        RemoteMainFrame_UpdateTextAutosizerPageInfo_ParamsSpec.$,
        null,
        [
          pageInfo
        ],
        false);
  }
}

/**
 * An object which receives request messages for the RemoteMainFrame
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class RemoteMainFrameReceiver {
  /**
   * @param {!RemoteMainFrameInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!RemoteMainFrameRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        RemoteMainFrameRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!RemoteMainFrameRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        RemoteMainFrame_UpdateTextAutosizerPageInfo_ParamsSpec.$,
        null,
        impl.updateTextAutosizerPageInfo.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class RemoteMainFrame {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.RemoteMainFrame";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!RemoteMainFrameRemote}
   */
  static getRemote() {
    let remote = new RemoteMainFrameRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the RemoteMainFrame
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class RemoteMainFrameCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      RemoteMainFrameRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!RemoteMainFrameRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateTextAutosizerPageInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        RemoteMainFrame_UpdateTextAutosizerPageInfo_ParamsSpec.$,
        null,
        this.updateTextAutosizerPageInfo.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class RemoteMainFrameHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.RemoteMainFrameHost', scope);
  }
}

/** @interface */
export class RemoteMainFrameHostInterface {
  
  /**
   */

  focusPage() {}
  
  /**
   * @param { !boolean } reverse
   */

  takeFocus(reverse) {}
  
  /**
   * @param { !url_mojom_Url } url
   * @return {!Promise}
   */

  updateTargetURL(url) {}
  
  /**
   */

  routeCloseEvent() {}
}

/**
 * @implements { RemoteMainFrameHostInterface }
 */
export class RemoteMainFrameHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!RemoteMainFrameHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          RemoteMainFrameHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!RemoteMainFrameHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  focusPage() {
    this.proxy.sendMessage(
        0,
        RemoteMainFrameHost_FocusPage_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } reverse
   */

  takeFocus(
      reverse) {
    this.proxy.sendMessage(
        1,
        RemoteMainFrameHost_TakeFocus_ParamsSpec.$,
        null,
        [
          reverse
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } url
   * @return {!Promise}
   */

  updateTargetURL(
      url) {
    return this.proxy.sendMessage(
        2,
        RemoteMainFrameHost_UpdateTargetURL_ParamsSpec.$,
        RemoteMainFrameHost_UpdateTargetURL_ResponseParamsSpec.$,
        [
          url
        ],
        false);
  }

  
  /**
   */

  routeCloseEvent() {
    this.proxy.sendMessage(
        3,
        RemoteMainFrameHost_RouteCloseEvent_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the RemoteMainFrameHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class RemoteMainFrameHostReceiver {
  /**
   * @param {!RemoteMainFrameHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!RemoteMainFrameHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        RemoteMainFrameHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!RemoteMainFrameHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        RemoteMainFrameHost_FocusPage_ParamsSpec.$,
        null,
        impl.focusPage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        RemoteMainFrameHost_TakeFocus_ParamsSpec.$,
        null,
        impl.takeFocus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        RemoteMainFrameHost_UpdateTargetURL_ParamsSpec.$,
        RemoteMainFrameHost_UpdateTargetURL_ResponseParamsSpec.$,
        impl.updateTargetURL.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        RemoteMainFrameHost_RouteCloseEvent_ParamsSpec.$,
        null,
        impl.routeCloseEvent.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class RemoteMainFrameHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.RemoteMainFrameHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!RemoteMainFrameHostRemote}
   */
  static getRemote() {
    let remote = new RemoteMainFrameHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the RemoteMainFrameHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class RemoteMainFrameHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      RemoteMainFrameHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!RemoteMainFrameHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.focusPage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        RemoteMainFrameHost_FocusPage_ParamsSpec.$,
        null,
        this.focusPage.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.takeFocus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        RemoteMainFrameHost_TakeFocus_ParamsSpec.$,
        null,
        this.takeFocus.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateTargetURL =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        RemoteMainFrameHost_UpdateTargetURL_ParamsSpec.$,
        RemoteMainFrameHost_UpdateTargetURL_ResponseParamsSpec.$,
        this.updateTargetURL.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.routeCloseEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        RemoteMainFrameHost_RouteCloseEvent_ParamsSpec.$,
        null,
        this.routeCloseEvent.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteMainFrameInterfacesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrameInterfacesFromRendererSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrameInterfacesFromBrowserSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CreateRemoteChildParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OpenURLParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrameHost_SetInheritedEffectiveTouchAction_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrameHost_UpdateRenderThrottlingStatus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrameHost_VisibilityChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrameHost_DidFocusFrame_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrameHost_CheckCompleted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrameHost_SetIsInert_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrameHost_DidChangeOpener_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrameHost_AdvanceFocus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrameHost_RouteMessageEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrameHost_PrintCrossProcessSubframe_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrameHost_Detach_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrameHost_UpdateViewportIntersection_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrameHost_SynchronizeVisualProperties_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrameHost_OpenURL_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrame_WillEnterFullscreen_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrame_EnforceInsecureNavigationsSet_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrame_SetFrameOwnerProperties_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrame_EnforceInsecureRequestPolicy_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrame_SetReplicatedOrigin_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrame_SetReplicatedIsAdFrame_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrame_SetReplicatedName_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrame_DispatchLoadEventForFrameOwner_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrame_SetNeedsOcclusionTracking_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrame_Collapse_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrame_Focus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrame_SetHadStickyUserActivationBeforeNavigation_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrame_BubbleLogicalScroll_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrame_UpdateUserActivationState_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrame_SetEmbeddingToken_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrame_SetPageFocus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrame_RenderFallbackContent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrame_AddResourceTimingFromChild_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrame_ScrollRectToVisible_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrame_DidStartLoading_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrame_DidStopLoading_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrame_IntrinsicSizingInfoOfChildChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrame_DidSetFramePolicyHeaders_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrame_DidUpdateFramePolicy_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrame_UpdateOpener_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrame_DetachAndDispose_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrame_EnableAutoResize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrame_DisableAutoResize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrame_DidUpdateVisualProperties_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrame_SetFrameSinkId_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrame_ChildProcessGone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrame_CreateRemoteChild_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrame_CreateRemoteChildren_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteFrame_ForwardFencedFrameEventToEmbedder_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteMainFrame_UpdateTextAutosizerPageInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteMainFrameHost_FocusPage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteMainFrameHost_TakeFocus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteMainFrameHost_UpdateTargetURL_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteMainFrameHost_UpdateTargetURL_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteMainFrameHost_RouteCloseEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    RemoteMainFrameInterfacesSpec.$,
    'RemoteMainFrameInterfaces',
    [
      mojo.internal.StructField(
        'mainFrameHost', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(RemoteMainFrameHostRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mainFrame', 8,
        0,
        mojo.internal.AssociatedInterfaceRequest(RemoteMainFramePendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class RemoteMainFrameInterfaces {
  constructor() {
    /** @type { !Object } */
    this.mainFrameHost;
    /** @type { !Object } */
    this.mainFrame;
  }
}



mojo.internal.Struct(
    RemoteFrameInterfacesFromRendererSpec.$,
    'RemoteFrameInterfacesFromRenderer',
    [
      mojo.internal.StructField(
        'frame', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(RemoteFrameRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'frameHostReceiver', 8,
        0,
        mojo.internal.AssociatedInterfaceRequest(RemoteFrameHostPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class RemoteFrameInterfacesFromRenderer {
  constructor() {
    /** @type { !Object } */
    this.frame;
    /** @type { !Object } */
    this.frameHostReceiver;
  }
}



mojo.internal.Struct(
    RemoteFrameInterfacesFromBrowserSpec.$,
    'RemoteFrameInterfacesFromBrowser',
    [
      mojo.internal.StructField(
        'frameReceiver', 0,
        0,
        mojo.internal.AssociatedInterfaceRequest(RemoteFramePendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'frameHost', 4,
        0,
        mojo.internal.AssociatedInterfaceProxy(RemoteFrameHostRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class RemoteFrameInterfacesFromBrowser {
  constructor() {
    /** @type { !Object } */
    this.frameReceiver;
    /** @type { !Object } */
    this.frameHost;
  }
}



mojo.internal.Struct(
    CreateRemoteChildParamsSpec.$,
    'CreateRemoteChildParams',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        blink_mojom_RemoteFrameTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'openerFrameToken', 8,
        0,
        blink_mojom_FrameTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'treeScopeType', 24,
        0,
        blink_mojom_TreeScopeTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'replicationState', 32,
        0,
        blink_mojom_FrameReplicationStateSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'ownerProperties', 40,
        0,
        blink_mojom_FrameOwnerPropertiesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isLoading', 28,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'devtoolsFrameToken', 48,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'frameInterfaces', 56,
        0,
        RemoteFrameInterfacesFromBrowserSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'childParams', 64,
        0,
        mojo.internal.Array(CreateRemoteChildParamsSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 80],]);



/**
 * @record
 */
export class CreateRemoteChildParams {
  constructor() {
    /** @type { !blink_mojom_RemoteFrameToken } */
    this.token;
    /** @type { (blink_mojom_FrameToken|undefined) } */
    this.openerFrameToken;
    /** @type { !blink_mojom_TreeScopeType } */
    this.treeScopeType;
    /** @type { !blink_mojom_FrameReplicationState } */
    this.replicationState;
    /** @type { !blink_mojom_FrameOwnerProperties } */
    this.ownerProperties;
    /** @type { !boolean } */
    this.isLoading;
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.devtoolsFrameToken;
    /** @type { !RemoteFrameInterfacesFromBrowser } */
    this.frameInterfaces;
    /** @type { !Array<!CreateRemoteChildParams> } */
    this.childParams;
  }
}



mojo.internal.Struct(
    OpenURLParamsSpec.$,
    'OpenURLParams',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'initiatorOrigin', 8,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'initiatorBaseUrl', 16,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'actualNavigationStart', 24,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'initiatorFrameToken', 32,
        0,
        blink_mojom_LocalFrameTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'postBody', 40,
        0,
        network_mojom_URLRequestBodySpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'extraHeaders', 48,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'referrer', 56,
        0,
        blink_mojom_ReferrerSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isFormSubmission', 64,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'disposition', 68,
        0,
        ui_mojom_WindowOpenDispositionSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'shouldReplaceCurrentEntry', 64,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'userGesture', 64,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isUnfencedTopNavigation', 64,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'triggeringEventInfo', 72,
        0,
        blink_mojom_TriggeringEventInfoSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'blobUrlToken', 76,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_BlobURLTokenRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hrefTranslate', 88,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'impression', 96,
        0,
        blink_mojom_ImpressionSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'downloadPolicy', 104,
        0,
        blink_mojom_NavigationDownloadPolicySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sourceLocation', 112,
        0,
        network_mojom_SourceLocationSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'initiatorNavigationStateKeepAliveHandle', 120,
        0,
        mojo.internal.InterfaceProxy(NavigationStateKeepAliveHandleRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'initiatorActivationAndAdStatus', 84,
        0,
        blink_mojom_NavigationInitiatorActivationAndAdStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isContainerInitiated', 64,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasRelOpener', 64,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'storageAccessApiStatus', 128,
        0,
        network_mojom_StorageAccessApiStatusSpec.$,
        network_mojom_StorageAccessApiStatus.kNone,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 144],]);



/**
 * @record
 */
export class OpenURLParams {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !url_mojom_Origin } */
    this.initiatorOrigin;
    /** @type { (url_mojom_Url|undefined) } */
    this.initiatorBaseUrl;
    /** @type { !mojoBase_mojom_TimeTicks } */
    this.actualNavigationStart;
    /** @type { (blink_mojom_LocalFrameToken|undefined) } */
    this.initiatorFrameToken;
    /** @type { (network_mojom_URLRequestBody|undefined) } */
    this.postBody;
    /** @type { !string } */
    this.extraHeaders;
    /** @type { !blink_mojom_Referrer } */
    this.referrer;
    /** @type { !boolean } */
    this.isFormSubmission;
    /** @type { !ui_mojom_WindowOpenDisposition } */
    this.disposition;
    /** @type { !boolean } */
    this.shouldReplaceCurrentEntry;
    /** @type { !boolean } */
    this.userGesture;
    /** @type { !boolean } */
    this.isUnfencedTopNavigation;
    /** @type { !blink_mojom_TriggeringEventInfo } */
    this.triggeringEventInfo;
    /** @type { (blink_mojom_BlobURLTokenRemote|undefined) } */
    this.blobUrlToken;
    /** @type { !string } */
    this.hrefTranslate;
    /** @type { (blink_mojom_Impression|undefined) } */
    this.impression;
    /** @type { !blink_mojom_NavigationDownloadPolicy } */
    this.downloadPolicy;
    /** @type { !network_mojom_SourceLocation } */
    this.sourceLocation;
    /** @type { (NavigationStateKeepAliveHandleRemote|undefined) } */
    this.initiatorNavigationStateKeepAliveHandle;
    /** @type { !blink_mojom_NavigationInitiatorActivationAndAdStatus } */
    this.initiatorActivationAndAdStatus;
    /** @type { !boolean } */
    this.isContainerInitiated;
    /** @type { !boolean } */
    this.hasRelOpener;
    /** @type { !network_mojom_StorageAccessApiStatus } */
    this.storageAccessApiStatus;
  }
}



mojo.internal.Struct(
    RemoteFrameHost_SetInheritedEffectiveTouchAction_ParamsSpec.$,
    'RemoteFrameHost_SetInheritedEffectiveTouchAction_Params',
    [
      mojo.internal.StructField(
        'touchAction', 0,
        0,
        cc_mojom_TouchActionSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RemoteFrameHost_SetInheritedEffectiveTouchAction_Params {
  constructor() {
    /** @type { !cc_mojom_TouchAction } */
    this.touchAction;
  }
}



mojo.internal.Struct(
    RemoteFrameHost_UpdateRenderThrottlingStatus_ParamsSpec.$,
    'RemoteFrameHost_UpdateRenderThrottlingStatus_Params',
    [
      mojo.internal.StructField(
        'isThrottled', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'subtreeThrottled', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'displayLocked', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RemoteFrameHost_UpdateRenderThrottlingStatus_Params {
  constructor() {
    /** @type { !boolean } */
    this.isThrottled;
    /** @type { !boolean } */
    this.subtreeThrottled;
    /** @type { !boolean } */
    this.displayLocked;
  }
}



mojo.internal.Struct(
    RemoteFrameHost_VisibilityChanged_ParamsSpec.$,
    'RemoteFrameHost_VisibilityChanged_Params',
    [
      mojo.internal.StructField(
        'visibility', 0,
        0,
        blink_mojom_FrameVisibilitySpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RemoteFrameHost_VisibilityChanged_Params {
  constructor() {
    /** @type { !blink_mojom_FrameVisibility } */
    this.visibility;
  }
}



mojo.internal.Struct(
    RemoteFrameHost_DidFocusFrame_ParamsSpec.$,
    'RemoteFrameHost_DidFocusFrame_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class RemoteFrameHost_DidFocusFrame_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    RemoteFrameHost_CheckCompleted_ParamsSpec.$,
    'RemoteFrameHost_CheckCompleted_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class RemoteFrameHost_CheckCompleted_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_ParamsSpec.$,
    'RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Params',
    [
      mojo.internal.StructField(
        'clipRect', 0,
        0,
        gfx_mojom_RectSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'guid', 8,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Params {
  constructor() {
    /** @type { !gfx_mojom_Rect } */
    this.clipRect;
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.guid;
  }
}



mojo.internal.Struct(
    RemoteFrameHost_SetIsInert_ParamsSpec.$,
    'RemoteFrameHost_SetIsInert_Params',
    [
      mojo.internal.StructField(
        'inert', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RemoteFrameHost_SetIsInert_Params {
  constructor() {
    /** @type { !boolean } */
    this.inert;
  }
}



mojo.internal.Struct(
    RemoteFrameHost_DidChangeOpener_ParamsSpec.$,
    'RemoteFrameHost_DidChangeOpener_Params',
    [
      mojo.internal.StructField(
        'openerFrame', 0,
        0,
        blink_mojom_LocalFrameTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RemoteFrameHost_DidChangeOpener_Params {
  constructor() {
    /** @type { (blink_mojom_LocalFrameToken|undefined) } */
    this.openerFrame;
  }
}



mojo.internal.Struct(
    RemoteFrameHost_AdvanceFocus_ParamsSpec.$,
    'RemoteFrameHost_AdvanceFocus_Params',
    [
      mojo.internal.StructField(
        'focusType', 0,
        0,
        blink_mojom_FocusTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sourceFrameToken', 8,
        0,
        blink_mojom_LocalFrameTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class RemoteFrameHost_AdvanceFocus_Params {
  constructor() {
    /** @type { !blink_mojom_FocusType } */
    this.focusType;
    /** @type { !blink_mojom_LocalFrameToken } */
    this.sourceFrameToken;
  }
}



mojo.internal.Struct(
    RemoteFrameHost_RouteMessageEvent_ParamsSpec.$,
    'RemoteFrameHost_RouteMessageEvent_Params',
    [
      mojo.internal.StructField(
        'sourceFrameToken', 0,
        0,
        blink_mojom_LocalFrameTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sourceOrigin', 8,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'targetOrigin', 16,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'message', 24,
        0,
        blink_mojom_TransferableMessageSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class RemoteFrameHost_RouteMessageEvent_Params {
  constructor() {
    /** @type { (blink_mojom_LocalFrameToken|undefined) } */
    this.sourceFrameToken;
    /** @type { !url_mojom_Origin } */
    this.sourceOrigin;
    /** @type { !mojoBase_mojom_String16 } */
    this.targetOrigin;
    /** @type { !blink_mojom_TransferableMessage } */
    this.message;
  }
}



mojo.internal.Struct(
    RemoteFrameHost_PrintCrossProcessSubframe_ParamsSpec.$,
    'RemoteFrameHost_PrintCrossProcessSubframe_Params',
    [
      mojo.internal.StructField(
        'frameContentRect', 0,
        0,
        gfx_mojom_RectSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'documentCookie', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class RemoteFrameHost_PrintCrossProcessSubframe_Params {
  constructor() {
    /** @type { !gfx_mojom_Rect } */
    this.frameContentRect;
    /** @type { !number } */
    this.documentCookie;
  }
}



mojo.internal.Struct(
    RemoteFrameHost_Detach_ParamsSpec.$,
    'RemoteFrameHost_Detach_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class RemoteFrameHost_Detach_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    RemoteFrameHost_UpdateViewportIntersection_ParamsSpec.$,
    'RemoteFrameHost_UpdateViewportIntersection_Params',
    [
      mojo.internal.StructField(
        'intersectionState', 0,
        0,
        blink_mojom_ViewportIntersectionStateSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'visualProperties', 8,
        0,
        blink_mojom_FrameVisualPropertiesSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class RemoteFrameHost_UpdateViewportIntersection_Params {
  constructor() {
    /** @type { !blink_mojom_ViewportIntersectionState } */
    this.intersectionState;
    /** @type { (blink_mojom_FrameVisualProperties|undefined) } */
    this.visualProperties;
  }
}



mojo.internal.Struct(
    RemoteFrameHost_SynchronizeVisualProperties_ParamsSpec.$,
    'RemoteFrameHost_SynchronizeVisualProperties_Params',
    [
      mojo.internal.StructField(
        'properties', 0,
        0,
        blink_mojom_FrameVisualPropertiesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RemoteFrameHost_SynchronizeVisualProperties_Params {
  constructor() {
    /** @type { !blink_mojom_FrameVisualProperties } */
    this.properties;
  }
}



mojo.internal.Struct(
    RemoteFrameHost_OpenURL_ParamsSpec.$,
    'RemoteFrameHost_OpenURL_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        OpenURLParamsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RemoteFrameHost_OpenURL_Params {
  constructor() {
    /** @type { !OpenURLParams } */
    this.params;
  }
}



mojo.internal.Struct(
    RemoteFrame_WillEnterFullscreen_ParamsSpec.$,
    'RemoteFrame_WillEnterFullscreen_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        blink_mojom_FullscreenOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RemoteFrame_WillEnterFullscreen_Params {
  constructor() {
    /** @type { !blink_mojom_FullscreenOptions } */
    this.options;
  }
}



mojo.internal.Struct(
    RemoteFrame_EnforceInsecureNavigationsSet_ParamsSpec.$,
    'RemoteFrame_EnforceInsecureNavigationsSet_Params',
    [
      mojo.internal.StructField(
        'set', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint32, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RemoteFrame_EnforceInsecureNavigationsSet_Params {
  constructor() {
    /** @type { !Array<!number> } */
    this.set;
  }
}



mojo.internal.Struct(
    RemoteFrame_SetFrameOwnerProperties_ParamsSpec.$,
    'RemoteFrame_SetFrameOwnerProperties_Params',
    [
      mojo.internal.StructField(
        'properties', 0,
        0,
        blink_mojom_FrameOwnerPropertiesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RemoteFrame_SetFrameOwnerProperties_Params {
  constructor() {
    /** @type { !blink_mojom_FrameOwnerProperties } */
    this.properties;
  }
}



mojo.internal.Struct(
    RemoteFrame_EnforceInsecureRequestPolicy_ParamsSpec.$,
    'RemoteFrame_EnforceInsecureRequestPolicy_Params',
    [
      mojo.internal.StructField(
        'policy', 0,
        0,
        blink_mojom_InsecureRequestPolicySpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RemoteFrame_EnforceInsecureRequestPolicy_Params {
  constructor() {
    /** @type { !blink_mojom_InsecureRequestPolicy } */
    this.policy;
  }
}



mojo.internal.Struct(
    RemoteFrame_SetReplicatedOrigin_ParamsSpec.$,
    'RemoteFrame_SetReplicatedOrigin_Params',
    [
      mojo.internal.StructField(
        'origin', 0,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isPotentiallyTrustworthyUniqueOrigin', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class RemoteFrame_SetReplicatedOrigin_Params {
  constructor() {
    /** @type { !url_mojom_Origin } */
    this.origin;
    /** @type { !boolean } */
    this.isPotentiallyTrustworthyUniqueOrigin;
  }
}



mojo.internal.Struct(
    RemoteFrame_SetReplicatedIsAdFrame_ParamsSpec.$,
    'RemoteFrame_SetReplicatedIsAdFrame_Params',
    [
      mojo.internal.StructField(
        'isAdFrame', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RemoteFrame_SetReplicatedIsAdFrame_Params {
  constructor() {
    /** @type { !boolean } */
    this.isAdFrame;
  }
}



mojo.internal.Struct(
    RemoteFrame_SetReplicatedName_ParamsSpec.$,
    'RemoteFrame_SetReplicatedName_Params',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'uniqueName', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class RemoteFrame_SetReplicatedName_Params {
  constructor() {
    /** @type { !string } */
    this.name;
    /** @type { !string } */
    this.uniqueName;
  }
}



mojo.internal.Struct(
    RemoteFrame_DispatchLoadEventForFrameOwner_ParamsSpec.$,
    'RemoteFrame_DispatchLoadEventForFrameOwner_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class RemoteFrame_DispatchLoadEventForFrameOwner_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    RemoteFrame_SetNeedsOcclusionTracking_ParamsSpec.$,
    'RemoteFrame_SetNeedsOcclusionTracking_Params',
    [
      mojo.internal.StructField(
        'needsTracking', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RemoteFrame_SetNeedsOcclusionTracking_Params {
  constructor() {
    /** @type { !boolean } */
    this.needsTracking;
  }
}



mojo.internal.Struct(
    RemoteFrame_Collapse_ParamsSpec.$,
    'RemoteFrame_Collapse_Params',
    [
      mojo.internal.StructField(
        'collapsed', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RemoteFrame_Collapse_Params {
  constructor() {
    /** @type { !boolean } */
    this.collapsed;
  }
}



mojo.internal.Struct(
    RemoteFrame_Focus_ParamsSpec.$,
    'RemoteFrame_Focus_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class RemoteFrame_Focus_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    RemoteFrame_SetHadStickyUserActivationBeforeNavigation_ParamsSpec.$,
    'RemoteFrame_SetHadStickyUserActivationBeforeNavigation_Params',
    [
      mojo.internal.StructField(
        'hasGesture', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RemoteFrame_SetHadStickyUserActivationBeforeNavigation_Params {
  constructor() {
    /** @type { !boolean } */
    this.hasGesture;
  }
}



mojo.internal.Struct(
    RemoteFrame_BubbleLogicalScroll_ParamsSpec.$,
    'RemoteFrame_BubbleLogicalScroll_Params',
    [
      mojo.internal.StructField(
        'direction', 0,
        0,
        blink_mojom_ScrollDirectionSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'granularity', 4,
        0,
        ui_mojom_ScrollGranularitySpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RemoteFrame_BubbleLogicalScroll_Params {
  constructor() {
    /** @type { !blink_mojom_ScrollDirection } */
    this.direction;
    /** @type { !ui_mojom_ScrollGranularity } */
    this.granularity;
  }
}



mojo.internal.Struct(
    RemoteFrame_UpdateUserActivationState_ParamsSpec.$,
    'RemoteFrame_UpdateUserActivationState_Params',
    [
      mojo.internal.StructField(
        'stateUpdateType', 0,
        0,
        blink_mojom_UserActivationUpdateTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'notificationType', 4,
        0,
        blink_mojom_UserActivationNotificationTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RemoteFrame_UpdateUserActivationState_Params {
  constructor() {
    /** @type { !blink_mojom_UserActivationUpdateType } */
    this.stateUpdateType;
    /** @type { !blink_mojom_UserActivationNotificationType } */
    this.notificationType;
  }
}



mojo.internal.Struct(
    RemoteFrame_SetEmbeddingToken_ParamsSpec.$,
    'RemoteFrame_SetEmbeddingToken_Params',
    [
      mojo.internal.StructField(
        'embeddingToken', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RemoteFrame_SetEmbeddingToken_Params {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.embeddingToken;
  }
}



mojo.internal.Struct(
    RemoteFrame_SetPageFocus_ParamsSpec.$,
    'RemoteFrame_SetPageFocus_Params',
    [
      mojo.internal.StructField(
        'isFocused', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RemoteFrame_SetPageFocus_Params {
  constructor() {
    /** @type { !boolean } */
    this.isFocused;
  }
}



mojo.internal.Struct(
    RemoteFrame_RenderFallbackContent_ParamsSpec.$,
    'RemoteFrame_RenderFallbackContent_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class RemoteFrame_RenderFallbackContent_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    RemoteFrame_AddResourceTimingFromChild_ParamsSpec.$,
    'RemoteFrame_AddResourceTimingFromChild_Params',
    [
      mojo.internal.StructField(
        'timing', 0,
        0,
        blink_mojom_ResourceTimingInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RemoteFrame_AddResourceTimingFromChild_Params {
  constructor() {
    /** @type { !blink_mojom_ResourceTimingInfo } */
    this.timing;
  }
}



mojo.internal.Struct(
    RemoteFrame_ScrollRectToVisible_ParamsSpec.$,
    'RemoteFrame_ScrollRectToVisible_Params',
    [
      mojo.internal.StructField(
        'rect', 0,
        0,
        gfx_mojom_RectFSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'params', 8,
        0,
        blink_mojom_ScrollIntoViewParamsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class RemoteFrame_ScrollRectToVisible_Params {
  constructor() {
    /** @type { !gfx_mojom_RectF } */
    this.rect;
    /** @type { !blink_mojom_ScrollIntoViewParams } */
    this.params;
  }
}



mojo.internal.Struct(
    RemoteFrame_DidStartLoading_ParamsSpec.$,
    'RemoteFrame_DidStartLoading_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class RemoteFrame_DidStartLoading_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    RemoteFrame_DidStopLoading_ParamsSpec.$,
    'RemoteFrame_DidStopLoading_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class RemoteFrame_DidStopLoading_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    RemoteFrame_IntrinsicSizingInfoOfChildChanged_ParamsSpec.$,
    'RemoteFrame_IntrinsicSizingInfoOfChildChanged_Params',
    [
      mojo.internal.StructField(
        'sizingInfo', 0,
        0,
        blink_mojom_IntrinsicSizingInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RemoteFrame_IntrinsicSizingInfoOfChildChanged_Params {
  constructor() {
    /** @type { !blink_mojom_IntrinsicSizingInfo } */
    this.sizingInfo;
  }
}



mojo.internal.Struct(
    RemoteFrame_DidSetFramePolicyHeaders_ParamsSpec.$,
    'RemoteFrame_DidSetFramePolicyHeaders_Params',
    [
      mojo.internal.StructField(
        'sandboxFlags', 0,
        0,
        network_mojom_WebSandboxFlagsSpec.$,
        -1,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'parsedPermissionsPolicy', 8,
        0,
        mojo.internal.Array(network_mojom_ParsedPermissionsPolicyDeclarationSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class RemoteFrame_DidSetFramePolicyHeaders_Params {
  constructor() {
    /** @type { !network_mojom_WebSandboxFlags } */
    this.sandboxFlags;
    /** @type { !Array<!network_mojom_ParsedPermissionsPolicyDeclaration> } */
    this.parsedPermissionsPolicy;
  }
}



mojo.internal.Struct(
    RemoteFrame_DidUpdateFramePolicy_ParamsSpec.$,
    'RemoteFrame_DidUpdateFramePolicy_Params',
    [
      mojo.internal.StructField(
        'framePolicy', 0,
        0,
        blink_mojom_FramePolicySpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RemoteFrame_DidUpdateFramePolicy_Params {
  constructor() {
    /** @type { !blink_mojom_FramePolicy } */
    this.framePolicy;
  }
}



mojo.internal.Struct(
    RemoteFrame_UpdateOpener_ParamsSpec.$,
    'RemoteFrame_UpdateOpener_Params',
    [
      mojo.internal.StructField(
        'openerFrameToken', 0,
        0,
        blink_mojom_FrameTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class RemoteFrame_UpdateOpener_Params {
  constructor() {
    /** @type { (blink_mojom_FrameToken|undefined) } */
    this.openerFrameToken;
  }
}



mojo.internal.Struct(
    RemoteFrame_DetachAndDispose_ParamsSpec.$,
    'RemoteFrame_DetachAndDispose_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class RemoteFrame_DetachAndDispose_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    RemoteFrame_EnableAutoResize_ParamsSpec.$,
    'RemoteFrame_EnableAutoResize_Params',
    [
      mojo.internal.StructField(
        'minSize', 0,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxSize', 8,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class RemoteFrame_EnableAutoResize_Params {
  constructor() {
    /** @type { !gfx_mojom_Size } */
    this.minSize;
    /** @type { !gfx_mojom_Size } */
    this.maxSize;
  }
}



mojo.internal.Struct(
    RemoteFrame_DisableAutoResize_ParamsSpec.$,
    'RemoteFrame_DisableAutoResize_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class RemoteFrame_DisableAutoResize_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    RemoteFrame_DidUpdateVisualProperties_ParamsSpec.$,
    'RemoteFrame_DidUpdateVisualProperties_Params',
    [
      mojo.internal.StructField(
        'metadata', 0,
        0,
        cc_mojom_RenderFrameMetadataSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RemoteFrame_DidUpdateVisualProperties_Params {
  constructor() {
    /** @type { !cc_mojom_RenderFrameMetadata } */
    this.metadata;
  }
}



mojo.internal.Struct(
    RemoteFrame_SetFrameSinkId_ParamsSpec.$,
    'RemoteFrame_SetFrameSinkId_Params',
    [
      mojo.internal.StructField(
        'frameSinkId', 0,
        0,
        viz_mojom_FrameSinkIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allowPaintHolding', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class RemoteFrame_SetFrameSinkId_Params {
  constructor() {
    /** @type { !viz_mojom_FrameSinkId } */
    this.frameSinkId;
    /** @type { !boolean } */
    this.allowPaintHolding;
  }
}



mojo.internal.Struct(
    RemoteFrame_ChildProcessGone_ParamsSpec.$,
    'RemoteFrame_ChildProcessGone_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class RemoteFrame_ChildProcessGone_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    RemoteFrame_CreateRemoteChild_ParamsSpec.$,
    'RemoteFrame_CreateRemoteChild_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        blink_mojom_RemoteFrameTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'openerFrameToken', 8,
        0,
        blink_mojom_FrameTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'treeScopeType', 24,
        0,
        blink_mojom_TreeScopeTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'replicationState', 32,
        0,
        blink_mojom_FrameReplicationStateSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'ownerProperties', 40,
        0,
        blink_mojom_FrameOwnerPropertiesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isLoading', 28,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'devtoolsFrameToken', 48,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'remoteFrameInterfaces', 56,
        0,
        RemoteFrameInterfacesFromBrowserSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 72],]);



/**
 * @record
 */
export class RemoteFrame_CreateRemoteChild_Params {
  constructor() {
    /** @type { !blink_mojom_RemoteFrameToken } */
    this.token;
    /** @type { (blink_mojom_FrameToken|undefined) } */
    this.openerFrameToken;
    /** @type { !blink_mojom_TreeScopeType } */
    this.treeScopeType;
    /** @type { !blink_mojom_FrameReplicationState } */
    this.replicationState;
    /** @type { !blink_mojom_FrameOwnerProperties } */
    this.ownerProperties;
    /** @type { !boolean } */
    this.isLoading;
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.devtoolsFrameToken;
    /** @type { !RemoteFrameInterfacesFromBrowser } */
    this.remoteFrameInterfaces;
  }
}



mojo.internal.Struct(
    RemoteFrame_CreateRemoteChildren_ParamsSpec.$,
    'RemoteFrame_CreateRemoteChildren_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        mojo.internal.Array(CreateRemoteChildParamsSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'navigationMetricsToken', 8,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class RemoteFrame_CreateRemoteChildren_Params {
  constructor() {
    /** @type { !Array<!CreateRemoteChildParams> } */
    this.params;
    /** @type { (mojoBase_mojom_UnguessableToken|undefined) } */
    this.navigationMetricsToken;
  }
}



mojo.internal.Struct(
    RemoteFrame_ForwardFencedFrameEventToEmbedder_ParamsSpec.$,
    'RemoteFrame_ForwardFencedFrameEventToEmbedder_Params',
    [
      mojo.internal.StructField(
        'eventType', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RemoteFrame_ForwardFencedFrameEventToEmbedder_Params {
  constructor() {
    /** @type { !string } */
    this.eventType;
  }
}



mojo.internal.Struct(
    RemoteMainFrame_UpdateTextAutosizerPageInfo_ParamsSpec.$,
    'RemoteMainFrame_UpdateTextAutosizerPageInfo_Params',
    [
      mojo.internal.StructField(
        'pageInfo', 0,
        0,
        blink_mojom_TextAutosizerPageInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RemoteMainFrame_UpdateTextAutosizerPageInfo_Params {
  constructor() {
    /** @type { !blink_mojom_TextAutosizerPageInfo } */
    this.pageInfo;
  }
}



mojo.internal.Struct(
    RemoteMainFrameHost_FocusPage_ParamsSpec.$,
    'RemoteMainFrameHost_FocusPage_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class RemoteMainFrameHost_FocusPage_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    RemoteMainFrameHost_TakeFocus_ParamsSpec.$,
    'RemoteMainFrameHost_TakeFocus_Params',
    [
      mojo.internal.StructField(
        'reverse', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RemoteMainFrameHost_TakeFocus_Params {
  constructor() {
    /** @type { !boolean } */
    this.reverse;
  }
}



mojo.internal.Struct(
    RemoteMainFrameHost_UpdateTargetURL_ParamsSpec.$,
    'RemoteMainFrameHost_UpdateTargetURL_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RemoteMainFrameHost_UpdateTargetURL_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
  }
}



mojo.internal.Struct(
    RemoteMainFrameHost_UpdateTargetURL_ResponseParamsSpec.$,
    'RemoteMainFrameHost_UpdateTargetURL_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class RemoteMainFrameHost_UpdateTargetURL_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    RemoteMainFrameHost_RouteCloseEvent_ParamsSpec.$,
    'RemoteMainFrameHost_RouteCloseEvent_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class RemoteMainFrameHost_RouteCloseEvent_Params {
  constructor() {
  }
}

