// third_party/blink/public/mojom/frame/fullscreen.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/frame/fullscreen.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');



  function FullscreenOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FullscreenOptions.prototype.initDefaults_ = function() {
    this.prefersNavigationBar = false;
    this.prefersStatusBar = false;
    this.isPrefixed = false;
    this.isXrOverlay = false;
    this.displayId = -1;
  };
  FullscreenOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FullscreenOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;






    return validator.validationError.NONE;
  };

  FullscreenOptions.encodedSize = codec.kStructHeaderSize + 16;

  FullscreenOptions.decode = function(decoder) {
    var packed;
    var val = new FullscreenOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.prefersNavigationBar = (packed >> 0) & 1 ? true : false;
    val.prefersStatusBar = (packed >> 1) & 1 ? true : false;
    val.isPrefixed = (packed >> 2) & 1 ? true : false;
    val.isXrOverlay = (packed >> 3) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.displayId =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  FullscreenOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FullscreenOptions.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.prefersNavigationBar & 1) << 0
    packed |= (val.prefersStatusBar & 1) << 1
    packed |= (val.isPrefixed & 1) << 2
    packed |= (val.isXrOverlay & 1) << 3
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int64, val.displayId);
  };
  exports.FullscreenOptions = FullscreenOptions;
})();