// third_party/blink/public/mojom/frame/frame_owner_properties.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_OWNER_PROPERTIES_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_OWNER_PROPERTIES_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/frame/frame_owner_properties.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/frame/frame_owner_properties.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/frame/frame_owner_properties.mojom-blink-forward.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/scroll/scrollbar_mode.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/frame/color_scheme.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/css/preferred_color_scheme.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/renderer/core/core_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {








class CORE_EXPORT FrameOwnerProperties {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FrameOwnerProperties, T>::value>;
  using DataView = FrameOwnerPropertiesDataView;
  using Data_ = internal::FrameOwnerProperties_Data;

  template <typename... Args>
  static FrameOwnerPropertiesPtr New(Args&&... args) {
    return FrameOwnerPropertiesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FrameOwnerPropertiesPtr From(const U& u) {
    return mojo::TypeConverter<FrameOwnerPropertiesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FrameOwnerProperties>::Convert(*this);
  }


  FrameOwnerProperties();

  FrameOwnerProperties(
      const ::blink::String& name,
      ::blink::mojom::blink::ScrollbarMode scrollbar_mode,
      int32_t margin_width,
      int32_t margin_height,
      bool allow_fullscreen,
      bool allow_payment_request,
      bool is_display_none,
      ::blink::mojom::blink::ColorScheme color_scheme,
      ::blink::mojom::blink::PreferredColorScheme preferred_color_scheme);


  ~FrameOwnerProperties();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FrameOwnerPropertiesPtr>
  FrameOwnerPropertiesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FrameOwnerProperties::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FrameOwnerProperties::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FrameOwnerProperties::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FrameOwnerProperties::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FrameOwnerProperties::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FrameOwnerProperties::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FrameOwnerProperties_UnserializedMessageContext<
            UserType, FrameOwnerProperties::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FrameOwnerProperties::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FrameOwnerProperties::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FrameOwnerProperties_UnserializedMessageContext<
            UserType, FrameOwnerProperties::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FrameOwnerProperties::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String name;
  
  ::blink::mojom::blink::ScrollbarMode scrollbar_mode;
  
  int32_t margin_width;
  
  int32_t margin_height;
  
  bool allow_fullscreen;
  
  bool allow_payment_request;
  
  bool is_display_none;
  
  ::blink::mojom::blink::ColorScheme color_scheme;
  
  ::blink::mojom::blink::PreferredColorScheme preferred_color_scheme;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FrameOwnerProperties::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FrameOwnerProperties::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FrameOwnerProperties::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FrameOwnerProperties::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
FrameOwnerPropertiesPtr FrameOwnerProperties::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(scrollbar_mode),
      mojo::Clone(margin_width),
      mojo::Clone(margin_height),
      mojo::Clone(allow_fullscreen),
      mojo::Clone(allow_payment_request),
      mojo::Clone(is_display_none),
      mojo::Clone(color_scheme),
      mojo::Clone(preferred_color_scheme)
  );
}

template <typename T, FrameOwnerProperties::EnableIfSame<T>*>
bool FrameOwnerProperties::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->scrollbar_mode, other_struct.scrollbar_mode))
    return false;
  if (!mojo::Equals(this->margin_width, other_struct.margin_width))
    return false;
  if (!mojo::Equals(this->margin_height, other_struct.margin_height))
    return false;
  if (!mojo::Equals(this->allow_fullscreen, other_struct.allow_fullscreen))
    return false;
  if (!mojo::Equals(this->allow_payment_request, other_struct.allow_payment_request))
    return false;
  if (!mojo::Equals(this->is_display_none, other_struct.is_display_none))
    return false;
  if (!mojo::Equals(this->color_scheme, other_struct.color_scheme))
    return false;
  if (!mojo::Equals(this->preferred_color_scheme, other_struct.preferred_color_scheme))
    return false;
  return true;
}

template <typename T, FrameOwnerProperties::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.scrollbar_mode < rhs.scrollbar_mode)
    return true;
  if (rhs.scrollbar_mode < lhs.scrollbar_mode)
    return false;
  if (lhs.margin_width < rhs.margin_width)
    return true;
  if (rhs.margin_width < lhs.margin_width)
    return false;
  if (lhs.margin_height < rhs.margin_height)
    return true;
  if (rhs.margin_height < lhs.margin_height)
    return false;
  if (lhs.allow_fullscreen < rhs.allow_fullscreen)
    return true;
  if (rhs.allow_fullscreen < lhs.allow_fullscreen)
    return false;
  if (lhs.allow_payment_request < rhs.allow_payment_request)
    return true;
  if (rhs.allow_payment_request < lhs.allow_payment_request)
    return false;
  if (lhs.is_display_none < rhs.is_display_none)
    return true;
  if (rhs.is_display_none < lhs.is_display_none)
    return false;
  if (lhs.color_scheme < rhs.color_scheme)
    return true;
  if (rhs.color_scheme < lhs.color_scheme)
    return false;
  if (lhs.preferred_color_scheme < rhs.preferred_color_scheme)
    return true;
  if (rhs.preferred_color_scheme < lhs.preferred_color_scheme)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct CORE_EXPORT StructTraits<::blink::mojom::blink::FrameOwnerProperties::DataView,
                                         ::blink::mojom::blink::FrameOwnerPropertiesPtr> {
  static bool IsNull(const ::blink::mojom::blink::FrameOwnerPropertiesPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::FrameOwnerPropertiesPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::FrameOwnerProperties::name)& name(
      const ::blink::mojom::blink::FrameOwnerPropertiesPtr& input) {
    return input->name;
  }

  static decltype(::blink::mojom::blink::FrameOwnerProperties::scrollbar_mode) scrollbar_mode(
      const ::blink::mojom::blink::FrameOwnerPropertiesPtr& input) {
    return input->scrollbar_mode;
  }

  static decltype(::blink::mojom::blink::FrameOwnerProperties::margin_width) margin_width(
      const ::blink::mojom::blink::FrameOwnerPropertiesPtr& input) {
    return input->margin_width;
  }

  static decltype(::blink::mojom::blink::FrameOwnerProperties::margin_height) margin_height(
      const ::blink::mojom::blink::FrameOwnerPropertiesPtr& input) {
    return input->margin_height;
  }

  static decltype(::blink::mojom::blink::FrameOwnerProperties::allow_fullscreen) allow_fullscreen(
      const ::blink::mojom::blink::FrameOwnerPropertiesPtr& input) {
    return input->allow_fullscreen;
  }

  static decltype(::blink::mojom::blink::FrameOwnerProperties::allow_payment_request) allow_payment_request(
      const ::blink::mojom::blink::FrameOwnerPropertiesPtr& input) {
    return input->allow_payment_request;
  }

  static decltype(::blink::mojom::blink::FrameOwnerProperties::is_display_none) is_display_none(
      const ::blink::mojom::blink::FrameOwnerPropertiesPtr& input) {
    return input->is_display_none;
  }

  static decltype(::blink::mojom::blink::FrameOwnerProperties::color_scheme) color_scheme(
      const ::blink::mojom::blink::FrameOwnerPropertiesPtr& input) {
    return input->color_scheme;
  }

  static decltype(::blink::mojom::blink::FrameOwnerProperties::preferred_color_scheme) preferred_color_scheme(
      const ::blink::mojom::blink::FrameOwnerPropertiesPtr& input) {
    return input->preferred_color_scheme;
  }

  static bool Read(::blink::mojom::blink::FrameOwnerProperties::DataView input, ::blink::mojom::blink::FrameOwnerPropertiesPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_OWNER_PROPERTIES_MOJOM_BLINK_H_