// third_party/blink/public/mojom/frame/frame.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/frame/frame.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/frame/frame.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* PluginActionTypeToStringHelper(PluginActionType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PluginActionType::kRotate90Clockwise:
      return "kRotate90Clockwise";
    case PluginActionType::kRotate90Counterclockwise:
      return "kRotate90Counterclockwise";
    default:
      return nullptr;
  }
}

std::string PluginActionTypeToString(PluginActionType value) {
  const char *str = PluginActionTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PluginActionType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PluginActionType value) {
  return os << PluginActionTypeToString(value);
}

NOINLINE static const char* JavaScriptExecutionResultTypeToStringHelper(JavaScriptExecutionResultType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case JavaScriptExecutionResultType::kSuccess:
      return "kSuccess";
    case JavaScriptExecutionResultType::kException:
      return "kException";
    default:
      return nullptr;
  }
}

std::string JavaScriptExecutionResultTypeToString(JavaScriptExecutionResultType value) {
  const char *str = JavaScriptExecutionResultTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown JavaScriptExecutionResultType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, JavaScriptExecutionResultType value) {
  return os << JavaScriptExecutionResultTypeToString(value);
}

NOINLINE static const char* TraverseCancelledReasonToStringHelper(TraverseCancelledReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case TraverseCancelledReason::kNotFound:
      return "kNotFound";
    case TraverseCancelledReason::kSandboxViolation:
      return "kSandboxViolation";
    case TraverseCancelledReason::kAbortedBeforeCommit:
      return "kAbortedBeforeCommit";
    default:
      return nullptr;
  }
}

std::string TraverseCancelledReasonToString(TraverseCancelledReason value) {
  const char *str = TraverseCancelledReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown TraverseCancelledReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, TraverseCancelledReason value) {
  return os << TraverseCancelledReasonToString(value);
}

NOINLINE static const char* ViewTransitionSameOriginOptInToStringHelper(ViewTransitionSameOriginOptIn value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ViewTransitionSameOriginOptIn::kDisabled:
      return "kDisabled";
    case ViewTransitionSameOriginOptIn::kEnabled:
      return "kEnabled";
    default:
      return nullptr;
  }
}

std::string ViewTransitionSameOriginOptInToString(ViewTransitionSameOriginOptIn value) {
  const char *str = ViewTransitionSameOriginOptInToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ViewTransitionSameOriginOptIn value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ViewTransitionSameOriginOptIn value) {
  return os << ViewTransitionSameOriginOptInToString(value);
}

NOINLINE static const char* FrameOwnerElementTypeToStringHelper(FrameOwnerElementType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case FrameOwnerElementType::kNone:
      return "kNone";
    case FrameOwnerElementType::kIframe:
      return "kIframe";
    case FrameOwnerElementType::kObject:
      return "kObject";
    case FrameOwnerElementType::kEmbed:
      return "kEmbed";
    case FrameOwnerElementType::kFrame:
      return "kFrame";
    case FrameOwnerElementType::kFencedframe:
      return "kFencedframe";
    default:
      return nullptr;
  }
}

std::string FrameOwnerElementTypeToString(FrameOwnerElementType value) {
  const char *str = FrameOwnerElementTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown FrameOwnerElementType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, FrameOwnerElementType value) {
  return os << FrameOwnerElementTypeToString(value);
}

NOINLINE static const char* NavigationApiEntryRestoreReasonToStringHelper(NavigationApiEntryRestoreReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case NavigationApiEntryRestoreReason::kBFCache:
      return "kBFCache";
    case NavigationApiEntryRestoreReason::kPrerenderActivationPush:
      return "kPrerenderActivationPush";
    case NavigationApiEntryRestoreReason::kPrerenderActivationReplace:
      return "kPrerenderActivationReplace";
    default:
      return nullptr;
  }
}

std::string NavigationApiEntryRestoreReasonToString(NavigationApiEntryRestoreReason value) {
  const char *str = NavigationApiEntryRestoreReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown NavigationApiEntryRestoreReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, NavigationApiEntryRestoreReason value) {
  return os << NavigationApiEntryRestoreReasonToString(value);
}

NOINLINE static const char* StorageTypeAccessedToStringHelper(StorageTypeAccessed value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case StorageTypeAccessed::kCacheStorage:
      return "kCacheStorage";
    case StorageTypeAccessed::kIndexedDB:
      return "kIndexedDB";
    case StorageTypeAccessed::kFileSystem:
      return "kFileSystem";
    case StorageTypeAccessed::kWebLocks:
      return "kWebLocks";
    case StorageTypeAccessed::kLocalStorage:
      return "kLocalStorage";
    case StorageTypeAccessed::kSessionStorage:
      return "kSessionStorage";
    default:
      return nullptr;
  }
}

std::string StorageTypeAccessedToString(StorageTypeAccessed value) {
  const char *str = StorageTypeAccessedToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown StorageTypeAccessed value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, StorageTypeAccessed value) {
  return os << StorageTypeAccessedToString(value);
}

NOINLINE static const char* WindowProxyAccessTypeToStringHelper(WindowProxyAccessType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WindowProxyAccessType::kLocation:
      return "kLocation";
    case WindowProxyAccessType::kClosed:
      return "kClosed";
    case WindowProxyAccessType::kLength:
      return "kLength";
    case WindowProxyAccessType::kSelf:
      return "kSelf";
    case WindowProxyAccessType::kWindow:
      return "kWindow";
    case WindowProxyAccessType::kFrames:
      return "kFrames";
    case WindowProxyAccessType::kOpener:
      return "kOpener";
    case WindowProxyAccessType::kParent:
      return "kParent";
    case WindowProxyAccessType::kTop:
      return "kTop";
    case WindowProxyAccessType::kPostMessage:
      return "kPostMessage";
    case WindowProxyAccessType::kAnonymousIndexedGetter:
      return "kAnonymousIndexedGetter";
    case WindowProxyAccessType::kClose:
      return "kClose";
    case WindowProxyAccessType::kFocus:
      return "kFocus";
    case WindowProxyAccessType::kBlur:
      return "kBlur";
    case WindowProxyAccessType::kAnonymousNamedGetter:
      return "kAnonymousNamedGetter";
    default:
      return nullptr;
  }
}

std::string WindowProxyAccessTypeToString(WindowProxyAccessType value) {
  const char *str = WindowProxyAccessTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WindowProxyAccessType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WindowProxyAccessType value) {
  return os << WindowProxyAccessTypeToString(value);
}

namespace internal {


// static
bool SavableSubframe_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SavableSubframe_Data* object =
      static_cast<const SavableSubframe_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->original_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->original_url, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->subframe_token, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->subframe_token, validation_context))
    return false;

  return true;
}

SavableSubframe_Data::SavableSubframe_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GetSavableResourceLinksReply_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GetSavableResourceLinksReply_Data* object =
      static_cast<const GetSavableResourceLinksReply_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->resources_list, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& resources_list_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->resources_list, validation_context,
                                         &resources_list_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->referrer, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->referrer, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->subframes, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& subframes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->subframes, validation_context,
                                         &subframes_validate_params)) {
    return false;
  }

  return true;
}

GetSavableResourceLinksReply_Data::GetSavableResourceLinksReply_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FindInPageResultAXParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FindInPageResultAXParams_Data* object =
      static_cast<const FindInPageResultAXParams_Data*>(data);

  return true;
}

FindInPageResultAXParams_Data::FindInPageResultAXParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SerializedDomElementInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SerializedDomElementInfo_Data* object =
      static_cast<const SerializedDomElementInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tag, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& tag_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->tag, validation_context,
                                         &tag_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->selector, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& selector_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->selector, validation_context,
                                         &selector_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->visible_bounds, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->click_point, validation_context))
    return false;

  return true;
}

SerializedDomElementInfo_Data::SerializedDomElementInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DownloadURLParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DownloadURLParams_Data* object =
      static_cast<const DownloadURLParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->referrer, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->initiator_origin, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->suggested_name, validation_context))
    return false;


  if (!::network::mojom::internal::RedirectMode_Data
        ::Validate(object->cross_origin_redirects, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->blob_url_token,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->data_url_blob,
                                                 validation_context)) {
    return false;
  }

  return true;
}

DownloadURLParams_Data::DownloadURLParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IframeAttributes_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IframeAttributes_Data* object =
      static_cast<const IframeAttributes_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->parsed_csp_attribute, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& src_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->src, validation_context,
                                         &src_validate_params)) {
    return false;
  }

  return true;
}

IframeAttributes_Data::IframeAttributes_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LegacyTechEventCodeLocation_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LegacyTechEventCodeLocation_Data* object =
      static_cast<const LegacyTechEventCodeLocation_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->filename, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& filename_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->filename, validation_context,
                                         &filename_validate_params)) {
    return false;
  }

  return true;
}

LegacyTechEventCodeLocation_Data::LegacyTechEventCodeLocation_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_EnterFullscreen_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_EnterFullscreen_Params_Data* object =
      static_cast<const LocalFrameHost_EnterFullscreen_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

LocalFrameHost_EnterFullscreen_Params_Data::LocalFrameHost_EnterFullscreen_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_EnterFullscreen_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_EnterFullscreen_ResponseParams_Data* object =
      static_cast<const LocalFrameHost_EnterFullscreen_ResponseParams_Data*>(data);

  return true;
}

LocalFrameHost_EnterFullscreen_ResponseParams_Data::LocalFrameHost_EnterFullscreen_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_ExitFullscreen_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_ExitFullscreen_Params_Data* object =
      static_cast<const LocalFrameHost_ExitFullscreen_Params_Data*>(data);

  return true;
}

LocalFrameHost_ExitFullscreen_Params_Data::LocalFrameHost_ExitFullscreen_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_FullscreenStateChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_FullscreenStateChanged_Params_Data* object =
      static_cast<const LocalFrameHost_FullscreenStateChanged_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

LocalFrameHost_FullscreenStateChanged_Params_Data::LocalFrameHost_FullscreenStateChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_RegisterProtocolHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_RegisterProtocolHandler_Params_Data* object =
      static_cast<const LocalFrameHost_RegisterProtocolHandler_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scheme, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& scheme_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->scheme, validation_context,
                                         &scheme_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

LocalFrameHost_RegisterProtocolHandler_Params_Data::LocalFrameHost_RegisterProtocolHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_UnregisterProtocolHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_UnregisterProtocolHandler_Params_Data* object =
      static_cast<const LocalFrameHost_UnregisterProtocolHandler_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scheme, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& scheme_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->scheme, validation_context,
                                         &scheme_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

LocalFrameHost_UnregisterProtocolHandler_Params_Data::LocalFrameHost_UnregisterProtocolHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DidDisplayInsecureContent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_DidDisplayInsecureContent_Params_Data* object =
      static_cast<const LocalFrameHost_DidDisplayInsecureContent_Params_Data*>(data);

  return true;
}

LocalFrameHost_DidDisplayInsecureContent_Params_Data::LocalFrameHost_DidDisplayInsecureContent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DidContainInsecureFormAction_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_DidContainInsecureFormAction_Params_Data* object =
      static_cast<const LocalFrameHost_DidContainInsecureFormAction_Params_Data*>(data);

  return true;
}

LocalFrameHost_DidContainInsecureFormAction_Params_Data::LocalFrameHost_DidContainInsecureFormAction_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_MainDocumentElementAvailable_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_MainDocumentElementAvailable_Params_Data* object =
      static_cast<const LocalFrameHost_MainDocumentElementAvailable_Params_Data*>(data);

  return true;
}

LocalFrameHost_MainDocumentElementAvailable_Params_Data::LocalFrameHost_MainDocumentElementAvailable_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_SetNeedsOcclusionTracking_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_SetNeedsOcclusionTracking_Params_Data* object =
      static_cast<const LocalFrameHost_SetNeedsOcclusionTracking_Params_Data*>(data);

  return true;
}

LocalFrameHost_SetNeedsOcclusionTracking_Params_Data::LocalFrameHost_SetNeedsOcclusionTracking_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_SetVirtualKeyboardMode_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_SetVirtualKeyboardMode_Params_Data* object =
      static_cast<const LocalFrameHost_SetVirtualKeyboardMode_Params_Data*>(data);


  if (!::ui::mojom::internal::VirtualKeyboardMode_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

LocalFrameHost_SetVirtualKeyboardMode_Params_Data::LocalFrameHost_SetVirtualKeyboardMode_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_VisibilityChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_VisibilityChanged_Params_Data* object =
      static_cast<const LocalFrameHost_VisibilityChanged_Params_Data*>(data);


  if (!::blink::mojom::internal::FrameVisibility_Data
        ::Validate(object->visibility, validation_context))
    return false;

  return true;
}

LocalFrameHost_VisibilityChanged_Params_Data::LocalFrameHost_VisibilityChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DidChangeThemeColor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_DidChangeThemeColor_Params_Data* object =
      static_cast<const LocalFrameHost_DidChangeThemeColor_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->theme_color, validation_context))
    return false;

  return true;
}

LocalFrameHost_DidChangeThemeColor_Params_Data::LocalFrameHost_DidChangeThemeColor_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DidChangeBackgroundColor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_DidChangeBackgroundColor_Params_Data* object =
      static_cast<const LocalFrameHost_DidChangeBackgroundColor_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->background_color, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->background_color, validation_context))
    return false;

  return true;
}

LocalFrameHost_DidChangeBackgroundColor_Params_Data::LocalFrameHost_DidChangeBackgroundColor_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DidFailLoadWithError_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_DidFailLoadWithError_Params_Data* object =
      static_cast<const LocalFrameHost_DidFailLoadWithError_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

LocalFrameHost_DidFailLoadWithError_Params_Data::LocalFrameHost_DidFailLoadWithError_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DidFocusFrame_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_DidFocusFrame_Params_Data* object =
      static_cast<const LocalFrameHost_DidFocusFrame_Params_Data*>(data);

  return true;
}

LocalFrameHost_DidFocusFrame_Params_Data::LocalFrameHost_DidFocusFrame_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DidCallFocus_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_DidCallFocus_Params_Data* object =
      static_cast<const LocalFrameHost_DidCallFocus_Params_Data*>(data);

  return true;
}

LocalFrameHost_DidCallFocus_Params_Data::LocalFrameHost_DidCallFocus_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_EnforceInsecureRequestPolicy_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_EnforceInsecureRequestPolicy_Params_Data* object =
      static_cast<const LocalFrameHost_EnforceInsecureRequestPolicy_Params_Data*>(data);


  if (!::blink::mojom::internal::InsecureRequestPolicy_Data
        ::Validate(object->policy_bitmap, validation_context))
    return false;

  return true;
}

LocalFrameHost_EnforceInsecureRequestPolicy_Params_Data::LocalFrameHost_EnforceInsecureRequestPolicy_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_EnforceInsecureNavigationsSet_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_EnforceInsecureNavigationsSet_Params_Data* object =
      static_cast<const LocalFrameHost_EnforceInsecureNavigationsSet_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->set, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& set_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->set, validation_context,
                                         &set_validate_params)) {
    return false;
  }

  return true;
}

LocalFrameHost_EnforceInsecureNavigationsSet_Params_Data::LocalFrameHost_EnforceInsecureNavigationsSet_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_SuddenTerminationDisablerChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_SuddenTerminationDisablerChanged_Params_Data* object =
      static_cast<const LocalFrameHost_SuddenTerminationDisablerChanged_Params_Data*>(data);


  if (!::blink::mojom::internal::SuddenTerminationDisablerType_Data
        ::Validate(object->disabler_type, validation_context))
    return false;

  return true;
}

LocalFrameHost_SuddenTerminationDisablerChanged_Params_Data::LocalFrameHost_SuddenTerminationDisablerChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_HadStickyUserActivationBeforeNavigationChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_HadStickyUserActivationBeforeNavigationChanged_Params_Data* object =
      static_cast<const LocalFrameHost_HadStickyUserActivationBeforeNavigationChanged_Params_Data*>(data);

  return true;
}

LocalFrameHost_HadStickyUserActivationBeforeNavigationChanged_Params_Data::LocalFrameHost_HadStickyUserActivationBeforeNavigationChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_ScrollRectToVisibleInParentFrame_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_ScrollRectToVisibleInParentFrame_Params_Data* object =
      static_cast<const LocalFrameHost_ScrollRectToVisibleInParentFrame_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rect_to_scroll, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->rect_to_scroll, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

LocalFrameHost_ScrollRectToVisibleInParentFrame_Params_Data::LocalFrameHost_ScrollRectToVisibleInParentFrame_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_BubbleLogicalScrollInParentFrame_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_BubbleLogicalScrollInParentFrame_Params_Data* object =
      static_cast<const LocalFrameHost_BubbleLogicalScrollInParentFrame_Params_Data*>(data);


  if (!::blink::mojom::internal::ScrollDirection_Data
        ::Validate(object->direction, validation_context))
    return false;


  if (!::ui::mojom::internal::ScrollGranularity_Data
        ::Validate(object->granularity, validation_context))
    return false;

  return true;
}

LocalFrameHost_BubbleLogicalScrollInParentFrame_Params_Data::LocalFrameHost_BubbleLogicalScrollInParentFrame_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_StartLoadingForAsyncNavigationApiCommit_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_StartLoadingForAsyncNavigationApiCommit_Params_Data* object =
      static_cast<const LocalFrameHost_StartLoadingForAsyncNavigationApiCommit_Params_Data*>(data);

  return true;
}

LocalFrameHost_StartLoadingForAsyncNavigationApiCommit_Params_Data::LocalFrameHost_StartLoadingForAsyncNavigationApiCommit_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DidBlockNavigation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_DidBlockNavigation_Params_Data* object =
      static_cast<const LocalFrameHost_DidBlockNavigation_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->blocked_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->blocked_url, validation_context))
    return false;


  if (!::blink::mojom::internal::NavigationBlockedReason_Data
        ::Validate(object->reason, validation_context))
    return false;

  return true;
}

LocalFrameHost_DidBlockNavigation_Params_Data::LocalFrameHost_DidBlockNavigation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DidChangeLoadProgress_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_DidChangeLoadProgress_Params_Data* object =
      static_cast<const LocalFrameHost_DidChangeLoadProgress_Params_Data*>(data);

  return true;
}

LocalFrameHost_DidChangeLoadProgress_Params_Data::LocalFrameHost_DidChangeLoadProgress_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DidFinishLoad_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_DidFinishLoad_Params_Data* object =
      static_cast<const LocalFrameHost_DidFinishLoad_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->validated_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->validated_url, validation_context))
    return false;

  return true;
}

LocalFrameHost_DidFinishLoad_Params_Data::LocalFrameHost_DidFinishLoad_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DispatchLoad_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_DispatchLoad_Params_Data* object =
      static_cast<const LocalFrameHost_DispatchLoad_Params_Data*>(data);

  return true;
}

LocalFrameHost_DispatchLoad_Params_Data::LocalFrameHost_DispatchLoad_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_GoToEntryAtOffset_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_GoToEntryAtOffset_Params_Data* object =
      static_cast<const LocalFrameHost_GoToEntryAtOffset_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->actual_navigation_start, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->actual_navigation_start, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->soft_navigation_heuristics_task_id, validation_context))
    return false;

  return true;
}

LocalFrameHost_GoToEntryAtOffset_Params_Data::LocalFrameHost_GoToEntryAtOffset_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_NavigateToNavigationApiKey_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_NavigateToNavigationApiKey_Params_Data* object =
      static_cast<const LocalFrameHost_NavigateToNavigationApiKey_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->key, validation_context,
                                         &key_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->actual_navigation_start, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->actual_navigation_start, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->soft_navigation_heuristics_task_id, validation_context))
    return false;

  return true;
}

LocalFrameHost_NavigateToNavigationApiKey_Params_Data::LocalFrameHost_NavigateToNavigationApiKey_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_NavigateEventHandlerPresenceChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_NavigateEventHandlerPresenceChanged_Params_Data* object =
      static_cast<const LocalFrameHost_NavigateEventHandlerPresenceChanged_Params_Data*>(data);

  return true;
}

LocalFrameHost_NavigateEventHandlerPresenceChanged_Params_Data::LocalFrameHost_NavigateEventHandlerPresenceChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_UpdateTitle_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_UpdateTitle_Params_Data* object =
      static_cast<const LocalFrameHost_UpdateTitle_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->title, validation_context))
    return false;


  if (!::mojo_base::mojom::internal::TextDirection_Data
        ::Validate(object->title_direction, validation_context))
    return false;

  return true;
}

LocalFrameHost_UpdateTitle_Params_Data::LocalFrameHost_UpdateTitle_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_UpdateApplicationTitle_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_UpdateApplicationTitle_Params_Data* object =
      static_cast<const LocalFrameHost_UpdateApplicationTitle_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->application_title, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->application_title, validation_context))
    return false;

  return true;
}

LocalFrameHost_UpdateApplicationTitle_Params_Data::LocalFrameHost_UpdateApplicationTitle_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_UpdateUserActivationState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_UpdateUserActivationState_Params_Data* object =
      static_cast<const LocalFrameHost_UpdateUserActivationState_Params_Data*>(data);


  if (!::blink::mojom::internal::UserActivationUpdateType_Data
        ::Validate(object->update_type, validation_context))
    return false;


  if (!::blink::mojom::internal::UserActivationNotificationType_Data
        ::Validate(object->notification_type, validation_context))
    return false;

  return true;
}

LocalFrameHost_UpdateUserActivationState_Params_Data::LocalFrameHost_UpdateUserActivationState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DidConsumeHistoryUserActivation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_DidConsumeHistoryUserActivation_Params_Data* object =
      static_cast<const LocalFrameHost_DidConsumeHistoryUserActivation_Params_Data*>(data);

  return true;
}

LocalFrameHost_DidConsumeHistoryUserActivation_Params_Data::LocalFrameHost_DidConsumeHistoryUserActivation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_HandleAccessibilityFindInPageResult_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_HandleAccessibilityFindInPageResult_Params_Data* object =
      static_cast<const LocalFrameHost_HandleAccessibilityFindInPageResult_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

LocalFrameHost_HandleAccessibilityFindInPageResult_Params_Data::LocalFrameHost_HandleAccessibilityFindInPageResult_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_HandleAccessibilityFindInPageTermination_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_HandleAccessibilityFindInPageTermination_Params_Data* object =
      static_cast<const LocalFrameHost_HandleAccessibilityFindInPageTermination_Params_Data*>(data);

  return true;
}

LocalFrameHost_HandleAccessibilityFindInPageTermination_Params_Data::LocalFrameHost_HandleAccessibilityFindInPageTermination_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DocumentOnLoadCompleted_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_DocumentOnLoadCompleted_Params_Data* object =
      static_cast<const LocalFrameHost_DocumentOnLoadCompleted_Params_Data*>(data);

  return true;
}

LocalFrameHost_DocumentOnLoadCompleted_Params_Data::LocalFrameHost_DocumentOnLoadCompleted_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_ForwardResourceTimingToParent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_ForwardResourceTimingToParent_Params_Data* object =
      static_cast<const LocalFrameHost_ForwardResourceTimingToParent_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->timing, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->timing, validation_context))
    return false;

  return true;
}

LocalFrameHost_ForwardResourceTimingToParent_Params_Data::LocalFrameHost_ForwardResourceTimingToParent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DidDispatchDOMContentLoadedEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_DidDispatchDOMContentLoadedEvent_Params_Data* object =
      static_cast<const LocalFrameHost_DidDispatchDOMContentLoadedEvent_Params_Data*>(data);

  return true;
}

LocalFrameHost_DidDispatchDOMContentLoadedEvent_Params_Data::LocalFrameHost_DidDispatchDOMContentLoadedEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_RunModalAlertDialog_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_RunModalAlertDialog_Params_Data* object =
      static_cast<const LocalFrameHost_RunModalAlertDialog_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->alert_message, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->alert_message, validation_context))
    return false;

  return true;
}

LocalFrameHost_RunModalAlertDialog_Params_Data::LocalFrameHost_RunModalAlertDialog_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_RunModalAlertDialog_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_RunModalAlertDialog_ResponseParams_Data* object =
      static_cast<const LocalFrameHost_RunModalAlertDialog_ResponseParams_Data*>(data);

  return true;
}

LocalFrameHost_RunModalAlertDialog_ResponseParams_Data::LocalFrameHost_RunModalAlertDialog_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_RunModalConfirmDialog_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_RunModalConfirmDialog_Params_Data* object =
      static_cast<const LocalFrameHost_RunModalConfirmDialog_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->alert_message, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->alert_message, validation_context))
    return false;

  return true;
}

LocalFrameHost_RunModalConfirmDialog_Params_Data::LocalFrameHost_RunModalConfirmDialog_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_RunModalConfirmDialog_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_RunModalConfirmDialog_ResponseParams_Data* object =
      static_cast<const LocalFrameHost_RunModalConfirmDialog_ResponseParams_Data*>(data);

  return true;
}

LocalFrameHost_RunModalConfirmDialog_ResponseParams_Data::LocalFrameHost_RunModalConfirmDialog_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_RunModalPromptDialog_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_RunModalPromptDialog_Params_Data* object =
      static_cast<const LocalFrameHost_RunModalPromptDialog_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->alert_message, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->alert_message, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->default_value, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->default_value, validation_context))
    return false;

  return true;
}

LocalFrameHost_RunModalPromptDialog_Params_Data::LocalFrameHost_RunModalPromptDialog_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_RunModalPromptDialog_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_RunModalPromptDialog_ResponseParams_Data* object =
      static_cast<const LocalFrameHost_RunModalPromptDialog_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

LocalFrameHost_RunModalPromptDialog_ResponseParams_Data::LocalFrameHost_RunModalPromptDialog_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_RunBeforeUnloadConfirm_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_RunBeforeUnloadConfirm_Params_Data* object =
      static_cast<const LocalFrameHost_RunBeforeUnloadConfirm_Params_Data*>(data);

  return true;
}

LocalFrameHost_RunBeforeUnloadConfirm_Params_Data::LocalFrameHost_RunBeforeUnloadConfirm_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_RunBeforeUnloadConfirm_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_RunBeforeUnloadConfirm_ResponseParams_Data* object =
      static_cast<const LocalFrameHost_RunBeforeUnloadConfirm_ResponseParams_Data*>(data);

  return true;
}

LocalFrameHost_RunBeforeUnloadConfirm_ResponseParams_Data::LocalFrameHost_RunBeforeUnloadConfirm_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_UpdateFaviconURL_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_UpdateFaviconURL_Params_Data* object =
      static_cast<const LocalFrameHost_UpdateFaviconURL_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->favicon_urls, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& favicon_urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->favicon_urls, validation_context,
                                         &favicon_urls_validate_params)) {
    return false;
  }

  return true;
}

LocalFrameHost_UpdateFaviconURL_Params_Data::LocalFrameHost_UpdateFaviconURL_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DownloadURL_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_DownloadURL_Params_Data* object =
      static_cast<const LocalFrameHost_DownloadURL_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

LocalFrameHost_DownloadURL_Params_Data::LocalFrameHost_DownloadURL_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_FocusedElementChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_FocusedElementChanged_Params_Data* object =
      static_cast<const LocalFrameHost_FocusedElementChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bounds_in_frame_widget, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bounds_in_frame_widget, validation_context))
    return false;


  if (!::blink::mojom::internal::FocusType_Data
        ::Validate(object->focus_type, validation_context))
    return false;

  return true;
}

LocalFrameHost_FocusedElementChanged_Params_Data::LocalFrameHost_FocusedElementChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_TextSelectionChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_TextSelectionChanged_Params_Data* object =
      static_cast<const LocalFrameHost_TextSelectionChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->text, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->range, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->range, validation_context))
    return false;

  return true;
}

LocalFrameHost_TextSelectionChanged_Params_Data::LocalFrameHost_TextSelectionChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_ShowPopupMenu_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_ShowPopupMenu_Params_Data* object =
      static_cast<const LocalFrameHost_ShowPopupMenu_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->popup_client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->popup_client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bounds, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bounds, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->menu_items, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& menu_items_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->menu_items, validation_context,
                                         &menu_items_validate_params)) {
    return false;
  }

  return true;
}

LocalFrameHost_ShowPopupMenu_Params_Data::LocalFrameHost_ShowPopupMenu_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_CreateNewPopupWidget_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_CreateNewPopupWidget_Params_Data* object =
      static_cast<const LocalFrameHost_CreateNewPopupWidget_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->popup_host, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->popup_host,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->blink_widget_host, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->blink_widget_host,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->blink_widget, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->blink_widget,
                                                 validation_context)) {
    return false;
  }

  return true;
}

LocalFrameHost_CreateNewPopupWidget_Params_Data::LocalFrameHost_CreateNewPopupWidget_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_ShowContextMenu_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_ShowContextMenu_Params_Data* object =
      static_cast<const LocalFrameHost_ShowContextMenu_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

LocalFrameHost_ShowContextMenu_Params_Data::LocalFrameHost_ShowContextMenu_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DidLoadResourceFromMemoryCache_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_DidLoadResourceFromMemoryCache_Params_Data* object =
      static_cast<const LocalFrameHost_DidLoadResourceFromMemoryCache_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->http_method, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& http_method_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->http_method, validation_context,
                                         &http_method_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mime_type, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& mime_type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->mime_type, validation_context,
                                         &mime_type_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::RequestDestination_Data
        ::Validate(object->request_destination, validation_context))
    return false;

  return true;
}

LocalFrameHost_DidLoadResourceFromMemoryCache_Params_Data::LocalFrameHost_DidLoadResourceFromMemoryCache_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DidChangeFrameOwnerProperties_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_DidChangeFrameOwnerProperties_Params_Data* object =
      static_cast<const LocalFrameHost_DidChangeFrameOwnerProperties_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->child_frame_token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->child_frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_owner_properties, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_owner_properties, validation_context))
    return false;

  return true;
}

LocalFrameHost_DidChangeFrameOwnerProperties_Params_Data::LocalFrameHost_DidChangeFrameOwnerProperties_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DidChangeOpener_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_DidChangeOpener_Params_Data* object =
      static_cast<const LocalFrameHost_DidChangeOpener_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->opener_frame, validation_context))
    return false;

  return true;
}

LocalFrameHost_DidChangeOpener_Params_Data::LocalFrameHost_DidChangeOpener_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DidChangeFramePolicy_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_DidChangeFramePolicy_Params_Data* object =
      static_cast<const LocalFrameHost_DidChangeFramePolicy_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->child_frame_token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->child_frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_policy, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_policy, validation_context))
    return false;

  return true;
}

LocalFrameHost_DidChangeFramePolicy_Params_Data::LocalFrameHost_DidChangeFramePolicy_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DidChangeIframeAttributes_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_DidChangeIframeAttributes_Params_Data* object =
      static_cast<const LocalFrameHost_DidChangeIframeAttributes_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->child_frame_token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->child_frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->attributes, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->attributes, validation_context))
    return false;

  return true;
}

LocalFrameHost_DidChangeIframeAttributes_Params_Data::LocalFrameHost_DidChangeIframeAttributes_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_CapturePaintPreviewOfSubframe_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_CapturePaintPreviewOfSubframe_Params_Data* object =
      static_cast<const LocalFrameHost_CapturePaintPreviewOfSubframe_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->clip_rect, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->clip_rect, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->guid, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->guid, validation_context))
    return false;

  return true;
}

LocalFrameHost_CapturePaintPreviewOfSubframe_Params_Data::LocalFrameHost_CapturePaintPreviewOfSubframe_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_SetCloseListener_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_SetCloseListener_Params_Data* object =
      static_cast<const LocalFrameHost_SetCloseListener_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->listener, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->listener,
                                                 validation_context)) {
    return false;
  }

  return true;
}

LocalFrameHost_SetCloseListener_Params_Data::LocalFrameHost_SetCloseListener_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_Detach_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_Detach_Params_Data* object =
      static_cast<const LocalFrameHost_Detach_Params_Data*>(data);

  return true;
}

LocalFrameHost_Detach_Params_Data::LocalFrameHost_Detach_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_GetKeepAliveHandleFactory_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_GetKeepAliveHandleFactory_Params_Data* object =
      static_cast<const LocalFrameHost_GetKeepAliveHandleFactory_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->factory, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->factory,
                                                 validation_context)) {
    return false;
  }

  return true;
}

LocalFrameHost_GetKeepAliveHandleFactory_Params_Data::LocalFrameHost_GetKeepAliveHandleFactory_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DidAddMessageToConsole_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_DidAddMessageToConsole_Params_Data* object =
      static_cast<const LocalFrameHost_DidAddMessageToConsole_Params_Data*>(data);


  if (!::blink::mojom::internal::ConsoleMessageLevel_Data
        ::Validate(object->log_level, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->msg, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->msg, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->source_id, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->untrusted_stack_trace, validation_context))
    return false;

  return true;
}

LocalFrameHost_DidAddMessageToConsole_Params_Data::LocalFrameHost_DidAddMessageToConsole_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_FrameSizeChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_FrameSizeChanged_Params_Data* object =
      static_cast<const LocalFrameHost_FrameSizeChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->size, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->size, validation_context))
    return false;

  return true;
}

LocalFrameHost_FrameSizeChanged_Params_Data::LocalFrameHost_FrameSizeChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DidInferColorScheme_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_DidInferColorScheme_Params_Data* object =
      static_cast<const LocalFrameHost_DidInferColorScheme_Params_Data*>(data);


  if (!::blink::mojom::internal::PreferredColorScheme_Data
        ::Validate(object->color_scheme, validation_context))
    return false;

  return true;
}

LocalFrameHost_DidInferColorScheme_Params_Data::LocalFrameHost_DidInferColorScheme_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DidChangeSrcDoc_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_DidChangeSrcDoc_Params_Data* object =
      static_cast<const LocalFrameHost_DidChangeSrcDoc_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->child_frame_token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->child_frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->srcdoc_value, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& srcdoc_value_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->srcdoc_value, validation_context,
                                         &srcdoc_value_validate_params)) {
    return false;
  }

  return true;
}

LocalFrameHost_DidChangeSrcDoc_Params_Data::LocalFrameHost_DidChangeSrcDoc_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_ReceivedDelegatedCapability_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_ReceivedDelegatedCapability_Params_Data* object =
      static_cast<const LocalFrameHost_ReceivedDelegatedCapability_Params_Data*>(data);


  if (!::blink::mojom::internal::DelegatedCapability_Data
        ::Validate(object->delegated_capability, validation_context))
    return false;

  return true;
}

LocalFrameHost_ReceivedDelegatedCapability_Params_Data::LocalFrameHost_ReceivedDelegatedCapability_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_SendFencedFrameReportingBeacon_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_SendFencedFrameReportingBeacon_Params_Data* object =
      static_cast<const LocalFrameHost_SendFencedFrameReportingBeacon_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event_data, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& event_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->event_data, validation_context,
                                         &event_data_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event_type, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& event_type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->event_type, validation_context,
                                         &event_type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->destinations, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& destinations_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::ReportingDestination_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->destinations, validation_context,
                                         &destinations_validate_params)) {
    return false;
  }

  return true;
}

LocalFrameHost_SendFencedFrameReportingBeacon_Params_Data::LocalFrameHost_SendFencedFrameReportingBeacon_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_SendFencedFrameReportingBeaconToCustomURL_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_SendFencedFrameReportingBeaconToCustomURL_Params_Data* object =
      static_cast<const LocalFrameHost_SendFencedFrameReportingBeaconToCustomURL_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->destination_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->destination_url, validation_context))
    return false;

  return true;
}

LocalFrameHost_SendFencedFrameReportingBeaconToCustomURL_Params_Data::LocalFrameHost_SendFencedFrameReportingBeaconToCustomURL_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DisableUntrustedNetworkInFencedFrame_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_DisableUntrustedNetworkInFencedFrame_Params_Data* object =
      static_cast<const LocalFrameHost_DisableUntrustedNetworkInFencedFrame_Params_Data*>(data);

  return true;
}

LocalFrameHost_DisableUntrustedNetworkInFencedFrame_Params_Data::LocalFrameHost_DisableUntrustedNetworkInFencedFrame_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DisableUntrustedNetworkInFencedFrame_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_DisableUntrustedNetworkInFencedFrame_ResponseParams_Data* object =
      static_cast<const LocalFrameHost_DisableUntrustedNetworkInFencedFrame_ResponseParams_Data*>(data);

  return true;
}

LocalFrameHost_DisableUntrustedNetworkInFencedFrame_ResponseParams_Data::LocalFrameHost_DisableUntrustedNetworkInFencedFrame_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_Params_Data* object =
      static_cast<const LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->exempted_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->exempted_url, validation_context))
    return false;

  return true;
}

LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_Params_Data::LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_ResponseParams_Data* object =
      static_cast<const LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_ResponseParams_Data*>(data);

  return true;
}

LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_ResponseParams_Data::LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_SendLegacyTechEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_SendLegacyTechEvent_Params_Data* object =
      static_cast<const LocalFrameHost_SendLegacyTechEvent_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->type, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->type, validation_context,
                                         &type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->code_location, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->code_location, validation_context))
    return false;

  return true;
}

LocalFrameHost_SendLegacyTechEvent_Params_Data::LocalFrameHost_SendLegacyTechEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_SetFencedFrameAutomaticBeaconReportEventData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_SetFencedFrameAutomaticBeaconReportEventData_Params_Data* object =
      static_cast<const LocalFrameHost_SetFencedFrameAutomaticBeaconReportEventData_Params_Data*>(data);


  if (!::blink::mojom::internal::AutomaticBeaconType_Data
        ::Validate(object->event_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event_data, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& event_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->event_data, validation_context,
                                         &event_data_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->destinations, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& destinations_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::ReportingDestination_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->destinations, validation_context,
                                         &destinations_validate_params)) {
    return false;
  }

  return true;
}

LocalFrameHost_SetFencedFrameAutomaticBeaconReportEventData_Params_Data::LocalFrameHost_SetFencedFrameAutomaticBeaconReportEventData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_SendPrivateAggregationRequestsForFencedFrameEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_SendPrivateAggregationRequestsForFencedFrameEvent_Params_Data* object =
      static_cast<const LocalFrameHost_SendPrivateAggregationRequestsForFencedFrameEvent_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event_type, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& event_type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->event_type, validation_context,
                                         &event_type_validate_params)) {
    return false;
  }

  return true;
}

LocalFrameHost_SendPrivateAggregationRequestsForFencedFrameEvent_Params_Data::LocalFrameHost_SendPrivateAggregationRequestsForFencedFrameEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_CreateFencedFrame_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_CreateFencedFrame_Params_Data* object =
      static_cast<const LocalFrameHost_CreateFencedFrame_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->fenced_frame, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->fenced_frame,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->remote_frame_interfaces, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->remote_frame_interfaces, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_token, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devtools_frame_token, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->devtools_frame_token, validation_context))
    return false;

  return true;
}

LocalFrameHost_CreateFencedFrame_Params_Data::LocalFrameHost_CreateFencedFrame_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_ForwardFencedFrameEventAndUserActivationToEmbedder_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_ForwardFencedFrameEventAndUserActivationToEmbedder_Params_Data* object =
      static_cast<const LocalFrameHost_ForwardFencedFrameEventAndUserActivationToEmbedder_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event_type, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& event_type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->event_type, validation_context,
                                         &event_type_validate_params)) {
    return false;
  }

  return true;
}

LocalFrameHost_ForwardFencedFrameEventAndUserActivationToEmbedder_Params_Data::LocalFrameHost_ForwardFencedFrameEventAndUserActivationToEmbedder_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_OnViewTransitionOptInChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_OnViewTransitionOptInChanged_Params_Data* object =
      static_cast<const LocalFrameHost_OnViewTransitionOptInChanged_Params_Data*>(data);


  if (!::blink::mojom::internal::ViewTransitionSameOriginOptIn_Data
        ::Validate(object->view_transition_opt_in, validation_context))
    return false;

  return true;
}

LocalFrameHost_OnViewTransitionOptInChanged_Params_Data::LocalFrameHost_OnViewTransitionOptInChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_StartDragging_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_StartDragging_Params_Data* object =
      static_cast<const LocalFrameHost_StartDragging_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->drag_data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->drag_data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->operations_allowed, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->operations_allowed, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->image, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cursor_offset_in_dip, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cursor_offset_in_dip, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->drag_obj_rect_in_dip, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->drag_obj_rect_in_dip, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event_info, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->event_info, validation_context))
    return false;

  return true;
}

LocalFrameHost_StartDragging_Params_Data::LocalFrameHost_StartDragging_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_IssueKeepAliveHandle_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_IssueKeepAliveHandle_Params_Data* object =
      static_cast<const LocalFrameHost_IssueKeepAliveHandle_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

LocalFrameHost_IssueKeepAliveHandle_Params_Data::LocalFrameHost_IssueKeepAliveHandle_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_NotifyStorageAccessed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_NotifyStorageAccessed_Params_Data* object =
      static_cast<const LocalFrameHost_NotifyStorageAccessed_Params_Data*>(data);


  if (!::blink::mojom::internal::StorageTypeAccessed_Data
        ::Validate(object->storageType, validation_context))
    return false;

  return true;
}

LocalFrameHost_NotifyStorageAccessed_Params_Data::LocalFrameHost_NotifyStorageAccessed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_RecordWindowProxyUsageMetrics_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_RecordWindowProxyUsageMetrics_Params_Data* object =
      static_cast<const LocalFrameHost_RecordWindowProxyUsageMetrics_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->target_frame_token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->target_frame_token, validation_context))
    return false;


  if (!::blink::mojom::internal::WindowProxyAccessType_Data
        ::Validate(object->access_type, validation_context))
    return false;

  return true;
}

LocalFrameHost_RecordWindowProxyUsageMetrics_Params_Data::LocalFrameHost_RecordWindowProxyUsageMetrics_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_NotifyDocumentInteractive_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_NotifyDocumentInteractive_Params_Data* object =
      static_cast<const LocalFrameHost_NotifyDocumentInteractive_Params_Data*>(data);

  return true;
}

LocalFrameHost_NotifyDocumentInteractive_Params_Data::LocalFrameHost_NotifyDocumentInteractive_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_SetStorageAccessApiStatus_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_SetStorageAccessApiStatus_Params_Data* object =
      static_cast<const LocalFrameHost_SetStorageAccessApiStatus_Params_Data*>(data);


  if (!::network::mojom::internal::StorageAccessApiStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

LocalFrameHost_SetStorageAccessApiStatus_Params_Data::LocalFrameHost_SetStorageAccessApiStatus_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_InitializeCrashReportStorage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_InitializeCrashReportStorage_Params_Data* object =
      static_cast<const LocalFrameHost_InitializeCrashReportStorage_Params_Data*>(data);

  return true;
}

LocalFrameHost_InitializeCrashReportStorage_Params_Data::LocalFrameHost_InitializeCrashReportStorage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_InitializeCrashReportStorage_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_InitializeCrashReportStorage_ResponseParams_Data* object =
      static_cast<const LocalFrameHost_InitializeCrashReportStorage_ResponseParams_Data*>(data);

  return true;
}

LocalFrameHost_InitializeCrashReportStorage_ResponseParams_Data::LocalFrameHost_InitializeCrashReportStorage_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_SetCrashReportStorageKey_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_SetCrashReportStorageKey_Params_Data* object =
      static_cast<const LocalFrameHost_SetCrashReportStorageKey_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->key, validation_context,
                                         &key_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& value_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->value, validation_context,
                                         &value_validate_params)) {
    return false;
  }

  return true;
}

LocalFrameHost_SetCrashReportStorageKey_Params_Data::LocalFrameHost_SetCrashReportStorageKey_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_SetCrashReportStorageKey_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_SetCrashReportStorageKey_ResponseParams_Data* object =
      static_cast<const LocalFrameHost_SetCrashReportStorageKey_ResponseParams_Data*>(data);

  return true;
}

LocalFrameHost_SetCrashReportStorageKey_ResponseParams_Data::LocalFrameHost_SetCrashReportStorageKey_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_RemoveCrashReportStorageKey_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_RemoveCrashReportStorageKey_Params_Data* object =
      static_cast<const LocalFrameHost_RemoveCrashReportStorageKey_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->key, validation_context,
                                         &key_validate_params)) {
    return false;
  }

  return true;
}

LocalFrameHost_RemoveCrashReportStorageKey_Params_Data::LocalFrameHost_RemoveCrashReportStorageKey_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_RemoveCrashReportStorageKey_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameHost_RemoveCrashReportStorageKey_ResponseParams_Data* object =
      static_cast<const LocalFrameHost_RemoveCrashReportStorageKey_ResponseParams_Data*>(data);

  return true;
}

LocalFrameHost_RemoveCrashReportStorageKey_ResponseParams_Data::LocalFrameHost_RemoveCrashReportStorageKey_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NonAssociatedLocalFrameHost_MaybeStartOutermostMainFrameNavigation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NonAssociatedLocalFrameHost_MaybeStartOutermostMainFrameNavigation_Params_Data* object =
      static_cast<const NonAssociatedLocalFrameHost_MaybeStartOutermostMainFrameNavigation_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->urls, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->urls, validation_context,
                                         &urls_validate_params)) {
    return false;
  }

  return true;
}

NonAssociatedLocalFrameHost_MaybeStartOutermostMainFrameNavigation_Params_Data::NonAssociatedLocalFrameHost_MaybeStartOutermostMainFrameNavigation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_GetTextSurroundingSelection_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_GetTextSurroundingSelection_Params_Data* object =
      static_cast<const LocalFrame_GetTextSurroundingSelection_Params_Data*>(data);

  return true;
}

LocalFrame_GetTextSurroundingSelection_Params_Data::LocalFrame_GetTextSurroundingSelection_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_GetTextSurroundingSelection_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_GetTextSurroundingSelection_ResponseParams_Data* object =
      static_cast<const LocalFrame_GetTextSurroundingSelection_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->content, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->content, validation_context))
    return false;

  return true;
}

LocalFrame_GetTextSurroundingSelection_ResponseParams_Data::LocalFrame_GetTextSurroundingSelection_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_SendInterventionReport_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_SendInterventionReport_Params_Data* object =
      static_cast<const LocalFrame_SendInterventionReport_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnion(object->child_frame_token, validation_context))
    return false;

  return true;
}

LocalFrame_SendInterventionReport_Params_Data::LocalFrame_SendInterventionReport_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_SetFrameOwnerProperties_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_SetFrameOwnerProperties_Params_Data* object =
      static_cast<const LocalFrame_SetFrameOwnerProperties_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->properties, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->properties, validation_context))
    return false;

  return true;
}

LocalFrame_SetFrameOwnerProperties_Params_Data::LocalFrame_SetFrameOwnerProperties_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_NotifyUserActivation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_NotifyUserActivation_Params_Data* object =
      static_cast<const LocalFrame_NotifyUserActivation_Params_Data*>(data);


  if (!::blink::mojom::internal::UserActivationNotificationType_Data
        ::Validate(object->notification_type, validation_context))
    return false;

  return true;
}

LocalFrame_NotifyUserActivation_Params_Data::LocalFrame_NotifyUserActivation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_NotifyVirtualKeyboardOverlayRect_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_NotifyVirtualKeyboardOverlayRect_Params_Data* object =
      static_cast<const LocalFrame_NotifyVirtualKeyboardOverlayRect_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->keyboard_rect, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->keyboard_rect, validation_context))
    return false;

  return true;
}

LocalFrame_NotifyVirtualKeyboardOverlayRect_Params_Data::LocalFrame_NotifyVirtualKeyboardOverlayRect_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_ShowInterestInElement_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_ShowInterestInElement_Params_Data* object =
      static_cast<const LocalFrame_ShowInterestInElement_Params_Data*>(data);

  return true;
}

LocalFrame_ShowInterestInElement_Params_Data::LocalFrame_ShowInterestInElement_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_AddMessageToConsole_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_AddMessageToConsole_Params_Data* object =
      static_cast<const LocalFrame_AddMessageToConsole_Params_Data*>(data);


  if (!::blink::mojom::internal::ConsoleMessageLevel_Data
        ::Validate(object->level, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

LocalFrame_AddMessageToConsole_Params_Data::LocalFrame_AddMessageToConsole_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_SwapInImmediately_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_SwapInImmediately_Params_Data* object =
      static_cast<const LocalFrame_SwapInImmediately_Params_Data*>(data);

  return true;
}

LocalFrame_SwapInImmediately_Params_Data::LocalFrame_SwapInImmediately_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_CheckCompleted_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_CheckCompleted_Params_Data* object =
      static_cast<const LocalFrame_CheckCompleted_Params_Data*>(data);

  return true;
}

LocalFrame_CheckCompleted_Params_Data::LocalFrame_CheckCompleted_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_StopLoading_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_StopLoading_Params_Data* object =
      static_cast<const LocalFrame_StopLoading_Params_Data*>(data);

  return true;
}

LocalFrame_StopLoading_Params_Data::LocalFrame_StopLoading_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_Collapse_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_Collapse_Params_Data* object =
      static_cast<const LocalFrame_Collapse_Params_Data*>(data);

  return true;
}

LocalFrame_Collapse_Params_Data::LocalFrame_Collapse_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_EnableViewSourceMode_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_EnableViewSourceMode_Params_Data* object =
      static_cast<const LocalFrame_EnableViewSourceMode_Params_Data*>(data);

  return true;
}

LocalFrame_EnableViewSourceMode_Params_Data::LocalFrame_EnableViewSourceMode_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_Focus_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_Focus_Params_Data* object =
      static_cast<const LocalFrame_Focus_Params_Data*>(data);

  return true;
}

LocalFrame_Focus_Params_Data::LocalFrame_Focus_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_ClearFocusedElement_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_ClearFocusedElement_Params_Data* object =
      static_cast<const LocalFrame_ClearFocusedElement_Params_Data*>(data);

  return true;
}

LocalFrame_ClearFocusedElement_Params_Data::LocalFrame_ClearFocusedElement_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_CopyImageAt_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_CopyImageAt_Params_Data* object =
      static_cast<const LocalFrame_CopyImageAt_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->window_point, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->window_point, validation_context))
    return false;

  return true;
}

LocalFrame_CopyImageAt_Params_Data::LocalFrame_CopyImageAt_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_SaveImageAt_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_SaveImageAt_Params_Data* object =
      static_cast<const LocalFrame_SaveImageAt_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->window_point, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->window_point, validation_context))
    return false;

  return true;
}

LocalFrame_SaveImageAt_Params_Data::LocalFrame_SaveImageAt_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_ReportBlinkFeatureUsage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_ReportBlinkFeatureUsage_Params_Data* object =
      static_cast<const LocalFrame_ReportBlinkFeatureUsage_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->features, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& features_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::WebFeature_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->features, validation_context,
                                         &features_validate_params)) {
    return false;
  }

  return true;
}

LocalFrame_ReportBlinkFeatureUsage_Params_Data::LocalFrame_ReportBlinkFeatureUsage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_RenderFallbackContent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_RenderFallbackContent_Params_Data* object =
      static_cast<const LocalFrame_RenderFallbackContent_Params_Data*>(data);

  return true;
}

LocalFrame_RenderFallbackContent_Params_Data::LocalFrame_RenderFallbackContent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_BeforeUnload_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_BeforeUnload_Params_Data* object =
      static_cast<const LocalFrame_BeforeUnload_Params_Data*>(data);

  return true;
}

LocalFrame_BeforeUnload_Params_Data::LocalFrame_BeforeUnload_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_BeforeUnload_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_BeforeUnload_ResponseParams_Data* object =
      static_cast<const LocalFrame_BeforeUnload_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->before_unload_start_time, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->before_unload_start_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->before_unload_end_time, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->before_unload_end_time, validation_context))
    return false;

  return true;
}

LocalFrame_BeforeUnload_ResponseParams_Data::LocalFrame_BeforeUnload_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_MediaPlayerActionAt_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_MediaPlayerActionAt_Params_Data* object =
      static_cast<const LocalFrame_MediaPlayerActionAt_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->location, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->location, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->action, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->action, validation_context))
    return false;

  return true;
}

LocalFrame_MediaPlayerActionAt_Params_Data::LocalFrame_MediaPlayerActionAt_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_RequestVideoFrameAtWithBoundsHint_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_RequestVideoFrameAtWithBoundsHint_Params_Data* object =
      static_cast<const LocalFrame_RequestVideoFrameAtWithBoundsHint_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->location, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->location, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->max_size, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->max_size, validation_context))
    return false;

  return true;
}

LocalFrame_RequestVideoFrameAtWithBoundsHint_Params_Data::LocalFrame_RequestVideoFrameAtWithBoundsHint_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_RequestVideoFrameAtWithBoundsHint_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_RequestVideoFrameAtWithBoundsHint_ResponseParams_Data* object =
      static_cast<const LocalFrame_RequestVideoFrameAtWithBoundsHint_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->bitmap, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bounds, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bounds, validation_context))
    return false;

  return true;
}

LocalFrame_RequestVideoFrameAtWithBoundsHint_ResponseParams_Data::LocalFrame_RequestVideoFrameAtWithBoundsHint_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_PluginActionAt_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_PluginActionAt_Params_Data* object =
      static_cast<const LocalFrame_PluginActionAt_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->location, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->location, validation_context))
    return false;


  if (!::blink::mojom::internal::PluginActionType_Data
        ::Validate(object->action, validation_context))
    return false;

  return true;
}

LocalFrame_PluginActionAt_Params_Data::LocalFrame_PluginActionAt_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_AdvanceFocusInFrame_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_AdvanceFocusInFrame_Params_Data* object =
      static_cast<const LocalFrame_AdvanceFocusInFrame_Params_Data*>(data);


  if (!::blink::mojom::internal::FocusType_Data
        ::Validate(object->focus_type, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->source_frame_token, validation_context))
    return false;

  return true;
}

LocalFrame_AdvanceFocusInFrame_Params_Data::LocalFrame_AdvanceFocusInFrame_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_AdvanceFocusForIME_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_AdvanceFocusForIME_Params_Data* object =
      static_cast<const LocalFrame_AdvanceFocusForIME_Params_Data*>(data);


  if (!::blink::mojom::internal::FocusType_Data
        ::Validate(object->focus_type, validation_context))
    return false;

  return true;
}

LocalFrame_AdvanceFocusForIME_Params_Data::LocalFrame_AdvanceFocusForIME_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_ReportContentSecurityPolicyViolation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_ReportContentSecurityPolicyViolation_Params_Data* object =
      static_cast<const LocalFrame_ReportContentSecurityPolicyViolation_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->violation, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->violation, validation_context))
    return false;

  return true;
}

LocalFrame_ReportContentSecurityPolicyViolation_Params_Data::LocalFrame_ReportContentSecurityPolicyViolation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_DidUpdateFramePolicy_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_DidUpdateFramePolicy_Params_Data* object =
      static_cast<const LocalFrame_DidUpdateFramePolicy_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_policy, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_policy, validation_context))
    return false;

  return true;
}

LocalFrame_DidUpdateFramePolicy_Params_Data::LocalFrame_DidUpdateFramePolicy_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_OnFrameVisibilityChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_OnFrameVisibilityChanged_Params_Data* object =
      static_cast<const LocalFrame_OnFrameVisibilityChanged_Params_Data*>(data);


  if (!::blink::mojom::internal::FrameVisibility_Data
        ::Validate(object->visibility, validation_context))
    return false;

  return true;
}

LocalFrame_OnFrameVisibilityChanged_Params_Data::LocalFrame_OnFrameVisibilityChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_PostMessageEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_PostMessageEvent_Params_Data* object =
      static_cast<const LocalFrame_PostMessageEvent_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->source_frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_origin, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->target_origin, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->target_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->message, validation_context))
    return false;

  return true;
}

LocalFrame_PostMessageEvent_Params_Data::LocalFrame_PostMessageEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_JavaScriptMethodExecuteRequest_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_JavaScriptMethodExecuteRequest_Params_Data* object =
      static_cast<const LocalFrame_JavaScriptMethodExecuteRequest_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->object_name, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->object_name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->method_name, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->method_name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->arguments, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->arguments, validation_context))
    return false;

  return true;
}

LocalFrame_JavaScriptMethodExecuteRequest_Params_Data::LocalFrame_JavaScriptMethodExecuteRequest_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_JavaScriptMethodExecuteRequest_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_JavaScriptMethodExecuteRequest_ResponseParams_Data* object =
      static_cast<const LocalFrame_JavaScriptMethodExecuteRequest_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

LocalFrame_JavaScriptMethodExecuteRequest_ResponseParams_Data::LocalFrame_JavaScriptMethodExecuteRequest_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_JavaScriptExecuteRequest_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_JavaScriptExecuteRequest_Params_Data* object =
      static_cast<const LocalFrame_JavaScriptExecuteRequest_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->javascript, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->javascript, validation_context))
    return false;

  return true;
}

LocalFrame_JavaScriptExecuteRequest_Params_Data::LocalFrame_JavaScriptExecuteRequest_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_JavaScriptExecuteRequest_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_JavaScriptExecuteRequest_ResponseParams_Data* object =
      static_cast<const LocalFrame_JavaScriptExecuteRequest_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

LocalFrame_JavaScriptExecuteRequest_ResponseParams_Data::LocalFrame_JavaScriptExecuteRequest_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_JavaScriptExecuteRequestForTests_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_JavaScriptExecuteRequestForTests_Params_Data* object =
      static_cast<const LocalFrame_JavaScriptExecuteRequestForTests_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->javascript, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->javascript, validation_context))
    return false;

  return true;
}

LocalFrame_JavaScriptExecuteRequestForTests_Params_Data::LocalFrame_JavaScriptExecuteRequestForTests_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_JavaScriptExecuteRequestForTests_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_JavaScriptExecuteRequestForTests_ResponseParams_Data* object =
      static_cast<const LocalFrame_JavaScriptExecuteRequestForTests_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::JavaScriptExecutionResultType_Data
        ::Validate(object->result_type, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

LocalFrame_JavaScriptExecuteRequestForTests_ResponseParams_Data::LocalFrame_JavaScriptExecuteRequestForTests_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_Params_Data* object =
      static_cast<const LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->javascript, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->javascript, validation_context))
    return false;

  return true;
}

LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_Params_Data::LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ResponseParams_Data* object =
      static_cast<const LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ResponseParams_Data::LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_JavaScriptAwaitPromiseInIsolatedWorld_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_JavaScriptAwaitPromiseInIsolatedWorld_Params_Data* object =
      static_cast<const LocalFrame_JavaScriptAwaitPromiseInIsolatedWorld_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->javascript, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->javascript, validation_context))
    return false;

  return true;
}

LocalFrame_JavaScriptAwaitPromiseInIsolatedWorld_Params_Data::LocalFrame_JavaScriptAwaitPromiseInIsolatedWorld_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_JavaScriptAwaitPromiseInIsolatedWorld_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_JavaScriptAwaitPromiseInIsolatedWorld_ResponseParams_Data* object =
      static_cast<const LocalFrame_JavaScriptAwaitPromiseInIsolatedWorld_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

LocalFrame_JavaScriptAwaitPromiseInIsolatedWorld_ResponseParams_Data::LocalFrame_JavaScriptAwaitPromiseInIsolatedWorld_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_GetCharacterIndexAtPoint_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_GetCharacterIndexAtPoint_Params_Data* object =
      static_cast<const LocalFrame_GetCharacterIndexAtPoint_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->location, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->location, validation_context))
    return false;

  return true;
}

LocalFrame_GetCharacterIndexAtPoint_Params_Data::LocalFrame_GetCharacterIndexAtPoint_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_GetFirstRectForRange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_GetFirstRectForRange_Params_Data* object =
      static_cast<const LocalFrame_GetFirstRectForRange_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->range, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->range, validation_context))
    return false;

  return true;
}

LocalFrame_GetFirstRectForRange_Params_Data::LocalFrame_GetFirstRectForRange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_GetStringForRange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_GetStringForRange_Params_Data* object =
      static_cast<const LocalFrame_GetStringForRange_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->range, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->range, validation_context))
    return false;

  return true;
}

LocalFrame_GetStringForRange_Params_Data::LocalFrame_GetStringForRange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_GetStringForRange_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_GetStringForRange_ResponseParams_Data* object =
      static_cast<const LocalFrame_GetStringForRange_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->string, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->baseline_point, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->baseline_point, validation_context))
    return false;

  return true;
}

LocalFrame_GetStringForRange_ResponseParams_Data::LocalFrame_GetStringForRange_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_BindReportingObserver_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_BindReportingObserver_Params_Data* object =
      static_cast<const LocalFrame_BindReportingObserver_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

LocalFrame_BindReportingObserver_Params_Data::LocalFrame_BindReportingObserver_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_UpdateOpener_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_UpdateOpener_Params_Data* object =
      static_cast<const LocalFrame_UpdateOpener_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnion(object->opener_frame_token, validation_context))
    return false;

  return true;
}

LocalFrame_UpdateOpener_Params_Data::LocalFrame_UpdateOpener_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_GetSavableResourceLinks_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_GetSavableResourceLinks_Params_Data* object =
      static_cast<const LocalFrame_GetSavableResourceLinks_Params_Data*>(data);

  return true;
}

LocalFrame_GetSavableResourceLinks_Params_Data::LocalFrame_GetSavableResourceLinks_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_GetSavableResourceLinks_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_GetSavableResourceLinks_ResponseParams_Data* object =
      static_cast<const LocalFrame_GetSavableResourceLinks_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->reply, validation_context))
    return false;

  return true;
}

LocalFrame_GetSavableResourceLinks_ResponseParams_Data::LocalFrame_GetSavableResourceLinks_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_MixedContentFound_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_MixedContentFound_Params_Data* object =
      static_cast<const LocalFrame_MixedContentFound_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->main_resource_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->main_resource_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mixed_content_url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->mixed_content_url, validation_context))
    return false;


  if (!::blink::mojom::internal::RequestContextType_Data
        ::Validate(object->request_context, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url_before_redirects, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url_before_redirects, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->source_location, validation_context))
    return false;

  return true;
}

LocalFrame_MixedContentFound_Params_Data::LocalFrame_MixedContentFound_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_BindDevToolsAgent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_BindDevToolsAgent_Params_Data* object =
      static_cast<const LocalFrame_BindDevToolsAgent_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->agent_host, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->agent_host,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->agent, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->agent,
                                                 validation_context)) {
    return false;
  }

  return true;
}

LocalFrame_BindDevToolsAgent_Params_Data::LocalFrame_BindDevToolsAgent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_ExtractAnnotatedText_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_ExtractAnnotatedText_Params_Data* object =
      static_cast<const LocalFrame_ExtractAnnotatedText_Params_Data*>(data);

  return true;
}

LocalFrame_ExtractAnnotatedText_Params_Data::LocalFrame_ExtractAnnotatedText_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_ExtractAnnotatedText_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_ExtractAnnotatedText_ResponseParams_Data* object =
      static_cast<const LocalFrame_ExtractAnnotatedText_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->annotated_text, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->annotated_text, validation_context))
    return false;

  return true;
}

LocalFrame_ExtractAnnotatedText_ResponseParams_Data::LocalFrame_ExtractAnnotatedText_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_ExtractSerializedDom_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_ExtractSerializedDom_Params_Data* object =
      static_cast<const LocalFrame_ExtractSerializedDom_Params_Data*>(data);

  return true;
}

LocalFrame_ExtractSerializedDom_Params_Data::LocalFrame_ExtractSerializedDom_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_ExtractSerializedDom_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_ExtractSerializedDom_ResponseParams_Data* object =
      static_cast<const LocalFrame_ExtractSerializedDom_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->serialized_dom, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->serialized_dom, validation_context))
    return false;

  return true;
}

LocalFrame_ExtractSerializedDom_ResponseParams_Data::LocalFrame_ExtractSerializedDom_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_ExtractSerializedDomElementInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_ExtractSerializedDomElementInfo_Params_Data* object =
      static_cast<const LocalFrame_ExtractSerializedDomElementInfo_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  return true;
}

LocalFrame_ExtractSerializedDomElementInfo_Params_Data::LocalFrame_ExtractSerializedDomElementInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_ExtractSerializedDomElementInfo_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_ExtractSerializedDomElementInfo_ResponseParams_Data* object =
      static_cast<const LocalFrame_ExtractSerializedDomElementInfo_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->info, validation_context))
    return false;

  return true;
}

LocalFrame_ExtractSerializedDomElementInfo_ResponseParams_Data::LocalFrame_ExtractSerializedDomElementInfo_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_HandleRendererDebugURL_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_HandleRendererDebugURL_Params_Data* object =
      static_cast<const LocalFrame_HandleRendererDebugURL_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

LocalFrame_HandleRendererDebugURL_Params_Data::LocalFrame_HandleRendererDebugURL_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_GetCanonicalUrlForSharing_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_GetCanonicalUrlForSharing_Params_Data* object =
      static_cast<const LocalFrame_GetCanonicalUrlForSharing_Params_Data*>(data);

  return true;
}

LocalFrame_GetCanonicalUrlForSharing_Params_Data::LocalFrame_GetCanonicalUrlForSharing_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_GetCanonicalUrlForSharing_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_GetCanonicalUrlForSharing_ResponseParams_Data* object =
      static_cast<const LocalFrame_GetCanonicalUrlForSharing_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->canonical_url, validation_context))
    return false;

  return true;
}

LocalFrame_GetCanonicalUrlForSharing_ResponseParams_Data::LocalFrame_GetCanonicalUrlForSharing_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_GetOpenGraphMetadata_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_GetOpenGraphMetadata_Params_Data* object =
      static_cast<const LocalFrame_GetOpenGraphMetadata_Params_Data*>(data);

  return true;
}

LocalFrame_GetOpenGraphMetadata_Params_Data::LocalFrame_GetOpenGraphMetadata_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_GetOpenGraphMetadata_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_GetOpenGraphMetadata_ResponseParams_Data* object =
      static_cast<const LocalFrame_GetOpenGraphMetadata_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->metadata, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->metadata, validation_context))
    return false;

  return true;
}

LocalFrame_GetOpenGraphMetadata_ResponseParams_Data::LocalFrame_GetOpenGraphMetadata_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_SetNavigationApiHistoryEntriesForRestore_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_SetNavigationApiHistoryEntriesForRestore_Params_Data* object =
      static_cast<const LocalFrame_SetNavigationApiHistoryEntriesForRestore_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->entry_arrays, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->entry_arrays, validation_context))
    return false;


  if (!::blink::mojom::internal::NavigationApiEntryRestoreReason_Data
        ::Validate(object->restore_reason, validation_context))
    return false;

  return true;
}

LocalFrame_SetNavigationApiHistoryEntriesForRestore_Params_Data::LocalFrame_SetNavigationApiHistoryEntriesForRestore_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_UpdatePrerenderURL_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_UpdatePrerenderURL_Params_Data* object =
      static_cast<const LocalFrame_UpdatePrerenderURL_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->matched_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->matched_url, validation_context))
    return false;

  return true;
}

LocalFrame_UpdatePrerenderURL_Params_Data::LocalFrame_UpdatePrerenderURL_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_UpdatePrerenderURL_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_UpdatePrerenderURL_ResponseParams_Data* object =
      static_cast<const LocalFrame_UpdatePrerenderURL_ResponseParams_Data*>(data);

  return true;
}

LocalFrame_UpdatePrerenderURL_ResponseParams_Data::LocalFrame_UpdatePrerenderURL_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_NotifyNavigationApiOfDisposedEntries_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_NotifyNavigationApiOfDisposedEntries_Params_Data* object =
      static_cast<const LocalFrame_NotifyNavigationApiOfDisposedEntries_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->keys, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& keys_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->keys, validation_context,
                                         &keys_validate_params)) {
    return false;
  }

  return true;
}

LocalFrame_NotifyNavigationApiOfDisposedEntries_Params_Data::LocalFrame_NotifyNavigationApiOfDisposedEntries_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_TraverseCancelled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_TraverseCancelled_Params_Data* object =
      static_cast<const LocalFrame_TraverseCancelled_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->navigation_api_key, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& navigation_api_key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->navigation_api_key, validation_context,
                                         &navigation_api_key_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::TraverseCancelledReason_Data
        ::Validate(object->reason, validation_context))
    return false;

  return true;
}

LocalFrame_TraverseCancelled_Params_Data::LocalFrame_TraverseCancelled_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_DispatchNavigateEventForCrossDocumentTraversal_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_DispatchNavigateEventForCrossDocumentTraversal_Params_Data* object =
      static_cast<const LocalFrame_DispatchNavigateEventForCrossDocumentTraversal_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->page_state, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->page_state, validation_context))
    return false;

  return true;
}

LocalFrame_DispatchNavigateEventForCrossDocumentTraversal_Params_Data::LocalFrame_DispatchNavigateEventForCrossDocumentTraversal_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_SnapshotDocumentForViewTransition_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_SnapshotDocumentForViewTransition_Params_Data* object =
      static_cast<const LocalFrame_SnapshotDocumentForViewTransition_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->transition_token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->transition_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->page_swap_event_params, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->page_swap_event_params, validation_context))
    return false;

  return true;
}

LocalFrame_SnapshotDocumentForViewTransition_Params_Data::LocalFrame_SnapshotDocumentForViewTransition_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_SnapshotDocumentForViewTransition_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_SnapshotDocumentForViewTransition_ResponseParams_Data* object =
      static_cast<const LocalFrame_SnapshotDocumentForViewTransition_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->view_transition_state, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->view_transition_state, validation_context))
    return false;

  return true;
}

LocalFrame_SnapshotDocumentForViewTransition_ResponseParams_Data::LocalFrame_SnapshotDocumentForViewTransition_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_NotifyViewTransitionAbortedToOldDocument_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_NotifyViewTransitionAbortedToOldDocument_Params_Data* object =
      static_cast<const LocalFrame_NotifyViewTransitionAbortedToOldDocument_Params_Data*>(data);

  return true;
}

LocalFrame_NotifyViewTransitionAbortedToOldDocument_Params_Data::LocalFrame_NotifyViewTransitionAbortedToOldDocument_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_DispatchPageSwap_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_DispatchPageSwap_Params_Data* object =
      static_cast<const LocalFrame_DispatchPageSwap_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->page_swap_event_params, validation_context))
    return false;

  return true;
}

LocalFrame_DispatchPageSwap_Params_Data::LocalFrame_DispatchPageSwap_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_AddResourceTimingEntryForFailedSubframeNavigation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 120, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_AddResourceTimingEntryForFailedSubframeNavigation_Params_Data* object =
      static_cast<const LocalFrame_AddResourceTimingEntryForFailedSubframeNavigation_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->subframe_token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->subframe_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->initial_url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->initial_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->start_time, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->start_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->redirect_time, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->redirect_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request_start, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request_start, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->response_start, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->response_start, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mime_type, 8, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& mime_type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->mime_type, validation_context,
                                         &mime_type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->load_timing_info, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->load_timing_info, validation_context))
    return false;


  if (!::network::mojom::internal::ConnectionInfo_Data
        ::Validate(object->connection_info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->alpn_negotiated_protocol, 11, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& alpn_negotiated_protocol_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->alpn_negotiated_protocol, validation_context,
                                         &alpn_negotiated_protocol_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->normalized_server_timing, 14, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& normalized_server_timing_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->normalized_server_timing, validation_context,
                                         &normalized_server_timing_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->completion_status, 15, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->completion_status, validation_context))
    return false;

  return true;
}

LocalFrame_AddResourceTimingEntryForFailedSubframeNavigation_Params_Data::LocalFrame_AddResourceTimingEntryForFailedSubframeNavigation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_GetScrollPosition_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_GetScrollPosition_Params_Data* object =
      static_cast<const LocalFrame_GetScrollPosition_Params_Data*>(data);

  return true;
}

LocalFrame_GetScrollPosition_Params_Data::LocalFrame_GetScrollPosition_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_GetScrollPosition_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrame_GetScrollPosition_ResponseParams_Data* object =
      static_cast<const LocalFrame_GetScrollPosition_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scroll_position, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->scroll_position, validation_context))
    return false;

  return true;
}

LocalFrame_GetScrollPosition_ResponseParams_Data::LocalFrame_GetScrollPosition_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrame_AnimateDoubleTapZoom_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalMainFrame_AnimateDoubleTapZoom_Params_Data* object =
      static_cast<const LocalMainFrame_AnimateDoubleTapZoom_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->point, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->point, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rect, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->rect, validation_context))
    return false;

  return true;
}

LocalMainFrame_AnimateDoubleTapZoom_Params_Data::LocalMainFrame_AnimateDoubleTapZoom_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrame_SetScaleFactor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalMainFrame_SetScaleFactor_Params_Data* object =
      static_cast<const LocalMainFrame_SetScaleFactor_Params_Data*>(data);

  return true;
}

LocalMainFrame_SetScaleFactor_Params_Data::LocalMainFrame_SetScaleFactor_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrame_ClosePage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalMainFrame_ClosePage_Params_Data* object =
      static_cast<const LocalMainFrame_ClosePage_Params_Data*>(data);

  return true;
}

LocalMainFrame_ClosePage_Params_Data::LocalMainFrame_ClosePage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrame_ClosePage_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalMainFrame_ClosePage_ResponseParams_Data* object =
      static_cast<const LocalMainFrame_ClosePage_ResponseParams_Data*>(data);

  return true;
}

LocalMainFrame_ClosePage_ResponseParams_Data::LocalMainFrame_ClosePage_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrame_GetFullPageSize_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalMainFrame_GetFullPageSize_Params_Data* object =
      static_cast<const LocalMainFrame_GetFullPageSize_Params_Data*>(data);

  return true;
}

LocalMainFrame_GetFullPageSize_Params_Data::LocalMainFrame_GetFullPageSize_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrame_GetFullPageSize_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalMainFrame_GetFullPageSize_ResponseParams_Data* object =
      static_cast<const LocalMainFrame_GetFullPageSize_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->full_page_size, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->full_page_size, validation_context))
    return false;

  return true;
}

LocalMainFrame_GetFullPageSize_ResponseParams_Data::LocalMainFrame_GetFullPageSize_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrame_SetInitialFocus_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalMainFrame_SetInitialFocus_Params_Data* object =
      static_cast<const LocalMainFrame_SetInitialFocus_Params_Data*>(data);

  return true;
}

LocalMainFrame_SetInitialFocus_Params_Data::LocalMainFrame_SetInitialFocus_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrame_EnablePreferredSizeChangedMode_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalMainFrame_EnablePreferredSizeChangedMode_Params_Data* object =
      static_cast<const LocalMainFrame_EnablePreferredSizeChangedMode_Params_Data*>(data);

  return true;
}

LocalMainFrame_EnablePreferredSizeChangedMode_Params_Data::LocalMainFrame_EnablePreferredSizeChangedMode_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrame_ZoomToFindInPageRect_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalMainFrame_ZoomToFindInPageRect_Params_Data* object =
      static_cast<const LocalMainFrame_ZoomToFindInPageRect_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rect_in_root_frame, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->rect_in_root_frame, validation_context))
    return false;

  return true;
}

LocalMainFrame_ZoomToFindInPageRect_Params_Data::LocalMainFrame_ZoomToFindInPageRect_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrame_InstallCoopAccessMonitor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalMainFrame_InstallCoopAccessMonitor_Params_Data* object =
      static_cast<const LocalMainFrame_InstallCoopAccessMonitor_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->accessed_window, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->accessed_window, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->coop_reporter_info, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->coop_reporter_info, validation_context))
    return false;

  return true;
}

LocalMainFrame_InstallCoopAccessMonitor_Params_Data::LocalMainFrame_InstallCoopAccessMonitor_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrame_UpdateBrowserControlsState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalMainFrame_UpdateBrowserControlsState_Params_Data* object =
      static_cast<const LocalMainFrame_UpdateBrowserControlsState_Params_Data*>(data);


  if (!::cc::mojom::internal::BrowserControlsState_Data
        ::Validate(object->constraints, validation_context))
    return false;


  if (!::cc::mojom::internal::BrowserControlsState_Data
        ::Validate(object->current, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->offset_tag_modifications, validation_context))
    return false;

  return true;
}

LocalMainFrame_UpdateBrowserControlsState_Params_Data::LocalMainFrame_UpdateBrowserControlsState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrame_SetV8CompileHints_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalMainFrame_SetV8CompileHints_Params_Data* object =
      static_cast<const LocalMainFrame_SetV8CompileHints_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data, validation_context))
    return false;

  return true;
}

LocalMainFrame_SetV8CompileHints_Params_Data::LocalMainFrame_SetV8CompileHints_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrame_Discard_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalMainFrame_Discard_Params_Data* object =
      static_cast<const LocalMainFrame_Discard_Params_Data*>(data);

  return true;
}

LocalMainFrame_Discard_Params_Data::LocalMainFrame_Discard_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrame_Discard_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalMainFrame_Discard_ResponseParams_Data* object =
      static_cast<const LocalMainFrame_Discard_ResponseParams_Data*>(data);

  return true;
}

LocalMainFrame_Discard_ResponseParams_Data::LocalMainFrame_Discard_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrame_FinalizeNavigationConfidence_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalMainFrame_FinalizeNavigationConfidence_Params_Data* object =
      static_cast<const LocalMainFrame_FinalizeNavigationConfidence_Params_Data*>(data);


  if (!::blink::mojom::internal::ConfidenceLevel_Data
        ::Validate(object->confidence, validation_context))
    return false;

  return true;
}

LocalMainFrame_FinalizeNavigationConfidence_Params_Data::LocalMainFrame_FinalizeNavigationConfidence_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrameHost_ScaleFactorChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalMainFrameHost_ScaleFactorChanged_Params_Data* object =
      static_cast<const LocalMainFrameHost_ScaleFactorChanged_Params_Data*>(data);

  return true;
}

LocalMainFrameHost_ScaleFactorChanged_Params_Data::LocalMainFrameHost_ScaleFactorChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrameHost_ContentsPreferredSizeChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalMainFrameHost_ContentsPreferredSizeChanged_Params_Data* object =
      static_cast<const LocalMainFrameHost_ContentsPreferredSizeChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pref_size, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->pref_size, validation_context))
    return false;

  return true;
}

LocalMainFrameHost_ContentsPreferredSizeChanged_Params_Data::LocalMainFrameHost_ContentsPreferredSizeChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrameHost_TextAutosizerPageInfoChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalMainFrameHost_TextAutosizerPageInfoChanged_Params_Data* object =
      static_cast<const LocalMainFrameHost_TextAutosizerPageInfoChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->page_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->page_info, validation_context))
    return false;

  return true;
}

LocalMainFrameHost_TextAutosizerPageInfoChanged_Params_Data::LocalMainFrameHost_TextAutosizerPageInfoChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrameHost_FocusPage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalMainFrameHost_FocusPage_Params_Data* object =
      static_cast<const LocalMainFrameHost_FocusPage_Params_Data*>(data);

  return true;
}

LocalMainFrameHost_FocusPage_Params_Data::LocalMainFrameHost_FocusPage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrameHost_TakeFocus_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalMainFrameHost_TakeFocus_Params_Data* object =
      static_cast<const LocalMainFrameHost_TakeFocus_Params_Data*>(data);

  return true;
}

LocalMainFrameHost_TakeFocus_Params_Data::LocalMainFrameHost_TakeFocus_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrameHost_UpdateTargetURL_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalMainFrameHost_UpdateTargetURL_Params_Data* object =
      static_cast<const LocalMainFrameHost_UpdateTargetURL_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

LocalMainFrameHost_UpdateTargetURL_Params_Data::LocalMainFrameHost_UpdateTargetURL_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrameHost_UpdateTargetURL_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalMainFrameHost_UpdateTargetURL_ResponseParams_Data* object =
      static_cast<const LocalMainFrameHost_UpdateTargetURL_ResponseParams_Data*>(data);

  return true;
}

LocalMainFrameHost_UpdateTargetURL_ResponseParams_Data::LocalMainFrameHost_UpdateTargetURL_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrameHost_RequestClose_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalMainFrameHost_RequestClose_Params_Data* object =
      static_cast<const LocalMainFrameHost_RequestClose_Params_Data*>(data);

  return true;
}

LocalMainFrameHost_RequestClose_Params_Data::LocalMainFrameHost_RequestClose_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrameHost_ShowCreatedWindow_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalMainFrameHost_ShowCreatedWindow_Params_Data* object =
      static_cast<const LocalMainFrameHost_ShowCreatedWindow_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->opener_frame_token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->opener_frame_token, validation_context))
    return false;


  if (!::ui::mojom::internal::WindowOpenDisposition_Data
        ::Validate(object->disposition, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->window_features, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->window_features, validation_context))
    return false;

  return true;
}

LocalMainFrameHost_ShowCreatedWindow_Params_Data::LocalMainFrameHost_ShowCreatedWindow_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrameHost_ShowCreatedWindow_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalMainFrameHost_ShowCreatedWindow_ResponseParams_Data* object =
      static_cast<const LocalMainFrameHost_ShowCreatedWindow_ResponseParams_Data*>(data);

  return true;
}

LocalMainFrameHost_ShowCreatedWindow_ResponseParams_Data::LocalMainFrameHost_ShowCreatedWindow_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrameHost_SetWindowRect_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalMainFrameHost_SetWindowRect_Params_Data* object =
      static_cast<const LocalMainFrameHost_SetWindowRect_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bounds, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bounds, validation_context))
    return false;

  return true;
}

LocalMainFrameHost_SetWindowRect_Params_Data::LocalMainFrameHost_SetWindowRect_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrameHost_SetWindowRect_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalMainFrameHost_SetWindowRect_ResponseParams_Data* object =
      static_cast<const LocalMainFrameHost_SetWindowRect_ResponseParams_Data*>(data);

  return true;
}

LocalMainFrameHost_SetWindowRect_ResponseParams_Data::LocalMainFrameHost_SetWindowRect_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrameHost_DidFirstVisuallyNonEmptyPaint_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalMainFrameHost_DidFirstVisuallyNonEmptyPaint_Params_Data* object =
      static_cast<const LocalMainFrameHost_DidFirstVisuallyNonEmptyPaint_Params_Data*>(data);

  return true;
}

LocalMainFrameHost_DidFirstVisuallyNonEmptyPaint_Params_Data::LocalMainFrameHost_DidFirstVisuallyNonEmptyPaint_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrameHost_DidAccessInitialMainDocument_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalMainFrameHost_DidAccessInitialMainDocument_Params_Data* object =
      static_cast<const LocalMainFrameHost_DidAccessInitialMainDocument_Params_Data*>(data);

  return true;
}

LocalMainFrameHost_DidAccessInitialMainDocument_Params_Data::LocalMainFrameHost_DidAccessInitialMainDocument_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrameHost_Maximize_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalMainFrameHost_Maximize_Params_Data* object =
      static_cast<const LocalMainFrameHost_Maximize_Params_Data*>(data);

  return true;
}

LocalMainFrameHost_Maximize_Params_Data::LocalMainFrameHost_Maximize_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrameHost_Minimize_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalMainFrameHost_Minimize_Params_Data* object =
      static_cast<const LocalMainFrameHost_Minimize_Params_Data*>(data);

  return true;
}

LocalMainFrameHost_Minimize_Params_Data::LocalMainFrameHost_Minimize_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrameHost_Restore_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalMainFrameHost_Restore_Params_Data* object =
      static_cast<const LocalMainFrameHost_Restore_Params_Data*>(data);

  return true;
}

LocalMainFrameHost_Restore_Params_Data::LocalMainFrameHost_Restore_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrameHost_SetResizable_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalMainFrameHost_SetResizable_Params_Data* object =
      static_cast<const LocalMainFrameHost_SetResizable_Params_Data*>(data);

  return true;
}

LocalMainFrameHost_SetResizable_Params_Data::LocalMainFrameHost_SetResizable_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrameHost_DraggableRegionsChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalMainFrameHost_DraggableRegionsChanged_Params_Data* object =
      static_cast<const LocalMainFrameHost_DraggableRegionsChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->regions, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& regions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->regions, validation_context,
                                         &regions_validate_params)) {
    return false;
  }

  return true;
}

LocalMainFrameHost_DraggableRegionsChanged_Params_Data::LocalMainFrameHost_DraggableRegionsChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrameHost_OnFirstContentfulPaint_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalMainFrameHost_OnFirstContentfulPaint_Params_Data* object =
      static_cast<const LocalMainFrameHost_OnFirstContentfulPaint_Params_Data*>(data);

  return true;
}

LocalMainFrameHost_OnFirstContentfulPaint_Params_Data::LocalMainFrameHost_OnFirstContentfulPaint_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::PluginActionType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::PluginActionType value) {
  return std::move(context).WriteString(::blink::mojom::PluginActionTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::JavaScriptExecutionResultType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::JavaScriptExecutionResultType value) {
  return std::move(context).WriteString(::blink::mojom::JavaScriptExecutionResultTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::TraverseCancelledReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::TraverseCancelledReason value) {
  return std::move(context).WriteString(::blink::mojom::TraverseCancelledReasonToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ViewTransitionSameOriginOptIn>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::ViewTransitionSameOriginOptIn value) {
  return std::move(context).WriteString(::blink::mojom::ViewTransitionSameOriginOptInToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::FrameOwnerElementType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::FrameOwnerElementType value) {
  return std::move(context).WriteString(::blink::mojom::FrameOwnerElementTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::NavigationApiEntryRestoreReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::NavigationApiEntryRestoreReason value) {
  return std::move(context).WriteString(::blink::mojom::NavigationApiEntryRestoreReasonToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::StorageTypeAccessed>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::StorageTypeAccessed value) {
  return std::move(context).WriteString(::blink::mojom::StorageTypeAccessedToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::WindowProxyAccessType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::WindowProxyAccessType value) {
  return std::move(context).WriteString(::blink::mojom::WindowProxyAccessTypeToString(value));
}

} // namespace perfetto