// third_party/blink/public/mojom/frame/frame.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');




/**
 * @const { !number }
 * @export
 */
blink.mojom.MAX_TITLE_CHARS = 4096;

/**
 * @const { !bigint }
 * @export
 */
blink.mojom.MAX_CRASH_REPORT_STORAGE_SIZE = BigInt('5242880');


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.PluginActionTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.PluginActionType = {
  
  kRotate90Clockwise: 0,
  kRotate90Counterclockwise: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.JavaScriptExecutionResultTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.JavaScriptExecutionResultType = {
  
  kSuccess: 0,
  kException: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.TraverseCancelledReasonSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.TraverseCancelledReason = {
  
  kNotFound: 0,
  kSandboxViolation: 1,
  kAbortedBeforeCommit: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.ViewTransitionSameOriginOptInSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.ViewTransitionSameOriginOptIn = {
  
  kDisabled: 0,
  kEnabled: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.FrameOwnerElementTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.FrameOwnerElementType = {
  
  kNone: 0,
  kIframe: 1,
  kObject: 2,
  kEmbed: 3,
  kFrame: 4,
  kFencedframe: 5,
  MIN_VALUE: 0,
  MAX_VALUE: 5,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.NavigationApiEntryRestoreReasonSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.NavigationApiEntryRestoreReason = {
  
  kBFCache: 0,
  kPrerenderActivationPush: 1,
  kPrerenderActivationReplace: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.StorageTypeAccessedSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.StorageTypeAccessed = {
  
  kCacheStorage: 0,
  kIndexedDB: 1,
  kFileSystem: 2,
  kWebLocks: 3,
  kLocalStorage: 4,
  kSessionStorage: 5,
  MIN_VALUE: 0,
  MAX_VALUE: 5,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.WindowProxyAccessTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.WindowProxyAccessType = {
  
  kLocation: 0,
  kClosed: 1,
  kLength: 2,
  kSelf: 3,
  kWindow: 4,
  kFrames: 5,
  kOpener: 6,
  kParent: 7,
  kTop: 8,
  kPostMessage: 9,
  kAnonymousIndexedGetter: 10,
  kClose: 11,
  kFocus: 12,
  kBlur: 13,
  kAnonymousNamedGetter: 14,
  MIN_VALUE: 0,
  MAX_VALUE: 14,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.LocalFrameHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.LocalFrameHost.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.LocalFrameHostInterface }
 */
blink.mojom.LocalFrameHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.LocalFrameHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.LocalFrameHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.LocalFrameHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.FullscreenOptions } options
   * @return {!Promise<{
        granted: !boolean,
   *  }>}
   */

  enterFullscreen(
      options) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.LocalFrameHost_EnterFullscreen_ParamsSpec.$,
        blink.mojom.LocalFrameHost_EnterFullscreen_ResponseParamsSpec.$,
        [
          options
        ],
        false);
  }

  
  /**
   */

  exitFullscreen() {
    this.proxy.sendMessage(
        1,
        blink.mojom.LocalFrameHost_ExitFullscreen_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } isFullscreen
   * @param { ?blink.mojom.FullscreenOptions } options
   */

  fullscreenStateChanged(
      isFullscreen,
      options) {
    this.proxy.sendMessage(
        2,
        blink.mojom.LocalFrameHost_FullscreenStateChanged_ParamsSpec.$,
        null,
        [
          isFullscreen,
          options
        ],
        false);
  }

  
  /**
   * @param { !string } scheme
   * @param { !url.mojom.Url } url
   * @param { !boolean } userGesture
   */

  registerProtocolHandler(
      scheme,
      url,
      userGesture) {
    this.proxy.sendMessage(
        3,
        blink.mojom.LocalFrameHost_RegisterProtocolHandler_ParamsSpec.$,
        null,
        [
          scheme,
          url,
          userGesture
        ],
        false);
  }

  
  /**
   * @param { !string } scheme
   * @param { !url.mojom.Url } url
   * @param { !boolean } userGesture
   */

  unregisterProtocolHandler(
      scheme,
      url,
      userGesture) {
    this.proxy.sendMessage(
        4,
        blink.mojom.LocalFrameHost_UnregisterProtocolHandler_ParamsSpec.$,
        null,
        [
          scheme,
          url,
          userGesture
        ],
        false);
  }

  
  /**
   */

  didDisplayInsecureContent() {
    this.proxy.sendMessage(
        5,
        blink.mojom.LocalFrameHost_DidDisplayInsecureContent_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  didContainInsecureFormAction() {
    this.proxy.sendMessage(
        6,
        blink.mojom.LocalFrameHost_DidContainInsecureFormAction_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } usesTemporaryZoomLevel
   */

  mainDocumentElementAvailable(
      usesTemporaryZoomLevel) {
    this.proxy.sendMessage(
        7,
        blink.mojom.LocalFrameHost_MainDocumentElementAvailable_ParamsSpec.$,
        null,
        [
          usesTemporaryZoomLevel
        ],
        false);
  }

  
  /**
   * @param { !boolean } needsTracking
   */

  setNeedsOcclusionTracking(
      needsTracking) {
    this.proxy.sendMessage(
        8,
        blink.mojom.LocalFrameHost_SetNeedsOcclusionTracking_ParamsSpec.$,
        null,
        [
          needsTracking
        ],
        false);
  }

  
  /**
   * @param { !ui.mojom.VirtualKeyboardMode } type
   */

  setVirtualKeyboardMode(
      type) {
    this.proxy.sendMessage(
        9,
        blink.mojom.LocalFrameHost_SetVirtualKeyboardMode_ParamsSpec.$,
        null,
        [
          type
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FrameVisibility } visibility
   */

  visibilityChanged(
      visibility) {
    this.proxy.sendMessage(
        10,
        blink.mojom.LocalFrameHost_VisibilityChanged_ParamsSpec.$,
        null,
        [
          visibility
        ],
        false);
  }

  
  /**
   * @param { ?skia.mojom.SkColor } themeColor
   */

  didChangeThemeColor(
      themeColor) {
    this.proxy.sendMessage(
        11,
        blink.mojom.LocalFrameHost_DidChangeThemeColor_ParamsSpec.$,
        null,
        [
          themeColor
        ],
        false);
  }

  
  /**
   * @param { !skia.mojom.SkColor4f } backgroundColor
   * @param { !boolean } colorAdjust
   */

  didChangeBackgroundColor(
      backgroundColor,
      colorAdjust) {
    this.proxy.sendMessage(
        12,
        blink.mojom.LocalFrameHost_DidChangeBackgroundColor_ParamsSpec.$,
        null,
        [
          backgroundColor,
          colorAdjust
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @param { !number } errorCode
   */

  didFailLoadWithError(
      url,
      errorCode) {
    this.proxy.sendMessage(
        13,
        blink.mojom.LocalFrameHost_DidFailLoadWithError_ParamsSpec.$,
        null,
        [
          url,
          errorCode
        ],
        false);
  }

  
  /**
   */

  didFocusFrame() {
    this.proxy.sendMessage(
        14,
        blink.mojom.LocalFrameHost_DidFocusFrame_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  didCallFocus() {
    this.proxy.sendMessage(
        15,
        blink.mojom.LocalFrameHost_DidCallFocus_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.InsecureRequestPolicy } policyBitmap
   */

  enforceInsecureRequestPolicy(
      policyBitmap) {
    this.proxy.sendMessage(
        16,
        blink.mojom.LocalFrameHost_EnforceInsecureRequestPolicy_ParamsSpec.$,
        null,
        [
          policyBitmap
        ],
        false);
  }

  
  /**
   * @param { !Array<!number> } set
   */

  enforceInsecureNavigationsSet(
      set) {
    this.proxy.sendMessage(
        17,
        blink.mojom.LocalFrameHost_EnforceInsecureNavigationsSet_ParamsSpec.$,
        null,
        [
          set
        ],
        false);
  }

  
  /**
   * @param { !boolean } present
   * @param { !blink.mojom.SuddenTerminationDisablerType } disablerType
   */

  suddenTerminationDisablerChanged(
      present,
      disablerType) {
    this.proxy.sendMessage(
        18,
        blink.mojom.LocalFrameHost_SuddenTerminationDisablerChanged_ParamsSpec.$,
        null,
        [
          present,
          disablerType
        ],
        false);
  }

  
  /**
   * @param { !boolean } hasGesture
   */

  hadStickyUserActivationBeforeNavigationChanged(
      hasGesture) {
    this.proxy.sendMessage(
        19,
        blink.mojom.LocalFrameHost_HadStickyUserActivationBeforeNavigationChanged_ParamsSpec.$,
        null,
        [
          hasGesture
        ],
        false);
  }

  
  /**
   * @param { !gfx.mojom.RectF } rectToScroll
   * @param { !blink.mojom.ScrollIntoViewParams } params
   */

  scrollRectToVisibleInParentFrame(
      rectToScroll,
      params) {
    this.proxy.sendMessage(
        20,
        blink.mojom.LocalFrameHost_ScrollRectToVisibleInParentFrame_ParamsSpec.$,
        null,
        [
          rectToScroll,
          params
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.ScrollDirection } direction
   * @param { !ui.mojom.ScrollGranularity } granularity
   */

  bubbleLogicalScrollInParentFrame(
      direction,
      granularity) {
    this.proxy.sendMessage(
        21,
        blink.mojom.LocalFrameHost_BubbleLogicalScrollInParentFrame_ParamsSpec.$,
        null,
        [
          direction,
          granularity
        ],
        false);
  }

  
  /**
   */

  startLoadingForAsyncNavigationApiCommit() {
    this.proxy.sendMessage(
        22,
        blink.mojom.LocalFrameHost_StartLoadingForAsyncNavigationApiCommit_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } blockedUrl
   * @param { !blink.mojom.NavigationBlockedReason } reason
   */

  didBlockNavigation(
      blockedUrl,
      reason) {
    this.proxy.sendMessage(
        23,
        blink.mojom.LocalFrameHost_DidBlockNavigation_ParamsSpec.$,
        null,
        [
          blockedUrl,
          reason
        ],
        false);
  }

  
  /**
   * @param { !number } loadProgress
   */

  didChangeLoadProgress(
      loadProgress) {
    this.proxy.sendMessage(
        24,
        blink.mojom.LocalFrameHost_DidChangeLoadProgress_ParamsSpec.$,
        null,
        [
          loadProgress
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } validatedUrl
   */

  didFinishLoad(
      validatedUrl) {
    this.proxy.sendMessage(
        25,
        blink.mojom.LocalFrameHost_DidFinishLoad_ParamsSpec.$,
        null,
        [
          validatedUrl
        ],
        false);
  }

  
  /**
   */

  dispatchLoad() {
    this.proxy.sendMessage(
        26,
        blink.mojom.LocalFrameHost_DispatchLoad_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } offset
   * @param { !boolean } hasUserGesture
   * @param { !mojoBase.mojom.TimeTicks } actualNavigationStart
   * @param { ?blink.mojom.TaskAttributionId } softNavigationHeuristicsTaskId
   */

  goToEntryAtOffset(
      offset,
      hasUserGesture,
      actualNavigationStart,
      softNavigationHeuristicsTaskId) {
    this.proxy.sendMessage(
        27,
        blink.mojom.LocalFrameHost_GoToEntryAtOffset_ParamsSpec.$,
        null,
        [
          offset,
          hasUserGesture,
          actualNavigationStart,
          softNavigationHeuristicsTaskId
        ],
        false);
  }

  
  /**
   * @param { !string } key
   * @param { !boolean } hasUserGesture
   * @param { !mojoBase.mojom.TimeTicks } actualNavigationStart
   * @param { ?blink.mojom.TaskAttributionId } softNavigationHeuristicsTaskId
   */

  navigateToNavigationApiKey(
      key,
      hasUserGesture,
      actualNavigationStart,
      softNavigationHeuristicsTaskId) {
    this.proxy.sendMessage(
        28,
        blink.mojom.LocalFrameHost_NavigateToNavigationApiKey_ParamsSpec.$,
        null,
        [
          key,
          hasUserGesture,
          actualNavigationStart,
          softNavigationHeuristicsTaskId
        ],
        false);
  }

  
  /**
   * @param { !boolean } present
   */

  navigateEventHandlerPresenceChanged(
      present) {
    this.proxy.sendMessage(
        29,
        blink.mojom.LocalFrameHost_NavigateEventHandlerPresenceChanged_ParamsSpec.$,
        null,
        [
          present
        ],
        false);
  }

  
  /**
   * @param { ?mojoBase.mojom.String16 } title
   * @param { !mojoBase.mojom.TextDirection } titleDirection
   */

  updateTitle(
      title,
      titleDirection) {
    this.proxy.sendMessage(
        30,
        blink.mojom.LocalFrameHost_UpdateTitle_ParamsSpec.$,
        null,
        [
          title,
          titleDirection
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.String16 } applicationTitle
   */

  updateApplicationTitle(
      applicationTitle) {
    this.proxy.sendMessage(
        31,
        blink.mojom.LocalFrameHost_UpdateApplicationTitle_ParamsSpec.$,
        null,
        [
          applicationTitle
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.UserActivationUpdateType } updateType
   * @param { !blink.mojom.UserActivationNotificationType } notificationType
   */

  updateUserActivationState(
      updateType,
      notificationType) {
    this.proxy.sendMessage(
        32,
        blink.mojom.LocalFrameHost_UpdateUserActivationState_ParamsSpec.$,
        null,
        [
          updateType,
          notificationType
        ],
        false);
  }

  
  /**
   */

  didConsumeHistoryUserActivation() {
    this.proxy.sendMessage(
        33,
        blink.mojom.LocalFrameHost_DidConsumeHistoryUserActivation_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FindInPageResultAXParams } params
   */

  handleAccessibilityFindInPageResult(
      params) {
    this.proxy.sendMessage(
        34,
        blink.mojom.LocalFrameHost_HandleAccessibilityFindInPageResult_ParamsSpec.$,
        null,
        [
          params
        ],
        false);
  }

  
  /**
   */

  handleAccessibilityFindInPageTermination() {
    this.proxy.sendMessage(
        35,
        blink.mojom.LocalFrameHost_HandleAccessibilityFindInPageTermination_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  documentOnLoadCompleted() {
    this.proxy.sendMessage(
        36,
        blink.mojom.LocalFrameHost_DocumentOnLoadCompleted_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.ResourceTimingInfo } timing
   */

  forwardResourceTimingToParent(
      timing) {
    this.proxy.sendMessage(
        37,
        blink.mojom.LocalFrameHost_ForwardResourceTimingToParent_ParamsSpec.$,
        null,
        [
          timing
        ],
        false);
  }

  
  /**
   */

  didDispatchDOMContentLoadedEvent() {
    this.proxy.sendMessage(
        38,
        blink.mojom.LocalFrameHost_DidDispatchDOMContentLoadedEvent_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.String16 } alertMessage
   * @param { !boolean } disableThirdPartySubframeSuppresion
   * @return {!Promise}
   */

  runModalAlertDialog(
      alertMessage,
      disableThirdPartySubframeSuppresion) {
    return this.proxy.sendMessage(
        39,
        blink.mojom.LocalFrameHost_RunModalAlertDialog_ParamsSpec.$,
        blink.mojom.LocalFrameHost_RunModalAlertDialog_ResponseParamsSpec.$,
        [
          alertMessage,
          disableThirdPartySubframeSuppresion
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.String16 } alertMessage
   * @param { !boolean } disableThirdPartySubframeSuppresion
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  runModalConfirmDialog(
      alertMessage,
      disableThirdPartySubframeSuppresion) {
    return this.proxy.sendMessage(
        40,
        blink.mojom.LocalFrameHost_RunModalConfirmDialog_ParamsSpec.$,
        blink.mojom.LocalFrameHost_RunModalConfirmDialog_ResponseParamsSpec.$,
        [
          alertMessage,
          disableThirdPartySubframeSuppresion
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.String16 } alertMessage
   * @param { !mojoBase.mojom.String16 } defaultValue
   * @param { !boolean } disableThirdPartySubframeSuppresion
   * @return {!Promise<{
        success: !boolean,
        result: !mojoBase.mojom.String16,
   *  }>}
   */

  runModalPromptDialog(
      alertMessage,
      defaultValue,
      disableThirdPartySubframeSuppresion) {
    return this.proxy.sendMessage(
        41,
        blink.mojom.LocalFrameHost_RunModalPromptDialog_ParamsSpec.$,
        blink.mojom.LocalFrameHost_RunModalPromptDialog_ResponseParamsSpec.$,
        [
          alertMessage,
          defaultValue,
          disableThirdPartySubframeSuppresion
        ],
        false);
  }

  
  /**
   * @param { !boolean } isReload
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  runBeforeUnloadConfirm(
      isReload) {
    return this.proxy.sendMessage(
        42,
        blink.mojom.LocalFrameHost_RunBeforeUnloadConfirm_ParamsSpec.$,
        blink.mojom.LocalFrameHost_RunBeforeUnloadConfirm_ResponseParamsSpec.$,
        [
          isReload
        ],
        false);
  }

  
  /**
   * @param { !Array<!blink.mojom.FaviconURL> } faviconUrls
   */

  updateFaviconURL(
      faviconUrls) {
    this.proxy.sendMessage(
        43,
        blink.mojom.LocalFrameHost_UpdateFaviconURL_ParamsSpec.$,
        null,
        [
          faviconUrls
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.DownloadURLParams } params
   */

  downloadURL(
      params) {
    this.proxy.sendMessage(
        44,
        blink.mojom.LocalFrameHost_DownloadURL_ParamsSpec.$,
        null,
        [
          params
        ],
        false);
  }

  
  /**
   * @param { !boolean } isEditableElement
   * @param { !boolean } isRichlyEditableElement
   * @param { !gfx.mojom.Rect } boundsInFrameWidget
   * @param { !blink.mojom.FocusType } focusType
   */

  focusedElementChanged(
      isEditableElement,
      isRichlyEditableElement,
      boundsInFrameWidget,
      focusType) {
    this.proxy.sendMessage(
        45,
        blink.mojom.LocalFrameHost_FocusedElementChanged_ParamsSpec.$,
        null,
        [
          isEditableElement,
          isRichlyEditableElement,
          boundsInFrameWidget,
          focusType
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.BigString16 } text
   * @param { !number } offset
   * @param { !gfx.mojom.Range } range
   */

  textSelectionChanged(
      text,
      offset,
      range) {
    this.proxy.sendMessage(
        46,
        blink.mojom.LocalFrameHost_TextSelectionChanged_ParamsSpec.$,
        null,
        [
          text,
          offset,
          range
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.PopupMenuClientRemote } popupClient
   * @param { !gfx.mojom.Rect } bounds
   * @param { !number } fontSize
   * @param { !number } selectedItem
   * @param { !Array<!blink.mojom.MenuItem> } menuItems
   * @param { !boolean } rightAligned
   * @param { !boolean } allowMultipleSelection
   */

  showPopupMenu(
      popupClient,
      bounds,
      fontSize,
      selectedItem,
      menuItems,
      rightAligned,
      allowMultipleSelection) {
    this.proxy.sendMessage(
        47,
        blink.mojom.LocalFrameHost_ShowPopupMenu_ParamsSpec.$,
        null,
        [
          popupClient,
          bounds,
          fontSize,
          selectedItem,
          menuItems,
          rightAligned,
          allowMultipleSelection
        ],
        false);
  }

  
  /**
   * @param { !Object } popupHost
   * @param { !Object } blinkWidgetHost
   * @param { !Object } blinkWidget
   */

  createNewPopupWidget(
      popupHost,
      blinkWidgetHost,
      blinkWidget) {
    this.proxy.sendMessage(
        48,
        blink.mojom.LocalFrameHost_CreateNewPopupWidget_ParamsSpec.$,
        null,
        [
          popupHost,
          blinkWidgetHost,
          blinkWidget
        ],
        false);
  }

  
  /**
   * @param { !Object } client
   * @param { !blink.mojom.UntrustworthyContextMenuParams } params
   */

  showContextMenu(
      client,
      params) {
    this.proxy.sendMessage(
        49,
        blink.mojom.LocalFrameHost_ShowContextMenu_ParamsSpec.$,
        null,
        [
          client,
          params
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @param { !string } httpMethod
   * @param { !string } mimeType
   * @param { !network.mojom.RequestDestination } requestDestination
   * @param { !boolean } includeCredentials
   */

  didLoadResourceFromMemoryCache(
      url,
      httpMethod,
      mimeType,
      requestDestination,
      includeCredentials) {
    this.proxy.sendMessage(
        50,
        blink.mojom.LocalFrameHost_DidLoadResourceFromMemoryCache_ParamsSpec.$,
        null,
        [
          url,
          httpMethod,
          mimeType,
          requestDestination,
          includeCredentials
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FrameToken } childFrameToken
   * @param { !blink.mojom.FrameOwnerProperties } frameOwnerProperties
   */

  didChangeFrameOwnerProperties(
      childFrameToken,
      frameOwnerProperties) {
    this.proxy.sendMessage(
        51,
        blink.mojom.LocalFrameHost_DidChangeFrameOwnerProperties_ParamsSpec.$,
        null,
        [
          childFrameToken,
          frameOwnerProperties
        ],
        false);
  }

  
  /**
   * @param { ?blink.mojom.LocalFrameToken } openerFrame
   */

  didChangeOpener(
      openerFrame) {
    this.proxy.sendMessage(
        52,
        blink.mojom.LocalFrameHost_DidChangeOpener_ParamsSpec.$,
        null,
        [
          openerFrame
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FrameToken } childFrameToken
   * @param { !blink.mojom.FramePolicy } framePolicy
   */

  didChangeFramePolicy(
      childFrameToken,
      framePolicy) {
    this.proxy.sendMessage(
        53,
        blink.mojom.LocalFrameHost_DidChangeFramePolicy_ParamsSpec.$,
        null,
        [
          childFrameToken,
          framePolicy
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FrameToken } childFrameToken
   * @param { !blink.mojom.IframeAttributes } attributes
   */

  didChangeIframeAttributes(
      childFrameToken,
      attributes) {
    this.proxy.sendMessage(
        54,
        blink.mojom.LocalFrameHost_DidChangeIframeAttributes_ParamsSpec.$,
        null,
        [
          childFrameToken,
          attributes
        ],
        false);
  }

  
  /**
   * @param { !gfx.mojom.Rect } clipRect
   * @param { !mojoBase.mojom.UnguessableToken } guid
   */

  capturePaintPreviewOfSubframe(
      clipRect,
      guid) {
    this.proxy.sendMessage(
        55,
        blink.mojom.LocalFrameHost_CapturePaintPreviewOfSubframe_ParamsSpec.$,
        null,
        [
          clipRect,
          guid
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.CloseListenerRemote } listener
   */

  setCloseListener(
      listener) {
    this.proxy.sendMessage(
        56,
        blink.mojom.LocalFrameHost_SetCloseListener_ParamsSpec.$,
        null,
        [
          listener
        ],
        false);
  }

  
  /**
   */

  detach() {
    this.proxy.sendMessage(
        57,
        blink.mojom.LocalFrameHost_Detach_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.KeepAliveHandleFactoryPendingReceiver } factory
   */

  getKeepAliveHandleFactory(
      factory) {
    this.proxy.sendMessage(
        58,
        blink.mojom.LocalFrameHost_GetKeepAliveHandleFactory_ParamsSpec.$,
        null,
        [
          factory
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.ConsoleMessageLevel } logLevel
   * @param { !mojoBase.mojom.BigString16 } msg
   * @param { !number } lineNumber
   * @param { ?mojoBase.mojom.String16 } sourceId
   * @param { ?mojoBase.mojom.BigString16 } untrustedStackTrace
   */

  didAddMessageToConsole(
      logLevel,
      msg,
      lineNumber,
      sourceId,
      untrustedStackTrace) {
    this.proxy.sendMessage(
        59,
        blink.mojom.LocalFrameHost_DidAddMessageToConsole_ParamsSpec.$,
        null,
        [
          logLevel,
          msg,
          lineNumber,
          sourceId,
          untrustedStackTrace
        ],
        false);
  }

  
  /**
   * @param { !gfx.mojom.Size } size
   */

  frameSizeChanged(
      size) {
    this.proxy.sendMessage(
        60,
        blink.mojom.LocalFrameHost_FrameSizeChanged_ParamsSpec.$,
        null,
        [
          size
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.PreferredColorScheme } colorScheme
   */

  didInferColorScheme(
      colorScheme) {
    this.proxy.sendMessage(
        61,
        blink.mojom.LocalFrameHost_DidInferColorScheme_ParamsSpec.$,
        null,
        [
          colorScheme
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FrameToken } childFrameToken
   * @param { !string } srcdocValue
   */

  didChangeSrcDoc(
      childFrameToken,
      srcdocValue) {
    this.proxy.sendMessage(
        62,
        blink.mojom.LocalFrameHost_DidChangeSrcDoc_ParamsSpec.$,
        null,
        [
          childFrameToken,
          srcdocValue
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.DelegatedCapability } delegatedCapability
   */

  receivedDelegatedCapability(
      delegatedCapability) {
    this.proxy.sendMessage(
        63,
        blink.mojom.LocalFrameHost_ReceivedDelegatedCapability_ParamsSpec.$,
        null,
        [
          delegatedCapability
        ],
        false);
  }

  
  /**
   * @param { !string } eventData
   * @param { !string } eventType
   * @param { !Array<!blink.mojom.ReportingDestination> } destinations
   * @param { !boolean } crossOriginExposed
   */

  sendFencedFrameReportingBeacon(
      eventData,
      eventType,
      destinations,
      crossOriginExposed) {
    this.proxy.sendMessage(
        64,
        blink.mojom.LocalFrameHost_SendFencedFrameReportingBeacon_ParamsSpec.$,
        null,
        [
          eventData,
          eventType,
          destinations,
          crossOriginExposed
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } destinationUrl
   * @param { !boolean } crossOriginExposed
   */

  sendFencedFrameReportingBeaconToCustomURL(
      destinationUrl,
      crossOriginExposed) {
    this.proxy.sendMessage(
        65,
        blink.mojom.LocalFrameHost_SendFencedFrameReportingBeaconToCustomURL_ParamsSpec.$,
        null,
        [
          destinationUrl,
          crossOriginExposed
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  disableUntrustedNetworkInFencedFrame() {
    return this.proxy.sendMessage(
        66,
        blink.mojom.LocalFrameHost_DisableUntrustedNetworkInFencedFrame_ParamsSpec.$,
        blink.mojom.LocalFrameHost_DisableUntrustedNetworkInFencedFrame_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } exemptedUrl
   * @return {!Promise}
   */

  exemptUrlFromNetworkRevocationForTesting(
      exemptedUrl) {
    return this.proxy.sendMessage(
        67,
        blink.mojom.LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_ParamsSpec.$,
        blink.mojom.LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_ResponseParamsSpec.$,
        [
          exemptedUrl
        ],
        false);
  }

  
  /**
   * @param { !string } type
   * @param { !blink.mojom.LegacyTechEventCodeLocation } codeLocation
   */

  sendLegacyTechEvent(
      type,
      codeLocation) {
    this.proxy.sendMessage(
        68,
        blink.mojom.LocalFrameHost_SendLegacyTechEvent_ParamsSpec.$,
        null,
        [
          type,
          codeLocation
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.AutomaticBeaconType } eventType
   * @param { !string } eventData
   * @param { !Array<!blink.mojom.ReportingDestination> } destinations
   * @param { !boolean } once
   * @param { !boolean } crossOriginExposed
   */

  setFencedFrameAutomaticBeaconReportEventData(
      eventType,
      eventData,
      destinations,
      once,
      crossOriginExposed) {
    this.proxy.sendMessage(
        69,
        blink.mojom.LocalFrameHost_SetFencedFrameAutomaticBeaconReportEventData_ParamsSpec.$,
        null,
        [
          eventType,
          eventData,
          destinations,
          once,
          crossOriginExposed
        ],
        false);
  }

  
  /**
   * @param { !string } eventType
   */

  sendPrivateAggregationRequestsForFencedFrameEvent(
      eventType) {
    this.proxy.sendMessage(
        70,
        blink.mojom.LocalFrameHost_SendPrivateAggregationRequestsForFencedFrameEvent_ParamsSpec.$,
        null,
        [
          eventType
        ],
        false);
  }

  
  /**
   * @param { !Object } fencedFrame
   * @param { !blink.mojom.RemoteFrameInterfacesFromRenderer } remoteFrameInterfaces
   * @param { !blink.mojom.RemoteFrameToken } frameToken
   * @param { !mojoBase.mojom.UnguessableToken } devtoolsFrameToken
   */

  createFencedFrame(
      fencedFrame,
      remoteFrameInterfaces,
      frameToken,
      devtoolsFrameToken) {
    this.proxy.sendMessage(
        71,
        blink.mojom.LocalFrameHost_CreateFencedFrame_ParamsSpec.$,
        null,
        [
          fencedFrame,
          remoteFrameInterfaces,
          frameToken,
          devtoolsFrameToken
        ],
        false);
  }

  
  /**
   * @param { !string } eventType
   */

  forwardFencedFrameEventAndUserActivationToEmbedder(
      eventType) {
    this.proxy.sendMessage(
        72,
        blink.mojom.LocalFrameHost_ForwardFencedFrameEventAndUserActivationToEmbedder_ParamsSpec.$,
        null,
        [
          eventType
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.ViewTransitionSameOriginOptIn } viewTransitionOptIn
   */

  onViewTransitionOptInChanged(
      viewTransitionOptIn) {
    this.proxy.sendMessage(
        73,
        blink.mojom.LocalFrameHost_OnViewTransitionOptInChanged_ParamsSpec.$,
        null,
        [
          viewTransitionOptIn
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.DragData } dragData
   * @param { !blink.mojom.AllowedDragOperations } operationsAllowed
   * @param { ?skia.mojom.BitmapN32 } image
   * @param { !gfx.mojom.Vector2d } cursorOffsetInDip
   * @param { !gfx.mojom.Rect } dragObjRectInDip
   * @param { !blink.mojom.DragEventSourceInfo } eventInfo
   */

  startDragging(
      dragData,
      operationsAllowed,
      image,
      cursorOffsetInDip,
      dragObjRectInDip,
      eventInfo) {
    this.proxy.sendMessage(
        74,
        blink.mojom.LocalFrameHost_StartDragging_ParamsSpec.$,
        null,
        [
          dragData,
          operationsAllowed,
          image,
          cursorOffsetInDip,
          dragObjRectInDip,
          eventInfo
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.NavigationStateKeepAliveHandlePendingReceiver } receiver
   */

  issueKeepAliveHandle(
      receiver) {
    this.proxy.sendMessage(
        75,
        blink.mojom.LocalFrameHost_IssueKeepAliveHandle_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.StorageTypeAccessed } storageType
   * @param { !boolean } blocked
   */

  notifyStorageAccessed(
      storageType,
      blocked) {
    this.proxy.sendMessage(
        76,
        blink.mojom.LocalFrameHost_NotifyStorageAccessed_ParamsSpec.$,
        null,
        [
          storageType,
          blocked
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FrameToken } targetFrameToken
   * @param { !blink.mojom.WindowProxyAccessType } accessType
   */

  recordWindowProxyUsageMetrics(
      targetFrameToken,
      accessType) {
    this.proxy.sendMessage(
        77,
        blink.mojom.LocalFrameHost_RecordWindowProxyUsageMetrics_ParamsSpec.$,
        null,
        [
          targetFrameToken,
          accessType
        ],
        false);
  }

  
  /**
   */

  notifyDocumentInteractive() {
    this.proxy.sendMessage(
        78,
        blink.mojom.LocalFrameHost_NotifyDocumentInteractive_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.StorageAccessApiStatus } status
   */

  setStorageAccessApiStatus(
      status) {
    this.proxy.sendMessage(
        79,
        blink.mojom.LocalFrameHost_SetStorageAccessApiStatus_ParamsSpec.$,
        null,
        [
          status
        ],
        false);
  }

  
  /**
   * @param { !bigint } length
   * @return {!Promise}
   */

  initializeCrashReportStorage(
      length) {
    return this.proxy.sendMessage(
        80,
        blink.mojom.LocalFrameHost_InitializeCrashReportStorage_ParamsSpec.$,
        blink.mojom.LocalFrameHost_InitializeCrashReportStorage_ResponseParamsSpec.$,
        [
          length
        ],
        false);
  }

  
  /**
   * @param { !string } key
   * @param { !string } value
   * @return {!Promise}
   */

  setCrashReportStorageKey(
      key,
      value) {
    return this.proxy.sendMessage(
        81,
        blink.mojom.LocalFrameHost_SetCrashReportStorageKey_ParamsSpec.$,
        blink.mojom.LocalFrameHost_SetCrashReportStorageKey_ResponseParamsSpec.$,
        [
          key,
          value
        ],
        false);
  }

  
  /**
   * @param { !string } key
   * @return {!Promise}
   */

  removeCrashReportStorageKey(
      key) {
    return this.proxy.sendMessage(
        82,
        blink.mojom.LocalFrameHost_RemoveCrashReportStorageKey_ParamsSpec.$,
        blink.mojom.LocalFrameHost_RemoveCrashReportStorageKey_ResponseParamsSpec.$,
        [
          key
        ],
        false);
  }
};

/**
 * An object which receives request messages for the LocalFrameHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.LocalFrameHostReceiver = class {
  /**
   * @param {!blink.mojom.LocalFrameHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.LocalFrameHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.LocalFrameHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.LocalFrameHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.LocalFrameHost_EnterFullscreen_ParamsSpec.$,
        blink.mojom.LocalFrameHost_EnterFullscreen_ResponseParamsSpec.$,
        impl.enterFullscreen.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.LocalFrameHost_ExitFullscreen_ParamsSpec.$,
        null,
        impl.exitFullscreen.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.LocalFrameHost_FullscreenStateChanged_ParamsSpec.$,
        null,
        impl.fullscreenStateChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.LocalFrameHost_RegisterProtocolHandler_ParamsSpec.$,
        null,
        impl.registerProtocolHandler.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.LocalFrameHost_UnregisterProtocolHandler_ParamsSpec.$,
        null,
        impl.unregisterProtocolHandler.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.LocalFrameHost_DidDisplayInsecureContent_ParamsSpec.$,
        null,
        impl.didDisplayInsecureContent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        blink.mojom.LocalFrameHost_DidContainInsecureFormAction_ParamsSpec.$,
        null,
        impl.didContainInsecureFormAction.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        blink.mojom.LocalFrameHost_MainDocumentElementAvailable_ParamsSpec.$,
        null,
        impl.mainDocumentElementAvailable.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        blink.mojom.LocalFrameHost_SetNeedsOcclusionTracking_ParamsSpec.$,
        null,
        impl.setNeedsOcclusionTracking.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        blink.mojom.LocalFrameHost_SetVirtualKeyboardMode_ParamsSpec.$,
        null,
        impl.setVirtualKeyboardMode.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        blink.mojom.LocalFrameHost_VisibilityChanged_ParamsSpec.$,
        null,
        impl.visibilityChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        blink.mojom.LocalFrameHost_DidChangeThemeColor_ParamsSpec.$,
        null,
        impl.didChangeThemeColor.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        blink.mojom.LocalFrameHost_DidChangeBackgroundColor_ParamsSpec.$,
        null,
        impl.didChangeBackgroundColor.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        blink.mojom.LocalFrameHost_DidFailLoadWithError_ParamsSpec.$,
        null,
        impl.didFailLoadWithError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        blink.mojom.LocalFrameHost_DidFocusFrame_ParamsSpec.$,
        null,
        impl.didFocusFrame.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        blink.mojom.LocalFrameHost_DidCallFocus_ParamsSpec.$,
        null,
        impl.didCallFocus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        blink.mojom.LocalFrameHost_EnforceInsecureRequestPolicy_ParamsSpec.$,
        null,
        impl.enforceInsecureRequestPolicy.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        blink.mojom.LocalFrameHost_EnforceInsecureNavigationsSet_ParamsSpec.$,
        null,
        impl.enforceInsecureNavigationsSet.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        blink.mojom.LocalFrameHost_SuddenTerminationDisablerChanged_ParamsSpec.$,
        null,
        impl.suddenTerminationDisablerChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        19,
        blink.mojom.LocalFrameHost_HadStickyUserActivationBeforeNavigationChanged_ParamsSpec.$,
        null,
        impl.hadStickyUserActivationBeforeNavigationChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        20,
        blink.mojom.LocalFrameHost_ScrollRectToVisibleInParentFrame_ParamsSpec.$,
        null,
        impl.scrollRectToVisibleInParentFrame.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        21,
        blink.mojom.LocalFrameHost_BubbleLogicalScrollInParentFrame_ParamsSpec.$,
        null,
        impl.bubbleLogicalScrollInParentFrame.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        22,
        blink.mojom.LocalFrameHost_StartLoadingForAsyncNavigationApiCommit_ParamsSpec.$,
        null,
        impl.startLoadingForAsyncNavigationApiCommit.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        23,
        blink.mojom.LocalFrameHost_DidBlockNavigation_ParamsSpec.$,
        null,
        impl.didBlockNavigation.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        24,
        blink.mojom.LocalFrameHost_DidChangeLoadProgress_ParamsSpec.$,
        null,
        impl.didChangeLoadProgress.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        25,
        blink.mojom.LocalFrameHost_DidFinishLoad_ParamsSpec.$,
        null,
        impl.didFinishLoad.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        26,
        blink.mojom.LocalFrameHost_DispatchLoad_ParamsSpec.$,
        null,
        impl.dispatchLoad.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        27,
        blink.mojom.LocalFrameHost_GoToEntryAtOffset_ParamsSpec.$,
        null,
        impl.goToEntryAtOffset.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        28,
        blink.mojom.LocalFrameHost_NavigateToNavigationApiKey_ParamsSpec.$,
        null,
        impl.navigateToNavigationApiKey.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        29,
        blink.mojom.LocalFrameHost_NavigateEventHandlerPresenceChanged_ParamsSpec.$,
        null,
        impl.navigateEventHandlerPresenceChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        30,
        blink.mojom.LocalFrameHost_UpdateTitle_ParamsSpec.$,
        null,
        impl.updateTitle.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        31,
        blink.mojom.LocalFrameHost_UpdateApplicationTitle_ParamsSpec.$,
        null,
        impl.updateApplicationTitle.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        32,
        blink.mojom.LocalFrameHost_UpdateUserActivationState_ParamsSpec.$,
        null,
        impl.updateUserActivationState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        33,
        blink.mojom.LocalFrameHost_DidConsumeHistoryUserActivation_ParamsSpec.$,
        null,
        impl.didConsumeHistoryUserActivation.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        34,
        blink.mojom.LocalFrameHost_HandleAccessibilityFindInPageResult_ParamsSpec.$,
        null,
        impl.handleAccessibilityFindInPageResult.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        35,
        blink.mojom.LocalFrameHost_HandleAccessibilityFindInPageTermination_ParamsSpec.$,
        null,
        impl.handleAccessibilityFindInPageTermination.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        36,
        blink.mojom.LocalFrameHost_DocumentOnLoadCompleted_ParamsSpec.$,
        null,
        impl.documentOnLoadCompleted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        37,
        blink.mojom.LocalFrameHost_ForwardResourceTimingToParent_ParamsSpec.$,
        null,
        impl.forwardResourceTimingToParent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        38,
        blink.mojom.LocalFrameHost_DidDispatchDOMContentLoadedEvent_ParamsSpec.$,
        null,
        impl.didDispatchDOMContentLoadedEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        39,
        blink.mojom.LocalFrameHost_RunModalAlertDialog_ParamsSpec.$,
        blink.mojom.LocalFrameHost_RunModalAlertDialog_ResponseParamsSpec.$,
        impl.runModalAlertDialog.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        40,
        blink.mojom.LocalFrameHost_RunModalConfirmDialog_ParamsSpec.$,
        blink.mojom.LocalFrameHost_RunModalConfirmDialog_ResponseParamsSpec.$,
        impl.runModalConfirmDialog.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        41,
        blink.mojom.LocalFrameHost_RunModalPromptDialog_ParamsSpec.$,
        blink.mojom.LocalFrameHost_RunModalPromptDialog_ResponseParamsSpec.$,
        impl.runModalPromptDialog.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        42,
        blink.mojom.LocalFrameHost_RunBeforeUnloadConfirm_ParamsSpec.$,
        blink.mojom.LocalFrameHost_RunBeforeUnloadConfirm_ResponseParamsSpec.$,
        impl.runBeforeUnloadConfirm.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        43,
        blink.mojom.LocalFrameHost_UpdateFaviconURL_ParamsSpec.$,
        null,
        impl.updateFaviconURL.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        44,
        blink.mojom.LocalFrameHost_DownloadURL_ParamsSpec.$,
        null,
        impl.downloadURL.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        45,
        blink.mojom.LocalFrameHost_FocusedElementChanged_ParamsSpec.$,
        null,
        impl.focusedElementChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        46,
        blink.mojom.LocalFrameHost_TextSelectionChanged_ParamsSpec.$,
        null,
        impl.textSelectionChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        47,
        blink.mojom.LocalFrameHost_ShowPopupMenu_ParamsSpec.$,
        null,
        impl.showPopupMenu.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        48,
        blink.mojom.LocalFrameHost_CreateNewPopupWidget_ParamsSpec.$,
        null,
        impl.createNewPopupWidget.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        49,
        blink.mojom.LocalFrameHost_ShowContextMenu_ParamsSpec.$,
        null,
        impl.showContextMenu.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        50,
        blink.mojom.LocalFrameHost_DidLoadResourceFromMemoryCache_ParamsSpec.$,
        null,
        impl.didLoadResourceFromMemoryCache.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        51,
        blink.mojom.LocalFrameHost_DidChangeFrameOwnerProperties_ParamsSpec.$,
        null,
        impl.didChangeFrameOwnerProperties.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        52,
        blink.mojom.LocalFrameHost_DidChangeOpener_ParamsSpec.$,
        null,
        impl.didChangeOpener.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        53,
        blink.mojom.LocalFrameHost_DidChangeFramePolicy_ParamsSpec.$,
        null,
        impl.didChangeFramePolicy.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        54,
        blink.mojom.LocalFrameHost_DidChangeIframeAttributes_ParamsSpec.$,
        null,
        impl.didChangeIframeAttributes.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        55,
        blink.mojom.LocalFrameHost_CapturePaintPreviewOfSubframe_ParamsSpec.$,
        null,
        impl.capturePaintPreviewOfSubframe.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        56,
        blink.mojom.LocalFrameHost_SetCloseListener_ParamsSpec.$,
        null,
        impl.setCloseListener.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        57,
        blink.mojom.LocalFrameHost_Detach_ParamsSpec.$,
        null,
        impl.detach.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        58,
        blink.mojom.LocalFrameHost_GetKeepAliveHandleFactory_ParamsSpec.$,
        null,
        impl.getKeepAliveHandleFactory.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        59,
        blink.mojom.LocalFrameHost_DidAddMessageToConsole_ParamsSpec.$,
        null,
        impl.didAddMessageToConsole.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        60,
        blink.mojom.LocalFrameHost_FrameSizeChanged_ParamsSpec.$,
        null,
        impl.frameSizeChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        61,
        blink.mojom.LocalFrameHost_DidInferColorScheme_ParamsSpec.$,
        null,
        impl.didInferColorScheme.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        62,
        blink.mojom.LocalFrameHost_DidChangeSrcDoc_ParamsSpec.$,
        null,
        impl.didChangeSrcDoc.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        63,
        blink.mojom.LocalFrameHost_ReceivedDelegatedCapability_ParamsSpec.$,
        null,
        impl.receivedDelegatedCapability.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        64,
        blink.mojom.LocalFrameHost_SendFencedFrameReportingBeacon_ParamsSpec.$,
        null,
        impl.sendFencedFrameReportingBeacon.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        65,
        blink.mojom.LocalFrameHost_SendFencedFrameReportingBeaconToCustomURL_ParamsSpec.$,
        null,
        impl.sendFencedFrameReportingBeaconToCustomURL.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        66,
        blink.mojom.LocalFrameHost_DisableUntrustedNetworkInFencedFrame_ParamsSpec.$,
        blink.mojom.LocalFrameHost_DisableUntrustedNetworkInFencedFrame_ResponseParamsSpec.$,
        impl.disableUntrustedNetworkInFencedFrame.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        67,
        blink.mojom.LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_ParamsSpec.$,
        blink.mojom.LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_ResponseParamsSpec.$,
        impl.exemptUrlFromNetworkRevocationForTesting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        68,
        blink.mojom.LocalFrameHost_SendLegacyTechEvent_ParamsSpec.$,
        null,
        impl.sendLegacyTechEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        69,
        blink.mojom.LocalFrameHost_SetFencedFrameAutomaticBeaconReportEventData_ParamsSpec.$,
        null,
        impl.setFencedFrameAutomaticBeaconReportEventData.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        70,
        blink.mojom.LocalFrameHost_SendPrivateAggregationRequestsForFencedFrameEvent_ParamsSpec.$,
        null,
        impl.sendPrivateAggregationRequestsForFencedFrameEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        71,
        blink.mojom.LocalFrameHost_CreateFencedFrame_ParamsSpec.$,
        null,
        impl.createFencedFrame.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        72,
        blink.mojom.LocalFrameHost_ForwardFencedFrameEventAndUserActivationToEmbedder_ParamsSpec.$,
        null,
        impl.forwardFencedFrameEventAndUserActivationToEmbedder.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        73,
        blink.mojom.LocalFrameHost_OnViewTransitionOptInChanged_ParamsSpec.$,
        null,
        impl.onViewTransitionOptInChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        74,
        blink.mojom.LocalFrameHost_StartDragging_ParamsSpec.$,
        null,
        impl.startDragging.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        75,
        blink.mojom.LocalFrameHost_IssueKeepAliveHandle_ParamsSpec.$,
        null,
        impl.issueKeepAliveHandle.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        76,
        blink.mojom.LocalFrameHost_NotifyStorageAccessed_ParamsSpec.$,
        null,
        impl.notifyStorageAccessed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        77,
        blink.mojom.LocalFrameHost_RecordWindowProxyUsageMetrics_ParamsSpec.$,
        null,
        impl.recordWindowProxyUsageMetrics.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        78,
        blink.mojom.LocalFrameHost_NotifyDocumentInteractive_ParamsSpec.$,
        null,
        impl.notifyDocumentInteractive.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        79,
        blink.mojom.LocalFrameHost_SetStorageAccessApiStatus_ParamsSpec.$,
        null,
        impl.setStorageAccessApiStatus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        80,
        blink.mojom.LocalFrameHost_InitializeCrashReportStorage_ParamsSpec.$,
        blink.mojom.LocalFrameHost_InitializeCrashReportStorage_ResponseParamsSpec.$,
        impl.initializeCrashReportStorage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        81,
        blink.mojom.LocalFrameHost_SetCrashReportStorageKey_ParamsSpec.$,
        blink.mojom.LocalFrameHost_SetCrashReportStorageKey_ResponseParamsSpec.$,
        impl.setCrashReportStorageKey.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        82,
        blink.mojom.LocalFrameHost_RemoveCrashReportStorageKey_ParamsSpec.$,
        blink.mojom.LocalFrameHost_RemoveCrashReportStorageKey_ResponseParamsSpec.$,
        impl.removeCrashReportStorageKey.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.LocalFrameHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.LocalFrameHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.LocalFrameHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.LocalFrameHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the LocalFrameHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.LocalFrameHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.LocalFrameHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.LocalFrameHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enterFullscreen =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.LocalFrameHost_EnterFullscreen_ParamsSpec.$,
        blink.mojom.LocalFrameHost_EnterFullscreen_ResponseParamsSpec.$,
        this.enterFullscreen.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.exitFullscreen =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.LocalFrameHost_ExitFullscreen_ParamsSpec.$,
        null,
        this.exitFullscreen.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.fullscreenStateChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.LocalFrameHost_FullscreenStateChanged_ParamsSpec.$,
        null,
        this.fullscreenStateChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.registerProtocolHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.LocalFrameHost_RegisterProtocolHandler_ParamsSpec.$,
        null,
        this.registerProtocolHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.unregisterProtocolHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.LocalFrameHost_UnregisterProtocolHandler_ParamsSpec.$,
        null,
        this.unregisterProtocolHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didDisplayInsecureContent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.LocalFrameHost_DidDisplayInsecureContent_ParamsSpec.$,
        null,
        this.didDisplayInsecureContent.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didContainInsecureFormAction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        blink.mojom.LocalFrameHost_DidContainInsecureFormAction_ParamsSpec.$,
        null,
        this.didContainInsecureFormAction.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.mainDocumentElementAvailable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        blink.mojom.LocalFrameHost_MainDocumentElementAvailable_ParamsSpec.$,
        null,
        this.mainDocumentElementAvailable.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setNeedsOcclusionTracking =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        blink.mojom.LocalFrameHost_SetNeedsOcclusionTracking_ParamsSpec.$,
        null,
        this.setNeedsOcclusionTracking.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setVirtualKeyboardMode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        blink.mojom.LocalFrameHost_SetVirtualKeyboardMode_ParamsSpec.$,
        null,
        this.setVirtualKeyboardMode.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.visibilityChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        blink.mojom.LocalFrameHost_VisibilityChanged_ParamsSpec.$,
        null,
        this.visibilityChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didChangeThemeColor =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        blink.mojom.LocalFrameHost_DidChangeThemeColor_ParamsSpec.$,
        null,
        this.didChangeThemeColor.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didChangeBackgroundColor =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        blink.mojom.LocalFrameHost_DidChangeBackgroundColor_ParamsSpec.$,
        null,
        this.didChangeBackgroundColor.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didFailLoadWithError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        blink.mojom.LocalFrameHost_DidFailLoadWithError_ParamsSpec.$,
        null,
        this.didFailLoadWithError.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didFocusFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        blink.mojom.LocalFrameHost_DidFocusFrame_ParamsSpec.$,
        null,
        this.didFocusFrame.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didCallFocus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        blink.mojom.LocalFrameHost_DidCallFocus_ParamsSpec.$,
        null,
        this.didCallFocus.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enforceInsecureRequestPolicy =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        blink.mojom.LocalFrameHost_EnforceInsecureRequestPolicy_ParamsSpec.$,
        null,
        this.enforceInsecureRequestPolicy.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enforceInsecureNavigationsSet =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        blink.mojom.LocalFrameHost_EnforceInsecureNavigationsSet_ParamsSpec.$,
        null,
        this.enforceInsecureNavigationsSet.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.suddenTerminationDisablerChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        blink.mojom.LocalFrameHost_SuddenTerminationDisablerChanged_ParamsSpec.$,
        null,
        this.suddenTerminationDisablerChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.hadStickyUserActivationBeforeNavigationChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        19,
        blink.mojom.LocalFrameHost_HadStickyUserActivationBeforeNavigationChanged_ParamsSpec.$,
        null,
        this.hadStickyUserActivationBeforeNavigationChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.scrollRectToVisibleInParentFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        20,
        blink.mojom.LocalFrameHost_ScrollRectToVisibleInParentFrame_ParamsSpec.$,
        null,
        this.scrollRectToVisibleInParentFrame.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bubbleLogicalScrollInParentFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        21,
        blink.mojom.LocalFrameHost_BubbleLogicalScrollInParentFrame_ParamsSpec.$,
        null,
        this.bubbleLogicalScrollInParentFrame.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startLoadingForAsyncNavigationApiCommit =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        22,
        blink.mojom.LocalFrameHost_StartLoadingForAsyncNavigationApiCommit_ParamsSpec.$,
        null,
        this.startLoadingForAsyncNavigationApiCommit.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didBlockNavigation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        23,
        blink.mojom.LocalFrameHost_DidBlockNavigation_ParamsSpec.$,
        null,
        this.didBlockNavigation.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didChangeLoadProgress =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        24,
        blink.mojom.LocalFrameHost_DidChangeLoadProgress_ParamsSpec.$,
        null,
        this.didChangeLoadProgress.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didFinishLoad =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        25,
        blink.mojom.LocalFrameHost_DidFinishLoad_ParamsSpec.$,
        null,
        this.didFinishLoad.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchLoad =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        26,
        blink.mojom.LocalFrameHost_DispatchLoad_ParamsSpec.$,
        null,
        this.dispatchLoad.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.goToEntryAtOffset =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        27,
        blink.mojom.LocalFrameHost_GoToEntryAtOffset_ParamsSpec.$,
        null,
        this.goToEntryAtOffset.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.navigateToNavigationApiKey =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        28,
        blink.mojom.LocalFrameHost_NavigateToNavigationApiKey_ParamsSpec.$,
        null,
        this.navigateToNavigationApiKey.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.navigateEventHandlerPresenceChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        29,
        blink.mojom.LocalFrameHost_NavigateEventHandlerPresenceChanged_ParamsSpec.$,
        null,
        this.navigateEventHandlerPresenceChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateTitle =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        30,
        blink.mojom.LocalFrameHost_UpdateTitle_ParamsSpec.$,
        null,
        this.updateTitle.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateApplicationTitle =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        31,
        blink.mojom.LocalFrameHost_UpdateApplicationTitle_ParamsSpec.$,
        null,
        this.updateApplicationTitle.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateUserActivationState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        32,
        blink.mojom.LocalFrameHost_UpdateUserActivationState_ParamsSpec.$,
        null,
        this.updateUserActivationState.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didConsumeHistoryUserActivation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        33,
        blink.mojom.LocalFrameHost_DidConsumeHistoryUserActivation_ParamsSpec.$,
        null,
        this.didConsumeHistoryUserActivation.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.handleAccessibilityFindInPageResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        34,
        blink.mojom.LocalFrameHost_HandleAccessibilityFindInPageResult_ParamsSpec.$,
        null,
        this.handleAccessibilityFindInPageResult.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.handleAccessibilityFindInPageTermination =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        35,
        blink.mojom.LocalFrameHost_HandleAccessibilityFindInPageTermination_ParamsSpec.$,
        null,
        this.handleAccessibilityFindInPageTermination.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.documentOnLoadCompleted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        36,
        blink.mojom.LocalFrameHost_DocumentOnLoadCompleted_ParamsSpec.$,
        null,
        this.documentOnLoadCompleted.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.forwardResourceTimingToParent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        37,
        blink.mojom.LocalFrameHost_ForwardResourceTimingToParent_ParamsSpec.$,
        null,
        this.forwardResourceTimingToParent.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didDispatchDOMContentLoadedEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        38,
        blink.mojom.LocalFrameHost_DidDispatchDOMContentLoadedEvent_ParamsSpec.$,
        null,
        this.didDispatchDOMContentLoadedEvent.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.runModalAlertDialog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        39,
        blink.mojom.LocalFrameHost_RunModalAlertDialog_ParamsSpec.$,
        blink.mojom.LocalFrameHost_RunModalAlertDialog_ResponseParamsSpec.$,
        this.runModalAlertDialog.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.runModalConfirmDialog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        40,
        blink.mojom.LocalFrameHost_RunModalConfirmDialog_ParamsSpec.$,
        blink.mojom.LocalFrameHost_RunModalConfirmDialog_ResponseParamsSpec.$,
        this.runModalConfirmDialog.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.runModalPromptDialog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        41,
        blink.mojom.LocalFrameHost_RunModalPromptDialog_ParamsSpec.$,
        blink.mojom.LocalFrameHost_RunModalPromptDialog_ResponseParamsSpec.$,
        this.runModalPromptDialog.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.runBeforeUnloadConfirm =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        42,
        blink.mojom.LocalFrameHost_RunBeforeUnloadConfirm_ParamsSpec.$,
        blink.mojom.LocalFrameHost_RunBeforeUnloadConfirm_ResponseParamsSpec.$,
        this.runBeforeUnloadConfirm.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateFaviconURL =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        43,
        blink.mojom.LocalFrameHost_UpdateFaviconURL_ParamsSpec.$,
        null,
        this.updateFaviconURL.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.downloadURL =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        44,
        blink.mojom.LocalFrameHost_DownloadURL_ParamsSpec.$,
        null,
        this.downloadURL.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.focusedElementChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        45,
        blink.mojom.LocalFrameHost_FocusedElementChanged_ParamsSpec.$,
        null,
        this.focusedElementChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.textSelectionChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        46,
        blink.mojom.LocalFrameHost_TextSelectionChanged_ParamsSpec.$,
        null,
        this.textSelectionChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.showPopupMenu =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        47,
        blink.mojom.LocalFrameHost_ShowPopupMenu_ParamsSpec.$,
        null,
        this.showPopupMenu.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createNewPopupWidget =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        48,
        blink.mojom.LocalFrameHost_CreateNewPopupWidget_ParamsSpec.$,
        null,
        this.createNewPopupWidget.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.showContextMenu =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        49,
        blink.mojom.LocalFrameHost_ShowContextMenu_ParamsSpec.$,
        null,
        this.showContextMenu.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didLoadResourceFromMemoryCache =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        50,
        blink.mojom.LocalFrameHost_DidLoadResourceFromMemoryCache_ParamsSpec.$,
        null,
        this.didLoadResourceFromMemoryCache.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didChangeFrameOwnerProperties =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        51,
        blink.mojom.LocalFrameHost_DidChangeFrameOwnerProperties_ParamsSpec.$,
        null,
        this.didChangeFrameOwnerProperties.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didChangeOpener =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        52,
        blink.mojom.LocalFrameHost_DidChangeOpener_ParamsSpec.$,
        null,
        this.didChangeOpener.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didChangeFramePolicy =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        53,
        blink.mojom.LocalFrameHost_DidChangeFramePolicy_ParamsSpec.$,
        null,
        this.didChangeFramePolicy.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didChangeIframeAttributes =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        54,
        blink.mojom.LocalFrameHost_DidChangeIframeAttributes_ParamsSpec.$,
        null,
        this.didChangeIframeAttributes.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.capturePaintPreviewOfSubframe =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        55,
        blink.mojom.LocalFrameHost_CapturePaintPreviewOfSubframe_ParamsSpec.$,
        null,
        this.capturePaintPreviewOfSubframe.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setCloseListener =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        56,
        blink.mojom.LocalFrameHost_SetCloseListener_ParamsSpec.$,
        null,
        this.setCloseListener.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.detach =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        57,
        blink.mojom.LocalFrameHost_Detach_ParamsSpec.$,
        null,
        this.detach.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getKeepAliveHandleFactory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        58,
        blink.mojom.LocalFrameHost_GetKeepAliveHandleFactory_ParamsSpec.$,
        null,
        this.getKeepAliveHandleFactory.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didAddMessageToConsole =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        59,
        blink.mojom.LocalFrameHost_DidAddMessageToConsole_ParamsSpec.$,
        null,
        this.didAddMessageToConsole.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.frameSizeChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        60,
        blink.mojom.LocalFrameHost_FrameSizeChanged_ParamsSpec.$,
        null,
        this.frameSizeChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didInferColorScheme =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        61,
        blink.mojom.LocalFrameHost_DidInferColorScheme_ParamsSpec.$,
        null,
        this.didInferColorScheme.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didChangeSrcDoc =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        62,
        blink.mojom.LocalFrameHost_DidChangeSrcDoc_ParamsSpec.$,
        null,
        this.didChangeSrcDoc.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.receivedDelegatedCapability =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        63,
        blink.mojom.LocalFrameHost_ReceivedDelegatedCapability_ParamsSpec.$,
        null,
        this.receivedDelegatedCapability.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sendFencedFrameReportingBeacon =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        64,
        blink.mojom.LocalFrameHost_SendFencedFrameReportingBeacon_ParamsSpec.$,
        null,
        this.sendFencedFrameReportingBeacon.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sendFencedFrameReportingBeaconToCustomURL =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        65,
        blink.mojom.LocalFrameHost_SendFencedFrameReportingBeaconToCustomURL_ParamsSpec.$,
        null,
        this.sendFencedFrameReportingBeaconToCustomURL.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.disableUntrustedNetworkInFencedFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        66,
        blink.mojom.LocalFrameHost_DisableUntrustedNetworkInFencedFrame_ParamsSpec.$,
        blink.mojom.LocalFrameHost_DisableUntrustedNetworkInFencedFrame_ResponseParamsSpec.$,
        this.disableUntrustedNetworkInFencedFrame.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.exemptUrlFromNetworkRevocationForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        67,
        blink.mojom.LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_ParamsSpec.$,
        blink.mojom.LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_ResponseParamsSpec.$,
        this.exemptUrlFromNetworkRevocationForTesting.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sendLegacyTechEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        68,
        blink.mojom.LocalFrameHost_SendLegacyTechEvent_ParamsSpec.$,
        null,
        this.sendLegacyTechEvent.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setFencedFrameAutomaticBeaconReportEventData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        69,
        blink.mojom.LocalFrameHost_SetFencedFrameAutomaticBeaconReportEventData_ParamsSpec.$,
        null,
        this.setFencedFrameAutomaticBeaconReportEventData.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sendPrivateAggregationRequestsForFencedFrameEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        70,
        blink.mojom.LocalFrameHost_SendPrivateAggregationRequestsForFencedFrameEvent_ParamsSpec.$,
        null,
        this.sendPrivateAggregationRequestsForFencedFrameEvent.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createFencedFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        71,
        blink.mojom.LocalFrameHost_CreateFencedFrame_ParamsSpec.$,
        null,
        this.createFencedFrame.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.forwardFencedFrameEventAndUserActivationToEmbedder =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        72,
        blink.mojom.LocalFrameHost_ForwardFencedFrameEventAndUserActivationToEmbedder_ParamsSpec.$,
        null,
        this.forwardFencedFrameEventAndUserActivationToEmbedder.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onViewTransitionOptInChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        73,
        blink.mojom.LocalFrameHost_OnViewTransitionOptInChanged_ParamsSpec.$,
        null,
        this.onViewTransitionOptInChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startDragging =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        74,
        blink.mojom.LocalFrameHost_StartDragging_ParamsSpec.$,
        null,
        this.startDragging.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.issueKeepAliveHandle =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        75,
        blink.mojom.LocalFrameHost_IssueKeepAliveHandle_ParamsSpec.$,
        null,
        this.issueKeepAliveHandle.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyStorageAccessed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        76,
        blink.mojom.LocalFrameHost_NotifyStorageAccessed_ParamsSpec.$,
        null,
        this.notifyStorageAccessed.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.recordWindowProxyUsageMetrics =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        77,
        blink.mojom.LocalFrameHost_RecordWindowProxyUsageMetrics_ParamsSpec.$,
        null,
        this.recordWindowProxyUsageMetrics.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyDocumentInteractive =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        78,
        blink.mojom.LocalFrameHost_NotifyDocumentInteractive_ParamsSpec.$,
        null,
        this.notifyDocumentInteractive.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setStorageAccessApiStatus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        79,
        blink.mojom.LocalFrameHost_SetStorageAccessApiStatus_ParamsSpec.$,
        null,
        this.setStorageAccessApiStatus.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.initializeCrashReportStorage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        80,
        blink.mojom.LocalFrameHost_InitializeCrashReportStorage_ParamsSpec.$,
        blink.mojom.LocalFrameHost_InitializeCrashReportStorage_ResponseParamsSpec.$,
        this.initializeCrashReportStorage.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setCrashReportStorageKey =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        81,
        blink.mojom.LocalFrameHost_SetCrashReportStorageKey_ParamsSpec.$,
        blink.mojom.LocalFrameHost_SetCrashReportStorageKey_ResponseParamsSpec.$,
        this.setCrashReportStorageKey.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.removeCrashReportStorageKey =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        82,
        blink.mojom.LocalFrameHost_RemoveCrashReportStorageKey_ParamsSpec.$,
        blink.mojom.LocalFrameHost_RemoveCrashReportStorageKey_ResponseParamsSpec.$,
        this.removeCrashReportStorageKey.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.NonAssociatedLocalFrameHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.NonAssociatedLocalFrameHost.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.NonAssociatedLocalFrameHostInterface }
 */
blink.mojom.NonAssociatedLocalFrameHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.NonAssociatedLocalFrameHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.NonAssociatedLocalFrameHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.NonAssociatedLocalFrameHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!url.mojom.Url> } urls
   */

  maybeStartOutermostMainFrameNavigation(
      urls) {
    this.proxy.sendMessage(
        0,
        blink.mojom.NonAssociatedLocalFrameHost_MaybeStartOutermostMainFrameNavigation_ParamsSpec.$,
        null,
        [
          urls
        ],
        false);
  }
};

/**
 * An object which receives request messages for the NonAssociatedLocalFrameHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.NonAssociatedLocalFrameHostReceiver = class {
  /**
   * @param {!blink.mojom.NonAssociatedLocalFrameHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.NonAssociatedLocalFrameHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.NonAssociatedLocalFrameHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.NonAssociatedLocalFrameHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.NonAssociatedLocalFrameHost_MaybeStartOutermostMainFrameNavigation_ParamsSpec.$,
        null,
        impl.maybeStartOutermostMainFrameNavigation.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.NonAssociatedLocalFrameHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.NonAssociatedLocalFrameHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.NonAssociatedLocalFrameHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.NonAssociatedLocalFrameHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the NonAssociatedLocalFrameHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.NonAssociatedLocalFrameHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.NonAssociatedLocalFrameHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.NonAssociatedLocalFrameHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.maybeStartOutermostMainFrameNavigation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.NonAssociatedLocalFrameHost_MaybeStartOutermostMainFrameNavigation_ParamsSpec.$,
        null,
        this.maybeStartOutermostMainFrameNavigation.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.LocalFramePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.LocalFrame.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.LocalFrameInterface }
 */
blink.mojom.LocalFrameRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.LocalFramePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.LocalFramePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.LocalFramePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } maxLength
   * @return {!Promise<{
        content: !mojoBase.mojom.String16,
        startOffset: !number,
        endOffset: !number,
   *  }>}
   */

  getTextSurroundingSelection(
      maxLength) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.LocalFrame_GetTextSurroundingSelection_ParamsSpec.$,
        blink.mojom.LocalFrame_GetTextSurroundingSelection_ResponseParamsSpec.$,
        [
          maxLength
        ],
        false);
  }

  
  /**
   * @param { !string } id
   * @param { !string } message
   * @param { ?blink.mojom.FrameToken } childFrameToken
   */

  sendInterventionReport(
      id,
      message,
      childFrameToken) {
    this.proxy.sendMessage(
        1,
        blink.mojom.LocalFrame_SendInterventionReport_ParamsSpec.$,
        null,
        [
          id,
          message,
          childFrameToken
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FrameOwnerProperties } properties
   */

  setFrameOwnerProperties(
      properties) {
    this.proxy.sendMessage(
        2,
        blink.mojom.LocalFrame_SetFrameOwnerProperties_ParamsSpec.$,
        null,
        [
          properties
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.UserActivationNotificationType } notificationType
   */

  notifyUserActivation(
      notificationType) {
    this.proxy.sendMessage(
        3,
        blink.mojom.LocalFrame_NotifyUserActivation_ParamsSpec.$,
        null,
        [
          notificationType
        ],
        false);
  }

  
  /**
   * @param { !gfx.mojom.Rect } keyboardRect
   */

  notifyVirtualKeyboardOverlayRect(
      keyboardRect) {
    this.proxy.sendMessage(
        4,
        blink.mojom.LocalFrame_NotifyVirtualKeyboardOverlayRect_ParamsSpec.$,
        null,
        [
          keyboardRect
        ],
        false);
  }

  
  /**
   * @param { !number } nodeID
   */

  showInterestInElement(
      nodeID) {
    this.proxy.sendMessage(
        5,
        blink.mojom.LocalFrame_ShowInterestInElement_ParamsSpec.$,
        null,
        [
          nodeID
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.ConsoleMessageLevel } level
   * @param { !string } message
   * @param { !boolean } discardDuplicates
   */

  addMessageToConsole(
      level,
      message,
      discardDuplicates) {
    this.proxy.sendMessage(
        6,
        blink.mojom.LocalFrame_AddMessageToConsole_ParamsSpec.$,
        null,
        [
          level,
          message,
          discardDuplicates
        ],
        false);
  }

  
  /**
   */

  swapInImmediately() {
    this.proxy.sendMessage(
        7,
        blink.mojom.LocalFrame_SwapInImmediately_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  checkCompleted() {
    this.proxy.sendMessage(
        8,
        blink.mojom.LocalFrame_CheckCompleted_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  stopLoading() {
    this.proxy.sendMessage(
        9,
        blink.mojom.LocalFrame_StopLoading_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } collapsed
   */

  collapse(
      collapsed) {
    this.proxy.sendMessage(
        10,
        blink.mojom.LocalFrame_Collapse_ParamsSpec.$,
        null,
        [
          collapsed
        ],
        false);
  }

  
  /**
   */

  enableViewSourceMode() {
    this.proxy.sendMessage(
        11,
        blink.mojom.LocalFrame_EnableViewSourceMode_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  focus() {
    this.proxy.sendMessage(
        12,
        blink.mojom.LocalFrame_Focus_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  clearFocusedElement() {
    this.proxy.sendMessage(
        13,
        blink.mojom.LocalFrame_ClearFocusedElement_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !gfx.mojom.Point } windowPoint
   */

  copyImageAt(
      windowPoint) {
    this.proxy.sendMessage(
        14,
        blink.mojom.LocalFrame_CopyImageAt_ParamsSpec.$,
        null,
        [
          windowPoint
        ],
        false);
  }

  
  /**
   * @param { !gfx.mojom.Point } windowPoint
   */

  saveImageAt(
      windowPoint) {
    this.proxy.sendMessage(
        15,
        blink.mojom.LocalFrame_SaveImageAt_ParamsSpec.$,
        null,
        [
          windowPoint
        ],
        false);
  }

  
  /**
   * @param { !Array<!blink.mojom.WebFeature> } features
   */

  reportBlinkFeatureUsage(
      features) {
    this.proxy.sendMessage(
        16,
        blink.mojom.LocalFrame_ReportBlinkFeatureUsage_ParamsSpec.$,
        null,
        [
          features
        ],
        false);
  }

  
  /**
   */

  renderFallbackContent() {
    this.proxy.sendMessage(
        17,
        blink.mojom.LocalFrame_RenderFallbackContent_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } isReload
   * @return {!Promise<{
        proceed: !boolean,
        beforeUnloadStartTime: !mojoBase.mojom.TimeTicks,
        beforeUnloadEndTime: !mojoBase.mojom.TimeTicks,
   *  }>}
   */

  beforeUnload(
      isReload) {
    return this.proxy.sendMessage(
        18,
        blink.mojom.LocalFrame_BeforeUnload_ParamsSpec.$,
        blink.mojom.LocalFrame_BeforeUnload_ResponseParamsSpec.$,
        [
          isReload
        ],
        false);
  }

  
  /**
   * @param { !gfx.mojom.Point } location
   * @param { !blink.mojom.MediaPlayerAction } action
   */

  mediaPlayerActionAt(
      location,
      action) {
    this.proxy.sendMessage(
        19,
        blink.mojom.LocalFrame_MediaPlayerActionAt_ParamsSpec.$,
        null,
        [
          location,
          action
        ],
        false);
  }

  
  /**
   * @param { !gfx.mojom.Point } location
   * @param { !gfx.mojom.Size } maxSize
   * @param { !number } maxArea
   * @return {!Promise<{
        bitmap: ?skia.mojom.BitmapN32,
        bounds: !gfx.mojom.Rect,
   *  }>}
   */

  requestVideoFrameAtWithBoundsHint(
      location,
      maxSize,
      maxArea) {
    return this.proxy.sendMessage(
        20,
        blink.mojom.LocalFrame_RequestVideoFrameAtWithBoundsHint_ParamsSpec.$,
        blink.mojom.LocalFrame_RequestVideoFrameAtWithBoundsHint_ResponseParamsSpec.$,
        [
          location,
          maxSize,
          maxArea
        ],
        false);
  }

  
  /**
   * @param { !gfx.mojom.Point } location
   * @param { !blink.mojom.PluginActionType } action
   */

  pluginActionAt(
      location,
      action) {
    this.proxy.sendMessage(
        21,
        blink.mojom.LocalFrame_PluginActionAt_ParamsSpec.$,
        null,
        [
          location,
          action
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FocusType } focusType
   * @param { ?blink.mojom.RemoteFrameToken } sourceFrameToken
   */

  advanceFocusInFrame(
      focusType,
      sourceFrameToken) {
    this.proxy.sendMessage(
        22,
        blink.mojom.LocalFrame_AdvanceFocusInFrame_ParamsSpec.$,
        null,
        [
          focusType,
          sourceFrameToken
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FocusType } focusType
   */

  advanceFocusForIME(
      focusType) {
    this.proxy.sendMessage(
        23,
        blink.mojom.LocalFrame_AdvanceFocusForIME_ParamsSpec.$,
        null,
        [
          focusType
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.CSPViolation } violation
   */

  reportContentSecurityPolicyViolation(
      violation) {
    this.proxy.sendMessage(
        24,
        blink.mojom.LocalFrame_ReportContentSecurityPolicyViolation_ParamsSpec.$,
        null,
        [
          violation
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FramePolicy } framePolicy
   */

  didUpdateFramePolicy(
      framePolicy) {
    this.proxy.sendMessage(
        25,
        blink.mojom.LocalFrame_DidUpdateFramePolicy_ParamsSpec.$,
        null,
        [
          framePolicy
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FrameVisibility } visibility
   */

  onFrameVisibilityChanged(
      visibility) {
    this.proxy.sendMessage(
        26,
        blink.mojom.LocalFrame_OnFrameVisibilityChanged_ParamsSpec.$,
        null,
        [
          visibility
        ],
        false);
  }

  
  /**
   * @param { ?blink.mojom.RemoteFrameToken } sourceFrameToken
   * @param { !mojoBase.mojom.String16 } sourceOrigin
   * @param { !mojoBase.mojom.String16 } targetOrigin
   * @param { !blink.mojom.TransferableMessage } message
   */

  postMessageEvent(
      sourceFrameToken,
      sourceOrigin,
      targetOrigin,
      message) {
    this.proxy.sendMessage(
        27,
        blink.mojom.LocalFrame_PostMessageEvent_ParamsSpec.$,
        null,
        [
          sourceFrameToken,
          sourceOrigin,
          targetOrigin,
          message
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.String16 } objectName
   * @param { !mojoBase.mojom.String16 } methodName
   * @param { !mojoBase.mojom.ListValue } arguments_
   * @param { !boolean } wantsResult
   * @return {!Promise<{
        result: !mojoBase.mojom.Value,
   *  }>}
   */

  javaScriptMethodExecuteRequest(
      objectName,
      methodName,
      arguments_,
      wantsResult) {
    return this.proxy.sendMessage(
        28,
        blink.mojom.LocalFrame_JavaScriptMethodExecuteRequest_ParamsSpec.$,
        blink.mojom.LocalFrame_JavaScriptMethodExecuteRequest_ResponseParamsSpec.$,
        [
          objectName,
          methodName,
          arguments_,
          wantsResult
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.BigString16 } javascript
   * @param { !boolean } wantsResult
   * @return {!Promise<{
        result: !mojoBase.mojom.Value,
   *  }>}
   */

  javaScriptExecuteRequest(
      javascript,
      wantsResult) {
    return this.proxy.sendMessage(
        29,
        blink.mojom.LocalFrame_JavaScriptExecuteRequest_ParamsSpec.$,
        blink.mojom.LocalFrame_JavaScriptExecuteRequest_ResponseParamsSpec.$,
        [
          javascript,
          wantsResult
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.BigString16 } javascript
   * @param { !boolean } hasUserGesture
   * @param { !boolean } resolvePromises
   * @param { !boolean } honorJsContentSettings
   * @param { !number } worldId
   * @return {!Promise<{
        resultType: !blink.mojom.JavaScriptExecutionResultType,
        result: !mojoBase.mojom.Value,
   *  }>}
   */

  javaScriptExecuteRequestForTests(
      javascript,
      hasUserGesture,
      resolvePromises,
      honorJsContentSettings,
      worldId) {
    return this.proxy.sendMessage(
        30,
        blink.mojom.LocalFrame_JavaScriptExecuteRequestForTests_ParamsSpec.$,
        blink.mojom.LocalFrame_JavaScriptExecuteRequestForTests_ResponseParamsSpec.$,
        [
          javascript,
          hasUserGesture,
          resolvePromises,
          honorJsContentSettings,
          worldId
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.BigString16 } javascript
   * @param { !boolean } wantsResult
   * @param { !number } worldId
   * @return {!Promise<{
        result: !mojoBase.mojom.Value,
   *  }>}
   */

  javaScriptExecuteRequestInIsolatedWorld(
      javascript,
      wantsResult,
      worldId) {
    return this.proxy.sendMessage(
        31,
        blink.mojom.LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ParamsSpec.$,
        blink.mojom.LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ResponseParamsSpec.$,
        [
          javascript,
          wantsResult,
          worldId
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.BigString16 } javascript
   * @param { !number } worldId
   * @return {!Promise<{
        result: !mojoBase.mojom.Value,
   *  }>}
   */

  javaScriptAwaitPromiseInIsolatedWorld(
      javascript,
      worldId) {
    return this.proxy.sendMessage(
        32,
        blink.mojom.LocalFrame_JavaScriptAwaitPromiseInIsolatedWorld_ParamsSpec.$,
        blink.mojom.LocalFrame_JavaScriptAwaitPromiseInIsolatedWorld_ResponseParamsSpec.$,
        [
          javascript,
          worldId
        ],
        false);
  }

  
  /**
   * @param { !gfx.mojom.Point } location
   */

  getCharacterIndexAtPoint(
      location) {
    this.proxy.sendMessage(
        33,
        blink.mojom.LocalFrame_GetCharacterIndexAtPoint_ParamsSpec.$,
        null,
        [
          location
        ],
        false);
  }

  
  /**
   * @param { !gfx.mojom.Range } range
   */

  getFirstRectForRange(
      range) {
    this.proxy.sendMessage(
        34,
        blink.mojom.LocalFrame_GetFirstRectForRange_ParamsSpec.$,
        null,
        [
          range
        ],
        false);
  }

  
  /**
   * @param { !gfx.mojom.Range } range
   * @return {!Promise<{
        string: ?ui.mojom.AttributedString,
        baselinePoint: !gfx.mojom.Point,
   *  }>}
   */

  getStringForRange(
      range) {
    return this.proxy.sendMessage(
        35,
        blink.mojom.LocalFrame_GetStringForRange_ParamsSpec.$,
        blink.mojom.LocalFrame_GetStringForRange_ResponseParamsSpec.$,
        [
          range
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.ReportingObserverPendingReceiver } receiver
   */

  bindReportingObserver(
      receiver) {
    this.proxy.sendMessage(
        36,
        blink.mojom.LocalFrame_BindReportingObserver_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }

  
  /**
   * @param { ?blink.mojom.FrameToken } openerFrameToken
   */

  updateOpener(
      openerFrameToken) {
    this.proxy.sendMessage(
        37,
        blink.mojom.LocalFrame_UpdateOpener_ParamsSpec.$,
        null,
        [
          openerFrameToken
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        reply: ?blink.mojom.GetSavableResourceLinksReply,
   *  }>}
   */

  getSavableResourceLinks() {
    return this.proxy.sendMessage(
        38,
        blink.mojom.LocalFrame_GetSavableResourceLinks_ParamsSpec.$,
        blink.mojom.LocalFrame_GetSavableResourceLinks_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } mainResourceUrl
   * @param { !url.mojom.Url } mixedContentUrl
   * @param { !blink.mojom.RequestContextType } requestContext
   * @param { !boolean } wasAllowed
   * @param { !url.mojom.Url } urlBeforeRedirects
   * @param { !boolean } hadRedirect
   * @param { ?network.mojom.SourceLocation } sourceLocation
   */

  mixedContentFound(
      mainResourceUrl,
      mixedContentUrl,
      requestContext,
      wasAllowed,
      urlBeforeRedirects,
      hadRedirect,
      sourceLocation) {
    this.proxy.sendMessage(
        39,
        blink.mojom.LocalFrame_MixedContentFound_ParamsSpec.$,
        null,
        [
          mainResourceUrl,
          mixedContentUrl,
          requestContext,
          wasAllowed,
          urlBeforeRedirects,
          hadRedirect,
          sourceLocation
        ],
        false);
  }

  
  /**
   * @param { !Object } agentHost
   * @param { !Object } agent
   */

  bindDevToolsAgent(
      agentHost,
      agent) {
    this.proxy.sendMessage(
        40,
        blink.mojom.LocalFrame_BindDevToolsAgent_ParamsSpec.$,
        null,
        [
          agentHost,
          agent
        ],
        false);
  }

  
  /**
   * @param { !bigint } charCountGoal
   * @return {!Promise<{
        annotatedText: !mojoBase.mojom.String16,
   *  }>}
   */

  extractAnnotatedText(
      charCountGoal) {
    return this.proxy.sendMessage(
        41,
        blink.mojom.LocalFrame_ExtractAnnotatedText_ParamsSpec.$,
        blink.mojom.LocalFrame_ExtractAnnotatedText_ResponseParamsSpec.$,
        [
          charCountGoal
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        serializedDom: !mojoBase.mojom.String16,
   *  }>}
   */

  extractSerializedDom() {
    return this.proxy.sendMessage(
        42,
        blink.mojom.LocalFrame_ExtractSerializedDom_ParamsSpec.$,
        blink.mojom.LocalFrame_ExtractSerializedDom_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } id
   * @return {!Promise<{
        info: ?blink.mojom.SerializedDomElementInfo,
   *  }>}
   */

  extractSerializedDomElementInfo(
      id) {
    return this.proxy.sendMessage(
        43,
        blink.mojom.LocalFrame_ExtractSerializedDomElementInfo_ParamsSpec.$,
        blink.mojom.LocalFrame_ExtractSerializedDomElementInfo_ResponseParamsSpec.$,
        [
          id
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } url
   */

  handleRendererDebugURL(
      url) {
    this.proxy.sendMessage(
        44,
        blink.mojom.LocalFrame_HandleRendererDebugURL_ParamsSpec.$,
        null,
        [
          url
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        canonicalUrl: ?url.mojom.Url,
   *  }>}
   */

  getCanonicalUrlForSharing() {
    return this.proxy.sendMessage(
        45,
        blink.mojom.LocalFrame_GetCanonicalUrlForSharing_ParamsSpec.$,
        blink.mojom.LocalFrame_GetCanonicalUrlForSharing_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        metadata: !blink.mojom.OpenGraphMetadata,
   *  }>}
   */

  getOpenGraphMetadata() {
    return this.proxy.sendMessage(
        46,
        blink.mojom.LocalFrame_GetOpenGraphMetadata_ParamsSpec.$,
        blink.mojom.LocalFrame_GetOpenGraphMetadata_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.NavigationApiHistoryEntryArrays } entryArrays
   * @param { !blink.mojom.NavigationApiEntryRestoreReason } restoreReason
   */

  setNavigationApiHistoryEntriesForRestore(
      entryArrays,
      restoreReason) {
    this.proxy.sendMessage(
        47,
        blink.mojom.LocalFrame_SetNavigationApiHistoryEntriesForRestore_ParamsSpec.$,
        null,
        [
          entryArrays,
          restoreReason
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } matchedUrl
   * @return {!Promise}
   */

  updatePrerenderURL(
      matchedUrl) {
    return this.proxy.sendMessage(
        48,
        blink.mojom.LocalFrame_UpdatePrerenderURL_ParamsSpec.$,
        blink.mojom.LocalFrame_UpdatePrerenderURL_ResponseParamsSpec.$,
        [
          matchedUrl
        ],
        false);
  }

  
  /**
   * @param { !Array<!string> } keys
   */

  notifyNavigationApiOfDisposedEntries(
      keys) {
    this.proxy.sendMessage(
        49,
        blink.mojom.LocalFrame_NotifyNavigationApiOfDisposedEntries_ParamsSpec.$,
        null,
        [
          keys
        ],
        false);
  }

  
  /**
   * @param { !string } navigationApiKey
   * @param { !blink.mojom.TraverseCancelledReason } reason
   */

  traverseCancelled(
      navigationApiKey,
      reason) {
    this.proxy.sendMessage(
        50,
        blink.mojom.LocalFrame_TraverseCancelled_ParamsSpec.$,
        null,
        [
          navigationApiKey,
          reason
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @param { !mojoBase.mojom.ByteString } pageState
   * @param { !boolean } isBrowserInitiated
   */

  dispatchNavigateEventForCrossDocumentTraversal(
      url,
      pageState,
      isBrowserInitiated) {
    this.proxy.sendMessage(
        51,
        blink.mojom.LocalFrame_DispatchNavigateEventForCrossDocumentTraversal_ParamsSpec.$,
        null,
        [
          url,
          pageState,
          isBrowserInitiated
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.ViewTransitionToken } transitionToken
   * @param { !blink.mojom.PageSwapEventParams } pageSwapEventParams
   * @return {!Promise<{
        viewTransitionState: !blink.mojom.ViewTransitionState,
   *  }>}
   */

  snapshotDocumentForViewTransition(
      transitionToken,
      pageSwapEventParams) {
    return this.proxy.sendMessage(
        52,
        blink.mojom.LocalFrame_SnapshotDocumentForViewTransition_ParamsSpec.$,
        blink.mojom.LocalFrame_SnapshotDocumentForViewTransition_ResponseParamsSpec.$,
        [
          transitionToken,
          pageSwapEventParams
        ],
        false);
  }

  
  /**
   */

  notifyViewTransitionAbortedToOldDocument() {
    this.proxy.sendMessage(
        53,
        blink.mojom.LocalFrame_NotifyViewTransitionAbortedToOldDocument_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { ?blink.mojom.PageSwapEventParams } pageSwapEventParams
   */

  dispatchPageSwap(
      pageSwapEventParams) {
    this.proxy.sendMessage(
        54,
        blink.mojom.LocalFrame_DispatchPageSwap_ParamsSpec.$,
        null,
        [
          pageSwapEventParams
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FrameToken } subframeToken
   * @param { !url.mojom.Url } initialUrl
   * @param { !mojoBase.mojom.TimeTicks } startTime
   * @param { !mojoBase.mojom.TimeTicks } redirectTime
   * @param { !mojoBase.mojom.TimeTicks } requestStart
   * @param { !mojoBase.mojom.TimeTicks } responseStart
   * @param { !number } responseCode
   * @param { !string } mimeType
   * @param { !network.mojom.LoadTimingInfo } loadTimingInfo
   * @param { !network.mojom.ConnectionInfo } connectionInfo
   * @param { !string } alpnNegotiatedProtocol
   * @param { !boolean } isSecureTransport
   * @param { !boolean } isValidated
   * @param { !string } normalizedServerTiming
   * @param { !network.mojom.URLLoaderCompletionStatus } completionStatus
   */

  addResourceTimingEntryForFailedSubframeNavigation(
      subframeToken,
      initialUrl,
      startTime,
      redirectTime,
      requestStart,
      responseStart,
      responseCode,
      mimeType,
      loadTimingInfo,
      connectionInfo,
      alpnNegotiatedProtocol,
      isSecureTransport,
      isValidated,
      normalizedServerTiming,
      completionStatus) {
    this.proxy.sendMessage(
        55,
        blink.mojom.LocalFrame_AddResourceTimingEntryForFailedSubframeNavigation_ParamsSpec.$,
        null,
        [
          subframeToken,
          initialUrl,
          startTime,
          redirectTime,
          requestStart,
          responseStart,
          responseCode,
          mimeType,
          loadTimingInfo,
          connectionInfo,
          alpnNegotiatedProtocol,
          isSecureTransport,
          isValidated,
          normalizedServerTiming,
          completionStatus
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        scrollPosition: !gfx.mojom.Point,
   *  }>}
   */

  getScrollPosition() {
    return this.proxy.sendMessage(
        56,
        blink.mojom.LocalFrame_GetScrollPosition_ParamsSpec.$,
        blink.mojom.LocalFrame_GetScrollPosition_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the LocalFrame
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.LocalFrameReceiver = class {
  /**
   * @param {!blink.mojom.LocalFrameInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.LocalFrameRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.LocalFrameRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.LocalFrameRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.LocalFrame_GetTextSurroundingSelection_ParamsSpec.$,
        blink.mojom.LocalFrame_GetTextSurroundingSelection_ResponseParamsSpec.$,
        impl.getTextSurroundingSelection.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.LocalFrame_SendInterventionReport_ParamsSpec.$,
        null,
        impl.sendInterventionReport.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.LocalFrame_SetFrameOwnerProperties_ParamsSpec.$,
        null,
        impl.setFrameOwnerProperties.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.LocalFrame_NotifyUserActivation_ParamsSpec.$,
        null,
        impl.notifyUserActivation.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.LocalFrame_NotifyVirtualKeyboardOverlayRect_ParamsSpec.$,
        null,
        impl.notifyVirtualKeyboardOverlayRect.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.LocalFrame_ShowInterestInElement_ParamsSpec.$,
        null,
        impl.showInterestInElement.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        blink.mojom.LocalFrame_AddMessageToConsole_ParamsSpec.$,
        null,
        impl.addMessageToConsole.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        blink.mojom.LocalFrame_SwapInImmediately_ParamsSpec.$,
        null,
        impl.swapInImmediately.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        blink.mojom.LocalFrame_CheckCompleted_ParamsSpec.$,
        null,
        impl.checkCompleted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        blink.mojom.LocalFrame_StopLoading_ParamsSpec.$,
        null,
        impl.stopLoading.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        blink.mojom.LocalFrame_Collapse_ParamsSpec.$,
        null,
        impl.collapse.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        blink.mojom.LocalFrame_EnableViewSourceMode_ParamsSpec.$,
        null,
        impl.enableViewSourceMode.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        blink.mojom.LocalFrame_Focus_ParamsSpec.$,
        null,
        impl.focus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        blink.mojom.LocalFrame_ClearFocusedElement_ParamsSpec.$,
        null,
        impl.clearFocusedElement.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        blink.mojom.LocalFrame_CopyImageAt_ParamsSpec.$,
        null,
        impl.copyImageAt.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        blink.mojom.LocalFrame_SaveImageAt_ParamsSpec.$,
        null,
        impl.saveImageAt.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        blink.mojom.LocalFrame_ReportBlinkFeatureUsage_ParamsSpec.$,
        null,
        impl.reportBlinkFeatureUsage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        blink.mojom.LocalFrame_RenderFallbackContent_ParamsSpec.$,
        null,
        impl.renderFallbackContent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        blink.mojom.LocalFrame_BeforeUnload_ParamsSpec.$,
        blink.mojom.LocalFrame_BeforeUnload_ResponseParamsSpec.$,
        impl.beforeUnload.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        19,
        blink.mojom.LocalFrame_MediaPlayerActionAt_ParamsSpec.$,
        null,
        impl.mediaPlayerActionAt.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        20,
        blink.mojom.LocalFrame_RequestVideoFrameAtWithBoundsHint_ParamsSpec.$,
        blink.mojom.LocalFrame_RequestVideoFrameAtWithBoundsHint_ResponseParamsSpec.$,
        impl.requestVideoFrameAtWithBoundsHint.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        21,
        blink.mojom.LocalFrame_PluginActionAt_ParamsSpec.$,
        null,
        impl.pluginActionAt.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        22,
        blink.mojom.LocalFrame_AdvanceFocusInFrame_ParamsSpec.$,
        null,
        impl.advanceFocusInFrame.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        23,
        blink.mojom.LocalFrame_AdvanceFocusForIME_ParamsSpec.$,
        null,
        impl.advanceFocusForIME.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        24,
        blink.mojom.LocalFrame_ReportContentSecurityPolicyViolation_ParamsSpec.$,
        null,
        impl.reportContentSecurityPolicyViolation.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        25,
        blink.mojom.LocalFrame_DidUpdateFramePolicy_ParamsSpec.$,
        null,
        impl.didUpdateFramePolicy.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        26,
        blink.mojom.LocalFrame_OnFrameVisibilityChanged_ParamsSpec.$,
        null,
        impl.onFrameVisibilityChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        27,
        blink.mojom.LocalFrame_PostMessageEvent_ParamsSpec.$,
        null,
        impl.postMessageEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        28,
        blink.mojom.LocalFrame_JavaScriptMethodExecuteRequest_ParamsSpec.$,
        blink.mojom.LocalFrame_JavaScriptMethodExecuteRequest_ResponseParamsSpec.$,
        impl.javaScriptMethodExecuteRequest.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        29,
        blink.mojom.LocalFrame_JavaScriptExecuteRequest_ParamsSpec.$,
        blink.mojom.LocalFrame_JavaScriptExecuteRequest_ResponseParamsSpec.$,
        impl.javaScriptExecuteRequest.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        30,
        blink.mojom.LocalFrame_JavaScriptExecuteRequestForTests_ParamsSpec.$,
        blink.mojom.LocalFrame_JavaScriptExecuteRequestForTests_ResponseParamsSpec.$,
        impl.javaScriptExecuteRequestForTests.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        31,
        blink.mojom.LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ParamsSpec.$,
        blink.mojom.LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ResponseParamsSpec.$,
        impl.javaScriptExecuteRequestInIsolatedWorld.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        32,
        blink.mojom.LocalFrame_JavaScriptAwaitPromiseInIsolatedWorld_ParamsSpec.$,
        blink.mojom.LocalFrame_JavaScriptAwaitPromiseInIsolatedWorld_ResponseParamsSpec.$,
        impl.javaScriptAwaitPromiseInIsolatedWorld.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        33,
        blink.mojom.LocalFrame_GetCharacterIndexAtPoint_ParamsSpec.$,
        null,
        impl.getCharacterIndexAtPoint.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        34,
        blink.mojom.LocalFrame_GetFirstRectForRange_ParamsSpec.$,
        null,
        impl.getFirstRectForRange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        35,
        blink.mojom.LocalFrame_GetStringForRange_ParamsSpec.$,
        blink.mojom.LocalFrame_GetStringForRange_ResponseParamsSpec.$,
        impl.getStringForRange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        36,
        blink.mojom.LocalFrame_BindReportingObserver_ParamsSpec.$,
        null,
        impl.bindReportingObserver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        37,
        blink.mojom.LocalFrame_UpdateOpener_ParamsSpec.$,
        null,
        impl.updateOpener.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        38,
        blink.mojom.LocalFrame_GetSavableResourceLinks_ParamsSpec.$,
        blink.mojom.LocalFrame_GetSavableResourceLinks_ResponseParamsSpec.$,
        impl.getSavableResourceLinks.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        39,
        blink.mojom.LocalFrame_MixedContentFound_ParamsSpec.$,
        null,
        impl.mixedContentFound.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        40,
        blink.mojom.LocalFrame_BindDevToolsAgent_ParamsSpec.$,
        null,
        impl.bindDevToolsAgent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        41,
        blink.mojom.LocalFrame_ExtractAnnotatedText_ParamsSpec.$,
        blink.mojom.LocalFrame_ExtractAnnotatedText_ResponseParamsSpec.$,
        impl.extractAnnotatedText.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        42,
        blink.mojom.LocalFrame_ExtractSerializedDom_ParamsSpec.$,
        blink.mojom.LocalFrame_ExtractSerializedDom_ResponseParamsSpec.$,
        impl.extractSerializedDom.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        43,
        blink.mojom.LocalFrame_ExtractSerializedDomElementInfo_ParamsSpec.$,
        blink.mojom.LocalFrame_ExtractSerializedDomElementInfo_ResponseParamsSpec.$,
        impl.extractSerializedDomElementInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        44,
        blink.mojom.LocalFrame_HandleRendererDebugURL_ParamsSpec.$,
        null,
        impl.handleRendererDebugURL.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        45,
        blink.mojom.LocalFrame_GetCanonicalUrlForSharing_ParamsSpec.$,
        blink.mojom.LocalFrame_GetCanonicalUrlForSharing_ResponseParamsSpec.$,
        impl.getCanonicalUrlForSharing.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        46,
        blink.mojom.LocalFrame_GetOpenGraphMetadata_ParamsSpec.$,
        blink.mojom.LocalFrame_GetOpenGraphMetadata_ResponseParamsSpec.$,
        impl.getOpenGraphMetadata.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        47,
        blink.mojom.LocalFrame_SetNavigationApiHistoryEntriesForRestore_ParamsSpec.$,
        null,
        impl.setNavigationApiHistoryEntriesForRestore.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        48,
        blink.mojom.LocalFrame_UpdatePrerenderURL_ParamsSpec.$,
        blink.mojom.LocalFrame_UpdatePrerenderURL_ResponseParamsSpec.$,
        impl.updatePrerenderURL.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        49,
        blink.mojom.LocalFrame_NotifyNavigationApiOfDisposedEntries_ParamsSpec.$,
        null,
        impl.notifyNavigationApiOfDisposedEntries.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        50,
        blink.mojom.LocalFrame_TraverseCancelled_ParamsSpec.$,
        null,
        impl.traverseCancelled.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        51,
        blink.mojom.LocalFrame_DispatchNavigateEventForCrossDocumentTraversal_ParamsSpec.$,
        null,
        impl.dispatchNavigateEventForCrossDocumentTraversal.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        52,
        blink.mojom.LocalFrame_SnapshotDocumentForViewTransition_ParamsSpec.$,
        blink.mojom.LocalFrame_SnapshotDocumentForViewTransition_ResponseParamsSpec.$,
        impl.snapshotDocumentForViewTransition.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        53,
        blink.mojom.LocalFrame_NotifyViewTransitionAbortedToOldDocument_ParamsSpec.$,
        null,
        impl.notifyViewTransitionAbortedToOldDocument.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        54,
        blink.mojom.LocalFrame_DispatchPageSwap_ParamsSpec.$,
        null,
        impl.dispatchPageSwap.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        55,
        blink.mojom.LocalFrame_AddResourceTimingEntryForFailedSubframeNavigation_ParamsSpec.$,
        null,
        impl.addResourceTimingEntryForFailedSubframeNavigation.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        56,
        blink.mojom.LocalFrame_GetScrollPosition_ParamsSpec.$,
        blink.mojom.LocalFrame_GetScrollPosition_ResponseParamsSpec.$,
        impl.getScrollPosition.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.LocalFrame = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.LocalFrame";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.LocalFrameRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.LocalFrameRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the LocalFrame
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.LocalFrameCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.LocalFrameRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.LocalFrameRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getTextSurroundingSelection =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.LocalFrame_GetTextSurroundingSelection_ParamsSpec.$,
        blink.mojom.LocalFrame_GetTextSurroundingSelection_ResponseParamsSpec.$,
        this.getTextSurroundingSelection.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sendInterventionReport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.LocalFrame_SendInterventionReport_ParamsSpec.$,
        null,
        this.sendInterventionReport.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setFrameOwnerProperties =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.LocalFrame_SetFrameOwnerProperties_ParamsSpec.$,
        null,
        this.setFrameOwnerProperties.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyUserActivation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.LocalFrame_NotifyUserActivation_ParamsSpec.$,
        null,
        this.notifyUserActivation.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyVirtualKeyboardOverlayRect =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.LocalFrame_NotifyVirtualKeyboardOverlayRect_ParamsSpec.$,
        null,
        this.notifyVirtualKeyboardOverlayRect.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.showInterestInElement =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.LocalFrame_ShowInterestInElement_ParamsSpec.$,
        null,
        this.showInterestInElement.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addMessageToConsole =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        blink.mojom.LocalFrame_AddMessageToConsole_ParamsSpec.$,
        null,
        this.addMessageToConsole.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.swapInImmediately =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        blink.mojom.LocalFrame_SwapInImmediately_ParamsSpec.$,
        null,
        this.swapInImmediately.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.checkCompleted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        blink.mojom.LocalFrame_CheckCompleted_ParamsSpec.$,
        null,
        this.checkCompleted.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.stopLoading =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        blink.mojom.LocalFrame_StopLoading_ParamsSpec.$,
        null,
        this.stopLoading.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.collapse =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        blink.mojom.LocalFrame_Collapse_ParamsSpec.$,
        null,
        this.collapse.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enableViewSourceMode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        blink.mojom.LocalFrame_EnableViewSourceMode_ParamsSpec.$,
        null,
        this.enableViewSourceMode.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.focus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        blink.mojom.LocalFrame_Focus_ParamsSpec.$,
        null,
        this.focus.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearFocusedElement =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        blink.mojom.LocalFrame_ClearFocusedElement_ParamsSpec.$,
        null,
        this.clearFocusedElement.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.copyImageAt =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        blink.mojom.LocalFrame_CopyImageAt_ParamsSpec.$,
        null,
        this.copyImageAt.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.saveImageAt =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        blink.mojom.LocalFrame_SaveImageAt_ParamsSpec.$,
        null,
        this.saveImageAt.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reportBlinkFeatureUsage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        blink.mojom.LocalFrame_ReportBlinkFeatureUsage_ParamsSpec.$,
        null,
        this.reportBlinkFeatureUsage.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.renderFallbackContent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        blink.mojom.LocalFrame_RenderFallbackContent_ParamsSpec.$,
        null,
        this.renderFallbackContent.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.beforeUnload =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        blink.mojom.LocalFrame_BeforeUnload_ParamsSpec.$,
        blink.mojom.LocalFrame_BeforeUnload_ResponseParamsSpec.$,
        this.beforeUnload.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.mediaPlayerActionAt =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        19,
        blink.mojom.LocalFrame_MediaPlayerActionAt_ParamsSpec.$,
        null,
        this.mediaPlayerActionAt.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestVideoFrameAtWithBoundsHint =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        20,
        blink.mojom.LocalFrame_RequestVideoFrameAtWithBoundsHint_ParamsSpec.$,
        blink.mojom.LocalFrame_RequestVideoFrameAtWithBoundsHint_ResponseParamsSpec.$,
        this.requestVideoFrameAtWithBoundsHint.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.pluginActionAt =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        21,
        blink.mojom.LocalFrame_PluginActionAt_ParamsSpec.$,
        null,
        this.pluginActionAt.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.advanceFocusInFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        22,
        blink.mojom.LocalFrame_AdvanceFocusInFrame_ParamsSpec.$,
        null,
        this.advanceFocusInFrame.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.advanceFocusForIME =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        23,
        blink.mojom.LocalFrame_AdvanceFocusForIME_ParamsSpec.$,
        null,
        this.advanceFocusForIME.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reportContentSecurityPolicyViolation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        24,
        blink.mojom.LocalFrame_ReportContentSecurityPolicyViolation_ParamsSpec.$,
        null,
        this.reportContentSecurityPolicyViolation.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didUpdateFramePolicy =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        25,
        blink.mojom.LocalFrame_DidUpdateFramePolicy_ParamsSpec.$,
        null,
        this.didUpdateFramePolicy.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onFrameVisibilityChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        26,
        blink.mojom.LocalFrame_OnFrameVisibilityChanged_ParamsSpec.$,
        null,
        this.onFrameVisibilityChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.postMessageEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        27,
        blink.mojom.LocalFrame_PostMessageEvent_ParamsSpec.$,
        null,
        this.postMessageEvent.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.javaScriptMethodExecuteRequest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        28,
        blink.mojom.LocalFrame_JavaScriptMethodExecuteRequest_ParamsSpec.$,
        blink.mojom.LocalFrame_JavaScriptMethodExecuteRequest_ResponseParamsSpec.$,
        this.javaScriptMethodExecuteRequest.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.javaScriptExecuteRequest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        29,
        blink.mojom.LocalFrame_JavaScriptExecuteRequest_ParamsSpec.$,
        blink.mojom.LocalFrame_JavaScriptExecuteRequest_ResponseParamsSpec.$,
        this.javaScriptExecuteRequest.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.javaScriptExecuteRequestForTests =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        30,
        blink.mojom.LocalFrame_JavaScriptExecuteRequestForTests_ParamsSpec.$,
        blink.mojom.LocalFrame_JavaScriptExecuteRequestForTests_ResponseParamsSpec.$,
        this.javaScriptExecuteRequestForTests.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.javaScriptExecuteRequestInIsolatedWorld =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        31,
        blink.mojom.LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ParamsSpec.$,
        blink.mojom.LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ResponseParamsSpec.$,
        this.javaScriptExecuteRequestInIsolatedWorld.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.javaScriptAwaitPromiseInIsolatedWorld =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        32,
        blink.mojom.LocalFrame_JavaScriptAwaitPromiseInIsolatedWorld_ParamsSpec.$,
        blink.mojom.LocalFrame_JavaScriptAwaitPromiseInIsolatedWorld_ResponseParamsSpec.$,
        this.javaScriptAwaitPromiseInIsolatedWorld.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getCharacterIndexAtPoint =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        33,
        blink.mojom.LocalFrame_GetCharacterIndexAtPoint_ParamsSpec.$,
        null,
        this.getCharacterIndexAtPoint.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getFirstRectForRange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        34,
        blink.mojom.LocalFrame_GetFirstRectForRange_ParamsSpec.$,
        null,
        this.getFirstRectForRange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getStringForRange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        35,
        blink.mojom.LocalFrame_GetStringForRange_ParamsSpec.$,
        blink.mojom.LocalFrame_GetStringForRange_ResponseParamsSpec.$,
        this.getStringForRange.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindReportingObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        36,
        blink.mojom.LocalFrame_BindReportingObserver_ParamsSpec.$,
        null,
        this.bindReportingObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateOpener =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        37,
        blink.mojom.LocalFrame_UpdateOpener_ParamsSpec.$,
        null,
        this.updateOpener.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getSavableResourceLinks =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        38,
        blink.mojom.LocalFrame_GetSavableResourceLinks_ParamsSpec.$,
        blink.mojom.LocalFrame_GetSavableResourceLinks_ResponseParamsSpec.$,
        this.getSavableResourceLinks.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.mixedContentFound =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        39,
        blink.mojom.LocalFrame_MixedContentFound_ParamsSpec.$,
        null,
        this.mixedContentFound.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindDevToolsAgent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        40,
        blink.mojom.LocalFrame_BindDevToolsAgent_ParamsSpec.$,
        null,
        this.bindDevToolsAgent.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.extractAnnotatedText =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        41,
        blink.mojom.LocalFrame_ExtractAnnotatedText_ParamsSpec.$,
        blink.mojom.LocalFrame_ExtractAnnotatedText_ResponseParamsSpec.$,
        this.extractAnnotatedText.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.extractSerializedDom =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        42,
        blink.mojom.LocalFrame_ExtractSerializedDom_ParamsSpec.$,
        blink.mojom.LocalFrame_ExtractSerializedDom_ResponseParamsSpec.$,
        this.extractSerializedDom.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.extractSerializedDomElementInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        43,
        blink.mojom.LocalFrame_ExtractSerializedDomElementInfo_ParamsSpec.$,
        blink.mojom.LocalFrame_ExtractSerializedDomElementInfo_ResponseParamsSpec.$,
        this.extractSerializedDomElementInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.handleRendererDebugURL =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        44,
        blink.mojom.LocalFrame_HandleRendererDebugURL_ParamsSpec.$,
        null,
        this.handleRendererDebugURL.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getCanonicalUrlForSharing =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        45,
        blink.mojom.LocalFrame_GetCanonicalUrlForSharing_ParamsSpec.$,
        blink.mojom.LocalFrame_GetCanonicalUrlForSharing_ResponseParamsSpec.$,
        this.getCanonicalUrlForSharing.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getOpenGraphMetadata =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        46,
        blink.mojom.LocalFrame_GetOpenGraphMetadata_ParamsSpec.$,
        blink.mojom.LocalFrame_GetOpenGraphMetadata_ResponseParamsSpec.$,
        this.getOpenGraphMetadata.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setNavigationApiHistoryEntriesForRestore =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        47,
        blink.mojom.LocalFrame_SetNavigationApiHistoryEntriesForRestore_ParamsSpec.$,
        null,
        this.setNavigationApiHistoryEntriesForRestore.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updatePrerenderURL =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        48,
        blink.mojom.LocalFrame_UpdatePrerenderURL_ParamsSpec.$,
        blink.mojom.LocalFrame_UpdatePrerenderURL_ResponseParamsSpec.$,
        this.updatePrerenderURL.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyNavigationApiOfDisposedEntries =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        49,
        blink.mojom.LocalFrame_NotifyNavigationApiOfDisposedEntries_ParamsSpec.$,
        null,
        this.notifyNavigationApiOfDisposedEntries.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.traverseCancelled =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        50,
        blink.mojom.LocalFrame_TraverseCancelled_ParamsSpec.$,
        null,
        this.traverseCancelled.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchNavigateEventForCrossDocumentTraversal =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        51,
        blink.mojom.LocalFrame_DispatchNavigateEventForCrossDocumentTraversal_ParamsSpec.$,
        null,
        this.dispatchNavigateEventForCrossDocumentTraversal.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.snapshotDocumentForViewTransition =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        52,
        blink.mojom.LocalFrame_SnapshotDocumentForViewTransition_ParamsSpec.$,
        blink.mojom.LocalFrame_SnapshotDocumentForViewTransition_ResponseParamsSpec.$,
        this.snapshotDocumentForViewTransition.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyViewTransitionAbortedToOldDocument =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        53,
        blink.mojom.LocalFrame_NotifyViewTransitionAbortedToOldDocument_ParamsSpec.$,
        null,
        this.notifyViewTransitionAbortedToOldDocument.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchPageSwap =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        54,
        blink.mojom.LocalFrame_DispatchPageSwap_ParamsSpec.$,
        null,
        this.dispatchPageSwap.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addResourceTimingEntryForFailedSubframeNavigation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        55,
        blink.mojom.LocalFrame_AddResourceTimingEntryForFailedSubframeNavigation_ParamsSpec.$,
        null,
        this.addResourceTimingEntryForFailedSubframeNavigation.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getScrollPosition =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        56,
        blink.mojom.LocalFrame_GetScrollPosition_ParamsSpec.$,
        blink.mojom.LocalFrame_GetScrollPosition_ResponseParamsSpec.$,
        this.getScrollPosition.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.LocalMainFramePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.LocalMainFrame.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.LocalMainFrameInterface }
 */
blink.mojom.LocalMainFrameRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.LocalMainFramePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.LocalMainFramePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.LocalMainFramePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !gfx.mojom.Point } point
   * @param { !gfx.mojom.Rect } rect
   */

  animateDoubleTapZoom(
      point,
      rect) {
    this.proxy.sendMessage(
        0,
        blink.mojom.LocalMainFrame_AnimateDoubleTapZoom_ParamsSpec.$,
        null,
        [
          point,
          rect
        ],
        false);
  }

  
  /**
   * @param { !number } scale
   */

  setScaleFactor(
      scale) {
    this.proxy.sendMessage(
        1,
        blink.mojom.LocalMainFrame_SetScaleFactor_ParamsSpec.$,
        null,
        [
          scale
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  closePage() {
    return this.proxy.sendMessage(
        2,
        blink.mojom.LocalMainFrame_ClosePage_ParamsSpec.$,
        blink.mojom.LocalMainFrame_ClosePage_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        fullPageSize: !gfx.mojom.Size,
   *  }>}
   */

  getFullPageSize() {
    return this.proxy.sendMessage(
        3,
        blink.mojom.LocalMainFrame_GetFullPageSize_ParamsSpec.$,
        blink.mojom.LocalMainFrame_GetFullPageSize_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } reverse
   */

  setInitialFocus(
      reverse) {
    this.proxy.sendMessage(
        4,
        blink.mojom.LocalMainFrame_SetInitialFocus_ParamsSpec.$,
        null,
        [
          reverse
        ],
        false);
  }

  
  /**
   */

  enablePreferredSizeChangedMode() {
    this.proxy.sendMessage(
        5,
        blink.mojom.LocalMainFrame_EnablePreferredSizeChangedMode_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !gfx.mojom.Rect } rectInRootFrame
   */

  zoomToFindInPageRect(
      rectInRootFrame) {
    this.proxy.sendMessage(
        6,
        blink.mojom.LocalMainFrame_ZoomToFindInPageRect_ParamsSpec.$,
        null,
        [
          rectInRootFrame
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FrameToken } accessedWindow
   * @param { !network.mojom.CrossOriginOpenerPolicyReporterParams } coopReporterInfo
   */

  installCoopAccessMonitor(
      accessedWindow,
      coopReporterInfo) {
    this.proxy.sendMessage(
        7,
        blink.mojom.LocalMainFrame_InstallCoopAccessMonitor_ParamsSpec.$,
        null,
        [
          accessedWindow,
          coopReporterInfo
        ],
        false);
  }

  
  /**
   * @param { !cc.mojom.BrowserControlsState } constraints
   * @param { !cc.mojom.BrowserControlsState } current
   * @param { !boolean } animate
   * @param { ?cc.mojom.BrowserControlsOffsetTagModifications } offsetTagModifications
   */

  updateBrowserControlsState(
      constraints,
      current,
      animate,
      offsetTagModifications) {
    this.proxy.sendMessage(
        8,
        blink.mojom.LocalMainFrame_UpdateBrowserControlsState_ParamsSpec.$,
        null,
        [
          constraints,
          current,
          animate,
          offsetTagModifications
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.ReadOnlySharedMemoryRegion } data
   */

  setV8CompileHints(
      data) {
    this.proxy.sendMessage(
        9,
        blink.mojom.LocalMainFrame_SetV8CompileHints_ParamsSpec.$,
        null,
        [
          data
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  discard() {
    return this.proxy.sendMessage(
        10,
        blink.mojom.LocalMainFrame_Discard_ParamsSpec.$,
        blink.mojom.LocalMainFrame_Discard_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } randomizedTriggerRate
   * @param { !blink.mojom.ConfidenceLevel } confidence
   */

  finalizeNavigationConfidence(
      randomizedTriggerRate,
      confidence) {
    this.proxy.sendMessage(
        11,
        blink.mojom.LocalMainFrame_FinalizeNavigationConfidence_ParamsSpec.$,
        null,
        [
          randomizedTriggerRate,
          confidence
        ],
        false);
  }
};

/**
 * An object which receives request messages for the LocalMainFrame
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.LocalMainFrameReceiver = class {
  /**
   * @param {!blink.mojom.LocalMainFrameInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.LocalMainFrameRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.LocalMainFrameRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.LocalMainFrameRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.LocalMainFrame_AnimateDoubleTapZoom_ParamsSpec.$,
        null,
        impl.animateDoubleTapZoom.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.LocalMainFrame_SetScaleFactor_ParamsSpec.$,
        null,
        impl.setScaleFactor.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.LocalMainFrame_ClosePage_ParamsSpec.$,
        blink.mojom.LocalMainFrame_ClosePage_ResponseParamsSpec.$,
        impl.closePage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.LocalMainFrame_GetFullPageSize_ParamsSpec.$,
        blink.mojom.LocalMainFrame_GetFullPageSize_ResponseParamsSpec.$,
        impl.getFullPageSize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.LocalMainFrame_SetInitialFocus_ParamsSpec.$,
        null,
        impl.setInitialFocus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.LocalMainFrame_EnablePreferredSizeChangedMode_ParamsSpec.$,
        null,
        impl.enablePreferredSizeChangedMode.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        blink.mojom.LocalMainFrame_ZoomToFindInPageRect_ParamsSpec.$,
        null,
        impl.zoomToFindInPageRect.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        blink.mojom.LocalMainFrame_InstallCoopAccessMonitor_ParamsSpec.$,
        null,
        impl.installCoopAccessMonitor.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        blink.mojom.LocalMainFrame_UpdateBrowserControlsState_ParamsSpec.$,
        null,
        impl.updateBrowserControlsState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        blink.mojom.LocalMainFrame_SetV8CompileHints_ParamsSpec.$,
        null,
        impl.setV8CompileHints.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        blink.mojom.LocalMainFrame_Discard_ParamsSpec.$,
        blink.mojom.LocalMainFrame_Discard_ResponseParamsSpec.$,
        impl.discard.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        blink.mojom.LocalMainFrame_FinalizeNavigationConfidence_ParamsSpec.$,
        null,
        impl.finalizeNavigationConfidence.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.LocalMainFrame = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.LocalMainFrame";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.LocalMainFrameRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.LocalMainFrameRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the LocalMainFrame
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.LocalMainFrameCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.LocalMainFrameRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.LocalMainFrameRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.animateDoubleTapZoom =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.LocalMainFrame_AnimateDoubleTapZoom_ParamsSpec.$,
        null,
        this.animateDoubleTapZoom.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setScaleFactor =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.LocalMainFrame_SetScaleFactor_ParamsSpec.$,
        null,
        this.setScaleFactor.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.closePage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.LocalMainFrame_ClosePage_ParamsSpec.$,
        blink.mojom.LocalMainFrame_ClosePage_ResponseParamsSpec.$,
        this.closePage.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getFullPageSize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.LocalMainFrame_GetFullPageSize_ParamsSpec.$,
        blink.mojom.LocalMainFrame_GetFullPageSize_ResponseParamsSpec.$,
        this.getFullPageSize.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setInitialFocus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.LocalMainFrame_SetInitialFocus_ParamsSpec.$,
        null,
        this.setInitialFocus.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enablePreferredSizeChangedMode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.LocalMainFrame_EnablePreferredSizeChangedMode_ParamsSpec.$,
        null,
        this.enablePreferredSizeChangedMode.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.zoomToFindInPageRect =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        blink.mojom.LocalMainFrame_ZoomToFindInPageRect_ParamsSpec.$,
        null,
        this.zoomToFindInPageRect.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.installCoopAccessMonitor =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        blink.mojom.LocalMainFrame_InstallCoopAccessMonitor_ParamsSpec.$,
        null,
        this.installCoopAccessMonitor.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateBrowserControlsState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        blink.mojom.LocalMainFrame_UpdateBrowserControlsState_ParamsSpec.$,
        null,
        this.updateBrowserControlsState.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setV8CompileHints =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        blink.mojom.LocalMainFrame_SetV8CompileHints_ParamsSpec.$,
        null,
        this.setV8CompileHints.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.discard =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        blink.mojom.LocalMainFrame_Discard_ParamsSpec.$,
        blink.mojom.LocalMainFrame_Discard_ResponseParamsSpec.$,
        this.discard.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.finalizeNavigationConfidence =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        blink.mojom.LocalMainFrame_FinalizeNavigationConfidence_ParamsSpec.$,
        null,
        this.finalizeNavigationConfidence.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.LocalMainFrameHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.LocalMainFrameHost.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.LocalMainFrameHostInterface }
 */
blink.mojom.LocalMainFrameHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.LocalMainFrameHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.LocalMainFrameHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.LocalMainFrameHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } scale
   */

  scaleFactorChanged(
      scale) {
    this.proxy.sendMessage(
        0,
        blink.mojom.LocalMainFrameHost_ScaleFactorChanged_ParamsSpec.$,
        null,
        [
          scale
        ],
        false);
  }

  
  /**
   * @param { !gfx.mojom.Size } prefSize
   */

  contentsPreferredSizeChanged(
      prefSize) {
    this.proxy.sendMessage(
        1,
        blink.mojom.LocalMainFrameHost_ContentsPreferredSizeChanged_ParamsSpec.$,
        null,
        [
          prefSize
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.TextAutosizerPageInfo } pageInfo
   */

  textAutosizerPageInfoChanged(
      pageInfo) {
    this.proxy.sendMessage(
        2,
        blink.mojom.LocalMainFrameHost_TextAutosizerPageInfoChanged_ParamsSpec.$,
        null,
        [
          pageInfo
        ],
        false);
  }

  
  /**
   */

  focusPage() {
    this.proxy.sendMessage(
        3,
        blink.mojom.LocalMainFrameHost_FocusPage_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } reverse
   */

  takeFocus(
      reverse) {
    this.proxy.sendMessage(
        4,
        blink.mojom.LocalMainFrameHost_TakeFocus_ParamsSpec.$,
        null,
        [
          reverse
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @return {!Promise}
   */

  updateTargetURL(
      url) {
    return this.proxy.sendMessage(
        5,
        blink.mojom.LocalMainFrameHost_UpdateTargetURL_ParamsSpec.$,
        blink.mojom.LocalMainFrameHost_UpdateTargetURL_ResponseParamsSpec.$,
        [
          url
        ],
        false);
  }

  
  /**
   */

  requestClose() {
    this.proxy.sendMessage(
        6,
        blink.mojom.LocalMainFrameHost_RequestClose_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.LocalFrameToken } openerFrameToken
   * @param { !ui.mojom.WindowOpenDisposition } disposition
   * @param { !blink.mojom.WindowFeatures } windowFeatures
   * @param { !boolean } openedByUserGesture
   * @return {!Promise}
   */

  showCreatedWindow(
      openerFrameToken,
      disposition,
      windowFeatures,
      openedByUserGesture) {
    return this.proxy.sendMessage(
        7,
        blink.mojom.LocalMainFrameHost_ShowCreatedWindow_ParamsSpec.$,
        blink.mojom.LocalMainFrameHost_ShowCreatedWindow_ResponseParamsSpec.$,
        [
          openerFrameToken,
          disposition,
          windowFeatures,
          openedByUserGesture
        ],
        false);
  }

  
  /**
   * @param { !gfx.mojom.Rect } bounds
   * @return {!Promise}
   */

  setWindowRect(
      bounds) {
    return this.proxy.sendMessage(
        8,
        blink.mojom.LocalMainFrameHost_SetWindowRect_ParamsSpec.$,
        blink.mojom.LocalMainFrameHost_SetWindowRect_ResponseParamsSpec.$,
        [
          bounds
        ],
        false);
  }

  
  /**
   */

  didFirstVisuallyNonEmptyPaint() {
    this.proxy.sendMessage(
        9,
        blink.mojom.LocalMainFrameHost_DidFirstVisuallyNonEmptyPaint_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  didAccessInitialMainDocument() {
    this.proxy.sendMessage(
        10,
        blink.mojom.LocalMainFrameHost_DidAccessInitialMainDocument_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  maximize() {
    this.proxy.sendMessage(
        11,
        blink.mojom.LocalMainFrameHost_Maximize_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  minimize() {
    this.proxy.sendMessage(
        12,
        blink.mojom.LocalMainFrameHost_Minimize_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  restore() {
    this.proxy.sendMessage(
        13,
        blink.mojom.LocalMainFrameHost_Restore_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } resizable
   */

  setResizable(
      resizable) {
    this.proxy.sendMessage(
        14,
        blink.mojom.LocalMainFrameHost_SetResizable_ParamsSpec.$,
        null,
        [
          resizable
        ],
        false);
  }

  
  /**
   * @param { !Array<!blink.mojom.DraggableRegion> } regions
   */

  draggableRegionsChanged(
      regions) {
    this.proxy.sendMessage(
        15,
        blink.mojom.LocalMainFrameHost_DraggableRegionsChanged_ParamsSpec.$,
        null,
        [
          regions
        ],
        false);
  }

  
  /**
   */

  onFirstContentfulPaint() {
    this.proxy.sendMessage(
        16,
        blink.mojom.LocalMainFrameHost_OnFirstContentfulPaint_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the LocalMainFrameHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.LocalMainFrameHostReceiver = class {
  /**
   * @param {!blink.mojom.LocalMainFrameHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.LocalMainFrameHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.LocalMainFrameHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.LocalMainFrameHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.LocalMainFrameHost_ScaleFactorChanged_ParamsSpec.$,
        null,
        impl.scaleFactorChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.LocalMainFrameHost_ContentsPreferredSizeChanged_ParamsSpec.$,
        null,
        impl.contentsPreferredSizeChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.LocalMainFrameHost_TextAutosizerPageInfoChanged_ParamsSpec.$,
        null,
        impl.textAutosizerPageInfoChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.LocalMainFrameHost_FocusPage_ParamsSpec.$,
        null,
        impl.focusPage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.LocalMainFrameHost_TakeFocus_ParamsSpec.$,
        null,
        impl.takeFocus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.LocalMainFrameHost_UpdateTargetURL_ParamsSpec.$,
        blink.mojom.LocalMainFrameHost_UpdateTargetURL_ResponseParamsSpec.$,
        impl.updateTargetURL.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        blink.mojom.LocalMainFrameHost_RequestClose_ParamsSpec.$,
        null,
        impl.requestClose.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        blink.mojom.LocalMainFrameHost_ShowCreatedWindow_ParamsSpec.$,
        blink.mojom.LocalMainFrameHost_ShowCreatedWindow_ResponseParamsSpec.$,
        impl.showCreatedWindow.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        blink.mojom.LocalMainFrameHost_SetWindowRect_ParamsSpec.$,
        blink.mojom.LocalMainFrameHost_SetWindowRect_ResponseParamsSpec.$,
        impl.setWindowRect.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        blink.mojom.LocalMainFrameHost_DidFirstVisuallyNonEmptyPaint_ParamsSpec.$,
        null,
        impl.didFirstVisuallyNonEmptyPaint.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        blink.mojom.LocalMainFrameHost_DidAccessInitialMainDocument_ParamsSpec.$,
        null,
        impl.didAccessInitialMainDocument.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        blink.mojom.LocalMainFrameHost_Maximize_ParamsSpec.$,
        null,
        impl.maximize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        blink.mojom.LocalMainFrameHost_Minimize_ParamsSpec.$,
        null,
        impl.minimize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        blink.mojom.LocalMainFrameHost_Restore_ParamsSpec.$,
        null,
        impl.restore.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        blink.mojom.LocalMainFrameHost_SetResizable_ParamsSpec.$,
        null,
        impl.setResizable.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        blink.mojom.LocalMainFrameHost_DraggableRegionsChanged_ParamsSpec.$,
        null,
        impl.draggableRegionsChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        blink.mojom.LocalMainFrameHost_OnFirstContentfulPaint_ParamsSpec.$,
        null,
        impl.onFirstContentfulPaint.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.LocalMainFrameHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.LocalMainFrameHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.LocalMainFrameHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.LocalMainFrameHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the LocalMainFrameHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.LocalMainFrameHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.LocalMainFrameHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.LocalMainFrameHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.scaleFactorChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.LocalMainFrameHost_ScaleFactorChanged_ParamsSpec.$,
        null,
        this.scaleFactorChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.contentsPreferredSizeChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.LocalMainFrameHost_ContentsPreferredSizeChanged_ParamsSpec.$,
        null,
        this.contentsPreferredSizeChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.textAutosizerPageInfoChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.LocalMainFrameHost_TextAutosizerPageInfoChanged_ParamsSpec.$,
        null,
        this.textAutosizerPageInfoChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.focusPage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.LocalMainFrameHost_FocusPage_ParamsSpec.$,
        null,
        this.focusPage.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.takeFocus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.LocalMainFrameHost_TakeFocus_ParamsSpec.$,
        null,
        this.takeFocus.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateTargetURL =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.LocalMainFrameHost_UpdateTargetURL_ParamsSpec.$,
        blink.mojom.LocalMainFrameHost_UpdateTargetURL_ResponseParamsSpec.$,
        this.updateTargetURL.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestClose =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        blink.mojom.LocalMainFrameHost_RequestClose_ParamsSpec.$,
        null,
        this.requestClose.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.showCreatedWindow =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        blink.mojom.LocalMainFrameHost_ShowCreatedWindow_ParamsSpec.$,
        blink.mojom.LocalMainFrameHost_ShowCreatedWindow_ResponseParamsSpec.$,
        this.showCreatedWindow.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setWindowRect =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        blink.mojom.LocalMainFrameHost_SetWindowRect_ParamsSpec.$,
        blink.mojom.LocalMainFrameHost_SetWindowRect_ResponseParamsSpec.$,
        this.setWindowRect.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didFirstVisuallyNonEmptyPaint =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        blink.mojom.LocalMainFrameHost_DidFirstVisuallyNonEmptyPaint_ParamsSpec.$,
        null,
        this.didFirstVisuallyNonEmptyPaint.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didAccessInitialMainDocument =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        blink.mojom.LocalMainFrameHost_DidAccessInitialMainDocument_ParamsSpec.$,
        null,
        this.didAccessInitialMainDocument.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.maximize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        blink.mojom.LocalMainFrameHost_Maximize_ParamsSpec.$,
        null,
        this.maximize.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.minimize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        blink.mojom.LocalMainFrameHost_Minimize_ParamsSpec.$,
        null,
        this.minimize.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.restore =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        blink.mojom.LocalMainFrameHost_Restore_ParamsSpec.$,
        null,
        this.restore.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setResizable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        blink.mojom.LocalMainFrameHost_SetResizable_ParamsSpec.$,
        null,
        this.setResizable.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.draggableRegionsChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        blink.mojom.LocalMainFrameHost_DraggableRegionsChanged_ParamsSpec.$,
        null,
        this.draggableRegionsChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onFirstContentfulPaint =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        blink.mojom.LocalMainFrameHost_OnFirstContentfulPaint_ParamsSpec.$,
        null,
        this.onFirstContentfulPaint.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SavableSubframeSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.GetSavableResourceLinksReplySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FindInPageResultAXParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SerializedDomElementInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DownloadURLParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IframeAttributesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LegacyTechEventCodeLocationSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_EnterFullscreen_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_EnterFullscreen_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_ExitFullscreen_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_FullscreenStateChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_RegisterProtocolHandler_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_UnregisterProtocolHandler_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_DidDisplayInsecureContent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_DidContainInsecureFormAction_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_MainDocumentElementAvailable_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_SetNeedsOcclusionTracking_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_SetVirtualKeyboardMode_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_VisibilityChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_DidChangeThemeColor_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_DidChangeBackgroundColor_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_DidFailLoadWithError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_DidFocusFrame_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_DidCallFocus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_EnforceInsecureRequestPolicy_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_EnforceInsecureNavigationsSet_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_SuddenTerminationDisablerChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_HadStickyUserActivationBeforeNavigationChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_ScrollRectToVisibleInParentFrame_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_BubbleLogicalScrollInParentFrame_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_StartLoadingForAsyncNavigationApiCommit_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_DidBlockNavigation_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_DidChangeLoadProgress_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_DidFinishLoad_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_DispatchLoad_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_GoToEntryAtOffset_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_NavigateToNavigationApiKey_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_NavigateEventHandlerPresenceChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_UpdateTitle_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_UpdateApplicationTitle_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_UpdateUserActivationState_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_DidConsumeHistoryUserActivation_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_HandleAccessibilityFindInPageResult_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_HandleAccessibilityFindInPageTermination_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_DocumentOnLoadCompleted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_ForwardResourceTimingToParent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_DidDispatchDOMContentLoadedEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_RunModalAlertDialog_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_RunModalAlertDialog_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_RunModalConfirmDialog_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_RunModalConfirmDialog_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_RunModalPromptDialog_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_RunModalPromptDialog_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_RunBeforeUnloadConfirm_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_RunBeforeUnloadConfirm_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_UpdateFaviconURL_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_DownloadURL_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_FocusedElementChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_TextSelectionChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_ShowPopupMenu_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_CreateNewPopupWidget_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_ShowContextMenu_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_DidLoadResourceFromMemoryCache_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_DidChangeFrameOwnerProperties_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_DidChangeOpener_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_DidChangeFramePolicy_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_DidChangeIframeAttributes_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_CapturePaintPreviewOfSubframe_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_SetCloseListener_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_Detach_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_GetKeepAliveHandleFactory_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_DidAddMessageToConsole_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_FrameSizeChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_DidInferColorScheme_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_DidChangeSrcDoc_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_ReceivedDelegatedCapability_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_SendFencedFrameReportingBeacon_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_SendFencedFrameReportingBeaconToCustomURL_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_DisableUntrustedNetworkInFencedFrame_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_DisableUntrustedNetworkInFencedFrame_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_SendLegacyTechEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_SetFencedFrameAutomaticBeaconReportEventData_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_SendPrivateAggregationRequestsForFencedFrameEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_CreateFencedFrame_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_ForwardFencedFrameEventAndUserActivationToEmbedder_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_OnViewTransitionOptInChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_StartDragging_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_IssueKeepAliveHandle_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_NotifyStorageAccessed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_RecordWindowProxyUsageMetrics_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_NotifyDocumentInteractive_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_SetStorageAccessApiStatus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_InitializeCrashReportStorage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_InitializeCrashReportStorage_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_SetCrashReportStorageKey_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_SetCrashReportStorageKey_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_RemoveCrashReportStorageKey_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrameHost_RemoveCrashReportStorageKey_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.NonAssociatedLocalFrameHost_MaybeStartOutermostMainFrameNavigation_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_GetTextSurroundingSelection_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_GetTextSurroundingSelection_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_SendInterventionReport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_SetFrameOwnerProperties_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_NotifyUserActivation_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_NotifyVirtualKeyboardOverlayRect_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_ShowInterestInElement_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_AddMessageToConsole_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_SwapInImmediately_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_CheckCompleted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_StopLoading_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_Collapse_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_EnableViewSourceMode_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_Focus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_ClearFocusedElement_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_CopyImageAt_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_SaveImageAt_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_ReportBlinkFeatureUsage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_RenderFallbackContent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_BeforeUnload_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_BeforeUnload_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_MediaPlayerActionAt_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_RequestVideoFrameAtWithBoundsHint_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_RequestVideoFrameAtWithBoundsHint_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_PluginActionAt_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_AdvanceFocusInFrame_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_AdvanceFocusForIME_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_ReportContentSecurityPolicyViolation_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_DidUpdateFramePolicy_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_OnFrameVisibilityChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_PostMessageEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_JavaScriptMethodExecuteRequest_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_JavaScriptMethodExecuteRequest_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_JavaScriptExecuteRequest_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_JavaScriptExecuteRequest_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_JavaScriptExecuteRequestForTests_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_JavaScriptExecuteRequestForTests_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_JavaScriptAwaitPromiseInIsolatedWorld_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_JavaScriptAwaitPromiseInIsolatedWorld_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_GetCharacterIndexAtPoint_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_GetFirstRectForRange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_GetStringForRange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_GetStringForRange_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_BindReportingObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_UpdateOpener_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_GetSavableResourceLinks_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_GetSavableResourceLinks_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_MixedContentFound_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_BindDevToolsAgent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_ExtractAnnotatedText_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_ExtractAnnotatedText_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_ExtractSerializedDom_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_ExtractSerializedDom_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_ExtractSerializedDomElementInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_ExtractSerializedDomElementInfo_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_HandleRendererDebugURL_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_GetCanonicalUrlForSharing_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_GetCanonicalUrlForSharing_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_GetOpenGraphMetadata_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_GetOpenGraphMetadata_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_SetNavigationApiHistoryEntriesForRestore_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_UpdatePrerenderURL_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_UpdatePrerenderURL_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_NotifyNavigationApiOfDisposedEntries_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_TraverseCancelled_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_DispatchNavigateEventForCrossDocumentTraversal_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_SnapshotDocumentForViewTransition_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_SnapshotDocumentForViewTransition_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_NotifyViewTransitionAbortedToOldDocument_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_DispatchPageSwap_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_AddResourceTimingEntryForFailedSubframeNavigation_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_GetScrollPosition_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalFrame_GetScrollPosition_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalMainFrame_AnimateDoubleTapZoom_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalMainFrame_SetScaleFactor_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalMainFrame_ClosePage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalMainFrame_ClosePage_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalMainFrame_GetFullPageSize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalMainFrame_GetFullPageSize_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalMainFrame_SetInitialFocus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalMainFrame_EnablePreferredSizeChangedMode_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalMainFrame_ZoomToFindInPageRect_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalMainFrame_InstallCoopAccessMonitor_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalMainFrame_UpdateBrowserControlsState_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalMainFrame_SetV8CompileHints_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalMainFrame_Discard_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalMainFrame_Discard_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalMainFrame_FinalizeNavigationConfidence_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalMainFrameHost_ScaleFactorChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalMainFrameHost_ContentsPreferredSizeChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalMainFrameHost_TextAutosizerPageInfoChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalMainFrameHost_FocusPage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalMainFrameHost_TakeFocus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalMainFrameHost_UpdateTargetURL_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalMainFrameHost_UpdateTargetURL_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalMainFrameHost_RequestClose_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalMainFrameHost_ShowCreatedWindow_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalMainFrameHost_ShowCreatedWindow_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalMainFrameHost_SetWindowRect_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalMainFrameHost_SetWindowRect_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalMainFrameHost_DidFirstVisuallyNonEmptyPaint_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalMainFrameHost_DidAccessInitialMainDocument_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalMainFrameHost_Maximize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalMainFrameHost_Minimize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalMainFrameHost_Restore_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalMainFrameHost_SetResizable_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalMainFrameHost_DraggableRegionsChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LocalMainFrameHost_OnFirstContentfulPaint_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.SavableSubframeSpec.$,
    'SavableSubframe',
    [
      mojo.internal.StructField(
        'originalUrl', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'subframeToken', 8,
        0,
        blink.mojom.FrameTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.SavableSubframe = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.originalUrl;
    /** @export { !blink.mojom.FrameToken } */
    this.subframeToken;
  }
};



mojo.internal.Struct(
    blink.mojom.GetSavableResourceLinksReplySpec.$,
    'GetSavableResourceLinksReply',
    [
      mojo.internal.StructField(
        'resourcesList', 0,
        0,
        mojo.internal.Array(url.mojom.UrlSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'referrer', 8,
        0,
        blink.mojom.ReferrerSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'subframes', 16,
        0,
        mojo.internal.Array(blink.mojom.SavableSubframeSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.GetSavableResourceLinksReply = class {
  constructor() {
    /** @export { !Array<!url.mojom.Url> } */
    this.resourcesList;
    /** @export { !blink.mojom.Referrer } */
    this.referrer;
    /** @export { !Array<!blink.mojom.SavableSubframe> } */
    this.subframes;
  }
};



mojo.internal.Struct(
    blink.mojom.FindInPageResultAXParamsSpec.$,
    'FindInPageResultAXParams',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'matchIndex', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'startId', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'startOffset', 12,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'endId', 16,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'endOffset', 20,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.FindInPageResultAXParams = class {
  constructor() {
    /** @export { !number } */
    this.requestId;
    /** @export { !number } */
    this.matchIndex;
    /** @export { !number } */
    this.startId;
    /** @export { !number } */
    this.startOffset;
    /** @export { !number } */
    this.endId;
    /** @export { !number } */
    this.endOffset;
  }
};



mojo.internal.Struct(
    blink.mojom.SerializedDomElementInfoSpec.$,
    'SerializedDomElementInfo',
    [
      mojo.internal.StructField(
        'tag', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'selector', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'visibleBounds', 16,
        0,
        gfx.mojom.RectSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'clickPoint', 24,
        0,
        gfx.mojom.PointSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
blink.mojom.SerializedDomElementInfo = class {
  constructor() {
    /** @export { !string } */
    this.tag;
    /** @export { !string } */
    this.selector;
    /** @export { (gfx.mojom.Rect|undefined) } */
    this.visibleBounds;
    /** @export { (gfx.mojom.Point|undefined) } */
    this.clickPoint;
  }
};



mojo.internal.Struct(
    blink.mojom.DownloadURLParamsSpec.$,
    'DownloadURLParams',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'referrer', 8,
        0,
        blink.mojom.ReferrerSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'initiatorOrigin', 16,
        0,
        url.mojom.OriginSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'suggestedName', 24,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'crossOriginRedirects', 32,
        0,
        network.mojom.RedirectModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'blobUrlToken', 36,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.BlobURLTokenRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dataUrlBlob', 44,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.BlobRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isContextMenuSave', 52,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasUserGesture', 52,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 64],]);





/** @record */
blink.mojom.DownloadURLParams = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { (blink.mojom.Referrer|undefined) } */
    this.referrer;
    /** @export { (url.mojom.Origin|undefined) } */
    this.initiatorOrigin;
    /** @export { (mojoBase.mojom.String16|undefined) } */
    this.suggestedName;
    /** @export { !network.mojom.RedirectMode } */
    this.crossOriginRedirects;
    /** @export { (blink.mojom.BlobURLTokenRemote|undefined) } */
    this.blobUrlToken;
    /** @export { (blink.mojom.BlobRemote|undefined) } */
    this.dataUrlBlob;
    /** @export { !boolean } */
    this.isContextMenuSave;
    /** @export { !boolean } */
    this.hasUserGesture;
  }
};



mojo.internal.Struct(
    blink.mojom.IframeAttributesSpec.$,
    'IframeAttributes',
    [
      mojo.internal.StructField(
        'parsedCspAttribute', 0,
        0,
        network.mojom.ContentSecurityPolicySpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'credentialless', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'browsingTopics', 8,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'adAuctionHeaders', 8,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sharedStorageWritableOptedIn', 8,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'id', 16,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'name', 24,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'src', 32,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);





/** @record */
blink.mojom.IframeAttributes = class {
  constructor() {
    /** @export { (network.mojom.ContentSecurityPolicy|undefined) } */
    this.parsedCspAttribute;
    /** @export { !boolean } */
    this.credentialless;
    /** @export { !boolean } */
    this.browsingTopics;
    /** @export { !boolean } */
    this.adAuctionHeaders;
    /** @export { !boolean } */
    this.sharedStorageWritableOptedIn;
    /** @export { (string|undefined) } */
    this.id;
    /** @export { (string|undefined) } */
    this.name;
    /** @export { (string|undefined) } */
    this.src;
  }
};



mojo.internal.Struct(
    blink.mojom.LegacyTechEventCodeLocationSpec.$,
    'LegacyTechEventCodeLocation',
    [
      mojo.internal.StructField(
        'filename', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'line', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'column', 16,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.LegacyTechEventCodeLocation = class {
  constructor() {
    /** @export { !string } */
    this.filename;
    /** @export { !bigint } */
    this.line;
    /** @export { !bigint } */
    this.column;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_EnterFullscreen_ParamsSpec.$,
    'LocalFrameHost_EnterFullscreen_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        blink.mojom.FullscreenOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrameHost_EnterFullscreen_Params = class {
  constructor() {
    /** @export { !blink.mojom.FullscreenOptions } */
    this.options;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_EnterFullscreen_ResponseParamsSpec.$,
    'LocalFrameHost_EnterFullscreen_ResponseParams',
    [
      mojo.internal.StructField(
        'granted', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrameHost_EnterFullscreen_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.granted;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_ExitFullscreen_ParamsSpec.$,
    'LocalFrameHost_ExitFullscreen_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalFrameHost_ExitFullscreen_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_FullscreenStateChanged_ParamsSpec.$,
    'LocalFrameHost_FullscreenStateChanged_Params',
    [
      mojo.internal.StructField(
        'isFullscreen', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'options', 8,
        0,
        blink.mojom.FullscreenOptionsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.LocalFrameHost_FullscreenStateChanged_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.isFullscreen;
    /** @export { (blink.mojom.FullscreenOptions|undefined) } */
    this.options;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_RegisterProtocolHandler_ParamsSpec.$,
    'LocalFrameHost_RegisterProtocolHandler_Params',
    [
      mojo.internal.StructField(
        'scheme', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'userGesture', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.LocalFrameHost_RegisterProtocolHandler_Params = class {
  constructor() {
    /** @export { !string } */
    this.scheme;
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !boolean } */
    this.userGesture;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_UnregisterProtocolHandler_ParamsSpec.$,
    'LocalFrameHost_UnregisterProtocolHandler_Params',
    [
      mojo.internal.StructField(
        'scheme', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'userGesture', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.LocalFrameHost_UnregisterProtocolHandler_Params = class {
  constructor() {
    /** @export { !string } */
    this.scheme;
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !boolean } */
    this.userGesture;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_DidDisplayInsecureContent_ParamsSpec.$,
    'LocalFrameHost_DidDisplayInsecureContent_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalFrameHost_DidDisplayInsecureContent_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_DidContainInsecureFormAction_ParamsSpec.$,
    'LocalFrameHost_DidContainInsecureFormAction_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalFrameHost_DidContainInsecureFormAction_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_MainDocumentElementAvailable_ParamsSpec.$,
    'LocalFrameHost_MainDocumentElementAvailable_Params',
    [
      mojo.internal.StructField(
        'usesTemporaryZoomLevel', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrameHost_MainDocumentElementAvailable_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.usesTemporaryZoomLevel;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_SetNeedsOcclusionTracking_ParamsSpec.$,
    'LocalFrameHost_SetNeedsOcclusionTracking_Params',
    [
      mojo.internal.StructField(
        'needsTracking', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrameHost_SetNeedsOcclusionTracking_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.needsTracking;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_SetVirtualKeyboardMode_ParamsSpec.$,
    'LocalFrameHost_SetVirtualKeyboardMode_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        ui.mojom.VirtualKeyboardModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrameHost_SetVirtualKeyboardMode_Params = class {
  constructor() {
    /** @export { !ui.mojom.VirtualKeyboardMode } */
    this.type;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_VisibilityChanged_ParamsSpec.$,
    'LocalFrameHost_VisibilityChanged_Params',
    [
      mojo.internal.StructField(
        'visibility', 0,
        0,
        blink.mojom.FrameVisibilitySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrameHost_VisibilityChanged_Params = class {
  constructor() {
    /** @export { !blink.mojom.FrameVisibility } */
    this.visibility;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_DidChangeThemeColor_ParamsSpec.$,
    'LocalFrameHost_DidChangeThemeColor_Params',
    [
      mojo.internal.StructField(
        'themeColor', 0,
        0,
        skia.mojom.SkColorSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrameHost_DidChangeThemeColor_Params = class {
  constructor() {
    /** @export { (skia.mojom.SkColor|undefined) } */
    this.themeColor;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_DidChangeBackgroundColor_ParamsSpec.$,
    'LocalFrameHost_DidChangeBackgroundColor_Params',
    [
      mojo.internal.StructField(
        'backgroundColor', 0,
        0,
        skia.mojom.SkColor4fSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'colorAdjust', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.LocalFrameHost_DidChangeBackgroundColor_Params = class {
  constructor() {
    /** @export { !skia.mojom.SkColor4f } */
    this.backgroundColor;
    /** @export { !boolean } */
    this.colorAdjust;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_DidFailLoadWithError_ParamsSpec.$,
    'LocalFrameHost_DidFailLoadWithError_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'errorCode', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.LocalFrameHost_DidFailLoadWithError_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !number } */
    this.errorCode;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_DidFocusFrame_ParamsSpec.$,
    'LocalFrameHost_DidFocusFrame_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalFrameHost_DidFocusFrame_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_DidCallFocus_ParamsSpec.$,
    'LocalFrameHost_DidCallFocus_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalFrameHost_DidCallFocus_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_EnforceInsecureRequestPolicy_ParamsSpec.$,
    'LocalFrameHost_EnforceInsecureRequestPolicy_Params',
    [
      mojo.internal.StructField(
        'policyBitmap', 0,
        0,
        blink.mojom.InsecureRequestPolicySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrameHost_EnforceInsecureRequestPolicy_Params = class {
  constructor() {
    /** @export { !blink.mojom.InsecureRequestPolicy } */
    this.policyBitmap;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_EnforceInsecureNavigationsSet_ParamsSpec.$,
    'LocalFrameHost_EnforceInsecureNavigationsSet_Params',
    [
      mojo.internal.StructField(
        'set', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint32, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrameHost_EnforceInsecureNavigationsSet_Params = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.set;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_SuddenTerminationDisablerChanged_ParamsSpec.$,
    'LocalFrameHost_SuddenTerminationDisablerChanged_Params',
    [
      mojo.internal.StructField(
        'present', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'disablerType', 4,
        0,
        blink.mojom.SuddenTerminationDisablerTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrameHost_SuddenTerminationDisablerChanged_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.present;
    /** @export { !blink.mojom.SuddenTerminationDisablerType } */
    this.disablerType;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_HadStickyUserActivationBeforeNavigationChanged_ParamsSpec.$,
    'LocalFrameHost_HadStickyUserActivationBeforeNavigationChanged_Params',
    [
      mojo.internal.StructField(
        'hasGesture', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrameHost_HadStickyUserActivationBeforeNavigationChanged_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.hasGesture;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_ScrollRectToVisibleInParentFrame_ParamsSpec.$,
    'LocalFrameHost_ScrollRectToVisibleInParentFrame_Params',
    [
      mojo.internal.StructField(
        'rectToScroll', 0,
        0,
        gfx.mojom.RectFSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'params', 8,
        0,
        blink.mojom.ScrollIntoViewParamsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.LocalFrameHost_ScrollRectToVisibleInParentFrame_Params = class {
  constructor() {
    /** @export { !gfx.mojom.RectF } */
    this.rectToScroll;
    /** @export { !blink.mojom.ScrollIntoViewParams } */
    this.params;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_BubbleLogicalScrollInParentFrame_ParamsSpec.$,
    'LocalFrameHost_BubbleLogicalScrollInParentFrame_Params',
    [
      mojo.internal.StructField(
        'direction', 0,
        0,
        blink.mojom.ScrollDirectionSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'granularity', 4,
        0,
        ui.mojom.ScrollGranularitySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrameHost_BubbleLogicalScrollInParentFrame_Params = class {
  constructor() {
    /** @export { !blink.mojom.ScrollDirection } */
    this.direction;
    /** @export { !ui.mojom.ScrollGranularity } */
    this.granularity;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_StartLoadingForAsyncNavigationApiCommit_ParamsSpec.$,
    'LocalFrameHost_StartLoadingForAsyncNavigationApiCommit_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalFrameHost_StartLoadingForAsyncNavigationApiCommit_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_DidBlockNavigation_ParamsSpec.$,
    'LocalFrameHost_DidBlockNavigation_Params',
    [
      mojo.internal.StructField(
        'blockedUrl', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reason', 8,
        0,
        blink.mojom.NavigationBlockedReasonSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.LocalFrameHost_DidBlockNavigation_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.blockedUrl;
    /** @export { !blink.mojom.NavigationBlockedReason } */
    this.reason;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_DidChangeLoadProgress_ParamsSpec.$,
    'LocalFrameHost_DidChangeLoadProgress_Params',
    [
      mojo.internal.StructField(
        'loadProgress', 0,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrameHost_DidChangeLoadProgress_Params = class {
  constructor() {
    /** @export { !number } */
    this.loadProgress;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_DidFinishLoad_ParamsSpec.$,
    'LocalFrameHost_DidFinishLoad_Params',
    [
      mojo.internal.StructField(
        'validatedUrl', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrameHost_DidFinishLoad_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.validatedUrl;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_DispatchLoad_ParamsSpec.$,
    'LocalFrameHost_DispatchLoad_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalFrameHost_DispatchLoad_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_GoToEntryAtOffset_ParamsSpec.$,
    'LocalFrameHost_GoToEntryAtOffset_Params',
    [
      mojo.internal.StructField(
        'offset', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasUserGesture', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'actualNavigationStart', 8,
        0,
        mojoBase.mojom.TimeTicksSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'softNavigationHeuristicsTaskId', 16,
        0,
        blink.mojom.TaskAttributionIdSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.LocalFrameHost_GoToEntryAtOffset_Params = class {
  constructor() {
    /** @export { !number } */
    this.offset;
    /** @export { !boolean } */
    this.hasUserGesture;
    /** @export { !mojoBase.mojom.TimeTicks } */
    this.actualNavigationStart;
    /** @export { (blink.mojom.TaskAttributionId|undefined) } */
    this.softNavigationHeuristicsTaskId;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_NavigateToNavigationApiKey_ParamsSpec.$,
    'LocalFrameHost_NavigateToNavigationApiKey_Params',
    [
      mojo.internal.StructField(
        'key', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasUserGesture', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'actualNavigationStart', 16,
        0,
        mojoBase.mojom.TimeTicksSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'softNavigationHeuristicsTaskId', 24,
        0,
        blink.mojom.TaskAttributionIdSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
blink.mojom.LocalFrameHost_NavigateToNavigationApiKey_Params = class {
  constructor() {
    /** @export { !string } */
    this.key;
    /** @export { !boolean } */
    this.hasUserGesture;
    /** @export { !mojoBase.mojom.TimeTicks } */
    this.actualNavigationStart;
    /** @export { (blink.mojom.TaskAttributionId|undefined) } */
    this.softNavigationHeuristicsTaskId;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_NavigateEventHandlerPresenceChanged_ParamsSpec.$,
    'LocalFrameHost_NavigateEventHandlerPresenceChanged_Params',
    [
      mojo.internal.StructField(
        'present', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrameHost_NavigateEventHandlerPresenceChanged_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.present;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_UpdateTitle_ParamsSpec.$,
    'LocalFrameHost_UpdateTitle_Params',
    [
      mojo.internal.StructField(
        'title', 0,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'titleDirection', 8,
        0,
        mojoBase.mojom.TextDirectionSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.LocalFrameHost_UpdateTitle_Params = class {
  constructor() {
    /** @export { (mojoBase.mojom.String16|undefined) } */
    this.title;
    /** @export { !mojoBase.mojom.TextDirection } */
    this.titleDirection;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_UpdateApplicationTitle_ParamsSpec.$,
    'LocalFrameHost_UpdateApplicationTitle_Params',
    [
      mojo.internal.StructField(
        'applicationTitle', 0,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrameHost_UpdateApplicationTitle_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.String16 } */
    this.applicationTitle;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_UpdateUserActivationState_ParamsSpec.$,
    'LocalFrameHost_UpdateUserActivationState_Params',
    [
      mojo.internal.StructField(
        'updateType', 0,
        0,
        blink.mojom.UserActivationUpdateTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'notificationType', 4,
        0,
        blink.mojom.UserActivationNotificationTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrameHost_UpdateUserActivationState_Params = class {
  constructor() {
    /** @export { !blink.mojom.UserActivationUpdateType } */
    this.updateType;
    /** @export { !blink.mojom.UserActivationNotificationType } */
    this.notificationType;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_DidConsumeHistoryUserActivation_ParamsSpec.$,
    'LocalFrameHost_DidConsumeHistoryUserActivation_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalFrameHost_DidConsumeHistoryUserActivation_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_HandleAccessibilityFindInPageResult_ParamsSpec.$,
    'LocalFrameHost_HandleAccessibilityFindInPageResult_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        blink.mojom.FindInPageResultAXParamsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrameHost_HandleAccessibilityFindInPageResult_Params = class {
  constructor() {
    /** @export { !blink.mojom.FindInPageResultAXParams } */
    this.params;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_HandleAccessibilityFindInPageTermination_ParamsSpec.$,
    'LocalFrameHost_HandleAccessibilityFindInPageTermination_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalFrameHost_HandleAccessibilityFindInPageTermination_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_DocumentOnLoadCompleted_ParamsSpec.$,
    'LocalFrameHost_DocumentOnLoadCompleted_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalFrameHost_DocumentOnLoadCompleted_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_ForwardResourceTimingToParent_ParamsSpec.$,
    'LocalFrameHost_ForwardResourceTimingToParent_Params',
    [
      mojo.internal.StructField(
        'timing', 0,
        0,
        blink.mojom.ResourceTimingInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrameHost_ForwardResourceTimingToParent_Params = class {
  constructor() {
    /** @export { !blink.mojom.ResourceTimingInfo } */
    this.timing;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_DidDispatchDOMContentLoadedEvent_ParamsSpec.$,
    'LocalFrameHost_DidDispatchDOMContentLoadedEvent_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalFrameHost_DidDispatchDOMContentLoadedEvent_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_RunModalAlertDialog_ParamsSpec.$,
    'LocalFrameHost_RunModalAlertDialog_Params',
    [
      mojo.internal.StructField(
        'alertMessage', 0,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'disableThirdPartySubframeSuppresion', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.LocalFrameHost_RunModalAlertDialog_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.String16 } */
    this.alertMessage;
    /** @export { !boolean } */
    this.disableThirdPartySubframeSuppresion;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_RunModalAlertDialog_ResponseParamsSpec.$,
    'LocalFrameHost_RunModalAlertDialog_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalFrameHost_RunModalAlertDialog_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_RunModalConfirmDialog_ParamsSpec.$,
    'LocalFrameHost_RunModalConfirmDialog_Params',
    [
      mojo.internal.StructField(
        'alertMessage', 0,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'disableThirdPartySubframeSuppresion', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.LocalFrameHost_RunModalConfirmDialog_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.String16 } */
    this.alertMessage;
    /** @export { !boolean } */
    this.disableThirdPartySubframeSuppresion;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_RunModalConfirmDialog_ResponseParamsSpec.$,
    'LocalFrameHost_RunModalConfirmDialog_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrameHost_RunModalConfirmDialog_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_RunModalPromptDialog_ParamsSpec.$,
    'LocalFrameHost_RunModalPromptDialog_Params',
    [
      mojo.internal.StructField(
        'alertMessage', 0,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'defaultValue', 8,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'disableThirdPartySubframeSuppresion', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.LocalFrameHost_RunModalPromptDialog_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.String16 } */
    this.alertMessage;
    /** @export { !mojoBase.mojom.String16 } */
    this.defaultValue;
    /** @export { !boolean } */
    this.disableThirdPartySubframeSuppresion;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_RunModalPromptDialog_ResponseParamsSpec.$,
    'LocalFrameHost_RunModalPromptDialog_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'result', 8,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.LocalFrameHost_RunModalPromptDialog_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
    /** @export { !mojoBase.mojom.String16 } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_RunBeforeUnloadConfirm_ParamsSpec.$,
    'LocalFrameHost_RunBeforeUnloadConfirm_Params',
    [
      mojo.internal.StructField(
        'isReload', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrameHost_RunBeforeUnloadConfirm_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.isReload;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_RunBeforeUnloadConfirm_ResponseParamsSpec.$,
    'LocalFrameHost_RunBeforeUnloadConfirm_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrameHost_RunBeforeUnloadConfirm_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_UpdateFaviconURL_ParamsSpec.$,
    'LocalFrameHost_UpdateFaviconURL_Params',
    [
      mojo.internal.StructField(
        'faviconUrls', 0,
        0,
        mojo.internal.Array(blink.mojom.FaviconURLSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrameHost_UpdateFaviconURL_Params = class {
  constructor() {
    /** @export { !Array<!blink.mojom.FaviconURL> } */
    this.faviconUrls;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_DownloadURL_ParamsSpec.$,
    'LocalFrameHost_DownloadURL_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        blink.mojom.DownloadURLParamsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrameHost_DownloadURL_Params = class {
  constructor() {
    /** @export { !blink.mojom.DownloadURLParams } */
    this.params;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_FocusedElementChanged_ParamsSpec.$,
    'LocalFrameHost_FocusedElementChanged_Params',
    [
      mojo.internal.StructField(
        'isEditableElement', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isRichlyEditableElement', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'boundsInFrameWidget', 8,
        0,
        gfx.mojom.RectSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'focusType', 4,
        0,
        blink.mojom.FocusTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.LocalFrameHost_FocusedElementChanged_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.isEditableElement;
    /** @export { !boolean } */
    this.isRichlyEditableElement;
    /** @export { !gfx.mojom.Rect } */
    this.boundsInFrameWidget;
    /** @export { !blink.mojom.FocusType } */
    this.focusType;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_TextSelectionChanged_ParamsSpec.$,
    'LocalFrameHost_TextSelectionChanged_Params',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojoBase.mojom.BigString16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'offset', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'range', 16,
        0,
        gfx.mojom.RangeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.LocalFrameHost_TextSelectionChanged_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.BigString16 } */
    this.text;
    /** @export { !number } */
    this.offset;
    /** @export { !gfx.mojom.Range } */
    this.range;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_ShowPopupMenu_ParamsSpec.$,
    'LocalFrameHost_ShowPopupMenu_Params',
    [
      mojo.internal.StructField(
        'popupClient', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.PopupMenuClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'bounds', 8,
        0,
        gfx.mojom.RectSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fontSize', 16,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'selectedItem', 24,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'menuItems', 32,
        0,
        mojo.internal.Array(blink.mojom.MenuItemSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'rightAligned', 28,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'allowMultipleSelection', 28,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);





/** @record */
blink.mojom.LocalFrameHost_ShowPopupMenu_Params = class {
  constructor() {
    /** @export { !blink.mojom.PopupMenuClientRemote } */
    this.popupClient;
    /** @export { !gfx.mojom.Rect } */
    this.bounds;
    /** @export { !number } */
    this.fontSize;
    /** @export { !number } */
    this.selectedItem;
    /** @export { !Array<!blink.mojom.MenuItem> } */
    this.menuItems;
    /** @export { !boolean } */
    this.rightAligned;
    /** @export { !boolean } */
    this.allowMultipleSelection;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_CreateNewPopupWidget_ParamsSpec.$,
    'LocalFrameHost_CreateNewPopupWidget_Params',
    [
      mojo.internal.StructField(
        'popupHost', 0,
        0,
        mojo.internal.AssociatedInterfaceRequest(blink.mojom.PopupWidgetHostPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'blinkWidgetHost', 4,
        0,
        mojo.internal.AssociatedInterfaceRequest(blink.mojom.WidgetHostPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'blinkWidget', 8,
        0,
        mojo.internal.AssociatedInterfaceProxy(blink.mojom.WidgetRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.LocalFrameHost_CreateNewPopupWidget_Params = class {
  constructor() {
    /** @export { !Object } */
    this.popupHost;
    /** @export { !Object } */
    this.blinkWidgetHost;
    /** @export { !Object } */
    this.blinkWidget;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_ShowContextMenu_ParamsSpec.$,
    'LocalFrameHost_ShowContextMenu_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(blink.mojom.ContextMenuClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'params', 8,
        0,
        blink.mojom.UntrustworthyContextMenuParamsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.LocalFrameHost_ShowContextMenu_Params = class {
  constructor() {
    /** @export { !Object } */
    this.client;
    /** @export { !blink.mojom.UntrustworthyContextMenuParams } */
    this.params;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_DidLoadResourceFromMemoryCache_ParamsSpec.$,
    'LocalFrameHost_DidLoadResourceFromMemoryCache_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'httpMethod', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mimeType', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requestDestination', 24,
        0,
        network.mojom.RequestDestinationSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'includeCredentials', 28,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
blink.mojom.LocalFrameHost_DidLoadResourceFromMemoryCache_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !string } */
    this.httpMethod;
    /** @export { !string } */
    this.mimeType;
    /** @export { !network.mojom.RequestDestination } */
    this.requestDestination;
    /** @export { !boolean } */
    this.includeCredentials;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_DidChangeFrameOwnerProperties_ParamsSpec.$,
    'LocalFrameHost_DidChangeFrameOwnerProperties_Params',
    [
      mojo.internal.StructField(
        'childFrameToken', 0,
        0,
        blink.mojom.FrameTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'frameOwnerProperties', 16,
        0,
        blink.mojom.FrameOwnerPropertiesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.LocalFrameHost_DidChangeFrameOwnerProperties_Params = class {
  constructor() {
    /** @export { !blink.mojom.FrameToken } */
    this.childFrameToken;
    /** @export { !blink.mojom.FrameOwnerProperties } */
    this.frameOwnerProperties;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_DidChangeOpener_ParamsSpec.$,
    'LocalFrameHost_DidChangeOpener_Params',
    [
      mojo.internal.StructField(
        'openerFrame', 0,
        0,
        blink.mojom.LocalFrameTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrameHost_DidChangeOpener_Params = class {
  constructor() {
    /** @export { (blink.mojom.LocalFrameToken|undefined) } */
    this.openerFrame;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_DidChangeFramePolicy_ParamsSpec.$,
    'LocalFrameHost_DidChangeFramePolicy_Params',
    [
      mojo.internal.StructField(
        'childFrameToken', 0,
        0,
        blink.mojom.FrameTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'framePolicy', 16,
        0,
        blink.mojom.FramePolicySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.LocalFrameHost_DidChangeFramePolicy_Params = class {
  constructor() {
    /** @export { !blink.mojom.FrameToken } */
    this.childFrameToken;
    /** @export { !blink.mojom.FramePolicy } */
    this.framePolicy;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_DidChangeIframeAttributes_ParamsSpec.$,
    'LocalFrameHost_DidChangeIframeAttributes_Params',
    [
      mojo.internal.StructField(
        'childFrameToken', 0,
        0,
        blink.mojom.FrameTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'attributes', 16,
        0,
        blink.mojom.IframeAttributesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.LocalFrameHost_DidChangeIframeAttributes_Params = class {
  constructor() {
    /** @export { !blink.mojom.FrameToken } */
    this.childFrameToken;
    /** @export { !blink.mojom.IframeAttributes } */
    this.attributes;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_CapturePaintPreviewOfSubframe_ParamsSpec.$,
    'LocalFrameHost_CapturePaintPreviewOfSubframe_Params',
    [
      mojo.internal.StructField(
        'clipRect', 0,
        0,
        gfx.mojom.RectSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'guid', 8,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.LocalFrameHost_CapturePaintPreviewOfSubframe_Params = class {
  constructor() {
    /** @export { !gfx.mojom.Rect } */
    this.clipRect;
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.guid;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_SetCloseListener_ParamsSpec.$,
    'LocalFrameHost_SetCloseListener_Params',
    [
      mojo.internal.StructField(
        'listener', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.CloseListenerRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrameHost_SetCloseListener_Params = class {
  constructor() {
    /** @export { !blink.mojom.CloseListenerRemote } */
    this.listener;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_Detach_ParamsSpec.$,
    'LocalFrameHost_Detach_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalFrameHost_Detach_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_GetKeepAliveHandleFactory_ParamsSpec.$,
    'LocalFrameHost_GetKeepAliveHandleFactory_Params',
    [
      mojo.internal.StructField(
        'factory', 0,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.KeepAliveHandleFactoryPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrameHost_GetKeepAliveHandleFactory_Params = class {
  constructor() {
    /** @export { !blink.mojom.KeepAliveHandleFactoryPendingReceiver } */
    this.factory;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_DidAddMessageToConsole_ParamsSpec.$,
    'LocalFrameHost_DidAddMessageToConsole_Params',
    [
      mojo.internal.StructField(
        'logLevel', 0,
        0,
        blink.mojom.ConsoleMessageLevelSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'msg', 8,
        0,
        mojoBase.mojom.BigString16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'lineNumber', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sourceId', 16,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'untrustedStackTrace', 24,
        0,
        mojoBase.mojom.BigString16Spec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
blink.mojom.LocalFrameHost_DidAddMessageToConsole_Params = class {
  constructor() {
    /** @export { !blink.mojom.ConsoleMessageLevel } */
    this.logLevel;
    /** @export { !mojoBase.mojom.BigString16 } */
    this.msg;
    /** @export { !number } */
    this.lineNumber;
    /** @export { (mojoBase.mojom.String16|undefined) } */
    this.sourceId;
    /** @export { (mojoBase.mojom.BigString16|undefined) } */
    this.untrustedStackTrace;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_FrameSizeChanged_ParamsSpec.$,
    'LocalFrameHost_FrameSizeChanged_Params',
    [
      mojo.internal.StructField(
        'size', 0,
        0,
        gfx.mojom.SizeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrameHost_FrameSizeChanged_Params = class {
  constructor() {
    /** @export { !gfx.mojom.Size } */
    this.size;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_DidInferColorScheme_ParamsSpec.$,
    'LocalFrameHost_DidInferColorScheme_Params',
    [
      mojo.internal.StructField(
        'colorScheme', 0,
        0,
        blink.mojom.PreferredColorSchemeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrameHost_DidInferColorScheme_Params = class {
  constructor() {
    /** @export { !blink.mojom.PreferredColorScheme } */
    this.colorScheme;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_DidChangeSrcDoc_ParamsSpec.$,
    'LocalFrameHost_DidChangeSrcDoc_Params',
    [
      mojo.internal.StructField(
        'childFrameToken', 0,
        0,
        blink.mojom.FrameTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'srcdocValue', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.LocalFrameHost_DidChangeSrcDoc_Params = class {
  constructor() {
    /** @export { !blink.mojom.FrameToken } */
    this.childFrameToken;
    /** @export { !string } */
    this.srcdocValue;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_ReceivedDelegatedCapability_ParamsSpec.$,
    'LocalFrameHost_ReceivedDelegatedCapability_Params',
    [
      mojo.internal.StructField(
        'delegatedCapability', 0,
        0,
        blink.mojom.DelegatedCapabilitySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrameHost_ReceivedDelegatedCapability_Params = class {
  constructor() {
    /** @export { !blink.mojom.DelegatedCapability } */
    this.delegatedCapability;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_SendFencedFrameReportingBeacon_ParamsSpec.$,
    'LocalFrameHost_SendFencedFrameReportingBeacon_Params',
    [
      mojo.internal.StructField(
        'eventData', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'eventType', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'destinations', 16,
        0,
        mojo.internal.Array(blink.mojom.ReportingDestinationSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'crossOriginExposed', 24,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
blink.mojom.LocalFrameHost_SendFencedFrameReportingBeacon_Params = class {
  constructor() {
    /** @export { !string } */
    this.eventData;
    /** @export { !string } */
    this.eventType;
    /** @export { !Array<!blink.mojom.ReportingDestination> } */
    this.destinations;
    /** @export { !boolean } */
    this.crossOriginExposed;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_SendFencedFrameReportingBeaconToCustomURL_ParamsSpec.$,
    'LocalFrameHost_SendFencedFrameReportingBeaconToCustomURL_Params',
    [
      mojo.internal.StructField(
        'destinationUrl', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'crossOriginExposed', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.LocalFrameHost_SendFencedFrameReportingBeaconToCustomURL_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.destinationUrl;
    /** @export { !boolean } */
    this.crossOriginExposed;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_DisableUntrustedNetworkInFencedFrame_ParamsSpec.$,
    'LocalFrameHost_DisableUntrustedNetworkInFencedFrame_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalFrameHost_DisableUntrustedNetworkInFencedFrame_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_DisableUntrustedNetworkInFencedFrame_ResponseParamsSpec.$,
    'LocalFrameHost_DisableUntrustedNetworkInFencedFrame_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalFrameHost_DisableUntrustedNetworkInFencedFrame_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_ParamsSpec.$,
    'LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_Params',
    [
      mojo.internal.StructField(
        'exemptedUrl', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.exemptedUrl;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_ResponseParamsSpec.$,
    'LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalFrameHost_ExemptUrlFromNetworkRevocationForTesting_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_SendLegacyTechEvent_ParamsSpec.$,
    'LocalFrameHost_SendLegacyTechEvent_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'codeLocation', 8,
        0,
        blink.mojom.LegacyTechEventCodeLocationSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.LocalFrameHost_SendLegacyTechEvent_Params = class {
  constructor() {
    /** @export { !string } */
    this.type;
    /** @export { !blink.mojom.LegacyTechEventCodeLocation } */
    this.codeLocation;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_SetFencedFrameAutomaticBeaconReportEventData_ParamsSpec.$,
    'LocalFrameHost_SetFencedFrameAutomaticBeaconReportEventData_Params',
    [
      mojo.internal.StructField(
        'eventType', 0,
        0,
        blink.mojom.AutomaticBeaconTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'eventData', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'destinations', 16,
        0,
        mojo.internal.Array(blink.mojom.ReportingDestinationSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'once', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'crossOriginExposed', 4,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.LocalFrameHost_SetFencedFrameAutomaticBeaconReportEventData_Params = class {
  constructor() {
    /** @export { !blink.mojom.AutomaticBeaconType } */
    this.eventType;
    /** @export { !string } */
    this.eventData;
    /** @export { !Array<!blink.mojom.ReportingDestination> } */
    this.destinations;
    /** @export { !boolean } */
    this.once;
    /** @export { !boolean } */
    this.crossOriginExposed;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_SendPrivateAggregationRequestsForFencedFrameEvent_ParamsSpec.$,
    'LocalFrameHost_SendPrivateAggregationRequestsForFencedFrameEvent_Params',
    [
      mojo.internal.StructField(
        'eventType', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrameHost_SendPrivateAggregationRequestsForFencedFrameEvent_Params = class {
  constructor() {
    /** @export { !string } */
    this.eventType;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_CreateFencedFrame_ParamsSpec.$,
    'LocalFrameHost_CreateFencedFrame_Params',
    [
      mojo.internal.StructField(
        'fencedFrame', 0,
        0,
        mojo.internal.AssociatedInterfaceRequest(blink.mojom.FencedFrameOwnerHostPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'remoteFrameInterfaces', 8,
        0,
        blink.mojom.RemoteFrameInterfacesFromRendererSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'frameToken', 16,
        0,
        blink.mojom.RemoteFrameTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'devtoolsFrameToken', 24,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
blink.mojom.LocalFrameHost_CreateFencedFrame_Params = class {
  constructor() {
    /** @export { !Object } */
    this.fencedFrame;
    /** @export { !blink.mojom.RemoteFrameInterfacesFromRenderer } */
    this.remoteFrameInterfaces;
    /** @export { !blink.mojom.RemoteFrameToken } */
    this.frameToken;
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.devtoolsFrameToken;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_ForwardFencedFrameEventAndUserActivationToEmbedder_ParamsSpec.$,
    'LocalFrameHost_ForwardFencedFrameEventAndUserActivationToEmbedder_Params',
    [
      mojo.internal.StructField(
        'eventType', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrameHost_ForwardFencedFrameEventAndUserActivationToEmbedder_Params = class {
  constructor() {
    /** @export { !string } */
    this.eventType;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_OnViewTransitionOptInChanged_ParamsSpec.$,
    'LocalFrameHost_OnViewTransitionOptInChanged_Params',
    [
      mojo.internal.StructField(
        'viewTransitionOptIn', 0,
        0,
        blink.mojom.ViewTransitionSameOriginOptInSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrameHost_OnViewTransitionOptInChanged_Params = class {
  constructor() {
    /** @export { !blink.mojom.ViewTransitionSameOriginOptIn } */
    this.viewTransitionOptIn;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_StartDragging_ParamsSpec.$,
    'LocalFrameHost_StartDragging_Params',
    [
      mojo.internal.StructField(
        'dragData', 0,
        0,
        blink.mojom.DragDataSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'operationsAllowed', 8,
        0,
        blink.mojom.AllowedDragOperationsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'image', 16,
        0,
        skia.mojom.BitmapN32Spec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cursorOffsetInDip', 24,
        0,
        gfx.mojom.Vector2dSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dragObjRectInDip', 32,
        0,
        gfx.mojom.RectSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'eventInfo', 40,
        0,
        blink.mojom.DragEventSourceInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);





/** @record */
blink.mojom.LocalFrameHost_StartDragging_Params = class {
  constructor() {
    /** @export { !blink.mojom.DragData } */
    this.dragData;
    /** @export { !blink.mojom.AllowedDragOperations } */
    this.operationsAllowed;
    /** @export { (skia.mojom.BitmapN32|undefined) } */
    this.image;
    /** @export { !gfx.mojom.Vector2d } */
    this.cursorOffsetInDip;
    /** @export { !gfx.mojom.Rect } */
    this.dragObjRectInDip;
    /** @export { !blink.mojom.DragEventSourceInfo } */
    this.eventInfo;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_IssueKeepAliveHandle_ParamsSpec.$,
    'LocalFrameHost_IssueKeepAliveHandle_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.NavigationStateKeepAliveHandlePendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrameHost_IssueKeepAliveHandle_Params = class {
  constructor() {
    /** @export { !blink.mojom.NavigationStateKeepAliveHandlePendingReceiver } */
    this.receiver;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_NotifyStorageAccessed_ParamsSpec.$,
    'LocalFrameHost_NotifyStorageAccessed_Params',
    [
      mojo.internal.StructField(
        'storageType', 0,
        0,
        blink.mojom.StorageTypeAccessedSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'blocked', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrameHost_NotifyStorageAccessed_Params = class {
  constructor() {
    /** @export { !blink.mojom.StorageTypeAccessed } */
    this.storageType;
    /** @export { !boolean } */
    this.blocked;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_RecordWindowProxyUsageMetrics_ParamsSpec.$,
    'LocalFrameHost_RecordWindowProxyUsageMetrics_Params',
    [
      mojo.internal.StructField(
        'targetFrameToken', 0,
        0,
        blink.mojom.FrameTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'accessType', 16,
        0,
        blink.mojom.WindowProxyAccessTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.LocalFrameHost_RecordWindowProxyUsageMetrics_Params = class {
  constructor() {
    /** @export { !blink.mojom.FrameToken } */
    this.targetFrameToken;
    /** @export { !blink.mojom.WindowProxyAccessType } */
    this.accessType;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_NotifyDocumentInteractive_ParamsSpec.$,
    'LocalFrameHost_NotifyDocumentInteractive_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalFrameHost_NotifyDocumentInteractive_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_SetStorageAccessApiStatus_ParamsSpec.$,
    'LocalFrameHost_SetStorageAccessApiStatus_Params',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        network.mojom.StorageAccessApiStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrameHost_SetStorageAccessApiStatus_Params = class {
  constructor() {
    /** @export { !network.mojom.StorageAccessApiStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_InitializeCrashReportStorage_ParamsSpec.$,
    'LocalFrameHost_InitializeCrashReportStorage_Params',
    [
      mojo.internal.StructField(
        'length', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrameHost_InitializeCrashReportStorage_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.length;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_InitializeCrashReportStorage_ResponseParamsSpec.$,
    'LocalFrameHost_InitializeCrashReportStorage_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalFrameHost_InitializeCrashReportStorage_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_SetCrashReportStorageKey_ParamsSpec.$,
    'LocalFrameHost_SetCrashReportStorageKey_Params',
    [
      mojo.internal.StructField(
        'key', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'value', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.LocalFrameHost_SetCrashReportStorageKey_Params = class {
  constructor() {
    /** @export { !string } */
    this.key;
    /** @export { !string } */
    this.value;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_SetCrashReportStorageKey_ResponseParamsSpec.$,
    'LocalFrameHost_SetCrashReportStorageKey_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalFrameHost_SetCrashReportStorageKey_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_RemoveCrashReportStorageKey_ParamsSpec.$,
    'LocalFrameHost_RemoveCrashReportStorageKey_Params',
    [
      mojo.internal.StructField(
        'key', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrameHost_RemoveCrashReportStorageKey_Params = class {
  constructor() {
    /** @export { !string } */
    this.key;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrameHost_RemoveCrashReportStorageKey_ResponseParamsSpec.$,
    'LocalFrameHost_RemoveCrashReportStorageKey_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalFrameHost_RemoveCrashReportStorageKey_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.NonAssociatedLocalFrameHost_MaybeStartOutermostMainFrameNavigation_ParamsSpec.$,
    'NonAssociatedLocalFrameHost_MaybeStartOutermostMainFrameNavigation_Params',
    [
      mojo.internal.StructField(
        'urls', 0,
        0,
        mojo.internal.Array(url.mojom.UrlSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.NonAssociatedLocalFrameHost_MaybeStartOutermostMainFrameNavigation_Params = class {
  constructor() {
    /** @export { !Array<!url.mojom.Url> } */
    this.urls;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_GetTextSurroundingSelection_ParamsSpec.$,
    'LocalFrame_GetTextSurroundingSelection_Params',
    [
      mojo.internal.StructField(
        'maxLength', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrame_GetTextSurroundingSelection_Params = class {
  constructor() {
    /** @export { !number } */
    this.maxLength;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_GetTextSurroundingSelection_ResponseParamsSpec.$,
    'LocalFrame_GetTextSurroundingSelection_ResponseParams',
    [
      mojo.internal.StructField(
        'content', 0,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'startOffset', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'endOffset', 12,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.LocalFrame_GetTextSurroundingSelection_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.String16 } */
    this.content;
    /** @export { !number } */
    this.startOffset;
    /** @export { !number } */
    this.endOffset;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_SendInterventionReport_ParamsSpec.$,
    'LocalFrame_SendInterventionReport_Params',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'message', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'childFrameToken', 16,
        0,
        blink.mojom.FrameTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
blink.mojom.LocalFrame_SendInterventionReport_Params = class {
  constructor() {
    /** @export { !string } */
    this.id;
    /** @export { !string } */
    this.message;
    /** @export { (blink.mojom.FrameToken|undefined) } */
    this.childFrameToken;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_SetFrameOwnerProperties_ParamsSpec.$,
    'LocalFrame_SetFrameOwnerProperties_Params',
    [
      mojo.internal.StructField(
        'properties', 0,
        0,
        blink.mojom.FrameOwnerPropertiesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrame_SetFrameOwnerProperties_Params = class {
  constructor() {
    /** @export { !blink.mojom.FrameOwnerProperties } */
    this.properties;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_NotifyUserActivation_ParamsSpec.$,
    'LocalFrame_NotifyUserActivation_Params',
    [
      mojo.internal.StructField(
        'notificationType', 0,
        0,
        blink.mojom.UserActivationNotificationTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrame_NotifyUserActivation_Params = class {
  constructor() {
    /** @export { !blink.mojom.UserActivationNotificationType } */
    this.notificationType;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_NotifyVirtualKeyboardOverlayRect_ParamsSpec.$,
    'LocalFrame_NotifyVirtualKeyboardOverlayRect_Params',
    [
      mojo.internal.StructField(
        'keyboardRect', 0,
        0,
        gfx.mojom.RectSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrame_NotifyVirtualKeyboardOverlayRect_Params = class {
  constructor() {
    /** @export { !gfx.mojom.Rect } */
    this.keyboardRect;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_ShowInterestInElement_ParamsSpec.$,
    'LocalFrame_ShowInterestInElement_Params',
    [
      mojo.internal.StructField(
        'nodeID', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrame_ShowInterestInElement_Params = class {
  constructor() {
    /** @export { !number } */
    this.nodeID;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_AddMessageToConsole_ParamsSpec.$,
    'LocalFrame_AddMessageToConsole_Params',
    [
      mojo.internal.StructField(
        'level', 0,
        0,
        blink.mojom.ConsoleMessageLevelSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'message', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'discardDuplicates', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.LocalFrame_AddMessageToConsole_Params = class {
  constructor() {
    /** @export { !blink.mojom.ConsoleMessageLevel } */
    this.level;
    /** @export { !string } */
    this.message;
    /** @export { !boolean } */
    this.discardDuplicates;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_SwapInImmediately_ParamsSpec.$,
    'LocalFrame_SwapInImmediately_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalFrame_SwapInImmediately_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_CheckCompleted_ParamsSpec.$,
    'LocalFrame_CheckCompleted_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalFrame_CheckCompleted_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_StopLoading_ParamsSpec.$,
    'LocalFrame_StopLoading_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalFrame_StopLoading_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_Collapse_ParamsSpec.$,
    'LocalFrame_Collapse_Params',
    [
      mojo.internal.StructField(
        'collapsed', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrame_Collapse_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.collapsed;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_EnableViewSourceMode_ParamsSpec.$,
    'LocalFrame_EnableViewSourceMode_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalFrame_EnableViewSourceMode_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_Focus_ParamsSpec.$,
    'LocalFrame_Focus_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalFrame_Focus_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_ClearFocusedElement_ParamsSpec.$,
    'LocalFrame_ClearFocusedElement_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalFrame_ClearFocusedElement_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_CopyImageAt_ParamsSpec.$,
    'LocalFrame_CopyImageAt_Params',
    [
      mojo.internal.StructField(
        'windowPoint', 0,
        0,
        gfx.mojom.PointSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrame_CopyImageAt_Params = class {
  constructor() {
    /** @export { !gfx.mojom.Point } */
    this.windowPoint;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_SaveImageAt_ParamsSpec.$,
    'LocalFrame_SaveImageAt_Params',
    [
      mojo.internal.StructField(
        'windowPoint', 0,
        0,
        gfx.mojom.PointSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrame_SaveImageAt_Params = class {
  constructor() {
    /** @export { !gfx.mojom.Point } */
    this.windowPoint;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_ReportBlinkFeatureUsage_ParamsSpec.$,
    'LocalFrame_ReportBlinkFeatureUsage_Params',
    [
      mojo.internal.StructField(
        'features', 0,
        0,
        mojo.internal.Array(blink.mojom.WebFeatureSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrame_ReportBlinkFeatureUsage_Params = class {
  constructor() {
    /** @export { !Array<!blink.mojom.WebFeature> } */
    this.features;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_RenderFallbackContent_ParamsSpec.$,
    'LocalFrame_RenderFallbackContent_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalFrame_RenderFallbackContent_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_BeforeUnload_ParamsSpec.$,
    'LocalFrame_BeforeUnload_Params',
    [
      mojo.internal.StructField(
        'isReload', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrame_BeforeUnload_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.isReload;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_BeforeUnload_ResponseParamsSpec.$,
    'LocalFrame_BeforeUnload_ResponseParams',
    [
      mojo.internal.StructField(
        'proceed', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'beforeUnloadStartTime', 8,
        0,
        mojoBase.mojom.TimeTicksSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'beforeUnloadEndTime', 16,
        0,
        mojoBase.mojom.TimeTicksSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.LocalFrame_BeforeUnload_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.proceed;
    /** @export { !mojoBase.mojom.TimeTicks } */
    this.beforeUnloadStartTime;
    /** @export { !mojoBase.mojom.TimeTicks } */
    this.beforeUnloadEndTime;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_MediaPlayerActionAt_ParamsSpec.$,
    'LocalFrame_MediaPlayerActionAt_Params',
    [
      mojo.internal.StructField(
        'location', 0,
        0,
        gfx.mojom.PointSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'action', 8,
        0,
        blink.mojom.MediaPlayerActionSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.LocalFrame_MediaPlayerActionAt_Params = class {
  constructor() {
    /** @export { !gfx.mojom.Point } */
    this.location;
    /** @export { !blink.mojom.MediaPlayerAction } */
    this.action;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_RequestVideoFrameAtWithBoundsHint_ParamsSpec.$,
    'LocalFrame_RequestVideoFrameAtWithBoundsHint_Params',
    [
      mojo.internal.StructField(
        'location', 0,
        0,
        gfx.mojom.PointSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'maxSize', 8,
        0,
        gfx.mojom.SizeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'maxArea', 16,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.LocalFrame_RequestVideoFrameAtWithBoundsHint_Params = class {
  constructor() {
    /** @export { !gfx.mojom.Point } */
    this.location;
    /** @export { !gfx.mojom.Size } */
    this.maxSize;
    /** @export { !number } */
    this.maxArea;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_RequestVideoFrameAtWithBoundsHint_ResponseParamsSpec.$,
    'LocalFrame_RequestVideoFrameAtWithBoundsHint_ResponseParams',
    [
      mojo.internal.StructField(
        'bitmap', 0,
        0,
        skia.mojom.BitmapN32Spec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'bounds', 8,
        0,
        gfx.mojom.RectSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.LocalFrame_RequestVideoFrameAtWithBoundsHint_ResponseParams = class {
  constructor() {
    /** @export { (skia.mojom.BitmapN32|undefined) } */
    this.bitmap;
    /** @export { !gfx.mojom.Rect } */
    this.bounds;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_PluginActionAt_ParamsSpec.$,
    'LocalFrame_PluginActionAt_Params',
    [
      mojo.internal.StructField(
        'location', 0,
        0,
        gfx.mojom.PointSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'action', 8,
        0,
        blink.mojom.PluginActionTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.LocalFrame_PluginActionAt_Params = class {
  constructor() {
    /** @export { !gfx.mojom.Point } */
    this.location;
    /** @export { !blink.mojom.PluginActionType } */
    this.action;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_AdvanceFocusInFrame_ParamsSpec.$,
    'LocalFrame_AdvanceFocusInFrame_Params',
    [
      mojo.internal.StructField(
        'focusType', 0,
        0,
        blink.mojom.FocusTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sourceFrameToken', 8,
        0,
        blink.mojom.RemoteFrameTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.LocalFrame_AdvanceFocusInFrame_Params = class {
  constructor() {
    /** @export { !blink.mojom.FocusType } */
    this.focusType;
    /** @export { (blink.mojom.RemoteFrameToken|undefined) } */
    this.sourceFrameToken;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_AdvanceFocusForIME_ParamsSpec.$,
    'LocalFrame_AdvanceFocusForIME_Params',
    [
      mojo.internal.StructField(
        'focusType', 0,
        0,
        blink.mojom.FocusTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrame_AdvanceFocusForIME_Params = class {
  constructor() {
    /** @export { !blink.mojom.FocusType } */
    this.focusType;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_ReportContentSecurityPolicyViolation_ParamsSpec.$,
    'LocalFrame_ReportContentSecurityPolicyViolation_Params',
    [
      mojo.internal.StructField(
        'violation', 0,
        0,
        network.mojom.CSPViolationSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrame_ReportContentSecurityPolicyViolation_Params = class {
  constructor() {
    /** @export { !network.mojom.CSPViolation } */
    this.violation;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_DidUpdateFramePolicy_ParamsSpec.$,
    'LocalFrame_DidUpdateFramePolicy_Params',
    [
      mojo.internal.StructField(
        'framePolicy', 0,
        0,
        blink.mojom.FramePolicySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrame_DidUpdateFramePolicy_Params = class {
  constructor() {
    /** @export { !blink.mojom.FramePolicy } */
    this.framePolicy;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_OnFrameVisibilityChanged_ParamsSpec.$,
    'LocalFrame_OnFrameVisibilityChanged_Params',
    [
      mojo.internal.StructField(
        'visibility', 0,
        0,
        blink.mojom.FrameVisibilitySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrame_OnFrameVisibilityChanged_Params = class {
  constructor() {
    /** @export { !blink.mojom.FrameVisibility } */
    this.visibility;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_PostMessageEvent_ParamsSpec.$,
    'LocalFrame_PostMessageEvent_Params',
    [
      mojo.internal.StructField(
        'sourceFrameToken', 0,
        0,
        blink.mojom.RemoteFrameTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sourceOrigin', 8,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'targetOrigin', 16,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'message', 24,
        0,
        blink.mojom.TransferableMessageSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
blink.mojom.LocalFrame_PostMessageEvent_Params = class {
  constructor() {
    /** @export { (blink.mojom.RemoteFrameToken|undefined) } */
    this.sourceFrameToken;
    /** @export { !mojoBase.mojom.String16 } */
    this.sourceOrigin;
    /** @export { !mojoBase.mojom.String16 } */
    this.targetOrigin;
    /** @export { !blink.mojom.TransferableMessage } */
    this.message;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_JavaScriptMethodExecuteRequest_ParamsSpec.$,
    'LocalFrame_JavaScriptMethodExecuteRequest_Params',
    [
      mojo.internal.StructField(
        'objectName', 0,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'methodName', 8,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'arguments', 16,
        0,
        mojoBase.mojom.ListValueSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'wantsResult', 24,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
blink.mojom.LocalFrame_JavaScriptMethodExecuteRequest_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.String16 } */
    this.objectName;
    /** @export { !mojoBase.mojom.String16 } */
    this.methodName;
    /** @export { !mojoBase.mojom.ListValue } */
    this.arguments;
    /** @export { !boolean } */
    this.wantsResult;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_JavaScriptMethodExecuteRequest_ResponseParamsSpec.$,
    'LocalFrame_JavaScriptMethodExecuteRequest_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojoBase.mojom.ValueSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.LocalFrame_JavaScriptMethodExecuteRequest_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.Value } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_JavaScriptExecuteRequest_ParamsSpec.$,
    'LocalFrame_JavaScriptExecuteRequest_Params',
    [
      mojo.internal.StructField(
        'javascript', 0,
        0,
        mojoBase.mojom.BigString16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'wantsResult', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.LocalFrame_JavaScriptExecuteRequest_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.BigString16 } */
    this.javascript;
    /** @export { !boolean } */
    this.wantsResult;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_JavaScriptExecuteRequest_ResponseParamsSpec.$,
    'LocalFrame_JavaScriptExecuteRequest_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojoBase.mojom.ValueSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.LocalFrame_JavaScriptExecuteRequest_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.Value } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_JavaScriptExecuteRequestForTests_ParamsSpec.$,
    'LocalFrame_JavaScriptExecuteRequestForTests_Params',
    [
      mojo.internal.StructField(
        'javascript', 0,
        0,
        mojoBase.mojom.BigString16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasUserGesture', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'resolvePromises', 8,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'honorJsContentSettings', 8,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'worldId', 12,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.LocalFrame_JavaScriptExecuteRequestForTests_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.BigString16 } */
    this.javascript;
    /** @export { !boolean } */
    this.hasUserGesture;
    /** @export { !boolean } */
    this.resolvePromises;
    /** @export { !boolean } */
    this.honorJsContentSettings;
    /** @export { !number } */
    this.worldId;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_JavaScriptExecuteRequestForTests_ResponseParamsSpec.$,
    'LocalFrame_JavaScriptExecuteRequestForTests_ResponseParams',
    [
      mojo.internal.StructField(
        'resultType', 0,
        0,
        blink.mojom.JavaScriptExecutionResultTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'result', 8,
        0,
        mojoBase.mojom.ValueSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.LocalFrame_JavaScriptExecuteRequestForTests_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.JavaScriptExecutionResultType } */
    this.resultType;
    /** @export { !mojoBase.mojom.Value } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ParamsSpec.$,
    'LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_Params',
    [
      mojo.internal.StructField(
        'javascript', 0,
        0,
        mojoBase.mojom.BigString16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'wantsResult', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'worldId', 12,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.BigString16 } */
    this.javascript;
    /** @export { !boolean } */
    this.wantsResult;
    /** @export { !number } */
    this.worldId;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ResponseParamsSpec.$,
    'LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojoBase.mojom.ValueSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.Value } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_JavaScriptAwaitPromiseInIsolatedWorld_ParamsSpec.$,
    'LocalFrame_JavaScriptAwaitPromiseInIsolatedWorld_Params',
    [
      mojo.internal.StructField(
        'javascript', 0,
        0,
        mojoBase.mojom.BigString16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'worldId', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.LocalFrame_JavaScriptAwaitPromiseInIsolatedWorld_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.BigString16 } */
    this.javascript;
    /** @export { !number } */
    this.worldId;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_JavaScriptAwaitPromiseInIsolatedWorld_ResponseParamsSpec.$,
    'LocalFrame_JavaScriptAwaitPromiseInIsolatedWorld_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojoBase.mojom.ValueSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.LocalFrame_JavaScriptAwaitPromiseInIsolatedWorld_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.Value } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_GetCharacterIndexAtPoint_ParamsSpec.$,
    'LocalFrame_GetCharacterIndexAtPoint_Params',
    [
      mojo.internal.StructField(
        'location', 0,
        0,
        gfx.mojom.PointSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrame_GetCharacterIndexAtPoint_Params = class {
  constructor() {
    /** @export { !gfx.mojom.Point } */
    this.location;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_GetFirstRectForRange_ParamsSpec.$,
    'LocalFrame_GetFirstRectForRange_Params',
    [
      mojo.internal.StructField(
        'range', 0,
        0,
        gfx.mojom.RangeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrame_GetFirstRectForRange_Params = class {
  constructor() {
    /** @export { !gfx.mojom.Range } */
    this.range;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_GetStringForRange_ParamsSpec.$,
    'LocalFrame_GetStringForRange_Params',
    [
      mojo.internal.StructField(
        'range', 0,
        0,
        gfx.mojom.RangeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrame_GetStringForRange_Params = class {
  constructor() {
    /** @export { !gfx.mojom.Range } */
    this.range;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_GetStringForRange_ResponseParamsSpec.$,
    'LocalFrame_GetStringForRange_ResponseParams',
    [
      mojo.internal.StructField(
        'string', 0,
        0,
        ui.mojom.AttributedStringSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'baselinePoint', 8,
        0,
        gfx.mojom.PointSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.LocalFrame_GetStringForRange_ResponseParams = class {
  constructor() {
    /** @export { (ui.mojom.AttributedString|undefined) } */
    this.string;
    /** @export { !gfx.mojom.Point } */
    this.baselinePoint;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_BindReportingObserver_ParamsSpec.$,
    'LocalFrame_BindReportingObserver_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.ReportingObserverPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrame_BindReportingObserver_Params = class {
  constructor() {
    /** @export { !blink.mojom.ReportingObserverPendingReceiver } */
    this.receiver;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_UpdateOpener_ParamsSpec.$,
    'LocalFrame_UpdateOpener_Params',
    [
      mojo.internal.StructField(
        'openerFrameToken', 0,
        0,
        blink.mojom.FrameTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.LocalFrame_UpdateOpener_Params = class {
  constructor() {
    /** @export { (blink.mojom.FrameToken|undefined) } */
    this.openerFrameToken;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_GetSavableResourceLinks_ParamsSpec.$,
    'LocalFrame_GetSavableResourceLinks_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalFrame_GetSavableResourceLinks_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_GetSavableResourceLinks_ResponseParamsSpec.$,
    'LocalFrame_GetSavableResourceLinks_ResponseParams',
    [
      mojo.internal.StructField(
        'reply', 0,
        0,
        blink.mojom.GetSavableResourceLinksReplySpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrame_GetSavableResourceLinks_ResponseParams = class {
  constructor() {
    /** @export { (blink.mojom.GetSavableResourceLinksReply|undefined) } */
    this.reply;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_MixedContentFound_ParamsSpec.$,
    'LocalFrame_MixedContentFound_Params',
    [
      mojo.internal.StructField(
        'mainResourceUrl', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mixedContentUrl', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requestContext', 16,
        0,
        blink.mojom.RequestContextTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'wasAllowed', 20,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'urlBeforeRedirects', 24,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hadRedirect', 20,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sourceLocation', 32,
        0,
        network.mojom.SourceLocationSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);





/** @record */
blink.mojom.LocalFrame_MixedContentFound_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.mainResourceUrl;
    /** @export { !url.mojom.Url } */
    this.mixedContentUrl;
    /** @export { !blink.mojom.RequestContextType } */
    this.requestContext;
    /** @export { !boolean } */
    this.wasAllowed;
    /** @export { !url.mojom.Url } */
    this.urlBeforeRedirects;
    /** @export { !boolean } */
    this.hadRedirect;
    /** @export { (network.mojom.SourceLocation|undefined) } */
    this.sourceLocation;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_BindDevToolsAgent_ParamsSpec.$,
    'LocalFrame_BindDevToolsAgent_Params',
    [
      mojo.internal.StructField(
        'agentHost', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(blink.mojom.DevToolsAgentHostRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'agent', 8,
        0,
        mojo.internal.AssociatedInterfaceRequest(blink.mojom.DevToolsAgentPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.LocalFrame_BindDevToolsAgent_Params = class {
  constructor() {
    /** @export { !Object } */
    this.agentHost;
    /** @export { !Object } */
    this.agent;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_ExtractAnnotatedText_ParamsSpec.$,
    'LocalFrame_ExtractAnnotatedText_Params',
    [
      mojo.internal.StructField(
        'charCountGoal', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrame_ExtractAnnotatedText_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.charCountGoal;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_ExtractAnnotatedText_ResponseParamsSpec.$,
    'LocalFrame_ExtractAnnotatedText_ResponseParams',
    [
      mojo.internal.StructField(
        'annotatedText', 0,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrame_ExtractAnnotatedText_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.String16 } */
    this.annotatedText;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_ExtractSerializedDom_ParamsSpec.$,
    'LocalFrame_ExtractSerializedDom_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalFrame_ExtractSerializedDom_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_ExtractSerializedDom_ResponseParamsSpec.$,
    'LocalFrame_ExtractSerializedDom_ResponseParams',
    [
      mojo.internal.StructField(
        'serializedDom', 0,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrame_ExtractSerializedDom_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.String16 } */
    this.serializedDom;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_ExtractSerializedDomElementInfo_ParamsSpec.$,
    'LocalFrame_ExtractSerializedDomElementInfo_Params',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrame_ExtractSerializedDomElementInfo_Params = class {
  constructor() {
    /** @export { !string } */
    this.id;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_ExtractSerializedDomElementInfo_ResponseParamsSpec.$,
    'LocalFrame_ExtractSerializedDomElementInfo_ResponseParams',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        blink.mojom.SerializedDomElementInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrame_ExtractSerializedDomElementInfo_ResponseParams = class {
  constructor() {
    /** @export { (blink.mojom.SerializedDomElementInfo|undefined) } */
    this.info;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_HandleRendererDebugURL_ParamsSpec.$,
    'LocalFrame_HandleRendererDebugURL_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrame_HandleRendererDebugURL_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_GetCanonicalUrlForSharing_ParamsSpec.$,
    'LocalFrame_GetCanonicalUrlForSharing_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalFrame_GetCanonicalUrlForSharing_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_GetCanonicalUrlForSharing_ResponseParamsSpec.$,
    'LocalFrame_GetCanonicalUrlForSharing_ResponseParams',
    [
      mojo.internal.StructField(
        'canonicalUrl', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrame_GetCanonicalUrlForSharing_ResponseParams = class {
  constructor() {
    /** @export { (url.mojom.Url|undefined) } */
    this.canonicalUrl;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_GetOpenGraphMetadata_ParamsSpec.$,
    'LocalFrame_GetOpenGraphMetadata_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalFrame_GetOpenGraphMetadata_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_GetOpenGraphMetadata_ResponseParamsSpec.$,
    'LocalFrame_GetOpenGraphMetadata_ResponseParams',
    [
      mojo.internal.StructField(
        'metadata', 0,
        0,
        blink.mojom.OpenGraphMetadataSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrame_GetOpenGraphMetadata_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.OpenGraphMetadata } */
    this.metadata;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_SetNavigationApiHistoryEntriesForRestore_ParamsSpec.$,
    'LocalFrame_SetNavigationApiHistoryEntriesForRestore_Params',
    [
      mojo.internal.StructField(
        'entryArrays', 0,
        0,
        blink.mojom.NavigationApiHistoryEntryArraysSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'restoreReason', 8,
        0,
        blink.mojom.NavigationApiEntryRestoreReasonSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.LocalFrame_SetNavigationApiHistoryEntriesForRestore_Params = class {
  constructor() {
    /** @export { !blink.mojom.NavigationApiHistoryEntryArrays } */
    this.entryArrays;
    /** @export { !blink.mojom.NavigationApiEntryRestoreReason } */
    this.restoreReason;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_UpdatePrerenderURL_ParamsSpec.$,
    'LocalFrame_UpdatePrerenderURL_Params',
    [
      mojo.internal.StructField(
        'matchedUrl', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrame_UpdatePrerenderURL_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.matchedUrl;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_UpdatePrerenderURL_ResponseParamsSpec.$,
    'LocalFrame_UpdatePrerenderURL_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalFrame_UpdatePrerenderURL_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_NotifyNavigationApiOfDisposedEntries_ParamsSpec.$,
    'LocalFrame_NotifyNavigationApiOfDisposedEntries_Params',
    [
      mojo.internal.StructField(
        'keys', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrame_NotifyNavigationApiOfDisposedEntries_Params = class {
  constructor() {
    /** @export { !Array<!string> } */
    this.keys;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_TraverseCancelled_ParamsSpec.$,
    'LocalFrame_TraverseCancelled_Params',
    [
      mojo.internal.StructField(
        'navigationApiKey', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reason', 8,
        0,
        blink.mojom.TraverseCancelledReasonSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.LocalFrame_TraverseCancelled_Params = class {
  constructor() {
    /** @export { !string } */
    this.navigationApiKey;
    /** @export { !blink.mojom.TraverseCancelledReason } */
    this.reason;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_DispatchNavigateEventForCrossDocumentTraversal_ParamsSpec.$,
    'LocalFrame_DispatchNavigateEventForCrossDocumentTraversal_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pageState', 8,
        0,
        mojoBase.mojom.ByteStringSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isBrowserInitiated', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.LocalFrame_DispatchNavigateEventForCrossDocumentTraversal_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !mojoBase.mojom.ByteString } */
    this.pageState;
    /** @export { !boolean } */
    this.isBrowserInitiated;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_SnapshotDocumentForViewTransition_ParamsSpec.$,
    'LocalFrame_SnapshotDocumentForViewTransition_Params',
    [
      mojo.internal.StructField(
        'transitionToken', 0,
        0,
        blink.mojom.ViewTransitionTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pageSwapEventParams', 8,
        0,
        blink.mojom.PageSwapEventParamsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.LocalFrame_SnapshotDocumentForViewTransition_Params = class {
  constructor() {
    /** @export { !blink.mojom.ViewTransitionToken } */
    this.transitionToken;
    /** @export { !blink.mojom.PageSwapEventParams } */
    this.pageSwapEventParams;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_SnapshotDocumentForViewTransition_ResponseParamsSpec.$,
    'LocalFrame_SnapshotDocumentForViewTransition_ResponseParams',
    [
      mojo.internal.StructField(
        'viewTransitionState', 0,
        0,
        blink.mojom.ViewTransitionStateSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrame_SnapshotDocumentForViewTransition_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.ViewTransitionState } */
    this.viewTransitionState;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_NotifyViewTransitionAbortedToOldDocument_ParamsSpec.$,
    'LocalFrame_NotifyViewTransitionAbortedToOldDocument_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalFrame_NotifyViewTransitionAbortedToOldDocument_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_DispatchPageSwap_ParamsSpec.$,
    'LocalFrame_DispatchPageSwap_Params',
    [
      mojo.internal.StructField(
        'pageSwapEventParams', 0,
        0,
        blink.mojom.PageSwapEventParamsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrame_DispatchPageSwap_Params = class {
  constructor() {
    /** @export { (blink.mojom.PageSwapEventParams|undefined) } */
    this.pageSwapEventParams;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_AddResourceTimingEntryForFailedSubframeNavigation_ParamsSpec.$,
    'LocalFrame_AddResourceTimingEntryForFailedSubframeNavigation_Params',
    [
      mojo.internal.StructField(
        'subframeToken', 0,
        0,
        blink.mojom.FrameTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'initialUrl', 16,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'startTime', 24,
        0,
        mojoBase.mojom.TimeTicksSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'redirectTime', 32,
        0,
        mojoBase.mojom.TimeTicksSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requestStart', 40,
        0,
        mojoBase.mojom.TimeTicksSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'responseStart', 48,
        0,
        mojoBase.mojom.TimeTicksSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'responseCode', 56,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mimeType', 64,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'loadTimingInfo', 72,
        0,
        network.mojom.LoadTimingInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'connectionInfo', 60,
        0,
        network.mojom.ConnectionInfoSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'alpnNegotiatedProtocol', 80,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isSecureTransport', 88,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isValidated', 88,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'normalizedServerTiming', 96,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'completionStatus', 104,
        0,
        network.mojom.URLLoaderCompletionStatusSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 120],]);





/** @record */
blink.mojom.LocalFrame_AddResourceTimingEntryForFailedSubframeNavigation_Params = class {
  constructor() {
    /** @export { !blink.mojom.FrameToken } */
    this.subframeToken;
    /** @export { !url.mojom.Url } */
    this.initialUrl;
    /** @export { !mojoBase.mojom.TimeTicks } */
    this.startTime;
    /** @export { !mojoBase.mojom.TimeTicks } */
    this.redirectTime;
    /** @export { !mojoBase.mojom.TimeTicks } */
    this.requestStart;
    /** @export { !mojoBase.mojom.TimeTicks } */
    this.responseStart;
    /** @export { !number } */
    this.responseCode;
    /** @export { !string } */
    this.mimeType;
    /** @export { !network.mojom.LoadTimingInfo } */
    this.loadTimingInfo;
    /** @export { !network.mojom.ConnectionInfo } */
    this.connectionInfo;
    /** @export { !string } */
    this.alpnNegotiatedProtocol;
    /** @export { !boolean } */
    this.isSecureTransport;
    /** @export { !boolean } */
    this.isValidated;
    /** @export { !string } */
    this.normalizedServerTiming;
    /** @export { !network.mojom.URLLoaderCompletionStatus } */
    this.completionStatus;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_GetScrollPosition_ParamsSpec.$,
    'LocalFrame_GetScrollPosition_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalFrame_GetScrollPosition_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalFrame_GetScrollPosition_ResponseParamsSpec.$,
    'LocalFrame_GetScrollPosition_ResponseParams',
    [
      mojo.internal.StructField(
        'scrollPosition', 0,
        0,
        gfx.mojom.PointSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalFrame_GetScrollPosition_ResponseParams = class {
  constructor() {
    /** @export { !gfx.mojom.Point } */
    this.scrollPosition;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalMainFrame_AnimateDoubleTapZoom_ParamsSpec.$,
    'LocalMainFrame_AnimateDoubleTapZoom_Params',
    [
      mojo.internal.StructField(
        'point', 0,
        0,
        gfx.mojom.PointSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'rect', 8,
        0,
        gfx.mojom.RectSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.LocalMainFrame_AnimateDoubleTapZoom_Params = class {
  constructor() {
    /** @export { !gfx.mojom.Point } */
    this.point;
    /** @export { !gfx.mojom.Rect } */
    this.rect;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalMainFrame_SetScaleFactor_ParamsSpec.$,
    'LocalMainFrame_SetScaleFactor_Params',
    [
      mojo.internal.StructField(
        'scale', 0,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalMainFrame_SetScaleFactor_Params = class {
  constructor() {
    /** @export { !number } */
    this.scale;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalMainFrame_ClosePage_ParamsSpec.$,
    'LocalMainFrame_ClosePage_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalMainFrame_ClosePage_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalMainFrame_ClosePage_ResponseParamsSpec.$,
    'LocalMainFrame_ClosePage_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalMainFrame_ClosePage_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalMainFrame_GetFullPageSize_ParamsSpec.$,
    'LocalMainFrame_GetFullPageSize_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalMainFrame_GetFullPageSize_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalMainFrame_GetFullPageSize_ResponseParamsSpec.$,
    'LocalMainFrame_GetFullPageSize_ResponseParams',
    [
      mojo.internal.StructField(
        'fullPageSize', 0,
        0,
        gfx.mojom.SizeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalMainFrame_GetFullPageSize_ResponseParams = class {
  constructor() {
    /** @export { !gfx.mojom.Size } */
    this.fullPageSize;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalMainFrame_SetInitialFocus_ParamsSpec.$,
    'LocalMainFrame_SetInitialFocus_Params',
    [
      mojo.internal.StructField(
        'reverse', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalMainFrame_SetInitialFocus_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.reverse;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalMainFrame_EnablePreferredSizeChangedMode_ParamsSpec.$,
    'LocalMainFrame_EnablePreferredSizeChangedMode_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalMainFrame_EnablePreferredSizeChangedMode_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalMainFrame_ZoomToFindInPageRect_ParamsSpec.$,
    'LocalMainFrame_ZoomToFindInPageRect_Params',
    [
      mojo.internal.StructField(
        'rectInRootFrame', 0,
        0,
        gfx.mojom.RectSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalMainFrame_ZoomToFindInPageRect_Params = class {
  constructor() {
    /** @export { !gfx.mojom.Rect } */
    this.rectInRootFrame;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalMainFrame_InstallCoopAccessMonitor_ParamsSpec.$,
    'LocalMainFrame_InstallCoopAccessMonitor_Params',
    [
      mojo.internal.StructField(
        'accessedWindow', 0,
        0,
        blink.mojom.FrameTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'coopReporterInfo', 16,
        0,
        network.mojom.CrossOriginOpenerPolicyReporterParamsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.LocalMainFrame_InstallCoopAccessMonitor_Params = class {
  constructor() {
    /** @export { !blink.mojom.FrameToken } */
    this.accessedWindow;
    /** @export { !network.mojom.CrossOriginOpenerPolicyReporterParams } */
    this.coopReporterInfo;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalMainFrame_UpdateBrowserControlsState_ParamsSpec.$,
    'LocalMainFrame_UpdateBrowserControlsState_Params',
    [
      mojo.internal.StructField(
        'constraints', 0,
        0,
        cc.mojom.BrowserControlsStateSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'current', 4,
        0,
        cc.mojom.BrowserControlsStateSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'animate', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'offsetTagModifications', 16,
        0,
        cc.mojom.BrowserControlsOffsetTagModificationsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.LocalMainFrame_UpdateBrowserControlsState_Params = class {
  constructor() {
    /** @export { !cc.mojom.BrowserControlsState } */
    this.constraints;
    /** @export { !cc.mojom.BrowserControlsState } */
    this.current;
    /** @export { !boolean } */
    this.animate;
    /** @export { (cc.mojom.BrowserControlsOffsetTagModifications|undefined) } */
    this.offsetTagModifications;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalMainFrame_SetV8CompileHints_ParamsSpec.$,
    'LocalMainFrame_SetV8CompileHints_Params',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojoBase.mojom.ReadOnlySharedMemoryRegionSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalMainFrame_SetV8CompileHints_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.ReadOnlySharedMemoryRegion } */
    this.data;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalMainFrame_Discard_ParamsSpec.$,
    'LocalMainFrame_Discard_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalMainFrame_Discard_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalMainFrame_Discard_ResponseParamsSpec.$,
    'LocalMainFrame_Discard_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalMainFrame_Discard_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalMainFrame_FinalizeNavigationConfidence_ParamsSpec.$,
    'LocalMainFrame_FinalizeNavigationConfidence_Params',
    [
      mojo.internal.StructField(
        'randomizedTriggerRate', 0,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'confidence', 8,
        0,
        blink.mojom.ConfidenceLevelSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.LocalMainFrame_FinalizeNavigationConfidence_Params = class {
  constructor() {
    /** @export { !number } */
    this.randomizedTriggerRate;
    /** @export { !blink.mojom.ConfidenceLevel } */
    this.confidence;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalMainFrameHost_ScaleFactorChanged_ParamsSpec.$,
    'LocalMainFrameHost_ScaleFactorChanged_Params',
    [
      mojo.internal.StructField(
        'scale', 0,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalMainFrameHost_ScaleFactorChanged_Params = class {
  constructor() {
    /** @export { !number } */
    this.scale;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalMainFrameHost_ContentsPreferredSizeChanged_ParamsSpec.$,
    'LocalMainFrameHost_ContentsPreferredSizeChanged_Params',
    [
      mojo.internal.StructField(
        'prefSize', 0,
        0,
        gfx.mojom.SizeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalMainFrameHost_ContentsPreferredSizeChanged_Params = class {
  constructor() {
    /** @export { !gfx.mojom.Size } */
    this.prefSize;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalMainFrameHost_TextAutosizerPageInfoChanged_ParamsSpec.$,
    'LocalMainFrameHost_TextAutosizerPageInfoChanged_Params',
    [
      mojo.internal.StructField(
        'pageInfo', 0,
        0,
        blink.mojom.TextAutosizerPageInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalMainFrameHost_TextAutosizerPageInfoChanged_Params = class {
  constructor() {
    /** @export { !blink.mojom.TextAutosizerPageInfo } */
    this.pageInfo;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalMainFrameHost_FocusPage_ParamsSpec.$,
    'LocalMainFrameHost_FocusPage_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalMainFrameHost_FocusPage_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalMainFrameHost_TakeFocus_ParamsSpec.$,
    'LocalMainFrameHost_TakeFocus_Params',
    [
      mojo.internal.StructField(
        'reverse', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalMainFrameHost_TakeFocus_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.reverse;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalMainFrameHost_UpdateTargetURL_ParamsSpec.$,
    'LocalMainFrameHost_UpdateTargetURL_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalMainFrameHost_UpdateTargetURL_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalMainFrameHost_UpdateTargetURL_ResponseParamsSpec.$,
    'LocalMainFrameHost_UpdateTargetURL_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalMainFrameHost_UpdateTargetURL_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalMainFrameHost_RequestClose_ParamsSpec.$,
    'LocalMainFrameHost_RequestClose_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalMainFrameHost_RequestClose_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalMainFrameHost_ShowCreatedWindow_ParamsSpec.$,
    'LocalMainFrameHost_ShowCreatedWindow_Params',
    [
      mojo.internal.StructField(
        'openerFrameToken', 0,
        0,
        blink.mojom.LocalFrameTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'disposition', 8,
        0,
        ui.mojom.WindowOpenDispositionSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'windowFeatures', 16,
        0,
        blink.mojom.WindowFeaturesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'openedByUserGesture', 12,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.LocalMainFrameHost_ShowCreatedWindow_Params = class {
  constructor() {
    /** @export { !blink.mojom.LocalFrameToken } */
    this.openerFrameToken;
    /** @export { !ui.mojom.WindowOpenDisposition } */
    this.disposition;
    /** @export { !blink.mojom.WindowFeatures } */
    this.windowFeatures;
    /** @export { !boolean } */
    this.openedByUserGesture;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalMainFrameHost_ShowCreatedWindow_ResponseParamsSpec.$,
    'LocalMainFrameHost_ShowCreatedWindow_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalMainFrameHost_ShowCreatedWindow_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalMainFrameHost_SetWindowRect_ParamsSpec.$,
    'LocalMainFrameHost_SetWindowRect_Params',
    [
      mojo.internal.StructField(
        'bounds', 0,
        0,
        gfx.mojom.RectSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalMainFrameHost_SetWindowRect_Params = class {
  constructor() {
    /** @export { !gfx.mojom.Rect } */
    this.bounds;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalMainFrameHost_SetWindowRect_ResponseParamsSpec.$,
    'LocalMainFrameHost_SetWindowRect_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalMainFrameHost_SetWindowRect_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalMainFrameHost_DidFirstVisuallyNonEmptyPaint_ParamsSpec.$,
    'LocalMainFrameHost_DidFirstVisuallyNonEmptyPaint_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalMainFrameHost_DidFirstVisuallyNonEmptyPaint_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalMainFrameHost_DidAccessInitialMainDocument_ParamsSpec.$,
    'LocalMainFrameHost_DidAccessInitialMainDocument_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalMainFrameHost_DidAccessInitialMainDocument_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalMainFrameHost_Maximize_ParamsSpec.$,
    'LocalMainFrameHost_Maximize_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalMainFrameHost_Maximize_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalMainFrameHost_Minimize_ParamsSpec.$,
    'LocalMainFrameHost_Minimize_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalMainFrameHost_Minimize_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalMainFrameHost_Restore_ParamsSpec.$,
    'LocalMainFrameHost_Restore_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalMainFrameHost_Restore_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LocalMainFrameHost_SetResizable_ParamsSpec.$,
    'LocalMainFrameHost_SetResizable_Params',
    [
      mojo.internal.StructField(
        'resizable', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalMainFrameHost_SetResizable_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.resizable;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalMainFrameHost_DraggableRegionsChanged_ParamsSpec.$,
    'LocalMainFrameHost_DraggableRegionsChanged_Params',
    [
      mojo.internal.StructField(
        'regions', 0,
        0,
        mojo.internal.Array(blink.mojom.DraggableRegionSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LocalMainFrameHost_DraggableRegionsChanged_Params = class {
  constructor() {
    /** @export { !Array<!blink.mojom.DraggableRegion> } */
    this.regions;
  }
};



mojo.internal.Struct(
    blink.mojom.LocalMainFrameHost_OnFirstContentfulPaint_ParamsSpec.$,
    'LocalMainFrameHost_OnFirstContentfulPaint_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.LocalMainFrameHost_OnFirstContentfulPaint_Params = class {
  constructor() {
  }
};

