// third_party/blink/public/mojom/frame/frame.mojom-blink-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_MOJOM_BLINK_TEST_UTILS_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_MOJOM_BLINK_TEST_UTILS_H_

#include "third_party/blink/public/mojom/frame/frame.mojom-blink.h"
#include "third_party/blink/renderer/core/core_export.h"


namespace blink::mojom::blink {


class CORE_EXPORT LocalFrameHostInterceptorForTesting : public LocalFrameHost {
  virtual LocalFrameHost* GetForwardingInterface() = 0;
  void EnterFullscreen(::blink::mojom::blink::FullscreenOptionsPtr options, EnterFullscreenCallback callback) override;
  void ExitFullscreen() override;
  void FullscreenStateChanged(bool is_fullscreen, ::blink::mojom::blink::FullscreenOptionsPtr options) override;
  void RegisterProtocolHandler(const ::blink::String& scheme, const ::blink::KURL& url, bool user_gesture) override;
  void UnregisterProtocolHandler(const ::blink::String& scheme, const ::blink::KURL& url, bool user_gesture) override;
  void DidDisplayInsecureContent() override;
  void DidContainInsecureFormAction() override;
  void MainDocumentElementAvailable(bool uses_temporary_zoom_level) override;
  void SetNeedsOcclusionTracking(bool needs_tracking) override;
  void SetVirtualKeyboardMode(::ui::mojom::blink::VirtualKeyboardMode type) override;
  void VisibilityChanged(::blink::mojom::blink::FrameVisibility visibility) override;
  void DidChangeThemeColor(std::optional<::SkColor> theme_color) override;
  void DidChangeBackgroundColor(const ::SkColor4f& background_color, bool color_adjust) override;
  void DidFailLoadWithError(const ::blink::KURL& url, int32_t error_code) override;
  void DidFocusFrame() override;
  void DidCallFocus() override;
  void EnforceInsecureRequestPolicy(::blink::mojom::blink::InsecureRequestPolicy policy_bitmap) override;
  void EnforceInsecureNavigationsSet(const ::blink::Vector<uint32_t>& set) override;
  void SuddenTerminationDisablerChanged(bool present, ::blink::mojom::blink::SuddenTerminationDisablerType disabler_type) override;
  void HadStickyUserActivationBeforeNavigationChanged(bool has_gesture) override;
  void ScrollRectToVisibleInParentFrame(const ::gfx::RectF& rect_to_scroll, ::blink::mojom::blink::ScrollIntoViewParamsPtr params) override;
  void BubbleLogicalScrollInParentFrame(::blink::mojom::blink::ScrollDirection direction, ::ui::ScrollGranularity granularity) override;
  void StartLoadingForAsyncNavigationApiCommit() override;
  void DidBlockNavigation(const ::blink::KURL& blocked_url, ::blink::mojom::blink::NavigationBlockedReason reason) override;
  void DidChangeLoadProgress(double load_progress) override;
  void DidFinishLoad(const ::blink::KURL& validated_url) override;
  void DispatchLoad() override;
  void GoToEntryAtOffset(int32_t offset, bool has_user_gesture, ::base::TimeTicks actual_navigation_start, std::optional<::blink::scheduler::TaskAttributionId> soft_navigation_heuristics_task_id) override;
  void NavigateToNavigationApiKey(const ::blink::String& key, bool has_user_gesture, ::base::TimeTicks actual_navigation_start, std::optional<::blink::scheduler::TaskAttributionId> soft_navigation_heuristics_task_id) override;
  void NavigateEventHandlerPresenceChanged(bool present) override;
  void UpdateTitle(const ::blink::String& title, ::base::i18n::TextDirection title_direction) override;
  void UpdateApplicationTitle(const ::blink::String& application_title) override;
  void UpdateUserActivationState(::blink::mojom::blink::UserActivationUpdateType update_type, ::blink::mojom::blink::UserActivationNotificationType notification_type) override;
  void DidConsumeHistoryUserActivation() override;
  void HandleAccessibilityFindInPageResult(FindInPageResultAXParamsPtr params) override;
  void HandleAccessibilityFindInPageTermination() override;
  void DocumentOnLoadCompleted() override;
  void ForwardResourceTimingToParent(::blink::mojom::blink::ResourceTimingInfoPtr timing) override;
  void DidDispatchDOMContentLoadedEvent() override;
  void RunModalAlertDialog(const ::blink::String& alert_message, bool disable_third_party_subframe_suppresion, RunModalAlertDialogCallback callback) override;
  void RunModalConfirmDialog(const ::blink::String& alert_message, bool disable_third_party_subframe_suppresion, RunModalConfirmDialogCallback callback) override;
  void RunModalPromptDialog(const ::blink::String& alert_message, const ::blink::String& default_value, bool disable_third_party_subframe_suppresion, RunModalPromptDialogCallback callback) override;
  void RunBeforeUnloadConfirm(bool is_reload, RunBeforeUnloadConfirmCallback callback) override;
  void UpdateFaviconURL(::blink::Vector<::blink::mojom::blink::FaviconURLPtr> favicon_urls) override;
  void DownloadURL(DownloadURLParamsPtr params) override;
  void FocusedElementChanged(bool is_editable_element, bool is_richly_editable_element, const ::gfx::Rect& bounds_in_frame_widget, ::blink::mojom::blink::FocusType focus_type) override;
  void TextSelectionChanged(const ::blink::String& text, uint32_t offset, const ::gfx::Range& range) override;
  void ShowPopupMenu(::mojo::PendingRemote<::blink::mojom::blink::PopupMenuClient> popup_client, const ::gfx::Rect& bounds, double font_size, int32_t selected_item, ::blink::Vector<::blink::mojom::blink::MenuItemPtr> menu_items, bool right_aligned, bool allow_multiple_selection) override;
  void CreateNewPopupWidget(::mojo::PendingAssociatedReceiver<::blink::mojom::blink::PopupWidgetHost> popup_host, ::mojo::PendingAssociatedReceiver<::blink::mojom::blink::WidgetHost> blink_widget_host, ::mojo::PendingAssociatedRemote<::blink::mojom::blink::Widget> blink_widget) override;
  void ShowContextMenu(::mojo::PendingAssociatedRemote<::blink::mojom::blink::ContextMenuClient> client, const ::blink::UntrustworthyContextMenuParams& params) override;
  void DidLoadResourceFromMemoryCache(const ::blink::KURL& url, const ::blink::String& http_method, const ::blink::String& mime_type, ::network::mojom::blink::RequestDestination request_destination, bool include_credentials) override;
  void DidChangeFrameOwnerProperties(const ::blink::FrameToken& child_frame_token, ::blink::mojom::blink::FrameOwnerPropertiesPtr frame_owner_properties) override;
  void DidChangeOpener(const std::optional<::blink::LocalFrameToken>& opener_frame) override;
  void DidChangeFramePolicy(const ::blink::FrameToken& child_frame_token, const ::blink::FramePolicy& frame_policy) override;
  void DidChangeIframeAttributes(const ::blink::FrameToken& child_frame_token, IframeAttributesPtr attributes) override;
  void CapturePaintPreviewOfSubframe(const ::gfx::Rect& clip_rect, const ::base::UnguessableToken& guid) override;
  void SetCloseListener(::mojo::PendingRemote<::blink::mojom::blink::CloseListener> listener) override;
  void Detach() override;
  void GetKeepAliveHandleFactory(::mojo::PendingReceiver<::blink::mojom::blink::KeepAliveHandleFactory> factory) override;
  void DidAddMessageToConsole(::blink::mojom::blink::ConsoleMessageLevel log_level, const ::blink::String& msg, uint32_t line_number, const ::blink::String& source_id, const ::blink::String& untrusted_stack_trace) override;
  void FrameSizeChanged(const ::gfx::Size& size) override;
  void DidInferColorScheme(::blink::mojom::blink::PreferredColorScheme color_scheme) override;
  void DidChangeSrcDoc(const ::blink::FrameToken& child_frame_token, const ::blink::String& srcdoc_value) override;
  void ReceivedDelegatedCapability(::blink::mojom::blink::DelegatedCapability delegated_capability) override;
  void SendFencedFrameReportingBeacon(const ::blink::String& event_data, const ::blink::String& event_type, const ::blink::Vector<::blink::FencedFrame::ReportingDestination>& destinations, bool cross_origin_exposed) override;
  void SendFencedFrameReportingBeaconToCustomURL(const ::blink::KURL& destination_url, bool cross_origin_exposed) override;
  void DisableUntrustedNetworkInFencedFrame(DisableUntrustedNetworkInFencedFrameCallback callback) override;
  void ExemptUrlFromNetworkRevocationForTesting(const ::blink::KURL& exempted_url, ExemptUrlFromNetworkRevocationForTestingCallback callback) override;
  void SendLegacyTechEvent(const ::blink::String& type, LegacyTechEventCodeLocationPtr code_location) override;
  void SetFencedFrameAutomaticBeaconReportEventData(::blink::mojom::blink::AutomaticBeaconType event_type, const ::blink::String& event_data, const ::blink::Vector<::blink::FencedFrame::ReportingDestination>& destinations, bool once, bool cross_origin_exposed) override;
  void SendPrivateAggregationRequestsForFencedFrameEvent(const ::blink::String& event_type) override;
  void CreateFencedFrame(::mojo::PendingAssociatedReceiver<::blink::mojom::blink::FencedFrameOwnerHost> fenced_frame, ::blink::mojom::blink::RemoteFrameInterfacesFromRendererPtr remote_frame_interfaces, const ::blink::RemoteFrameToken& frame_token, const ::base::UnguessableToken& devtools_frame_token) override;
  void ForwardFencedFrameEventAndUserActivationToEmbedder(const ::blink::String& event_type) override;
  void OnViewTransitionOptInChanged(ViewTransitionSameOriginOptIn view_transition_opt_in) override;
  void StartDragging(const ::blink::WebDragData& drag_data, ::blink::DragOperationsMask operations_allowed, const ::SkBitmap& image, const ::gfx::Vector2d& cursor_offset_in_dip, const ::gfx::Rect& drag_obj_rect_in_dip, ::blink::mojom::blink::DragEventSourceInfoPtr event_info) override;
  void IssueKeepAliveHandle(::mojo::PendingReceiver<::blink::mojom::blink::NavigationStateKeepAliveHandle> receiver) override;
  void NotifyStorageAccessed(StorageTypeAccessed storageType, bool blocked) override;
  void RecordWindowProxyUsageMetrics(const ::blink::FrameToken& target_frame_token, WindowProxyAccessType access_type) override;
  void NotifyDocumentInteractive() override;
  void SetStorageAccessApiStatus(::net::StorageAccessApiStatus status) override;
  void InitializeCrashReportStorage(uint64_t length, InitializeCrashReportStorageCallback callback) override;
  void SetCrashReportStorageKey(const ::blink::String& key, const ::blink::String& value, SetCrashReportStorageKeyCallback callback) override;
  void RemoveCrashReportStorageKey(const ::blink::String& key, RemoveCrashReportStorageKeyCallback callback) override;
};
class CORE_EXPORT LocalFrameHostAsyncWaiter {
 public:
  explicit LocalFrameHostAsyncWaiter(LocalFrameHost* proxy);

  LocalFrameHostAsyncWaiter(const LocalFrameHostAsyncWaiter&) = delete;
  LocalFrameHostAsyncWaiter& operator=(const LocalFrameHostAsyncWaiter&) = delete;

  ~LocalFrameHostAsyncWaiter();
  void EnterFullscreen(
      ::blink::mojom::blink::FullscreenOptionsPtr options, bool* out_granted);
  bool EnterFullscreen(::blink::mojom::blink::FullscreenOptionsPtr options);
  void RunModalAlertDialog(
      const ::blink::String& alert_message, bool disable_third_party_subframe_suppresion);
  
  void RunModalConfirmDialog(
      const ::blink::String& alert_message, bool disable_third_party_subframe_suppresion, bool* out_success);
  bool RunModalConfirmDialog(const ::blink::String& alert_message, bool disable_third_party_subframe_suppresion);
  void RunModalPromptDialog(
      const ::blink::String& alert_message, const ::blink::String& default_value, bool disable_third_party_subframe_suppresion, bool* out_success, ::blink::String* out_result);
  
  void RunBeforeUnloadConfirm(
      bool is_reload, bool* out_success);
  bool RunBeforeUnloadConfirm(bool is_reload);
  void DisableUntrustedNetworkInFencedFrame(
      );
  
  void ExemptUrlFromNetworkRevocationForTesting(
      const ::blink::KURL& exempted_url);
  
  void InitializeCrashReportStorage(
      uint64_t length);
  
  void SetCrashReportStorageKey(
      const ::blink::String& key, const ::blink::String& value);
  
  void RemoveCrashReportStorageKey(
      const ::blink::String& key);
  

 private:
  LocalFrameHost* const proxy_;
};


class CORE_EXPORT NonAssociatedLocalFrameHostInterceptorForTesting : public NonAssociatedLocalFrameHost {
  virtual NonAssociatedLocalFrameHost* GetForwardingInterface() = 0;
  void MaybeStartOutermostMainFrameNavigation(const ::blink::Vector<::blink::KURL>& urls) override;
};
class CORE_EXPORT NonAssociatedLocalFrameHostAsyncWaiter {
 public:
  explicit NonAssociatedLocalFrameHostAsyncWaiter(NonAssociatedLocalFrameHost* proxy);

  NonAssociatedLocalFrameHostAsyncWaiter(const NonAssociatedLocalFrameHostAsyncWaiter&) = delete;
  NonAssociatedLocalFrameHostAsyncWaiter& operator=(const NonAssociatedLocalFrameHostAsyncWaiter&) = delete;

  ~NonAssociatedLocalFrameHostAsyncWaiter();

 private:
  NonAssociatedLocalFrameHost* const proxy_;
};


class CORE_EXPORT LocalFrameInterceptorForTesting : public LocalFrame {
  virtual LocalFrame* GetForwardingInterface() = 0;
  void GetTextSurroundingSelection(uint32_t max_length, GetTextSurroundingSelectionCallback callback) override;
  void SendInterventionReport(const ::blink::String& id, const ::blink::String& message, const std::optional<::blink::FrameToken>& child_frame_token) override;
  void SetFrameOwnerProperties(::blink::mojom::blink::FrameOwnerPropertiesPtr properties) override;
  void NotifyUserActivation(::blink::mojom::blink::UserActivationNotificationType notification_type) override;
  void NotifyVirtualKeyboardOverlayRect(const ::gfx::Rect& keyboard_rect) override;
  void ShowInterestInElement(int32_t nodeID) override;
  void AddMessageToConsole(::blink::mojom::blink::ConsoleMessageLevel level, const ::blink::String& message, bool discard_duplicates) override;
  void SwapInImmediately() override;
  void CheckCompleted() override;
  void StopLoading() override;
  void Collapse(bool collapsed) override;
  void EnableViewSourceMode() override;
  void Focus() override;
  void ClearFocusedElement() override;
  void CopyImageAt(const ::gfx::Point& window_point) override;
  void SaveImageAt(const ::gfx::Point& window_point) override;
  void ReportBlinkFeatureUsage(const ::blink::Vector<::blink::mojom::blink::WebFeature>& features) override;
  void RenderFallbackContent() override;
  void BeforeUnload(bool is_reload, BeforeUnloadCallback callback) override;
  void MediaPlayerActionAt(const ::gfx::Point& location, ::blink::mojom::blink::MediaPlayerActionPtr action) override;
  void RequestVideoFrameAtWithBoundsHint(const ::gfx::Point& location, const ::gfx::Size& max_size, int32_t max_area, RequestVideoFrameAtWithBoundsHintCallback callback) override;
  void PluginActionAt(const ::gfx::Point& location, PluginActionType action) override;
  void AdvanceFocusInFrame(::blink::mojom::blink::FocusType focus_type, const std::optional<::blink::RemoteFrameToken>& source_frame_token) override;
  void AdvanceFocusForIME(::blink::mojom::blink::FocusType focus_type) override;
  void ReportContentSecurityPolicyViolation(::network::mojom::blink::CSPViolationPtr violation) override;
  void DidUpdateFramePolicy(const ::blink::FramePolicy& frame_policy) override;
  void OnFrameVisibilityChanged(::blink::mojom::blink::FrameVisibility visibility) override;
  void PostMessageEvent(const std::optional<::blink::RemoteFrameToken>& source_frame_token, const ::blink::String& source_origin, const ::blink::String& target_origin, ::blink::BlinkTransferableMessage message) override;
  void JavaScriptMethodExecuteRequest(const ::blink::String& object_name, const ::blink::String& method_name, ::base::Value::List arguments, bool wants_result, JavaScriptMethodExecuteRequestCallback callback) override;
  void JavaScriptExecuteRequest(const ::blink::String& javascript, bool wants_result, JavaScriptExecuteRequestCallback callback) override;
  void JavaScriptExecuteRequestForTests(const ::blink::String& javascript, bool has_user_gesture, bool resolve_promises, bool honor_js_content_settings, int32_t world_id, JavaScriptExecuteRequestForTestsCallback callback) override;
  void JavaScriptExecuteRequestInIsolatedWorld(const ::blink::String& javascript, bool wants_result, int32_t world_id, JavaScriptExecuteRequestInIsolatedWorldCallback callback) override;
  void JavaScriptAwaitPromiseInIsolatedWorld(const ::blink::String& javascript, int32_t world_id, JavaScriptAwaitPromiseInIsolatedWorldCallback callback) override;
  void GetCharacterIndexAtPoint(const ::gfx::Point& location) override;
  void GetFirstRectForRange(const ::gfx::Range& range) override;
  void GetStringForRange(const ::gfx::Range& range, GetStringForRangeCallback callback) override;
  void BindReportingObserver(::mojo::PendingReceiver<::blink::mojom::blink::ReportingObserver> receiver) override;
  void UpdateOpener(const std::optional<::blink::FrameToken>& opener_frame_token) override;
  void GetSavableResourceLinks(GetSavableResourceLinksCallback callback) override;
  void MixedContentFound(const ::blink::KURL& main_resource_url, const ::blink::KURL& mixed_content_url, ::blink::mojom::blink::RequestContextType request_context, bool was_allowed, const ::blink::KURL& url_before_redirects, bool had_redirect, ::network::mojom::blink::SourceLocationPtr source_location) override;
  void BindDevToolsAgent(::mojo::PendingAssociatedRemote<::blink::mojom::blink::DevToolsAgentHost> agent_host, ::mojo::PendingAssociatedReceiver<::blink::mojom::blink::DevToolsAgent> agent) override;
  void ExtractAnnotatedText(uint64_t char_count_goal, ExtractAnnotatedTextCallback callback) override;
  void ExtractSerializedDom(ExtractSerializedDomCallback callback) override;
  void ExtractSerializedDomElementInfo(const ::blink::String& id, ExtractSerializedDomElementInfoCallback callback) override;
  void HandleRendererDebugURL(const ::blink::KURL& url) override;
  void GetCanonicalUrlForSharing(GetCanonicalUrlForSharingCallback callback) override;
  void GetOpenGraphMetadata(GetOpenGraphMetadataCallback callback) override;
  void SetNavigationApiHistoryEntriesForRestore(::blink::mojom::blink::NavigationApiHistoryEntryArraysPtr entry_arrays, NavigationApiEntryRestoreReason restore_reason) override;
  void UpdatePrerenderURL(const ::blink::KURL& matched_url, UpdatePrerenderURLCallback callback) override;
  void NotifyNavigationApiOfDisposedEntries(const ::blink::Vector<::blink::String>& keys) override;
  void TraverseCancelled(const ::blink::String& navigation_api_key, TraverseCancelledReason reason) override;
  void DispatchNavigateEventForCrossDocumentTraversal(const ::blink::KURL& url, const std::string& page_state, bool is_browser_initiated) override;
  void SnapshotDocumentForViewTransition(const ::blink::ViewTransitionToken& transition_token, ::blink::mojom::blink::PageSwapEventParamsPtr page_swap_event_params, SnapshotDocumentForViewTransitionCallback callback) override;
  void NotifyViewTransitionAbortedToOldDocument() override;
  void DispatchPageSwap(::blink::mojom::blink::PageSwapEventParamsPtr page_swap_event_params) override;
  void AddResourceTimingEntryForFailedSubframeNavigation(const ::blink::FrameToken& subframe_token, const ::blink::KURL& initial_url, ::base::TimeTicks start_time, ::base::TimeTicks redirect_time, ::base::TimeTicks request_start, ::base::TimeTicks response_start, uint32_t response_code, const ::blink::String& mime_type, ::network::mojom::blink::LoadTimingInfoPtr load_timing_info, ::net::HttpConnectionInfo connection_info, const ::blink::String& alpn_negotiated_protocol, bool is_secure_transport, bool is_validated, const ::blink::String& normalized_server_timing, const ::network::URLLoaderCompletionStatus& completion_status) override;
  void GetScrollPosition(GetScrollPositionCallback callback) override;
};
class CORE_EXPORT LocalFrameAsyncWaiter {
 public:
  explicit LocalFrameAsyncWaiter(LocalFrame* proxy);

  LocalFrameAsyncWaiter(const LocalFrameAsyncWaiter&) = delete;
  LocalFrameAsyncWaiter& operator=(const LocalFrameAsyncWaiter&) = delete;

  ~LocalFrameAsyncWaiter();
  void GetTextSurroundingSelection(
      uint32_t max_length, ::blink::String* out_content, uint32_t* out_start_offset, uint32_t* out_end_offset);
  
  void BeforeUnload(
      bool is_reload, bool* out_proceed, ::base::TimeTicks* out_before_unload_start_time, ::base::TimeTicks* out_before_unload_end_time);
  
  void RequestVideoFrameAtWithBoundsHint(
      const ::gfx::Point& location, const ::gfx::Size& max_size, int32_t max_area, ::SkBitmap* out_bitmap, ::gfx::Rect* out_bounds);
  
  void JavaScriptMethodExecuteRequest(
      const ::blink::String& object_name, const ::blink::String& method_name, ::base::Value::List arguments, bool wants_result, ::base::Value* out_result);
  ::base::Value JavaScriptMethodExecuteRequest(const ::blink::String& object_name, const ::blink::String& method_name, ::base::Value::List arguments, bool wants_result);
  void JavaScriptExecuteRequest(
      const ::blink::String& javascript, bool wants_result, ::base::Value* out_result);
  ::base::Value JavaScriptExecuteRequest(const ::blink::String& javascript, bool wants_result);
  void JavaScriptExecuteRequestForTests(
      const ::blink::String& javascript, bool has_user_gesture, bool resolve_promises, bool honor_js_content_settings, int32_t world_id, JavaScriptExecutionResultType* out_result_type, ::base::Value* out_result);
  
  void JavaScriptExecuteRequestInIsolatedWorld(
      const ::blink::String& javascript, bool wants_result, int32_t world_id, ::base::Value* out_result);
  ::base::Value JavaScriptExecuteRequestInIsolatedWorld(const ::blink::String& javascript, bool wants_result, int32_t world_id);
  void JavaScriptAwaitPromiseInIsolatedWorld(
      const ::blink::String& javascript, int32_t world_id, ::base::Value* out_result);
  ::base::Value JavaScriptAwaitPromiseInIsolatedWorld(const ::blink::String& javascript, int32_t world_id);
  void GetStringForRange(
      const ::gfx::Range& range, ::ui::mojom::blink::AttributedStringPtr* out_string, ::gfx::Point* out_baseline_point);
  
  void GetSavableResourceLinks(
      GetSavableResourceLinksReplyPtr* out_reply);
  GetSavableResourceLinksReplyPtr GetSavableResourceLinks();
  void ExtractAnnotatedText(
      uint64_t char_count_goal, ::blink::String* out_annotated_text);
  ::blink::String ExtractAnnotatedText(uint64_t char_count_goal);
  void ExtractSerializedDom(
      ::blink::String* out_serialized_dom);
  ::blink::String ExtractSerializedDom();
  void ExtractSerializedDomElementInfo(
      const ::blink::String& id, SerializedDomElementInfoPtr* out_info);
  SerializedDomElementInfoPtr ExtractSerializedDomElementInfo(const ::blink::String& id);
  void GetCanonicalUrlForSharing(
      std::optional<::blink::KURL>* out_canonical_url);
  std::optional<::blink::KURL> GetCanonicalUrlForSharing();
  void GetOpenGraphMetadata(
      ::blink::mojom::blink::OpenGraphMetadataPtr* out_metadata);
  ::blink::mojom::blink::OpenGraphMetadataPtr GetOpenGraphMetadata();
  void UpdatePrerenderURL(
      const ::blink::KURL& matched_url);
  
  void SnapshotDocumentForViewTransition(
      const ::blink::ViewTransitionToken& transition_token, ::blink::mojom::blink::PageSwapEventParamsPtr page_swap_event_params, ::blink::ViewTransitionState* out_view_transition_state);
  ::blink::ViewTransitionState SnapshotDocumentForViewTransition(const ::blink::ViewTransitionToken& transition_token, ::blink::mojom::blink::PageSwapEventParamsPtr page_swap_event_params);
  void GetScrollPosition(
      ::gfx::Point* out_scroll_position);
  ::gfx::Point GetScrollPosition();

 private:
  LocalFrame* const proxy_;
};


class CORE_EXPORT LocalMainFrameInterceptorForTesting : public LocalMainFrame {
  virtual LocalMainFrame* GetForwardingInterface() = 0;
  void AnimateDoubleTapZoom(const ::gfx::Point& point, const ::gfx::Rect& rect) override;
  void SetScaleFactor(float scale) override;
  void ClosePage(ClosePageCallback callback) override;
  void GetFullPageSize(GetFullPageSizeCallback callback) override;
  void SetInitialFocus(bool reverse) override;
  void EnablePreferredSizeChangedMode() override;
  void ZoomToFindInPageRect(const ::gfx::Rect& rect_in_root_frame) override;
  void InstallCoopAccessMonitor(const ::blink::FrameToken& accessed_window, ::network::mojom::blink::CrossOriginOpenerPolicyReporterParamsPtr coop_reporter_info) override;
  void UpdateBrowserControlsState(::cc::BrowserControlsState constraints, ::cc::BrowserControlsState current, bool animate, const std::optional<::cc::BrowserControlsOffsetTagModifications>& offset_tag_modifications) override;
  void SetV8CompileHints(::base::ReadOnlySharedMemoryRegion data) override;
  void Discard(DiscardCallback callback) override;
  void FinalizeNavigationConfidence(double randomized_trigger_rate, ::blink::mojom::blink::ConfidenceLevel confidence) override;
};
class CORE_EXPORT LocalMainFrameAsyncWaiter {
 public:
  explicit LocalMainFrameAsyncWaiter(LocalMainFrame* proxy);

  LocalMainFrameAsyncWaiter(const LocalMainFrameAsyncWaiter&) = delete;
  LocalMainFrameAsyncWaiter& operator=(const LocalMainFrameAsyncWaiter&) = delete;

  ~LocalMainFrameAsyncWaiter();
  void ClosePage(
      );
  
  void GetFullPageSize(
      ::gfx::Size* out_full_page_size);
  ::gfx::Size GetFullPageSize();
  void Discard(
      );
  

 private:
  LocalMainFrame* const proxy_;
};


class CORE_EXPORT LocalMainFrameHostInterceptorForTesting : public LocalMainFrameHost {
  virtual LocalMainFrameHost* GetForwardingInterface() = 0;
  void ScaleFactorChanged(float scale) override;
  void ContentsPreferredSizeChanged(const ::gfx::Size& pref_size) override;
  void TextAutosizerPageInfoChanged(::blink::mojom::blink::TextAutosizerPageInfoPtr page_info) override;
  void FocusPage() override;
  void TakeFocus(bool reverse) override;
  void UpdateTargetURL(const ::blink::KURL& url, UpdateTargetURLCallback callback) override;
  void RequestClose() override;
  void ShowCreatedWindow(const ::blink::LocalFrameToken& opener_frame_token, ::ui::mojom::blink::WindowOpenDisposition disposition, ::blink::mojom::blink::WindowFeaturesPtr window_features, bool opened_by_user_gesture, ShowCreatedWindowCallback callback) override;
  void SetWindowRect(const ::gfx::Rect& bounds, SetWindowRectCallback callback) override;
  void DidFirstVisuallyNonEmptyPaint() override;
  void DidAccessInitialMainDocument() override;
  void Maximize() override;
  void Minimize() override;
  void Restore() override;
  void SetResizable(bool resizable) override;
  void DraggableRegionsChanged(::blink::Vector<::blink::mojom::blink::DraggableRegionPtr> regions) override;
  void OnFirstContentfulPaint() override;
};
class CORE_EXPORT LocalMainFrameHostAsyncWaiter {
 public:
  explicit LocalMainFrameHostAsyncWaiter(LocalMainFrameHost* proxy);

  LocalMainFrameHostAsyncWaiter(const LocalMainFrameHostAsyncWaiter&) = delete;
  LocalMainFrameHostAsyncWaiter& operator=(const LocalMainFrameHostAsyncWaiter&) = delete;

  ~LocalMainFrameHostAsyncWaiter();
  void UpdateTargetURL(
      const ::blink::KURL& url);
  
  void ShowCreatedWindow(
      const ::blink::LocalFrameToken& opener_frame_token, ::ui::mojom::blink::WindowOpenDisposition disposition, ::blink::mojom::blink::WindowFeaturesPtr window_features, bool opened_by_user_gesture);
  
  void SetWindowRect(
      const ::gfx::Rect& bounds);
  

 private:
  LocalMainFrameHost* const proxy_;
};




}  // blink::mojom::blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_MOJOM_BLINK_TEST_UTILS_H_