// third_party/blink/public/mojom/frame/back_forward_cache_controller.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  RendererEvictionReason as blink_mojom_RendererEvictionReason,
  RendererEvictionReasonSpec as blink_mojom_RendererEvictionReasonSpec
} from '../navigation/renderer_eviction_reason.mojom.m.js';

import {
  WebSchedulerTrackedFeature as blink_mojom_WebSchedulerTrackedFeature,
  WebSchedulerTrackedFeatureSpec as blink_mojom_WebSchedulerTrackedFeatureSpec
} from '../scheduler/web_scheduler_tracked_feature.mojom.m.js';

import {
  ScriptSourceLocation as blink_mojom_ScriptSourceLocation,
  ScriptSourceLocationSpec as blink_mojom_ScriptSourceLocationSpec
} from '../script_source_location.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class BackForwardCacheControllerHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.BackForwardCacheControllerHost', scope);
  }
}

/** @interface */
export class BackForwardCacheControllerHostInterface {
  
  /**
   * @param { !blink_mojom_RendererEvictionReason } reason
   * @param { ?blink_mojom_ScriptSourceLocation } source
   */

  evictFromBackForwardCache(reason, source) {}
  
  /**
   * @param { !Array<!BlockingDetails> } details
   */

  didChangeBackForwardCacheDisablingFeatures(details) {}
}

/**
 * @implements { BackForwardCacheControllerHostInterface }
 */
export class BackForwardCacheControllerHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!BackForwardCacheControllerHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          BackForwardCacheControllerHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!BackForwardCacheControllerHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink_mojom_RendererEvictionReason } reason
   * @param { ?blink_mojom_ScriptSourceLocation } source
   */

  evictFromBackForwardCache(
      reason,
      source) {
    this.proxy.sendMessage(
        0,
        BackForwardCacheControllerHost_EvictFromBackForwardCache_ParamsSpec.$,
        null,
        [
          reason,
          source
        ],
        false);
  }

  
  /**
   * @param { !Array<!BlockingDetails> } details
   */

  didChangeBackForwardCacheDisablingFeatures(
      details) {
    this.proxy.sendMessage(
        1,
        BackForwardCacheControllerHost_DidChangeBackForwardCacheDisablingFeatures_ParamsSpec.$,
        null,
        [
          details
        ],
        false);
  }
}

/**
 * An object which receives request messages for the BackForwardCacheControllerHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class BackForwardCacheControllerHostReceiver {
  /**
   * @param {!BackForwardCacheControllerHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!BackForwardCacheControllerHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        BackForwardCacheControllerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!BackForwardCacheControllerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        BackForwardCacheControllerHost_EvictFromBackForwardCache_ParamsSpec.$,
        null,
        impl.evictFromBackForwardCache.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        BackForwardCacheControllerHost_DidChangeBackForwardCacheDisablingFeatures_ParamsSpec.$,
        null,
        impl.didChangeBackForwardCacheDisablingFeatures.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class BackForwardCacheControllerHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.BackForwardCacheControllerHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!BackForwardCacheControllerHostRemote}
   */
  static getRemote() {
    let remote = new BackForwardCacheControllerHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the BackForwardCacheControllerHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class BackForwardCacheControllerHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      BackForwardCacheControllerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!BackForwardCacheControllerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.evictFromBackForwardCache =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        BackForwardCacheControllerHost_EvictFromBackForwardCache_ParamsSpec.$,
        null,
        this.evictFromBackForwardCache.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didChangeBackForwardCacheDisablingFeatures =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        BackForwardCacheControllerHost_DidChangeBackForwardCacheDisablingFeatures_ParamsSpec.$,
        null,
        this.didChangeBackForwardCacheDisablingFeatures.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BlockingDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BackForwardCacheControllerHost_EvictFromBackForwardCache_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BackForwardCacheControllerHost_DidChangeBackForwardCacheDisablingFeatures_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    BlockingDetailsSpec.$,
    'BlockingDetails',
    [
      mojo.internal.StructField(
        'feature', 0,
        0,
        blink_mojom_WebSchedulerTrackedFeatureSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'source', 8,
        0,
        blink_mojom_ScriptSourceLocationSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class BlockingDetails {
  constructor() {
    /** @type { !blink_mojom_WebSchedulerTrackedFeature } */
    this.feature;
    /** @type { (blink_mojom_ScriptSourceLocation|undefined) } */
    this.source;
  }
}



mojo.internal.Struct(
    BackForwardCacheControllerHost_EvictFromBackForwardCache_ParamsSpec.$,
    'BackForwardCacheControllerHost_EvictFromBackForwardCache_Params',
    [
      mojo.internal.StructField(
        'reason', 0,
        0,
        blink_mojom_RendererEvictionReasonSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'source', 8,
        0,
        blink_mojom_ScriptSourceLocationSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class BackForwardCacheControllerHost_EvictFromBackForwardCache_Params {
  constructor() {
    /** @type { !blink_mojom_RendererEvictionReason } */
    this.reason;
    /** @type { (blink_mojom_ScriptSourceLocation|undefined) } */
    this.source;
  }
}



mojo.internal.Struct(
    BackForwardCacheControllerHost_DidChangeBackForwardCacheDisablingFeatures_ParamsSpec.$,
    'BackForwardCacheControllerHost_DidChangeBackForwardCacheDisablingFeatures_Params',
    [
      mojo.internal.StructField(
        'details', 0,
        0,
        mojo.internal.Array(BlockingDetailsSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class BackForwardCacheControllerHost_DidChangeBackForwardCacheDisablingFeatures_Params {
  constructor() {
    /** @type { !Array<!BlockingDetails> } */
    this.details;
  }
}

