// third_party/blink/public/mojom/frame/back_forward_cache_controller.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('blink.mojom.RendererEvictionReason');
goog.require('blink.mojom.WebSchedulerTrackedFeature');
goog.require('blink.mojom.ScriptSourceLocation');






goog.provide('blink.mojom.BackForwardCacheControllerHost');
goog.provide('blink.mojom.BackForwardCacheControllerHostReceiver');
goog.provide('blink.mojom.BackForwardCacheControllerHostCallbackRouter');
goog.provide('blink.mojom.BackForwardCacheControllerHostInterface');
goog.provide('blink.mojom.BackForwardCacheControllerHostRemote');
goog.provide('blink.mojom.BackForwardCacheControllerHostPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.BackForwardCacheControllerHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.BackForwardCacheControllerHost.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.BackForwardCacheControllerHostInterface = class {
  
  /**
   * @param { !blink.mojom.RendererEvictionReason } reason
   * @param { ?blink.mojom.ScriptSourceLocation } source
   */

  evictFromBackForwardCache(reason, source) {}
  
  /**
   * @param { !Array<!blink.mojom.BlockingDetails> } details
   */

  didChangeBackForwardCacheDisablingFeatures(details) {}
};

/**
 * @export
 * @implements { blink.mojom.BackForwardCacheControllerHostInterface }
 */
blink.mojom.BackForwardCacheControllerHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.BackForwardCacheControllerHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.BackForwardCacheControllerHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.BackForwardCacheControllerHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.RendererEvictionReason } reason
   * @param { ?blink.mojom.ScriptSourceLocation } source
   */

  evictFromBackForwardCache(
      reason,
      source) {
    this.proxy.sendMessage(
        0,
        blink.mojom.BackForwardCacheControllerHost_EvictFromBackForwardCache_ParamsSpec.$,
        null,
        [
          reason,
          source
        ],
        false);
  }

  
  /**
   * @param { !Array<!blink.mojom.BlockingDetails> } details
   */

  didChangeBackForwardCacheDisablingFeatures(
      details) {
    this.proxy.sendMessage(
        1,
        blink.mojom.BackForwardCacheControllerHost_DidChangeBackForwardCacheDisablingFeatures_ParamsSpec.$,
        null,
        [
          details
        ],
        false);
  }
};

/**
 * An object which receives request messages for the BackForwardCacheControllerHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.BackForwardCacheControllerHostReceiver = class {
  /**
   * @param {!blink.mojom.BackForwardCacheControllerHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.BackForwardCacheControllerHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.BackForwardCacheControllerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.BackForwardCacheControllerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.BackForwardCacheControllerHost_EvictFromBackForwardCache_ParamsSpec.$,
        null,
        impl.evictFromBackForwardCache.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.BackForwardCacheControllerHost_DidChangeBackForwardCacheDisablingFeatures_ParamsSpec.$,
        null,
        impl.didChangeBackForwardCacheDisablingFeatures.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.BackForwardCacheControllerHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.BackForwardCacheControllerHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.BackForwardCacheControllerHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.BackForwardCacheControllerHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the BackForwardCacheControllerHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.BackForwardCacheControllerHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.BackForwardCacheControllerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.BackForwardCacheControllerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.evictFromBackForwardCache =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.BackForwardCacheControllerHost_EvictFromBackForwardCache_ParamsSpec.$,
        null,
        this.evictFromBackForwardCache.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didChangeBackForwardCacheDisablingFeatures =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.BackForwardCacheControllerHost_DidChangeBackForwardCacheDisablingFeatures_ParamsSpec.$,
        null,
        this.didChangeBackForwardCacheDisablingFeatures.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.BlockingDetailsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BlockingDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.BackForwardCacheControllerHost_EvictFromBackForwardCache_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BackForwardCacheControllerHost_EvictFromBackForwardCache_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.BackForwardCacheControllerHost_DidChangeBackForwardCacheDisablingFeatures_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BackForwardCacheControllerHost_DidChangeBackForwardCacheDisablingFeatures_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.BlockingDetailsSpec.$,
    'BlockingDetails',
    [
      mojo.internal.StructField(
        'feature', 0,
        0,
        blink.mojom.WebSchedulerTrackedFeatureSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'source', 8,
        0,
        blink.mojom.ScriptSourceLocationSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.BlockingDetails');

/** @record */
blink.mojom.BlockingDetails = class {
  constructor() {
    /** @export { !blink.mojom.WebSchedulerTrackedFeature } */
    this.feature;
    /** @export { (blink.mojom.ScriptSourceLocation|undefined) } */
    this.source;
  }
};



mojo.internal.Struct(
    blink.mojom.BackForwardCacheControllerHost_EvictFromBackForwardCache_ParamsSpec.$,
    'BackForwardCacheControllerHost_EvictFromBackForwardCache_Params',
    [
      mojo.internal.StructField(
        'reason', 0,
        0,
        blink.mojom.RendererEvictionReasonSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'source', 8,
        0,
        blink.mojom.ScriptSourceLocationSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.BackForwardCacheControllerHost_EvictFromBackForwardCache_Params');

/** @record */
blink.mojom.BackForwardCacheControllerHost_EvictFromBackForwardCache_Params = class {
  constructor() {
    /** @export { !blink.mojom.RendererEvictionReason } */
    this.reason;
    /** @export { (blink.mojom.ScriptSourceLocation|undefined) } */
    this.source;
  }
};



mojo.internal.Struct(
    blink.mojom.BackForwardCacheControllerHost_DidChangeBackForwardCacheDisablingFeatures_ParamsSpec.$,
    'BackForwardCacheControllerHost_DidChangeBackForwardCacheDisablingFeatures_Params',
    [
      mojo.internal.StructField(
        'details', 0,
        0,
        mojo.internal.Array(blink.mojom.BlockingDetailsSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.BackForwardCacheControllerHost_DidChangeBackForwardCacheDisablingFeatures_Params');

/** @record */
blink.mojom.BackForwardCacheControllerHost_DidChangeBackForwardCacheDisablingFeatures_Params = class {
  constructor() {
    /** @export { !Array<!blink.mojom.BlockingDetails> } */
    this.details;
  }
};

