// third_party/blink/public/mojom/filesystem/file_system.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  DirectoryEntry as filesystem_mojom_DirectoryEntry,
  DirectoryEntrySpec as filesystem_mojom_DirectoryEntrySpec
} from '../../../../../components/services/filesystem/public/mojom/types.mojom.m.js';

import {
  FileError as mojoBase_mojom_FileError,
  FileErrorSpec as mojoBase_mojom_FileErrorSpec
} from '../../../../../mojo/public/mojom/base/file_error.mojom.m.js';

import {
  FileInfo as mojoBase_mojom_FileInfo,
  FileInfoSpec as mojoBase_mojom_FileInfoSpec
} from '../../../../../mojo/public/mojom/base/file_info.mojom.m.js';

import {
  FilePath as mojoBase_mojom_FilePath,
  FilePathSpec as mojoBase_mojom_FilePathSpec
} from '../../../../../mojo/public/mojom/base/file_path.mojom.m.js';

import {
  Time as mojoBase_mojom_Time,
  TimeSpec as mojoBase_mojom_TimeSpec
} from '../../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  Origin as url_mojom_Origin,
  OriginSpec as url_mojom_OriginSpec
} from '../../../../../url/mojom/origin.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';

import {
  BlobRemote as blink_mojom_BlobRemote,
  BlobPendingReceiver as blink_mojom_BlobPendingReceiver
} from '../blob/blob.mojom.m.js';

import {
  SerializedBlob as blink_mojom_SerializedBlob,
  SerializedBlobSpec as blink_mojom_SerializedBlobSpec
} from '../blob/serialized_blob.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const FileSystemTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const FileSystemType = {
  
  kTemporary: 0,
  kPersistent: 1,
  kIsolated: 2,
  kExternal: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class FileSystemCancellableOperationPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.FileSystemCancellableOperation', scope);
  }
}

/** @interface */
export class FileSystemCancellableOperationInterface {
  
  /**
   * @return {!Promise<{
        errorCode: !mojoBase_mojom_FileError,
   *  }>}
   */

  cancel() {}
}

/**
 * @implements { FileSystemCancellableOperationInterface }
 */
export class FileSystemCancellableOperationRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!FileSystemCancellableOperationPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          FileSystemCancellableOperationPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!FileSystemCancellableOperationPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        errorCode: !mojoBase_mojom_FileError,
   *  }>}
   */

  cancel() {
    return this.proxy.sendMessage(
        0,
        FileSystemCancellableOperation_Cancel_ParamsSpec.$,
        FileSystemCancellableOperation_Cancel_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the FileSystemCancellableOperation
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class FileSystemCancellableOperationReceiver {
  /**
   * @param {!FileSystemCancellableOperationInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!FileSystemCancellableOperationRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        FileSystemCancellableOperationRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FileSystemCancellableOperationRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        FileSystemCancellableOperation_Cancel_ParamsSpec.$,
        FileSystemCancellableOperation_Cancel_ResponseParamsSpec.$,
        impl.cancel.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class FileSystemCancellableOperation {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FileSystemCancellableOperation";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!FileSystemCancellableOperationRemote}
   */
  static getRemote() {
    let remote = new FileSystemCancellableOperationRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the FileSystemCancellableOperation
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class FileSystemCancellableOperationCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      FileSystemCancellableOperationRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FileSystemCancellableOperationRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        FileSystemCancellableOperation_Cancel_ParamsSpec.$,
        FileSystemCancellableOperation_Cancel_ResponseParamsSpec.$,
        this.cancel.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class FileSystemOperationListenerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.FileSystemOperationListener', scope);
  }
}

/** @interface */
export class FileSystemOperationListenerInterface {
  
  /**
   * @param { !Array<!filesystem_mojom_DirectoryEntry> } entries
   * @param { !boolean } hasMore
   */

  resultsRetrieved(entries, hasMore) {}
  
  /**
   * @param { !bigint } byteCount
   * @param { !boolean } complete
   */

  didWrite(byteCount, complete) {}
  
  /**
   * @param { !mojoBase_mojom_FileError } errorCode
   */

  errorOccurred(errorCode) {}
}

/**
 * @implements { FileSystemOperationListenerInterface }
 */
export class FileSystemOperationListenerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!FileSystemOperationListenerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          FileSystemOperationListenerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!FileSystemOperationListenerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!filesystem_mojom_DirectoryEntry> } entries
   * @param { !boolean } hasMore
   */

  resultsRetrieved(
      entries,
      hasMore) {
    this.proxy.sendMessage(
        0,
        FileSystemOperationListener_ResultsRetrieved_ParamsSpec.$,
        null,
        [
          entries,
          hasMore
        ],
        false);
  }

  
  /**
   * @param { !bigint } byteCount
   * @param { !boolean } complete
   */

  didWrite(
      byteCount,
      complete) {
    this.proxy.sendMessage(
        1,
        FileSystemOperationListener_DidWrite_ParamsSpec.$,
        null,
        [
          byteCount,
          complete
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_FileError } errorCode
   */

  errorOccurred(
      errorCode) {
    this.proxy.sendMessage(
        2,
        FileSystemOperationListener_ErrorOccurred_ParamsSpec.$,
        null,
        [
          errorCode
        ],
        false);
  }
}

/**
 * An object which receives request messages for the FileSystemOperationListener
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class FileSystemOperationListenerReceiver {
  /**
   * @param {!FileSystemOperationListenerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!FileSystemOperationListenerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        FileSystemOperationListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FileSystemOperationListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        FileSystemOperationListener_ResultsRetrieved_ParamsSpec.$,
        null,
        impl.resultsRetrieved.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        FileSystemOperationListener_DidWrite_ParamsSpec.$,
        null,
        impl.didWrite.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        FileSystemOperationListener_ErrorOccurred_ParamsSpec.$,
        null,
        impl.errorOccurred.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class FileSystemOperationListener {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FileSystemOperationListener";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!FileSystemOperationListenerRemote}
   */
  static getRemote() {
    let remote = new FileSystemOperationListenerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the FileSystemOperationListener
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class FileSystemOperationListenerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      FileSystemOperationListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FileSystemOperationListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resultsRetrieved =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        FileSystemOperationListener_ResultsRetrieved_ParamsSpec.$,
        null,
        this.resultsRetrieved.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didWrite =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        FileSystemOperationListener_DidWrite_ParamsSpec.$,
        null,
        this.didWrite.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.errorOccurred =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        FileSystemOperationListener_ErrorOccurred_ParamsSpec.$,
        null,
        this.errorOccurred.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ReceivedSnapshotListenerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.ReceivedSnapshotListener', scope);
  }
}

/** @interface */
export class ReceivedSnapshotListenerInterface {
  
  /**
   */

  didReceiveSnapshotFile() {}
}

/**
 * @implements { ReceivedSnapshotListenerInterface }
 */
export class ReceivedSnapshotListenerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ReceivedSnapshotListenerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ReceivedSnapshotListenerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ReceivedSnapshotListenerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  didReceiveSnapshotFile() {
    this.proxy.sendMessage(
        0,
        ReceivedSnapshotListener_DidReceiveSnapshotFile_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ReceivedSnapshotListener
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ReceivedSnapshotListenerReceiver {
  /**
   * @param {!ReceivedSnapshotListenerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ReceivedSnapshotListenerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ReceivedSnapshotListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ReceivedSnapshotListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ReceivedSnapshotListener_DidReceiveSnapshotFile_ParamsSpec.$,
        null,
        impl.didReceiveSnapshotFile.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ReceivedSnapshotListener {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ReceivedSnapshotListener";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ReceivedSnapshotListenerRemote}
   */
  static getRemote() {
    let remote = new ReceivedSnapshotListenerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ReceivedSnapshotListener
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ReceivedSnapshotListenerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ReceivedSnapshotListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ReceivedSnapshotListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didReceiveSnapshotFile =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ReceivedSnapshotListener_DidReceiveSnapshotFile_ParamsSpec.$,
        null,
        this.didReceiveSnapshotFile.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class FileSystemManagerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.FileSystemManager', scope);
  }
}

/** @interface */
export class FileSystemManagerInterface {
  
  /**
   * @param { !url_mojom_Origin } origin
   * @param { !FileSystemType } fileSystemType
   * @return {!Promise<{
        name: !string,
        rootUrl: !url_mojom_Url,
        errorCode: !mojoBase_mojom_FileError,
   *  }>}
   */

  open(origin, fileSystemType) {}
  
  /**
   * @param { !url_mojom_Url } filesystemUrl
   * @return {!Promise<{
        info: !FileSystemInfo,
        filePath: !mojoBase_mojom_FilePath,
        isDirectory: !boolean,
        errorCode: !mojoBase_mojom_FileError,
   *  }>}
   */

  resolveURL(filesystemUrl) {}
  
  /**
   * @param { !url_mojom_Url } srcPath
   * @param { !url_mojom_Url } destPath
   * @return {!Promise<{
        errorCode: !mojoBase_mojom_FileError,
   *  }>}
   */

  move(srcPath, destPath) {}
  
  /**
   * @param { !url_mojom_Url } srcPath
   * @param { !url_mojom_Url } destPath
   * @return {!Promise<{
        errorCode: !mojoBase_mojom_FileError,
   *  }>}
   */

  copy(srcPath, destPath) {}
  
  /**
   * @param { !url_mojom_Url } path
   * @param { !boolean } recursive
   * @return {!Promise<{
        errorCode: !mojoBase_mojom_FileError,
   *  }>}
   */

  remove(path, recursive) {}
  
  /**
   * @param { !url_mojom_Url } path
   * @return {!Promise<{
        fileInfo: !mojoBase_mojom_FileInfo,
        errorCode: !mojoBase_mojom_FileError,
   *  }>}
   */

  readMetadata(path) {}
  
  /**
   * @param { !url_mojom_Url } path
   * @param { !boolean } exclusive
   * @param { !boolean } isDirectory
   * @param { !boolean } recursive
   * @return {!Promise<{
        errorCode: !mojoBase_mojom_FileError,
   *  }>}
   */

  create(path, exclusive, isDirectory, recursive) {}
  
  /**
   * @param { !url_mojom_Url } path
   * @param { !boolean } isDirectory
   * @return {!Promise<{
        errorCode: !mojoBase_mojom_FileError,
   *  }>}
   */

  exists(path, isDirectory) {}
  
  /**
   * @param { !url_mojom_Url } path
   * @param { !FileSystemOperationListenerRemote } listener
   */

  readDirectory(path, listener) {}
  
  /**
   * @param { !url_mojom_Url } path
   * @return {!Promise<{
        entries: !Array<!filesystem_mojom_DirectoryEntry>,
        errorCode: !mojoBase_mojom_FileError,
   *  }>}
   */

  readDirectorySync(path) {}
  
  /**
   * @param { !url_mojom_Url } filePath
   * @param { !blink_mojom_BlobRemote } blob
   * @param { !bigint } position
   * @param { !FileSystemCancellableOperationPendingReceiver } opReceiver
   * @param { !FileSystemOperationListenerRemote } listener
   */

  write(filePath, blob, position, opReceiver, listener) {}
  
  /**
   * @param { !url_mojom_Url } filePath
   * @param { !blink_mojom_BlobRemote } blob
   * @param { !bigint } position
   * @return {!Promise<{
        byteCount: !bigint,
        errorCode: !mojoBase_mojom_FileError,
   *  }>}
   */

  writeSync(filePath, blob, position) {}
  
  /**
   * @param { !url_mojom_Url } filePath
   * @param { !bigint } length
   * @param { !FileSystemCancellableOperationPendingReceiver } opReceiver
   * @return {!Promise<{
        errorCode: !mojoBase_mojom_FileError,
   *  }>}
   */

  truncate(filePath, length, opReceiver) {}
  
  /**
   * @param { !url_mojom_Url } filePath
   * @param { !bigint } length
   * @return {!Promise<{
        errorCode: !mojoBase_mojom_FileError,
   *  }>}
   */

  truncateSync(filePath, length) {}
  
  /**
   * @param { !url_mojom_Url } filePath
   * @return {!Promise<{
        fileInfo: !mojoBase_mojom_FileInfo,
        platformPath: !mojoBase_mojom_FilePath,
        errorCode: !mojoBase_mojom_FileError,
        snapshotListener: ?ReceivedSnapshotListenerRemote,
   *  }>}
   */

  createSnapshotFile(filePath) {}
  
  /**
   * @param { !url_mojom_Url } filePath
   * @return {!Promise<{
        platformPath: !mojoBase_mojom_FilePath,
   *  }>}
   */

  getPlatformPath(filePath) {}
  
  /**
   * @param { !string } contentType
   * @param { !url_mojom_Url } url
   * @param { !bigint } length
   * @param { ?mojoBase_mojom_Time } expectedModificationTime
   * @return {!Promise<{
        blob: !blink_mojom_SerializedBlob,
   *  }>}
   */

  registerBlob(contentType, url, length, expectedModificationTime) {}
}

/**
 * @implements { FileSystemManagerInterface }
 */
export class FileSystemManagerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!FileSystemManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          FileSystemManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!FileSystemManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !url_mojom_Origin } origin
   * @param { !FileSystemType } fileSystemType
   * @return {!Promise<{
        name: !string,
        rootUrl: !url_mojom_Url,
        errorCode: !mojoBase_mojom_FileError,
   *  }>}
   */

  open(
      origin,
      fileSystemType) {
    return this.proxy.sendMessage(
        0,
        FileSystemManager_Open_ParamsSpec.$,
        FileSystemManager_Open_ResponseParamsSpec.$,
        [
          origin,
          fileSystemType
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } filesystemUrl
   * @return {!Promise<{
        info: !FileSystemInfo,
        filePath: !mojoBase_mojom_FilePath,
        isDirectory: !boolean,
        errorCode: !mojoBase_mojom_FileError,
   *  }>}
   */

  resolveURL(
      filesystemUrl) {
    return this.proxy.sendMessage(
        1,
        FileSystemManager_ResolveURL_ParamsSpec.$,
        FileSystemManager_ResolveURL_ResponseParamsSpec.$,
        [
          filesystemUrl
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } srcPath
   * @param { !url_mojom_Url } destPath
   * @return {!Promise<{
        errorCode: !mojoBase_mojom_FileError,
   *  }>}
   */

  move(
      srcPath,
      destPath) {
    return this.proxy.sendMessage(
        2,
        FileSystemManager_Move_ParamsSpec.$,
        FileSystemManager_Move_ResponseParamsSpec.$,
        [
          srcPath,
          destPath
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } srcPath
   * @param { !url_mojom_Url } destPath
   * @return {!Promise<{
        errorCode: !mojoBase_mojom_FileError,
   *  }>}
   */

  copy(
      srcPath,
      destPath) {
    return this.proxy.sendMessage(
        3,
        FileSystemManager_Copy_ParamsSpec.$,
        FileSystemManager_Copy_ResponseParamsSpec.$,
        [
          srcPath,
          destPath
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } path
   * @param { !boolean } recursive
   * @return {!Promise<{
        errorCode: !mojoBase_mojom_FileError,
   *  }>}
   */

  remove(
      path,
      recursive) {
    return this.proxy.sendMessage(
        4,
        FileSystemManager_Remove_ParamsSpec.$,
        FileSystemManager_Remove_ResponseParamsSpec.$,
        [
          path,
          recursive
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } path
   * @return {!Promise<{
        fileInfo: !mojoBase_mojom_FileInfo,
        errorCode: !mojoBase_mojom_FileError,
   *  }>}
   */

  readMetadata(
      path) {
    return this.proxy.sendMessage(
        5,
        FileSystemManager_ReadMetadata_ParamsSpec.$,
        FileSystemManager_ReadMetadata_ResponseParamsSpec.$,
        [
          path
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } path
   * @param { !boolean } exclusive
   * @param { !boolean } isDirectory
   * @param { !boolean } recursive
   * @return {!Promise<{
        errorCode: !mojoBase_mojom_FileError,
   *  }>}
   */

  create(
      path,
      exclusive,
      isDirectory,
      recursive) {
    return this.proxy.sendMessage(
        6,
        FileSystemManager_Create_ParamsSpec.$,
        FileSystemManager_Create_ResponseParamsSpec.$,
        [
          path,
          exclusive,
          isDirectory,
          recursive
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } path
   * @param { !boolean } isDirectory
   * @return {!Promise<{
        errorCode: !mojoBase_mojom_FileError,
   *  }>}
   */

  exists(
      path,
      isDirectory) {
    return this.proxy.sendMessage(
        7,
        FileSystemManager_Exists_ParamsSpec.$,
        FileSystemManager_Exists_ResponseParamsSpec.$,
        [
          path,
          isDirectory
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } path
   * @param { !FileSystemOperationListenerRemote } listener
   */

  readDirectory(
      path,
      listener) {
    this.proxy.sendMessage(
        8,
        FileSystemManager_ReadDirectory_ParamsSpec.$,
        null,
        [
          path,
          listener
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } path
   * @return {!Promise<{
        entries: !Array<!filesystem_mojom_DirectoryEntry>,
        errorCode: !mojoBase_mojom_FileError,
   *  }>}
   */

  readDirectorySync(
      path) {
    return this.proxy.sendMessage(
        9,
        FileSystemManager_ReadDirectorySync_ParamsSpec.$,
        FileSystemManager_ReadDirectorySync_ResponseParamsSpec.$,
        [
          path
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } filePath
   * @param { !blink_mojom_BlobRemote } blob
   * @param { !bigint } position
   * @param { !FileSystemCancellableOperationPendingReceiver } opReceiver
   * @param { !FileSystemOperationListenerRemote } listener
   */

  write(
      filePath,
      blob,
      position,
      opReceiver,
      listener) {
    this.proxy.sendMessage(
        10,
        FileSystemManager_Write_ParamsSpec.$,
        null,
        [
          filePath,
          blob,
          position,
          opReceiver,
          listener
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } filePath
   * @param { !blink_mojom_BlobRemote } blob
   * @param { !bigint } position
   * @return {!Promise<{
        byteCount: !bigint,
        errorCode: !mojoBase_mojom_FileError,
   *  }>}
   */

  writeSync(
      filePath,
      blob,
      position) {
    return this.proxy.sendMessage(
        11,
        FileSystemManager_WriteSync_ParamsSpec.$,
        FileSystemManager_WriteSync_ResponseParamsSpec.$,
        [
          filePath,
          blob,
          position
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } filePath
   * @param { !bigint } length
   * @param { !FileSystemCancellableOperationPendingReceiver } opReceiver
   * @return {!Promise<{
        errorCode: !mojoBase_mojom_FileError,
   *  }>}
   */

  truncate(
      filePath,
      length,
      opReceiver) {
    return this.proxy.sendMessage(
        12,
        FileSystemManager_Truncate_ParamsSpec.$,
        FileSystemManager_Truncate_ResponseParamsSpec.$,
        [
          filePath,
          length,
          opReceiver
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } filePath
   * @param { !bigint } length
   * @return {!Promise<{
        errorCode: !mojoBase_mojom_FileError,
   *  }>}
   */

  truncateSync(
      filePath,
      length) {
    return this.proxy.sendMessage(
        13,
        FileSystemManager_TruncateSync_ParamsSpec.$,
        FileSystemManager_TruncateSync_ResponseParamsSpec.$,
        [
          filePath,
          length
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } filePath
   * @return {!Promise<{
        fileInfo: !mojoBase_mojom_FileInfo,
        platformPath: !mojoBase_mojom_FilePath,
        errorCode: !mojoBase_mojom_FileError,
        snapshotListener: ?ReceivedSnapshotListenerRemote,
   *  }>}
   */

  createSnapshotFile(
      filePath) {
    return this.proxy.sendMessage(
        14,
        FileSystemManager_CreateSnapshotFile_ParamsSpec.$,
        FileSystemManager_CreateSnapshotFile_ResponseParamsSpec.$,
        [
          filePath
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } filePath
   * @return {!Promise<{
        platformPath: !mojoBase_mojom_FilePath,
   *  }>}
   */

  getPlatformPath(
      filePath) {
    return this.proxy.sendMessage(
        15,
        FileSystemManager_GetPlatformPath_ParamsSpec.$,
        FileSystemManager_GetPlatformPath_ResponseParamsSpec.$,
        [
          filePath
        ],
        false);
  }

  
  /**
   * @param { !string } contentType
   * @param { !url_mojom_Url } url
   * @param { !bigint } length
   * @param { ?mojoBase_mojom_Time } expectedModificationTime
   * @return {!Promise<{
        blob: !blink_mojom_SerializedBlob,
   *  }>}
   */

  registerBlob(
      contentType,
      url,
      length,
      expectedModificationTime) {
    return this.proxy.sendMessage(
        16,
        FileSystemManager_RegisterBlob_ParamsSpec.$,
        FileSystemManager_RegisterBlob_ResponseParamsSpec.$,
        [
          contentType,
          url,
          length,
          expectedModificationTime
        ],
        false);
  }
}

/**
 * An object which receives request messages for the FileSystemManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class FileSystemManagerReceiver {
  /**
   * @param {!FileSystemManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!FileSystemManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        FileSystemManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FileSystemManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        FileSystemManager_Open_ParamsSpec.$,
        FileSystemManager_Open_ResponseParamsSpec.$,
        impl.open.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        FileSystemManager_ResolveURL_ParamsSpec.$,
        FileSystemManager_ResolveURL_ResponseParamsSpec.$,
        impl.resolveURL.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        FileSystemManager_Move_ParamsSpec.$,
        FileSystemManager_Move_ResponseParamsSpec.$,
        impl.move.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        FileSystemManager_Copy_ParamsSpec.$,
        FileSystemManager_Copy_ResponseParamsSpec.$,
        impl.copy.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        FileSystemManager_Remove_ParamsSpec.$,
        FileSystemManager_Remove_ResponseParamsSpec.$,
        impl.remove.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        FileSystemManager_ReadMetadata_ParamsSpec.$,
        FileSystemManager_ReadMetadata_ResponseParamsSpec.$,
        impl.readMetadata.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        FileSystemManager_Create_ParamsSpec.$,
        FileSystemManager_Create_ResponseParamsSpec.$,
        impl.create.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        FileSystemManager_Exists_ParamsSpec.$,
        FileSystemManager_Exists_ResponseParamsSpec.$,
        impl.exists.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        FileSystemManager_ReadDirectory_ParamsSpec.$,
        null,
        impl.readDirectory.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        FileSystemManager_ReadDirectorySync_ParamsSpec.$,
        FileSystemManager_ReadDirectorySync_ResponseParamsSpec.$,
        impl.readDirectorySync.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        FileSystemManager_Write_ParamsSpec.$,
        null,
        impl.write.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        FileSystemManager_WriteSync_ParamsSpec.$,
        FileSystemManager_WriteSync_ResponseParamsSpec.$,
        impl.writeSync.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        FileSystemManager_Truncate_ParamsSpec.$,
        FileSystemManager_Truncate_ResponseParamsSpec.$,
        impl.truncate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        FileSystemManager_TruncateSync_ParamsSpec.$,
        FileSystemManager_TruncateSync_ResponseParamsSpec.$,
        impl.truncateSync.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        FileSystemManager_CreateSnapshotFile_ParamsSpec.$,
        FileSystemManager_CreateSnapshotFile_ResponseParamsSpec.$,
        impl.createSnapshotFile.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        FileSystemManager_GetPlatformPath_ParamsSpec.$,
        FileSystemManager_GetPlatformPath_ResponseParamsSpec.$,
        impl.getPlatformPath.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        FileSystemManager_RegisterBlob_ParamsSpec.$,
        FileSystemManager_RegisterBlob_ResponseParamsSpec.$,
        impl.registerBlob.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class FileSystemManager {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FileSystemManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!FileSystemManagerRemote}
   */
  static getRemote() {
    let remote = new FileSystemManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the FileSystemManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class FileSystemManagerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      FileSystemManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FileSystemManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.open =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        FileSystemManager_Open_ParamsSpec.$,
        FileSystemManager_Open_ResponseParamsSpec.$,
        this.open.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resolveURL =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        FileSystemManager_ResolveURL_ParamsSpec.$,
        FileSystemManager_ResolveURL_ResponseParamsSpec.$,
        this.resolveURL.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.move =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        FileSystemManager_Move_ParamsSpec.$,
        FileSystemManager_Move_ResponseParamsSpec.$,
        this.move.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.copy =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        FileSystemManager_Copy_ParamsSpec.$,
        FileSystemManager_Copy_ResponseParamsSpec.$,
        this.copy.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.remove =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        FileSystemManager_Remove_ParamsSpec.$,
        FileSystemManager_Remove_ResponseParamsSpec.$,
        this.remove.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.readMetadata =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        FileSystemManager_ReadMetadata_ParamsSpec.$,
        FileSystemManager_ReadMetadata_ResponseParamsSpec.$,
        this.readMetadata.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.create =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        FileSystemManager_Create_ParamsSpec.$,
        FileSystemManager_Create_ResponseParamsSpec.$,
        this.create.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.exists =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        FileSystemManager_Exists_ParamsSpec.$,
        FileSystemManager_Exists_ResponseParamsSpec.$,
        this.exists.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.readDirectory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        FileSystemManager_ReadDirectory_ParamsSpec.$,
        null,
        this.readDirectory.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.readDirectorySync =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        FileSystemManager_ReadDirectorySync_ParamsSpec.$,
        FileSystemManager_ReadDirectorySync_ResponseParamsSpec.$,
        this.readDirectorySync.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.write =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        FileSystemManager_Write_ParamsSpec.$,
        null,
        this.write.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.writeSync =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        FileSystemManager_WriteSync_ParamsSpec.$,
        FileSystemManager_WriteSync_ResponseParamsSpec.$,
        this.writeSync.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.truncate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        FileSystemManager_Truncate_ParamsSpec.$,
        FileSystemManager_Truncate_ResponseParamsSpec.$,
        this.truncate.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.truncateSync =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        FileSystemManager_TruncateSync_ParamsSpec.$,
        FileSystemManager_TruncateSync_ResponseParamsSpec.$,
        this.truncateSync.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createSnapshotFile =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        FileSystemManager_CreateSnapshotFile_ParamsSpec.$,
        FileSystemManager_CreateSnapshotFile_ResponseParamsSpec.$,
        this.createSnapshotFile.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getPlatformPath =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        FileSystemManager_GetPlatformPath_ParamsSpec.$,
        FileSystemManager_GetPlatformPath_ResponseParamsSpec.$,
        this.getPlatformPath.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.registerBlob =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        FileSystemManager_RegisterBlob_ParamsSpec.$,
        FileSystemManager_RegisterBlob_ResponseParamsSpec.$,
        this.registerBlob.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemCancellableOperation_Cancel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemCancellableOperation_Cancel_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemOperationListener_ResultsRetrieved_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemOperationListener_DidWrite_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemOperationListener_ErrorOccurred_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ReceivedSnapshotListener_DidReceiveSnapshotFile_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemManager_Open_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemManager_Open_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemManager_ResolveURL_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemManager_ResolveURL_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemManager_Move_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemManager_Move_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemManager_Copy_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemManager_Copy_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemManager_Remove_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemManager_Remove_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemManager_ReadMetadata_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemManager_ReadMetadata_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemManager_Create_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemManager_Create_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemManager_Exists_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemManager_Exists_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemManager_ReadDirectory_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemManager_ReadDirectorySync_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemManager_ReadDirectorySync_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemManager_Write_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemManager_WriteSync_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemManager_WriteSync_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemManager_Truncate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemManager_Truncate_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemManager_TruncateSync_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemManager_TruncateSync_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemManager_CreateSnapshotFile_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemManager_CreateSnapshotFile_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemManager_GetPlatformPath_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemManager_GetPlatformPath_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemManager_RegisterBlob_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemManager_RegisterBlob_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    FileSystemInfoSpec.$,
    'FileSystemInfo',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'rootUrl', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mountType', 16,
        0,
        FileSystemTypeSpec.$,
        FileSystemType.kTemporary,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class FileSystemInfo {
  constructor() {
    /** @type { !string } */
    this.name;
    /** @type { !url_mojom_Url } */
    this.rootUrl;
    /** @type { !FileSystemType } */
    this.mountType;
  }
}



mojo.internal.Struct(
    FileSystemCancellableOperation_Cancel_ParamsSpec.$,
    'FileSystemCancellableOperation_Cancel_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FileSystemCancellableOperation_Cancel_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    FileSystemCancellableOperation_Cancel_ResponseParamsSpec.$,
    'FileSystemCancellableOperation_Cancel_ResponseParams',
    [
      mojo.internal.StructField(
        'errorCode', 0,
        0,
        mojoBase_mojom_FileErrorSpec.$,
        -16,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemCancellableOperation_Cancel_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_FileError } */
    this.errorCode;
  }
}



mojo.internal.Struct(
    FileSystemOperationListener_ResultsRetrieved_ParamsSpec.$,
    'FileSystemOperationListener_ResultsRetrieved_Params',
    [
      mojo.internal.StructField(
        'entries', 0,
        0,
        mojo.internal.Array(filesystem_mojom_DirectoryEntrySpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasMore', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileSystemOperationListener_ResultsRetrieved_Params {
  constructor() {
    /** @type { !Array<!filesystem_mojom_DirectoryEntry> } */
    this.entries;
    /** @type { !boolean } */
    this.hasMore;
  }
}



mojo.internal.Struct(
    FileSystemOperationListener_DidWrite_ParamsSpec.$,
    'FileSystemOperationListener_DidWrite_Params',
    [
      mojo.internal.StructField(
        'byteCount', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'complete', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileSystemOperationListener_DidWrite_Params {
  constructor() {
    /** @type { !bigint } */
    this.byteCount;
    /** @type { !boolean } */
    this.complete;
  }
}



mojo.internal.Struct(
    FileSystemOperationListener_ErrorOccurred_ParamsSpec.$,
    'FileSystemOperationListener_ErrorOccurred_Params',
    [
      mojo.internal.StructField(
        'errorCode', 0,
        0,
        mojoBase_mojom_FileErrorSpec.$,
        -16,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemOperationListener_ErrorOccurred_Params {
  constructor() {
    /** @type { !mojoBase_mojom_FileError } */
    this.errorCode;
  }
}



mojo.internal.Struct(
    ReceivedSnapshotListener_DidReceiveSnapshotFile_ParamsSpec.$,
    'ReceivedSnapshotListener_DidReceiveSnapshotFile_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class ReceivedSnapshotListener_DidReceiveSnapshotFile_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    FileSystemManager_Open_ParamsSpec.$,
    'FileSystemManager_Open_Params',
    [
      mojo.internal.StructField(
        'origin', 0,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fileSystemType', 8,
        0,
        FileSystemTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileSystemManager_Open_Params {
  constructor() {
    /** @type { !url_mojom_Origin } */
    this.origin;
    /** @type { !FileSystemType } */
    this.fileSystemType;
  }
}



mojo.internal.Struct(
    FileSystemManager_Open_ResponseParamsSpec.$,
    'FileSystemManager_Open_ResponseParams',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'rootUrl', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'errorCode', 16,
        0,
        mojoBase_mojom_FileErrorSpec.$,
        -16,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class FileSystemManager_Open_ResponseParams {
  constructor() {
    /** @type { !string } */
    this.name;
    /** @type { !url_mojom_Url } */
    this.rootUrl;
    /** @type { !mojoBase_mojom_FileError } */
    this.errorCode;
  }
}



mojo.internal.Struct(
    FileSystemManager_ResolveURL_ParamsSpec.$,
    'FileSystemManager_ResolveURL_Params',
    [
      mojo.internal.StructField(
        'filesystemUrl', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemManager_ResolveURL_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.filesystemUrl;
  }
}



mojo.internal.Struct(
    FileSystemManager_ResolveURL_ResponseParamsSpec.$,
    'FileSystemManager_ResolveURL_ResponseParams',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        FileSystemInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'filePath', 8,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isDirectory', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'errorCode', 20,
        0,
        mojoBase_mojom_FileErrorSpec.$,
        -16,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class FileSystemManager_ResolveURL_ResponseParams {
  constructor() {
    /** @type { !FileSystemInfo } */
    this.info;
    /** @type { !mojoBase_mojom_FilePath } */
    this.filePath;
    /** @type { !boolean } */
    this.isDirectory;
    /** @type { !mojoBase_mojom_FileError } */
    this.errorCode;
  }
}



mojo.internal.Struct(
    FileSystemManager_Move_ParamsSpec.$,
    'FileSystemManager_Move_Params',
    [
      mojo.internal.StructField(
        'srcPath', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'destPath', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileSystemManager_Move_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.srcPath;
    /** @type { !url_mojom_Url } */
    this.destPath;
  }
}



mojo.internal.Struct(
    FileSystemManager_Move_ResponseParamsSpec.$,
    'FileSystemManager_Move_ResponseParams',
    [
      mojo.internal.StructField(
        'errorCode', 0,
        0,
        mojoBase_mojom_FileErrorSpec.$,
        -16,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemManager_Move_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_FileError } */
    this.errorCode;
  }
}



mojo.internal.Struct(
    FileSystemManager_Copy_ParamsSpec.$,
    'FileSystemManager_Copy_Params',
    [
      mojo.internal.StructField(
        'srcPath', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'destPath', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileSystemManager_Copy_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.srcPath;
    /** @type { !url_mojom_Url } */
    this.destPath;
  }
}



mojo.internal.Struct(
    FileSystemManager_Copy_ResponseParamsSpec.$,
    'FileSystemManager_Copy_ResponseParams',
    [
      mojo.internal.StructField(
        'errorCode', 0,
        0,
        mojoBase_mojom_FileErrorSpec.$,
        -16,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemManager_Copy_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_FileError } */
    this.errorCode;
  }
}



mojo.internal.Struct(
    FileSystemManager_Remove_ParamsSpec.$,
    'FileSystemManager_Remove_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'recursive', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileSystemManager_Remove_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.path;
    /** @type { !boolean } */
    this.recursive;
  }
}



mojo.internal.Struct(
    FileSystemManager_Remove_ResponseParamsSpec.$,
    'FileSystemManager_Remove_ResponseParams',
    [
      mojo.internal.StructField(
        'errorCode', 0,
        0,
        mojoBase_mojom_FileErrorSpec.$,
        -16,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemManager_Remove_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_FileError } */
    this.errorCode;
  }
}



mojo.internal.Struct(
    FileSystemManager_ReadMetadata_ParamsSpec.$,
    'FileSystemManager_ReadMetadata_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemManager_ReadMetadata_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.path;
  }
}



mojo.internal.Struct(
    FileSystemManager_ReadMetadata_ResponseParamsSpec.$,
    'FileSystemManager_ReadMetadata_ResponseParams',
    [
      mojo.internal.StructField(
        'fileInfo', 0,
        0,
        mojoBase_mojom_FileInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'errorCode', 8,
        0,
        mojoBase_mojom_FileErrorSpec.$,
        -16,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileSystemManager_ReadMetadata_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_FileInfo } */
    this.fileInfo;
    /** @type { !mojoBase_mojom_FileError } */
    this.errorCode;
  }
}



mojo.internal.Struct(
    FileSystemManager_Create_ParamsSpec.$,
    'FileSystemManager_Create_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'exclusive', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isDirectory', 8,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'recursive', 8,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileSystemManager_Create_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.path;
    /** @type { !boolean } */
    this.exclusive;
    /** @type { !boolean } */
    this.isDirectory;
    /** @type { !boolean } */
    this.recursive;
  }
}



mojo.internal.Struct(
    FileSystemManager_Create_ResponseParamsSpec.$,
    'FileSystemManager_Create_ResponseParams',
    [
      mojo.internal.StructField(
        'errorCode', 0,
        0,
        mojoBase_mojom_FileErrorSpec.$,
        -16,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemManager_Create_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_FileError } */
    this.errorCode;
  }
}



mojo.internal.Struct(
    FileSystemManager_Exists_ParamsSpec.$,
    'FileSystemManager_Exists_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isDirectory', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileSystemManager_Exists_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.path;
    /** @type { !boolean } */
    this.isDirectory;
  }
}



mojo.internal.Struct(
    FileSystemManager_Exists_ResponseParamsSpec.$,
    'FileSystemManager_Exists_ResponseParams',
    [
      mojo.internal.StructField(
        'errorCode', 0,
        0,
        mojoBase_mojom_FileErrorSpec.$,
        -16,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemManager_Exists_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_FileError } */
    this.errorCode;
  }
}



mojo.internal.Struct(
    FileSystemManager_ReadDirectory_ParamsSpec.$,
    'FileSystemManager_ReadDirectory_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'listener', 8,
        0,
        mojo.internal.InterfaceProxy(FileSystemOperationListenerRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileSystemManager_ReadDirectory_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.path;
    /** @type { !FileSystemOperationListenerRemote } */
    this.listener;
  }
}



mojo.internal.Struct(
    FileSystemManager_ReadDirectorySync_ParamsSpec.$,
    'FileSystemManager_ReadDirectorySync_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemManager_ReadDirectorySync_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.path;
  }
}



mojo.internal.Struct(
    FileSystemManager_ReadDirectorySync_ResponseParamsSpec.$,
    'FileSystemManager_ReadDirectorySync_ResponseParams',
    [
      mojo.internal.StructField(
        'entries', 0,
        0,
        mojo.internal.Array(filesystem_mojom_DirectoryEntrySpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'errorCode', 8,
        0,
        mojoBase_mojom_FileErrorSpec.$,
        -16,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileSystemManager_ReadDirectorySync_ResponseParams {
  constructor() {
    /** @type { !Array<!filesystem_mojom_DirectoryEntry> } */
    this.entries;
    /** @type { !mojoBase_mojom_FileError } */
    this.errorCode;
  }
}



mojo.internal.Struct(
    FileSystemManager_Write_ParamsSpec.$,
    'FileSystemManager_Write_Params',
    [
      mojo.internal.StructField(
        'filePath', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'blob', 8,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_BlobRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'position', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'opReceiver', 24,
        0,
        mojo.internal.InterfaceRequest(FileSystemCancellableOperationPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'listener', 28,
        0,
        mojo.internal.InterfaceProxy(FileSystemOperationListenerRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class FileSystemManager_Write_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.filePath;
    /** @type { !blink_mojom_BlobRemote } */
    this.blob;
    /** @type { !bigint } */
    this.position;
    /** @type { !FileSystemCancellableOperationPendingReceiver } */
    this.opReceiver;
    /** @type { !FileSystemOperationListenerRemote } */
    this.listener;
  }
}



mojo.internal.Struct(
    FileSystemManager_WriteSync_ParamsSpec.$,
    'FileSystemManager_WriteSync_Params',
    [
      mojo.internal.StructField(
        'filePath', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'blob', 8,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_BlobRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'position', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class FileSystemManager_WriteSync_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.filePath;
    /** @type { !blink_mojom_BlobRemote } */
    this.blob;
    /** @type { !bigint } */
    this.position;
  }
}



mojo.internal.Struct(
    FileSystemManager_WriteSync_ResponseParamsSpec.$,
    'FileSystemManager_WriteSync_ResponseParams',
    [
      mojo.internal.StructField(
        'byteCount', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'errorCode', 8,
        0,
        mojoBase_mojom_FileErrorSpec.$,
        -16,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileSystemManager_WriteSync_ResponseParams {
  constructor() {
    /** @type { !bigint } */
    this.byteCount;
    /** @type { !mojoBase_mojom_FileError } */
    this.errorCode;
  }
}



mojo.internal.Struct(
    FileSystemManager_Truncate_ParamsSpec.$,
    'FileSystemManager_Truncate_Params',
    [
      mojo.internal.StructField(
        'filePath', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'length', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'opReceiver', 16,
        0,
        mojo.internal.InterfaceRequest(FileSystemCancellableOperationPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class FileSystemManager_Truncate_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.filePath;
    /** @type { !bigint } */
    this.length;
    /** @type { !FileSystemCancellableOperationPendingReceiver } */
    this.opReceiver;
  }
}



mojo.internal.Struct(
    FileSystemManager_Truncate_ResponseParamsSpec.$,
    'FileSystemManager_Truncate_ResponseParams',
    [
      mojo.internal.StructField(
        'errorCode', 0,
        0,
        mojoBase_mojom_FileErrorSpec.$,
        -16,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemManager_Truncate_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_FileError } */
    this.errorCode;
  }
}



mojo.internal.Struct(
    FileSystemManager_TruncateSync_ParamsSpec.$,
    'FileSystemManager_TruncateSync_Params',
    [
      mojo.internal.StructField(
        'filePath', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'length', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileSystemManager_TruncateSync_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.filePath;
    /** @type { !bigint } */
    this.length;
  }
}



mojo.internal.Struct(
    FileSystemManager_TruncateSync_ResponseParamsSpec.$,
    'FileSystemManager_TruncateSync_ResponseParams',
    [
      mojo.internal.StructField(
        'errorCode', 0,
        0,
        mojoBase_mojom_FileErrorSpec.$,
        -16,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemManager_TruncateSync_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_FileError } */
    this.errorCode;
  }
}



mojo.internal.Struct(
    FileSystemManager_CreateSnapshotFile_ParamsSpec.$,
    'FileSystemManager_CreateSnapshotFile_Params',
    [
      mojo.internal.StructField(
        'filePath', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemManager_CreateSnapshotFile_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.filePath;
  }
}



mojo.internal.Struct(
    FileSystemManager_CreateSnapshotFile_ResponseParamsSpec.$,
    'FileSystemManager_CreateSnapshotFile_ResponseParams',
    [
      mojo.internal.StructField(
        'fileInfo', 0,
        0,
        mojoBase_mojom_FileInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'platformPath', 8,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'errorCode', 16,
        0,
        mojoBase_mojom_FileErrorSpec.$,
        -16,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'snapshotListener', 20,
        0,
        mojo.internal.InterfaceProxy(ReceivedSnapshotListenerRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class FileSystemManager_CreateSnapshotFile_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_FileInfo } */
    this.fileInfo;
    /** @type { !mojoBase_mojom_FilePath } */
    this.platformPath;
    /** @type { !mojoBase_mojom_FileError } */
    this.errorCode;
    /** @type { (ReceivedSnapshotListenerRemote|undefined) } */
    this.snapshotListener;
  }
}



mojo.internal.Struct(
    FileSystemManager_GetPlatformPath_ParamsSpec.$,
    'FileSystemManager_GetPlatformPath_Params',
    [
      mojo.internal.StructField(
        'filePath', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemManager_GetPlatformPath_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.filePath;
  }
}



mojo.internal.Struct(
    FileSystemManager_GetPlatformPath_ResponseParamsSpec.$,
    'FileSystemManager_GetPlatformPath_ResponseParams',
    [
      mojo.internal.StructField(
        'platformPath', 0,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemManager_GetPlatformPath_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_FilePath } */
    this.platformPath;
  }
}



mojo.internal.Struct(
    FileSystemManager_RegisterBlob_ParamsSpec.$,
    'FileSystemManager_RegisterBlob_Params',
    [
      mojo.internal.StructField(
        'contentType', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'length', 16,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'expectedModificationTime', 24,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class FileSystemManager_RegisterBlob_Params {
  constructor() {
    /** @type { !string } */
    this.contentType;
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !bigint } */
    this.length;
    /** @type { (mojoBase_mojom_Time|undefined) } */
    this.expectedModificationTime;
  }
}



mojo.internal.Struct(
    FileSystemManager_RegisterBlob_ResponseParamsSpec.$,
    'FileSystemManager_RegisterBlob_ResponseParams',
    [
      mojo.internal.StructField(
        'blob', 0,
        0,
        blink_mojom_SerializedBlobSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemManager_RegisterBlob_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_SerializedBlob } */
    this.blob;
  }
}

