// third_party/blink/public/mojom/file_system_access/file_system_access_transfer_token.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  UnguessableToken as mojoBase_mojom_UnguessableToken,
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec
} from '../../../../../mojo/public/mojom/base/unguessable_token.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class FileSystemAccessTransferTokenPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.FileSystemAccessTransferToken', scope);
  }
}

/** @interface */
export class FileSystemAccessTransferTokenInterface {
  
  /**
   * @return {!Promise<{
        id: !mojoBase_mojom_UnguessableToken,
   *  }>}
   */

  getInternalID() {}
  
  /**
   * @param { !FileSystemAccessTransferTokenPendingReceiver } tokenClone
   */

  clone(tokenClone) {}
}

/**
 * @implements { FileSystemAccessTransferTokenInterface }
 */
export class FileSystemAccessTransferTokenRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!FileSystemAccessTransferTokenPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          FileSystemAccessTransferTokenPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!FileSystemAccessTransferTokenPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        id: !mojoBase_mojom_UnguessableToken,
   *  }>}
   */

  getInternalID() {
    return this.proxy.sendMessage(
        0,
        FileSystemAccessTransferToken_GetInternalID_ParamsSpec.$,
        FileSystemAccessTransferToken_GetInternalID_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !FileSystemAccessTransferTokenPendingReceiver } tokenClone
   */

  clone(
      tokenClone) {
    this.proxy.sendMessage(
        1,
        FileSystemAccessTransferToken_Clone_ParamsSpec.$,
        null,
        [
          tokenClone
        ],
        false);
  }
}

/**
 * An object which receives request messages for the FileSystemAccessTransferToken
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class FileSystemAccessTransferTokenReceiver {
  /**
   * @param {!FileSystemAccessTransferTokenInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!FileSystemAccessTransferTokenRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        FileSystemAccessTransferTokenRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FileSystemAccessTransferTokenRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        FileSystemAccessTransferToken_GetInternalID_ParamsSpec.$,
        FileSystemAccessTransferToken_GetInternalID_ResponseParamsSpec.$,
        impl.getInternalID.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        FileSystemAccessTransferToken_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class FileSystemAccessTransferToken {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FileSystemAccessTransferToken";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!FileSystemAccessTransferTokenRemote}
   */
  static getRemote() {
    let remote = new FileSystemAccessTransferTokenRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the FileSystemAccessTransferToken
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class FileSystemAccessTransferTokenCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      FileSystemAccessTransferTokenRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FileSystemAccessTransferTokenRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getInternalID =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        FileSystemAccessTransferToken_GetInternalID_ParamsSpec.$,
        FileSystemAccessTransferToken_GetInternalID_ResponseParamsSpec.$,
        this.getInternalID.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        FileSystemAccessTransferToken_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessTransferToken_GetInternalID_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessTransferToken_GetInternalID_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessTransferToken_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    FileSystemAccessTransferToken_GetInternalID_ParamsSpec.$,
    'FileSystemAccessTransferToken_GetInternalID_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FileSystemAccessTransferToken_GetInternalID_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    FileSystemAccessTransferToken_GetInternalID_ResponseParamsSpec.$,
    'FileSystemAccessTransferToken_GetInternalID_ResponseParams',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemAccessTransferToken_GetInternalID_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.id;
  }
}



mojo.internal.Struct(
    FileSystemAccessTransferToken_Clone_ParamsSpec.$,
    'FileSystemAccessTransferToken_Clone_Params',
    [
      mojo.internal.StructField(
        'tokenClone', 0,
        0,
        mojo.internal.InterfaceRequest(FileSystemAccessTransferTokenPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemAccessTransferToken_Clone_Params {
  constructor() {
    /** @type { !FileSystemAccessTransferTokenPendingReceiver } */
    this.tokenClone;
  }
}

