// third_party/blink/public/mojom/file_system_access/file_system_access_observer.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/file_system_access/file_system_access_observer.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var file_system_access_directory_handle$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/file_system_access/file_system_access_directory_handle.mojom', 'file_system_access_directory_handle.mojom.js');
  }



  function FileSystemAccessChangeTypeAppeared(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessChangeTypeAppeared.prototype.initDefaults_ = function() {
  };
  FileSystemAccessChangeTypeAppeared.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessChangeTypeAppeared.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessChangeTypeAppeared.encodedSize = codec.kStructHeaderSize + 0;

  FileSystemAccessChangeTypeAppeared.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessChangeTypeAppeared();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FileSystemAccessChangeTypeAppeared.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessChangeTypeAppeared.encodedSize);
    encoder.writeUint32(0);
  };
  function FileSystemAccessChangeTypeDisappeared(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessChangeTypeDisappeared.prototype.initDefaults_ = function() {
  };
  FileSystemAccessChangeTypeDisappeared.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessChangeTypeDisappeared.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessChangeTypeDisappeared.encodedSize = codec.kStructHeaderSize + 0;

  FileSystemAccessChangeTypeDisappeared.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessChangeTypeDisappeared();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FileSystemAccessChangeTypeDisappeared.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessChangeTypeDisappeared.encodedSize);
    encoder.writeUint32(0);
  };
  function FileSystemAccessChangeTypeErrored(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessChangeTypeErrored.prototype.initDefaults_ = function() {
  };
  FileSystemAccessChangeTypeErrored.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessChangeTypeErrored.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessChangeTypeErrored.encodedSize = codec.kStructHeaderSize + 0;

  FileSystemAccessChangeTypeErrored.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessChangeTypeErrored();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FileSystemAccessChangeTypeErrored.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessChangeTypeErrored.encodedSize);
    encoder.writeUint32(0);
  };
  function FileSystemAccessChangeTypeModified(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessChangeTypeModified.prototype.initDefaults_ = function() {
  };
  FileSystemAccessChangeTypeModified.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessChangeTypeModified.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessChangeTypeModified.encodedSize = codec.kStructHeaderSize + 0;

  FileSystemAccessChangeTypeModified.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessChangeTypeModified();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FileSystemAccessChangeTypeModified.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessChangeTypeModified.encodedSize);
    encoder.writeUint32(0);
  };
  function FileSystemAccessChangeTypeMoved(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessChangeTypeMoved.prototype.initDefaults_ = function() {
    this.formerRelativePath = null;
  };
  FileSystemAccessChangeTypeMoved.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessChangeTypeMoved.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessChangeTypeMoved.formerRelativePath
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, codec.String, true, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessChangeTypeMoved.encodedSize = codec.kStructHeaderSize + 8;

  FileSystemAccessChangeTypeMoved.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessChangeTypeMoved();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.formerRelativePath =
        decoder.decodeArrayPointer(codec.String);
    return val;
  };

  FileSystemAccessChangeTypeMoved.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessChangeTypeMoved.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.String, val.formerRelativePath);
  };
  function FileSystemAccessChangeTypeUnknown(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessChangeTypeUnknown.prototype.initDefaults_ = function() {
  };
  FileSystemAccessChangeTypeUnknown.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessChangeTypeUnknown.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessChangeTypeUnknown.encodedSize = codec.kStructHeaderSize + 0;

  FileSystemAccessChangeTypeUnknown.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessChangeTypeUnknown();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FileSystemAccessChangeTypeUnknown.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessChangeTypeUnknown.encodedSize);
    encoder.writeUint32(0);
  };
  function FileSystemAccessChangeMetadata(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessChangeMetadata.prototype.initDefaults_ = function() {
    this.root = null;
    this.changedEntry = null;
    this.relativePath = null;
  };
  FileSystemAccessChangeMetadata.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessChangeMetadata.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessChangeMetadata.root
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_system_access_directory_handle$.FileSystemAccessEntry, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessChangeMetadata.changedEntry
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, file_system_access_directory_handle$.FileSystemAccessEntry, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessChangeMetadata.relativePath
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessChangeMetadata.encodedSize = codec.kStructHeaderSize + 24;

  FileSystemAccessChangeMetadata.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessChangeMetadata();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.root =
        decoder.decodeStructPointer(file_system_access_directory_handle$.FileSystemAccessEntry);
    val.changedEntry =
        decoder.decodeStructPointer(file_system_access_directory_handle$.FileSystemAccessEntry);
    val.relativePath =
        decoder.decodeArrayPointer(codec.String);
    return val;
  };

  FileSystemAccessChangeMetadata.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessChangeMetadata.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_system_access_directory_handle$.FileSystemAccessEntry, val.root);
    encoder.encodeStructPointer(file_system_access_directory_handle$.FileSystemAccessEntry, val.changedEntry);
    encoder.encodeArrayPointer(codec.String, val.relativePath);
  };
  function FileSystemAccessChange(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessChange.prototype.initDefaults_ = function() {
    this.metadata = null;
    this.type = null;
  };
  FileSystemAccessChange.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessChange.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessChange.metadata
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, FileSystemAccessChangeMetadata, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessChange.type
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 8, FileSystemAccessChangeType, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessChange.encodedSize = codec.kStructHeaderSize + 24;

  FileSystemAccessChange.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessChange();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.metadata =
        decoder.decodeStructPointer(FileSystemAccessChangeMetadata);
    val.type =
        decoder.decodeStruct(FileSystemAccessChangeType);
    return val;
  };

  FileSystemAccessChange.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessChange.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(FileSystemAccessChangeMetadata, val.metadata);
    encoder.encodeStruct(FileSystemAccessChangeType, val.type);
  };
  function FileSystemAccessObserver_OnFileChanges_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessObserver_OnFileChanges_Params.prototype.initDefaults_ = function() {
    this.changes = null;
  };
  FileSystemAccessObserver_OnFileChanges_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessObserver_OnFileChanges_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessObserver_OnFileChanges_Params.changes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(FileSystemAccessChange), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessObserver_OnFileChanges_Params.encodedSize = codec.kStructHeaderSize + 8;

  FileSystemAccessObserver_OnFileChanges_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessObserver_OnFileChanges_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.changes =
        decoder.decodeArrayPointer(new codec.PointerTo(FileSystemAccessChange));
    return val;
  };

  FileSystemAccessObserver_OnFileChanges_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessObserver_OnFileChanges_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(FileSystemAccessChange), val.changes);
  };

  function FileSystemAccessChangeType(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  FileSystemAccessChangeType.Tags = {
    appeared: 0,
    disappeared: 1,
    errored: 2,
    modified: 3,
    moved: 4,
    unknown: 5,
  };

  FileSystemAccessChangeType.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  FileSystemAccessChangeType.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "appeared",
        "disappeared",
        "errored",
        "modified",
        "moved",
        "unknown",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a FileSystemAccessChangeType member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(FileSystemAccessChangeType.prototype, "appeared", {
    get: function() {
      if (this.$tag != FileSystemAccessChangeType.Tags.appeared) {
        throw new ReferenceError(
            "FileSystemAccessChangeType.appeared is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = FileSystemAccessChangeType.Tags.appeared;
      this.$data = value;
    }
  });
  Object.defineProperty(FileSystemAccessChangeType.prototype, "disappeared", {
    get: function() {
      if (this.$tag != FileSystemAccessChangeType.Tags.disappeared) {
        throw new ReferenceError(
            "FileSystemAccessChangeType.disappeared is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = FileSystemAccessChangeType.Tags.disappeared;
      this.$data = value;
    }
  });
  Object.defineProperty(FileSystemAccessChangeType.prototype, "errored", {
    get: function() {
      if (this.$tag != FileSystemAccessChangeType.Tags.errored) {
        throw new ReferenceError(
            "FileSystemAccessChangeType.errored is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = FileSystemAccessChangeType.Tags.errored;
      this.$data = value;
    }
  });
  Object.defineProperty(FileSystemAccessChangeType.prototype, "modified", {
    get: function() {
      if (this.$tag != FileSystemAccessChangeType.Tags.modified) {
        throw new ReferenceError(
            "FileSystemAccessChangeType.modified is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = FileSystemAccessChangeType.Tags.modified;
      this.$data = value;
    }
  });
  Object.defineProperty(FileSystemAccessChangeType.prototype, "moved", {
    get: function() {
      if (this.$tag != FileSystemAccessChangeType.Tags.moved) {
        throw new ReferenceError(
            "FileSystemAccessChangeType.moved is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = FileSystemAccessChangeType.Tags.moved;
      this.$data = value;
    }
  });
  Object.defineProperty(FileSystemAccessChangeType.prototype, "unknown", {
    get: function() {
      if (this.$tag != FileSystemAccessChangeType.Tags.unknown) {
        throw new ReferenceError(
            "FileSystemAccessChangeType.unknown is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = FileSystemAccessChangeType.Tags.unknown;
      this.$data = value;
    }
  });


    FileSystemAccessChangeType.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case FileSystemAccessChangeType.Tags.appeared:
          encoder.encodeStructPointer(FileSystemAccessChangeTypeAppeared, val.appeared);
          break;
        case FileSystemAccessChangeType.Tags.disappeared:
          encoder.encodeStructPointer(FileSystemAccessChangeTypeDisappeared, val.disappeared);
          break;
        case FileSystemAccessChangeType.Tags.errored:
          encoder.encodeStructPointer(FileSystemAccessChangeTypeErrored, val.errored);
          break;
        case FileSystemAccessChangeType.Tags.modified:
          encoder.encodeStructPointer(FileSystemAccessChangeTypeModified, val.modified);
          break;
        case FileSystemAccessChangeType.Tags.moved:
          encoder.encodeStructPointer(FileSystemAccessChangeTypeMoved, val.moved);
          break;
        case FileSystemAccessChangeType.Tags.unknown:
          encoder.encodeStructPointer(FileSystemAccessChangeTypeUnknown, val.unknown);
          break;
      }
      encoder.align();
    };


    FileSystemAccessChangeType.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new FileSystemAccessChangeType();
      var tag = decoder.readUint32();
      switch (tag) {
        case FileSystemAccessChangeType.Tags.appeared:
          result.appeared = decoder.decodeStructPointer(FileSystemAccessChangeTypeAppeared);
          break;
        case FileSystemAccessChangeType.Tags.disappeared:
          result.disappeared = decoder.decodeStructPointer(FileSystemAccessChangeTypeDisappeared);
          break;
        case FileSystemAccessChangeType.Tags.errored:
          result.errored = decoder.decodeStructPointer(FileSystemAccessChangeTypeErrored);
          break;
        case FileSystemAccessChangeType.Tags.modified:
          result.modified = decoder.decodeStructPointer(FileSystemAccessChangeTypeModified);
          break;
        case FileSystemAccessChangeType.Tags.moved:
          result.moved = decoder.decodeStructPointer(FileSystemAccessChangeTypeMoved);
          break;
        case FileSystemAccessChangeType.Tags.unknown:
          result.unknown = decoder.decodeStructPointer(FileSystemAccessChangeTypeUnknown);
          break;
      }
      decoder.align();

      return result;
    };


    FileSystemAccessChangeType.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case FileSystemAccessChangeType.Tags.appeared:
          

    // validate FileSystemAccessChangeType.appeared
    err = messageValidator.validateStructPointer(data_offset, FileSystemAccessChangeTypeAppeared, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case FileSystemAccessChangeType.Tags.disappeared:
          

    // validate FileSystemAccessChangeType.disappeared
    err = messageValidator.validateStructPointer(data_offset, FileSystemAccessChangeTypeDisappeared, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case FileSystemAccessChangeType.Tags.errored:
          

    // validate FileSystemAccessChangeType.errored
    err = messageValidator.validateStructPointer(data_offset, FileSystemAccessChangeTypeErrored, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case FileSystemAccessChangeType.Tags.modified:
          

    // validate FileSystemAccessChangeType.modified
    err = messageValidator.validateStructPointer(data_offset, FileSystemAccessChangeTypeModified, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case FileSystemAccessChangeType.Tags.moved:
          

    // validate FileSystemAccessChangeType.moved
    err = messageValidator.validateStructPointer(data_offset, FileSystemAccessChangeTypeMoved, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case FileSystemAccessChangeType.Tags.unknown:
          

    // validate FileSystemAccessChangeType.unknown
    err = messageValidator.validateStructPointer(data_offset, FileSystemAccessChangeTypeUnknown, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  FileSystemAccessChangeType.encodedSize = 16;
  var kFileSystemAccessObserver_OnFileChanges_Name = 0;

  function FileSystemAccessObserverPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(FileSystemAccessObserver,
                                                   handleOrPtrInfo);
  }

  function FileSystemAccessObserverAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        FileSystemAccessObserver, associatedInterfacePtrInfo);
  }

  FileSystemAccessObserverAssociatedPtr.prototype =
      Object.create(FileSystemAccessObserverPtr.prototype);
  FileSystemAccessObserverAssociatedPtr.prototype.constructor =
      FileSystemAccessObserverAssociatedPtr;

  function FileSystemAccessObserverProxy(receiver) {
    this.receiver_ = receiver;
  }
  FileSystemAccessObserverPtr.prototype.onFileChanges = function() {
    return FileSystemAccessObserverProxy.prototype.onFileChanges
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessObserverProxy.prototype.onFileChanges = function(changes) {
    var params_ = new FileSystemAccessObserver_OnFileChanges_Params();
    params_.changes = changes;
    var builder = new codec.MessageV0Builder(
        kFileSystemAccessObserver_OnFileChanges_Name,
        codec.align(FileSystemAccessObserver_OnFileChanges_Params.encodedSize));
    builder.encodeStruct(FileSystemAccessObserver_OnFileChanges_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function FileSystemAccessObserverStub(delegate) {
    this.delegate_ = delegate;
  }
  FileSystemAccessObserverStub.prototype.onFileChanges = function(changes) {
    return this.delegate_ && this.delegate_.onFileChanges && this.delegate_.onFileChanges(changes);
  }

  FileSystemAccessObserverStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kFileSystemAccessObserver_OnFileChanges_Name:
      var params = reader.decodeStruct(FileSystemAccessObserver_OnFileChanges_Params);
      this.onFileChanges(params.changes);
      return true;
    default:
      return false;
    }
  };

  FileSystemAccessObserverStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateFileSystemAccessObserverRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kFileSystemAccessObserver_OnFileChanges_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FileSystemAccessObserver_OnFileChanges_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateFileSystemAccessObserverResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var FileSystemAccessObserver = {
    name: 'blink.mojom.FileSystemAccessObserver',
    kVersion: 0,
    ptrClass: FileSystemAccessObserverPtr,
    proxyClass: FileSystemAccessObserverProxy,
    stubClass: FileSystemAccessObserverStub,
    validateRequest: validateFileSystemAccessObserverRequest,
    validateResponse: null,
  };
  FileSystemAccessObserverStub.prototype.validator = validateFileSystemAccessObserverRequest;
  FileSystemAccessObserverProxy.prototype.validator = null;
  exports.FileSystemAccessChangeTypeAppeared = FileSystemAccessChangeTypeAppeared;
  exports.FileSystemAccessChangeTypeDisappeared = FileSystemAccessChangeTypeDisappeared;
  exports.FileSystemAccessChangeTypeErrored = FileSystemAccessChangeTypeErrored;
  exports.FileSystemAccessChangeTypeModified = FileSystemAccessChangeTypeModified;
  exports.FileSystemAccessChangeTypeMoved = FileSystemAccessChangeTypeMoved;
  exports.FileSystemAccessChangeTypeUnknown = FileSystemAccessChangeTypeUnknown;
  exports.FileSystemAccessChangeMetadata = FileSystemAccessChangeMetadata;
  exports.FileSystemAccessChange = FileSystemAccessChange;
  exports.FileSystemAccessChangeType = FileSystemAccessChangeType;
  exports.FileSystemAccessObserver = FileSystemAccessObserver;
  exports.FileSystemAccessObserverPtr = FileSystemAccessObserverPtr;
  exports.FileSystemAccessObserverAssociatedPtr = FileSystemAccessObserverAssociatedPtr;
})();