// third_party/blink/public/mojom/file_system_access/file_system_access_observer.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/file_system_access/file_system_access_observer.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_observer.mojom-params-data.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_observer.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_observer.mojom-import-headers.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_observer.mojom-test-utils.h"


namespace blink::mojom {
FileSystemAccessChangeTypeAppeared::FileSystemAccessChangeTypeAppeared() {}

FileSystemAccessChangeTypeAppeared::~FileSystemAccessChangeTypeAppeared() = default;
size_t FileSystemAccessChangeTypeAppeared::Hash(size_t seed) const {
  return seed;
}

void FileSystemAccessChangeTypeAppeared::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
}

bool FileSystemAccessChangeTypeAppeared::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FileSystemAccessChangeTypeDisappeared::FileSystemAccessChangeTypeDisappeared() {}

FileSystemAccessChangeTypeDisappeared::~FileSystemAccessChangeTypeDisappeared() = default;
size_t FileSystemAccessChangeTypeDisappeared::Hash(size_t seed) const {
  return seed;
}

void FileSystemAccessChangeTypeDisappeared::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
}

bool FileSystemAccessChangeTypeDisappeared::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FileSystemAccessChangeTypeErrored::FileSystemAccessChangeTypeErrored() {}

FileSystemAccessChangeTypeErrored::~FileSystemAccessChangeTypeErrored() = default;
size_t FileSystemAccessChangeTypeErrored::Hash(size_t seed) const {
  return seed;
}

void FileSystemAccessChangeTypeErrored::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
}

bool FileSystemAccessChangeTypeErrored::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FileSystemAccessChangeTypeModified::FileSystemAccessChangeTypeModified() {}

FileSystemAccessChangeTypeModified::~FileSystemAccessChangeTypeModified() = default;
size_t FileSystemAccessChangeTypeModified::Hash(size_t seed) const {
  return seed;
}

void FileSystemAccessChangeTypeModified::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
}

bool FileSystemAccessChangeTypeModified::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FileSystemAccessChangeTypeMoved::FileSystemAccessChangeTypeMoved()
    : former_relative_path() {}

FileSystemAccessChangeTypeMoved::FileSystemAccessChangeTypeMoved(
    std::optional<std::vector<std::string>> former_relative_path_in)
    : former_relative_path(std::move(former_relative_path_in)) {}

FileSystemAccessChangeTypeMoved::~FileSystemAccessChangeTypeMoved() = default;

void FileSystemAccessChangeTypeMoved::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "former_relative_path"), this->former_relative_path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::vector<std::string>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FileSystemAccessChangeTypeMoved::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FileSystemAccessChangeTypeUnknown::FileSystemAccessChangeTypeUnknown() {}

FileSystemAccessChangeTypeUnknown::~FileSystemAccessChangeTypeUnknown() = default;
size_t FileSystemAccessChangeTypeUnknown::Hash(size_t seed) const {
  return seed;
}

void FileSystemAccessChangeTypeUnknown::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
}

bool FileSystemAccessChangeTypeUnknown::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FileSystemAccessChangeMetadata::FileSystemAccessChangeMetadata()
    : root(),
      changed_entry(),
      relative_path() {}

FileSystemAccessChangeMetadata::FileSystemAccessChangeMetadata(
    ::blink::mojom::FileSystemAccessEntryPtr root_in,
    ::blink::mojom::FileSystemAccessEntryPtr changed_entry_in,
    std::vector<std::string> relative_path_in)
    : root(std::move(root_in)),
      changed_entry(std::move(changed_entry_in)),
      relative_path(std::move(relative_path_in)) {}

FileSystemAccessChangeMetadata::~FileSystemAccessChangeMetadata() = default;

void FileSystemAccessChangeMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "root"), this->root,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::FileSystemAccessEntryPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "changed_entry"), this->changed_entry,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::FileSystemAccessEntryPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "relative_path"), this->relative_path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FileSystemAccessChangeMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FileSystemAccessChange::FileSystemAccessChange()
    : metadata(),
      type() {}

FileSystemAccessChange::FileSystemAccessChange(
    FileSystemAccessChangeMetadataPtr metadata_in,
    FileSystemAccessChangeTypePtr type_in)
    : metadata(std::move(metadata_in)),
      type(std::move(type_in)) {}

FileSystemAccessChange::~FileSystemAccessChange() = default;

void FileSystemAccessChange::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "metadata"), this->metadata,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type FileSystemAccessChangeMetadataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type FileSystemAccessChangeTypePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FileSystemAccessChange::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FileSystemAccessChangeTypePtr
FileSystemAccessChangeType::NewAppeared(
    FileSystemAccessChangeTypeAppearedPtr value) {
  return FileSystemAccessChangeTypePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kAppeared)>,
      std::move(value));
}

FileSystemAccessChangeTypePtr
FileSystemAccessChangeType::NewDisappeared(
    FileSystemAccessChangeTypeDisappearedPtr value) {
  return FileSystemAccessChangeTypePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kDisappeared)>,
      std::move(value));
}

FileSystemAccessChangeTypePtr
FileSystemAccessChangeType::NewErrored(
    FileSystemAccessChangeTypeErroredPtr value) {
  return FileSystemAccessChangeTypePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kErrored)>,
      std::move(value));
}

FileSystemAccessChangeTypePtr
FileSystemAccessChangeType::NewModified(
    FileSystemAccessChangeTypeModifiedPtr value) {
  return FileSystemAccessChangeTypePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kModified)>,
      std::move(value));
}

FileSystemAccessChangeTypePtr
FileSystemAccessChangeType::NewMoved(
    FileSystemAccessChangeTypeMovedPtr value) {
  return FileSystemAccessChangeTypePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kMoved)>,
      std::move(value));
}

FileSystemAccessChangeTypePtr
FileSystemAccessChangeType::NewUnknown(
    FileSystemAccessChangeTypeUnknownPtr value) {
  return FileSystemAccessChangeTypePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kUnknown)>,
      std::move(value));
}

FileSystemAccessChangeType::FileSystemAccessChangeType(
    std::in_place_index_t<static_cast<size_t>(Tag::kAppeared)>,
    FileSystemAccessChangeTypeAppearedPtr value)
    : tag_(Tag::kAppeared),
      data_(std::in_place_index<static_cast<size_t>(Tag::kAppeared)>,
            std::move(value)) {}

FileSystemAccessChangeType::FileSystemAccessChangeType(
    std::in_place_index_t<static_cast<size_t>(Tag::kDisappeared)>,
    FileSystemAccessChangeTypeDisappearedPtr value)
    : tag_(Tag::kDisappeared),
      data_(std::in_place_index<static_cast<size_t>(Tag::kDisappeared)>,
            std::move(value)) {}

FileSystemAccessChangeType::FileSystemAccessChangeType(
    std::in_place_index_t<static_cast<size_t>(Tag::kErrored)>,
    FileSystemAccessChangeTypeErroredPtr value)
    : tag_(Tag::kErrored),
      data_(std::in_place_index<static_cast<size_t>(Tag::kErrored)>,
            std::move(value)) {}

FileSystemAccessChangeType::FileSystemAccessChangeType(
    std::in_place_index_t<static_cast<size_t>(Tag::kModified)>,
    FileSystemAccessChangeTypeModifiedPtr value)
    : tag_(Tag::kModified),
      data_(std::in_place_index<static_cast<size_t>(Tag::kModified)>,
            std::move(value)) {}

FileSystemAccessChangeType::FileSystemAccessChangeType(
    std::in_place_index_t<static_cast<size_t>(Tag::kMoved)>,
    FileSystemAccessChangeTypeMovedPtr value)
    : tag_(Tag::kMoved),
      data_(std::in_place_index<static_cast<size_t>(Tag::kMoved)>,
            std::move(value)) {}

FileSystemAccessChangeType::FileSystemAccessChangeType(
    std::in_place_index_t<static_cast<size_t>(Tag::kUnknown)>,
    FileSystemAccessChangeTypeUnknownPtr value)
    : tag_(Tag::kUnknown),
      data_(std::in_place_index<static_cast<size_t>(Tag::kUnknown)>,
            std::move(value)) {}
FileSystemAccessChangeType::~FileSystemAccessChangeType() {
  DestroyActive();
}

void FileSystemAccessChangeType::set_appeared(FileSystemAccessChangeTypeAppearedPtr appeared) {
  if (tag_ == Tag::kAppeared) {
    data_.appeared = std::move(appeared);
  } else {
    DestroyActive();
    tag_ = Tag::kAppeared;
    new (&data_.appeared) FileSystemAccessChangeTypeAppearedPtr(
        std::move(appeared));
  }
}

void FileSystemAccessChangeType::set_disappeared(FileSystemAccessChangeTypeDisappearedPtr disappeared) {
  if (tag_ == Tag::kDisappeared) {
    data_.disappeared = std::move(disappeared);
  } else {
    DestroyActive();
    tag_ = Tag::kDisappeared;
    new (&data_.disappeared) FileSystemAccessChangeTypeDisappearedPtr(
        std::move(disappeared));
  }
}

void FileSystemAccessChangeType::set_errored(FileSystemAccessChangeTypeErroredPtr errored) {
  if (tag_ == Tag::kErrored) {
    data_.errored = std::move(errored);
  } else {
    DestroyActive();
    tag_ = Tag::kErrored;
    new (&data_.errored) FileSystemAccessChangeTypeErroredPtr(
        std::move(errored));
  }
}

void FileSystemAccessChangeType::set_modified(FileSystemAccessChangeTypeModifiedPtr modified) {
  if (tag_ == Tag::kModified) {
    data_.modified = std::move(modified);
  } else {
    DestroyActive();
    tag_ = Tag::kModified;
    new (&data_.modified) FileSystemAccessChangeTypeModifiedPtr(
        std::move(modified));
  }
}

void FileSystemAccessChangeType::set_moved(FileSystemAccessChangeTypeMovedPtr moved) {
  if (tag_ == Tag::kMoved) {
    data_.moved = std::move(moved);
  } else {
    DestroyActive();
    tag_ = Tag::kMoved;
    new (&data_.moved) FileSystemAccessChangeTypeMovedPtr(
        std::move(moved));
  }
}

void FileSystemAccessChangeType::set_unknown(FileSystemAccessChangeTypeUnknownPtr unknown) {
  if (tag_ == Tag::kUnknown) {
    data_.unknown = std::move(unknown);
  } else {
    DestroyActive();
    tag_ = Tag::kUnknown;
    new (&data_.unknown) FileSystemAccessChangeTypeUnknownPtr(
        std::move(unknown));
  }
}


FileSystemAccessChangeType::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kAppeared)>,
    FileSystemAccessChangeTypeAppearedPtr value)
    : appeared(std::move(value)) {}

FileSystemAccessChangeType::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kDisappeared)>,
    FileSystemAccessChangeTypeDisappearedPtr value)
    : disappeared(std::move(value)) {}

FileSystemAccessChangeType::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kErrored)>,
    FileSystemAccessChangeTypeErroredPtr value)
    : errored(std::move(value)) {}

FileSystemAccessChangeType::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kModified)>,
    FileSystemAccessChangeTypeModifiedPtr value)
    : modified(std::move(value)) {}

FileSystemAccessChangeType::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kMoved)>,
    FileSystemAccessChangeTypeMovedPtr value)
    : moved(std::move(value)) {}

FileSystemAccessChangeType::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kUnknown)>,
    FileSystemAccessChangeTypeUnknownPtr value)
    : unknown(std::move(value)) {}

void FileSystemAccessChangeType::DestroyActive() {
  switch (tag_) {

    case Tag::kAppeared:
      std::destroy_at(&data_.appeared);
      break;
    case Tag::kDisappeared:
      std::destroy_at(&data_.disappeared);
      break;
    case Tag::kErrored:
      std::destroy_at(&data_.errored);
      break;
    case Tag::kModified:
      std::destroy_at(&data_.modified);
      break;
    case Tag::kMoved:
      std::destroy_at(&data_.moved);
      break;
    case Tag::kUnknown:
      std::destroy_at(&data_.unknown);
      break;
  }
}

bool FileSystemAccessChangeType::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

FileSystemAccessObserver::IPCStableHashFunction FileSystemAccessObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FileSystemAccessObserver>(message.name())) {
    case messages::FileSystemAccessObserver::kOnFileChanges: {
      return &FileSystemAccessObserver::OnFileChanges_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FileSystemAccessObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FileSystemAccessObserver>(message.name())) {
      case messages::FileSystemAccessObserver::kOnFileChanges:
            return "Receive blink::mojom::FileSystemAccessObserver::OnFileChanges";
    }
  } else {
    switch (static_cast<messages::FileSystemAccessObserver>(message.name())) {
      case messages::FileSystemAccessObserver::kOnFileChanges:
            return "Receive reply blink::mojom::FileSystemAccessObserver::OnFileChanges";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FileSystemAccessObserver::OnFileChanges_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x25c9dac0;  // IPCStableHash for blink::mojom::FileSystemAccessObserver::OnFileChanges
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

FileSystemAccessObserverProxy::FileSystemAccessObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FileSystemAccessObserverProxy::OnFileChanges(
    std::vector<FileSystemAccessChangePtr> in_changes) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemAccessObserver::OnFileChanges", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("changes"), in_changes,
                        "<value of type std::vector<FileSystemAccessChangePtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessObserver::kOnFileChanges), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessObserver_OnFileChanges_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->changes)::BaseType>
      changes_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& changes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::FileSystemAccessChangeDataView>>(
    in_changes,
    changes_fragment,
    &changes_validate_params);

  params->changes.Set(
      changes_fragment.is_null() ? nullptr : changes_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->changes.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null changes in FileSystemAccessObserver.OnFileChanges request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessObserver::Name_);
  message.set_method_name("OnFileChanges");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool FileSystemAccessObserverStubDispatch::Accept(
    FileSystemAccessObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FileSystemAccessObserver>(message->header()->name)) {
    case messages::FileSystemAccessObserver::kOnFileChanges: {
      DCHECK(message->is_serialized());
      internal::FileSystemAccessObserver_OnFileChanges_Params_Data* params =
          reinterpret_cast<internal::FileSystemAccessObserver_OnFileChanges_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FileSystemAccessObserver.0
      bool success = true;
      std::vector<FileSystemAccessChangePtr> p_changes{};
      FileSystemAccessObserver_OnFileChanges_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadChanges(&p_changes))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFileChanges(        
        std::move(p_changes));
      return true;
    }
  }
  return false;
}

// static
bool FileSystemAccessObserverStubDispatch::AcceptWithResponder(
    FileSystemAccessObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FileSystemAccessObserver>(message->header()->name)) {
    case messages::FileSystemAccessObserver::kOnFileChanges: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFileSystemAccessObserverValidationInfo[] = {
    { &internal::FileSystemAccessObserver_OnFileChanges_Params_Data::Validate,
     nullptr /* no response */},
};

bool FileSystemAccessObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::FileSystemAccessObserver::Name_,
    kFileSystemAccessObserverValidationInfo);
}



}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::FileSystemAccessChangeTypeAppeared::DataView, ::blink::mojom::FileSystemAccessChangeTypeAppearedPtr>::Read(
    ::blink::mojom::FileSystemAccessChangeTypeAppeared::DataView input,
    ::blink::mojom::FileSystemAccessChangeTypeAppearedPtr* output) {
  bool success = true;
  ::blink::mojom::FileSystemAccessChangeTypeAppearedPtr result(::blink::mojom::FileSystemAccessChangeTypeAppeared::New());
  
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::FileSystemAccessChangeTypeDisappeared::DataView, ::blink::mojom::FileSystemAccessChangeTypeDisappearedPtr>::Read(
    ::blink::mojom::FileSystemAccessChangeTypeDisappeared::DataView input,
    ::blink::mojom::FileSystemAccessChangeTypeDisappearedPtr* output) {
  bool success = true;
  ::blink::mojom::FileSystemAccessChangeTypeDisappearedPtr result(::blink::mojom::FileSystemAccessChangeTypeDisappeared::New());
  
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::FileSystemAccessChangeTypeErrored::DataView, ::blink::mojom::FileSystemAccessChangeTypeErroredPtr>::Read(
    ::blink::mojom::FileSystemAccessChangeTypeErrored::DataView input,
    ::blink::mojom::FileSystemAccessChangeTypeErroredPtr* output) {
  bool success = true;
  ::blink::mojom::FileSystemAccessChangeTypeErroredPtr result(::blink::mojom::FileSystemAccessChangeTypeErrored::New());
  
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::FileSystemAccessChangeTypeModified::DataView, ::blink::mojom::FileSystemAccessChangeTypeModifiedPtr>::Read(
    ::blink::mojom::FileSystemAccessChangeTypeModified::DataView input,
    ::blink::mojom::FileSystemAccessChangeTypeModifiedPtr* output) {
  bool success = true;
  ::blink::mojom::FileSystemAccessChangeTypeModifiedPtr result(::blink::mojom::FileSystemAccessChangeTypeModified::New());
  
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::FileSystemAccessChangeTypeMoved::DataView, ::blink::mojom::FileSystemAccessChangeTypeMovedPtr>::Read(
    ::blink::mojom::FileSystemAccessChangeTypeMoved::DataView input,
    ::blink::mojom::FileSystemAccessChangeTypeMovedPtr* output) {
  bool success = true;
  ::blink::mojom::FileSystemAccessChangeTypeMovedPtr result(::blink::mojom::FileSystemAccessChangeTypeMoved::New());
  
      if (success && !input.ReadFormerRelativePath(&result->former_relative_path))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::FileSystemAccessChangeTypeUnknown::DataView, ::blink::mojom::FileSystemAccessChangeTypeUnknownPtr>::Read(
    ::blink::mojom::FileSystemAccessChangeTypeUnknown::DataView input,
    ::blink::mojom::FileSystemAccessChangeTypeUnknownPtr* output) {
  bool success = true;
  ::blink::mojom::FileSystemAccessChangeTypeUnknownPtr result(::blink::mojom::FileSystemAccessChangeTypeUnknown::New());
  
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::FileSystemAccessChangeMetadata::DataView, ::blink::mojom::FileSystemAccessChangeMetadataPtr>::Read(
    ::blink::mojom::FileSystemAccessChangeMetadata::DataView input,
    ::blink::mojom::FileSystemAccessChangeMetadataPtr* output) {
  bool success = true;
  ::blink::mojom::FileSystemAccessChangeMetadataPtr result(::blink::mojom::FileSystemAccessChangeMetadata::New());
  
      if (success && !input.ReadRoot(&result->root))
        success = false;
      if (success && !input.ReadChangedEntry(&result->changed_entry))
        success = false;
      if (success && !input.ReadRelativePath(&result->relative_path))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::FileSystemAccessChange::DataView, ::blink::mojom::FileSystemAccessChangePtr>::Read(
    ::blink::mojom::FileSystemAccessChange::DataView input,
    ::blink::mojom::FileSystemAccessChangePtr* output) {
  bool success = true;
  ::blink::mojom::FileSystemAccessChangePtr result(::blink::mojom::FileSystemAccessChange::New());
  
      if (success && !input.ReadMetadata(&result->metadata))
        success = false;
      if (success && !input.ReadType(&result->type))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::blink::mojom::FileSystemAccessChangeType::DataView, ::blink::mojom::FileSystemAccessChangeTypePtr>::Read(
    ::blink::mojom::FileSystemAccessChangeType::DataView input,
    ::blink::mojom::FileSystemAccessChangeTypePtr* output) {
  using UnionType = ::blink::mojom::FileSystemAccessChangeType;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kAppeared: {
      ::blink::mojom::FileSystemAccessChangeTypeAppearedPtr result_appeared{};
      if (!input.ReadAppeared(&result_appeared))
        return false;

      *output = UnionType::NewAppeared(
          std::move(result_appeared));
      break;
    }
    case Tag::kDisappeared: {
      ::blink::mojom::FileSystemAccessChangeTypeDisappearedPtr result_disappeared{};
      if (!input.ReadDisappeared(&result_disappeared))
        return false;

      *output = UnionType::NewDisappeared(
          std::move(result_disappeared));
      break;
    }
    case Tag::kErrored: {
      ::blink::mojom::FileSystemAccessChangeTypeErroredPtr result_errored{};
      if (!input.ReadErrored(&result_errored))
        return false;

      *output = UnionType::NewErrored(
          std::move(result_errored));
      break;
    }
    case Tag::kModified: {
      ::blink::mojom::FileSystemAccessChangeTypeModifiedPtr result_modified{};
      if (!input.ReadModified(&result_modified))
        return false;

      *output = UnionType::NewModified(
          std::move(result_modified));
      break;
    }
    case Tag::kMoved: {
      ::blink::mojom::FileSystemAccessChangeTypeMovedPtr result_moved{};
      if (!input.ReadMoved(&result_moved))
        return false;

      *output = UnionType::NewMoved(
          std::move(result_moved));
      break;
    }
    case Tag::kUnknown: {
      ::blink::mojom::FileSystemAccessChangeTypeUnknownPtr result_unknown{};
      if (!input.ReadUnknown(&result_unknown))
        return false;

      *output = UnionType::NewUnknown(
          std::move(result_unknown));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void FileSystemAccessObserverInterceptorForTesting::OnFileChanges(std::vector<FileSystemAccessChangePtr> changes) {
  GetForwardingInterface()->OnFileChanges(
    std::move(changes)
    );
}
FileSystemAccessObserverAsyncWaiter::FileSystemAccessObserverAsyncWaiter(
    FileSystemAccessObserver* proxy) : proxy_(proxy) {}

FileSystemAccessObserverAsyncWaiter::~FileSystemAccessObserverAsyncWaiter() = default;







}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif