// third_party/blink/public/mojom/file_system_access/file_system_access_file_writer.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  FileSystemAccessError as blink_mojom_FileSystemAccessError,
  FileSystemAccessErrorSpec as blink_mojom_FileSystemAccessErrorSpec
} from './file_system_access_error.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class FileSystemAccessFileWriterPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.FileSystemAccessFileWriter', scope);
  }
}

/** @interface */
export class FileSystemAccessFileWriterInterface {
  
  /**
   * @param { !bigint } offset
   * @param { !MojoHandle } stream
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        bytesWritten: !bigint,
   *  }>}
   */

  write(offset, stream) {}
  
  /**
   * @param { !bigint } length
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
   *  }>}
   */

  truncate(length) {}
  
  /**
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
   *  }>}
   */

  close() {}
  
  /**
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
   *  }>}
   */

  abort() {}
}

/**
 * @implements { FileSystemAccessFileWriterInterface }
 */
export class FileSystemAccessFileWriterRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!FileSystemAccessFileWriterPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          FileSystemAccessFileWriterPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!FileSystemAccessFileWriterPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !bigint } offset
   * @param { !MojoHandle } stream
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        bytesWritten: !bigint,
   *  }>}
   */

  write(
      offset,
      stream) {
    return this.proxy.sendMessage(
        0,
        FileSystemAccessFileWriter_Write_ParamsSpec.$,
        FileSystemAccessFileWriter_Write_ResponseParamsSpec.$,
        [
          offset,
          stream
        ],
        false);
  }

  
  /**
   * @param { !bigint } length
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
   *  }>}
   */

  truncate(
      length) {
    return this.proxy.sendMessage(
        1,
        FileSystemAccessFileWriter_Truncate_ParamsSpec.$,
        FileSystemAccessFileWriter_Truncate_ResponseParamsSpec.$,
        [
          length
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
   *  }>}
   */

  close() {
    return this.proxy.sendMessage(
        2,
        FileSystemAccessFileWriter_Close_ParamsSpec.$,
        FileSystemAccessFileWriter_Close_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
   *  }>}
   */

  abort() {
    return this.proxy.sendMessage(
        3,
        FileSystemAccessFileWriter_Abort_ParamsSpec.$,
        FileSystemAccessFileWriter_Abort_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the FileSystemAccessFileWriter
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class FileSystemAccessFileWriterReceiver {
  /**
   * @param {!FileSystemAccessFileWriterInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!FileSystemAccessFileWriterRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        FileSystemAccessFileWriterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FileSystemAccessFileWriterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        FileSystemAccessFileWriter_Write_ParamsSpec.$,
        FileSystemAccessFileWriter_Write_ResponseParamsSpec.$,
        impl.write.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        FileSystemAccessFileWriter_Truncate_ParamsSpec.$,
        FileSystemAccessFileWriter_Truncate_ResponseParamsSpec.$,
        impl.truncate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        FileSystemAccessFileWriter_Close_ParamsSpec.$,
        FileSystemAccessFileWriter_Close_ResponseParamsSpec.$,
        impl.close.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        FileSystemAccessFileWriter_Abort_ParamsSpec.$,
        FileSystemAccessFileWriter_Abort_ResponseParamsSpec.$,
        impl.abort.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class FileSystemAccessFileWriter {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FileSystemAccessFileWriter";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!FileSystemAccessFileWriterRemote}
   */
  static getRemote() {
    let remote = new FileSystemAccessFileWriterRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the FileSystemAccessFileWriter
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class FileSystemAccessFileWriterCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      FileSystemAccessFileWriterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FileSystemAccessFileWriterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.write =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        FileSystemAccessFileWriter_Write_ParamsSpec.$,
        FileSystemAccessFileWriter_Write_ResponseParamsSpec.$,
        this.write.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.truncate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        FileSystemAccessFileWriter_Truncate_ParamsSpec.$,
        FileSystemAccessFileWriter_Truncate_ResponseParamsSpec.$,
        this.truncate.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.close =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        FileSystemAccessFileWriter_Close_ParamsSpec.$,
        FileSystemAccessFileWriter_Close_ResponseParamsSpec.$,
        this.close.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.abort =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        FileSystemAccessFileWriter_Abort_ParamsSpec.$,
        FileSystemAccessFileWriter_Abort_ResponseParamsSpec.$,
        this.abort.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessFileWriter_Write_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessFileWriter_Write_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessFileWriter_Truncate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessFileWriter_Truncate_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessFileWriter_Close_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessFileWriter_Close_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessFileWriter_Abort_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessFileWriter_Abort_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    FileSystemAccessFileWriter_Write_ParamsSpec.$,
    'FileSystemAccessFileWriter_Write_Params',
    [
      mojo.internal.StructField(
        'offset', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'stream', 8,
        0,
        mojo.internal.Handle,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileSystemAccessFileWriter_Write_Params {
  constructor() {
    /** @type { !bigint } */
    this.offset;
    /** @type { !MojoHandle } */
    this.stream;
  }
}



mojo.internal.Struct(
    FileSystemAccessFileWriter_Write_ResponseParamsSpec.$,
    'FileSystemAccessFileWriter_Write_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink_mojom_FileSystemAccessErrorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'bytesWritten', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileSystemAccessFileWriter_Write_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessError } */
    this.result;
    /** @type { !bigint } */
    this.bytesWritten;
  }
}



mojo.internal.Struct(
    FileSystemAccessFileWriter_Truncate_ParamsSpec.$,
    'FileSystemAccessFileWriter_Truncate_Params',
    [
      mojo.internal.StructField(
        'length', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemAccessFileWriter_Truncate_Params {
  constructor() {
    /** @type { !bigint } */
    this.length;
  }
}



mojo.internal.Struct(
    FileSystemAccessFileWriter_Truncate_ResponseParamsSpec.$,
    'FileSystemAccessFileWriter_Truncate_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink_mojom_FileSystemAccessErrorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemAccessFileWriter_Truncate_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessError } */
    this.result;
  }
}



mojo.internal.Struct(
    FileSystemAccessFileWriter_Close_ParamsSpec.$,
    'FileSystemAccessFileWriter_Close_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FileSystemAccessFileWriter_Close_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    FileSystemAccessFileWriter_Close_ResponseParamsSpec.$,
    'FileSystemAccessFileWriter_Close_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink_mojom_FileSystemAccessErrorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemAccessFileWriter_Close_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessError } */
    this.result;
  }
}



mojo.internal.Struct(
    FileSystemAccessFileWriter_Abort_ParamsSpec.$,
    'FileSystemAccessFileWriter_Abort_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FileSystemAccessFileWriter_Abort_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    FileSystemAccessFileWriter_Abort_ResponseParamsSpec.$,
    'FileSystemAccessFileWriter_Abort_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink_mojom_FileSystemAccessErrorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemAccessFileWriter_Abort_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessError } */
    this.result;
  }
}

