// third_party/blink/public/mojom/file_system_access/file_system_access_file_handle.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_handle.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_handle.mojom-params-data.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_handle.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_handle.mojom-import-headers.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_handle.mojom-test-utils.h"


namespace blink::mojom {
FileSystemAccessRegularFile::FileSystemAccessRegularFile()
    : os_file(),
      file_size(),
      file_modification_host() {}

FileSystemAccessRegularFile::FileSystemAccessRegularFile(
    ::base::File os_file_in,
    int64_t file_size_in,
    ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileModificationHost> file_modification_host_in)
    : os_file(std::move(os_file_in)),
      file_size(std::move(file_size_in)),
      file_modification_host(std::move(file_modification_host_in)) {}

FileSystemAccessRegularFile::~FileSystemAccessRegularFile() = default;

void FileSystemAccessRegularFile::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "os_file"), this->os_file,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::File>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file_size"), this->file_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file_modification_host"), this->file_modification_host,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileModificationHost>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FileSystemAccessRegularFile::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FileSystemAccessAccessHandleFilePtr
FileSystemAccessAccessHandleFile::NewRegularFile(
    FileSystemAccessRegularFilePtr value) {
  return FileSystemAccessAccessHandleFilePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kRegularFile)>,
      std::move(value));
}

FileSystemAccessAccessHandleFilePtr
FileSystemAccessAccessHandleFile::NewIncognitoFileDelegate(
    ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileDelegateHost> value) {
  return FileSystemAccessAccessHandleFilePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kIncognitoFileDelegate)>,
      std::move(value));
}

FileSystemAccessAccessHandleFile::FileSystemAccessAccessHandleFile(
    std::in_place_index_t<static_cast<size_t>(Tag::kRegularFile)>,
    FileSystemAccessRegularFilePtr value)
    : tag_(Tag::kRegularFile),
      data_(std::in_place_index<static_cast<size_t>(Tag::kRegularFile)>,
            std::move(value)) {}

FileSystemAccessAccessHandleFile::FileSystemAccessAccessHandleFile(
    std::in_place_index_t<static_cast<size_t>(Tag::kIncognitoFileDelegate)>,
    ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileDelegateHost> value)
    : tag_(Tag::kIncognitoFileDelegate),
      data_(std::in_place_index<static_cast<size_t>(Tag::kIncognitoFileDelegate)>,
            std::move(value)) {}
FileSystemAccessAccessHandleFile::~FileSystemAccessAccessHandleFile() {
  DestroyActive();
}

void FileSystemAccessAccessHandleFile::set_regular_file(FileSystemAccessRegularFilePtr regular_file) {
  if (tag_ == Tag::kRegularFile) {
    data_.regular_file = std::move(regular_file);
  } else {
    DestroyActive();
    tag_ = Tag::kRegularFile;
    new (&data_.regular_file) FileSystemAccessRegularFilePtr(
        std::move(regular_file));
  }
}

void FileSystemAccessAccessHandleFile::set_incognito_file_delegate(::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileDelegateHost> incognito_file_delegate) {
  if (tag_ == Tag::kIncognitoFileDelegate) {
    data_.incognito_file_delegate = std::move(incognito_file_delegate);
  } else {
    DestroyActive();
    tag_ = Tag::kIncognitoFileDelegate;
    new (&data_.incognito_file_delegate) ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileDelegateHost>(
        std::move(incognito_file_delegate));
  }
}


FileSystemAccessAccessHandleFile::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kRegularFile)>,
    FileSystemAccessRegularFilePtr value)
    : regular_file(std::move(value)) {}

FileSystemAccessAccessHandleFile::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kIncognitoFileDelegate)>,
    ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileDelegateHost> value)
    : incognito_file_delegate(std::move(value)) {}

void FileSystemAccessAccessHandleFile::DestroyActive() {
  switch (tag_) {

    case Tag::kRegularFile:
      std::destroy_at(&data_.regular_file);
      break;
    case Tag::kIncognitoFileDelegate:
      std::destroy_at(&data_.incognito_file_delegate);
      break;
  }
}

bool FileSystemAccessAccessHandleFile::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

FileSystemAccessFileHandle::IPCStableHashFunction FileSystemAccessFileHandle::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FileSystemAccessFileHandle>(message.name())) {
    case messages::FileSystemAccessFileHandle::kGetPermissionStatus: {
      return &FileSystemAccessFileHandle::GetPermissionStatus_Sym::IPCStableHash;
    }
    case messages::FileSystemAccessFileHandle::kRequestPermission: {
      return &FileSystemAccessFileHandle::RequestPermission_Sym::IPCStableHash;
    }
    case messages::FileSystemAccessFileHandle::kAsBlob: {
      return &FileSystemAccessFileHandle::AsBlob_Sym::IPCStableHash;
    }
    case messages::FileSystemAccessFileHandle::kCreateFileWriter: {
      return &FileSystemAccessFileHandle::CreateFileWriter_Sym::IPCStableHash;
    }
    case messages::FileSystemAccessFileHandle::kRename: {
      return &FileSystemAccessFileHandle::Rename_Sym::IPCStableHash;
    }
    case messages::FileSystemAccessFileHandle::kMove: {
      return &FileSystemAccessFileHandle::Move_Sym::IPCStableHash;
    }
    case messages::FileSystemAccessFileHandle::kRemove: {
      return &FileSystemAccessFileHandle::Remove_Sym::IPCStableHash;
    }
    case messages::FileSystemAccessFileHandle::kOpenAccessHandle: {
      return &FileSystemAccessFileHandle::OpenAccessHandle_Sym::IPCStableHash;
    }
    case messages::FileSystemAccessFileHandle::kIsSameEntry: {
      return &FileSystemAccessFileHandle::IsSameEntry_Sym::IPCStableHash;
    }
    case messages::FileSystemAccessFileHandle::kTransfer: {
      return &FileSystemAccessFileHandle::Transfer_Sym::IPCStableHash;
    }
    case messages::FileSystemAccessFileHandle::kGetUniqueId: {
      return &FileSystemAccessFileHandle::GetUniqueId_Sym::IPCStableHash;
    }
    case messages::FileSystemAccessFileHandle::kGetCloudIdentifiers: {
      return &FileSystemAccessFileHandle::GetCloudIdentifiers_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FileSystemAccessFileHandle::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FileSystemAccessFileHandle>(message.name())) {
      case messages::FileSystemAccessFileHandle::kGetPermissionStatus:
            return "Receive blink::mojom::FileSystemAccessFileHandle::GetPermissionStatus";
      case messages::FileSystemAccessFileHandle::kRequestPermission:
            return "Receive blink::mojom::FileSystemAccessFileHandle::RequestPermission";
      case messages::FileSystemAccessFileHandle::kAsBlob:
            return "Receive blink::mojom::FileSystemAccessFileHandle::AsBlob";
      case messages::FileSystemAccessFileHandle::kCreateFileWriter:
            return "Receive blink::mojom::FileSystemAccessFileHandle::CreateFileWriter";
      case messages::FileSystemAccessFileHandle::kRename:
            return "Receive blink::mojom::FileSystemAccessFileHandle::Rename";
      case messages::FileSystemAccessFileHandle::kMove:
            return "Receive blink::mojom::FileSystemAccessFileHandle::Move";
      case messages::FileSystemAccessFileHandle::kRemove:
            return "Receive blink::mojom::FileSystemAccessFileHandle::Remove";
      case messages::FileSystemAccessFileHandle::kOpenAccessHandle:
            return "Receive blink::mojom::FileSystemAccessFileHandle::OpenAccessHandle";
      case messages::FileSystemAccessFileHandle::kIsSameEntry:
            return "Receive blink::mojom::FileSystemAccessFileHandle::IsSameEntry";
      case messages::FileSystemAccessFileHandle::kTransfer:
            return "Receive blink::mojom::FileSystemAccessFileHandle::Transfer";
      case messages::FileSystemAccessFileHandle::kGetUniqueId:
            return "Receive blink::mojom::FileSystemAccessFileHandle::GetUniqueId";
      case messages::FileSystemAccessFileHandle::kGetCloudIdentifiers:
            return "Receive blink::mojom::FileSystemAccessFileHandle::GetCloudIdentifiers";
    }
  } else {
    switch (static_cast<messages::FileSystemAccessFileHandle>(message.name())) {
      case messages::FileSystemAccessFileHandle::kGetPermissionStatus:
            return "Receive reply blink::mojom::FileSystemAccessFileHandle::GetPermissionStatus";
      case messages::FileSystemAccessFileHandle::kRequestPermission:
            return "Receive reply blink::mojom::FileSystemAccessFileHandle::RequestPermission";
      case messages::FileSystemAccessFileHandle::kAsBlob:
            return "Receive reply blink::mojom::FileSystemAccessFileHandle::AsBlob";
      case messages::FileSystemAccessFileHandle::kCreateFileWriter:
            return "Receive reply blink::mojom::FileSystemAccessFileHandle::CreateFileWriter";
      case messages::FileSystemAccessFileHandle::kRename:
            return "Receive reply blink::mojom::FileSystemAccessFileHandle::Rename";
      case messages::FileSystemAccessFileHandle::kMove:
            return "Receive reply blink::mojom::FileSystemAccessFileHandle::Move";
      case messages::FileSystemAccessFileHandle::kRemove:
            return "Receive reply blink::mojom::FileSystemAccessFileHandle::Remove";
      case messages::FileSystemAccessFileHandle::kOpenAccessHandle:
            return "Receive reply blink::mojom::FileSystemAccessFileHandle::OpenAccessHandle";
      case messages::FileSystemAccessFileHandle::kIsSameEntry:
            return "Receive reply blink::mojom::FileSystemAccessFileHandle::IsSameEntry";
      case messages::FileSystemAccessFileHandle::kTransfer:
            return "Receive reply blink::mojom::FileSystemAccessFileHandle::Transfer";
      case messages::FileSystemAccessFileHandle::kGetUniqueId:
            return "Receive reply blink::mojom::FileSystemAccessFileHandle::GetUniqueId";
      case messages::FileSystemAccessFileHandle::kGetCloudIdentifiers:
            return "Receive reply blink::mojom::FileSystemAccessFileHandle::GetCloudIdentifiers";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FileSystemAccessFileHandle::GetPermissionStatus_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x17f5df34;  // IPCStableHash for blink::mojom::FileSystemAccessFileHandle::GetPermissionStatus
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemAccessFileHandle::RequestPermission_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf5400d3b;  // IPCStableHash for blink::mojom::FileSystemAccessFileHandle::RequestPermission
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemAccessFileHandle::AsBlob_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7292ce07;  // IPCStableHash for blink::mojom::FileSystemAccessFileHandle::AsBlob
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemAccessFileHandle::CreateFileWriter_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x311de5e4;  // IPCStableHash for blink::mojom::FileSystemAccessFileHandle::CreateFileWriter
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemAccessFileHandle::Rename_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9b36d9d2;  // IPCStableHash for blink::mojom::FileSystemAccessFileHandle::Rename
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemAccessFileHandle::Move_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf4613d6c;  // IPCStableHash for blink::mojom::FileSystemAccessFileHandle::Move
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemAccessFileHandle::Remove_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa19df3d3;  // IPCStableHash for blink::mojom::FileSystemAccessFileHandle::Remove
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemAccessFileHandle::OpenAccessHandle_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcc3282cc;  // IPCStableHash for blink::mojom::FileSystemAccessFileHandle::OpenAccessHandle
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemAccessFileHandle::IsSameEntry_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe0d96b14;  // IPCStableHash for blink::mojom::FileSystemAccessFileHandle::IsSameEntry
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemAccessFileHandle::Transfer_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd5a56b23;  // IPCStableHash for blink::mojom::FileSystemAccessFileHandle::Transfer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemAccessFileHandle::GetUniqueId_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x878ebfaf;  // IPCStableHash for blink::mojom::FileSystemAccessFileHandle::GetUniqueId
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemAccessFileHandle::GetCloudIdentifiers_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf25b5aed;  // IPCStableHash for blink::mojom::FileSystemAccessFileHandle::GetCloudIdentifiers
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class FileSystemAccessFileHandle_GetPermissionStatus_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessFileHandle_GetPermissionStatus_ForwardToCallback(
      FileSystemAccessFileHandle::GetPermissionStatusCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemAccessFileHandle_GetPermissionStatus_ForwardToCallback(const FileSystemAccessFileHandle_GetPermissionStatus_ForwardToCallback&) = delete;
  FileSystemAccessFileHandle_GetPermissionStatus_ForwardToCallback& operator=(const FileSystemAccessFileHandle_GetPermissionStatus_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessFileHandle::GetPermissionStatusCallback callback_;
};

class FileSystemAccessFileHandle_RequestPermission_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessFileHandle_RequestPermission_ForwardToCallback(
      FileSystemAccessFileHandle::RequestPermissionCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemAccessFileHandle_RequestPermission_ForwardToCallback(const FileSystemAccessFileHandle_RequestPermission_ForwardToCallback&) = delete;
  FileSystemAccessFileHandle_RequestPermission_ForwardToCallback& operator=(const FileSystemAccessFileHandle_RequestPermission_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessFileHandle::RequestPermissionCallback callback_;
};

class FileSystemAccessFileHandle_AsBlob_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessFileHandle_AsBlob_ForwardToCallback(
      FileSystemAccessFileHandle::AsBlobCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemAccessFileHandle_AsBlob_ForwardToCallback(const FileSystemAccessFileHandle_AsBlob_ForwardToCallback&) = delete;
  FileSystemAccessFileHandle_AsBlob_ForwardToCallback& operator=(const FileSystemAccessFileHandle_AsBlob_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessFileHandle::AsBlobCallback callback_;
};

class FileSystemAccessFileHandle_CreateFileWriter_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessFileHandle_CreateFileWriter_ForwardToCallback(
      FileSystemAccessFileHandle::CreateFileWriterCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemAccessFileHandle_CreateFileWriter_ForwardToCallback(const FileSystemAccessFileHandle_CreateFileWriter_ForwardToCallback&) = delete;
  FileSystemAccessFileHandle_CreateFileWriter_ForwardToCallback& operator=(const FileSystemAccessFileHandle_CreateFileWriter_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessFileHandle::CreateFileWriterCallback callback_;
};

class FileSystemAccessFileHandle_Rename_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessFileHandle_Rename_ForwardToCallback(
      FileSystemAccessFileHandle::RenameCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemAccessFileHandle_Rename_ForwardToCallback(const FileSystemAccessFileHandle_Rename_ForwardToCallback&) = delete;
  FileSystemAccessFileHandle_Rename_ForwardToCallback& operator=(const FileSystemAccessFileHandle_Rename_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessFileHandle::RenameCallback callback_;
};

class FileSystemAccessFileHandle_Move_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessFileHandle_Move_ForwardToCallback(
      FileSystemAccessFileHandle::MoveCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemAccessFileHandle_Move_ForwardToCallback(const FileSystemAccessFileHandle_Move_ForwardToCallback&) = delete;
  FileSystemAccessFileHandle_Move_ForwardToCallback& operator=(const FileSystemAccessFileHandle_Move_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessFileHandle::MoveCallback callback_;
};

class FileSystemAccessFileHandle_Remove_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessFileHandle_Remove_ForwardToCallback(
      FileSystemAccessFileHandle::RemoveCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemAccessFileHandle_Remove_ForwardToCallback(const FileSystemAccessFileHandle_Remove_ForwardToCallback&) = delete;
  FileSystemAccessFileHandle_Remove_ForwardToCallback& operator=(const FileSystemAccessFileHandle_Remove_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessFileHandle::RemoveCallback callback_;
};

class FileSystemAccessFileHandle_OpenAccessHandle_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessFileHandle_OpenAccessHandle_ForwardToCallback(
      FileSystemAccessFileHandle::OpenAccessHandleCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemAccessFileHandle_OpenAccessHandle_ForwardToCallback(const FileSystemAccessFileHandle_OpenAccessHandle_ForwardToCallback&) = delete;
  FileSystemAccessFileHandle_OpenAccessHandle_ForwardToCallback& operator=(const FileSystemAccessFileHandle_OpenAccessHandle_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessFileHandle::OpenAccessHandleCallback callback_;
};

class FileSystemAccessFileHandle_IsSameEntry_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessFileHandle_IsSameEntry_ForwardToCallback(
      FileSystemAccessFileHandle::IsSameEntryCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemAccessFileHandle_IsSameEntry_ForwardToCallback(const FileSystemAccessFileHandle_IsSameEntry_ForwardToCallback&) = delete;
  FileSystemAccessFileHandle_IsSameEntry_ForwardToCallback& operator=(const FileSystemAccessFileHandle_IsSameEntry_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessFileHandle::IsSameEntryCallback callback_;
};

class FileSystemAccessFileHandle_GetUniqueId_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessFileHandle_GetUniqueId_ForwardToCallback(
      FileSystemAccessFileHandle::GetUniqueIdCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemAccessFileHandle_GetUniqueId_ForwardToCallback(const FileSystemAccessFileHandle_GetUniqueId_ForwardToCallback&) = delete;
  FileSystemAccessFileHandle_GetUniqueId_ForwardToCallback& operator=(const FileSystemAccessFileHandle_GetUniqueId_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessFileHandle::GetUniqueIdCallback callback_;
};

class FileSystemAccessFileHandle_GetCloudIdentifiers_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessFileHandle_GetCloudIdentifiers_ForwardToCallback(
      FileSystemAccessFileHandle::GetCloudIdentifiersCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemAccessFileHandle_GetCloudIdentifiers_ForwardToCallback(const FileSystemAccessFileHandle_GetCloudIdentifiers_ForwardToCallback&) = delete;
  FileSystemAccessFileHandle_GetCloudIdentifiers_ForwardToCallback& operator=(const FileSystemAccessFileHandle_GetCloudIdentifiers_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessFileHandle::GetCloudIdentifiersCallback callback_;
};

FileSystemAccessFileHandleProxy::FileSystemAccessFileHandleProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FileSystemAccessFileHandleProxy::GetPermissionStatus(
    ::blink::mojom::FileSystemAccessPermissionMode in_mode, GetPermissionStatusCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemAccessFileHandle::GetPermissionStatus", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mode"), in_mode,
                        "<value of type ::blink::mojom::FileSystemAccessPermissionMode>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileHandle::kGetPermissionStatus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileHandle_GetPermissionStatus_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessPermissionMode>(
    in_mode,
    &params->mode);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileHandle::Name_);
  message.set_method_name("GetPermissionStatus");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessFileHandle_GetPermissionStatus_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FileSystemAccessFileHandleProxy::RequestPermission(
    ::blink::mojom::FileSystemAccessPermissionMode in_mode, RequestPermissionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemAccessFileHandle::RequestPermission", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mode"), in_mode,
                        "<value of type ::blink::mojom::FileSystemAccessPermissionMode>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileHandle::kRequestPermission), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileHandle_RequestPermission_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessPermissionMode>(
    in_mode,
    &params->mode);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileHandle::Name_);
  message.set_method_name("RequestPermission");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessFileHandle_RequestPermission_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FileSystemAccessFileHandleProxy::AsBlob(
    AsBlobCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::FileSystemAccessFileHandle::AsBlob");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileHandle::kAsBlob), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileHandle_AsBlob_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileHandle::Name_);
  message.set_method_name("AsBlob");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessFileHandle_AsBlob_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FileSystemAccessFileHandleProxy::CreateFileWriter(
    bool in_keep_existing_data, bool in_auto_close, FileSystemAccessWritableFileStreamLockMode in_mode, CreateFileWriterCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemAccessFileHandle::CreateFileWriter", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("keep_existing_data"), in_keep_existing_data,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("auto_close"), in_auto_close,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mode"), in_mode,
                        "<value of type FileSystemAccessWritableFileStreamLockMode>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileHandle::kCreateFileWriter), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileHandle_CreateFileWriter_Params_Data> params(
          message);
  params.Allocate();

  params->keep_existing_data = in_keep_existing_data;

  params->auto_close = in_auto_close;

  
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessWritableFileStreamLockMode>(
    in_mode,
    &params->mode);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileHandle::Name_);
  message.set_method_name("CreateFileWriter");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessFileHandle_CreateFileWriter_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FileSystemAccessFileHandleProxy::Rename(
    const std::string& in_new_entry_name, RenameCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemAccessFileHandle::Rename", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_entry_name"), in_new_entry_name,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileHandle::kRename), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileHandle_Rename_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->new_entry_name)::BaseType> new_entry_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_new_entry_name,
    new_entry_name_fragment);

  params->new_entry_name.Set(
      new_entry_name_fragment.is_null() ? nullptr : new_entry_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->new_entry_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null new_entry_name in FileSystemAccessFileHandle.Rename request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileHandle::Name_);
  message.set_method_name("Rename");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessFileHandle_Rename_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FileSystemAccessFileHandleProxy::Move(
    ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> in_destination_directory, const std::string& in_new_entry_name, MoveCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemAccessFileHandle::Move", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("destination_directory"), in_destination_directory,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_entry_name"), in_new_entry_name,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileHandle::kMove), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileHandle_Move_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessTransferTokenInterfaceBase>>(
    in_destination_directory,
    &params->destination_directory,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->destination_directory)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid destination_directory in FileSystemAccessFileHandle.Move request");
  mojo::internal::MessageFragment<
      typename decltype(params->new_entry_name)::BaseType> new_entry_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_new_entry_name,
    new_entry_name_fragment);

  params->new_entry_name.Set(
      new_entry_name_fragment.is_null() ? nullptr : new_entry_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->new_entry_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null new_entry_name in FileSystemAccessFileHandle.Move request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileHandle::Name_);
  message.set_method_name("Move");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessFileHandle_Move_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FileSystemAccessFileHandleProxy::Remove(
    RemoveCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::FileSystemAccessFileHandle::Remove");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileHandle::kRemove), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileHandle_Remove_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileHandle::Name_);
  message.set_method_name("Remove");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessFileHandle_Remove_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FileSystemAccessFileHandleProxy::OpenAccessHandle(
    FileSystemAccessAccessHandleLockMode in_mode, OpenAccessHandleCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemAccessFileHandle::OpenAccessHandle", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mode"), in_mode,
                        "<value of type FileSystemAccessAccessHandleLockMode>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileHandle::kOpenAccessHandle), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileHandle_OpenAccessHandle_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessAccessHandleLockMode>(
    in_mode,
    &params->mode);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileHandle::Name_);
  message.set_method_name("OpenAccessHandle");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessFileHandle_OpenAccessHandle_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FileSystemAccessFileHandleProxy::IsSameEntry(
    ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> in_other, IsSameEntryCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemAccessFileHandle::IsSameEntry", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("other"), in_other,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileHandle::kIsSameEntry), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileHandle_IsSameEntry_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessTransferTokenInterfaceBase>>(
    in_other,
    &params->other,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->other)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid other in FileSystemAccessFileHandle.IsSameEntry request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileHandle::Name_);
  message.set_method_name("IsSameEntry");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessFileHandle_IsSameEntry_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FileSystemAccessFileHandleProxy::Transfer(
    ::mojo::PendingReceiver<::blink::mojom::FileSystemAccessTransferToken> in_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemAccessFileHandle::Transfer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::FileSystemAccessTransferToken>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileHandle::kTransfer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileHandle_Transfer_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::FileSystemAccessTransferTokenInterfaceBase>>(
    in_token,
    &params->token,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->token)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid token in FileSystemAccessFileHandle.Transfer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileHandle::Name_);
  message.set_method_name("Transfer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FileSystemAccessFileHandleProxy::GetUniqueId(
    GetUniqueIdCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::FileSystemAccessFileHandle::GetUniqueId");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileHandle::kGetUniqueId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileHandle_GetUniqueId_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileHandle::Name_);
  message.set_method_name("GetUniqueId");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessFileHandle_GetUniqueId_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FileSystemAccessFileHandleProxy::GetCloudIdentifiers(
    GetCloudIdentifiersCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::FileSystemAccessFileHandle::GetCloudIdentifiers");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileHandle::kGetCloudIdentifiers), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileHandle_GetCloudIdentifiers_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileHandle::Name_);
  message.set_method_name("GetCloudIdentifiers");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessFileHandle_GetCloudIdentifiers_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class FileSystemAccessFileHandle_GetPermissionStatus_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemAccessFileHandle::GetPermissionStatusCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemAccessFileHandle_GetPermissionStatus_ProxyToResponder> proxy(
        new FileSystemAccessFileHandle_GetPermissionStatus_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemAccessFileHandle_GetPermissionStatus_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessFileHandle_GetPermissionStatus_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemAccessFileHandle_GetPermissionStatus_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemAccessFileHandle::GetPermissionStatusCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::PermissionStatus in_status);
};

bool FileSystemAccessFileHandle_GetPermissionStatus_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemAccessFileHandle_GetPermissionStatus_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessFileHandle_GetPermissionStatus_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemAccessFileHandle.0
  bool success = true;
  ::blink::mojom::PermissionStatus p_status{};
  FileSystemAccessFileHandle_GetPermissionStatus_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessFileHandle::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void FileSystemAccessFileHandle_GetPermissionStatus_ProxyToResponder::Run(
    ::blink::mojom::PermissionStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemAccessFileHandle::GetPermissionStatus", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::PermissionStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileHandle::kGetPermissionStatus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileHandle_GetPermissionStatus_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::PermissionStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileHandle::Name_);
  message.set_method_name("GetPermissionStatus");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FileSystemAccessFileHandle_RequestPermission_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemAccessFileHandle::RequestPermissionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemAccessFileHandle_RequestPermission_ProxyToResponder> proxy(
        new FileSystemAccessFileHandle_RequestPermission_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemAccessFileHandle_RequestPermission_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessFileHandle_RequestPermission_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemAccessFileHandle_RequestPermission_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemAccessFileHandle::RequestPermissionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::FileSystemAccessErrorPtr in_result, ::blink::mojom::PermissionStatus in_status);
};

bool FileSystemAccessFileHandle_RequestPermission_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemAccessFileHandle_RequestPermission_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessFileHandle_RequestPermission_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemAccessFileHandle.1
  bool success = true;
  ::blink::mojom::FileSystemAccessErrorPtr p_result{};
  ::blink::mojom::PermissionStatus p_status{};
  FileSystemAccessFileHandle_RequestPermission_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessFileHandle::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_status));
  }
  return true;
}

void FileSystemAccessFileHandle_RequestPermission_ProxyToResponder::Run(
    ::blink::mojom::FileSystemAccessErrorPtr in_result, ::blink::mojom::PermissionStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemAccessFileHandle::RequestPermission", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::PermissionStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileHandle::kRequestPermission), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileHandle_RequestPermission_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

  
  mojo::internal::Serialize<::blink::mojom::PermissionStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileHandle::Name_);
  message.set_method_name("RequestPermission");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FileSystemAccessFileHandle_AsBlob_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemAccessFileHandle::AsBlobCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemAccessFileHandle_AsBlob_ProxyToResponder> proxy(
        new FileSystemAccessFileHandle_AsBlob_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemAccessFileHandle_AsBlob_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessFileHandle_AsBlob_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemAccessFileHandle_AsBlob_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemAccessFileHandle::AsBlobCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::FileSystemAccessErrorPtr in_result, const ::base::File::Info& in_info, ::blink::mojom::SerializedBlobPtr in_blob);
};

bool FileSystemAccessFileHandle_AsBlob_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemAccessFileHandle_AsBlob_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessFileHandle_AsBlob_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemAccessFileHandle.2
  bool success = true;
  ::blink::mojom::FileSystemAccessErrorPtr p_result{};
  ::base::File::Info p_info{};
  ::blink::mojom::SerializedBlobPtr p_blob{};
  FileSystemAccessFileHandle_AsBlob_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadInfo(&p_info))
    success = false;
  if (success && !input_data_view.ReadBlob(&p_blob))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessFileHandle::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_info), 
std::move(p_blob));
  }
  return true;
}

void FileSystemAccessFileHandle_AsBlob_ProxyToResponder::Run(
    ::blink::mojom::FileSystemAccessErrorPtr in_result, const ::base::File::Info& in_info, ::blink::mojom::SerializedBlobPtr in_blob) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemAccessFileHandle::AsBlob", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type const ::base::File::Info&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blob"), in_blob,
                        "<value of type ::blink::mojom::SerializedBlobPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileHandle::kAsBlob), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileHandle_AsBlob_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FileInfoDataView>(
    in_info,
    info_fragment);

  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null info in ");
  mojo::internal::MessageFragment<
      typename decltype(params->blob)::BaseType> blob_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::SerializedBlobDataView>(
    in_blob,
    blob_fragment);

  params->blob.Set(
      blob_fragment.is_null() ? nullptr : blob_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileHandle::Name_);
  message.set_method_name("AsBlob");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FileSystemAccessFileHandle_CreateFileWriter_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemAccessFileHandle::CreateFileWriterCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemAccessFileHandle_CreateFileWriter_ProxyToResponder> proxy(
        new FileSystemAccessFileHandle_CreateFileWriter_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemAccessFileHandle_CreateFileWriter_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessFileHandle_CreateFileWriter_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemAccessFileHandle_CreateFileWriter_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemAccessFileHandle::CreateFileWriterCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::FileSystemAccessErrorPtr in_result, ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileWriter> in_writer);
};

bool FileSystemAccessFileHandle_CreateFileWriter_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemAccessFileHandle_CreateFileWriter_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessFileHandle_CreateFileWriter_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemAccessFileHandle.3
  bool success = true;
  ::blink::mojom::FileSystemAccessErrorPtr p_result{};
  ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileWriter> p_writer{};
  FileSystemAccessFileHandle_CreateFileWriter_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success) {
    p_writer =
        input_data_view.TakeWriter<decltype(p_writer)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessFileHandle::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_writer));
  }
  return true;
}

void FileSystemAccessFileHandle_CreateFileWriter_ProxyToResponder::Run(
    ::blink::mojom::FileSystemAccessErrorPtr in_result, ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileWriter> in_writer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemAccessFileHandle::CreateFileWriter", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("writer"), in_writer,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileWriter>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileHandle::kCreateFileWriter), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileHandle_CreateFileWriter_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessFileWriterInterfaceBase>>(
    in_writer,
    &params->writer,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileHandle::Name_);
  message.set_method_name("CreateFileWriter");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FileSystemAccessFileHandle_Rename_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemAccessFileHandle::RenameCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemAccessFileHandle_Rename_ProxyToResponder> proxy(
        new FileSystemAccessFileHandle_Rename_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemAccessFileHandle_Rename_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessFileHandle_Rename_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemAccessFileHandle_Rename_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemAccessFileHandle::RenameCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::FileSystemAccessErrorPtr in_result);
};

bool FileSystemAccessFileHandle_Rename_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemAccessFileHandle_Rename_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessFileHandle_Rename_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemAccessFileHandle.4
  bool success = true;
  ::blink::mojom::FileSystemAccessErrorPtr p_result{};
  FileSystemAccessFileHandle_Rename_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessFileHandle::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void FileSystemAccessFileHandle_Rename_ProxyToResponder::Run(
    ::blink::mojom::FileSystemAccessErrorPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemAccessFileHandle::Rename", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileHandle::kRename), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileHandle_Rename_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileHandle::Name_);
  message.set_method_name("Rename");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FileSystemAccessFileHandle_Move_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemAccessFileHandle::MoveCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemAccessFileHandle_Move_ProxyToResponder> proxy(
        new FileSystemAccessFileHandle_Move_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemAccessFileHandle_Move_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessFileHandle_Move_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemAccessFileHandle_Move_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemAccessFileHandle::MoveCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::FileSystemAccessErrorPtr in_result);
};

bool FileSystemAccessFileHandle_Move_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemAccessFileHandle_Move_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessFileHandle_Move_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemAccessFileHandle.5
  bool success = true;
  ::blink::mojom::FileSystemAccessErrorPtr p_result{};
  FileSystemAccessFileHandle_Move_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessFileHandle::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void FileSystemAccessFileHandle_Move_ProxyToResponder::Run(
    ::blink::mojom::FileSystemAccessErrorPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemAccessFileHandle::Move", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileHandle::kMove), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileHandle_Move_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileHandle::Name_);
  message.set_method_name("Move");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FileSystemAccessFileHandle_Remove_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemAccessFileHandle::RemoveCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemAccessFileHandle_Remove_ProxyToResponder> proxy(
        new FileSystemAccessFileHandle_Remove_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemAccessFileHandle_Remove_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessFileHandle_Remove_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemAccessFileHandle_Remove_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemAccessFileHandle::RemoveCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::FileSystemAccessErrorPtr in_result);
};

bool FileSystemAccessFileHandle_Remove_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemAccessFileHandle_Remove_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessFileHandle_Remove_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemAccessFileHandle.6
  bool success = true;
  ::blink::mojom::FileSystemAccessErrorPtr p_result{};
  FileSystemAccessFileHandle_Remove_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessFileHandle::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void FileSystemAccessFileHandle_Remove_ProxyToResponder::Run(
    ::blink::mojom::FileSystemAccessErrorPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemAccessFileHandle::Remove", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileHandle::kRemove), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileHandle_Remove_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileHandle::Name_);
  message.set_method_name("Remove");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FileSystemAccessFileHandle_OpenAccessHandle_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemAccessFileHandle::OpenAccessHandleCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemAccessFileHandle_OpenAccessHandle_ProxyToResponder> proxy(
        new FileSystemAccessFileHandle_OpenAccessHandle_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemAccessFileHandle_OpenAccessHandle_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessFileHandle_OpenAccessHandle_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemAccessFileHandle_OpenAccessHandle_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemAccessFileHandle::OpenAccessHandleCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::FileSystemAccessErrorPtr in_result, FileSystemAccessAccessHandleFilePtr in_file, ::mojo::PendingRemote<::blink::mojom::FileSystemAccessAccessHandleHost> in_access_handle_host);
};

bool FileSystemAccessFileHandle_OpenAccessHandle_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemAccessFileHandle_OpenAccessHandle_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessFileHandle_OpenAccessHandle_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemAccessFileHandle.7
  bool success = true;
  ::blink::mojom::FileSystemAccessErrorPtr p_result{};
  FileSystemAccessAccessHandleFilePtr p_file{};
  ::mojo::PendingRemote<::blink::mojom::FileSystemAccessAccessHandleHost> p_access_handle_host{};
  FileSystemAccessFileHandle_OpenAccessHandle_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadFile(&p_file))
    success = false;
  if (success) {
    p_access_handle_host =
        input_data_view.TakeAccessHandleHost<decltype(p_access_handle_host)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessFileHandle::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_file), 
std::move(p_access_handle_host));
  }
  return true;
}

void FileSystemAccessFileHandle_OpenAccessHandle_ProxyToResponder::Run(
    ::blink::mojom::FileSystemAccessErrorPtr in_result, FileSystemAccessAccessHandleFilePtr in_file, ::mojo::PendingRemote<::blink::mojom::FileSystemAccessAccessHandleHost> in_access_handle_host) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemAccessFileHandle::OpenAccessHandle", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file"), in_file,
                        "<value of type FileSystemAccessAccessHandleFilePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("access_handle_host"), in_access_handle_host,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::FileSystemAccessAccessHandleHost>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileHandle::kOpenAccessHandle), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileHandle_OpenAccessHandle_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");
  mojo::internal::MessageFragment<decltype(params->file)>
      file_fragment(params.message());
  file_fragment.Claim(&params->file);
  
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessAccessHandleFileDataView>(
    in_file,
    file_fragment,
    true);

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessAccessHandleHostInterfaceBase>>(
    in_access_handle_host,
    &params->access_handle_host,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileHandle::Name_);
  message.set_method_name("OpenAccessHandle");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FileSystemAccessFileHandle_IsSameEntry_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemAccessFileHandle::IsSameEntryCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemAccessFileHandle_IsSameEntry_ProxyToResponder> proxy(
        new FileSystemAccessFileHandle_IsSameEntry_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemAccessFileHandle_IsSameEntry_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessFileHandle_IsSameEntry_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemAccessFileHandle_IsSameEntry_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemAccessFileHandle::IsSameEntryCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::FileSystemAccessErrorPtr in_result, bool in_is_same);
};

bool FileSystemAccessFileHandle_IsSameEntry_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemAccessFileHandle_IsSameEntry_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessFileHandle_IsSameEntry_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemAccessFileHandle.8
  bool success = true;
  ::blink::mojom::FileSystemAccessErrorPtr p_result{};
  bool p_is_same{};
  FileSystemAccessFileHandle_IsSameEntry_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success)
    p_is_same = input_data_view.is_same();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessFileHandle::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_is_same));
  }
  return true;
}

void FileSystemAccessFileHandle_IsSameEntry_ProxyToResponder::Run(
    ::blink::mojom::FileSystemAccessErrorPtr in_result, bool in_is_same) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemAccessFileHandle::IsSameEntry", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_same"), in_is_same,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileHandle::kIsSameEntry), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileHandle_IsSameEntry_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

  params->is_same = in_is_same;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileHandle::Name_);
  message.set_method_name("IsSameEntry");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FileSystemAccessFileHandle_GetUniqueId_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemAccessFileHandle::GetUniqueIdCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemAccessFileHandle_GetUniqueId_ProxyToResponder> proxy(
        new FileSystemAccessFileHandle_GetUniqueId_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemAccessFileHandle_GetUniqueId_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessFileHandle_GetUniqueId_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemAccessFileHandle_GetUniqueId_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemAccessFileHandle::GetUniqueIdCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::FileSystemAccessErrorPtr in_result, const std::string& in_id);
};

bool FileSystemAccessFileHandle_GetUniqueId_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemAccessFileHandle_GetUniqueId_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessFileHandle_GetUniqueId_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemAccessFileHandle.10
  bool success = true;
  ::blink::mojom::FileSystemAccessErrorPtr p_result{};
  std::string p_id{};
  FileSystemAccessFileHandle_GetUniqueId_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadId(&p_id))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessFileHandle::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_id));
  }
  return true;
}

void FileSystemAccessFileHandle_GetUniqueId_ProxyToResponder::Run(
    ::blink::mojom::FileSystemAccessErrorPtr in_result, const std::string& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemAccessFileHandle::GetUniqueId", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileHandle::kGetUniqueId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileHandle_GetUniqueId_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileHandle::Name_);
  message.set_method_name("GetUniqueId");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FileSystemAccessFileHandle_GetCloudIdentifiers_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemAccessFileHandle::GetCloudIdentifiersCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemAccessFileHandle_GetCloudIdentifiers_ProxyToResponder> proxy(
        new FileSystemAccessFileHandle_GetCloudIdentifiers_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemAccessFileHandle_GetCloudIdentifiers_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessFileHandle_GetCloudIdentifiers_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemAccessFileHandle_GetCloudIdentifiers_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemAccessFileHandle::GetCloudIdentifiersCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::FileSystemAccessErrorPtr in_result, std::vector<::blink::mojom::FileSystemAccessCloudIdentifierPtr> in_cloud_identifiers);
};

bool FileSystemAccessFileHandle_GetCloudIdentifiers_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemAccessFileHandle_GetCloudIdentifiers_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessFileHandle_GetCloudIdentifiers_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemAccessFileHandle.11
  bool success = true;
  ::blink::mojom::FileSystemAccessErrorPtr p_result{};
  std::vector<::blink::mojom::FileSystemAccessCloudIdentifierPtr> p_cloud_identifiers{};
  FileSystemAccessFileHandle_GetCloudIdentifiers_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadCloudIdentifiers(&p_cloud_identifiers))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessFileHandle::Name_, 11, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_cloud_identifiers));
  }
  return true;
}

void FileSystemAccessFileHandle_GetCloudIdentifiers_ProxyToResponder::Run(
    ::blink::mojom::FileSystemAccessErrorPtr in_result, std::vector<::blink::mojom::FileSystemAccessCloudIdentifierPtr> in_cloud_identifiers) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemAccessFileHandle::GetCloudIdentifiers", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cloud_identifiers"), in_cloud_identifiers,
                        "<value of type std::vector<::blink::mojom::FileSystemAccessCloudIdentifierPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileHandle::kGetCloudIdentifiers), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileHandle_GetCloudIdentifiers_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");
  mojo::internal::MessageFragment<
      typename decltype(params->cloud_identifiers)::BaseType>
      cloud_identifiers_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& cloud_identifiers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::FileSystemAccessCloudIdentifierDataView>>(
    in_cloud_identifiers,
    cloud_identifiers_fragment,
    &cloud_identifiers_validate_params);

  params->cloud_identifiers.Set(
      cloud_identifiers_fragment.is_null() ? nullptr : cloud_identifiers_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cloud_identifiers.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cloud_identifiers in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileHandle::Name_);
  message.set_method_name("GetCloudIdentifiers");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool FileSystemAccessFileHandleStubDispatch::Accept(
    FileSystemAccessFileHandle* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FileSystemAccessFileHandle>(message->header()->name)) {
    case messages::FileSystemAccessFileHandle::kGetPermissionStatus: {
      break;
    }
    case messages::FileSystemAccessFileHandle::kRequestPermission: {
      break;
    }
    case messages::FileSystemAccessFileHandle::kAsBlob: {
      break;
    }
    case messages::FileSystemAccessFileHandle::kCreateFileWriter: {
      break;
    }
    case messages::FileSystemAccessFileHandle::kRename: {
      break;
    }
    case messages::FileSystemAccessFileHandle::kMove: {
      break;
    }
    case messages::FileSystemAccessFileHandle::kRemove: {
      break;
    }
    case messages::FileSystemAccessFileHandle::kOpenAccessHandle: {
      break;
    }
    case messages::FileSystemAccessFileHandle::kIsSameEntry: {
      break;
    }
    case messages::FileSystemAccessFileHandle::kTransfer: {
      DCHECK(message->is_serialized());
      internal::FileSystemAccessFileHandle_Transfer_Params_Data* params =
          reinterpret_cast<internal::FileSystemAccessFileHandle_Transfer_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FileSystemAccessFileHandle.9
      bool success = true;
      ::mojo::PendingReceiver<::blink::mojom::FileSystemAccessTransferToken> p_token{};
      FileSystemAccessFileHandle_Transfer_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_token =
            input_data_view.TakeToken<decltype(p_token)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessFileHandle::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Transfer(        
        std::move(p_token));
      return true;
    }
    case messages::FileSystemAccessFileHandle::kGetUniqueId: {
      break;
    }
    case messages::FileSystemAccessFileHandle::kGetCloudIdentifiers: {
      break;
    }
  }
  return false;
}

// static
bool FileSystemAccessFileHandleStubDispatch::AcceptWithResponder(
    FileSystemAccessFileHandle* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FileSystemAccessFileHandle>(message->header()->name)) {
    case messages::FileSystemAccessFileHandle::kGetPermissionStatus: {
      internal::FileSystemAccessFileHandle_GetPermissionStatus_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessFileHandle_GetPermissionStatus_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemAccessFileHandle.0
      bool success = true;
      ::blink::mojom::FileSystemAccessPermissionMode p_mode{};
      FileSystemAccessFileHandle_GetPermissionStatus_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMode(&p_mode))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessFileHandle::Name_, 0, false);
        return false;
      }
      auto callback =
          FileSystemAccessFileHandle_GetPermissionStatus_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPermissionStatus(        
        std::move(p_mode), std::move(callback));
      return true;
    }
    case messages::FileSystemAccessFileHandle::kRequestPermission: {
      internal::FileSystemAccessFileHandle_RequestPermission_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessFileHandle_RequestPermission_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemAccessFileHandle.1
      bool success = true;
      ::blink::mojom::FileSystemAccessPermissionMode p_mode{};
      FileSystemAccessFileHandle_RequestPermission_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMode(&p_mode))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessFileHandle::Name_, 1, false);
        return false;
      }
      auto callback =
          FileSystemAccessFileHandle_RequestPermission_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestPermission(        
        std::move(p_mode), std::move(callback));
      return true;
    }
    case messages::FileSystemAccessFileHandle::kAsBlob: {
      internal::FileSystemAccessFileHandle_AsBlob_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessFileHandle_AsBlob_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemAccessFileHandle.2
      bool success = true;
      FileSystemAccessFileHandle_AsBlob_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessFileHandle::Name_, 2, false);
        return false;
      }
      auto callback =
          FileSystemAccessFileHandle_AsBlob_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AsBlob(std::move(callback));
      return true;
    }
    case messages::FileSystemAccessFileHandle::kCreateFileWriter: {
      internal::FileSystemAccessFileHandle_CreateFileWriter_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessFileHandle_CreateFileWriter_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemAccessFileHandle.3
      bool success = true;
      bool p_keep_existing_data{};
      bool p_auto_close{};
      FileSystemAccessWritableFileStreamLockMode p_mode{};
      FileSystemAccessFileHandle_CreateFileWriter_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_keep_existing_data = input_data_view.keep_existing_data();
      if (success)
        p_auto_close = input_data_view.auto_close();
      if (success && !input_data_view.ReadMode(&p_mode))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessFileHandle::Name_, 3, false);
        return false;
      }
      auto callback =
          FileSystemAccessFileHandle_CreateFileWriter_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateFileWriter(        
        std::move(p_keep_existing_data), 
        std::move(p_auto_close), 
        std::move(p_mode), std::move(callback));
      return true;
    }
    case messages::FileSystemAccessFileHandle::kRename: {
      internal::FileSystemAccessFileHandle_Rename_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessFileHandle_Rename_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemAccessFileHandle.4
      bool success = true;
      std::string p_new_entry_name{};
      FileSystemAccessFileHandle_Rename_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNewEntryName(&p_new_entry_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessFileHandle::Name_, 4, false);
        return false;
      }
      auto callback =
          FileSystemAccessFileHandle_Rename_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Rename(        
        std::move(p_new_entry_name), std::move(callback));
      return true;
    }
    case messages::FileSystemAccessFileHandle::kMove: {
      internal::FileSystemAccessFileHandle_Move_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessFileHandle_Move_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemAccessFileHandle.5
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> p_destination_directory{};
      std::string p_new_entry_name{};
      FileSystemAccessFileHandle_Move_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_destination_directory =
            input_data_view.TakeDestinationDirectory<decltype(p_destination_directory)>();
      }
      if (success && !input_data_view.ReadNewEntryName(&p_new_entry_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessFileHandle::Name_, 5, false);
        return false;
      }
      auto callback =
          FileSystemAccessFileHandle_Move_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Move(        
        std::move(p_destination_directory), 
        std::move(p_new_entry_name), std::move(callback));
      return true;
    }
    case messages::FileSystemAccessFileHandle::kRemove: {
      internal::FileSystemAccessFileHandle_Remove_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessFileHandle_Remove_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemAccessFileHandle.6
      bool success = true;
      FileSystemAccessFileHandle_Remove_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessFileHandle::Name_, 6, false);
        return false;
      }
      auto callback =
          FileSystemAccessFileHandle_Remove_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Remove(std::move(callback));
      return true;
    }
    case messages::FileSystemAccessFileHandle::kOpenAccessHandle: {
      internal::FileSystemAccessFileHandle_OpenAccessHandle_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessFileHandle_OpenAccessHandle_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemAccessFileHandle.7
      bool success = true;
      FileSystemAccessAccessHandleLockMode p_mode{};
      FileSystemAccessFileHandle_OpenAccessHandle_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMode(&p_mode))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessFileHandle::Name_, 7, false);
        return false;
      }
      auto callback =
          FileSystemAccessFileHandle_OpenAccessHandle_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenAccessHandle(        
        std::move(p_mode), std::move(callback));
      return true;
    }
    case messages::FileSystemAccessFileHandle::kIsSameEntry: {
      internal::FileSystemAccessFileHandle_IsSameEntry_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessFileHandle_IsSameEntry_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemAccessFileHandle.8
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> p_other{};
      FileSystemAccessFileHandle_IsSameEntry_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_other =
            input_data_view.TakeOther<decltype(p_other)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessFileHandle::Name_, 8, false);
        return false;
      }
      auto callback =
          FileSystemAccessFileHandle_IsSameEntry_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IsSameEntry(        
        std::move(p_other), std::move(callback));
      return true;
    }
    case messages::FileSystemAccessFileHandle::kTransfer: {
      break;
    }
    case messages::FileSystemAccessFileHandle::kGetUniqueId: {
      internal::FileSystemAccessFileHandle_GetUniqueId_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessFileHandle_GetUniqueId_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemAccessFileHandle.10
      bool success = true;
      FileSystemAccessFileHandle_GetUniqueId_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessFileHandle::Name_, 10, false);
        return false;
      }
      auto callback =
          FileSystemAccessFileHandle_GetUniqueId_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetUniqueId(std::move(callback));
      return true;
    }
    case messages::FileSystemAccessFileHandle::kGetCloudIdentifiers: {
      internal::FileSystemAccessFileHandle_GetCloudIdentifiers_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessFileHandle_GetCloudIdentifiers_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemAccessFileHandle.11
      bool success = true;
      FileSystemAccessFileHandle_GetCloudIdentifiers_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessFileHandle::Name_, 11, false);
        return false;
      }
      auto callback =
          FileSystemAccessFileHandle_GetCloudIdentifiers_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetCloudIdentifiers(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFileSystemAccessFileHandleValidationInfo[] = {
    { &internal::FileSystemAccessFileHandle_GetPermissionStatus_Params_Data::Validate,
     &internal::FileSystemAccessFileHandle_GetPermissionStatus_ResponseParams_Data::Validate},
    { &internal::FileSystemAccessFileHandle_RequestPermission_Params_Data::Validate,
     &internal::FileSystemAccessFileHandle_RequestPermission_ResponseParams_Data::Validate},
    { &internal::FileSystemAccessFileHandle_AsBlob_Params_Data::Validate,
     &internal::FileSystemAccessFileHandle_AsBlob_ResponseParams_Data::Validate},
    { &internal::FileSystemAccessFileHandle_CreateFileWriter_Params_Data::Validate,
     &internal::FileSystemAccessFileHandle_CreateFileWriter_ResponseParams_Data::Validate},
    { &internal::FileSystemAccessFileHandle_Rename_Params_Data::Validate,
     &internal::FileSystemAccessFileHandle_Rename_ResponseParams_Data::Validate},
    { &internal::FileSystemAccessFileHandle_Move_Params_Data::Validate,
     &internal::FileSystemAccessFileHandle_Move_ResponseParams_Data::Validate},
    { &internal::FileSystemAccessFileHandle_Remove_Params_Data::Validate,
     &internal::FileSystemAccessFileHandle_Remove_ResponseParams_Data::Validate},
    { &internal::FileSystemAccessFileHandle_OpenAccessHandle_Params_Data::Validate,
     &internal::FileSystemAccessFileHandle_OpenAccessHandle_ResponseParams_Data::Validate},
    { &internal::FileSystemAccessFileHandle_IsSameEntry_Params_Data::Validate,
     &internal::FileSystemAccessFileHandle_IsSameEntry_ResponseParams_Data::Validate},
    { &internal::FileSystemAccessFileHandle_Transfer_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FileSystemAccessFileHandle_GetUniqueId_Params_Data::Validate,
     &internal::FileSystemAccessFileHandle_GetUniqueId_ResponseParams_Data::Validate},
    { &internal::FileSystemAccessFileHandle_GetCloudIdentifiers_Params_Data::Validate,
     &internal::FileSystemAccessFileHandle_GetCloudIdentifiers_ResponseParams_Data::Validate},
};

bool FileSystemAccessFileHandleRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::FileSystemAccessFileHandle::Name_,
    kFileSystemAccessFileHandleValidationInfo);
}

bool FileSystemAccessFileHandleResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::FileSystemAccessFileHandle::Name_,
    kFileSystemAccessFileHandleValidationInfo);
}


}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::FileSystemAccessRegularFile::DataView, ::blink::mojom::FileSystemAccessRegularFilePtr>::Read(
    ::blink::mojom::FileSystemAccessRegularFile::DataView input,
    ::blink::mojom::FileSystemAccessRegularFilePtr* output) {
  bool success = true;
  ::blink::mojom::FileSystemAccessRegularFilePtr result(::blink::mojom::FileSystemAccessRegularFile::New());
  
      if (success && !input.ReadOsFile(&result->os_file))
        success = false;
      if (success)
        result->file_size = input.file_size();
      if (success) {
        result->file_modification_host =
            input.TakeFileModificationHost<decltype(result->file_modification_host)>();
      }
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::blink::mojom::FileSystemAccessAccessHandleFile::DataView, ::blink::mojom::FileSystemAccessAccessHandleFilePtr>::Read(
    ::blink::mojom::FileSystemAccessAccessHandleFile::DataView input,
    ::blink::mojom::FileSystemAccessAccessHandleFilePtr* output) {
  using UnionType = ::blink::mojom::FileSystemAccessAccessHandleFile;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kRegularFile: {
      ::blink::mojom::FileSystemAccessRegularFilePtr result_regular_file{};
      if (!input.ReadRegularFile(&result_regular_file))
        return false;

      *output = UnionType::NewRegularFile(
          std::move(result_regular_file));
      break;
    }
    case Tag::kIncognitoFileDelegate: {
      *output = UnionType::NewIncognitoFileDelegate(
          input.TakeIncognitoFileDelegate<::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileDelegateHost>>());
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void FileSystemAccessFileHandleInterceptorForTesting::GetPermissionStatus(::blink::mojom::FileSystemAccessPermissionMode mode, GetPermissionStatusCallback callback) {
  GetForwardingInterface()->GetPermissionStatus(
    std::move(mode)
    , std::move(callback));
}
void FileSystemAccessFileHandleInterceptorForTesting::RequestPermission(::blink::mojom::FileSystemAccessPermissionMode mode, RequestPermissionCallback callback) {
  GetForwardingInterface()->RequestPermission(
    std::move(mode)
    , std::move(callback));
}
void FileSystemAccessFileHandleInterceptorForTesting::AsBlob(AsBlobCallback callback) {
  GetForwardingInterface()->AsBlob(std::move(callback));
}
void FileSystemAccessFileHandleInterceptorForTesting::CreateFileWriter(bool keep_existing_data, bool auto_close, FileSystemAccessWritableFileStreamLockMode mode, CreateFileWriterCallback callback) {
  GetForwardingInterface()->CreateFileWriter(
    std::move(keep_existing_data)
    , 
    std::move(auto_close)
    , 
    std::move(mode)
    , std::move(callback));
}
void FileSystemAccessFileHandleInterceptorForTesting::Rename(const std::string& new_entry_name, RenameCallback callback) {
  GetForwardingInterface()->Rename(
    std::move(new_entry_name)
    , std::move(callback));
}
void FileSystemAccessFileHandleInterceptorForTesting::Move(::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> destination_directory, const std::string& new_entry_name, MoveCallback callback) {
  GetForwardingInterface()->Move(
    std::move(destination_directory)
    , 
    std::move(new_entry_name)
    , std::move(callback));
}
void FileSystemAccessFileHandleInterceptorForTesting::Remove(RemoveCallback callback) {
  GetForwardingInterface()->Remove(std::move(callback));
}
void FileSystemAccessFileHandleInterceptorForTesting::OpenAccessHandle(FileSystemAccessAccessHandleLockMode mode, OpenAccessHandleCallback callback) {
  GetForwardingInterface()->OpenAccessHandle(
    std::move(mode)
    , std::move(callback));
}
void FileSystemAccessFileHandleInterceptorForTesting::IsSameEntry(::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> other, IsSameEntryCallback callback) {
  GetForwardingInterface()->IsSameEntry(
    std::move(other)
    , std::move(callback));
}
void FileSystemAccessFileHandleInterceptorForTesting::Transfer(::mojo::PendingReceiver<::blink::mojom::FileSystemAccessTransferToken> token) {
  GetForwardingInterface()->Transfer(
    std::move(token)
    );
}
void FileSystemAccessFileHandleInterceptorForTesting::GetUniqueId(GetUniqueIdCallback callback) {
  GetForwardingInterface()->GetUniqueId(std::move(callback));
}
void FileSystemAccessFileHandleInterceptorForTesting::GetCloudIdentifiers(GetCloudIdentifiersCallback callback) {
  GetForwardingInterface()->GetCloudIdentifiers(std::move(callback));
}
FileSystemAccessFileHandleAsyncWaiter::FileSystemAccessFileHandleAsyncWaiter(
    FileSystemAccessFileHandle* proxy) : proxy_(proxy) {}

FileSystemAccessFileHandleAsyncWaiter::~FileSystemAccessFileHandleAsyncWaiter() = default;


void FileSystemAccessFileHandleAsyncWaiter::GetPermissionStatus(
    ::blink::mojom::FileSystemAccessPermissionMode mode, ::blink::mojom::PermissionStatus* out_status) {
  base::RunLoop loop;
  proxy_->GetPermissionStatus(
      std::move(mode),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::PermissionStatus* out_status
,
             ::blink::mojom::PermissionStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::blink::mojom::PermissionStatus FileSystemAccessFileHandleAsyncWaiter::GetPermissionStatus(
    ::blink::mojom::FileSystemAccessPermissionMode mode) {
  ::blink::mojom::PermissionStatus async_wait_result;
  GetPermissionStatus(std::move(mode),&async_wait_result);
  return async_wait_result;
}

void FileSystemAccessFileHandleAsyncWaiter::RequestPermission(
    ::blink::mojom::FileSystemAccessPermissionMode mode, ::blink::mojom::FileSystemAccessErrorPtr* out_result, ::blink::mojom::PermissionStatus* out_status) {
  base::RunLoop loop;
  proxy_->RequestPermission(
      std::move(mode),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::FileSystemAccessErrorPtr* out_result
,
             ::blink::mojom::PermissionStatus* out_status
,
             ::blink::mojom::FileSystemAccessErrorPtr result,
             ::blink::mojom::PermissionStatus status) {*out_result = std::move(result);*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_result,
          out_status));
  loop.Run();
}



void FileSystemAccessFileHandleAsyncWaiter::AsBlob(
    ::blink::mojom::FileSystemAccessErrorPtr* out_result, ::base::File::Info* out_info, ::blink::mojom::SerializedBlobPtr* out_blob) {
  base::RunLoop loop;
  proxy_->AsBlob(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::FileSystemAccessErrorPtr* out_result
,
             ::base::File::Info* out_info
,
             ::blink::mojom::SerializedBlobPtr* out_blob
,
             ::blink::mojom::FileSystemAccessErrorPtr result,
             const ::base::File::Info& info,
             ::blink::mojom::SerializedBlobPtr blob) {*out_result = std::move(result);*out_info = std::move(info);*out_blob = std::move(blob);
            loop->Quit();
          },
          &loop,
          out_result,
          out_info,
          out_blob));
  loop.Run();
}



void FileSystemAccessFileHandleAsyncWaiter::CreateFileWriter(
    bool keep_existing_data, bool auto_close, FileSystemAccessWritableFileStreamLockMode mode, ::blink::mojom::FileSystemAccessErrorPtr* out_result, ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileWriter>* out_writer) {
  base::RunLoop loop;
  proxy_->CreateFileWriter(
      std::move(keep_existing_data),
      std::move(auto_close),
      std::move(mode),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::FileSystemAccessErrorPtr* out_result
,
             ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileWriter>* out_writer
,
             ::blink::mojom::FileSystemAccessErrorPtr result,
             ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileWriter> writer) {*out_result = std::move(result);*out_writer = std::move(writer);
            loop->Quit();
          },
          &loop,
          out_result,
          out_writer));
  loop.Run();
}



void FileSystemAccessFileHandleAsyncWaiter::Rename(
    const std::string& new_entry_name, ::blink::mojom::FileSystemAccessErrorPtr* out_result) {
  base::RunLoop loop;
  proxy_->Rename(
      std::move(new_entry_name),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::FileSystemAccessErrorPtr* out_result
,
             ::blink::mojom::FileSystemAccessErrorPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

::blink::mojom::FileSystemAccessErrorPtr FileSystemAccessFileHandleAsyncWaiter::Rename(
    const std::string& new_entry_name) {
  ::blink::mojom::FileSystemAccessErrorPtr async_wait_result;
  Rename(std::move(new_entry_name),&async_wait_result);
  return async_wait_result;
}

void FileSystemAccessFileHandleAsyncWaiter::Move(
    ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> destination_directory, const std::string& new_entry_name, ::blink::mojom::FileSystemAccessErrorPtr* out_result) {
  base::RunLoop loop;
  proxy_->Move(
      std::move(destination_directory),
      std::move(new_entry_name),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::FileSystemAccessErrorPtr* out_result
,
             ::blink::mojom::FileSystemAccessErrorPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

::blink::mojom::FileSystemAccessErrorPtr FileSystemAccessFileHandleAsyncWaiter::Move(
    ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> destination_directory, const std::string& new_entry_name) {
  ::blink::mojom::FileSystemAccessErrorPtr async_wait_result;
  Move(std::move(destination_directory),std::move(new_entry_name),&async_wait_result);
  return async_wait_result;
}

void FileSystemAccessFileHandleAsyncWaiter::Remove(
    ::blink::mojom::FileSystemAccessErrorPtr* out_result) {
  base::RunLoop loop;
  proxy_->Remove(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::FileSystemAccessErrorPtr* out_result
,
             ::blink::mojom::FileSystemAccessErrorPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

::blink::mojom::FileSystemAccessErrorPtr FileSystemAccessFileHandleAsyncWaiter::Remove(
    ) {
  ::blink::mojom::FileSystemAccessErrorPtr async_wait_result;
  Remove(&async_wait_result);
  return async_wait_result;
}

void FileSystemAccessFileHandleAsyncWaiter::OpenAccessHandle(
    FileSystemAccessAccessHandleLockMode mode, ::blink::mojom::FileSystemAccessErrorPtr* out_result, FileSystemAccessAccessHandleFilePtr* out_file, ::mojo::PendingRemote<::blink::mojom::FileSystemAccessAccessHandleHost>* out_access_handle_host) {
  base::RunLoop loop;
  proxy_->OpenAccessHandle(
      std::move(mode),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::FileSystemAccessErrorPtr* out_result
,
             FileSystemAccessAccessHandleFilePtr* out_file
,
             ::mojo::PendingRemote<::blink::mojom::FileSystemAccessAccessHandleHost>* out_access_handle_host
,
             ::blink::mojom::FileSystemAccessErrorPtr result,
             FileSystemAccessAccessHandleFilePtr file,
             ::mojo::PendingRemote<::blink::mojom::FileSystemAccessAccessHandleHost> access_handle_host) {*out_result = std::move(result);*out_file = std::move(file);*out_access_handle_host = std::move(access_handle_host);
            loop->Quit();
          },
          &loop,
          out_result,
          out_file,
          out_access_handle_host));
  loop.Run();
}



void FileSystemAccessFileHandleAsyncWaiter::IsSameEntry(
    ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> other, ::blink::mojom::FileSystemAccessErrorPtr* out_result, bool* out_is_same) {
  base::RunLoop loop;
  proxy_->IsSameEntry(
      std::move(other),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::FileSystemAccessErrorPtr* out_result
,
             bool* out_is_same
,
             ::blink::mojom::FileSystemAccessErrorPtr result,
             bool is_same) {*out_result = std::move(result);*out_is_same = std::move(is_same);
            loop->Quit();
          },
          &loop,
          out_result,
          out_is_same));
  loop.Run();
}



void FileSystemAccessFileHandleAsyncWaiter::GetUniqueId(
    ::blink::mojom::FileSystemAccessErrorPtr* out_result, std::string* out_id) {
  base::RunLoop loop;
  proxy_->GetUniqueId(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::FileSystemAccessErrorPtr* out_result
,
             std::string* out_id
,
             ::blink::mojom::FileSystemAccessErrorPtr result,
             const std::string& id) {*out_result = std::move(result);*out_id = std::move(id);
            loop->Quit();
          },
          &loop,
          out_result,
          out_id));
  loop.Run();
}



void FileSystemAccessFileHandleAsyncWaiter::GetCloudIdentifiers(
    ::blink::mojom::FileSystemAccessErrorPtr* out_result, std::vector<::blink::mojom::FileSystemAccessCloudIdentifierPtr>* out_cloud_identifiers) {
  base::RunLoop loop;
  proxy_->GetCloudIdentifiers(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::FileSystemAccessErrorPtr* out_result
,
             std::vector<::blink::mojom::FileSystemAccessCloudIdentifierPtr>* out_cloud_identifiers
,
             ::blink::mojom::FileSystemAccessErrorPtr result,
             std::vector<::blink::mojom::FileSystemAccessCloudIdentifierPtr> cloud_identifiers) {*out_result = std::move(result);*out_cloud_identifiers = std::move(cloud_identifiers);
            loop->Quit();
          },
          &loop,
          out_result,
          out_cloud_identifiers));
  loop.Run();
}








}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif